/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.util;

import java.util.List;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.RatReport;

public class ClaimReporterMultiplexer
implements RatReport {
    private final IDocumentAnalyser analyser;
    private final List reporters;

    public ClaimReporterMultiplexer(IDocumentAnalyser pAnalyser, List reporters) {
        this.analyser = pAnalyser;
        this.reporters = reporters;
    }

    public void report(Document document) throws RatException {
        if (this.analyser != null) {
            try {
                this.analyser.analyse(document);
            }
            catch (RatDocumentAnalysisException e) {
                throw new RatException(e.getMessage(), e);
            }
        }
        int length = this.reporters.size();
        for (int i = 0; i < length; ++i) {
            RatReport report = (RatReport)this.reporters.get(i);
            report.report(document);
        }
    }

    public void startReport() throws RatException {
        int length = this.reporters.size();
        for (int i = 0; i < length; ++i) {
            RatReport report = (RatReport)this.reporters.get(i);
            report.startReport();
        }
    }

    public void endReport() throws RatException {
        int length = this.reporters.size();
        for (int i = 0; i < length; ++i) {
            RatReport report = (RatReport)this.reporters.get(i);
            report.endReport();
        }
    }
}

