/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.claim.impl.AbstractClaimReporter;

public class ClaimAggregator
extends AbstractClaimReporter {
    private final ClaimStatistic statistic;
    private final Map numsByLicenseFamilyName = new HashMap();
    private final Map numsByLicenseFamilyCode = new HashMap();
    private final Map numsByFileType = new HashMap();
    private int numApproved;
    private int numUnApproved;
    private int numGenerated;
    private int numUnknown;

    public ClaimAggregator(ClaimStatistic pStatistic) {
        this.statistic = pStatistic;
    }

    private void incMapValue(Map pMap, Object pKey) {
        Integer num = (Integer)pMap.get(pKey);
        int newNum = num == null ? 1 : num + 1;
        pMap.put(pKey, new Integer(newNum));
    }

    protected void handleDocumentCategoryClaim(String documentCategoryName) {
        this.incMapValue(this.numsByFileType, documentCategoryName);
    }

    protected void handleApprovedLicenseClaim(String licenseApproved) {
        if (MetaData.RAT_APPROVED_LICENSE_VALUE_TRUE.equals(licenseApproved)) {
            ++this.numApproved;
        } else {
            ++this.numUnApproved;
        }
    }

    protected void handleLicenseFamilyNameClaim(String licenseFamilyName) {
        this.incMapValue(this.numsByLicenseFamilyName, licenseFamilyName);
    }

    protected void handleHeaderCategoryClaim(String headerCategory) {
        if ("GEN  ".equals(headerCategory)) {
            ++this.numGenerated;
            this.incMapValue(this.numsByLicenseFamilyCode, "GEN  ");
        } else if ("?????".equals(headerCategory)) {
            ++this.numUnknown;
            this.incMapValue(this.numsByLicenseFamilyCode, "?????");
        }
    }

    public void fillClaimStatistic(ClaimStatistic pStatistic) {
        pStatistic.setDocumentCategoryMap(this.numsByFileType);
        pStatistic.setLicenseFileCodeMap(this.numsByLicenseFamilyCode);
        pStatistic.setLicenseFileNameMap(this.numsByLicenseFamilyName);
        pStatistic.setNumApproved(this.numApproved);
        pStatistic.setNumGenerated(this.numGenerated);
        pStatistic.setNumUnApproved(this.numUnApproved);
        pStatistic.setNumUnknown(this.numUnknown);
    }

    public void endReport() throws RatException {
        super.endReport();
        this.fillClaimStatistic(this.statistic);
    }
}

