/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import kafka.api.FetchRequest;
import kafka.api.OffsetRequest$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.perf.SimpleConsumerPerformance;
import kafka.perf.SimpleConsumerPerformance$;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class SimpleConsumerPerformance$
implements ScalaObject {
    public static final SimpleConsumerPerformance$ MODULE$;

    static {
        new SimpleConsumerPerformance$();
    }

    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        SimpleConsumerPerformance.ConsumerPerfConfig config = new SimpleConsumerPerformance.ConsumerPerfConfig(args);
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, fetch.size, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        SimpleConsumer consumer = new SimpleConsumer(config.url().getHost(), config.url().getPort(), 30000, 2 * config.fetchSize());
        long offset = config.fromLatest() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(consumer.getOffsetsBefore(config.topic(), config.partition(), OffsetRequest$.MODULE$.LatestTime(), 1)).head()) : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(consumer.getOffsetsBefore(config.topic(), config.partition(), OffsetRequest$.MODULE$.EarliestTime(), 1)).head());
        long startMs = System.currentTimeMillis();
        boolean done = false;
        long totalBytesRead = 0L;
        long totalMessagesRead = 0L;
        int consumedInterval = 0;
        long lastReportTime = startMs;
        long lastBytesRead = 0L;
        long lastMessagesRead = 0L;
        while (true) {
            if (done) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - startMs) / 1000.0;
                if (!config.showDetailedStats()) {
                    double totalMBRead = (double)totalBytesRead * 1.0 / (double)0x100000;
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config.dateFormat().format(BoxesRunTime.boxToLong((long)reportTime)), BoxesRunTime.boxToInteger((int)config.fetchSize()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsed)), BoxesRunTime.boxToLong((long)totalMessagesRead), BoxesRunTime.boxToDouble((double)((double)totalMessagesRead / elapsed))})));
                }
                System.exit(0);
                return;
            }
            ByteBufferMessageSet messages = consumer.fetch(new FetchRequest(config.topic(), config.partition(), offset, config.fetchSize()));
            IntRef messagesRead$1 = new IntRef(0);
            IntRef bytesRead$1 = new IntRef(0);
            messages.foreach((Function1)new anonfun.main.1(messagesRead$1, bytesRead$1));
            if (messagesRead$1.elem == 0 || totalMessagesRead > config.numMessages()) {
                done = true;
            } else {
                offset += messages.validBytes();
            }
            totalBytesRead += (long)bytesRead$1.elem;
            totalMessagesRead += (long)messagesRead$1.elem;
            if ((consumedInterval += messagesRead$1.elem) <= config.reportingInterval()) continue;
            if (config.showDetailedStats()) {
                long reportTime = System.currentTimeMillis();
                double elapsed = (double)(reportTime - lastReportTime) / 1000.0;
                double totalMBRead = (double)(totalBytesRead - lastBytesRead) * 1.0 / (double)0x100000;
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong((long)reportTime)), BoxesRunTime.boxToInteger((int)config.fetchSize()), BoxesRunTime.boxToDouble((double)((double)totalBytesRead * 1.0 / (double)0x100000)), BoxesRunTime.boxToDouble((double)(totalMBRead / elapsed)), BoxesRunTime.boxToLong((long)totalMessagesRead), BoxesRunTime.boxToDouble((double)((double)(totalMessagesRead - lastMessagesRead) / elapsed))})));
            }
            lastReportTime = SystemTime$.MODULE$.milliseconds();
            lastBytesRead = totalBytesRead;
            lastMessagesRead = totalMessagesRead;
            consumedInterval = 0;
        }
    }

    private SimpleConsumerPerformance$() {
        MODULE$ = this;
    }
}

