/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.perf.ProducerPerformance;
import kafka.perf.ProducerPerformance$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ProducerPerformance$
implements Logging,
ScalaObject {
    public static final ProducerPerformance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ProducerPerformance$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ProducerPerformance$ producerPerformance$ = this;
        synchronized (producerPerformance$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging.class.trace((Logging)this, (Function0)msg);
    }

    public Object trace(Function0 e) {
        return Logging.class.trace((Logging)this, (Function0)e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging.class.trace((Logging)this, (Function0)msg, (Function0)e);
    }

    public void debug(Function0 msg) {
        Logging.class.debug((Logging)this, (Function0)msg);
    }

    public Object debug(Function0 e) {
        return Logging.class.debug((Logging)this, (Function0)e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging.class.debug((Logging)this, (Function0)msg, (Function0)e);
    }

    public void info(Function0 msg) {
        Logging.class.info((Logging)this, (Function0)msg);
    }

    public Object info(Function0 e) {
        return Logging.class.info((Logging)this, (Function0)e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging.class.info((Logging)this, (Function0)msg, (Function0)e);
    }

    public void warn(Function0 msg) {
        Logging.class.warn((Logging)this, (Function0)msg);
    }

    public Object warn(Function0 e) {
        return Logging.class.warn((Logging)this, (Function0)e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging.class.warn((Logging)this, (Function0)msg, (Function0)e);
    }

    public void error(Function0 msg) {
        Logging.class.error((Logging)this, (Function0)msg);
    }

    public Object error(Function0 e) {
        return Logging.class.error((Logging)this, (Function0)e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging.class.error((Logging)this, (Function0)msg, (Function0)e);
    }

    public void fatal(Function0 msg) {
        Logging.class.fatal((Logging)this, (Function0)msg);
    }

    public Object fatal(Function0 e) {
        return Logging.class.fatal((Logging)this, (Function0)e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging.class.fatal((Logging)this, (Function0)msg, (Function0)e);
    }

    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        ProducerPerformance.ProducerPerfConfig config$1 = new ProducerPerformance.ProducerPerfConfig(args);
        if (!config$1.isFixSize()) {
            logger.info((Object)"WARN: Throughput will be slower due to changing message size per request");
        }
        AtomicLong totalBytesSent$1 = new AtomicLong(0L);
        AtomicLong totalMessagesSent$1 = new AtomicLong(0L);
        ExecutorService executor$1 = Executors.newFixedThreadPool(config$1.numThreads());
        CountDownLatch allDone$1 = new CountDownLatch(config$1.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand$1 = new Random();
        if (!config$1.hideHeader()) {
            if (config$1.showDetailedStats()) {
                Predef$.MODULE$.println((Object)"time, compression, thread.id, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println((Object)"start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
            }
        }
        Predef$.MODULE$.intWrapper(0).until(config$1.numThreads()).foreach$mVc$sp((Function1)new anonfun.main.1(config$1, totalBytesSent$1, totalMessagesSent$1, executor$1, allDone$1, rand$1));
        allDone$1.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        if (!config$1.showDetailedStats()) {
            double totalMBSent = (double)totalBytesSent$1.get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config$1.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config$1.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config$1.compressionCodec().codec()), BoxesRunTime.boxToInteger((int)config$1.messageSize()), BoxesRunTime.boxToInteger((int)config$1.batchSize()), BoxesRunTime.boxToDouble((double)totalMBSent), BoxesRunTime.boxToDouble((double)(totalMBSent / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesSent$1.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesSent$1.get() / elapsedSecs))})));
        }
        System.exit(0);
    }

    private String getStringOfLength(int len) {
        char[] strArray$1 = new char[len];
        Predef$.MODULE$.intWrapper(0).until(len).foreach$mVc$sp((Function1)new anonfun.getStringOfLength.1(strArray$1));
        return new String(strArray$1);
    }

    public final byte[] kafka$perf$ProducerPerformance$$getByteArrayOfLength(int len) {
        return new byte[len == 0 ? 5 : len];
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

