/*
 * Decompiled with CFR 0.152.
 */
package kafka.perf;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.Message;
import kafka.perf.ConsumerPerformance$;
import kafka.perf.ConsumerPerformance$ConsumerPerfConfig$;
import kafka.perf.ConsumerPerformance$ConsumerPerfThread$;
import kafka.perf.PerfConfig;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\tmq!B\u0001\u0003\u0011\u000b9\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0011\u0001XM\u001d4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!A\u0002\u0005\u000b\u0005\u0011\u0005\t\u0011#\u0002\f\u0005M\u0019uN\\:v[\u0016\u0014\b+\u001a:g_Jl\u0017M\\2f'\rIA\u0002\u0006\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\tY1kY1mC>\u0013'.Z2u\u0011\u0015Y\u0012\u0002\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u001f\u0013\t\u0007I\u0011B\u0010\u0002\r1|wmZ3s+\u0005\u0001\u0003CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0015awn\u001a\u001bk\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0012#A\u0002'pO\u001e,'\u000f\u0003\u0004,\u0013\u0001\u0006I\u0001I\u0001\bY><w-\u001a:!\u0011\u0015i\u0013\u0002\"\u0001/\u0003\u0011i\u0017-\u001b8\u0015\u0005=\u0012\u0004CA\u000b1\u0013\t\tdC\u0001\u0003V]&$\b\"B\u001a-\u0001\u0004!\u0014\u0001B1sON\u00042!F\u001b8\u0013\t1dCA\u0003BeJ\f\u0017\u0010\u0005\u00029w9\u0011Q#O\u0005\u0003uY\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!H\u0006\u0004\t\u007f%!\t\u0011!A\u0001\u0001\n\u00112i\u001c8tk6,'\u000fU3sM\u000e{gNZ5h'\rq\u0014\t\u0006\t\u0003\u0011\tK!a\u0011\u0002\u0003\u0015A+'OZ\"p]\u001aLw\r\u0003\u00054}\t\u0005\t\u0015!\u00035\u0011\u0015Yb\b\"\u0001G)\t9\u0015\n\u0005\u0002I}5\t\u0011\u0002C\u00034\u000b\u0002\u0007A\u0007C\u0004L}\t\u0007I\u0011\u0001'\u0002\u0019i\\7i\u001c8oK\u000e$x\n\u001d;\u0016\u00035\u00032AT)8\u001b\u0005y%\"\u0001)\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002S\u001f\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDa\u0001\u0016 !\u0002\u0013i\u0015!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005C\u0004W}\t\u0007I\u0011\u0001'\u0002\u0015\u001d\u0014x.\u001e9JI>\u0003H\u000f\u0003\u0004Y}\u0001\u0006I!T\u0001\fOJ|W\u000f]%e\u001fB$\b\u0005C\u0004[}\t\u0007I\u0011A.\u0002\u0019\u0019,Go\u00195TSj,w\n\u001d;\u0016\u0003q\u00032AT)^!\tia,\u0003\u0002`\u001d\t9\u0011J\u001c;fO\u0016\u0014\bBB1?A\u0003%A,A\u0007gKR\u001c\u0007nU5{K>\u0003H\u000f\t\u0005\bGz\u0012\r\u0011\"\u0001e\u0003]\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H/F\u0001f!\tqe-\u0003\u0002h\u001f\n\tr\n\u001d;j_:\u001c\u0006/Z2Ck&dG-\u001a:\t\r%t\u0004\u0015!\u0003f\u0003a\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H\u000f\t\u0005\bWz\u0012\r\u0011\"\u0001\\\u0003M\u0019xnY6fi\n+hMZ3s'&TXm\u00149u\u0011\u0019ig\b)A\u00059\u0006!2o\\2lKR\u0014UO\u001a4feNK'0Z(qi\u0002Bqa\u001c C\u0002\u0013\u00051,A\u0007ok6$\u0006N]3bIN|\u0005\u000f\u001e\u0005\u0007cz\u0002\u000b\u0011\u0002/\u0002\u001d9,X\u000e\u00165sK\u0006$7o\u00149uA!91O\u0010b\u0001\n\u0003!\u0018aB8qi&|gn]\u000b\u0002kB\u0011aJ^\u0005\u0003o>\u0013\u0011b\u00149uS>t7+\u001a;\t\ret\u0004\u0015!\u0003v\u0003!y\u0007\u000f^5p]N\u0004\u0003bB>?\u0005\u0004%\t\u0001`\u0001\u0006aJ|\u0007o]\u000b\u0002{B\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u0011\u0003\u0011)H/\u001b7\n\u0007\u0005\u0015qP\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0003?A\u0003%Q0\u0001\u0004qe>\u00048\u000f\t\u0005\n\u0003\u001bq$\u0019!C\u0001\u0003\u001f\tabY8ogVlWM]\"p]\u001aLw-\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\u0011\t\u0001bY8ogVlWM]\u0005\u0005\u00037\t)B\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011\u0005}a\b)A\u0005\u0003#\tqbY8ogVlWM]\"p]\u001aLw\r\t\u0005\n\u0003Gq$\u0019!C\u0001\u0003K\t!B\\;n)\"\u0014X-\u00193t+\t\t9\u0003E\u0002\u0016\u0003SI1!a\u000b\u0017\u0005\rIe\u000e\u001e\u0005\t\u0003_q\u0004\u0015!\u0003\u0002(\u0005Ya.^7UQJ,\u0017\rZ:!\u0011%\t\u0019D\u0010b\u0001\n\u0003\t)$A\u0003u_BL7-F\u00018\u0011\u001d\tID\u0010Q\u0001\n]\na\u0001^8qS\u000e\u0004\u0003\"CA\u001f}\t\u0007I\u0011AA \u0003-qW/\\'fgN\fw-Z:\u0016\u0005\u0005\u0005\u0003cA\u000b\u0002D%\u0019\u0011Q\t\f\u0003\t1{gn\u001a\u0005\t\u0003\u0013r\u0004\u0015!\u0003\u0002B\u0005aa.^7NKN\u001c\u0018mZ3tA!I\u0011Q\n C\u0002\u0013\u0005\u0011QE\u0001\u0012e\u0016\u0004xN\u001d;j]\u001eLe\u000e^3sm\u0006d\u0007\u0002CA)}\u0001\u0006I!a\n\u0002%I,\u0007o\u001c:uS:<\u0017J\u001c;feZ\fG\u000e\t\u0005\n\u0003+r$\u0019!C\u0001\u0003/\n\u0011c\u001d5po\u0012+G/Y5mK\u0012\u001cF/\u0019;t+\t\tI\u0006E\u0002\u0016\u00037J1!!\u0018\u0017\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0019?A\u0003%\u0011\u0011L\u0001\u0013g\"|w\u000fR3uC&dW\rZ*uCR\u001c\b\u0005C\u0005\u0002fy\u0012\r\u0011\"\u0001\u0002h\u0005QA-\u0019;f\r>\u0014X.\u0019;\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=\u0004#\u0001\u0003uKb$\u0018\u0002BA:\u0003[\u0012\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\t\u0011\u0005]d\b)A\u0005\u0003S\n1\u0002Z1uK\u001a{'/\\1uA!I\u00111\u0010 C\u0002\u0013\u0005\u0011qK\u0001\u000bQ&$W\rS3bI\u0016\u0014\b\u0002CA@}\u0001\u0006I!!\u0017\u0002\u0017!LG-\u001a%fC\u0012,'\u000f\t\u0004\u000b\u0003\u0007KA\u0011!A\u0001\u0002\u0005\u0015%AE\"p]N,X.\u001a:QKJ4G\u000b\u001b:fC\u0012\u001cR!!!\u0002\bR\u00012!DAE\u0013\r\tYI\u0004\u0002\u0007)\"\u0014X-\u00193\t\u0017\u0005=\u0015\u0011\u0011B\u0001B\u0003%\u0011qE\u0001\ti\"\u0014X-\u00193JI\"Q\u00111SAA\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\t9\fW.\u001a\u0005\f\u0003/\u000b\tI!A!\u0002\u0013\tI*\u0001\u0004tiJ,\u0017-\u001c\t\u0007\u0003'\tY*a(\n\t\u0005u\u0015Q\u0003\u0002\f\u0017\u000647.Y*ue\u0016\fW\u000e\u0005\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)\u000bB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\tI+a)\u0003\u000f5+7o]1hK\"Q\u0011QVAA\u0005\u0003\u0005\u000b\u0011B$\u0002\r\r|gNZ5h\u0011-\t\t,!!\u0003\u0002\u0003\u0006I!a-\u0002#Q|G/\u00197NKN\u001c\u0018mZ3t%\u0016\fG\r\u0005\u0003\u00026\u0006}VBAA\\\u0015\u0011\tI,a/\u0002\r\u0005$x.\\5d\u0015\r\til`\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAa\u0003o\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011-\t)-!!\u0003\u0002\u0003\u0006I!a-\u0002\u001dQ|G/\u00197CsR,7OU3bI\"91$!!\u0005\u0002\u0005%GCDAf\u0003\u001b\fy-!5\u0002T\u0006U\u0017q\u001b\t\u0004\u0011\u0006\u0005\u0005\u0002CAH\u0003\u000f\u0004\r!a\n\t\u000f\u0005M\u0015q\u0019a\u0001o!A\u0011qSAd\u0001\u0004\tI\nC\u0004\u0002.\u0006\u001d\u0007\u0019A$\t\u0011\u0005E\u0016q\u0019a\u0001\u0003gC\u0001\"!2\u0002H\u0002\u0007\u00111\u0017\u0005\u000b\u00037\f\tI1A\u0005\n\u0005u\u0017!D:ikR$wn\u001e8MCR\u001c\u0007.\u0006\u0002\u0002`B!\u0011\u0011]Ar\u001b\t\tY,\u0003\u0003\u0002f\u0006m&AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\n\u0003S\f\t\t)A\u0005\u0003?\fab\u001d5vi\u0012|wO\u001c'bi\u000eD\u0007\u0005\u0003\u0005\u0002n\u0006\u0005E\u0011AAx\u0003!\u0019\b.\u001e;e_^tG#A\u0018\t\u0011\u0005M\u0018\u0011\u0011C!\u0003_\f1A];o\u0011!\t90!!\u0005\n\u0005e\u0018\u0001\u00049sS:$X*Z:tC\u001e,GcD\u0018\u0002|\u0006}(1\u0001B\u0004\u0005\u0017\u0011yAa\u0005\t\u0011\u0005u\u0018Q\u001fa\u0001\u0003O\t!!\u001b3\t\u0011\t\u0005\u0011Q\u001fa\u0001\u0003\u0003\n\u0011BY=uKN\u0014V-\u00193\t\u0011\t\u0015\u0011Q\u001fa\u0001\u0003\u0003\nQ\u0002\\1ti\nKH/Z:SK\u0006$\u0007\u0002\u0003B\u0005\u0003k\u0004\r!!\u0011\u0002\u00195,7o]1hKN\u0014V-\u00193\t\u0011\t5\u0011Q\u001fa\u0001\u0003\u0003\n\u0001\u0003\\1ti6+7o]1hKN\u0014V-\u00193\t\u0011\tE\u0011Q\u001fa\u0001\u0003\u0003\nqa\u001d;beRl5\u000f\u0003\u0005\u0003\u0016\u0005U\b\u0019AA!\u0003\u0015)g\u000eZ't\u0011!\u0011I\"!!\u0005\n\u0005=\u0018\u0001E:ikR$wn\u001e8D_6\u0004H.\u001a;f\u0001")
public final class ConsumerPerformance {
    public static final void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfThread
    extends Thread
    implements ScalaObject {
        public final int kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId;
        private final KafkaStream<Message> stream;
        public final ConsumerPerfConfig kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final CountDownLatch shutdownLatch;

        private CountDownLatch shutdownLatch() {
            return this.shutdownLatch;
        }

        public void shutdown() {
            this.shutdownLatch().await();
        }

        @Override
        public void run() {
            LongRef bytesRead$1 = new LongRef(0L);
            LongRef messagesRead$1 = new LongRef(0L);
            long startMs = System.currentTimeMillis();
            LongRef lastReportTime$1 = new LongRef(startMs);
            LongRef lastBytesRead$1 = new LongRef(0L);
            LongRef lastMessagesRead$1 = new LongRef(0L);
            try {
                this.stream.withFilter((Function1)new ConsumerPerfThread$$anonfun$run$1(this, messagesRead$1)).foreach((Function1)new ConsumerPerfThread$$anonfun$run$2(this, bytesRead$1, messagesRead$1, lastReportTime$1, lastBytesRead$1, lastMessagesRead$1));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead$1.elem);
            this.totalBytesRead.addAndGet(bytesRead$1.elem);
            if (this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.showDetailedStats()) {
                this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$printMessage(this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId, bytesRead$1.elem, lastBytesRead$1.elem, messagesRead$1.elem, lastMessagesRead$1.elem, startMs, System.currentTimeMillis());
            }
            this.shutdownComplete();
        }

        public final void kafka$perf$ConsumerPerformance$ConsumerPerfThread$$printMessage(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs) {
            long elapsedMs = endMs - startMs;
            double totalMBRead = (double)bytesRead * 1.0 / (double)0x100000;
            double mbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %d, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToInteger((int)this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config.consumerConfig().fetchSize()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(1000.0 * (mbRead / (double)elapsedMs))), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)((double)((messagesRead - lastMessagesRead) / elapsedMs) * 1000.0))})));
        }

        private void shutdownComplete() {
            this.shutdownLatch().countDown();
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<Message> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead) {
            this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$threadId = threadId;
            this.stream = stream;
            this.kafka$perf$ConsumerPerformance$ConsumerPerfThread$$config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            super(name);
            this.shutdownLatch = new CountDownLatch(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfConfig
    extends PerfConfig
    implements ScalaObject {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final OptionSet options;
        private final Properties props;
        private final ConsumerConfig consumerConfig;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Properties props() {
            return this.props;
        }

        public ConsumerConfig consumerConfig() {
            return this.consumerConfig;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            this.options = this.parser().parse(args);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{this.topicOpt(), this.zkConnectOpt()})).foreach((Function1)new ConsumerPerfConfig$$anonfun$1(this));
            this.props = new Properties();
            this.props().put("groupid", this.options().valueOf(this.groupIdOpt()));
            this.props().put("socket.buffer.size", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
            this.props().put("fetch.size", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
            this.props().put("autooffset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
            this.props().put("zk.connect", this.options().valueOf(this.zkConnectOpt()));
            this.props().put("consumer.timeout.ms", "5000");
            this.consumerConfig = new ConsumerConfig(this.props());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }
}

