/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;
import org.apache.pig.LoadFunc;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.partition.PathPartitioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPartitionHelper {
    public static final String PARTITION_COLUMNS = PathPartitionHelper.class + ".partition-columns";
    public static final String PARITITION_FILTER_EXPRESSION = PathPartitionHelper.class.getName() + ".partition-filter";
    private static final Logger LOG = Logger.getLogger(PathPartitionHelper.class);
    transient PathPartitioner pathPartitioner = new PathPartitioner();

    public Map<String, String> getPathPartitionKeyValues(String location) throws IOException {
        return this.pathPartitioner.getPathPartitionKeyValues(location);
    }

    public Set<String> getPartitionKeys(String location, Configuration conf) throws IOException {
        return this.pathPartitioner.getPartitionKeys(location, conf);
    }

    public void setPartitionFilterExpression(String partitionFilterExpression, Class<? extends LoadFunc> loaderClass, String signature) throws IOException {
        UDFContext.getUDFContext().getUDFProperties(loaderClass, new String[]{signature}).setProperty(PARITITION_FILTER_EXPRESSION, partitionFilterExpression);
    }

    public void setPartitionKeys(String location, Configuration conf, Class<? extends LoadFunc> loaderClass, String signature) throws IOException {
        Set<String> partitionKeys = this.getPartitionKeys(location, conf);
        if (partitionKeys != null) {
            StringBuilder buff = new StringBuilder();
            int i = 0;
            for (String key : partitionKeys) {
                if (i++ != 0) {
                    buff.append(",");
                }
                buff.append(key);
            }
            UDFContext.getUDFContext().getUDFProperties(loaderClass, new String[]{signature}).setProperty(PARTITION_COLUMNS, buff.toString());
        }
    }

    public List<FileStatus> listStatus(JobContext ctx, Class<? extends LoadFunc> loaderClass, String signature) throws IOException {
        String partitionColumnStr;
        Properties properties = UDFContext.getUDFContext().getUDFProperties(loaderClass, new String[]{signature});
        String partitionExpression = properties.getProperty(PARITITION_FILTER_EXPRESSION);
        ExpressionFactory expressionFactory = null;
        if (partitionExpression != null) {
            expressionFactory = ExpressionFactory.newInstance();
        }
        String[] partitionKeys = (partitionColumnStr = properties.getProperty(PARTITION_COLUMNS)) == null ? null : partitionColumnStr.split(",");
        Path[] inputPaths = FileInputFormat.getInputPaths((JobContext)ctx);
        ArrayList<FileStatus> splitPaths = null;
        if (partitionKeys != null) {
            splitPaths = new ArrayList<FileStatus>();
            for (Path inputPath : inputPaths) {
                FileSystem fs = inputPath.getFileSystem(ctx.getConfiguration());
                if (fs.getFileStatus(inputPath).isDir()) {
                    FileStatus[] fileStatusArr = fs.listStatus(inputPath);
                    if (fileStatusArr == null) continue;
                    for (FileStatus childFileStatus : fileStatusArr) {
                        this.getPartitionedFiles(expressionFactory, partitionExpression, fs, childFileStatus, 0, partitionKeys, splitPaths);
                    }
                    continue;
                }
                splitPaths.add(fs.getFileStatus(inputPath));
            }
            if (splitPaths.size() < 1) {
                LOG.error((Object)"Not split paths where found, please check that the filter logic for the partition keys does not filter out everything ");
            }
        }
        return splitPaths;
    }

    private void getPartitionedFiles(ExpressionFactory expressionFactory, String partitionExpression, FileSystem fs, FileStatus fileStatus, int partitionLevel, String[] partitionKeys, List<FileStatus> splitPaths) throws IOException {
        String partition = partitionLevel < partitionKeys.length ? partitionKeys[partitionLevel] : null;
        Path path = fileStatus.getPath();
        if (path.getName().startsWith("_")) {
            return;
        }
        if (partition != null) {
            if (fileStatus.isDir()) {
                if (!path.getName().startsWith(partition)) {
                    return;
                }
            } else {
                return;
            }
            if (partitionLevel == partitionKeys.length - 1 && !this.evaluatePartitionExpression(expressionFactory, partitionExpression, path)) {
                LOG.debug((Object)("Pruning partition: " + path));
                return;
            }
        }
        int nextPartitionLevel = partitionLevel + 1;
        FileStatus[] childStatusArr = null;
        if (fileStatus.isDir()) {
            childStatusArr = fs.listStatus(path);
            if (childStatusArr != null) {
                for (FileStatus childFileStatus : childStatusArr) {
                    this.getPartitionedFiles(expressionFactory, partitionExpression, fs, childFileStatus, nextPartitionLevel, partitionKeys, splitPaths);
                }
            }
        } else {
            splitPaths.add(fileStatus);
        }
    }

    private boolean evaluatePartitionExpression(ExpressionFactory expressionFactory, String partitionExpression, Path path) throws IOException {
        boolean ret = true;
        if (expressionFactory != null) {
            if (!partitionExpression.startsWith("${")) {
                partitionExpression = "${" + partitionExpression + "}";
            }
            Map<String, String> context = this.pathPartitioner.getPathPartitionKeyValues(path.toString());
            MapVariableMapper mapper = new MapVariableMapper(expressionFactory, context);
            VariableContext varContext = new VariableContext(mapper);
            ValueExpression evalExpression = expressionFactory.createValueExpression((ELContext)varContext, partitionExpression, Boolean.class);
            ret = (Boolean)evalExpression.getValue((ELContext)varContext);
            LOG.debug((Object)("Evaluated: " + partitionExpression + " returned: " + ret));
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapVariableMapper
    extends VariableMapper {
        private Map<String, ValueExpression> valueExpressionMap = new HashMap<String, ValueExpression>();

        public MapVariableMapper(ExpressionFactory expressionFactory, Map<String, String> variableMap) {
            for (Map.Entry<String, String> entry : variableMap.entrySet()) {
                ValueExpression valExpr = expressionFactory.createValueExpression((Object)entry.getValue(), String.class);
                this.valueExpressionMap.put(entry.getKey(), valExpr);
            }
        }

        public ValueExpression resolveVariable(String variableName) {
            return this.valueExpressionMap.get(variableName);
        }

        public ValueExpression setVariable(String variableName, ValueExpression valueExpression) {
            return this.valueExpressionMap.put(variableName, valueExpression);
        }
    }

    class VariableContext
    extends ELContext {
        VariableMapper variableMapper;

        VariableContext(VariableMapper variableMapper) {
            this.variableMapper = variableMapper;
        }

        public ELResolver getELResolver() {
            return null;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return this.variableMapper;
        }
    }
}

