/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;
import org.apache.pig.piggybank.storage.avro.ASCommons;
import org.apache.pig.piggybank.storage.avro.ASLog;

public class PigSchema2Avro {
    public static final String TUPLE_NAME = "TUPLE";
    public static final String FIELD_NAME = "FIELD";
    public static int tupleIndex = 0;

    public static Schema convert(ResourceSchema pigSchema, boolean nullable) throws IOException {
        ResourceSchema.ResourceFieldSchema[] pigFields = pigSchema.getFields();
        if (pigFields.length == 1 && ASCommons.isTupleWrapper(pigFields[0])) {
            ASLog.details("Ignore the pig tuple wrapper.");
            ResourceSchema.ResourceFieldSchema[] listSchemas = pigFields[0].getSchema().getFields();
            if (listSchemas.length != 1) {
                throw new IOException("Expect one subfield from " + pigFields);
            }
            return PigSchema2Avro.convert(listSchemas[0], nullable);
        }
        return PigSchema2Avro.convertRecord(pigFields, nullable);
    }

    protected static Schema convert(ResourceSchema.ResourceFieldSchema pigSchema, boolean nullable) throws IOException {
        ASLog.details("Convert pig field schema:" + pigSchema);
        byte pigType = pigSchema.getType();
        if (pigType == 110) {
            ASLog.details("Convert a pig field tuple: " + pigSchema);
            ResourceSchema.ResourceFieldSchema[] listSchemas = pigSchema.getSchema().getFields();
            Schema outSchema = null;
            if (ASCommons.isTupleWrapper(pigSchema)) {
                ASLog.details("Ignore the pig tuple wrapper.");
                if (listSchemas.length != 1) {
                    throw new IOException("Expect one subfield from " + pigSchema);
                }
                outSchema = PigSchema2Avro.convert(listSchemas[0], nullable);
            } else {
                outSchema = PigSchema2Avro.convertRecord(listSchemas, nullable);
            }
            return ASCommons.wrapAsUnion(outSchema, nullable);
        }
        if (pigType == 120) {
            ASLog.details("Convert a pig field bag:" + pigSchema);
            ResourceSchema.ResourceFieldSchema[] fs = pigSchema.getSchema().getFields();
            if (fs == null || fs.length != 1 || fs[0].getType() != 110) {
                throw new IOException("Expect one tuple field in a bag");
            }
            Schema outSchema = Schema.createArray((Schema)PigSchema2Avro.convert(fs[0], nullable));
            return ASCommons.wrapAsUnion(outSchema, nullable);
        }
        if (pigType == 100) {
            throw new IOException("Please provide schema for Map field!");
        }
        if (pigType == 0) {
            throw new IOException("Must specify a schema for UNKNOWN pig type.");
        }
        if (pigType == 55 || pigType == 60 || pigType == 5 || pigType == 6 || pigType == 50 || pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15) {
            ASLog.details("Convert a pig field primitive:" + pigSchema);
            Schema outSchema = PigSchema2Avro.convertPrimitiveType(pigType);
            return ASCommons.wrapAsUnion(outSchema, nullable);
        }
        throw new IOException("unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    protected static Schema convertRecord(ResourceSchema.ResourceFieldSchema[] pigFields, boolean nullable) throws IOException {
        ASLog.funcCall("convertRecord");
        String typeName = PigSchema2Avro.getRecordName();
        Schema outSchema = Schema.createRecord((String)typeName, null, null, (boolean)false);
        ArrayList<Schema.Field> outFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < pigFields.length; ++i) {
            Schema fieldSchema = PigSchema2Avro.convert(pigFields[i], nullable);
            String outname = pigFields[i].getName();
            if (outname == null) {
                outname = "FIELD_" + i;
            }
            String desc = pigFields[i].getDescription();
            outFields.add(new Schema.Field(outname, fieldSchema, desc, null));
        }
        outSchema.setFields(outFields);
        return outSchema;
    }

    private static String getRecordName() {
        String name = "TUPLE_" + tupleIndex;
        ++tupleIndex;
        return name;
    }

    protected static Schema convertPrimitiveType(byte pigType) throws IOException {
        if (pigType == 5) {
            return ASCommons.BooleanSchema;
        }
        if (pigType == 50) {
            return ASCommons.BytesSchema;
        }
        if (pigType == 55 || pigType == 60) {
            return ASCommons.StringSchema;
        }
        if (pigType == 25) {
            return ASCommons.DoubleSchema;
        }
        if (pigType == 20) {
            return ASCommons.FloatSchema;
        }
        if (pigType == 10) {
            return ASCommons.IntSchema;
        }
        if (pigType == 15) {
            return ASCommons.LongSchema;
        }
        throw new IOException("unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    public static Schema validateAndConvert(Schema avroSchema, ResourceSchema pigSchema) throws IOException {
        ResourceSchema.ResourceFieldSchema[] pigFields = pigSchema.getFields();
        return PigSchema2Avro.validateAndConvertRecord(avroSchema, pigFields);
    }

    protected static Schema validateAndConvert(Schema avroSchema, ResourceSchema.ResourceFieldSchema pigSchema) throws IOException {
        ASLog.details("Validate pig field schema:" + pigSchema);
        if (!PigSchema2Avro.isCompatible(avroSchema, pigSchema)) {
            throw new IOException("Schemas are not compatible.\n Avro=" + avroSchema + "\n" + "Pig=" + pigSchema);
        }
        byte pigType = pigSchema.getType();
        if (avroSchema.getType().equals((Object)Schema.Type.UNION)) {
            ASLog.details("Validate Pig schema with Avro union:" + avroSchema);
            List unionSchemas = avroSchema.getTypes();
            for (Schema schema : unionSchemas) {
                try {
                    Schema s = PigSchema2Avro.validateAndConvert(schema, pigSchema);
                    return avroSchema;
                }
                catch (IOException e) {
                }
            }
            throw new IOException("pig schema " + pigSchema + " is not compatible with avro " + avroSchema);
        }
        if (pigType == 110) {
            ASLog.details("Validate a pig tuple: " + pigSchema);
            ResourceSchema.ResourceFieldSchema[] pigFields = pigSchema.getSchema().getFields();
            Schema outSchema = PigSchema2Avro.validateAndConvertRecord(avroSchema, pigFields);
            return outSchema;
        }
        if (pigType == 120) {
            ASLog.details("Validate a pig bag:" + pigSchema);
            ResourceSchema.ResourceFieldSchema[] fs = pigSchema.getSchema().getFields();
            if (fs == null || fs.length != 1 || fs[0].getType() != 110) {
                throw new IOException("Expect one tuple field in a bag");
            }
            Schema inElemSchema = avroSchema.getElementType();
            Schema outSchema = Schema.createArray((Schema)PigSchema2Avro.validateAndConvert(inElemSchema, fs[0]));
            return outSchema;
        }
        if (pigType == 100) {
            ASLog.details("Cannot validate a pig map. Will use user defined Avro schema.");
            return avroSchema;
        }
        if (pigType == 0 || pigType == 55 || pigType == 60 || pigType == 5 || pigType == 6 || pigType == 50 || pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15) {
            ASLog.details("Validate a pig primitive type:" + pigSchema);
            return avroSchema;
        }
        throw new IOException("Unsupported pig type:" + DataType.findTypeName((byte)pigType));
    }

    protected static Schema validateAndConvertRecord(Schema avroSchema, ResourceSchema.ResourceFieldSchema[] pigFields) throws IOException {
        if (!avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
            if (pigFields.length != 1) {
                throw new IOException("Expect only one field in Pig tuple schema. Avro schema is " + avroSchema.getType());
            }
            return PigSchema2Avro.validateAndConvert(avroSchema, pigFields[0]);
        }
        boolean isPartialSchema = ASCommons.isUDPartialRecordSchema(avroSchema);
        ASLog.details("isPartialSchema=" + isPartialSchema);
        String typeName = isPartialSchema ? PigSchema2Avro.getRecordName() : avroSchema.getName();
        Schema outSchema = Schema.createRecord((String)typeName, (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)false);
        List inFields = avroSchema.getFields();
        if (!isPartialSchema && inFields.size() != pigFields.length) {
            throw new IOException("Expect " + inFields.size() + " fields in pig schema." + " But there are " + pigFields.length);
        }
        ArrayList<Schema.Field> outFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < pigFields.length; ++i) {
            String outname;
            Schema.Field inputField = isPartialSchema ? ASCommons.getUDField(avroSchema, i) : (Schema.Field)inFields.get(i);
            Schema fieldSchema = null;
            fieldSchema = inputField == null ? PigSchema2Avro.convert(pigFields[i], true) : (inputField.schema() == null ? PigSchema2Avro.convert(pigFields[i], false) : PigSchema2Avro.validateAndConvert(inputField.schema(), pigFields[i]));
            String string = outname = isPartialSchema ? pigFields[i].getName() : inputField.name();
            if (outname == null) {
                outname = "FIELD_" + i;
            }
            String doc = isPartialSchema ? pigFields[i].getDescription() : inputField.doc();
            outFields.add(new Schema.Field(outname, fieldSchema, doc, null));
        }
        outSchema.setFields(outFields);
        return outSchema;
    }

    protected static boolean isCompatible(Schema avroSchema, ResourceSchema.ResourceFieldSchema pigSchema) throws IOException {
        Schema.Type avroType = avroSchema.getType();
        byte pigType = pigSchema.getType();
        if (avroType.equals((Object)Schema.Type.UNION)) {
            return true;
        }
        if (pigType == 110) {
            return true;
        }
        return avroType.equals((Object)Schema.Type.ARRAY) && pigType == 120 || avroType.equals((Object)Schema.Type.MAP) && pigType == 100 || avroType.equals((Object)Schema.Type.STRING) && pigType == 55 || pigType == 60 || avroType.equals((Object)Schema.Type.ENUM) && pigType == 55 || avroType.equals((Object)Schema.Type.BOOLEAN) && pigType == 5 || pigType == 10 || avroType.equals((Object)Schema.Type.BYTES) && pigType == 50 || avroType.equals((Object)Schema.Type.DOUBLE) && pigType == 25 || pigType == 20 || pigType == 10 || pigType == 15 || avroType.equals((Object)Schema.Type.FLOAT) && pigType == 20 || pigType == 10 || pigType == 15 || avroType.equals((Object)Schema.Type.FIXED) && pigType == 50 || avroType.equals((Object)Schema.Type.INT) && pigType == 10 || avroType.equals((Object)Schema.Type.LONG) && pigType == 15 || pigType == 10;
    }
}

