/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigAvroInputFormat
extends FileInputFormat<NullWritable, Writable> {
    private Schema schema = null;

    public PigAvroInputFormat() {
    }

    public PigAvroInputFormat(Schema s) {
        this.schema = s;
    }

    protected List<FileStatus> listStatus(JobContext context) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus file : super.listStatus(context)) {
            if (!file.getPath().getName().endsWith(".avro")) continue;
            result.add(file);
        }
        return result;
    }

    public RecordReader<NullWritable, Writable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(split.toString());
        return new PigAvroRecordReader(context, (FileSplit)split, this.schema);
    }
}

