/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.util.Utf8;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.avro.ASCommons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigAvroDatumReader
extends GenericDatumReader<Object> {
    public PigAvroDatumReader(Schema schema) {
        super(schema);
    }

    public PigAvroDatumReader(Schema writer, Schema reader) throws IOException {
        super(writer, reader);
    }

    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Tuple tuple = (Tuple)this.newRecord(old, expected);
        for (Schema.Field f : in.readFieldOrder()) {
            tuple.append(this.read(null, f.schema(), in));
        }
        return tuple;
    }

    protected Object readMap(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema eValue = expected.getValueType();
        long l = in.readMapStart();
        Object map = this.newMap(old, (int)l);
        if (l > 0L) {
            do {
                int i = 0;
                while ((long)i < l) {
                    this.addToMap(map, this.readString(null, ASCommons.StringSchema, (Decoder)in), this.read(null, eValue, in));
                    ++i;
                }
            } while ((l = in.mapNext()) > 0L);
        }
        return map;
    }

    protected Object createEnum(String symbol, Schema schema) {
        return symbol;
    }

    protected Object peekArray(Object array) {
        return null;
    }

    protected void addToArray(Object array, long pos, Object e) {
        if (e instanceof Tuple) {
            ((DataBag)array).add((Tuple)e);
        } else {
            DefaultTuple t = new DefaultTuple();
            t.append(e);
            ((DataBag)array).add((Tuple)t);
        }
    }

    protected Object readFixed(Object old, Schema expected, Decoder in) throws IOException {
        GenericFixed fixed = (GenericFixed)super.readFixed(old, expected, in);
        DataByteArray byteArray = new DataByteArray(fixed.bytes());
        return byteArray;
    }

    protected Object newRecord(Object old, Schema schema) {
        return TupleFactory.getInstance().newTuple();
    }

    protected Object newArray(Object old, int size, Schema schema) {
        return BagFactory.getInstance().newDefaultBag();
    }

    protected Object readString(Object old, Schema expected, Decoder in) throws IOException {
        Utf8 str = (Utf8)super.readString(old, expected, in);
        return str.toString();
    }

    protected Object readBytes(Object old, Decoder in) throws IOException {
        ByteBuffer buf = (ByteBuffer)super.readBytes(old, in);
        DataByteArray byteArray = new DataByteArray(buf.array());
        return byteArray;
    }
}

