/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.JsonMetadata;
import org.apache.pig.piggybank.storage.allloader.LoadFuncHelper;
import org.apache.pig.piggybank.storage.partition.PathPartitionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllLoader
extends FileInputLoadFunc
implements LoadMetadata,
StoreMetadata,
LoadPushDown {
    private static final Logger LOG = Logger.getLogger(AllLoader.class);
    private static final String PROJECTION_ID = AllLoader.class.getName() + ".projection";
    transient LoadFunc childLoadFunc;
    transient boolean supportPushDownProjection = false;
    transient LoadPushDown.RequiredFieldList requiredFieldList;
    transient SortedSet<Integer> requiredFieldHashSet;
    transient TupleFactory tupleFactory = TupleFactory.getInstance();
    transient ResourceSchema schema;
    String signature;
    transient PathPartitionHelper pathPartitionerHelper = new PathPartitionHelper();
    transient Map<String, String> currentPathPartitionKeyMap;
    transient String[] partitionColumns;
    transient JsonMetadata jsonMetadata = new JsonMetadata();
    transient boolean partitionKeysSet = false;
    LoadFuncHelper loadFuncHelper = null;
    transient Configuration conf;
    transient Path currentPath;
    String constructorPassedPartitionFilter;

    public AllLoader() {
    }

    public AllLoader(String partitionFilter) {
        this();
        LOG.debug((Object)("PartitionFilter: " + partitionFilter.toString()));
        this.constructorPassedPartitionFilter = partitionFilter;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
        this.conf = job.getConfiguration();
        this.loadFuncHelper = new LoadFuncHelper(this.conf);
        if (this.constructorPassedPartitionFilter != null) {
            this.pathPartitionerHelper.setPartitionFilterExpression(this.constructorPassedPartitionFilter, AllLoader.class, this.signature);
        }
        this.getPartitionKeys(location, job);
    }

    public LoadCaster getLoadCaster() throws IOException {
        return new Utf8StorageConverter();
    }

    public AllLoaderInputFormat getInputFormat() throws IOException {
        return new AllLoaderInputFormat(this.signature);
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        AllReader allReader = (AllReader)reader;
        if (this.currentPath == null || !this.currentPath.equals((Object)allReader.path)) {
            this.currentPathPartitionKeyMap = this.partitionColumns == null ? null : this.pathPartitionerHelper.getPathPartitionKeyValues(allReader.path.toString());
            this.currentPath = allReader.path;
        }
        this.childLoadFunc = allReader.prepareLoadFuncForReading(split);
        String projectProperty = this.getUDFContext().getProperty(PROJECTION_ID);
        if (projectProperty != null) {
            ByteArrayInputStream input = new ByteArrayInputStream(Base64.decodeBase64((byte[])projectProperty.getBytes("UTF-8")));
            ObjectInputStream objInput = new ObjectInputStream(input);
            try {
                this.requiredFieldList = (LoadPushDown.RequiredFieldList)objInput.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new FrontendException(e.toString(), (Throwable)e);
            }
            finally {
                IOUtils.closeStream((Closeable)objInput);
            }
            if (this.childLoadFunc.getClass().isAssignableFrom(LoadPushDown.class)) {
                this.supportPushDownProjection = true;
                ((LoadPushDown)this.childLoadFunc).pushProjection(this.requiredFieldList);
            } else if (this.requiredFieldList != null) {
                this.requiredFieldHashSet = new TreeSet<Integer>();
                for (LoadPushDown.RequiredField requiredField : this.requiredFieldList.getFields()) {
                    this.requiredFieldHashSet.add(requiredField.getIndex());
                }
            }
        }
    }

    public Tuple getNext() throws IOException {
        Tuple tuple = null;
        if (this.supportPushDownProjection) {
            tuple = this.childLoadFunc.getNext();
        } else {
            tuple = this.childLoadFunc.getNext();
            if (tuple != null && this.requiredFieldHashSet != null) {
                Tuple projectedTuple = this.tupleFactory.newTuple(this.requiredFieldHashSet.size());
                int i = 0;
                int tupleSize = tuple.size();
                Iterator i$ = this.requiredFieldHashSet.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    if (index < tupleSize) {
                        projectedTuple.set(i++, tuple.get(index));
                        continue;
                    }
                    projectedTuple.set(i++, (Object)this.currentPathPartitionKeyMap.get(this.partitionColumns[index - tupleSize]));
                }
                tuple = projectedTuple;
            }
        }
        return tuple;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        Properties properties = this.getUDFContext();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(byteArray);
            objOut.writeObject(requiredFieldList);
        }
        catch (IOException e) {
            try {
                throw new FrontendException(e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(objOut);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)objOut);
        try {
            properties.setProperty(PROJECTION_ID, new String(Base64.encodeBase64((byte[])byteArray.toByteArray()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FrontendException(e.toString(), (Throwable)e);
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    private ResourceSchema getSchemaFromLoadFunc(String location, Job job) throws IOException {
        ResourceSchema schema = null;
        if (this.loadFuncHelper == null) {
            this.loadFuncHelper = new LoadFuncHelper(job.getConfiguration());
        }
        Path firstFile = this.loadFuncHelper.determineFirstFile(location);
        if (this.childLoadFunc == null) {
            FuncSpec funcSpec = this.loadFuncHelper.determineFunction(location, firstFile);
            if (funcSpec == null) {
                throw new FrontendException("No LoadFunction could be determined for " + location);
            }
            this.childLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec((FuncSpec)funcSpec);
        }
        LOG.debug((Object)("Found LoadFunc:  " + this.childLoadFunc.getClass().getName()));
        if (this.childLoadFunc instanceof LoadMetadata) {
            schema = ((LoadMetadata)this.childLoadFunc).getSchema(firstFile.toUri().toString(), job);
            LOG.debug((Object)("Found schema " + schema + " from loadFunc:  " + this.childLoadFunc.getClass().getName()));
        }
        return schema;
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.schema == null) {
            ResourceSchema foundSchema = this.jsonMetadata.getSchema(location, job);
            if (foundSchema == null) {
                foundSchema = this.getSchemaFromLoadFunc(location, job);
            }
            if (!this.partitionKeysSet && foundSchema != null) {
                String[] keys = this.getPartitionColumns(location, job);
                if (keys != null && keys.length != 0) {
                    Object[] fields = foundSchema.getFields();
                    LOG.debug((Object)("Schema: " + Arrays.toString(fields)));
                    Object[] newFields = (ResourceSchema.ResourceFieldSchema[])Arrays.copyOf(fields, fields.length + keys.length);
                    int index = fields.length;
                    for (String key : keys) {
                        newFields[index++] = new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(key, 55));
                    }
                    foundSchema.setFields((ResourceSchema.ResourceFieldSchema[])newFields);
                    LOG.debug((Object)("Added partition fields: " + keys + " to loader schema"));
                    LOG.debug((Object)("Schema is: " + Arrays.toString(newFields)));
                }
                this.partitionKeysSet = true;
            }
            this.schema = foundSchema;
        }
        return this.schema;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) throws IOException {
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
        this.jsonMetadata.storeSchema(schema, location, job);
    }

    private String[] getPartitionColumns(String location, Job job) {
        if (this.partitionColumns == null) {
            String partitionColumnStr;
            Properties properties = this.getUDFContext();
            if (properties == null) {
                properties = new Properties();
            }
            if ((partitionColumnStr = properties.getProperty(PathPartitionHelper.PARTITION_COLUMNS)) == null && location != null && job != null) {
                Set<String> partitionColumnSet;
                try {
                    partitionColumnSet = this.pathPartitionerHelper.getPartitionKeys(location, job.getConfiguration());
                }
                catch (IOException e) {
                    RuntimeException rte = new RuntimeException(e);
                    rte.setStackTrace(e.getStackTrace());
                    throw rte;
                }
                if (partitionColumnSet != null) {
                    StringBuilder buff = new StringBuilder();
                    int i = 0;
                    for (String column : partitionColumnSet) {
                        if (i++ != 0) {
                            buff.append(',');
                        }
                        buff.append(column);
                    }
                    String buffStr = buff.toString().trim();
                    if (buffStr.length() > 0) {
                        properties.setProperty(PathPartitionHelper.PARTITION_COLUMNS, buff.toString());
                    }
                    this.partitionColumns = partitionColumnSet.toArray(new String[0]);
                }
            } else if (partitionColumnStr != null) {
                String[] split = partitionColumnStr.split(",");
                LinkedHashSet<String> partitionColumnSet = new LinkedHashSet<String>();
                if (split.length > 0) {
                    for (String splitItem : split) {
                        partitionColumnSet.add(splitItem);
                    }
                }
                this.partitionColumns = partitionColumnSet.toArray(new String[0]);
            }
        }
        return this.partitionColumns;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        Object[] partitionKeys = this.getPartitionColumns(location, job);
        if (partitionKeys == null) {
            throw new NullPointerException("INDUCED");
        }
        LOG.info((Object)("Get Parition Keys for: " + location + " keys: " + Arrays.toString(partitionKeys)));
        return partitionKeys;
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
        super.setUDFContextSignature(signature);
    }

    private Properties getUDFContext() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
        LOG.debug((Object)("PartitionFilter: " + partitionFilter.toString()));
        this.pathPartitionerHelper.setPartitionFilterExpression(partitionFilter.toString(), AllLoader.class, this.signature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllReader
    extends RecordReader<Writable, Writable> {
        LoadFunc selectedLoadFunc;
        RecordReader<Writable, Writable> selectedReader;
        LoadFuncHelper loadFuncHelper = null;
        String udfSignature;
        Path path;

        public AllReader(String udfSignature) {
            this.udfSignature = udfSignature;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            FileSplit fileSplit = (FileSplit)inputSplit;
            this.path = fileSplit.getPath();
            String fileName = this.path.toUri().toString();
            this.loadFuncHelper = new LoadFuncHelper(taskAttemptContext.getConfiguration());
            FuncSpec funcSpec = this.loadFuncHelper.determineFunction(fileName);
            if (funcSpec == null) {
                throw new IOException("Cannot determine LoadFunc for " + fileName);
            }
            this.selectedLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec((FuncSpec)funcSpec);
            this.selectedLoadFunc.setUDFContextSignature(this.udfSignature);
            this.selectedLoadFunc.setLocation(fileName, new Job(taskAttemptContext.getConfiguration(), taskAttemptContext.getJobName()));
            this.selectedReader = this.selectedLoadFunc.getInputFormat().createRecordReader((InputSplit)fileSplit, taskAttemptContext);
            this.selectedReader.initialize((InputSplit)fileSplit, taskAttemptContext);
            LOG.info((Object)("Using LoadFunc " + this.selectedLoadFunc.getClass().getName() + " on " + fileName));
        }

        public LoadFunc prepareLoadFuncForReading(PigSplit split) throws IOException {
            this.selectedLoadFunc.prepareToRead(this.selectedReader, split);
            return this.selectedLoadFunc;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.selectedReader.nextKeyValue();
        }

        public Writable getCurrentKey() throws IOException, InterruptedException {
            return (Writable)this.selectedReader.getCurrentKey();
        }

        public Writable getCurrentValue() throws IOException, InterruptedException {
            return (Writable)this.selectedReader.getCurrentValue();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.selectedReader.getProgress();
        }

        public void close() throws IOException {
            this.selectedReader.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllLoaderInputFormat
    extends FileInputFormat<Writable, Writable> {
        transient PathPartitionHelper partitionHelper = new PathPartitionHelper();
        String udfSignature;

        public AllLoaderInputFormat(String udfSignature) {
            this.udfSignature = udfSignature;
        }

        protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
            List files = this.partitionHelper.listStatus(jobContext, AllLoader.class, this.udfSignature);
            if (files == null) {
                files = super.listStatus(jobContext);
            }
            return files;
        }

        public RecordReader<Writable, Writable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return new AllReader(this.udfSignature);
        }
    }
}

