/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.math;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.piggybank.evaluation.math.DoubleNextAfter;
import org.apache.pig.piggybank.evaluation.math.FloatNextAfter;
import org.apache.pig.piggybank.evaluation.math.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class nextAfter
extends EvalFunc<Double> {
    public Double exec(Tuple input) throws IOException {
        try {
            double first = DataType.toDouble((Object)input.get(0));
            double second = DataType.toDouble((Object)input.get(1));
            return Math.nextAfter(first, second);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Failed to process input; error - " + nfe.getMessage());
            return null;
        }
        catch (Exception e) {
            throw new IOException("Caught exception in nextAfter", e);
        }
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 25));
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Util.addToFunctionList(funcList, ((Object)((Object)this)).getClass().getName(), (byte)50);
        Util.addToFunctionList(funcList, DoubleNextAfter.class.getName(), (byte)25);
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        fields.add(new Schema.FieldSchema(null, 20));
        fields.add(new Schema.FieldSchema(null, 25));
        funcList.add(new FuncSpec(FloatNextAfter.class.getName(), new Schema(fields)));
        return funcList;
    }
}

