/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.cluster.Broker;
import kafka.cluster.Cluster;
import kafka.consumer.TopicCount;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ZkUtils$
implements Logging,
ScalaObject {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ZkUtils$ zkUtils$ = this;
        synchronized (zkUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.createEphemeral(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$1, String data$1) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$1, data$1);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = this.readData(client, path$1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string = (String)storedData$1.elem;
                String string2 = data$1;
                if (string != null ? !string.equals(string2) : string2 != null) break block6;
                this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.2(path$1, data$1));
            }
            return;
        }
        this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.1(path$1, data$1, storedData$1));
        throw zkNodeExistsException2;
    }

    public void updatePersistentPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, (Object)data);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, (Object)data);
            }
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void deletePath(ZkClient client, String path$2) {
        try {
            client.delete(path$2);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePath.1(path$2));
        }
    }

    public void deletePathRecursive(ZkClient client, String path$3) {
        try {
            client.deleteRecursive(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePathRecursive.1(path$3));
        }
    }

    public String readData(ZkClient client, String path) {
        return (String)client.readData(path);
    }

    public String readDataMaybeNull(ZkClient client, String path) {
        return (String)client.readData(path, true);
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        java.util.List ret = null;
        try {
            ret = client.getChildren(path);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
        return JavaConversions$.MODULE$.asBuffer(ret);
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    public String getLastPart(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$1) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$1, this.BrokerIdsPath());
        nodes.foreach((Function1)new anonfun.getCluster.1(zkClient$1, cluster$1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, List<String>> getPartitionsForTopics(ZkClient zkClient$3, Iterator<String> topics) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topics.foreach((Function1)new anonfun.getPartitionsForTopics.1(zkClient$3, ret$1));
        return var3_3;
    }

    public void setupPartition(ZkClient zkClient, int brokerId, String host, int port, String topic, int nParts) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        Broker broker = new Broker(brokerId, ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString(), host, port);
        this.createEphemeralPathExpectConflict(zkClient, brokerIdPath, broker.getZKString());
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        this.createEphemeralPathExpectConflict(zkClient, brokerPartTopicPath, ((Object)BoxesRunTime.boxToInteger((int)nParts)).toString());
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public Map<String, TopicCount> getConsumerTopicMaps(ZkClient zkClient$4, String group) {
        ZKGroupDirs dirs$1 = new ZKGroupDirs(group);
        Seq<String> consumersInGroup = this.getConsumersInGroup(zkClient$4, group);
        Seq topicCountMaps = (Seq)consumersInGroup.map((Function1)new anonfun.1(zkClient$4, dirs$1), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)consumersInGroup.zip((Iterable)topicCountMaps, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient$2, String group$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$2, dirs.consumerRegistryDir());
        HashMap consumersPerTopicMap$1 = new HashMap();
        consumers.foreach((Function1)new anonfun.getConsumersPerTopic.1(zkClient$2, group$1, consumersPerTopicMap$1));
        consumersPerTopicMap$1.foreach((Function1)new anonfun.getConsumersPerTopic.2(consumersPerTopicMap$1));
        return consumersPerTopicMap$1;
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
    }
}

