/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.consumer.SimpleConsumer;
import kafka.tools.ConsumerOffsetChecker$;
import kafka.tools.ConsumerOffsetChecker$$anonfun$kafka$tools$ConsumerOffsetChecker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging,
ScalaObject {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final Map<String, Option<SimpleConsumer>> consumerMap;
    private final Regex BidPidPattern;
    private final Regex BrokerIpPattern;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private Map<String, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    private Regex BidPidPattern() {
        return this.BidPidPattern;
    }

    private Regex BrokerIpPattern() {
        return this.BrokerIpPattern;
    }

    public final Option kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, String bid) {
        None$ none$;
        List list;
        String brokerInfo$1;
        String string = brokerInfo$1 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, Predef$.MODULE$.augmentString("/brokers/ids/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bid})));
        Option option = this.BrokerIpPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(2) == 0)) {
            none$ = new Some((Object)new SimpleConsumer((String)list.apply(0), Predef$.MODULE$.augmentString((String)list.apply(1)).toInt(), 10000, 100000));
        } else {
            this.error((Function0<String>)new anonfun.1(brokerInfo$1));
            none$ = None$.MODULE$;
        }
        None$ consumer = none$;
        return consumer;
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient$1, String group, String topic, String bidPid$1) {
        List list;
        long offset = Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topic, bidPid$1})))).toLong();
        String owner = ZkUtils$.MODULE$.readDataMaybeNull(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s,%s,%s (Group,Topic,BrokerId-PartitionId)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Owner = ", owner})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Consumer offset = ", BoxesRunTime.boxToLong((long)offset)})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"= ", BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToDouble((double)((double)offset / package$.MODULE$.pow(1024.0, 3.0)))})));
        String string = bidPid$1;
        Option option = this.BidPidPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(2) == 0)) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String bid$1 = string2;
            String pid = string3;
            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate((Object)bid$1, (Function0)new anonfun.2(zkClient$1, bid$1));
            Option option2 = consumerOpt;
            if (option2 instanceof Some) {
                SimpleConsumer simpleConsumer;
                Some some = (Some)option2;
                SimpleConsumer consumer = simpleConsumer = (SimpleConsumer)some.x();
                long logSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(consumer.getOffsetsBefore(topic, Predef$.MODULE$.augmentString(pid).toInt(), -1L, 1)).last());
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Log size = ", BoxesRunTime.boxToLong((long)logSize)})));
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"= ", BoxesRunTime.boxToLong((long)logSize), BoxesRunTime.boxToDouble((double)((double)logSize / package$.MODULE$.pow(1024.0, 3.0)))})));
                long lag = logSize - offset;
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Consumer lag = ", BoxesRunTime.boxToLong((long)lag)})));
                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"= ", BoxesRunTime.boxToLong((long)lag), BoxesRunTime.boxToDouble((double)((double)lag / package$.MODULE$.pow(1024.0, 3.0)))})));
                Predef$.MODULE$.println();
            } else {
                None$ none$ = None$.MODULE$;
                Option option3 = option2;
                if (none$ == null ? option3 != null : !none$.equals(option3)) {
                    throw new MatchError((Object)option2);
                }
            }
        } else {
            this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$processPartition$1(bidPid$1));
        }
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient$2, String group$1, String topic$1) {
        List bidsPids = ZkUtils$.MODULE$.getChildrenParentMayNotExist(zkClient$2, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group$1, topic$1}))).toList();
        ((LinearSeqOptimized)bidsPids.sorted((Ordering)Ordering$String$.MODULE$)).foreach((Function1)new anonfun$kafka$tools$ConsumerOffsetChecker$$processTopic$1(zkClient$2, group$1, topic$1));
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println((Object)"BROKER INFO");
        this.consumerMap().foreach((Function1)new anonfun.printBrokerInfo.1());
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser$1.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec topicsOpt = parser$1.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser$1.accepts("help", "Print this message.");
        OptionSet options$1 = parser$1.parse(args);
        if (options$1.has("help")) {
            parser$1.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
        String zkConnect$1 = (String)options$1.valueOf((OptionSpec)zkConnectOpt);
        String group$2 = (String)options$1.valueOf((OptionSpec)groupOpt);
        None$ topics = options$1.has((OptionSpec)topicsOpt) ? new Some(options$1.valueOf((OptionSpec)topicsOpt)) : None$.MODULE$;
        ObjectRef zkClient$3 = new ObjectRef(null);
        try {
            None$ none$;
            block11: {
                List list;
                block10: {
                    block9: {
                        zkClient$3.elem = new ZkClient(zkConnect$1, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
                        none$ = topics;
                        if (!(none$ instanceof Some)) break block9;
                        list = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)none$).x()).split(",")).view().toList();
                        break block10;
                    }
                    None$ none$2 = None$.MODULE$;
                    None$ none$3 = none$;
                    if (none$2 != null ? !none$2.equals(none$3) : none$3 != null) break block11;
                    list = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient$3.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group$2}))).toList();
                }
                List topicList$1 = list;
                this.debug((Function0<String>)new anonfun.main.2(zkConnect$1, group$2, topicList$1));
                ((LinearSeqOptimized)topicList$1.sorted((Ordering)Ordering$String$.MODULE$)).foreach((Function1)new anonfun.main.3(group$2, zkClient$3));
                this.printBrokerInfo();
                return;
            }
            throw new MatchError((Object)none$);
        }
        finally {
            this.consumerMap().values().foreach((Function1)new anonfun.main.4());
            if ((ZkClient)zkClient$3.elem != null) {
                ((ZkClient)zkClient$3.elem).close();
            }
        }
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.BidPidPattern = Predef$.MODULE$.augmentString("(\\d+)-(\\d+)").r();
        this.BrokerIpPattern = Predef$.MODULE$.augmentString(".*:(\\d+\\.\\d+\\.\\d+\\.\\d+):(\\d+$)").r();
    }
}

