/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.message.Message$;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011!B;uS2\u001c\u0018BA\u0007\u000b\u0005!Q6jQ8oM&<\u0007CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0006aJ|\u0007o\u001d\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA!\u001e;jY*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001a\u0003C\u0001\u0012\u0001\u001b\u0005\u0011\u0001\"B\u000b\u001f\u0001\u00041\u0002bB\u0013\u0001\u0005\u0004%\tAJ\u0001\u0005a>\u0014H/F\u0001(!\ty\u0001&\u0003\u0002*!\t\u0019\u0011J\u001c;\t\r-\u0002\u0001\u0015!\u0003(\u0003\u0015\u0001xN\u001d;!\u0011\u001di\u0003A1A\u0005\u00029\n\u0001\u0002[8ti:\u000bW.Z\u000b\u0002_A\u0011\u0001g\r\b\u0003\u001fEJ!A\r\t\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eAAaa\u000e\u0001!\u0002\u0013y\u0013!\u00035pgRt\u0015-\\3!\u0011\u001dI\u0004A1A\u0005\u0002\u0019\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u0007w\u0001\u0001\u000b\u0011B\u0014\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAJ\u0001\u0011g>\u001c7.\u001a;TK:$')\u001e4gKJDaa\u0010\u0001!\u0002\u00139\u0013!E:pG.,GoU3oI\n+hMZ3sA!9\u0011\t\u0001b\u0001\n\u00031\u0013aE:pG.,GOU3dK&4XMQ;gM\u0016\u0014\bBB\"\u0001A\u0003%q%\u0001\u000bt_\u000e\\W\r\u001e*fG\u0016Lg/\u001a\"vM\u001a,'\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001'\u0003Qi\u0017\r_*pG.,GOU3rk\u0016\u001cHoU5{K\"1q\t\u0001Q\u0001\n\u001d\nQ#\\1y'>\u001c7.\u001a;SKF,Xm\u001d;TSj,\u0007\u0005C\u0004J\u0001\t\u0007I\u0011\u0001\u0014\u0002\u001d5\f\u00070T3tg\u0006<WmU5{K\"11\n\u0001Q\u0001\n\u001d\nq\"\\1y\u001b\u0016\u001c8/Y4f'&TX\r\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001'\u0003)qW/\u001c+ie\u0016\fGm\u001d\u0005\u0007\u001f\u0002\u0001\u000b\u0011B\u0014\u0002\u00179,X\u000e\u00165sK\u0006$7\u000f\t\u0005\b#\u0002\u0011\r\u0011\"\u0001'\u0003QiwN\\5u_JLgn\u001a)fe&|GmU3dg\"11\u000b\u0001Q\u0001\n\u001d\nQ#\\8oSR|'/\u001b8h!\u0016\u0014\u0018n\u001c3TK\u000e\u001c\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0001\u0014\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u00199\u0006\u0001)A\u0005O\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003bB-\u0001\u0005\u0004%\tAL\u0001\u0007Y><G)\u001b:\t\rm\u0003\u0001\u0015!\u00030\u0003\u001dawn\u001a#je\u0002Bq!\u0018\u0001C\u0002\u0013\u0005a%A\u0006m_\u001e4\u0015\u000e\\3TSj,\u0007BB0\u0001A\u0003%q%\u0001\u0007m_\u001e4\u0015\u000e\\3TSj,\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00012\u0002\u001d1|wMR5mKNK'0Z'baV\t1\r\u0005\u0003eO>:S\"A3\u000b\u0005\u0019\u0004\u0012AC2pY2,7\r^5p]&\u0011\u0001.\u001a\u0002\u0004\u001b\u0006\u0004\bB\u00026\u0001A\u0003%1-A\bm_\u001e4\u0015\u000e\\3TSj,W*\u00199!\u0011\u001da\u0007A1A\u0005\u0002\u0019\nA\u0002\\8h%>dG\u000eS8veNDaA\u001c\u0001!\u0002\u00139\u0013!\u00047pOJ{G\u000e\u001c%pkJ\u001c\b\u0005C\u0004q\u0001\t\u0007I\u0011\u00012\u0002\u001f1|wMU8mY\"{WO]:NCBDaA\u001d\u0001!\u0002\u0013\u0019\u0017\u0001\u00057pOJ{G\u000e\u001c%pkJ\u001cX*\u00199!\u0011\u001d!\bA1A\u0005\u0002\u0019\n\u0011\u0003\\8h%\u0016$XM\u001c;j_:Du.\u001e:t\u0011\u00191\b\u0001)A\u0005O\u0005\u0011Bn\\4SKR,g\u000e^5p]\"{WO]:!\u0011\u001dA\bA1A\u0005\u0002\t\fA\u0003\\8h%\u0016$XM\u001c;j_:Du.\u001e:t\u001b\u0006\u0004\bB\u0002>\u0001A\u0003%1-A\u000bm_\u001e\u0014V\r^3oi&|g\u000eS8veNl\u0015\r\u001d\u0011\t\u000fq\u0004!\u0019!C\u0001{\u0006\u0001Bn\\4SKR,g\u000e^5p]NK'0Z\u000b\u0002}B\u0011qb`\u0005\u0004\u0003\u0003\u0001\"\u0001\u0002'p]\u001eDq!!\u0002\u0001A\u0003%a0A\tm_\u001e\u0014V\r^3oi&|gnU5{K\u0002B\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\u0002'1|wMU3uK:$\u0018n\u001c8TSj,W*\u00199\u0016\u0005\u00055\u0001\u0003\u00023h_yD\u0001\"!\u0005\u0001A\u0003%\u0011QB\u0001\u0015Y><'+\u001a;f]RLwN\\*ju\u0016l\u0015\r\u001d\u0011\t\u0011\u0005U\u0001A1A\u0005\u0002\u0019\n\u0011\u0004\\8h\u00072,\u0017M\\;q\u0013:$XM\u001d<bY6Kg.\u001e;fg\"9\u0011\u0011\u0004\u0001!\u0002\u00139\u0013A\u00077pO\u000ecW-\u00198va&sG/\u001a:wC2l\u0015N\\;uKN\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0003=)g.\u00192mKj{wn[3fa\u0016\u0014XCAA\u0011!\ry\u00111E\u0005\u0004\u0003K\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\"\u0005\u0001RM\\1cY\u0016Tvn\\6fKB,'\u000f\t\u0005\t\u0003[\u0001!\u0019!C\u0001M\u0005ia\r\\;tQ&sG/\u001a:wC2Dq!!\r\u0001A\u0003%q%\u0001\bgYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0011\t\u0011\u0005U\u0002A1A\u0005\u0002\t\f\u0001C\u001a7vg\"Le\u000e^3sm\u0006dW*\u00199\t\u000f\u0005e\u0002\u0001)A\u0005G\u0006\tb\r\\;tQ&sG/\u001a:wC2l\u0015\r\u001d\u0011\t\u0011\u0005u\u0002A1A\u0005\u0002\u0019\n\u0001D\u001a7vg\"\u001c6\r[3ek2,'\u000f\u00165sK\u0006$'+\u0019;f\u0011\u001d\t\t\u0005\u0001Q\u0001\n\u001d\n\u0011D\u001a7vg\"\u001c6\r[3ek2,'\u000f\u00165sK\u0006$'+\u0019;fA!A\u0011Q\t\u0001C\u0002\u0013\u0005a%\u0001\feK\u001a\fW\u000f\u001c;GYV\u001c\b.\u00138uKJ4\u0018\r\\'t\u0011\u001d\tI\u0005\u0001Q\u0001\n\u001d\nq\u0003Z3gCVdGO\u00127vg\"Le\u000e^3sm\u0006dWj\u001d\u0011\t\u0011\u00055\u0003A1A\u0005\u0002\t\f!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]'ba\"9\u0011\u0011\u000b\u0001!\u0002\u0013\u0019\u0017a\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:NCB\u0004\u0003")
public class KafkaConfig
extends ZKConfig
implements ScalaObject {
    private final int port;
    private final String hostName;
    private final int brokerId;
    private final int socketSendBuffer;
    private final int socketReceiveBuffer;
    private final int maxSocketRequestSize;
    private final int maxMessageSize;
    private final int numThreads;
    private final int monitoringPeriodSecs;
    private final int numPartitions;
    private final String logDir;
    private final int logFileSize;
    private final Map<String, Integer> logFileSizeMap;
    private final int logRollHours;
    private final Map<String, Integer> logRollHoursMap;
    private final int logRetentionHours;
    private final Map<String, Integer> logRetentionHoursMap;
    private final long logRetentionSize;
    private final Map<String, Long> logRetentionSizeMap;
    private final int logCleanupIntervalMinutes;
    private final boolean enableZookeeper;
    private final int flushInterval;
    private final Map<String, Integer> flushIntervalMap;
    private final int flushSchedulerThreadRate;
    private final int defaultFlushIntervalMs;
    private final Map<String, Integer> topicPartitionsMap;

    public int port() {
        return this.port;
    }

    public String hostName() {
        return this.hostName;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int socketSendBuffer() {
        return this.socketSendBuffer;
    }

    public int socketReceiveBuffer() {
        return this.socketReceiveBuffer;
    }

    public int maxSocketRequestSize() {
        return this.maxSocketRequestSize;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int monitoringPeriodSecs() {
        return this.monitoringPeriodSecs;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public String logDir() {
        return this.logDir;
    }

    public int logFileSize() {
        return this.logFileSize;
    }

    public Map<String, Integer> logFileSizeMap() {
        return this.logFileSizeMap;
    }

    public int logRollHours() {
        return this.logRollHours;
    }

    public Map<String, Integer> logRollHoursMap() {
        return this.logRollHoursMap;
    }

    public int logRetentionHours() {
        return this.logRetentionHours;
    }

    public Map<String, Integer> logRetentionHoursMap() {
        return this.logRetentionHoursMap;
    }

    public long logRetentionSize() {
        return this.logRetentionSize;
    }

    public Map<String, Long> logRetentionSizeMap() {
        return this.logRetentionSizeMap;
    }

    public int logCleanupIntervalMinutes() {
        return this.logCleanupIntervalMinutes;
    }

    public boolean enableZookeeper() {
        return this.enableZookeeper;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public Map<String, Integer> flushIntervalMap() {
        return this.flushIntervalMap;
    }

    public int flushSchedulerThreadRate() {
        return this.flushSchedulerThreadRate;
    }

    public int defaultFlushIntervalMs() {
        return this.defaultFlushIntervalMs;
    }

    public Map<String, Integer> topicPartitionsMap() {
        return this.topicPartitionsMap;
    }

    public KafkaConfig(Properties props) {
        super(props);
        this.port = Utils$.MODULE$.getInt(props, "port", 6667);
        this.hostName = Utils$.MODULE$.getString(props, "hostname", null);
        this.brokerId = Utils$.MODULE$.getInt(props, "brokerid");
        this.socketSendBuffer = Utils$.MODULE$.getInt(props, "socket.send.buffer", 102400);
        this.socketReceiveBuffer = Utils$.MODULE$.getInt(props, "socket.receive.buffer", 102400);
        this.maxSocketRequestSize = Utils$.MODULE$.getIntInRange(props, "max.socket.request.bytes", 0x6400000, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.maxMessageSize = Utils$.MODULE$.getIntInRange(props, "max.message.size", 1000000, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(0, Integer.MAX_VALUE));
        this.numThreads = Utils$.MODULE$.getIntInRange(props, "num.threads", Runtime.getRuntime().availableProcessors(), (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.monitoringPeriodSecs = Utils$.MODULE$.getIntInRange(props, "monitoring.period.secs", 600, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.numPartitions = Utils$.MODULE$.getIntInRange(props, "num.partitions", 1, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logDir = Utils$.MODULE$.getString(props, "log.dir");
        this.logFileSize = Utils$.MODULE$.getIntInRange(props, "log.file.size", 0x40000000, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(Message$.MODULE$.MinHeaderSize(), Integer.MAX_VALUE));
        this.logFileSizeMap = Utils$.MODULE$.getTopicFileSize(Utils$.MODULE$.getString(props, "topic.log.file.size", ""));
        this.logRollHours = Utils$.MODULE$.getIntInRange(props, "log.roll.hours", 168, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRollHoursMap = Utils$.MODULE$.getTopicRollHours(Utils$.MODULE$.getString(props, "topic.log.roll.hours", ""));
        this.logRetentionHours = Utils$.MODULE$.getIntInRange(props, "log.retention.hours", 168, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.logRetentionHoursMap = Utils$.MODULE$.getTopicRetentionHours(Utils$.MODULE$.getString(props, "topic.log.retention.hours", ""));
        this.logRetentionSize = Utils$.MODULE$.getLong(props, "log.retention.size", -1L);
        this.logRetentionSizeMap = Utils$.MODULE$.getTopicRetentionSize(Utils$.MODULE$.getString(props, "topic.log.retention.size", ""));
        this.logCleanupIntervalMinutes = Utils$.MODULE$.getIntInRange(props, "log.cleanup.interval.mins", 10, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.enableZookeeper = Utils$.MODULE$.getBoolean(props, "enable.zookeeper", true);
        this.flushInterval = Utils$.MODULE$.getIntInRange(props, "log.flush.interval", 500, (Tuple2<Integer, Integer>)new Tuple2.mcII.sp(1, Integer.MAX_VALUE));
        this.flushIntervalMap = Utils$.MODULE$.getTopicFlushIntervals(Utils$.MODULE$.getString(props, "topic.flush.intervals.ms", ""));
        this.flushSchedulerThreadRate = Utils$.MODULE$.getInt(props, "log.default.flush.scheduler.interval.ms", 3000);
        this.defaultFlushIntervalMs = Utils$.MODULE$.getInt(props, "log.default.flush.interval.ms", this.flushSchedulerThreadRate());
        this.topicPartitionsMap = Utils$.MODULE$.getTopicPartitions(Utils$.MODULE$.getString(props, "topic.partition.count.map", ""));
    }
}

