/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ProducerRequest$;
import kafka.producer.ProducerConfig;
import kafka.producer.SyncProducer;
import kafka.producer.async.AsyncProducer$;
import kafka.producer.async.AsyncProducerConfig;
import kafka.producer.async.AsyncProducerInterruptedException;
import kafka.producer.async.AsyncProducerStats$;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.producer.async.QueueClosedException;
import kafka.producer.async.QueueFullException;
import kafka.producer.async.QueueItem;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}w!B\u0001\u0003\u0011\u000bI\u0011!D!ts:\u001c\u0007K]8ek\u000e,'O\u0003\u0002\u0004\t\u0005)\u0011m]=oG*\u0011QAB\u0001\taJ|G-^2fe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)YQ\"\u0001\u0002\u0007\u00111\u0011A\u0011!A\t\u00065\u0011Q\"Q:z]\u000e\u0004&o\u001c3vG\u0016\u00148cA\u0006\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000f\f\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u001d\u00013B1A\u0005\u0002\u0005\n\u0001b\u00155vi\u0012|wO\\\u000b\u0002\u001d!11e\u0003Q\u0001\n9\t\u0011b\u00155vi\u0012|wO\u001c\u0011\t\u000f\u0015Z!\u0019!C\u0001M\u00051!+\u00198e_6,\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003UI\tA!\u001e;jY&\u0011A&\u000b\u0002\u0007%\u0006tGm\\7\t\r9Z\u0001\u0015!\u0003(\u0003\u001d\u0011\u0016M\u001c3p[\u0002Bq\u0001M\u0006C\u0002\u0013\u0005\u0011'A\tQe>$WoY3s\u001b\n+\u0017M\u001c(b[\u0016,\u0012A\r\t\u0003\u001fMJ!\u0001\u000e\t\u0003\rM#(/\u001b8h\u0011\u001914\u0002)A\u0005e\u0005\u0011\u0002K]8ek\u000e,'/\u0014\"fC:t\u0015-\\3!\u0011\u001dA4B1A\u0005\u0002E\n!\u0004\u0015:pIV\u001cWM])vKV,7+\u001b>f\u001b\n+\u0017M\u001c(b[\u0016DaAO\u0006!\u0002\u0013\u0011\u0014a\u0007)s_\u0012,8-\u001a:Rk\u0016,XmU5{K6\u0013U-\u00198OC6,\u0007\u0005C\u0004=\u0017E\u0005I\u0011A\u001f\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011ah\u0013\u0016\u0003\u007f\t\u0003\"a\u0006!\n\u0005\u0005C\"\u0001\u0002(vY2\\\u0013a\u0011\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!C\u0012AC1o]>$\u0018\r^5p]&\u0011!*\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0001\u0003'<\t\u0003\u0005)\u0019A'\u0003\u0003Q\u000b\"AT)\u0011\u0005]y\u0015B\u0001)\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u0006*\n\u0005MC\"aA!os\"9QkCI\u0001\n\u00031\u0016AD5oSR$C-\u001a4bk2$H%N\u000b\u0003/nS#\u0001\u0017\"\u0011\u0005!J\u0016B\u0001.*\u0005)\u0001&o\u001c9feRLWm\u001d\u0003\t\u0019R#\t\u0011!b\u0001\u001b\"9QlCI\u0001\n\u0003q\u0016AD5oSR$C-\u001a4bk2$HEN\u000b\u0003}}#\u0001\u0002\u0014/\u0005\u0002\u0003\u0015\r!\u0014\u0005\bC.\t\n\u0011\"\u0001c\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uI]*\"aV2\u0005\u00111\u0003G\u0011!AC\u000253Q\u0001\u0004\u0002\u0001\r\u0015,2AZA\u0001'\u0011!gb\u001a\f\u0011\u0005!\\W\"A5\u000b\u0005)4\u0011!B;uS2\u001c\u0018B\u00017j\u0005\u001daunZ4j]\u001eD\u0001B\u001c3\u0003\u0002\u0003\u0006Ia\\\u0001\u0007G>tg-[4\u0011\u0005)\u0001\u0018BA9\u0003\u0005M\t5/\u001f8d!J|G-^2fe\u000e{gNZ5h\u0011!)AM!A!\u0002\u0013\u0019\bC\u0001;v\u001b\u0005!\u0011B\u0001<\u0005\u00051\u0019\u0016P\\2Qe>$WoY3s\u0011!AHM!A!\u0002\u0013I\u0018AC:fe&\fG.\u001b>feB\u0019!\u0010 @\u000e\u0003mT!\u0001\u001f\u0004\n\u0005u\\(aB#oG>$WM\u001d\t\u0004\u007f\u0006\u0005A\u0002\u0001\u0003\t\u0019\u0012$\t\u0011!b\u0001\u001b\"Q\u0011Q\u00013\u0003\u0002\u0003\u0006I!a\u0002\u0002\u0019\u00154XM\u001c;IC:$G.\u001a:\u0011\t)\tIA`\u0005\u0004\u0003\u0017\u0011!\u0001D#wK:$\b*\u00198eY\u0016\u0014\b\"CA\bI\n\u0005\t\u0015!\u0003Y\u0003E)g/\u001a8u\u0011\u0006tG\r\\3s!J|\u0007o\u001d\u0005\u000b\u0003'!'\u0011!Q\u0001\n\u0005U\u0011AC2cW\"\u000bg\u000e\u001a7feB!!\"a\u0006\u007f\u0013\r\tIB\u0001\u0002\u0010\u0007\u0006dGNY1dW\"\u000bg\u000e\u001a7fe\"I\u0011Q\u00043\u0003\u0002\u0003\u0006I\u0001W\u0001\u0010G\n\\\u0007*\u00198eY\u0016\u0014\bK]8qg\"1Q\u0004\u001aC\u0001\u0003C!\u0002#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u0011\u0007)!g\u0010\u0003\u0004o\u0003?\u0001\ra\u001c\u0005\u0007\u000b\u0005}\u0001\u0019A:\t\ra\fy\u00021\u0001z\u0011)\t)!a\b\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003\u001f\ty\u0002%AA\u0002aC!\"a\u0005\u0002 A\u0005\t\u0019AA\u000b\u0011%\ti\"a\b\u0011\u0002\u0003\u0007\u0001\fC\u0005\u00026\u0011\u0014\r\u0011\"\u0003\u00028\u000511\r\\8tK\u0012,\"!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u00051\u0011\r^8nS\u000eT1!a\u0011*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u000f\niDA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\t\u0003\u0017\"\u0007\u0015!\u0003\u0002:\u000591\r\\8tK\u0012\u0004\u0003\"CA(I\n\u0007I\u0011BA)\u0003\u0015\tX/Z;f+\t\t\u0019\u0006\u0005\u0004\u0002V\u0005]\u00131L\u0007\u0003\u0003\u0003JA!!\u0017\u0002B\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB!!\"!\u0018\u007f\u0013\r\tyF\u0001\u0002\n#V,W/Z%uK6D\u0001\"a\u0019eA\u0003%\u00111K\u0001\u0007cV,W/\u001a\u0011\t\u0013\u0005\u001dDM1A\u0005\n\u0005%\u0014aD1ts:\u001c\u0007K]8ek\u000e,'/\u0013#\u0016\u0005\u0005-\u0004cA\f\u0002n%\u0019\u0011q\u000e\r\u0003\u0007%sG\u000f\u0003\u0005\u0002t\u0011\u0004\u000b\u0011BA6\u0003A\t7/\u001f8d!J|G-^2fe&#\u0005\u0005C\u0005\u0002x\u0011\u0014\r\u0011\"\u0003\u0002z\u0005Q1/\u001a8e)\"\u0014X-\u00193\u0016\u0005\u0005m\u0004\u0003\u0002\u0006\u0002~yL1!a \u0003\u0005I\u0001&o\u001c3vG\u0016\u00148+\u001a8e)\"\u0014X-\u00193\t\u0011\u0005\rE\r)A\u0005\u0003w\n1b]3oIRC'/Z1eA!1Q\u0004\u001aC\u0001\u0003\u000f#B!a\t\u0002\n\"1a.!\"A\u0002=Dq!!$e\t\u0003\ty)A\u0003ti\u0006\u0014H/\u0006\u0002\u0002\u0012B\u0019q#a%\n\u0007\u0005U\u0005D\u0001\u0003V]&$\bbBAMI\u0012\u0005\u00111T\u0001\u0005g\u0016tG\r\u0006\u0004\u0002\u0012\u0006u\u0015Q\u0016\u0005\t\u0003?\u000b9\n1\u0001\u0002\"\u0006)Ao\u001c9jGB!\u00111UAU\u001d\r9\u0012QU\u0005\u0004\u0003OC\u0012A\u0002)sK\u0012,g-C\u00025\u0003WS1!a*\u0019\u0011\u001d\ty+a&A\u0002y\fQ!\u001a<f]RDq!!'e\t\u0003\t\u0019\f\u0006\u0005\u0002\u0012\u0006U\u0016qWA]\u0011!\ty*!-A\u0002\u0005\u0005\u0006bBAX\u0003c\u0003\rA \u0005\t\u0003w\u000b\t\f1\u0001\u0002l\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003\u007f#G\u0011AAH\u0003\u0015\u0019Gn\\:f\u0011\u001d\t\u0019\r\u001aC\u0001\u0003\u000b\fab]3u\u0019><w-\u001a:MKZ,G\u000e\u0006\u0003\u0002\u0012\u0006\u001d\u0007\u0002CAe\u0003\u0003\u0004\r!a3\u0002\u000b1,g/\u001a7\u0011\t\u00055\u00171\\\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006)An\\45U*!\u0011Q[Al\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011\\\u0001\u0004_J<\u0017\u0002BAo\u0003\u001f\u0014Q\u0001T3wK2\u0004")
public class AsyncProducer<T>
implements Logging,
ScalaObject {
    private final AsyncProducerConfig config;
    private final SyncProducer producer;
    private final CallbackHandler<T> cbkHandler;
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue kafka$producer$async$AsyncProducer$$queue;
    private final int kafka$producer$async$AsyncProducer$$asyncProducerID;
    private final ProducerSendThread<T> sendThread;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Properties init$default$7() {
        return AsyncProducer$.MODULE$.init$default$7();
    }

    public static final Null$ init$default$6() {
        return AsyncProducer$.MODULE$.init$default$6();
    }

    public static final Properties init$default$5() {
        return AsyncProducer$.MODULE$.init$default$5();
    }

    public static final Null$ init$default$4() {
        return AsyncProducer$.MODULE$.init$default$4();
    }

    public static final String ProducerQueueSizeMBeanName() {
        return AsyncProducer$.MODULE$.ProducerQueueSizeMBeanName();
    }

    public static final String ProducerMBeanName() {
        return AsyncProducer$.MODULE$.ProducerMBeanName();
    }

    public static final Random Random() {
        return AsyncProducer$.MODULE$.Random();
    }

    public static final Object Shutdown() {
        return AsyncProducer$.MODULE$.Shutdown();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        AsyncProducer asyncProducer = this;
        synchronized (asyncProducer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public final LinkedBlockingQueue kafka$producer$async$AsyncProducer$$queue() {
        return this.kafka$producer$async$AsyncProducer$$queue;
    }

    public final int kafka$producer$async$AsyncProducer$$asyncProducerID() {
        return this.kafka$producer$async$AsyncProducer$$asyncProducerID;
    }

    private ProducerSendThread<T> sendThread() {
        return this.sendThread;
    }

    public AsyncProducer(AsyncProducerConfig config) {
        this(config, new SyncProducer(config), (Encoder)Utils$.MODULE$.getObject(config.serializerClass()), (EventHandler)Utils$.MODULE$.getObject(config.eventHandler()), config.eventHandlerProps(), (CallbackHandler)Utils$.MODULE$.getObject(config.cbkHandler()), config.cbkHandlerProps());
    }

    public void start() {
        this.sendThread().start();
    }

    public void send(String topic, T event) {
        this.send(topic, event, ProducerRequest$.MODULE$.RandomPartition());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String topic, T event, int partition) {
        boolean bl;
        int n;
        AsyncProducerStats$.MODULE$.recordEvent();
        if (this.closed().get()) {
            throw new QueueClosedException("Attempt to add event to a closed queue.");
        }
        QueueItem<T> data = new QueueItem<T>(event, topic, partition);
        if (this.cbkHandler != null) {
            data = this.cbkHandler.beforeEnqueue(data);
        }
        if ((n = this.config.enqueueTimeoutMs()) == 0) {
            bl = this.kafka$producer$async$AsyncProducer$$queue().offer(data);
        } else {
            boolean exceptionResult1 = false;
            try {
                boolean bl2;
                boolean bl3;
                boolean bl4 = bl3 = this.config.enqueueTimeoutMs() < 0;
                if (bl3) {
                    this.kafka$producer$async$AsyncProducer$$queue().put(data);
                    bl2 = true;
                } else {
                    bl2 = this.kafka$producer$async$AsyncProducer$$queue().offer(data, this.config.enqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                }
                bl = exceptionResult1 = bl2;
            }
            catch (InterruptedException interruptedException) {
                String msg$1 = Predef$.MODULE$.augmentString("%s interrupted during enqueue of event %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), event.toString()}));
                this.error((Function0<String>)new $anonfun$3(this, msg$1));
                throw new AsyncProducerInterruptedException(msg$1);
            }
        }
        boolean added = bl;
        if (this.cbkHandler != null) {
            this.cbkHandler.afterEnqueue(data, added);
        }
        if (!added) {
            AsyncProducerStats$.MODULE$.recordDroppedEvents();
            this.logger().error((Object)new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
            throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)event.toString()).toString());
        }
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((Object)new StringBuilder().append((Object)"Added event to send queue for topic: ").append((Object)topic).append((Object)", partition: ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)":").append((Object)event.toString()).toString());
            this.logger().trace((Object)new StringBuilder().append((Object)"Remaining queue size: ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$producer$async$AsyncProducer$$queue().remainingCapacity())).toString());
        }
    }

    public void close() {
        if (this.cbkHandler != null) {
            this.cbkHandler.close();
            this.logger().info((Object)"Closed the callback handler");
        }
        this.closed().set(true);
        this.kafka$producer$async$AsyncProducer$$queue().put(new QueueItem<Object>(AsyncProducer$.MODULE$.Shutdown(), null, -1));
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((Object)"Added shutdown command to the queue");
        }
        this.sendThread().shutdown();
        this.sendThread().awaitShutdown();
        this.producer.close();
        this.logger().info((Object)"Closed AsyncProducer");
    }

    public void setLoggerLevel(Level level) {
        this.logger().setLevel(level);
    }

    public AsyncProducer(AsyncProducerConfig config, SyncProducer producer, Encoder<T> serializer, EventHandler<T> eventHandler, Properties eventHandlerProps, CallbackHandler<T> cbkHandler, Properties cbkHandlerProps) {
        this.config = config;
        this.producer = producer;
        this.cbkHandler = cbkHandler;
        Logging$class.$init$(this);
        this.closed = new AtomicBoolean(false);
        this.kafka$producer$async$AsyncProducer$$queue = new LinkedBlockingQueue(config.queueSize());
        if (eventHandler != null) {
            eventHandler.init(eventHandlerProps);
        }
        if (cbkHandler != null) {
            cbkHandler.init(cbkHandlerProps);
        }
        this.kafka$producer$async$AsyncProducer$$asyncProducerID = AsyncProducer$.MODULE$.Random().nextInt();
        this.sendThread = new ProducerSendThread<T>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$producer$async$AsyncProducer$$asyncProducerID())).toString(), this.kafka$producer$async$AsyncProducer$$queue(), serializer, producer, eventHandler == null ? new DefaultEventHandler<T>(new ProducerConfig(config.props()), cbkHandler) : eventHandler, cbkHandler, config.queueTime(), config.batchSize(), AsyncProducer$.MODULE$.Shutdown());
        this.sendThread().setDaemon(false);
        Utils$.MODULE$.swallow((Function2<Object, Throwable, Object>)new $anonfun$2(this), (Function0<Object>)new $anonfun$1(this));
    }
}

