/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.FileMessageSet$;
import kafka.message.LogFlushStats$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001d\u0019KG.Z'fgN\fw-Z*fi*\u00111\u0001B\u0001\b[\u0016\u001c8/Y4f\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!a!\u0003\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\tQQ*Z:tC\u001e,7+\u001a;\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011!B;uS2\u001c\u0018BA\t\u000f\u0005\u001daunZ4j]\u001e\u0004\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u00111bU2bY\u0006|%M[3di\"I\u0011\u0004\u0001BC\u0002\u0013\u0005!AG\u0001\bG\"\fgN\\3m+\u0005Y\u0002C\u0001\u000f$\u001b\u0005i\"B\u0001\u0010 \u0003!\u0019\u0007.\u00198oK2\u001c(B\u0001\u0011\"\u0003\rq\u0017n\u001c\u0006\u0002E\u0005!!.\u0019<b\u0013\t!SDA\u0006GS2,7\t[1o]\u0016d\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0011\u0002\u000b\u0001\u0003\u0006\u0004%\tAA\u0015\u0002\r=4gm]3u+\u0005Q\u0003CA\n,\u0013\taCC\u0001\u0003M_:<\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u000f=4gm]3uA!I\u0001\u0007\u0001BC\u0002\u0013\u0005!!K\u0001\u0006Y&l\u0017\u000e\u001e\u0005\te\u0001\u0011\t\u0011)A\u0005U\u00051A.[7ji\u0002B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!N\u0001\b[V$\u0018M\u00197f+\u00051\u0004CA\n8\u0013\tADCA\u0004C_>dW-\u00198\t\u0011i\u0002!\u0011!Q\u0001\nY\n\u0001\"\\;uC\ndW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005Ya.Z3e%\u0016\u001cwN^3s+\u0005q\u0004CA G\u001b\u0005\u0001%BA!C\u0003\u0019\tGo\\7jG*\u00111\tR\u0001\u000bG>t7-\u001e:sK:$(BA#\"\u0003\u0011)H/\u001b7\n\u0005\u001d\u0003%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003?\u00031qW-\u001a3SK\u000e|g/\u001a:!\u0011\u0019Y\u0005\u0001\"\u0001\u0005\u0019\u00061A(\u001b8jiz\"b!\u0014(P!F\u0013\u0006CA\u0005\u0001\u0011\u0015I\"\n1\u0001\u001c\u0011\u0015A#\n1\u0001+\u0011\u0015\u0001$\n1\u0001+\u0011\u0015!$\n1\u00017\u0011\u0015a$\n1\u0001?\u0011\u001d!\u0006A1A\u0005\nU\u000bqa]3u'&TX-F\u0001W!\tyt+\u0003\u0002Y\u0001\nQ\u0011\t^8nS\u000eduN\\4\t\ri\u0003\u0001\u0015!\u0003W\u0003!\u0019X\r^*ju\u0016\u0004\u0003b\u0002/\u0001\u0005\u0004%I!V\u0001\u0011g\u0016$\b*[4i/\u0006$XM]'be.DaA\u0018\u0001!\u0002\u00131\u0016!E:fi\"Kw\r[,bi\u0016\u0014X*\u0019:lA!)1\n\u0001C\u0001AR\u0019Q*\u00192\t\u000bey\u0006\u0019A\u000e\t\u000bQz\u0006\u0019\u0001\u001c\t\u000b-\u0003A\u0011\u00013\u0015\u00075+W\u000eC\u0003gG\u0002\u0007q-\u0001\u0003gS2,\u0007C\u00015l\u001b\u0005I'B\u00016\"\u0003\tIw.\u0003\u0002mS\n!a)\u001b7f\u0011\u0015!4\r1\u00017\u0011\u0015Y\u0005\u0001\"\u0001p)\u0011i\u0005/\u001d:\t\u000beq\u0007\u0019A\u000e\t\u000bQr\u0007\u0019\u0001\u001c\t\u000bqr\u0007\u0019\u0001 \t\u000b-\u0003A\u0011\u0001;\u0015\t5+ho\u001e\u0005\u0006MN\u0004\ra\u001a\u0005\u0006iM\u0004\rA\u000e\u0005\u0006yM\u0004\rA\u0010\u0005\u0006s\u0002!\tA_\u0001\u0005e\u0016\fG\rF\u0002\twvDQ\u0001 =A\u0002)\n!B]3bI>3gm]3u\u0011\u0015q\b\u00101\u0001+\u0003\u0011\u0019\u0018N_3\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004\u00059qO]5uKR{Gc\u0002\u0016\u0002\u0006\u0005=\u00111\u0003\u0005\b\u0003\u000fy\b\u0019AA\u0005\u0003-!Wm\u001d;DQ\u0006tg.\u001a7\u0011\u0007q\tY!C\u0002\u0002\u000eu\u0011AcR1uQ\u0016\u0014\u0018N\\4CsR,7\t[1o]\u0016d\u0007BBA\t\u007f\u0002\u0007!&A\u0006xe&$Xm\u00144gg\u0016$\b\"\u0002@\u0000\u0001\u0004Q\u0003bBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\tSR,'/\u0019;peV\u0011\u00111\u0004\t\u0007\u0003;\ti#a\r\u000f\t\u0005}\u0011\u0011\u0006\b\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012bAA\u0016)\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003W!\u0002cA\u0005\u00026%\u0019\u0011q\u0007\u0002\u0003!5+7o]1hK\u0006sGm\u00144gg\u0016$\bbBA\u001e\u0001\u0011\u0005\u0011QH\u0001\fg&TX-\u00138CsR,7\u000fF\u0001+\u0011\u001d\t\t\u0005\u0001C\u0001\u0003{\tQ\u0002[5hQ^\u000bG/\u001a:NCJ\\\u0007bBA#\u0001\u0011\u0005\u0011qI\u0001\rG\",7m['vi\u0006\u0014G.\u001a\u000b\u0003\u0003\u0013\u00022aEA&\u0013\r\ti\u0005\u0006\u0002\u0005+:LG\u000fC\u0004\u0002R\u0001!\t!a\u0015\u0002\r\u0005\u0004\b/\u001a8e)\u0011\tI%!\u0016\t\u000f\u0005]\u0013q\na\u0001\u0011\u0005AQ.Z:tC\u001e,7\u000fC\u0004\u0002\\\u0001!\t!a\u0012\u0002\u000b\u0019dWo\u001d5\t\u000f\u0005}\u0003\u0001\"\u0001\u0002H\u0005)1\r\\8tK\"9\u00111\r\u0001\u0005\u0002\u0005u\u0012a\u0002:fG>4XM\u001d\u0005\b\u0003O\u0002A\u0011BA5\u0003=1\u0018\r\\5eCR,W*Z:tC\u001e,G#\u0003\u0016\u0002l\u00055\u0014\u0011OA;\u0011\u0019I\u0012Q\ra\u00017!9\u0011qNA3\u0001\u0004Q\u0013!B:uCJ$\bbBA:\u0003K\u0002\rAK\u0001\u0004Y\u0016t\u0007\u0002CA<\u0003K\u0002\r!!\u001f\u0002\r\t,hMZ3s!\u0011\tY(! \u000e\u0003}I1!a  \u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0015\u0004\u0001\u0005\r\u0005cA\u0007\u0002\u0006&\u0019\u0011q\u0011\b\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class FileMessageSet
extends MessageSet
implements Logging,
ScalaObject {
    private final FileChannel channel;
    private final long offset;
    private final long limit;
    private final boolean mutable;
    private final AtomicBoolean needRecover;
    private final AtomicLong setSize;
    private final AtomicLong setHighWaterMark;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileChannel channel() {
        return this.channel;
    }

    public long offset() {
        return this.offset;
    }

    public long limit() {
        return this.limit;
    }

    public boolean mutable() {
        return this.mutable;
    }

    public AtomicBoolean needRecover() {
        return this.needRecover;
    }

    private AtomicLong setSize() {
        return this.setSize;
    }

    private AtomicLong setHighWaterMark() {
        return this.setHighWaterMark;
    }

    public FileMessageSet(FileChannel channel, boolean mutable) {
        this(channel, 0L, Long.MAX_VALUE, mutable, new AtomicBoolean(false));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable);
    }

    public FileMessageSet(FileChannel channel, boolean mutable, AtomicBoolean needRecover) {
        this(channel, 0L, Long.MAX_VALUE, mutable, needRecover);
    }

    public FileMessageSet(File file, boolean mutable, AtomicBoolean needRecover) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable, needRecover);
    }

    public MessageSet read(long readOffset, long size2) {
        return new FileMessageSet(this.channel(), this.offset() + readOffset, package$.MODULE$.min(this.offset() + readOffset + size2, this.highWaterMark()), false, new AtomicBoolean(false));
    }

    @Override
    public long writeTo(GatheringByteChannel destChannel, long writeOffset, long size2) {
        return this.channel().transferTo(this.offset() + writeOffset, package$.MODULE$.min(size2, this.sizeInBytes()), destChannel);
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return new $anon$1(this);
    }

    @Override
    public long sizeInBytes() {
        return this.setSize().get();
    }

    public long highWaterMark() {
        return this.setHighWaterMark().get();
    }

    public void checkMutable() {
        if (this.mutable()) {
            return;
        }
        throw new IllegalStateException("Attempt to invoke mutation on immutable message set.");
    }

    public void append(MessageSet messages) {
        long written;
        this.checkMutable();
        for (written = 0L; written < messages.sizeInBytes(); written += messages.writeTo(this.channel(), 0L, messages.sizeInBytes())) {
        }
        this.setSize().getAndAdd(written);
    }

    public void flush() {
        this.checkMutable();
        long startTime = SystemTime$.MODULE$.milliseconds();
        this.channel().force(true);
        long elapsedTime$1 = SystemTime$.MODULE$.milliseconds() - startTime;
        LogFlushStats$.MODULE$.recordFlushRequest(elapsedTime$1);
        this.debug((Function0<String>)new $anonfun$flush$1(this, elapsedTime$1));
        this.setHighWaterMark().set(this.sizeInBytes());
        this.debug((Function0<String>)new $anonfun$flush$2(this));
    }

    public void close() {
        if (this.mutable()) {
            this.flush();
        }
        this.channel().close();
    }

    public long recover() {
        this.checkMutable();
        long len = this.channel().size();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        long validUpTo = 0L;
        long next2 = 0L;
        do {
            if ((next2 = this.validateMessage(this.channel(), validUpTo, len, buffer)) < 0L) continue;
            validUpTo = next2;
        } while (next2 >= 0L);
        this.channel().truncate(validUpTo);
        this.setSize().set(validUpTo);
        this.setHighWaterMark().set(validUpTo);
        this.info((Function0<String>)new $anonfun$recover$1(this));
        this.channel().position(validUpTo);
        this.needRecover().set(false);
        return len - validUpTo;
    }

    private long validateMessage(FileChannel channel, long start, long len, ByteBuffer buffer) {
        buffer.rewind();
        int read2 = channel.read(buffer, start);
        if (read2 < 4) {
            return -1L;
        }
        int size2 = buffer.getInt(0);
        if (size2 < Message$.MODULE$.MinHeaderSize()) {
            return -1L;
        }
        long next2 = start + 4L + (long)size2;
        if (next2 > len) {
            return -1L;
        }
        ByteBuffer messageBuffer = ByteBuffer.allocate(size2);
        long curr = start + 4L;
        while (messageBuffer.hasRemaining()) {
            read2 = channel.read(messageBuffer, curr);
            if (read2 < 0) {
                throw new IllegalStateException("File size changed during recovery!");
            }
            curr += (long)read2;
        }
        messageBuffer.rewind();
        Message message = new Message(messageBuffer);
        if (message.isValid()) {
            return next2;
        }
        return -1L;
    }

    public FileMessageSet(FileChannel channel, long offset, long limit, boolean mutable, AtomicBoolean needRecover) {
        Object object;
        this.channel = channel;
        this.offset = offset;
        this.limit = limit;
        this.mutable = mutable;
        this.needRecover = needRecover;
        Logging$class.$init$(this);
        this.setSize = new AtomicLong();
        this.setHighWaterMark = new AtomicLong();
        if (mutable) {
            if (limit < Long.MAX_VALUE || offset > 0L) {
                throw new IllegalArgumentException("Attempt to open a mutable message set with a view or offset, which is not allowed.");
            }
            if (needRecover.get()) {
                long startMs$1 = System.currentTimeMillis();
                long truncated$1 = this.recover();
                this.info((Function0<String>)new $anonfun$1(this, startMs$1, truncated$1));
                object = BoxedUnit.UNIT;
            } else {
                this.setSize().set(channel.size());
                this.setHighWaterMark().set(this.sizeInBytes());
                object = channel.position(channel.size());
            }
        } else {
            this.setSize().set(package$.MODULE$.min(channel.size(), limit) - offset);
            this.setHighWaterMark().set(this.sizeInBytes());
            this.debug((Function0<String>)new $anonfun$2(this));
            object = BoxedUnit.UNIT;
        }
    }
}

