/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import kafka.api.OffsetRequest;
import kafka.common.InvalidPartitionException;
import kafka.common.InvalidTopicException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$kafka$log$LogManager$;
import kafka.log.LogManager$StopActor$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaZooKeeper;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0005h!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0003\u0007\u0005)aunZ'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0003\u0002\u0001\b\u001fU\u0001\"\u0001C\u0007\u000e\u0003%Q!AC\u0006\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0005!!.\u0019<b\u0013\tq\u0011B\u0001\u0004PE*,7\r\u001e\t\u0003!Mi\u0011!\u0005\u0006\u0003%\u0011\tQ!\u001e;jYNL!\u0001F\t\u0003\u000f1{wmZ5oOB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\tY1kY1mC>\u0013'.Z2u\u0011!a\u0002A!b\u0001\n\u0003q\u0012AB2p]\u001aLwm\u0001\u0001\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u000f\r|gNZ5hA!A\u0001\u0006\u0001BC\u0002\u0013%\u0011&A\u0005tG\",G-\u001e7feV\t!\u0006\u0005\u0002\u0011W%\u0011A&\u0005\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0011!q\u0003A!A!\u0002\u0013Q\u0013AC:dQ\u0016$W\u000f\\3sA!A\u0001\u0007\u0001BC\u0002\u0013%\u0011'\u0001\u0003uS6,W#\u0001\u001a\u0011\u0005A\u0019\u0014B\u0001\u001b\u0012\u0005\u0011!\u0016.\\3\t\u0011Y\u0002!\u0011!Q\u0001\nI\nQ\u0001^5nK\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!O\u0001\u0019Y><'k\u001c7m\t\u00164\u0017-\u001e7u\u0013:$XM\u001d<bY6\u001bX#\u0001\u001e\u0011\u0005YY\u0014B\u0001\u001f\u0018\u0005\u0011auN\\4\t\u0011y\u0002!\u0011!Q\u0001\ni\n\u0011\u0004\\8h%>dG\u000eR3gCVdG/\u00138uKJ4\u0018\r\\'tA!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011(\u0001\u000bm_\u001e\u001cE.Z1okBLe\u000e^3sm\u0006dWj\u001d\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005u\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002-1|wm\u00117fC:,\b\u000fR3gCVdG/Q4f\u001bND\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0018Y><7\t\\3b]V\u0004H)\u001a4bk2$\u0018iZ3Ng\u0002B\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\r]\u0016,GMU3d_Z,'/\u001f\t\u0003-)K!aS\f\u0003\u000f\t{w\u000e\\3b]\")Q\n\u0001C\u0001\u001d\u00061A(\u001b8jiz\"\u0002bT)S'R+fk\u0016\t\u0003!\u0002i\u0011A\u0001\u0005\u000691\u0003\ra\b\u0005\u0006Q1\u0003\rA\u000b\u0005\u0006a1\u0003\rA\r\u0005\u0006q1\u0003\rA\u000f\u0005\u0006\u00012\u0003\rA\u000f\u0005\u0006\t2\u0003\rA\u000f\u0005\u0006\u00112\u0003\r!\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0003\u0019awn\u001a#jeV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_\u0017\u0005\u0011\u0011n\\\u0005\u0003Av\u0013AAR5mK\"1!\r\u0001Q\u0001\nm\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004e\u0001\t\u0007I\u0011B3\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u00051\u0007C\u0001\fh\u0013\tAwCA\u0002J]RDaA\u001b\u0001!\u0002\u00131\u0017A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u00039awn\u001a$jY\u0016\u001c\u0016N_3NCB,\u0012A\u001c\t\u0005_J$h-D\u0001q\u0015\t\tx#\u0001\u0006d_2dWm\u0019;j_:L!a\u001d9\u0003\u00075\u000b\u0007\u000f\u0005\u0002vq:\u0011aC^\u0005\u0003o^\ta\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qo\u0006\u0005\u0007y\u0002\u0001\u000b\u0011\u00028\u0002\u001f1|wMR5mKNK'0Z'ba\u0002BqA \u0001C\u0002\u0013%Q-A\u0007gYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003g\u000391G.^:i\u0013:$XM\u001d<bY\u0002B\u0001\"!\u0002\u0001\u0005\u0004%I!\\\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8og6\u000b\u0007\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u00028\u0002'Q|\u0007/[2QCJ$\u0018\u000e^5p]Nl\u0015\r\u001d\u0011\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0011a\u00047pO\u000e\u0013X-\u0019;j_:dunY6\u0016\u0003\u001dAq!a\u0005\u0001A\u0003%q!\u0001\tm_\u001e\u001c%/Z1uS>tGj\\2lA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\u0007e\u0006tGm\\7\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u00052\"\u0001\u0003vi&d\u0017\u0002BA\u0013\u0003?\u0011aAU1oI>l\u0007\u0002CA\u0015\u0001\u0001\u0006I!a\u0007\u0002\u000fI\fg\u000eZ8nA!I\u0011Q\u0006\u0001A\u0002\u0013%\u0011qF\u0001\u000fW\u000647.\u0019.p_.,W\r]3s+\t\t\t\u0004E\u0002!\u0003gI1!!\u000e\"\u00059Y\u0015MZ6b5>|7*Z3qKJD\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\u0002%-\fgm[1[_>\\W-\u001a9fe~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002\u0017\u0003\u007fI1!!\u0011\u0018\u0005\u0011)f.\u001b;\t\u0015\u0005\u0015\u0013qGA\u0001\u0002\u0004\t\t$A\u0002yIEB\u0001\"!\u0013\u0001A\u0003&\u0011\u0011G\u0001\u0010W\u000647.\u0019.p_.,W\r]3sA!I\u0011Q\n\u0001A\u0002\u0013%\u0011qJ\u0001\bu.\f5\r^8s+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fF\u0001\u0007C\u000e$xN]:\n\t\u0005m\u0013Q\u000b\u0002\u0006\u0003\u000e$xN\u001d\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003C\n1B_6BGR|'o\u0018\u0013fcR!\u0011QHA2\u0011)\t)%!\u0018\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002R\u0005A!p[!di>\u0014\b\u0005C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002n\u0005a1\u000f^1siV\u0004H*\u0019;dQV\u0011\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA\u0010\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003s\n\u0019H\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0011\u0005u\u0004\u0001)A\u0005\u0003_\nQb\u001d;beR,\b\u000fT1uG\"\u0004\u0003\u0002CAA\u0001\t\u0007I\u0011B\u0015\u0002'1|wM\u00127vg\",'oU2iK\u0012,H.\u001a:\t\u000f\u0005\u0015\u0005\u0001)A\u0005U\u0005!Bn\\4GYV\u001c\b.\u001a:TG\",G-\u001e7fe\u0002B\u0001\"!#\u0001\u0005\u0004%I!\\\u0001\u0014Y><g\t\\;tQ&sG/\u001a:wC2l\u0015\r\u001d\u0005\b\u0003\u001b\u0003\u0001\u0015!\u0003o\u0003Qawn\u001a$mkND\u0017J\u001c;feZ\fG.T1qA!I\u0011\u0011\u0013\u0001C\u0002\u0013%\u00111S\u0001\u0014Y><'+\u001a;f]RLwN\\*ju\u0016l\u0015\r]\u000b\u0003\u0003+\u0003Ba\u001c:uu!A\u0011\u0011\u0014\u0001!\u0002\u0013\t)*\u0001\u000bm_\u001e\u0014V\r^3oi&|gnU5{K6\u000b\u0007\u000f\t\u0005\n\u0003;\u0003!\u0019!C\u0005\u0003'\u000b\u0011\u0003\\8h%\u0016$XM\u001c;j_:l5/T1q\u0011!\t\t\u000b\u0001Q\u0001\n\u0005U\u0015A\u00057pOJ+G/\u001a8uS>tWj]'ba\u0002B\u0011\"!*\u0001\u0005\u0004%I!a%\u0002\u00191|wMU8mY6\u001bX*\u00199\t\u0011\u0005%\u0006\u0001)A\u0005\u0003+\u000bQ\u0002\\8h%>dG.T:NCB\u0004\u0003\"CAW\u0001\t\u0007I\u0011BAX\u0003\u0011awnZ:\u0016\u0005\u0005E\u0006C\u0002\t\u00024R\f9,C\u0002\u00026F\u0011A\u0001U8pYB1\u0001#a-g\u0003s\u00032\u0001UA^\u0013\r\tiL\u0001\u0002\u0004\u0019><\u0007\u0002CAa\u0001\u0001\u0006I!!-\u0002\u000b1|wm\u001d\u0011\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005\u001d\u0017aB:vE\u0012K'o]\u000b\u0003\u0003\u0013\u0004BAFAf7&\u0019\u0011QZ\f\u0003\u000b\u0005\u0013(/Y=\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u0013\f\u0001b];c\t&\u00148\u000fI\u0004\b\u0003+\u0004\u0001RQAl\u0003%\u0019Fo\u001c9BGR|'\u000f\u0005\u0003\u0002Z\u0006mW\"\u0001\u0001\u0007\u0015\u0005u\u0007\u0001\"A\u0001\u0012\u000b\u000byNA\u0005Ti>\u0004\u0018i\u0019;peN1\u00111\\\u0004\u0016\u0003C\u00042AFAr\u0013\r\t)o\u0006\u0002\b!J|G-^2u\u0011\u001di\u00151\u001cC\u0001\u0003S$\"!a6\t\u0017\u00055\u00181\u001cC\u0001\u0002\u0013\u0015\u0013q^\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u001f\t\u0004\u0011\u0005M\u0018BA=\n\u0011-\t90a7\u0005\u0002\u0003%\t%!?\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0010\u0003\u0006\u0002~\u0006mG\u0011!A\u0005B\u0015\fA\u0002\u001d:pIV\u001cG/\u0011:jifD1B!\u0001\u0002\\\u0012\u0005\t\u0011\"\u0011\u0003\u0004\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0003\u0005\u0017\u00012A\u0006B\u0004\u0013\r\u0011Ia\u0006\u0002\u0004\u0003:L\b\"CA#\u0003\u007f\f\t\u00111\u0001g\u0011-\u0011y!a7\u0005\u0002\u0003%\tE!\u0005\u0002\u0011\r\fg.R9vC2$2!\u0013B\n\u0011)\t)E!\u0004\u0002\u0002\u0003\u0007!Q\u0001\u0005\f\u0005/\tY\u000e\"A\u0001\n#\u0011I\"A\u0006sK\u0006$'+Z:pYZ,G#A\u0004)\t\u0005m'Q\u0004\t\u0004-\t}\u0011b\u0001B\u0011/\ta1/\u001a:jC2L'0\u00192mK\"9!Q\u0005\u0001\u0005\n\t\u001d\u0012\u0001C4fi6\u001bX*\u00199\u0015\t\u0005U%\u0011\u0006\u0005\b\u0005W\u0011\u0019\u00031\u0001o\u0003!Aw.\u001e:t\u001b\u0006\u0004\bb\u0002B\u0018\u0001\u0011\u0005!\u0011G\u0001\bgR\f'\u000f^;q)\t\ti\u0004C\u0004\u00036\u0001!IA!\r\u0002\u0019\u0005<\u0018-\u001b;Ti\u0006\u0014H/\u001e9\t\u000f\te\u0002\u0001\"\u0003\u0003<\u0005!\"/Z4jgR,'OT3x)>\u0004\u0018nY%o5.#B!!\u0010\u0003>!9!q\bB\u001c\u0001\u0004!\u0018!\u0002;pa&\u001c\u0007b\u0002B\"\u0001\u0011%!QI\u0001\nGJ,\u0017\r^3M_\u001e$b!!/\u0003H\t%\u0003b\u0002B \u0005\u0003\u0002\r\u0001\u001e\u0005\b\u0005\u0017\u0012\t\u00051\u0001g\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0003P\u0001!IA!\u0015\u0002\u0015\u001d,G\u000fT8h!>|G\u000e\u0006\u0004\u00028\nM#Q\u000b\u0005\b\u0005\u007f\u0011i\u00051\u0001u\u0011\u001d\u0011YE!\u0014A\u0002\u0019DqA!\u0017\u0001\t\u0003\u0011Y&A\u000bdQ>|7/\u001a*b]\u0012|W\u000eU1si&$\u0018n\u001c8\u0015\u0007\u0019\u0014i\u0006C\u0004\u0003@\t]\u0003\u0019\u0001;\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d\u0005Qq-\u001a;PM\u001a\u001cX\r^:\u0015\t\t\u0015$q\r\t\u0005-\u0005-'\b\u0003\u0005\u0003j\t}\u0003\u0019\u0001B6\u00035ygMZ:fiJ+\u0017/^3tiB!!Q\u000eB:\u001b\t\u0011yGC\u0002\u0003r\u0011\t1!\u00199j\u0013\u0011\u0011)Ha\u001c\u0003\u001b=3gm]3u%\u0016\fX/Z:u\u0011\u001d\u0011I\b\u0001C\u0001\u0005w\naaZ3u\u0019><GCBA]\u0005{\u0012y\bC\u0004\u0003@\t]\u0004\u0019\u0001;\t\u000f\t-#q\u000fa\u0001M\"9!1\u0011\u0001\u0005\u0002\t\u0015\u0015AD4fi>\u00138I]3bi\u0016dun\u001a\u000b\u0007\u0003s\u00139I!#\t\u000f\t}\"\u0011\u0011a\u0001i\"9!1\nBA\u0001\u00041\u0007b\u0002BG\u0001\u0011%!qR\u0001\u000fI\u0016dW\r^3TK\u001elWM\u001c;t)\u00151'\u0011\u0013BJ\u0011\u001d\u0019!1\u0012a\u0001\u0003sC\u0001B!&\u0003\f\u0002\u0007!qS\u0001\tg\u0016<W.\u001a8ugB)qN!'\u0003\u001e&\u0019!1\u00149\u0003\u0007M+\u0017\u000fE\u0002Q\u0005?K1A!)\u0003\u0005)aunZ*fO6,g\u000e\u001e\u0005\b\u0005K\u0003A\u0011\u0002BT\u0003Y\u0019G.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001cHc\u00014\u0003*\"91Aa)A\u0002\u0005e\u0006b\u0002BW\u0001\u0011%!qV\u0001\u001eG2,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{KR\u0019aM!-\t\u000f\r\u0011Y\u000b1\u0001\u0002:\"9!Q\u0017\u0001\u0005\u0002\tE\u0012aC2mK\u0006tW\u000f\u001d'pONDqA!/\u0001\t\u0003\u0011\t$A\u0003dY>\u001cX\rC\u0004\u0003>\u0002!IAa0\u0002\u001d\u001d,G\u000fT8h\u0013R,'/\u0019;peR\u0011!\u0011\u0019\t\u0006_\n\r\u0017\u0011X\u0005\u0004\u0005\u000b\u0004(\u0001C%uKJ\fGo\u001c:\t\u000f\t%\u0007\u0001\"\u0003\u00032\u0005aa\r\\;tQ\u0006cG\u000eT8hg\"9!Q\u001a\u0001\u0005\u0002\t=\u0017\u0001D4fi\u0006cG\u000eV8qS\u000e\u001cHC\u0001Bi!\u0011y'1\u0019;\t\u000f\tU\u0007\u0001\"\u0001\u0003X\u0006)r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t\u001b\u0006\u0004H#\u00018)\u0007\u0001\u0011Y\u000eE\u0002\u0011\u0005;L1Aa8\u0012\u0005)!\bN]3bIN\fg-\u001a")
public class LogManager
implements Logging,
ScalaObject {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time kafka$log$LogManager$$time;
    private final long logRollDefaultIntervalMs;
    private final long logCleanupIntervalMs;
    private final long logCleanupDefaultAgeMs;
    public final boolean kafka$log$LogManager$$needRecovery;
    private final File logDir;
    private final int kafka$log$LogManager$$numPartitions;
    private final Map kafka$log$LogManager$$logFileSizeMap;
    private final int kafka$log$LogManager$$flushInterval;
    private final Map kafka$log$LogManager$$topicPartitionsMap;
    private final Object logCreationLock;
    private final Random random;
    private KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper;
    private Actor zkActor;
    private final CountDownLatch startupLatch;
    private final KafkaScheduler logFlusherScheduler;
    private final Map kafka$log$LogManager$$logFlushIntervalMap;
    private final Map<String, Long> logRetentionSizeMap;
    private final Map<String, Long> logRetentionMsMap;
    private final Map kafka$log$LogManager$$logRollMsMap;
    private final Pool kafka$log$LogManager$$logs;
    private final File[] subDirs;
    private /* synthetic */ LogManager$StopActor$ StopActor$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public long logRollDefaultIntervalMs() {
        return this.logRollDefaultIntervalMs;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public long logCleanupDefaultAgeMs() {
        return this.logCleanupDefaultAgeMs;
    }

    public File logDir() {
        return this.logDir;
    }

    public final int kafka$log$LogManager$$numPartitions() {
        return this.kafka$log$LogManager$$numPartitions;
    }

    public final Map kafka$log$LogManager$$logFileSizeMap() {
        return this.kafka$log$LogManager$$logFileSizeMap;
    }

    public final int kafka$log$LogManager$$flushInterval() {
        return this.kafka$log$LogManager$$flushInterval;
    }

    public final Map kafka$log$LogManager$$topicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Random random() {
        return this.random;
    }

    public final KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper() {
        return this.kafka$log$LogManager$$kafkaZookeeper;
    }

    private void kafka$log$LogManager$$kafkaZookeeper_$eq(KafkaZooKeeper kafkaZooKeeper) {
        this.kafka$log$LogManager$$kafkaZookeeper = kafkaZooKeeper;
    }

    private Actor zkActor() {
        return this.zkActor;
    }

    private void zkActor_$eq(Actor actor) {
        this.zkActor = actor;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private KafkaScheduler logFlusherScheduler() {
        return this.logFlusherScheduler;
    }

    public final Map kafka$log$LogManager$$logFlushIntervalMap() {
        return this.kafka$log$LogManager$$logFlushIntervalMap;
    }

    private Map<String, Long> logRetentionSizeMap() {
        return this.logRetentionSizeMap;
    }

    private Map<String, Long> logRetentionMsMap() {
        return this.logRetentionMsMap;
    }

    public final Map kafka$log$LogManager$$logRollMsMap() {
        return this.kafka$log$LogManager$$logRollMsMap;
    }

    public final Pool kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    public File[] subDirs() {
        return this.subDirs;
    }

    public final LogManager$StopActor$ StopActor() {
        if (this.StopActor$module == null) {
            this.StopActor$module = new LogManager$StopActor$(this);
        }
        return this.StopActor$module;
    }

    private Map<String, Long> getMsMap(Map<String, Integer> hoursMap) {
        ObjectRef ret$1 = new ObjectRef((Object)new HashMap());
        hoursMap.foreach((Function1)new $anonfun$getMsMap$1(this, ret$1));
        return (HashMap)ret$1.elem;
    }

    public void startup() {
        if (this.config().enableZookeeper()) {
            this.kafka$log$LogManager$$kafkaZookeeper().registerBrokerInZk();
            this.getAllTopics().foreach((Function1)new $anonfun$startup$2(this));
            this.startupLatch().countDown();
        }
        this.info((Function0<String>)new $anonfun$startup$3(this));
        this.logFlusherScheduler().scheduleWithRate((Function0<Object>)new $anonfun$startup$1(this), this.config().flushSchedulerThreadRate(), this.config().flushSchedulerThreadRate());
    }

    private void awaitStartup() {
        if (this.config().enableZookeeper()) {
            this.startupLatch().await();
        }
    }

    private void registerNewTopicInZK(String topic) {
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)topic);
        }
    }

    private Log createLog(String topic, int partition) {
        Object object = this.logCreationLock();
        synchronized (object) {
            File d = new File(this.logDir(), new StringBuilder().append((Object)topic).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
            d.mkdirs();
            long rollIntervalMs = BoxesRunTime.unboxToLong((Object)this.kafka$log$LogManager$$logRollMsMap().get((Object)topic).getOrElse((Function0)new $anonfun$4(this)));
            int maxLogFileSize = BoxesRunTime.unboxToInt((Object)this.kafka$log$LogManager$$logFileSizeMap().get((Object)topic).getOrElse((Function0)new $anonfun$5(this)));
            Log log = new Log(d, this.kafka$log$LogManager$$time(), maxLogFileSize, this.config().maxMessageSize(), this.kafka$log$LogManager$$flushInterval(), rollIntervalMs, false);
            return log;
        }
    }

    private Pool<Integer, Log> getLogPool(String topic$1, int partition$1) {
        this.awaitStartup();
        if (topic$1.length() <= 0) {
            throw new InvalidTopicException("topic name can't be empty");
        }
        if (partition$1 < 0 || partition$1 >= BoxesRunTime.unboxToInt((Object)this.kafka$log$LogManager$$topicPartitionsMap().getOrElse((Object)topic$1, (Function0)new $anonfun$getLogPool$1(this)))) {
            this.warn((Function0<String>)new $anonfun$getLogPool$2(this, topic$1, partition$1));
            throw new InvalidPartitionException(new StringBuilder().append((Object)"wrong partition ").append((Object)BoxesRunTime.boxToInteger((int)partition$1)).toString());
        }
        return (Pool)this.kafka$log$LogManager$$logs().get(topic$1);
    }

    public int chooseRandomPartition(String topic) {
        return this.random().nextInt(BoxesRunTime.unboxToInt((Object)this.kafka$log$LogManager$$topicPartitionsMap().getOrElse((Object)topic, (Function0)new $anonfun$chooseRandomPartition$1(this))));
    }

    public long[] getOffsets(OffsetRequest offsetRequest) {
        Log log = this.getLog(offsetRequest.topic(), offsetRequest.partition());
        if (log == null) {
            return Log$.MODULE$.getEmptyOffsets(offsetRequest);
        }
        return log.getOffsetsBefore(offsetRequest);
    }

    public Log getLog(String topic, int partition) {
        Pool<Integer, Log> parts = this.getLogPool(topic, partition);
        if (parts == null) {
            return null;
        }
        return parts.get(BoxesRunTime.boxToInteger((int)partition));
    }

    public Log getOrCreateLog(String topic$2, int partition$2) {
        Log log;
        boolean hasNewTopic = false;
        Pool parts = this.getLogPool(topic$2, partition$2);
        if (parts == null) {
            Pool found = this.kafka$log$LogManager$$logs().putIfNotExists(topic$2, new Pool());
            if (found == null) {
                hasNewTopic = true;
            }
            parts = (Pool)this.kafka$log$LogManager$$logs().get(topic$2);
        }
        if ((log = parts.get((Integer)BoxesRunTime.boxToInteger((int)partition$2))) == null) {
            log = this.createLog(topic$2, partition$2);
            Log found = parts.putIfNotExists(BoxesRunTime.boxToInteger((int)partition$2), log);
            if (found == null) {
                this.info((Function0<String>)new $anonfun$getOrCreateLog$1(this, topic$2, partition$2));
            } else {
                log.close();
                log = found;
            }
        }
        if (hasNewTopic) {
            this.registerNewTopicInZK(topic$2);
        }
        return log;
    }

    private int deleteSegments(Log log$2, Seq<LogSegment> segments) {
        IntRef total$1 = new IntRef(0);
        segments.foreach((Function1)new $anonfun$deleteSegments$1(this, log$2, total$1));
        return total$1.elem;
    }

    private int cleanupExpiredSegments(Log log) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        String topic = (String)Utils$.MODULE$.getTopicPartition(log.dir().getName())._1();
        long logCleanupThresholdMS$1 = BoxesRunTime.unboxToLong((Object)this.logRetentionMsMap().get((Object)topic).getOrElse((Function0)new $anonfun$6(this)));
        Seq<LogSegment> toBeDeleted = log.markDeletedWhile((Function1<LogSegment, Boolean>)new $anonfun$11(this, startMs$1, logCleanupThresholdMS$1));
        int total = this.deleteSegments(log, toBeDeleted);
        return total;
    }

    private int cleanupSegmentsToMaintainSize(Log log) {
        String topic = (String)Utils$.MODULE$.getTopicPartition(log.dir().getName())._1();
        long maxLogRetentionSize = BoxesRunTime.unboxToLong((Object)this.logRetentionSizeMap().get((Object)topic).getOrElse((Function0)new $anonfun$7(this)));
        if (maxLogRetentionSize < 0L || log.size() < maxLogRetentionSize) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log.size() - maxLogRetentionSize);
        Seq<LogSegment> toBeDeleted = log.markDeletedWhile((Function1<LogSegment, Boolean>)new $anonfun$12(this, diff$1));
        int total = this.deleteSegments(log, toBeDeleted);
        return total;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new $anonfun$cleanupLogs$1(this));
        Iterator<Log> iter = this.getLogIterator();
        IntRef total$2 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        while (iter.hasNext()) {
            Log log$3 = (Log)iter.next();
            this.debug((Function0<String>)new $anonfun$cleanupLogs$2(this, log$3));
            total$2.elem += this.cleanupExpiredSegments(log$3) + this.cleanupSegmentsToMaintainSize(log$3);
        }
        this.debug((Function0<String>)new $anonfun$cleanupLogs$3(this, total$2, startMs$2));
    }

    public void close() {
        this.logFlusherScheduler().shutdown();
        Iterator<Log> iter = this.getLogIterator();
        while (iter.hasNext()) {
            ((Log)iter.next()).close();
        }
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)this.StopActor());
            this.kafka$log$LogManager$$kafkaZookeeper().close();
        }
    }

    private Iterator<Log> getLogIterator() {
        return new $anon$2(this);
    }

    public final void kafka$log$LogManager$$flushAllLogs() {
        this.debug((Function0<String>)new $anonfun$kafka$log$LogManager$$flushAllLogs$1(this));
        this.getLogIterator().foreach((Function1)new $anonfun$kafka$log$LogManager$$flushAllLogs$2(this));
    }

    public Iterator<String> getAllTopics() {
        return this.kafka$log$LogManager$$logs().keys().iterator();
    }

    public Map<String, Integer> getTopicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap();
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig config, KafkaScheduler scheduler, Time time, long logRollDefaultIntervalMs, long logCleanupIntervalMs, long logCleanupDefaultAgeMs, boolean needRecovery) {
        Object object;
        this.config = config;
        this.scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        this.logRollDefaultIntervalMs = logRollDefaultIntervalMs;
        this.logCleanupIntervalMs = logCleanupIntervalMs;
        this.logCleanupDefaultAgeMs = logCleanupDefaultAgeMs;
        this.kafka$log$LogManager$$needRecovery = needRecovery;
        Logging$class.$init$(this);
        this.logDir = new File(config.logDir());
        this.kafka$log$LogManager$$numPartitions = config.numPartitions();
        this.kafka$log$LogManager$$logFileSizeMap = config.logFileSizeMap();
        this.kafka$log$LogManager$$flushInterval = config.flushInterval();
        this.kafka$log$LogManager$$topicPartitionsMap = config.topicPartitionsMap();
        this.logCreationLock = new Object();
        this.random = new Random();
        this.kafka$log$LogManager$$kafkaZookeeper = null;
        this.zkActor = null;
        this.startupLatch = config.enableZookeeper() ? new CountDownLatch(1) : null;
        this.logFlusherScheduler = new KafkaScheduler(1, "kafka-logflusher-", false);
        this.kafka$log$LogManager$$logFlushIntervalMap = config.flushIntervalMap();
        this.logRetentionSizeMap = config.logRetentionSizeMap();
        this.logRetentionMsMap = this.getMsMap(config.logRetentionHoursMap());
        this.kafka$log$LogManager$$logRollMsMap = this.getMsMap(config.logRollHoursMap());
        this.kafka$log$LogManager$$logs = new Pool();
        if (this.logDir().exists()) {
            object = BoxedUnit.UNIT;
        } else {
            this.info((Function0<String>)new $anonfun$8(this));
            object = BoxesRunTime.boxToBoolean((boolean)this.logDir().mkdirs());
        }
        if (this.logDir().isDirectory() && this.logDir().canRead()) {
            BoxedUnit boxedUnit;
            Object object2;
            this.subDirs = this.logDir().listFiles();
            if (this.subDirs() != null) {
                Predef$.MODULE$.refArrayOps((Object[])this.subDirs()).foreach((Function1)new $anonfun$9(this));
            }
            if (scheduler == null) {
                object2 = BoxedUnit.UNIT;
            } else {
                this.info((Function0<String>)new $anonfun$10(this));
                object2 = scheduler.scheduleWithRate((Function0<Object>)new $anonfun$3(this), 60000L, logCleanupIntervalMs);
            }
            if (config.enableZookeeper()) {
                this.kafka$log$LogManager$$kafkaZookeeper_$eq(new KafkaZooKeeper(config, this));
                this.kafka$log$LogManager$$kafkaZookeeper().startup();
                this.zkActor_$eq(new $anon$1(this));
                boxedUnit = this.zkActor().start();
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
    }
}

