/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.common.ErrorMapping$;
import kafka.consumer.ConsumerTopicStat$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo$;
import kafka.message.ByteBufferMessageSet;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-c!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0002\u0007\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u0010+A\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u0005)Q\u000f^5mg&\u0011A#\u0005\u0002\b\u0019><w-\u001b8h!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011q\u0001!Q1A\u0005\u0002y\tQ\u0001^8qS\u000e\u001c\u0001!F\u0001 !\t\u00013E\u0004\u0002\u0017C%\u0011!eF\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#/!Aq\u0005\u0001B\u0001B\u0003%q$\u0001\u0004u_BL7\r\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005A!M]8lKJLE-F\u0001,!\t1B&\u0003\u0002./\t\u0019\u0011J\u001c;\t\u0011=\u0002!\u0011!Q\u0001\n-\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011E\u0002!Q1A\u0005\u0002I\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0003\u0002\u000f\rdWo\u001d;fe&\u0011\u0001(\u000e\u0002\n!\u0006\u0014H/\u001b;j_:D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011B\u001f\u0002\u0015\rDWO\\6Rk\u0016,X-F\u0001?!\ryDIR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u000bG>t7-\u001e:sK:$(BA\"\f\u0003\u0011)H/\u001b7\n\u0005\u0015\u0003%!\u0004\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002H\u00116\t!!\u0003\u0002J\u0005\t\u0001b)\u001a;dQ\u0016$G)\u0019;b\u0007\",hn\u001b\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005}\u0005Y1\r[;oWF+X-^3!\u0011!i\u0005A!b\u0001\n\u0013q\u0015AD2p]N,X.\u001a3PM\u001a\u001cX\r^\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!\u000bQ\u0001\u0007CR|W.[2\n\u0005Q\u000b&AC!u_6L7\rT8oO\"Aa\u000b\u0001B\u0001B\u0003%q*A\bd_:\u001cX/\\3e\u001f\u001a47/\u001a;!\u0011!A\u0006A!b\u0001\n\u0013q\u0015!\u00044fi\u000eDW\rZ(gMN,G\u000f\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003P\u000391W\r^2iK\u0012|eMZ:fi\u0002B\u0001\u0002\u0018\u0001\u0003\u0006\u0004%I!X\u0001\nM\u0016$8\r[*ju\u0016,\u0012A\u0018\t\u0003!~K!\u0001Y)\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\u0011\u0007A!A!\u0002\u0013q\u0016A\u00034fi\u000eD7+\u001b>fA!)A\r\u0001C\u0001K\u00061A(\u001b8jiz\"\u0002BZ4iS*\\G.\u001c\t\u0003\u000f\u0002AQ\u0001H2A\u0002}AQ!K2A\u0002-BQ!M2A\u0002MBQ\u0001P2A\u0002yBQ!T2A\u0002=CQ\u0001W2A\u0002=CQ\u0001X2A\u0002yCQa\u001c\u0001\u0005\u0002A\f\u0001cZ3u\u0007>t7/^7f\u001f\u001a47/\u001a;\u0015\u0003E\u0004\"A\u0006:\n\u0005M<\"\u0001\u0002'p]\u001eDQ!\u001e\u0001\u0005\u0002A\fabZ3u\r\u0016$8\r[(gMN,G\u000fC\u0003x\u0001\u0011\u0005\u00010\u0001\nsKN,GoQ8ogVlWm\u00144gg\u0016$HCA=}!\t1\"0\u0003\u0002|/\t!QK\\5u\u0011\u0015ih\u000f1\u0001r\u0003AqWm^\"p]N,X.Z(gMN,G\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0011e\u0016\u001cX\r\u001e$fi\u000eDwJ\u001a4tKR$2!_A\u0002\u0011\u0019\t)A a\u0001c\u0006qa.Z<GKR\u001c\u0007n\u00144gg\u0016$\bbBA\u0005\u0001\u0011\u0005\u00111B\u0001\bK:\fX/Z;f)\u0015\t\u0018QBA\u000f\u0011!\ty!a\u0002A\u0002\u0005E\u0011\u0001C7fgN\fw-Z:\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0005\u0003\u001diWm]:bO\u0016LA!a\u0007\u0002\u0016\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKRDq!a\b\u0002\b\u0001\u0007\u0011/A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBA\u0012\u0001\u0011\u0005\u0011QE\u0001\rK:\fX/Z;f\u000bJ\u0014xN\u001d\u000b\u0006s\u0006\u001d\u00121\t\u0005\t\u0003S\t\t\u00031\u0001\u0002,\u0005\tQ\r\u0005\u0003\u0002.\u0005ub\u0002BA\u0018\u0003sqA!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ki\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\r\tYdF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty$!\u0011\u0003\u0013QC'o\\<bE2,'bAA\u001e/!9\u0011qDA\u0011\u0001\u0004\t\bbBA$\u0001\u0011\u0005\u0013\u0011J\u0001\ti>\u001cFO]5oOR\tq\u0004")
public class PartitionTopicInfo
implements Logging,
ScalaObject {
    private final String topic;
    private final int brokerId;
    private final Partition partition;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    private final AtomicInteger fetchSize;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionTopicInfo partitionTopicInfo = this;
        synchronized (partitionTopicInfo) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    public long getConsumeOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset().set(newConsumeOffset$1);
        this.debug((Function0<String>)new $anonfun$resetConsumeOffset$1(this, newConsumeOffset$1));
    }

    public void resetFetchOffset(long newFetchOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(newFetchOffset$1);
        this.debug((Function0<String>)new $anonfun$resetFetchOffset$1(this, newFetchOffset$1));
    }

    public long enqueue(ByteBufferMessageSet messages, long fetchOffset) {
        Object object;
        long size$1 = messages.validBytes();
        if (size$1 > 0L) {
            this.trace((Function0<String>)new $anonfun$enqueue$1(this, size$1));
            this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
            long newOffset$1 = this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().addAndGet(size$1);
            this.debug((Function0<String>)new $anonfun$enqueue$2(this, newOffset$1));
            ConsumerTopicStat$.MODULE$.getConsumerTopicStat(this.topic()).recordBytesPerTopic(size$1);
            object = BoxesRunTime.boxToLong((long)ConsumerTopicStat$.MODULE$.getConsumerAllTopicStat().recordBytesPerTopic(size$1));
        } else {
            object = BoxedUnit.UNIT;
        }
        return size$1;
    }

    public void enqueueError(Throwable e, long fetchOffset) {
        ByteBufferMessageSet messages = new ByteBufferMessageSet(ErrorMapping$.MODULE$.EmptyByteBuffer(), 0L, ErrorMapping$.MODULE$.codeFor(e.getClass()));
        this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
    }

    public String toString() {
        return new StringBuilder().append((Object)this.topic()).append((Object)":").append((Object)this.partition().toString()).append((Object)": fetched offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)": consumed offset = ").append((Object)BoxesRunTime.boxToLong((long)this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
    }

    public PartitionTopicInfo(String topic, int brokerId, Partition partition, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize) {
        this.topic = topic;
        this.brokerId = brokerId;
        this.partition = partition;
        this.chunkQueue = chunkQueue;
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset = consumedOffset;
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        Logging$class.$init$(this);
        this.debug((Function0<String>)new $anonfun$1(this));
        this.debug((Function0<String>)new $anonfun$2(this));
    }
}

