---
sidebar_position: 0
---
# 👋 Getting Started

Tabby is an open-source, self-hosted AI coding assistant. With Tabby, every team can set up its own LLM-powered code completion server with ease.

[![Join Slack](https://shields.io/badge/Join%20Slack-e29351?logo=slack)](https://join.slack.com/t/tabbycommunity/shared_invite/zt-1xeiddizp-bciR2RtFTaJ37RBxr8VxpA)
[![Follow on Linkedin](https://shields.io/badge/Follow%20on%20Linkedin-e29351?logo=linkedin)](https://www.linkedin.com/company/tabbyml/)
[![Star on Github](https://img.shields.io/github/stars/TabbyML/tabby?labelColor=e29351&label=Star&color=ffffff&logo=github)](https://github.com/TabbyML/tabby)

## 📄 About the Docs

| Section                                     | Goal                                                                        |
| ------------------------------------------- | --------------------------------------------------------------------------- |
| [📚 Installation](/docs/installation)           | Everything deployment: Docker, Homebrew, Hugging Face Space and many others |
| [💻 IDE / Editor Extensions](/docs/extensions)  | IDE/Editor extensions that can be seamlessly integrated with Tabby          |
| [🧑‍🔬 Models Directory](/docs/models)             | A curated list of models that we recommend using with Tabby                 |
| [🏷️ API References](/api)                   | API Documentation                                                           |
| [🏘️ Community](#%EF%B8%8F-community)        | Everything about for developers and contributing                            |
| [🗺️ Roadmap](/docs/roadmap)                     | Our future plans                                                            |

## 📏 Principles

* **Open**: Tabby is free, open-source, and compatible with major Coding LLMs (CodeLlama, StarCoder, CodeGen). In fact, you can use and combine your preferred models without implementing anything by yourself.

* **End-to-End**: While most coding tools consider code completion merely as a thin wrapper atop Coding LLMs, in real-world scenarios, optimizations in IDE extensions can be just as crucial as the capabilities of Coding LLMs.
Tabby optimizes the entire stack:
  + <u>IDE extensions</u>: Tabby achieves accurate streaming and cancellation with an adaptive caching strategy to ensure rapid completion (in less than a second).
  + <u>Model serving</u>: Tabby parses relevant code into Tree Sitter tags to provide effective prompts.

* **User and Developer Experience**: The key to sustainable open-source solutions is to make it easier for everyone to contribute to projects.
AI experts should feel comfortable understanding and improving the suggestion quality.
EngOps team should find it easy to set up and feel in control of the data.
Developers should have an "aha" moment during coding time.
Tabby optimizes the experience for these core users to enhance your team's productivity.

## 🏘️ Community

- ⭐ Tabby [Github repo](https://github.com/TabbyML/tabby) to stay updated about new releases and tutorials.

- 🙋 Join the Tabby community on [Slack](https://join.slack.com/t/tabbycommunity/shared_invite/zt-1xeiddizp-bciR2RtFTaJ37RBxr8VxpA) and get direct support from the community.

- 🎤 Follow Tabby on [Twitter / X](https://twitter.com/Tabby_ML) to engage with TabbyML for all things possible.

- 📚 Follow Tabby on [LinkedIn](https://www.linkedin.com/company/tabbyml/) for the latest from the community.

- 💌 Subscribe to our [Newsletter](https://tinyletter.com/tabbyml/) to unlock Tabby insights and secrets.
