## TFSA-2018-002: GIF File Parsing Null Pointer Dereference Error

### CVE Number

CVE-2018-7576

### Issue Description

When parsing certain invalid GIF files, an internal function in the GIF decoder
returned a null pointer, which was subsequently used as an argument to strcat.

### Impact

A maliciously crafted GIF could be used to cause the TensorFlow process to
crash.

### Vulnerable Versions

TensorFlow 1.0.0, 1.0.1, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1 1.4.1, 1.5.0, 1.5.1

### Mitigation

We have patched the vulnerability in GitHub commit
[c4843158](https://github.com/tensorflow/tensorflow/commit/c48431588e7cf8aff61d4c299231e3e925144df8).
If users are running TensorFlow in production or on untrusted data, they are
encouraged to apply this patch.

Additionally, this patch has already been integrated into TensorFlow 1.6.0 and
newer.

### Credits

This issue was discovered by the Blade Team of Tencent.
