# Roadmap
**Last updated: January 13, 2016**

TensorFlow is a fast moving project. In order for the community to better
understand what the near future will bring, this document shares what we are
working on internally. Many of these features were requested by the community,
and we welcome
[contributions](https://github.com/tensorflow/tensorflow/labels/contributions%20welcome).

The features on this list are targeted for the next few months. At this point,
we do not have timelines for these features.

### Improve support for C++ only users
* Graph construction
* Gradients
* Shape Inference

### Making TensorFlow easier to use
* Higher level APIs (for instance, layers)
* Saving everything to run a graph

### Performance
* Speed and memory benchmarks
* Performance and memory usage improvements

### Core Features
* Repeated partial graph evaluation ([#672](https://github.com/tensorflow/tensorflow/issues/672))


### Platforms
* iOS support ([#16](https://github.com/tensorflow/tensorflow/issues/16))
* OpenCL support ([#22](https://github.com/tensorflow/tensorflow/issues/22))
* Distributed execution
  ([#23](https://github.com/tensorflow/tensorflow/issues/23))

### Community
* Improvements to Jenkins: automated tests for all supported configurations
* Open-source the doc generator and publish docs style guide
* TensorFlow Models repository (partially,
  [#6](https://github.com/tensorflow/tensorflow/issues/6))

