// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = (typeof Module !== 'undefined' ? Module : null) || {};

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = typeof window === 'object';
// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  if (!Module['print']) Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  if (!Module['printErr']) Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };

  Module['readBinary'] = function readBinary(filename) {
    var ret = Module['read'](filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };

  Module['load'] = function load(f) {
    globalEval(read(f));
  };

  if (!Module['thisProgram']) {
    if (process['argv'].length > 1) {
      Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
    } else {
      Module['thisProgram'] = 'unknown-program';
    }
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
}
else if (ENVIRONMENT_IS_SHELL) {
  if (!Module['print']) Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }

  Module['readBinary'] = function readBinary(f) {
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    var data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof console !== 'undefined') {
    if (!Module['print']) Module['print'] = function print(x) {
      console.log(x);
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  if (ENVIRONMENT_IS_WORKER) {
    Module['load'] = importScripts;
  }

  if (typeof Module['setWindowTitle'] === 'undefined') {
    Module['setWindowTitle'] = function(title) { document.title = title };
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
if (!Module['thisProgram']) {
  Module['thisProgram'] = './this.program';
}

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in: 
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at: 
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  setTempRet0: function (value) {
    tempRet0 = value;
  },
  getTempRet0: function () {
    return tempRet0;
  },
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  STACK_ALIGN: 16,
  prepVararg: function (ptr, type) {
    if (type === 'double' || type === 'i64') {
      // move so the load is aligned
      if (ptr & 7) {
        assert((ptr & 7) === 4);
        ptr += 4;
      }
    } else {
      assert((ptr & 3) === 0);
    }
    return ptr;
  },
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (!vararg && (type == 'i64' || type == 'double')) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      assert(args.length == sig.length-1);
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      assert(sig.length == 1);
      assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[sig]) {
      Runtime.funcWrappers[sig] = {};
    }
    var sigCache = Runtime.funcWrappers[sig];
    if (!sigCache[func]) {
      sigCache[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return sigCache[func];
  },
  getCompilerSetting: function (name) {
    throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+15)&-16);(assert((((STACKTOP|0) < (STACK_MAX|0))|0))|0); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + (assert(!staticSealed),size))|0;STATICTOP = (((STATICTOP)+15)&-16); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + (assert(DYNAMICTOP > 0),size))|0;DYNAMICTOP = (((DYNAMICTOP)+15)&-16); if (DYNAMICTOP >= TOTAL_MEMORY) { var success = enlargeMemory(); if (!success) { DYNAMICTOP = ret;  return 0; } }; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 16))*(quantum ? quantum : 16); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}



Module["Runtime"] = Runtime;



//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  if (!func) {
    try {
      func = eval('_' + ident); // explicit lookup
    } catch(e) {}
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

var cwrap, ccall;
(function(){
  var JSfuncs = {
    // Helpers for cwrap -- it can't refer to Runtime directly because it might
    // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
    // out what the minified function name is.
    'stackSave': function() {
      Runtime.stackSave()
    },
    'stackRestore': function() {
      Runtime.stackRestore()
    },
    // type conversion from js to c
    'arrayToC' : function(arr) {
      var ret = Runtime.stackAlloc(arr.length);
      writeArrayToMemory(arr, ret);
      return ret;
    },
    'stringToC' : function(str) {
      var ret = 0;
      if (str !== null && str !== undefined && str !== 0) { // null string
        // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
        ret = Runtime.stackAlloc((str.length << 2) + 1);
        writeStringToMemory(str, ret);
      }
      return ret;
    }
  };
  // For fast lookup of conversion functions
  var toC = {'string' : JSfuncs['stringToC'], 'array' : JSfuncs['arrayToC']};

  // C calling interface. 
  ccall = function ccallFunc(ident, returnType, argTypes, args, opts) {
    var func = getCFunc(ident);
    var cArgs = [];
    var stack = 0;
    assert(returnType !== 'array', 'Return type should not be "array".');
    if (args) {
      for (var i = 0; i < args.length; i++) {
        var converter = toC[argTypes[i]];
        if (converter) {
          if (stack === 0) stack = Runtime.stackSave();
          cArgs[i] = converter(args[i]);
        } else {
          cArgs[i] = args[i];
        }
      }
    }
    var ret = func.apply(null, cArgs);
    if ((!opts || !opts.async) && typeof EmterpreterAsync === 'object') {
      assert(!EmterpreterAsync.state, 'cannot start async op with normal JS calling ccall');
    }
    if (opts && opts.async) assert(!returnType, 'async ccalls cannot return values');
    if (returnType === 'string') ret = Pointer_stringify(ret);
    if (stack !== 0) {
      if (opts && opts.async) {
        EmterpreterAsync.asyncFinalizers.push(function() {
          Runtime.stackRestore(stack);
        });
        return;
      }
      Runtime.stackRestore(stack);
    }
    return ret;
  }

  var sourceRegex = /^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;
  function parseJSFunc(jsfunc) {
    // Match the body and the return value of a javascript function source
    var parsed = jsfunc.toString().match(sourceRegex).slice(1);
    return {arguments : parsed[0], body : parsed[1], returnValue: parsed[2]}
  }
  var JSsource = {};
  for (var fun in JSfuncs) {
    if (JSfuncs.hasOwnProperty(fun)) {
      // Elements of toCsource are arrays of three items:
      // the code, and the return value
      JSsource[fun] = parseJSFunc(JSfuncs[fun]);
    }
  }

  
  cwrap = function cwrap(ident, returnType, argTypes) {
    argTypes = argTypes || [];
    var cfunc = getCFunc(ident);
    // When the function takes numbers and returns a number, we can just return
    // the original function
    var numericArgs = argTypes.every(function(type){ return type === 'number'});
    var numericRet = (returnType !== 'string');
    if ( numericRet && numericArgs) {
      return cfunc;
    }
    // Creation of the arguments list (["$1","$2",...,"$nargs"])
    var argNames = argTypes.map(function(x,i){return '$'+i});
    var funcstr = "(function(" + argNames.join(',') + ") {";
    var nargs = argTypes.length;
    if (!numericArgs) {
      // Generate the code needed to convert the arguments from javascript
      // values to pointers
      funcstr += 'var stack = ' + JSsource['stackSave'].body + ';';
      for (var i = 0; i < nargs; i++) {
        var arg = argNames[i], type = argTypes[i];
        if (type === 'number') continue;
        var convertCode = JSsource[type + 'ToC']; // [code, return]
        funcstr += 'var ' + convertCode.arguments + ' = ' + arg + ';';
        funcstr += convertCode.body + ';';
        funcstr += arg + '=' + convertCode.returnValue + ';';
      }
    }

    // When the code is compressed, the name of cfunc is not literally 'cfunc' anymore
    var cfuncname = parseJSFunc(function(){return cfunc}).returnValue;
    // Call the function
    funcstr += 'var ret = ' + cfuncname + '(' + argNames.join(',') + ');';
    if (!numericRet) { // Return type can only by 'string' or 'number'
      // Convert the result to a string
      var strgfy = parseJSFunc(function(){return Pointer_stringify}).returnValue;
      funcstr += 'ret = ' + strgfy + '(ret);';
    }
    funcstr += "if (typeof EmterpreterAsync === 'object') { assert(!EmterpreterAsync.state, 'cannot start async op with normal JS calling cwrap') }";
    if (!numericArgs) {
      // If we had a stack, restore it
      funcstr += JSsource['stackRestore'].body.replace('()', '(stack)') + ';';
    }
    funcstr += 'return ret})';
    return eval(funcstr);
  };
})();
Module["ccall"] = ccall;
Module["cwrap"] = cwrap;

function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module["setValue"] = setValue;


function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module["getValue"] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module["ALLOC_NORMAL"] = ALLOC_NORMAL;
Module["ALLOC_STACK"] = ALLOC_STACK;
Module["ALLOC_STATIC"] = ALLOC_STATIC;
Module["ALLOC_DYNAMIC"] = ALLOC_DYNAMIC;
Module["ALLOC_NONE"] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    assert(type, 'Must know what type to store in allocate!');

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}
Module["allocate"] = allocate;

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return Runtime.staticAlloc(size);
  if ((typeof _sbrk !== 'undefined' && !_sbrk.called) || !runtimeInitialized) return Runtime.dynamicAlloc(size);
  return _malloc(size);
}
Module["getMemory"] = getMemory;

function Pointer_stringify(ptr, /* optional */ length) {
  if (length === 0 || !ptr) return '';
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    assert(ptr + i < TOTAL_MEMORY);
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return Module['UTF8ToString'](ptr);
}
Module["Pointer_stringify"] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}
Module["AsciiToString"] = AsciiToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}
Module["stringToAscii"] = stringToAscii;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

function UTF8ArrayToString(u8Array, idx) {
  var u0, u1, u2, u3, u4, u5;

  var str = '';
  while (1) {
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    u0 = u8Array[idx++];
    if (!u0) return str;
    if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
    u1 = u8Array[idx++] & 63;
    if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
    u2 = u8Array[idx++] & 63;
    if ((u0 & 0xF0) == 0xE0) {
      u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
    } else {
      u3 = u8Array[idx++] & 63;
      if ((u0 & 0xF8) == 0xF0) {
        u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
      } else {
        u4 = u8Array[idx++] & 63;
        if ((u0 & 0xFC) == 0xF8) {
          u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
        } else {
          u5 = u8Array[idx++] & 63;
          u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
        }
      }
    }
    if (u0 < 0x10000) {
      str += String.fromCharCode(u0);
    } else {
      var ch = u0 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    }
  }
}
Module["UTF8ArrayToString"] = UTF8ArrayToString;

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8,ptr);
}
Module["UTF8ToString"] = UTF8ToString;

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}
Module["stringToUTF8Array"] = stringToUTF8Array;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}
Module["stringToUTF8"] = stringToUTF8;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}
Module["lengthBytesUTF8"] = lengthBytesUTF8;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF16ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module["UTF16ToString"] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF16"] = stringToUTF16;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}
Module["lengthBytesUTF16"] = lengthBytesUTF16;

function UTF32ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module["UTF32ToString"] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null 
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}
Module["stringToUTF32"] = stringToUTF32;

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}
Module["lengthBytesUTF32"] = lengthBytesUTF32;

function demangle(func) {
  var hasLibcxxabi = !!Module['___cxa_demangle'];
  if (hasLibcxxabi) {
    try {
      var buf = _malloc(func.length);
      writeStringToMemory(func.substr(1), buf);
      var status = _malloc(4);
      var ret = Module['___cxa_demangle'](buf, 0, 0, status);
      if (getValue(status, 'i32') === 0 && ret) {
        return Pointer_stringify(ret);
      }
      // otherwise, libcxxabi failed, we can try ours which may return a partial result
    } catch(e) {
      // failure when using libcxxabi, we can try ours which may return a partial result
    } finally {
      if (buf) _free(buf);
      if (status) _free(status);
      if (ret) _free(ret);
    }
  }
  var i = 3;
  // params, etc.
  var basicTypes = {
    'v': 'void',
    'b': 'bool',
    'c': 'char',
    's': 'short',
    'i': 'int',
    'l': 'long',
    'f': 'float',
    'd': 'double',
    'w': 'wchar_t',
    'a': 'signed char',
    'h': 'unsigned char',
    't': 'unsigned short',
    'j': 'unsigned int',
    'm': 'unsigned long',
    'x': 'long long',
    'y': 'unsigned long long',
    'z': '...'
  };
  var subs = [];
  var first = true;
  function dump(x) {
    //return;
    if (x) Module.print(x);
    Module.print(func);
    var pre = '';
    for (var a = 0; a < i; a++) pre += ' ';
    Module.print (pre + '^');
  }
  function parseNested() {
    i++;
    if (func[i] === 'K') i++; // ignore const
    var parts = [];
    while (func[i] !== 'E') {
      if (func[i] === 'S') { // substitution
        i++;
        var next = func.indexOf('_', i);
        var num = func.substring(i, next) || 0;
        parts.push(subs[num] || '?');
        i = next+1;
        continue;
      }
      if (func[i] === 'C') { // constructor
        parts.push(parts[parts.length-1]);
        i += 2;
        continue;
      }
      var size = parseInt(func.substr(i));
      var pre = size.toString().length;
      if (!size || !pre) { i--; break; } // counter i++ below us
      var curr = func.substr(i + pre, size);
      parts.push(curr);
      subs.push(curr);
      i += pre + size;
    }
    i++; // skip E
    return parts;
  }
  function parse(rawList, limit, allowVoid) { // main parser
    limit = limit || Infinity;
    var ret = '', list = [];
    function flushList() {
      return '(' + list.join(', ') + ')';
    }
    var name;
    if (func[i] === 'N') {
      // namespaced N-E
      name = parseNested().join('::');
      limit--;
      if (limit === 0) return rawList ? [name] : name;
    } else {
      // not namespaced
      if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
      var size = parseInt(func.substr(i));
      if (size) {
        var pre = size.toString().length;
        name = func.substr(i + pre, size);
        i += pre + size;
      }
    }
    first = false;
    if (func[i] === 'I') {
      i++;
      var iList = parse(true);
      var iRet = parse(true, 1, true);
      ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
    } else {
      ret = name;
    }
    paramLoop: while (i < func.length && limit-- > 0) {
      //dump('paramLoop');
      var c = func[i++];
      if (c in basicTypes) {
        list.push(basicTypes[c]);
      } else {
        switch (c) {
          case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
          case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
          case 'L': { // literal
            i++; // skip basic type
            var end = func.indexOf('E', i);
            var size = end - i;
            list.push(func.substr(i, size));
            i += size + 2; // size + 'EE'
            break;
          }
          case 'A': { // array
            var size = parseInt(func.substr(i));
            i += size.toString().length;
            if (func[i] !== '_') throw '?';
            i++; // skip _
            list.push(parse(true, 1, true)[0] + ' [' + size + ']');
            break;
          }
          case 'E': break paramLoop;
          default: ret += '?' + c; break paramLoop;
        }
      }
    }
    if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
    if (rawList) {
      if (ret) {
        list.push(ret + '?');
      }
      return list;
    } else {
      return ret + flushList();
    }
  }
  var parsed = func;
  try {
    // Special-case the entry point, since its name differs from other name mangling.
    if (func == 'Object._main' || func == '_main') {
      return 'main()';
    }
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    parsed = parse();
  } catch(e) {
    parsed += '?';
  }
  if (parsed.indexOf('?') >= 0 && !hasLibcxxabi) {
    Runtime.warnOnce('warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
  }
  return parsed;
}

function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  return demangleAll(jsStackTrace());
}
Module["stackTrace"] = stackTrace;

// Memory management

var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
  if (x % 4096 > 0) {
    x += (4096 - (x % 4096));
  }
  return x;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk



function enlargeMemory() {
  // TOTAL_MEMORY is the current size of the actual array, and DYNAMICTOP is the new top.
  assert(DYNAMICTOP >= TOTAL_MEMORY);
  assert(TOTAL_MEMORY > 4); // So the loop below will not be infinite

  var OLD_TOTAL_MEMORY = TOTAL_MEMORY;


  var LIMIT = Math.pow(2, 31); // 2GB is a practical maximum, as we use signed ints as pointers
                               // and JS engines seem unhappy to give us 2GB arrays currently
  if (DYNAMICTOP >= LIMIT) return false;

  while (TOTAL_MEMORY <= DYNAMICTOP) { // Simple heuristic.
    if (TOTAL_MEMORY < LIMIT/2) {
      TOTAL_MEMORY = alignMemoryPage(2*TOTAL_MEMORY); // double until 1GB
    } else {
      var last = TOTAL_MEMORY;
      TOTAL_MEMORY = alignMemoryPage((3*TOTAL_MEMORY + LIMIT)/4); // add smaller increments towards 2GB, which we cannot reach
      if (TOTAL_MEMORY <= last) return false;
    }
  }

  TOTAL_MEMORY = Math.max(TOTAL_MEMORY, 16*1024*1024);

  if (TOTAL_MEMORY >= LIMIT) return false;

  Module.printErr('Warning: Enlarging memory arrays, this is not fast! ' + [OLD_TOTAL_MEMORY, TOTAL_MEMORY]);


  var start = Date.now();

  try {
    if (ArrayBuffer.transfer) {
      buffer = ArrayBuffer.transfer(buffer, TOTAL_MEMORY);
    } else {
      var oldHEAP8 = HEAP8;
      buffer = new ArrayBuffer(TOTAL_MEMORY);
    }
  } catch(e) {
    return false;
  }

  var success = _emscripten_replace_memory(buffer);
  if (!success) return false;

  // everything worked

  Module['buffer'] = buffer;
  Module['HEAP8'] = HEAP8 = new Int8Array(buffer);
  Module['HEAP16'] = HEAP16 = new Int16Array(buffer);
  Module['HEAP32'] = HEAP32 = new Int32Array(buffer);
  Module['HEAPU8'] = HEAPU8 = new Uint8Array(buffer);
  Module['HEAPU16'] = HEAPU16 = new Uint16Array(buffer);
  Module['HEAPU32'] = HEAPU32 = new Uint32Array(buffer);
  Module['HEAPF32'] = HEAPF32 = new Float32Array(buffer);
  Module['HEAPF64'] = HEAPF64 = new Float64Array(buffer);
  if (!ArrayBuffer.transfer) {
    HEAP8.set(oldHEAP8);
  }

  Module.printErr('enlarged memory arrays from ' + OLD_TOTAL_MEMORY + ' to ' + TOTAL_MEMORY + ', took ' + (Date.now() - start) + ' ms (has ArrayBuffer.transfer? ' + (!!ArrayBuffer.transfer) + ')');

  return true;
}

var byteLength;
try {
  byteLength = Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype, 'byteLength').get);
  byteLength(new ArrayBuffer(4)); // can fail on older ie
} catch(e) { // can fail on older node/v8
  byteLength = function(buffer) { return buffer.byteLength; };
}

var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 268435456;

var totalMemory = 64*1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
totalMemory = Math.max(totalMemory, 16*1024*1024);
if (totalMemory !== TOTAL_MEMORY) {
  Module.printErr('increasing TOTAL_MEMORY to ' + totalMemory + ' to be compliant with the asm.js spec (and given that TOTAL_STACK=' + TOTAL_STACK + ')');
  TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'JS engine does not provide full typed array support');

var buffer;



buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);


// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['buffer'] = buffer;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module["addOnPreRun"] = addOnPreRun;

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module["addOnInit"] = addOnInit;

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module["addOnPreMain"] = addOnPreMain;

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module["addOnExit"] = addOnExit;

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module["addOnPostRun"] = addOnPostRun;

// Tools


function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}
Module["intArrayFromString"] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module["intArrayToString"] = intArrayToString;

function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))>>0)]=chr;
    i = i + 1;
  }
}
Module["writeStringToMemory"] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[((buffer++)>>0)]=array[i];
  }
}
Module["writeArrayToMemory"] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    assert(str.charCodeAt(i) === str.charCodeAt(i)&0xff);
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}
Module["writeAsciiToMemory"] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}


// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


if (!Math['clz32']) Math['clz32'] = function(x) {
  x = x >>> 0;
  for (var i = 0; i < 32; i++) {
    if (x & (1 << (31 - i))) return i;
  }
  return 32;
};
Math.clz32 = Math['clz32']

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
var runDependencyTracking = {};

function getUniqueRunDependency(id) {
  var orig = id;
  while (1) {
    if (!runDependencyTracking[id]) return id;
    id = orig + Math.random();
  }
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        if (ABORT) {
          clearInterval(runDependencyWatcher);
          runDependencyWatcher = null;
          return;
        }
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 10000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module["addRunDependency"] = addRunDependency;

function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module["removeRunDependency"] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;



// === Body ===

var ASM_CONSTS = [function($0, $1, $2, $3) { { if (!artoolkit["multiEachMarkerInfo"]) { artoolkit["multiEachMarkerInfo"] = ({}); } var multiEachMarker = artoolkit["multiEachMarkerInfo"]; multiEachMarker['visible'] = $0; multiEachMarker['pattId'] = $1; multiEachMarker['pattType'] = $2; multiEachMarker['width'] = $3; } },
 function($0, $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $30, $31, $32) { { var $a = arguments; var i = 12; if (!artoolkit["markerInfo"]) { artoolkit["markerInfo"] = ({ pos: [0,0], line: [[0,0,0], [0,0,0], [0,0,0], [0,0,0]], vertex: [[0,0], [0,0], [0,0], [0,0]] }); } var markerInfo = artoolkit["markerInfo"]; markerInfo["area"] = $0; markerInfo["id"] = $1; markerInfo["idPatt"] = $2; markerInfo["idMatrix"] = $3; markerInfo["dir"] = $4; markerInfo["dirPatt"] = $5; markerInfo["dirMatrix"] = $6; markerInfo["cf"] = $7; markerInfo["cfPatt"] = $8; markerInfo["cfMatrix"] = $9; markerInfo["pos"][0] = $10; markerInfo["pos"][1] = $11; markerInfo["line"][0][0] = $a[i++]; markerInfo["line"][0][1] = $a[i++]; markerInfo["line"][0][2] = $a[i++]; markerInfo["line"][1][0] = $a[i++]; markerInfo["line"][1][1] = $a[i++]; markerInfo["line"][1][2] = $a[i++]; markerInfo["line"][2][0] = $a[i++]; markerInfo["line"][2][1] = $a[i++]; markerInfo["line"][2][2] = $a[i++]; markerInfo["line"][3][0] = $a[i++]; markerInfo["line"][3][1] = $a[i++]; markerInfo["line"][3][2] = $a[i++]; markerInfo["vertex"][0][0] = $a[i++]; markerInfo["vertex"][0][1] = $a[i++]; markerInfo["vertex"][1][0] = $a[i++]; markerInfo["vertex"][1][1] = $a[i++]; markerInfo["vertex"][2][0] = $a[i++]; markerInfo["vertex"][2][1] = $a[i++]; markerInfo["vertex"][3][0] = $a[i++]; markerInfo["vertex"][3][1] = $a[i++]; markerInfo["errorCorrected"] = $a[i++]; } },
 function($0, $1, $2, $3, $4) { { if (!artoolkit["frameMalloc"]) { artoolkit["frameMalloc"] = ({}); } var frameMalloc = artoolkit["frameMalloc"]; frameMalloc["framepointer"] = $1; frameMalloc["framesize"] = $2; frameMalloc["camera"] = $3; frameMalloc["transform"] = $4; } }];

function _emscripten_asm_const_33(code, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32) {
 return ASM_CONSTS[code](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32);
}

function _emscripten_asm_const_4(code, a0, a1, a2, a3) {
 return ASM_CONSTS[code](a0, a1, a2, a3);
}

function _emscripten_asm_const_5(code, a0, a1, a2, a3, a4) {
 return ASM_CONSTS[code](a0, a1, a2, a3, a4);
}



STATIC_BASE = 8;

STATICTOP = STATIC_BASE + 18336;
  /* global initializers */  __ATINIT__.push({ func: function() { __GLOBAL__sub_I_ARToolKitJS_cpp() } }, { func: function() { __GLOBAL__sub_I_bind_cpp() } });
  

/* memory initializer */ allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,9,0,0,52,42,0,0,0,0,0,0,1,0,0,0,128,1,0,0,0,0,0,0,228,8,0,0,115,42,0,0,52,9,0,0,12,47,0,0,0,0,0,0,1,0,0,0,128,1,0,0,0,0,0,0,52,9,0,0,205,46,0,0,0,0,0,0,1,0,0,0,128,1,0,0,0,0,0,0,228,8,0,0,186,46,0,0,228,8,0,0,155,46,0,0,228,8,0,0,194,45,0,0,228,8,0,0,163,45,0,0,228,8,0,0,132,45,0,0,228,8,0,0,101,45,0,0,228,8,0,0,70,45,0,0,228,8,0,0,225,45,0,0,228,8,0,0,0,46,0,0,228,8,0,0,31,46,0,0,228,8,0,0,62,46,0,0,228,8,0,0,93,46,0,0,228,8,0,0,124,46,0,0,12,9,0,0,75,47,0,0,48,2,0,0,0,0,0,0,228,8,0,0,88,47,0,0,228,8,0,0,101,47,0,0,12,9,0,0,114,47,0,0,56,2,0,0,0,0,0,0,12,9,0,0,147,47,0,0,64,2,0,0,0,0,0,0,12,9,0,0,181,47,0,0,64,2,0,0,0,0,0,0,200,8,0,0,221,47,0,0,200,8,0,0,223,47,0,0,200,8,0,0,225,47,0,0,200,8,0,0,227,47,0,0,200,8,0,0,229,47,0,0,200,8,0,0,231,47,0,0,200,8,0,0,233,47,0,0,200,8,0,0,235,47,0,0,200,8,0,0,237,47,0,0,200,8,0,0,14,54,0,0,200,8,0,0,239,47,0,0,200,8,0,0,241,47,0,0,200,8,0,0,243,47,0,0,12,9,0,0,245,47,0,0,80,2,0,0,0,0,0,0,12,9,0,0,26,48,0,0,80,2,0,0,0,0,0,0,255,15,0,0,6,16,0,0,18,16,0,0,28,16,0,0,255,255,255,255,255,255,255,255,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,3,0,0,0,6,0,0,0,12,0,0,0,11,0,0,0,5,0,0,0,10,0,0,0,7,0,0,0,14,0,0,0,15,0,0,0,13,0,0,0,9,0,0,0,1,0,0,0,2,0,0,0,4,0,0,0,8,0,0,0,16,0,0,0,32,0,0,0,64,0,0,0,3,0,0,0,6,0,0,0,12,0,0,0,24,0,0,0,48,0,0,0,96,0,0,0,67,0,0,0,5,0,0,0,10,0,0,0,20,0,0,0,40,0,0,0,80,0,0,0,35,0,0,0,70,0,0,0,15,0,0,0,30,0,0,0,60,0,0,0,120,0,0,0,115,0,0,0,101,0,0,0,73,0,0,0,17,0,0,0,34,0,0,0,68,0,0,0,11,0,0,0,22,0,0,0,44,0,0,0,88,0,0,0,51,0,0,0,102,0,0,0,79,0,0,0,29,0,0,0,58,0,0,0,116,0,0,0,107,0,0,0,85,0,0,0,41,0,0,0,82,0,0,0,39,0,0,0,78,0,0,0,31,0,0,0,62,0,0,0,124,0,0,0,123,0,0,0,117,0,0,0,105,0,0,0,81,0,0,0,33,0,0,0,66,0,0,0,7,0,0,0,14,0,0,0,28,0,0,0,56,0,0,0,112,0,0,0,99,0,0,0,69,0,0,0,9,0,0,0,18,0,0,0,36,0,0,0,72,0,0,0,19,0,0,0,38,0,0,0,76,0,0,0,27,0,0,0,54,0,0,0,108,0,0,0,91,0,0,0,53,0,0,0,106,0,0,0,87,0,0,0,45,0,0,0,90,0,0,0,55,0,0,0,110,0,0,0,95,0,0,0,61,0,0,0,122,0,0,0,119,0,0,0,109,0,0,0,89,0,0,0,49,0,0,0,98,0,0,0,71,0,0,0,13,0,0,0,26,0,0,0,52,0,0,0,104,0,0,0,83,0,0,0,37,0,0,0,74,0,0,0,23,0,0,0,46,0,0,0,92,0,0,0,59,0,0,0,118,0,0,0,111,0,0,0,93,0,0,0,57,0,0,0,114,0,0,0,103,0,0,0,77,0,0,0,25,0,0,0,50,0,0,0,100,0,0,0,75,0,0,0,21,0,0,0,42,0,0,0,84,0,0,0,43,0,0,0,86,0,0,0,47,0,0,0,94,0,0,0,63,0,0,0,126,0,0,0,127,0,0,0,125,0,0,0,121,0,0,0,113,0,0,0,97,0,0,0,65,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,8,0,0,0,5,0,0,0,10,0,0,0,3,0,0,0,14,0,0,0,9,0,0,0,7,0,0,0,6,0,0,0,13,0,0,0,11,0,0,0,12,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,7,0,0,0,2,0,0,0,14,0,0,0,8,0,0,0,56,0,0,0,3,0,0,0,63,0,0,0,15,0,0,0,31,0,0,0,9,0,0,0,90,0,0,0,57,0,0,0,21,0,0,0,4,0,0,0,28,0,0,0,64,0,0,0,67,0,0,0,16,0,0,0,112,0,0,0,32,0,0,0,97,0,0,0,10,0,0,0,108,0,0,0,91,0,0,0,70,0,0,0,58,0,0,0,38,0,0,0,22,0,0,0,47,0,0,0,5,0,0,0,54,0,0,0,29,0,0,0,19,0,0,0,65,0,0,0,95,0,0,0,68,0,0,0,45,0,0,0,17,0,0,0,43,0,0,0,113,0,0,0,115,0,0,0,33,0,0,0,77,0,0,0,98,0,0,0,117,0,0,0,11,0,0,0,87,0,0,0,109,0,0,0,35,0,0,0,92,0,0,0,74,0,0,0,71,0,0,0,79,0,0,0,59,0,0,0,104,0,0,0,39,0,0,0,100,0,0,0,23,0,0,0,82,0,0,0,48,0,0,0,119,0,0,0,6,0,0,0,126,0,0,0,55,0,0,0,13,0,0,0,30,0,0,0,62,0,0,0,20,0,0,0,89,0,0,0,66,0,0,0,27,0,0,0,96,0,0,0,111,0,0,0,69,0,0,0,107,0,0,0,46,0,0,0,37,0,0,0,18,0,0,0,53,0,0,0,44,0,0,0,94,0,0,0,114,0,0,0,42,0,0,0,116,0,0,0,76,0,0,0,34,0,0,0,86,0,0,0,78,0,0,0,73,0,0,0,99,0,0,0,103,0,0,0,118,0,0,0,81,0,0,0,12,0,0,0,125,0,0,0,88,0,0,0,61,0,0,0,110,0,0,0,26,0,0,0,36,0,0,0,106,0,0,0,93,0,0,0,52,0,0,0,75,0,0,0,41,0,0,0,72,0,0,0,85,0,0,0,80,0,0,0,102,0,0,0,60,0,0,0,124,0,0,0,105,0,0,0,25,0,0,0,40,0,0,0,51,0,0,0,101,0,0,0,84,0,0,0,24,0,0,0,123,0,0,0,83,0,0,0,50,0,0,0,49,0,0,0,122,0,0,0,120,0,0,0,121,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,136,0,0,0,5,0,0,0,144,0,0,0,6,0,0,0,152,0,0,0,9,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,253,255,255,255,254,255,255,255,0,0,0,0,112,2,0,0,168,2,0,0,200,2,0,0,112,2,0,0,168,2,0,0,168,2,0,0,208,2,0,0,168,2,0,0,112,2,0,0,168,2,0,0,208,2,0,0,168,2,0,0,112,2,0,0,168,2,0,0,168,2,0,0,104,1,0,0,168,2,0,0,168,2,0,0,168,2,0,0,168,2,0,0,168,2,0,0,104,1,0,0,168,2,0,0,168,2,0,0,168,2,0,0,168,2,0,0,168,2,0,0,168,2,0,0,0,0,0,0,32,2,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,96,2,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,0,0,0,0,80,2,0,0,3,0,0,0,7,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,216,2,0,0,3,0,0,0,8,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,232,2,0,0,3,0,0,0,9,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,240,10,0,0,96,11,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,5,0,0,0,139,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,5,0,0,0,131,65,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,5,0,0,0,7,0,0,0,11,0,0,0,13,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,29,0,0,0,31,0,0,0,37,0,0,0,41,0,0,0,43,0,0,0,47,0,0,0,53,0,0,0,59,0,0,0,61,0,0,0,67,0,0,0,71,0,0,0,73,0,0,0,79,0,0,0,83,0,0,0,89,0,0,0,97,0,0,0,101,0,0,0,103,0,0,0,107,0,0,0,109,0,0,0,113,0,0,0,127,0,0,0,131,0,0,0,137,0,0,0,139,0,0,0,149,0,0,0,151,0,0,0,157,0,0,0,163,0,0,0,167,0,0,0,173,0,0,0,179,0,0,0,181,0,0,0,191,0,0,0,193,0,0,0,197,0,0,0,199,0,0,0,211,0,0,0,1,0,0,0,11,0,0,0,13,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,29,0,0,0,31,0,0,0,37,0,0,0,41,0,0,0,43,0,0,0,47,0,0,0,53,0,0,0,59,0,0,0,61,0,0,0,67,0,0,0,71,0,0,0,73,0,0,0,79,0,0,0,83,0,0,0,89,0,0,0,97,0,0,0,101,0,0,0,103,0,0,0,107,0,0,0,109,0,0,0,113,0,0,0,121,0,0,0,127,0,0,0,131,0,0,0,137,0,0,0,139,0,0,0,143,0,0,0,149,0,0,0,151,0,0,0,157,0,0,0,163,0,0,0,167,0,0,0,169,0,0,0,173,0,0,0,179,0,0,0,181,0,0,0,187,0,0,0,191,0,0,0,193,0,0,0,197,0,0,0,199,0,0,0,209,0,0,0,69,114,114,111,114,58,32,108,97,98,101,108,105,110,103,32,119,111,114,107,32,111,118,101,114,102,108,111,119,46,10,0,69,114,114,111,114,58,32,85,110,115,117,112,112,111,114,116,101,100,32,112,105,120,101,108,32,102,111,114,109,97,116,32,40,37,100,41,32,114,101,113,117,101,115,116,101,100,46,10,0,85,110,107,110,111,119,110,32,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,108,97,98,101,108,105,110,103,32,116,104,114,101,115,104,111,108,100,32,109,111,100,101,32,114,101,113,117,101,115,116,101,100,46,32,83,101,116,32,116,111,32,109,97,110,117,97,108,46,10,0,76,97,98,101,108,105,110,103,32,116,104,114,101,115,104,111,108,100,32,109,111,100,101,32,115,101,116,32,116,111,32,37,115,46,10,0,77,65,78,85,65,76,0,65,85,84,79,95,77,69,68,73,65,78,0,65,85,84,79,95,79,84,83,85,0,65,85,84,79,95,65,68,65,80,84,73,86,69,65,85,84,79,95,66,82,65,67,75,69,84,73,78,71,0,65,117,116,111,32,116,104,114,101,115,104,111,108,100,32,40,98,114,97,99,107,101,116,41,32,109,97,114,107,101,114,32,99,111,117,110,116,115,32,45,91,37,51,100,58,32,37,51,100,93,32,91,37,51,100,58,32,37,51,100,93,32,91,37,51,100,58,32,37,51,100,93,43,46,10,0,65,117,116,111,32,116,104,114,101,115,104,111,108,100,32,40,98,114,97,99,107,101,116,41,32,97,100,106,117,115,116,101,100,32,116,104,114,101,115,104,111,108,100,32,116,111,32,37,100,46,10,0,109,101,100,105,97,110,0,79,116,115,117,0,65,117,116,111,32,116,104,114,101,115,104,111,108,100,32,40,37,115,41,32,97,100,106,117,115,116,101,100,32,116,104,114,101,115,104,111,108,100,32,116,111,32,37,100,46,10,0,63,63,63,32,49,10,0,63,63,63,32,50,10,0,63,63,63,32,51,10,0,69,114,114,111,114,58,32,85,110,115,117,112,112,111,114,116,101,100,32,112,105,120,101,108,32,102,111,114,109,97,116,32,112,97,115,115,101,100,32,116,111,32,97,114,73,109,97,103,101,80,114,111,99,72,105,115,116,40,41,46,10,0,0,0,0,1,0,1,1,1,0,2,4,255,255,5,3,1,0,2,255,6,7,255,3,1,2,2,3,2,3,2,3,3,0,255,4,6,7,5,255,1,4,5,4,4,5,5,4,5,7,6,6,6,7,7,7,6,255,2,4,6,7,5,3,255,0,1,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,1,0,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,0,255,255,3,255,5,6,255,255,9,10,255,12,255,255,15,255,17,18,255,20,255,255,23,24,255,255,27,255,29,30,255,255,1,2,255,4,255,255,7,8,255,255,11,255,13,14,255,16,255,255,19,255,21,22,255,255,25,26,255,28,255,255,31,69,114,114,111,114,58,32,117,110,115,117,112,112,111,114,116,101,100,32,112,105,120,101,108,32,102,111,114,109,97,116,46,10,0,69,114,114,111,114,58,32,78,85,76,76,32,112,97,116,116,72,97,110,100,108,101,46,10,0,69,114,114,111,114,58,32,99,97,110,39,116,32,108,111,97,100,32,112,97,116,116,101,114,110,32,102,114,111,109,32,78,85,76,76,32,98,117,102,102,101,114,46,10,0,69,114,114,111,114,58,32,111,117,116,32,111,102,32,109,101,109,111,114,121,46,10,0,32,9,10,13,0,80,97,116,116,101,114,110,32,68,97,116,97,32,114,101,97,100,32,101,114,114,111,114,33,33,10,0,69,114,114,111,114,32,111,112,101,110,105,110,103,32,112,97,116,116,101,114,110,32,102,105,108,101,32,39,37,115,39,32,102,111,114,32,114,101,97,100,105,110,103,46,10,0,69,114,114,111,114,32,114,101,97,100,105,110,103,32,112,97,116,116,101,114,110,32,102,105,108,101,32,39,37,115,39,46,10,0,114,98,0,69,114,114,111,114,32,40,37,100,41,58,32,117,110,97,98,108,101,32,116,111,32,111,112,101,110,32,99,97,109,101,114,97,32,112,97,114,97,109,101,116,101,114,115,32,102,105,108,101,32,34,37,115,34,32,102,111,114,32,114,101,97,100,105,110,103,46,10,0,69,114,114,111,114,32,40,37,100,41,58,32,117,110,97,98,108,101,32,116,111,32,100,101,116,101,114,109,105,110,101,32,102,105,108,101,32,108,101,110,103,116,104,46,0,69,114,114,111,114,58,32,115,117,112,112,108,105,101,100,32,102,105,108,101,32,100,111,101,115,32,110,111,116,32,97,112,112,101,97,114,32,116,111,32,98,101,32,97,110,32,65,82,84,111,111,108,75,105,116,32,99,97,109,101,114,97,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,46,10,0,69,114,114,111,114,32,40,37,100,41,58,32,117,110,97,98,108,101,32,116,111,32,114,101,97,100,32,102,114,111,109,32,102,105,108,101,46,0,69,114,114,111,114,58,32,105,99,112,71,101,116,74,95,85,95,88,99,0,69,114,114,111,114,58,32,109,97,108,108,111,99,10,0,69,114,114,111,114,32,49,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,50,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,51,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,52,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,53,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,54,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,69,114,114,111,114,32,55,58,32,105,99,112,71,101,116,73,110,105,116,88,119,50,88,99,10,0,114,0,69,114,114,111,114,58,32,117,110,97,98,108,101,32,116,111,32,111,112,101,110,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,46,10,0,37,115,37,115,10,0,37,100,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,58,32,70,105,114,115,116,32,108,105,110,101,32,109,117,115,116,32,98,101,32,110,117,109,98,101,114,32,111,102,32,109,97,114,107,101,114,32,99,111,110,102,105,103,115,32,116,111,32,114,101,97,100,46,10,0,79,117,116,32,111,102,32,109,101,109,111,114,121,33,33,10,0,37,108,108,117,37,99,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,58,32,112,97,116,116,101,114,110,32,39,37,115,39,32,115,112,101,99,105,102,105,101,100,32,105,110,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,119,104,105,108,101,32,105,110,32,98,97,114,99,111,100,101,45,111,110,108,121,32,109,111,100,101,46,10,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,58,32,85,110,97,98,108,101,32,116,111,32,100,101,116,101,114,109,105,110,101,32,100,105,114,101,99,116,111,114,121,32,110,97,109,101,46,10,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,58,32,85,110,97,98,108,101,32,116,111,32,108,111,97,100,32,112,97,116,116,101,114,110,32,39,37,115,39,46,10,0,37,108,102,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,44,32,109,97,114,107,101,114,32,100,101,102,105,110,105,116,105,111,110,32,37,51,100,58,32,70,105,114,115,116,32,108,105,110,101,32,109,117,115,116,32,98,101,32,112,97,116,116,101,114,110,32,119,105,100,116,104,46,10,0,37,108,102,32,37,108,102,32,37,108,102,32,37,108,102,0,37,102,32,37,102,0,69,114,114,111,114,32,112,114,111,99,101,115,115,105,110,103,32,109,117,108,116,105,109,97,114,107,101,114,32,99,111,110,102,105,103,32,102,105,108,101,32,39,37,115,39,44,32,109,97,114,107,101,114,32,100,101,102,105,110,105,116,105,111,110,32,37,51,100,58,32,76,105,110,101,115,32,50,32,45,32,52,32,109,117,115,116,32,98,101,32,109,97,114,107,101,114,32,116,114,97,110,115,102,111,114,109,46,10,0,97,114,103,108,67,97,109,101,114,97,70,114,117,115,116,117,109,40,41,58,32,97,114,80,97,114,97,109,68,101,99,111,109,112,77,97,116,40,41,32,105,110,100,105,99,97,116,101,100,32,112,97,114,97,109,101,116,101,114,32,101,114,114,111,114,46,10,0,108,111,97,100,67,97,109,101,114,97,40,41,58,32,69,114,114,111,114,32,108,111,97,100,105,110,103,32,112,97,114,97,109,101,116,101,114,32,102,105,108,101,32,37,115,32,102,111,114,32,99,97,109,101,114,97,46,10,0,42,42,42,32,67,97,109,101,114,97,32,80,97,114,97,109,101,116,101,114,32,114,101,115,105,122,101,100,32,102,114,111,109,32,37,100,44,32,37,100,46,32,42,42,42,10,0,115,101,116,67,97,109,101,114,97,40,41,58,32,69,114,114,111,114,58,32,97,114,80,97,114,97,109,76,84,67,114,101,97,116,101,46,10,0,115,101,116,67,97,109,101,114,97,40,41,58,32,69,114,114,111,114,58,32,97,114,67,114,101,97,116,101,72,97,110,100,108,101,46,10,0,115,101,116,67,97,109,101,114,97,40,41,58,32,69,114,114,111,114,32,99,114,101,97,116,105,110,103,32,51,68,32,104,97,110,100,108,101,0,108,111,97,100,77,97,114,107,101,114,40,41,58,32,69,114,114,111,114,32,108,111,97,100,105,110,103,32,112,97,116,116,101,114,110,32,102,105,108,101,32,37,115,46,10,0,65,82,84,111,111,108,75,105,116,74,83,40,41,58,32,85,110,97,98,108,101,32,116,111,32,115,101,116,32,117,112,32,65,82,32,109,97,114,107,101,114,46,10,0,99,111,110,102,105,103,32,100,97,116,97,32,108,111,97,100,32,101,114,114,111,114,32,33,33,10,0,65,82,84,111,111,108,75,105,116,74,83,40,41,58,32,85,110,97,98,108,101,32,116,111,32,115,101,116,32,117,112,32,65,82,32,109,117,108,116,105,109,97,114,107,101,114,46,10,0,80,97,116,116,101,114,110,32,100,101,116,101,99,116,105,111,110,32,109,111,100,101,32,115,101,116,32,116,111,32,37,100,46,10,0,80,97,116,116,101,114,110,32,114,97,116,105,111,32,115,105,122,101,32,115,101,116,32,116,111,32,37,102,46,10,0,76,97,98,101,108,105,110,103,32,109,111,100,101,32,115,101,116,32,116,111,32,37,100,10,0,84,104,114,101,115,104,111,108,100,32,115,101,116,32,116,111,32,37,100,10,0,84,104,114,101,115,104,111,108,100,32,109,111,100,101,32,115,101,116,32,116,111,32,37,100,10,0,111,110,46,0,111,102,102,46,0,68,101,98,117,103,32,109,111,100,101,32,115,101,116,32,116,111,32,37,115,10,0,73,109,97,103,101,32,112,114,111,99,46,32,109,111,100,101,32,115,101,116,32,116,111,32,37,100,46,10,0,123,32,105,102,32,40,33,97,114,116,111,111,108,107,105,116,91,34,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,73,110,102,111,34,93,41,32,123,32,97,114,116,111,111,108,107,105,116,91,34,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,73,110,102,111,34,93,32,61,32,40,123,125,41,59,32,125,32,118,97,114,32,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,32,61,32,97,114,116,111,111,108,107,105,116,91,34,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,73,110,102,111,34,93,59,32,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,91,39,118,105,115,105,98,108,101,39,93,32,61,32,36,48,59,32,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,91,39,112,97,116,116,73,100,39,93,32,61,32,36,49,59,32,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,91,39,112,97,116,116,84,121,112,101,39,93,32,61,32,36,50,59,32,109,117,108,116,105,69,97,99,104,77,97,114,107,101,114,91,39,119,105,100,116,104,39,93,32,61,32,36,51,59,32,125,0,123,32,118,97,114,32,36,97,32,61,32,97,114,103,117,109,101,110,116,115,59,32,118,97,114,32,105,32,61,32,49,50,59,32,105,102,32,40,33,97,114,116,111,111,108,107,105,116,91,34,109,97,114,107,101,114,73,110,102,111,34,93,41,32,123,32,97,114,116,111,111,108,107,105,116,91,34,109,97,114,107,101,114,73,110,102,111,34,93,32,61,32,40,123,32,112,111,115,58,32,91,48,44,48,93,44,32,108,105,110,101,58,32,91,91,48,44,48,44,48,93,44,32,91,48,44,48,44,48,93,44,32,91,48,44,48,44,48,93,44,32,91,48,44,48,44,48,93,93,44,32,118,101,114,116,101,120,58,32,91,91,48,44,48,93,44,32,91,48,44,48,93,44,32,91,48,44,48,93,44,32,91,48,44,48,93,93,32,125,41,59,32,125,32,118,97,114,32,109,97,114,107,101,114,73,110,102,111,32,61,32,97,114,116,111,111,108,107,105,116,91,34,109,97,114,107,101,114,73,110,102,111,34,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,97,114,101,97,34,93,32,61,32,36,48,59,32,109,97,114,107,101,114,73,110,102,111,91,34,105,100,34,93,32,61,32,36,49,59,32,109,97,114,107,101,114,73,110,102,111,91,34,105,100,80,97,116,116,34,93,32,61,32,36,50,59,32,109,97,114,107,101,114,73,110,102,111,91,34,105,100,77,97,116,114,105,120,34,93,32,61,32,36,51,59,32,109,97,114,107,101,114,73,110,102,111,91,34,100,105,114,34,93,32,61,32,36,52,59,32,109,97,114,107,101,114,73,110,102,111,91,34,100,105,114,80,97,116,116,34,93,32,61,32,36,53,59,32,109,97,114,107,101,114,73,110,102,111,91,34,100,105,114,77,97,116,114,105,120,34,93,32,61,32,36,54,59,32,109,97,114,107,101,114,73,110,102,111,91,34,99,102,34,93,32,61,32,36,55,59,32,109,97,114,107,101,114,73,110,102,111,91,34,99,102,80,97,116,116,34,93,32,61,32,36,56,59,32,109,97,114,107,101,114,73,110,102,111,91,34,99,102,77,97,116,114,105,120,34,93,32,61,32,36,57,59,32,109,97,114,107,101,114,73,110,102,111,91,34,112,111,115,34,93,91,48,93,32,61,32,36,49,48,59,32,109,97,114,107,101,114,73,110,102,111,91,34,112,111,115,34,93,91,49,93,32,61,32,36,49,49,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,48,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,48,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,48,93,91,50,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,49,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,49,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,49,93,91,50,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,50,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,50,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,50,93,91,50,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,51,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,51,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,108,105,110,101,34,93,91,51,93,91,50,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,48,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,48,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,49,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,49,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,50,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,50,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,51,93,91,48,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,118,101,114,116,101,120,34,93,91,51,93,91,49,93,32,61,32,36,97,91,105,43,43,93,59,32,109,97,114,107,101,114,73,110,102,111,91,34,101,114,114,111,114,67,111,114,114,101,99,116,101,100,34,93,32,61,32,36,97,91,105,43,43,93,59,32,125,0,115,101,116,117,112,40,41,58,32,69,114,114,111,114,58,32,97,114,80,97,116,116,67,114,101,97,116,101,72,97,110,100,108,101,46,10,0,65,108,108,111,99,97,116,101,100,32,118,105,100,101,111,70,114,97,109,101,83,105,122,101,32,37,100,10,0,123,32,105,102,32,40,33,97,114,116,111,111,108,107,105,116,91,34,102,114,97,109,101,77,97,108,108,111,99,34,93,41,32,123,32,97,114,116,111,111,108,107,105,116,91,34,102,114,97,109,101,77,97,108,108,111,99,34,93,32,61,32,40,123,125,41,59,32,125,32,118,97,114,32,102,114,97,109,101,77,97,108,108,111,99,32,61,32,97,114,116,111,111,108,107,105,116,91,34,102,114,97,109,101,77,97,108,108,111,99,34,93,59,32,102,114,97,109,101,77,97,108,108,111,99,91,34,102,114,97,109,101,112,111,105,110,116,101,114,34,93,32,61,32,36,49,59,32,102,114,97,109,101,77,97,108,108,111,99,91,34,102,114,97,109,101,115,105,122,101,34,93,32,61,32,36,50,59,32,102,114,97,109,101,77,97,108,108,111,99,91,34,99,97,109,101,114,97,34,93,32,61,32,36,51,59,32,102,114,97,109,101,77,97,108,108,111,99,91,34,116,114,97,110,115,102,111,114,109,34,93,32,61,32,36,52,59,32,125,0,115,101,116,117,112,0,116,101,97,114,100,111,119,110,0,95,97,100,100,77,97,114,107,101,114,0,95,97,100,100,77,117,108,116,105,77,97,114,107,101,114,0,103,101,116,77,117,108,116,105,77,97,114,107,101,114,78,117,109,0,103,101,116,77,117,108,116,105,77,97,114,107,101,114,67,111,117,110,116,0,95,108,111,97,100,67,97,109,101,114,97,0,115,101,116,77,97,114,107,101,114,73,110,102,111,68,105,114,0,115,101,116,77,97,114,107,101,114,73,110,102,111,86,101,114,116,101,120,0,103,101,116,84,114,97,110,115,77,97,116,83,113,117,97,114,101,0,103,101,116,84,114,97,110,115,77,97,116,83,113,117,97,114,101,67,111,110,116,0,103,101,116,84,114,97,110,115,77,97,116,77,117,108,116,105,83,113,117,97,114,101,0,103,101,116,84,114,97,110,115,77,97,116,77,117,108,116,105,83,113,117,97,114,101,82,111,98,117,115,116,0,100,101,116,101,99,116,77,97,114,107,101,114,0,103,101,116,77,97,114,107,101,114,78,117,109,0,103,101,116,77,117,108,116,105,69,97,99,104,77,97,114,107,101,114,0,103,101,116,77,97,114,107,101,114,0,115,101,116,68,101,98,117,103,77,111,100,101,0,103,101,116,68,101,98,117,103,77,111,100,101,0,103,101,116,80,114,111,99,101,115,115,105,110,103,73,109,97,103,101,0,115,101,116,76,111,103,76,101,118,101,108,0,103,101,116,76,111,103,76,101,118,101,108,0,115,101,116,80,114,111,106,101,99,116,105,111,110,78,101,97,114,80,108,97,110,101,0,103,101,116,80,114,111,106,101,99,116,105,111,110,78,101,97,114,80,108,97,110,101,0,115,101,116,80,114,111,106,101,99,116,105,111,110,70,97,114,80,108,97,110,101,0,103,101,116,80,114,111,106,101,99,116,105,111,110,70,97,114,80,108,97,110,101,0,115,101,116,84,104,114,101,115,104,111,108,100,77,111,100,101,0,103,101,116,84,104,114,101,115,104,111,108,100,77,111,100,101,0,115,101,116,84,104,114,101,115,104,111,108,100,0,103,101,116,84,104,114,101,115,104,111,108,100,0,115,101,116,80,97,116,116,101,114,110,68,101,116,101,99,116,105,111,110,77,111,100,101,0,103,101,116,80,97,116,116,101,114,110,68,101,116,101,99,116,105,111,110,77,111,100,101,0,115,101,116,80,97,116,116,82,97,116,105,111,0,103,101,116,80,97,116,116,82,97,116,105,111,0,115,101,116,77,97,116,114,105,120,67,111,100,101,84,121,112,101,0,103,101,116,77,97,116,114,105,120,67,111,100,101,84,121,112,101,0,115,101,116,76,97,98,101,108,105,110,103,77,111,100,101,0,103,101,116,76,97,98,101,108,105,110,103,77,111,100,101,0,115,101,116,73,109,97,103,101,80,114,111,99,77,111,100,101,0,103,101,116,73,109,97,103,101,80,114,111,99,77,111,100,101,0,69,82,82,79,82,95,65,82,67,79,78,84,82,79,76,76,69,82,95,78,79,84,95,70,79,85,78,68,0,69,82,82,79,82,95,77,85,76,84,73,77,65,82,75,69,82,95,78,79,84,95,70,79,85,78,68,0,69,82,82,79,82,95,77,65,82,75,69,82,95,73,78,68,69,88,95,79,85,84,95,79,70,95,66,79,85,78,68,83,0,65,82,95,68,69,66,85,71,95,68,73,83,65,66,76,69,0,65,82,95,68,69,66,85,71,95,69,78,65,66,76,69,0,65,82,95,68,69,70,65,85,76,84,95,68,69,66,85,71,95,77,79,68,69,0,65,82,95,76,65,66,69,76,73,78,71,95,87,72,73,84,69,95,82,69,71,73,79,78,0,65,82,95,76,65,66,69,76,73,78,71,95,66,76,65,67,75,95,82,69,71,73,79,78,0,65,82,95,68,69,70,65,85,76,84,95,76,65,66,69,76,73,78,71,95,77,79,68,69,0,65,82,95,68,69,70,65,85,76,84,95,76,65,66,69,76,73,78,71,95,84,72,82,69,83,72,0,65,82,95,73,77,65,71,69,95,80,82,79,67,95,70,82,65,77,69,95,73,77,65,71,69,0,65,82,95,73,77,65,71,69,95,80,82,79,67,95,70,73,69,76,68,95,73,77,65,71,69,0,65,82,95,68,69,70,65,85,76,84,95,73,77,65,71,69,95,80,82,79,67,95,77,79,68,69,0,65,82,95,84,69,77,80,76,65,84,69,95,77,65,84,67,72,73,78,71,95,67,79,76,79,82,0,65,82,95,84,69,77,80,76,65,84,69,95,77,65,84,67,72,73,78,71,95,77,79,78,79,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,68,69,84,69,67,84,73,79,78,0,65,82,95,84,69,77,80,76,65,84,69,95,77,65,84,67,72,73,78,71,95,67,79,76,79,82,95,65,78,68,95,77,65,84,82,73,88,0,65,82,95,84,69,77,80,76,65,84,69,95,77,65,84,67,72,73,78,71,95,77,79,78,79,95,65,78,68,95,77,65,84,82,73,88,0,65,82,95,68,69,70,65,85,76,84,95,80,65,84,84,69,82,78,95,68,69,84,69,67,84,73,79,78,95,77,79,68,69,0,65,82,95,85,83,69,95,84,82,65,67,75,73,78,71,95,72,73,83,84,79,82,89,0,65,82,95,78,79,85,83,69,95,84,82,65,67,75,73,78,71,95,72,73,83,84,79,82,89,0,65,82,95,85,83,69,95,84,82,65,67,75,73,78,71,95,72,73,83,84,79,82,89,95,86,50,0,65,82,95,68,69,70,65,85,76,84,95,77,65,82,75,69,82,95,69,88,84,82,65,67,84,73,79,78,95,77,79,68,69,0,65,82,95,77,65,88,95,76,79,79,80,95,67,79,85,78,84,0,65,82,95,76,79,79,80,95,66,82,69,65,75,95,84,72,82,69,83,72,0,65,82,95,76,79,71,95,76,69,86,69,76,95,68,69,66,85,71,0,65,82,95,76,79,71,95,76,69,86,69,76,95,73,78,70,79,0,65,82,95,76,79,71,95,76,69,86,69,76,95,87,65,82,78,0,65,82,95,76,79,71,95,76,69,86,69,76,95,69,82,82,79,82,0,65,82,95,76,79,71,95,76,69,86,69,76,95,82,69,76,95,73,78,70,79,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,51,120,51,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,51,120,51,95,72,65,77,77,73,78,71,54,51,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,51,120,51,95,80,65,82,73,84,89,54,53,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,52,120,52,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,52,120,52,95,66,67,72,95,49,51,95,57,95,51,0,65,82,95,77,65,84,82,73,88,95,67,79,68,69,95,52,120,52,95,66,67,72,95,49,51,95,53,95,53,0,65,82,95,76,65,66,69,76,73,78,71,95,84,72,82,69,83,72,95,77,79,68,69,95,77,65,78,85,65,76,0,65,82,95,76,65,66,69,76,73,78,71,95,84,72,82,69,83,72,95,77,79,68,69,95,65,85,84,79,95,77,69,68,73,65,78,0,65,82,95,76,65,66], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate([69,76,73,78,71,95,84,72,82,69,83,72,95,77,79,68,69,95,65,85,84,79,95,79,84,83,85,0,65,82,95,76,65,66,69,76,73,78,71,95,84,72,82,69,83,72,95,77,79,68,69,95,65,85,84,79,95,65,68,65,80,84,73,86,69,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,78,79,78,69,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,80,65,84,84,69,82,78,95,69,88,84,82,65,67,84,73,79,78,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,77,65,84,67,72,95,71,69,78,69,82,73,67,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,77,65,84,67,72,95,67,79,78,84,82,65,83,84,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,77,65,84,67,72,95,66,65,82,67,79,68,69,95,78,79,84,95,70,79,85,78,68,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,77,65,84,67,72,95,66,65,82,67,79,68,69,95,69,68,67,95,70,65,73,76,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,77,65,84,67,72,95,67,79,78,70,73,68,69,78,67,69,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,80,79,83,69,95,69,82,82,79,82,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,80,79,83,69,95,69,82,82,79,82,95,77,85,76,84,73,0,65,82,95,77,65,82,75,69,82,95,73,78,70,79,95,67,85,84,79,70,70,95,80,72,65,83,69,95,72,69,85,82,73,83,84,73,67,95,84,82,79,85,66,76,69,83,79,77,69,95,77,65,84,82,73,88,95,67,79,68,69,83,0,118,105,105,102,0,118,105,105,105,0,100,105,105,0,118,105,105,100,0,105,105,0,118,105,105,0,105,105,105,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,83,116,51,95,95,49,50,49,95,95,98,97,115,105,99,95,115,116,114,105,110,103,95,99,111,109,109,111,110,73,76,98,49,69,69,69,0,105,105,105,105,0,105,105,105,105,105,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,60,117,110,115,105,103,110,101,100,32,99,104,97,114,62,0,115,116,100,58,58,119,115,116,114,105,110,103,0,101,109,115,99,114,105,112,116,101,110,58,58,118,97,108,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,115,105,103,110,101,100,32,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,99,104,97,114,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,115,104,111,114,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,115,104,111,114,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,105,110,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,108,111,110,103,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,110,115,105,103,110,101,100,32,108,111,110,103,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,56,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,56,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,49,54,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,49,54,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,105,110,116,51,50,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,117,105,110,116,51,50,95,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,102,108,111,97,116,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,100,111,117,98,108,101,62,0,101,109,115,99,114,105,112,116,101,110,58,58,109,101,109,111,114,121,95,118,105,101,119,60,108,111,110,103,32,100,111,117,98,108,101,62,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,101,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,100,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,102,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,109,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,108,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,106,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,105,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,116,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,115,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,104,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,97,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,99,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,51,118,97,108,69,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,104,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,104,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,104,69,69,69,69,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,51,95,95,102,117,110,100,97,109,101,110,116,97,108,95,116,121,112,101,95,105,110,102,111,69,0,118,0,98,0,99,0,104,0,97,0,115,0,116,0,105,0,106,0,109,0,102,0,100,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,106,101,114,111,109,101,101,116,105,101,110,110,101,47,119,111,114,107,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,118,101,99,116,111,114,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,106,101,114,111,109,101,101,116,105,101,110,110,101,47,119,111,114,107,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,115,116,114,105,110,103,0,32,40,0,41,0,95,98,108,111,99,107,95,105,110,118,111,107,101,0,105,110,118,111,99,97,116,105,111,110,32,102,117,110,99,116,105,111,110,32,102,111,114,32,98,108,111,99,107,32,105,110,32,0,32,99,111,110,115,116,0,32,118,111,108,97,116,105,108,101,0,32,114,101,115,116,114,105,99,116,0,32,91,0,32,91,93,0,93,0,32,99,111,109,112,108,101,120,0,40,0,44,32,0,32,38,0,32,38,38,0,32,0,32,105,109,97,103,105,110,97,114,121,0,58,58,42,0,38,38,0,111,98,106,99,95,111,98,106,101,99,116,60,0,42,0,105,100,0,38,0,111,98,106,99,112,114,111,116,111,0,60,0,62,0,32,118,101,99,116,111,114,91,0,112,105,120,101,108,32,118,101,99,116,111,114,91,0,100,101,99,108,116,121,112,101,40,0,115,116,100,58,58,97,108,108,111,99,97,116,111,114,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,0,115,116,100,58,58,115,116,114,105,110,103,0,115,116,100,58,58,105,115,116,114,101,97,109,0,115,116,100,58,58,111,115,116,114,101,97,109,0,115,116,100,58,58,105,111,115,116,114,101,97,109,0,115,116,100,0,58,58,0,58,58,115,116,114,105,110,103,32,108,105,116,101,114,97,108,0,115,116,100,58,58,0,126,0,39,117,110,110,97,109,101,100,0,39,108,97,109,98,100,97,39,40,0,111,112,101,114,97,116,111,114,38,38,0,111,112,101,114,97,116,111,114,38,0,111,112,101,114,97,116,111,114,38,61,0,111,112,101,114,97,116,111,114,61,0,111,112,101,114,97,116,111,114,40,41,0,111,112,101,114,97,116,111,114,44,0,111,112,101,114,97,116,111,114,126,0,111,112,101,114,97,116,111,114,32,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,91,93,0,111,112,101,114,97,116,111,114,42,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,0,111,112,101,114,97,116,111,114,47,0,111,112,101,114,97,116,111,114,47,61,0,111,112,101,114,97,116,111,114,94,0,111,112,101,114,97,116,111,114,94,61,0,111,112,101,114,97,116,111,114,61,61,0,111,112,101,114,97,116,111,114,62,61,0,111,112,101,114,97,116,111,114,62,0,111,112,101,114,97,116,111,114,91,93,0,111,112,101,114,97,116,111,114,60,61,0,111,112,101,114,97,116,111,114,34,34,32,0,111,112,101,114,97,116,111,114,60,60,0,111,112,101,114,97,116,111,114,60,60,61,0,111,112,101,114,97,116,111,114,60,0,111,112,101,114,97,116,111,114,45,0,111,112,101,114,97,116,111,114,45,61,0,111,112,101,114,97,116,111,114,42,61,0,111,112,101,114,97,116,111,114,45,45,0,111,112,101,114,97,116,111,114,32,110,101,119,91,93,0,111,112,101,114,97,116,111,114,33,61,0,111,112,101,114,97,116,111,114,33,0,111,112,101,114,97,116,111,114,32,110,101,119,0,111,112,101,114,97,116,111,114,124,124,0,111,112,101,114,97,116,111,114,124,0,111,112,101,114,97,116,111,114,124,61,0,111,112,101,114,97,116,111,114,45,62,42,0,111,112,101,114,97,116,111,114,43,0,111,112,101,114,97,116,111,114,43,61,0,111,112,101,114,97,116,111,114,43,43,0,111,112,101,114,97,116,111,114,45,62,0,111,112,101,114,97,116,111,114,63,0,111,112,101,114,97,116,111,114,37,0,111,112,101,114,97,116,111,114,37,61,0,111,112,101,114,97,116,111,114,62,62,0,111,112,101,114,97,116,111,114,62,62,61,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,44,32,115,116,100,58,58,97,108,108,111,99,97,116,111,114,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,115,116,114,105,110,103,0,115,116,100,58,58,98,97,115,105,99,95,105,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,111,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,105,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,111,115,116,114,101,97,109,0,95,71,76,79,66,65,76,95,95,78,0,40,97,110,111,110,121,109,111,117,115,32,110,97,109,101,115,112,97,99,101,41,0,32,62,0,119,99,104,97,114,95,116,0,102,97,108,115,101,0,116,114,117,101,0,99,104,97,114,0,115,105,103,110,101,100,32,99,104,97,114,0,117,110,115,105,103,110,101,100,32,99,104,97,114,0,115,104,111,114,116,0,117,110,115,105,103,110,101,100,32,115,104,111,114,116,0,0,117,0,108,0,117,108,0,108,108,0,117,108,108,0,95,95,105,110,116,49,50,56,0,117,110,115,105,103,110,101,100,32,95,95,105,110,116,49,50,56,0,37,97,102,0,37,97,0,37,76,97,76,0,38,61,0,61,0,97,108,105,103,110,111,102,32,40,0,99,111,110,115,116,95,99,97,115,116,60,0,62,40,0,44,0,41,40,0,100,101,108,101,116,101,91,93,32,0,100,121,110,97,109,105,99,95,99,97,115,116,60,0,100,101,108,101,116,101,32,0,46,42,0,47,0,47,61,0,94,0,94,61,0,61,61,0,62,61,0,41,91,0,60,61,0,60,60,0,60,60,61,0,45,0,45,61,0,42,61,0,45,45,0,41,45,45,0,91,93,32,0,41,32,0,33,61,0,33,0,110,111,101,120,99,101,112,116,32,40,0,124,124,0,124,0,124,61,0,45,62,42,0,43,0,43,61,0,43,43,0,41,43,43,0,45,62,0,41,32,63,32,40,0,41,32,58,32,40,0,114,101,105,110,116,101,114,112,114,101,116,95,99,97,115,116,60,0,37,0,37,61,0,62,62,0,62,62,61,0,115,116,97,116,105,99,95,99,97,115,116,60,0,115,105,122,101,111,102,32,40,0,115,105,122,101,111,102,46,46,46,40,0,116,121,112,101,105,100,40,0,116,104,114,111,119,0,116,104,114,111,119,32,0,102,112,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,111,117,116,95,111,102,95,114,97,110,103,101,34,0,95,95,116,104,114,111,119,95,111,117,116,95,111,102,95,114,97,110,103,101,0,118,111,105,100,0,98,111,111,108,0,105,110,116,0,117,110,115,105,103,110,101,100,32,105,110,116,0,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,0,108,111,110,103,32,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,32,108,111,110,103,0,102,108,111,97,116,0,100,111,117,98,108,101,0,108,111,110,103,32,100,111,117,98,108,101,0,95,95,102,108,111,97,116,49,50,56,0,46,46,46,0,100,101,99,105,109,97,108,54,52,0,100,101,99,105,109,97,108,49,50,56,0,100,101,99,105,109,97,108,51,50,0,100,101,99,105,109,97,108,49,54,0,99,104,97,114,51,50,95,116,0,99,104,97,114,49,54,95,116,0,97,117,116,111,0,115,116,100,58,58,110,117,108,108,112,116,114,95,116,0,118,116,97,98,108,101,32,102,111,114,32,0,86,84,84,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,110,97,109,101,32,102,111,114,32,0,99,111,118,97,114,105,97,110,116,32,114,101,116,117,114,110,32,116,104,117,110,107,32,116,111,32,0,99,111,110,115,116,114,117,99,116,105,111,110,32,118,116,97,98,108,101,32,102,111,114,32,0,45,105,110,45,0,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,110,111,110,45,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,103,117,97,114,100,32,118,97,114,105,97,98,108,101,32,102,111,114,32,0,114,101,102,101,114,101,110,99,101,32,116,101,109,112,111,114,97,114,121,32,102,111,114,32,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,114,119,97], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+10240);
/* memory initializer */ allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+17795);





/* no memory initializer */
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


  
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }function ___cxa_atexit() {
  return _atexit.apply(null, arguments)
  }

   
  Module["_i64Subtract"] = _i64Subtract;

  function ___assert_fail(condition, filename, line, func) {
      ABORT = true;
      throw 'Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + stackTrace();
    }

  
  
  
  function embind_init_charCodes() {
      var codes = new Array(256);
      for (var i = 0; i < 256; ++i) {
          codes[i] = String.fromCharCode(i);
      }
      embind_charCodes = codes;
    }var embind_charCodes=undefined;function readLatin1String(ptr) {
      var ret = "";
      var c = ptr;
      while (HEAPU8[c]) {
          ret += embind_charCodes[HEAPU8[c++]];
      }
      return ret;
    }
  
  
  var awaitingDependencies={};
  
  var registeredTypes={};
  
  var typeDependencies={};
  
  
  
  
  
  
  var char_0=48;
  
  var char_9=57;function makeLegalFunctionName(name) {
      if (undefined === name) {
          return '_unknown';
      }
      name = name.replace(/[^a-zA-Z0-9_]/g, '$');
      var f = name.charCodeAt(0);
      if (f >= char_0 && f <= char_9) {
          return '_' + name;
      } else {
          return name;
      }
    }function createNamedFunction(name, body) {
      name = makeLegalFunctionName(name);
      /*jshint evil:true*/
      return new Function(
          "body",
          "return function " + name + "() {\n" +
          "    \"use strict\";" +
          "    return body.apply(this, arguments);\n" +
          "};\n"
      )(body);
    }function extendError(baseErrorType, errorName) {
      var errorClass = createNamedFunction(errorName, function(message) {
          this.name = errorName;
          this.message = message;
  
          var stack = (new Error(message)).stack;
          if (stack !== undefined) {
              this.stack = this.toString() + '\n' +
                  stack.replace(/^Error(:[^\n]*)?\n/, '');
          }
      });
      errorClass.prototype = Object.create(baseErrorType.prototype);
      errorClass.prototype.constructor = errorClass;
      errorClass.prototype.toString = function() {
          if (this.message === undefined) {
              return this.name;
          } else {
              return this.name + ': ' + this.message;
          }
      };
  
      return errorClass;
    }var BindingError=undefined;function throwBindingError(message) {
      throw new BindingError(message);
    }
  
  
  
  var InternalError=undefined;function throwInternalError(message) {
      throw new InternalError(message);
    }function whenDependentTypesAreResolved(myTypes, dependentTypes, getTypeConverters) {
      myTypes.forEach(function(type) {
          typeDependencies[type] = dependentTypes;
      });
  
      function onComplete(typeConverters) {
          var myTypeConverters = getTypeConverters(typeConverters);
          if (myTypeConverters.length !== myTypes.length) {
              throwInternalError('Mismatched type converter count');
          }
          for (var i = 0; i < myTypes.length; ++i) {
              registerType(myTypes[i], myTypeConverters[i]);
          }
      }
  
      var typeConverters = new Array(dependentTypes.length);
      var unregisteredTypes = [];
      var registered = 0;
      dependentTypes.forEach(function(dt, i) {
          if (registeredTypes.hasOwnProperty(dt)) {
              typeConverters[i] = registeredTypes[dt];
          } else {
              unregisteredTypes.push(dt);
              if (!awaitingDependencies.hasOwnProperty(dt)) {
                  awaitingDependencies[dt] = [];
              }
              awaitingDependencies[dt].push(function() {
                  typeConverters[i] = registeredTypes[dt];
                  ++registered;
                  if (registered === unregisteredTypes.length) {
                      onComplete(typeConverters);
                  }
              });
          }
      });
      if (0 === unregisteredTypes.length) {
          onComplete(typeConverters);
      }
    }function registerType(rawType, registeredInstance, options) {
      options = options || {};
  
      if (!('argPackAdvance' in registeredInstance)) {
          throw new TypeError('registerType registeredInstance requires argPackAdvance');
      }
  
      var name = registeredInstance.name;
      if (!rawType) {
          throwBindingError('type "' + name + '" must have a positive integer typeid pointer');
      }
      if (registeredTypes.hasOwnProperty(rawType)) {
          if (options.ignoreDuplicateRegistrations) {
              return;
          } else {
              throwBindingError("Cannot register type '" + name + "' twice");
          }
      }
  
      registeredTypes[rawType] = registeredInstance;
      delete typeDependencies[rawType];
  
      if (awaitingDependencies.hasOwnProperty(rawType)) {
          var callbacks = awaitingDependencies[rawType];
          delete awaitingDependencies[rawType];
          callbacks.forEach(function(cb) {
              cb();
          });
      }
    }function __embind_register_void(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          isVoid: true, // void return values can be optimized out sometimes
          name: name,
          'argPackAdvance': 0,
          'fromWireType': function() {
              return undefined;
          },
          'toWireType': function(destructors, o) {
              // TODO: assert if anything else is given?
              return undefined;
          },
      });
    }

  
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  
  
  
  var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:function (adjusted) {
        if (!adjusted || EXCEPTIONS.infos[adjusted]) return adjusted;
        for (var ptr in EXCEPTIONS.infos) {
          var info = EXCEPTIONS.infos[ptr];
          if (info.adjusted === adjusted) {
            return ptr;
          }
        }
        return adjusted;
      },addRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount++;
      },decRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        assert(info.refcount > 0);
        info.refcount--;
        if (info.refcount === 0) {
          if (info.destructor) {
            Runtime.dynCall('vi', info.destructor, [ptr]);
          }
          delete EXCEPTIONS.infos[ptr];
          ___cxa_free_exception(ptr);
        }
      },clearRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount = 0;
      }};
  function ___resumeException(ptr) {
      if (!EXCEPTIONS.last) { EXCEPTIONS.last = ptr; }
      EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr)); // exception refcount should be cleared, but don't free it
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
    }function ___cxa_find_matching_catch() {
      var thrown = EXCEPTIONS.last;
      if (!thrown) {
        // just pass through the null ptr
        return ((asm["setTempRet0"](0),0)|0);
      }
      var info = EXCEPTIONS.infos[thrown];
      var throwntype = info.type;
      if (!throwntype) {
        // just pass through the thrown ptr
        return ((asm["setTempRet0"](0),thrown)|0);
      }
      var typeArray = Array.prototype.slice.call(arguments);
  
      var pointer = Module['___cxa_is_pointer_type'](throwntype);
      // can_catch receives a **, add indirection
      if (!___cxa_find_matching_catch.buffer) ___cxa_find_matching_catch.buffer = _malloc(4);
      HEAP32[((___cxa_find_matching_catch.buffer)>>2)]=thrown;
      thrown = ___cxa_find_matching_catch.buffer;
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (typeArray[i] && Module['___cxa_can_catch'](typeArray[i], throwntype, thrown)) {
          thrown = HEAP32[((thrown)>>2)]; // undo indirection
          info.adjusted = thrown;
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
        }
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      thrown = HEAP32[((thrown)>>2)]; // undo indirection
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      EXCEPTIONS.infos[ptr] = {
        ptr: ptr,
        adjusted: ptr,
        type: type,
        destructor: destructor,
        refcount: 0
      };
      EXCEPTIONS.last = ptr;
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
    }

   
  Module["_memset"] = _memset;

  var _BDtoILow=true;

  
  function getShiftFromSize(size) {
      switch (size) {
          case 1: return 0;
          case 2: return 1;
          case 4: return 2;
          case 8: return 3;
          default:
              throw new TypeError('Unknown type size: ' + size);
      }
    }function __embind_register_bool(rawType, name, size, trueValue, falseValue) {
      var shift = getShiftFromSize(size);
  
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(wt) {
              // ambiguous emscripten ABI: sometimes return values are
              // true or false, and sometimes integers (0 or 1)
              return !!wt;
          },
          'toWireType': function(destructors, o) {
              return o ? trueValue : falseValue;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': function(pointer) {
              // TODO: if heap is fixed (like in asm.js) this could be executed outside
              var heap;
              if (size === 1) {
                  heap = HEAP8;
              } else if (size === 2) {
                  heap = HEAP16;
              } else if (size === 4) {
                  heap = HEAP32;
              } else {
                  throw new TypeError("Unknown boolean type size: " + name);
              }
              return this['fromWireType'](heap[pointer >> shift]);
          },
          destructorFunction: null, // This type does not need a destructor
      });
    }

   
  Module["_bitshift64Shl"] = _bitshift64Shl;

  function _abort() {
      Module['abort']();
    }

  
  function _free() {
  }
  Module["_free"] = _free;
  
  function _malloc(bytes) {
      /* Over-allocate to make sure it is byte-aligned by 8.
       * This will leak memory, but this is only the dummy
       * implementation (replaced by dlmalloc normally) so
       * not an issue.
       */
      var ptr = Runtime.dynamicAlloc(bytes + 8);
      return (ptr+8) & 0xFFFFFFF8;
    }
  Module["_malloc"] = _malloc;
  
  function simpleReadValueFromPointer(pointer) {
      return this['fromWireType'](HEAPU32[pointer >> 2]);
    }function __embind_register_std_string(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              var length = HEAPU32[value >> 2];
              var a = new Array(length);
              for (var i = 0; i < length; ++i) {
                  a[i] = String.fromCharCode(HEAPU8[value + 4 + i]);
              }
              _free(value);
              return a.join('');
          },
          'toWireType': function(destructors, value) {
              if (value instanceof ArrayBuffer) {
                  value = new Uint8Array(value);
              }
  
              function getTAElement(ta, index) {
                  return ta[index];
              }
              function getStringElement(string, index) {
                  return string.charCodeAt(index);
              }
              var getElement;
              if (value instanceof Uint8Array) {
                  getElement = getTAElement;
              } else if (value instanceof Int8Array) {
                  getElement = getTAElement;
              } else if (typeof value === 'string') {
                  getElement = getStringElement;
              } else {
                  throwBindingError('Cannot pass non-string to std::string');
              }
  
              // assumes 4-byte alignment
              var length = value.length;
              var ptr = _malloc(4 + length);
              HEAPU32[ptr >> 2] = length;
              for (var i = 0; i < length; ++i) {
                  var charCode = getElement(value, i);
                  if (charCode > 255) {
                      _free(ptr);
                      throwBindingError('String has UTF-16 code units that do not fit in 8 bits');
                  }
                  HEAPU8[ptr + 4 + i] = charCode;
              }
              if (destructors !== null) {
                  destructors.push(_free, ptr);
              }
              return ptr;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: function(ptr) { _free(ptr); },
      });
    }

  function __embind_register_std_wstring(rawType, charSize, name) {
      // nb. do not cache HEAPU16 and HEAPU32, they may be destroyed by enlargeMemory().
      name = readLatin1String(name);
      var getHeap, shift;
      if (charSize === 2) {
          getHeap = function() { return HEAPU16; };
          shift = 1;
      } else if (charSize === 4) {
          getHeap = function() { return HEAPU32; };
          shift = 2;
      }
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              var HEAP = getHeap();
              var length = HEAPU32[value >> 2];
              var a = new Array(length);
              var start = (value + 4) >> shift;
              for (var i = 0; i < length; ++i) {
                  a[i] = String.fromCharCode(HEAP[start + i]);
              }
              _free(value);
              return a.join('');
          },
          'toWireType': function(destructors, value) {
              // assumes 4-byte alignment
              var HEAP = getHeap();
              var length = value.length;
              var ptr = _malloc(4 + length * charSize);
              HEAPU32[ptr >> 2] = length;
              var start = (ptr + 4) >> shift;
              for (var i = 0; i < length; ++i) {
                  HEAP[start + i] = value.charCodeAt(i);
              }
              if (destructors !== null) {
                  destructors.push(_free, ptr);
              }
              return ptr;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: function(ptr) { _free(ptr); },
      });
    }

  function ___lock() {}

  function ___unlock() {}

  var _emscripten_asm_const_int=true;

   
  Module["_i64Add"] = _i64Add;

  var _fabs=Math_abs;

  var _sqrt=Math_sqrt;

  
  function _embind_repr(v) {
      if (v === null) {
          return 'null';
      }
      var t = typeof v;
      if (t === 'object' || t === 'array' || t === 'function') {
          return v.toString();
      } else {
          return '' + v;
      }
    }
  
  function integerReadValueFromPointer(name, shift, signed) {
      // integers are quite common, so generate very specialized functions
      switch (shift) {
          case 0: return signed ?
              function readS8FromPointer(pointer) { return HEAP8[pointer]; } :
              function readU8FromPointer(pointer) { return HEAPU8[pointer]; };
          case 1: return signed ?
              function readS16FromPointer(pointer) { return HEAP16[pointer >> 1]; } :
              function readU16FromPointer(pointer) { return HEAPU16[pointer >> 1]; };
          case 2: return signed ?
              function readS32FromPointer(pointer) { return HEAP32[pointer >> 2]; } :
              function readU32FromPointer(pointer) { return HEAPU32[pointer >> 2]; };
          default:
              throw new TypeError("Unknown integer type: " + name);
      }
    }function __embind_register_integer(primitiveType, name, size, minRange, maxRange) {
      name = readLatin1String(name);
      if (maxRange === -1) { // LLVM doesn't have signed and unsigned 32-bit types, so u32 literals come out as 'i32 -1'. Always treat those as max u32.
          maxRange = 4294967295;
      }
  
      var shift = getShiftFromSize(size);
      
      var fromWireType = function(value) {
          return value;
      };
      
      if (minRange === 0) {
          var bitshift = 32 - 8*size;
          fromWireType = function(value) {
              return (value << bitshift) >>> bitshift;
          };
      }
  
      registerType(primitiveType, {
          name: name,
          'fromWireType': fromWireType,
          'toWireType': function(destructors, value) {
              // todo: Here we have an opportunity for -O3 level "unsafe" optimizations: we could
              // avoid the following two if()s and assume value is of proper type.
              if (typeof value !== "number" && typeof value !== "boolean") {
                  throw new TypeError('Cannot convert "' + _embind_repr(value) + '" to ' + this.name);
              }
              if (value < minRange || value > maxRange) {
                  throw new TypeError('Passing a number "' + _embind_repr(value) + '" from JS side to C/C++ side to an argument of type "' + name + '", which is outside the valid range [' + minRange + ', ' + maxRange + ']!');
              }
              return value | 0;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': integerReadValueFromPointer(name, shift, minRange !== 0),
          destructorFunction: null, // This type does not need a destructor
      });
    }

  
  
  var emval_free_list=[];
  
  var emval_handle_array=[{},{value:undefined},{value:null},{value:true},{value:false}];function __emval_decref(handle) {
      if (handle > 4 && 0 === --emval_handle_array[handle].refcount) {
          emval_handle_array[handle] = undefined;
          emval_free_list.push(handle);
      }
    }
  
  
  
  function count_emval_handles() {
      var count = 0;
      for (var i = 5; i < emval_handle_array.length; ++i) {
          if (emval_handle_array[i] !== undefined) {
              ++count;
          }
      }
      return count;
    }
  
  function get_first_emval() {
      for (var i = 5; i < emval_handle_array.length; ++i) {
          if (emval_handle_array[i] !== undefined) {
              return emval_handle_array[i];
          }
      }
      return null;
    }function init_emval() {
      Module['count_emval_handles'] = count_emval_handles;
      Module['get_first_emval'] = get_first_emval;
    }function __emval_register(value) {
  
      switch(value){
        case undefined :{ return 1; }
        case null :{ return 2; }
        case true :{ return 3; }
        case false :{ return 4; }
        default:{
          var handle = emval_free_list.length ?
              emval_free_list.pop() :
              emval_handle_array.length;
  
          emval_handle_array[handle] = {refcount: 1, value: value};
          return handle;
          }
        }
    }function __embind_register_emval(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(handle) {
              var rv = emval_handle_array[handle].value;
              __emval_decref(handle);
              return rv;
          },
          'toWireType': function(destructors, value) {
              return __emval_register(value);
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: null, // This type does not need a destructor
  
          // TODO: do we need a deleteObject here?  write a test where
          // emval is passed into JS via an interface
      });
    }

  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }

  var _sin=Math_sin;

  
  function ___setErrNo(value) {
      if (Module['___errno_location']) HEAP32[((Module['___errno_location']())>>2)]=value;
      else Module.printErr('failed to set errno from JS');
      return value;
    }
  
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 85: return totalMemory / PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 79:
          return 0;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: {
          if (typeof navigator === 'object') return navigator['hardwareConcurrency'] || 1;
          return 1;
        }
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }

   
  Module["_bitshift64Lshr"] = _bitshift64Lshr;

  
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }

  var _llvm_ctlz_i32=true;

  
  function floatReadValueFromPointer(name, shift) {
      switch (shift) {
          case 2: return function(pointer) {
              return this['fromWireType'](HEAPF32[pointer >> 2]);
          };
          case 3: return function(pointer) {
              return this['fromWireType'](HEAPF64[pointer >> 3]);
          };
          default:
              throw new TypeError("Unknown float type: " + name);
      }
    }function __embind_register_float(rawType, name, size) {
      var shift = getShiftFromSize(size);
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              return value;
          },
          'toWireType': function(destructors, value) {
              // todo: Here we have an opportunity for -O3 level "unsafe" optimizations: we could
              // avoid the following if() and assume value is of proper type.
              if (typeof value !== "number" && typeof value !== "boolean") {
                  throw new TypeError('Cannot convert "' + _embind_repr(value) + '" to ' + this.name);
              }
              return value;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': floatReadValueFromPointer(name, shift),
          destructorFunction: null, // This type does not need a destructor
      });
    }

  var _BDtoIHigh=true;

  function _pthread_cleanup_push(routine, arg) {
      __ATEXIT__.push(function() { Runtime.dynCall('vi', routine, [arg]) })
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

  
  
  function new_(constructor, argumentList) {
      if (!(constructor instanceof Function)) {
          throw new TypeError('new_ called with constructor type ' + typeof(constructor) + " which is not a function");
      }
  
      /*
       * Previously, the following line was just:
  
       function dummy() {};
  
       * Unfortunately, Chrome was preserving 'dummy' as the object's name, even though at creation, the 'dummy' has the
       * correct constructor name.  Thus, objects created with IMVU.new would show up in the debugger as 'dummy', which
       * isn't very helpful.  Using IMVU.createNamedFunction addresses the issue.  Doublely-unfortunately, there's no way
       * to write a test for this behavior.  -NRD 2013.02.22
       */
      var dummy = createNamedFunction(constructor.name || 'unknownFunctionName', function(){});
      dummy.prototype = constructor.prototype;
      var obj = new dummy;
  
      var r = constructor.apply(obj, argumentList);
      return (r instanceof Object) ? r : obj;
    }
  
  function runDestructors(destructors) {
      while (destructors.length) {
          var ptr = destructors.pop();
          var del = destructors.pop();
          del(ptr);
      }
    }function craftInvokerFunction(humanName, argTypes, classType, cppInvokerFunc, cppTargetFunc) {
      // humanName: a human-readable string name for the function to be generated.
      // argTypes: An array that contains the embind type objects for all types in the function signature.
      //    argTypes[0] is the type object for the function return value.
      //    argTypes[1] is the type object for function this object/class type, or null if not crafting an invoker for a class method.
      //    argTypes[2...] are the actual function parameters.
      // classType: The embind type object for the class to be bound, or null if this is not a method of a class.
      // cppInvokerFunc: JS Function object to the C++-side function that interops into C++ code.
      // cppTargetFunc: Function pointer (an integer to FUNCTION_TABLE) to the target C++ function the cppInvokerFunc will end up calling.
      var argCount = argTypes.length;
  
      if (argCount < 2) {
          throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!");
      }
  
      var isClassMethodFunc = (argTypes[1] !== null && classType !== null);
  
      // Free functions with signature "void function()" do not need an invoker that marshalls between wire types.
  // TODO: This omits argument count check - enable only at -O3 or similar.
  //    if (ENABLE_UNSAFE_OPTS && argCount == 2 && argTypes[0].name == "void" && !isClassMethodFunc) {
  //       return FUNCTION_TABLE[fn];
  //    }
  
      var argsList = "";
      var argsListWired = "";
      for(var i = 0; i < argCount - 2; ++i) {
          argsList += (i!==0?", ":"")+"arg"+i;
          argsListWired += (i!==0?", ":"")+"arg"+i+"Wired";
      }
  
      var invokerFnBody =
          "return function "+makeLegalFunctionName(humanName)+"("+argsList+") {\n" +
          "if (arguments.length !== "+(argCount - 2)+") {\n" +
              "throwBindingError('function "+humanName+" called with ' + arguments.length + ' arguments, expected "+(argCount - 2)+" args!');\n" +
          "}\n";
  
  
      // Determine if we need to use a dynamic stack to store the destructors for the function parameters.
      // TODO: Remove this completely once all function invokers are being dynamically generated.
      var needsDestructorStack = false;
  
      for(var i = 1; i < argTypes.length; ++i) { // Skip return value at index 0 - it's not deleted here.
          if (argTypes[i] !== null && argTypes[i].destructorFunction === undefined) { // The type does not define a destructor function - must use dynamic stack
              needsDestructorStack = true;
              break;
          }
      }
  
      if (needsDestructorStack) {
          invokerFnBody +=
              "var destructors = [];\n";
      }
  
      var dtorStack = needsDestructorStack ? "destructors" : "null";
      var args1 = ["throwBindingError", "invoker", "fn", "runDestructors", "retType", "classParam"];
      var args2 = [throwBindingError, cppInvokerFunc, cppTargetFunc, runDestructors, argTypes[0], argTypes[1]];
  
  
      if (isClassMethodFunc) {
          invokerFnBody += "var thisWired = classParam.toWireType("+dtorStack+", this);\n";
      }
  
      for(var i = 0; i < argCount - 2; ++i) {
          invokerFnBody += "var arg"+i+"Wired = argType"+i+".toWireType("+dtorStack+", arg"+i+"); // "+argTypes[i+2].name+"\n";
          args1.push("argType"+i);
          args2.push(argTypes[i+2]);
      }
  
      if (isClassMethodFunc) {
          argsListWired = "thisWired" + (argsListWired.length > 0 ? ", " : "") + argsListWired;
      }
  
      var returns = (argTypes[0].name !== "void");
  
      invokerFnBody +=
          (returns?"var rv = ":"") + "invoker(fn"+(argsListWired.length>0?", ":"")+argsListWired+");\n";
  
      if (needsDestructorStack) {
          invokerFnBody += "runDestructors(destructors);\n";
      } else {
          for(var i = isClassMethodFunc?1:2; i < argTypes.length; ++i) { // Skip return value at index 0 - it's not deleted here. Also skip class type if not a method.
              var paramName = (i === 1 ? "thisWired" : ("arg"+(i - 2)+"Wired"));
              if (argTypes[i].destructorFunction !== null) {
                  invokerFnBody += paramName+"_dtor("+paramName+"); // "+argTypes[i].name+"\n";
                  args1.push(paramName+"_dtor");
                  args2.push(argTypes[i].destructorFunction);
              }
          }
      }
  
      if (returns) {
          invokerFnBody += "var ret = retType.fromWireType(rv);\n" +
                           "return ret;\n";
      } else {
      }
      invokerFnBody += "}\n";
  
      args1.push(invokerFnBody);
  
      var invokerFunction = new_(Function, args1).apply(null, args2);
      return invokerFunction;
    }
  
  
  function ensureOverloadTable(proto, methodName, humanName) {
      if (undefined === proto[methodName].overloadTable) {
          var prevFunc = proto[methodName];
          // Inject an overload resolver function that routes to the appropriate overload based on the number of arguments.
          proto[methodName] = function() {
              // TODO This check can be removed in -O3 level "unsafe" optimizations.
              if (!proto[methodName].overloadTable.hasOwnProperty(arguments.length)) {
                  throwBindingError("Function '" + humanName + "' called with an invalid number of arguments (" + arguments.length + ") - expects one of (" + proto[methodName].overloadTable + ")!");
              }
              return proto[methodName].overloadTable[arguments.length].apply(this, arguments);
          };
          // Move the previous function into the overload table.
          proto[methodName].overloadTable = [];
          proto[methodName].overloadTable[prevFunc.argCount] = prevFunc;
      }
    }function exposePublicSymbol(name, value, numArguments) {
      if (Module.hasOwnProperty(name)) {
          if (undefined === numArguments || (undefined !== Module[name].overloadTable && undefined !== Module[name].overloadTable[numArguments])) {
              throwBindingError("Cannot register public name '" + name + "' twice");
          }
  
          // We are exposing a function with the same name as an existing function. Create an overload table and a function selector
          // that routes between the two.
          ensureOverloadTable(Module, name, name);
          if (Module.hasOwnProperty(numArguments)) {
              throwBindingError("Cannot register multiple overloads of a function with the same number of arguments (" + numArguments + ")!");
          }
          // Add the new function into the overload table.
          Module[name].overloadTable[numArguments] = value;
      }
      else {
          Module[name] = value;
          if (undefined !== numArguments) {
              Module[name].numArguments = numArguments;
          }
      }
    }
  
  function heap32VectorToArray(count, firstElement) {
      var array = [];
      for (var i = 0; i < count; i++) {
          array.push(HEAP32[(firstElement >> 2) + i]);
      }
      return array;
    }
  
  function replacePublicSymbol(name, value, numArguments) {
      if (!Module.hasOwnProperty(name)) {
          throwInternalError('Replacing nonexistant public symbol');
      }
      // If there's an overload table for this symbol, replace the symbol in the overload table instead.
      if (undefined !== Module[name].overloadTable && undefined !== numArguments) {
          Module[name].overloadTable[numArguments] = value;
      }
      else {
          Module[name] = value;
      }
    }
  
  function requireFunction(signature, rawFunction) {
      signature = readLatin1String(signature);
  
      function makeDynCaller(dynCall) {
          var args = [];
          for (var i = 1; i < signature.length; ++i) {
              args.push('a' + i);
          }
  
          var name = 'dynCall_' + signature + '_' + rawFunction;
          var body = 'return function ' + name + '(' + args.join(', ') + ') {\n';
          body    += '    return dynCall(rawFunction' + (args.length ? ', ' : '') + args.join(', ') + ');\n';
          body    += '};\n';
  
          return (new Function('dynCall', 'rawFunction', body))(dynCall, rawFunction);
      }
  
      var fp;
      if (Module['FUNCTION_TABLE_' + signature] !== undefined) {
          fp = Module['FUNCTION_TABLE_' + signature][rawFunction];
      } else if (typeof FUNCTION_TABLE !== "undefined") {
          fp = FUNCTION_TABLE[rawFunction];
      } else {
          // asm.js does not give direct access to the function tables,
          // and thus we must go through the dynCall interface which allows
          // calling into a signature's function table by pointer value.
          //
          // https://github.com/dherman/asm.js/issues/83
          //
          // This has three main penalties:
          // - dynCall is another function call in the path from JavaScript to C++.
          // - JITs may not predict through the function table indirection at runtime.
          var dc = asm['dynCall_' + signature];
          if (dc === undefined) {
              // We will always enter this branch if the signature
              // contains 'f' and PRECISE_F32 is not enabled.
              //
              // Try again, replacing 'f' with 'd'.
              dc = asm['dynCall_' + signature.replace(/f/g, 'd')];
              if (dc === undefined) {
                  throwBindingError("No dynCall invoker for signature: " + signature);
              }
          }
          fp = makeDynCaller(dc);
      }
  
      if (typeof fp !== "function") {
          throwBindingError("unknown function pointer with signature " + signature + ": " + rawFunction);
      }
      return fp;
    }
  
  
  var UnboundTypeError=undefined;
  
  function getTypeName(type) {
      var ptr = ___getTypeName(type);
      var rv = readLatin1String(ptr);
      _free(ptr);
      return rv;
    }function throwUnboundTypeError(message, types) {
      var unboundTypes = [];
      var seen = {};
      function visit(type) {
          if (seen[type]) {
              return;
          }
          if (registeredTypes[type]) {
              return;
          }
          if (typeDependencies[type]) {
              typeDependencies[type].forEach(visit);
              return;
          }
          unboundTypes.push(type);
          seen[type] = true;
      }
      types.forEach(visit);
  
      throw new UnboundTypeError(message + ': ' + unboundTypes.map(getTypeName).join([', ']));
    }function __embind_register_function(name, argCount, rawArgTypesAddr, signature, rawInvoker, fn) {
      var argTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
      name = readLatin1String(name);
      
      rawInvoker = requireFunction(signature, rawInvoker);
  
      exposePublicSymbol(name, function() {
          throwUnboundTypeError('Cannot call ' + name + ' due to unbound types', argTypes);
      }, argCount - 1);
  
      whenDependentTypesAreResolved([], argTypes, function(argTypes) {
          var invokerArgsArray = [argTypes[0] /* return value */, null /* no class 'this'*/].concat(argTypes.slice(1) /* actual params */);
          replacePublicSymbol(name, craftInvokerFunction(name, invokerArgsArray, null /* no class 'this'*/, rawInvoker, fn), argCount - 1);
          return [];
      });
    }

  function __embind_register_constant(name, type, value) {
      name = readLatin1String(name);
      whenDependentTypesAreResolved([], [type], function(type) {
          type = type[0];
          Module[name] = type['fromWireType'](value);
          return [];
      });
    }

  function _pthread_cleanup_pop() {
      assert(_pthread_cleanup_push.level == __ATEXIT__.length, 'cannot pop if something else added meanwhile!');
      __ATEXIT__.pop();
      _pthread_cleanup_push.level = __ATEXIT__.length;
    }

  
  
  
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function (stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = new Buffer(BUFSIZE);
              var bytesRead = 0;
  
              var fd = process.stdin.fd;
              // Linux and Mac cannot use process.stdin.fd (which isn't set up as sync)
              var usingDevice = false;
              try {
                fd = fs.openSync('/dev/stdin', 'r');
                usingDevice = true;
              } catch (e) {}
  
              bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
  
              if (usingDevice) { fs.closeSync(fd); }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
  
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  var MEMFS={ops_table:null,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.buffer.byteLength which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },getFileDataAsRegularArray:function (node) {
        if (node.contents && node.contents.subarray) {
          var arr = [];
          for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
          return arr; // Returns a copy of the original data.
        }
        return node.contents; // No-op, the file contents are already in a JS array. Return as-is.
      },getFileDataAsTypedArray:function (node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function (node, newCapacity) {
        // If we are asked to expand the size of a file that already exists, revert to using a standard JS array to store the file
        // instead of a typed array. This makes resizing the array more flexible because we can just .push() elements at the back to
        // increase the size.
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node);
          node.usedBytes = node.contents.length; // We might be writing to a lazy-loaded file which had overridden this property, so force-reset it.
        }
  
        if (!node.contents || node.contents.subarray) { // Keep using a typed array if creating a new storage, or if old one was a typed array as well.
          var prevCapacity = node.contents ? node.contents.buffer.byteLength : 0;
          if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
          // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
          // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
          // avoid overshooting the allocation cap by a very large margin.
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) | 0);
          if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity); // Allocate new storage.
          if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
          return;
        }
        // Not using a typed array to back the file storage. Use a standard JS array instead.
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0);
      },resizeFileStorage:function (node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
          return;
        }
        if (!node.contents || node.contents.subarray) { // Resize a typed array if that is being used as the backing store.
          var oldContents = node.contents;
          node.contents = new Uint8Array(new ArrayBuffer(newSize)); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
          return;
        }
        // Backing with a JS array.
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) { // Can we just reuse the buffer we are given?
              assert(position === 0, 'canOwn must imply no weird position inside the file');
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); // Use typed array write if available.
          else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position+length);
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function (stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  var IDBFS={dbs:{},indexedDB:function () {
        if (typeof indexedDB !== 'undefined') return indexedDB;
        var ret = null;
        if (typeof window === 'object') ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, 'IDBFS used, but indexedDB not supported');
        return ret;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
  
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
  
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
  
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
  
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;
  
          var fileStore;
  
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }
  
          if (!fileStore.indexNames.contains('timestamp')) {
            fileStore.createIndex('timestamp', 'timestamp', { unique: false });
          }
        };
        req.onsuccess = function() {
          db = req.result;
  
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};
  
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
  
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  
        while (check.length) {
          var path = check.pop();
          var stat;
  
          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
  
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }
  
          entries[path] = { timestamp: stat.mtime };
        }
  
        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};
  
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
  
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function(e) {
            callback(this.error);
            e.preventDefault();
          };
  
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          var index = store.index('timestamp');
  
          index.openKeyCursor().onsuccess = function(event) {
            var cursor = event.target.result;
  
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, entries: entries });
            }
  
            entries[cursor.primaryKey] = { timestamp: cursor.key };
  
            cursor.continue();
          };
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;
  
        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }
  
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          // Performance consideration: storing a normal JavaScript array to a IndexedDB is much slower than storing a typed array.
          // Therefore always convert the file contents to a typed array first before writing the data to IndexedDB.
          node.contents = MEMFS.getFileDataAsTypedArray(node);
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { encoding: 'binary', canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }
  
          FS.chmod(path, entry.mode);
          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);
  
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },reconcile:function (src, dst, callback) {
        var total = 0;
  
        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });
  
        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });
  
        if (!total) {
          return callback(null);
        }
  
        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };
  
        transaction.onerror = function(e) {
          done(this.error);
          e.preventDefault();
        };
  
        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });
  
        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};
  
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        flags &= ~0100000 /*O_LARGEFILE*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            path = fs.readlinkSync(path);
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
            return path;
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          if (length === 0) return 0; // node errors on 0 length reads
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
  
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
  
          return position;
        }}};
  
  var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function (mount) {
        assert(ENVIRONMENT_IS_WORKER);
        if (!WORKERFS.reader) WORKERFS.reader = new FileReaderSync();
        var root = WORKERFS.createNode(null, '/', WORKERFS.DIR_MODE, 0);
        var createdParents = {};
        function ensureParent(path) {
          // return the parent node, creating subdirs as necessary
          var parts = path.split('/');
          var parent = root;
          for (var i = 0; i < parts.length-1; i++) {
            var curr = parts.slice(0, i+1).join('/');
            if (!createdParents[curr]) {
              createdParents[curr] = WORKERFS.createNode(parent, curr, WORKERFS.DIR_MODE, 0);
            }
            parent = createdParents[curr];
          }
          return parent;
        }
        function base(path) {
          var parts = path.split('/');
          return parts[parts.length-1];
        }
        // We also accept FileList here, by using Array.prototype
        Array.prototype.forEach.call(mount.opts["files"] || [], function(file) {
          WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file, file.lastModifiedDate);
        });
        (mount.opts["blobs"] || []).forEach(function(obj) {
          WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"]);
        });
        (mount.opts["packages"] || []).forEach(function(pack) {
          pack['metadata'].files.forEach(function(file) {
            var name = file.filename.substr(1); // remove initial slash
            WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0, pack['blob'].slice(file.start, file.end));
          });
        });
        return root;
      },createNode:function (parent, name, mode, dev, contents, mtime) {
        var node = FS.createNode(parent, name, mode);
        node.mode = mode;
        node.node_ops = WORKERFS.node_ops;
        node.stream_ops = WORKERFS.stream_ops;
        node.timestamp = (mtime || new Date).getTime();
        assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE);
        if (mode === WORKERFS.FILE_MODE) {
          node.size = contents.size;
          node.contents = contents;
        } else {
          node.size = 4096;
          node.contents = {};
        }
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          return {
            dev: 1,
            ino: undefined,
            mode: node.mode,
            nlink: 1,
            uid: 0,
            gid: 0,
            rdev: undefined,
            size: node.size,
            atime: new Date(node.timestamp),
            mtime: new Date(node.timestamp),
            ctime: new Date(node.timestamp),
            blksize: 4096,
            blocks: Math.ceil(node.size / 4096),
          };
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rename:function (oldNode, newDir, newName) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },unlink:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rmdir:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readdir:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },symlink:function (parent, newName, oldPath) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readlink:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          if (position >= stream.node.size) return 0;
          var chunk = stream.node.contents.slice(position, position + length);
          var ab = WORKERFS.reader.readAsArrayBuffer(chunk);
          buffer.set(new Uint8Array(ab), offset);
          return chunk.size;
        },write:function (stream, buffer, offset, length, position) {
          throw new FS.ErrnoError(ERRNO_CODES.EIO);
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.size;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        }}};
  
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
  
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };
  
          FS.FSNode.prototype = {};
  
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
  
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); }
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); }
            }
          });
        }
  
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var perms = ['r', 'w', 'rw'][flag & 3];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        var err = FS.nodePermissions(dir, 'x');
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0;
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            callback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        try {
          if (FS.trackingDelegate['willMovePath']) {
            FS.trackingDelegate['willMovePath'](old_path, new_path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
        try {
          if (FS.trackingDelegate['onMovePath']) FS.trackingDelegate['onMovePath'](old_path, new_path);
        } catch(e) {
          console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // if asked only for a directory, then this must be one
        if ((flags & 65536) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var err = FS.mayOpen(node, flags);
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        try {
          if (FS.trackingDelegate['onOpenFile']) {
            var trackingFlags = 0;
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ;
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE;
            }
            FS.trackingDelegate['onOpenFile'](path, trackingFlags);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: " + e.message);
        }
        return stream;
      },close:function (stream) {
        if (stream.getdents) stream.getdents = null; // free readdir state
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
          if (stream.path && FS.trackingDelegate['onWriteToFile']) FS.trackingDelegate['onWriteToFile'](stream.path);
        } catch(e) {
          console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: " + e.message);
        }
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },msync:function (stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function (stream) {
        return 0;
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device;
        if (typeof crypto !== 'undefined') {
          // for modern web browsers
          var randomBuffer = new Uint8Array(1);
          random_device = function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
        } else if (ENVIRONMENT_IS_NODE) {
          // for nodejs
          random_device = function() { return require('crypto').randomBytes(1)[0]; };
        } else {
          // default for ES5 platforms
          random_device = function() { return (Math.random()*256)|0; };
        }
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createSpecialDirectories:function () {
        // create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the name of the stream for fd 6 (see test_unistd_ttyname)
        FS.mkdir('/proc');
        FS.mkdir('/proc/self');
        FS.mkdir('/proc/self/fd');
        FS.mount({
          mount: function() {
            var node = FS.createNode('/proc/self', 'fd', 16384 | 0777, 73);
            node.node_ops = {
              lookup: function(parent, name) {
                var fd = +name;
                var stream = FS.getStream(fd);
                if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
                var ret = {
                  parent: null,
                  mount: { mountpoint: 'fake' },
                  node_ops: { readlink: function() { return stream.path } }
                };
                ret.parent = ret; // make it look like a simple root node
                return ret;
              }
            };
            return node;
          }
        }, {}, '/proc/self/fd');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');
  
        var stdout = FS.open('/dev/stdout', 'w');
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');
  
        var stderr = FS.open('/dev/stderr', 'w');
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
          //Module.printErr(stackTrace()); // useful for debugging
          this.node = node;
          this.setErrno = function(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key;
                break;
              }
            }
          };
          this.setErrno(errno);
          this.message = ERRNO_MESSAGES[errno];
          if (this.stack) this.stack = demangleAll(this.stack);
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
        FS.createSpecialDirectories();
  
        FS.filesystems = {
          'MEMFS': MEMFS,
          'IDBFS': IDBFS,
          'NODEFS': NODEFS,
          'WORKERFS': WORKERFS,
        };
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        // force-flush all streams, so we get musl std streams printed out
        var fflush = Module['_fflush'];
        if (fflush) fflush(0);
        // close all of our streams
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperty(node, "usedBytes", {
            get: function() { return this.contents.length; }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function (dirfd, path) {
        if (path[0] !== '/') {
          // relative path
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = FS.getStream(dirfd);
            if (!dirstream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
            dir = dirstream.path;
          }
          path = PATH.join2(dir, path);
        }
        return path;
      },doStat:function (func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -ERRNO_CODES.ENOTDIR;
          }
          throw e;
        }
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode;
        HEAP32[(((buf)+(16))>>2)]=stat.nlink;
        HEAP32[(((buf)+(20))>>2)]=stat.uid;
        HEAP32[(((buf)+(24))>>2)]=stat.gid;
        HEAP32[(((buf)+(28))>>2)]=stat.rdev;
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size;
        HEAP32[(((buf)+(40))>>2)]=4096;
        HEAP32[(((buf)+(44))>>2)]=stat.blocks;
        HEAP32[(((buf)+(48))>>2)]=(stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(52))>>2)]=0;
        HEAP32[(((buf)+(56))>>2)]=(stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)]=0;
        HEAP32[(((buf)+(64))>>2)]=(stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)]=0;
        HEAP32[(((buf)+(72))>>2)]=stat.ino;
        return 0;
      },doMsync:function (addr, stream, len, flags) {
        var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len));
        FS.msync(stream, buffer, 0, len, flags);
      },doMkdir:function (path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function (path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -ERRNO_CODES.EINVAL;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function (path, buf, bufsize) {
        if (bufsize <= 0) return -ERRNO_CODES.EINVAL;
        var ret = FS.readlink(path);
        ret = ret.slice(0, Math.max(0, bufsize));
        writeStringToMemory(ret, buf, true);
        return ret.length;
      },doAccess:function (path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -ERRNO_CODES.EINVAL;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -ERRNO_CODES.EACCES;
        }
        return 0;
      },doDup:function (path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:0,get:function (varargs) {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function () {
        var ret = Pointer_stringify(SYSCALLS.get());
        return ret;
      },getStreamFromFD:function () {
        var stream = FS.getStream(SYSCALLS.get());
        if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return stream;
      },getSocketFromFD:function () {
        var socket = SOCKFS.getSocket(SYSCALLS.get());
        if (!socket) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return socket;
      },getSocketAddress:function (allowNull) {
        var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get();
        if (allowNull && addrp === 0) return null;
        var info = __read_sockaddr(addrp, addrlen);
        if (info.errno) throw new FS.ErrnoError(info.errno);
        info.addr = DNS.lookup_addr(info.addr) || info.addr;
        return info;
      },get64:function () {
        var low = SYSCALLS.get(), high = SYSCALLS.get();
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      },getZero:function () {
        assert(SYSCALLS.get() === 0);
      }};function ___syscall5(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // open
      var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get() // optional TODO
      var stream = FS.open(pathname, flags, mode);
      return stream.fd;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 
  Module["_memcpy"] = _memcpy;

  function ___syscall6(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // close
      var stream = SYSCALLS.getStreamFromFD();
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _cos=Math_cos;

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) {
        var success = self.alloc(bytes);
        if (!success) return -1 >>> 0; // sbrk failure code
      }
      return ret;  // Previous break location.
    }

   
  Module["_memmove"] = _memmove;

  var _BItoD=true;

  function ___syscall54(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ioctl
      var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get();
      switch (op) {
        case 21505: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        case 21506: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0; // no-op, not actually adjusting terminal settings
        }
        case 21519: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          var argp = SYSCALLS.get();
          HEAP32[((argp)>>2)]=0;
          return 0;
        }
        case 21520: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return -ERRNO_CODES.EINVAL; // not supported
        }
        case 21531: {
          var argp = SYSCALLS.get();
          return FS.ioctl(stream, op, argp);
        }
        default: abort('bad ioctl syscall ' + op);
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var _ceilf=Math_ceil;

  function __embind_register_memory_view(rawType, dataTypeIndex, name) {
      var typeMapping = [
          Int8Array,
          Uint8Array,
          Int16Array,
          Uint16Array,
          Int32Array,
          Uint32Array,
          Float32Array,
          Float64Array,
      ];
  
      var TA = typeMapping[dataTypeIndex];
  
      function decodeMemoryView(handle) {
          handle = handle >> 2;
          var heap = HEAPU32;
          var size = heap[handle]; // in elements
          var data = heap[handle + 1]; // byte offset into emscripten heap
          return new TA(heap['buffer'], data, size);
      }
  
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': decodeMemoryView,
          'argPackAdvance': 8,
          'readValueFromPointer': decodeMemoryView,
      }, {
          ignoreDuplicateRegistrations: true,
      });
    }

  function _time(ptr) {
      var ret = (Date.now()/1000)|0;
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

  function _pthread_self() {
      //FIXME: assumes only a single thread
      return 0;
    }

  function ___syscall140(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // llseek
      var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
      var offset = offset_low;
      assert(offset_high === 0);
      FS.llseek(stream, offset, whence);
      HEAP32[((result)>>2)]=stream.position;
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall146(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // writev
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doWritev(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall221(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fcntl64
      var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get();
      switch (cmd) {
        case 0: {
          var arg = SYSCALLS.get();
          if (arg < 0) {
            return -ERRNO_CODES.EINVAL;
          }
          var newStream;
          newStream = FS.open(stream.path, stream.flags, 0, arg);
          return newStream.fd;
        }
        case 1:
        case 2:
          return 0;  // FD_CLOEXEC makes no sense for a single process.
        case 3:
          return stream.flags;
        case 4: {
          var arg = SYSCALLS.get();
          stream.flags |= arg;
          return 0;
        }
        case 12:
        case 12: {
          var arg = SYSCALLS.get();
          var offset = 0;
          // We're always unlocked.
          HEAP16[(((arg)+(offset))>>1)]=2;
          return 0;
        }
        case 13:
        case 14:
        case 13:
        case 14:
          return 0; // Pretend that the locking is successful.
        case 16:
        case 8:
          return -ERRNO_CODES.EINVAL; // These are for sockets. We don't have them fully implemented yet.
        case 9:
          // musl trusts getown return values, due to a bug where they must be, as they overlap with errors. just return -1 here, so fnctl() returns that, and we set errno ourselves.
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        default: {
          return -ERRNO_CODES.EINVAL;
        }
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall145(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // readv
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doReadv(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  var ___dso_handle=allocate(1, "i32*", ALLOC_STATIC);
embind_init_charCodes()
BindingError = Module['BindingError'] = extendError(Error, 'BindingError');
InternalError = Module['InternalError'] = extendError(Error, 'InternalError');
init_emval();
UnboundTypeError = Module['UnboundTypeError'] = extendError(Error, 'UnboundTypeError');
FS.staticInit();__ATINIT__.unshift(function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() });__ATMAIN__.push(function() { FS.ignorePermissions = false });__ATEXIT__.push(function() { FS.quit() });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;Module["FS_unlink"] = FS.unlink;
__ATINIT__.unshift(function() { TTY.init() });__ATEXIT__.push(function() { TTY.shutdown() });
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); var NODEJS_PATH = require("path"); NODEFS.staticInit(); }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);


function nullFunc_iiii(x) { Module["printErr"]("Invalid function pointer called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_dii(x) { Module["printErr"]("Invalid function pointer called with signature 'dii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vid(x) { Module["printErr"]("Invalid function pointer called with signature 'vid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_di(x) { Module["printErr"]("Invalid function pointer called with signature 'di'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_i(x) { Module["printErr"]("Invalid function pointer called with signature 'i'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vi(x) { Module["printErr"]("Invalid function pointer called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vii(x) { Module["printErr"]("Invalid function pointer called with signature 'vii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_ii(x) { Module["printErr"]("Invalid function pointer called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viii(x) { Module["printErr"]("Invalid function pointer called with signature 'viii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_v(x) { Module["printErr"]("Invalid function pointer called with signature 'v'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viid(x) { Module["printErr"]("Invalid function pointer called with signature 'viid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'iiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iii(x) { Module["printErr"]("Invalid function pointer called with signature 'iii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_dii(index,a1,a2) {
  try {
    return Module["dynCall_dii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vid(index,a1,a2) {
  try {
    Module["dynCall_vid"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_di(index,a1) {
  try {
    return Module["dynCall_di"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viid(index,a1,a2,a3) {
  try {
    Module["dynCall_viid"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity, "byteLength": byteLength };

Module.asmLibraryArg = { "abort": abort, "assert": assert, "nullFunc_iiii": nullFunc_iiii, "nullFunc_viiiii": nullFunc_viiiii, "nullFunc_dii": nullFunc_dii, "nullFunc_vid": nullFunc_vid, "nullFunc_di": nullFunc_di, "nullFunc_i": nullFunc_i, "nullFunc_vi": nullFunc_vi, "nullFunc_vii": nullFunc_vii, "nullFunc_ii": nullFunc_ii, "nullFunc_viii": nullFunc_viii, "nullFunc_v": nullFunc_v, "nullFunc_viid": nullFunc_viid, "nullFunc_iiiii": nullFunc_iiiii, "nullFunc_viiiiii": nullFunc_viiiiii, "nullFunc_iii": nullFunc_iii, "nullFunc_viiii": nullFunc_viiii, "invoke_iiii": invoke_iiii, "invoke_viiiii": invoke_viiiii, "invoke_dii": invoke_dii, "invoke_vid": invoke_vid, "invoke_di": invoke_di, "invoke_i": invoke_i, "invoke_vi": invoke_vi, "invoke_vii": invoke_vii, "invoke_ii": invoke_ii, "invoke_viii": invoke_viii, "invoke_v": invoke_v, "invoke_viid": invoke_viid, "invoke_iiiii": invoke_iiiii, "invoke_viiiiii": invoke_viiiiii, "invoke_iii": invoke_iii, "invoke_viiii": invoke_viiii, "_fabs": _fabs, "___syscall221": ___syscall221, "_sin": _sin, "floatReadValueFromPointer": floatReadValueFromPointer, "simpleReadValueFromPointer": simpleReadValueFromPointer, "___syscall54": ___syscall54, "__embind_register_memory_view": __embind_register_memory_view, "throwInternalError": throwInternalError, "get_first_emval": get_first_emval, "_abort": _abort, "_pthread_cleanup_push": _pthread_cleanup_push, "extendError": extendError, "__embind_register_integer": __embind_register_integer, "___assert_fail": ___assert_fail, "init_emval": init_emval, "___cxa_allocate_exception": ___cxa_allocate_exception, "__ZSt18uncaught_exceptionv": __ZSt18uncaught_exceptionv, "_ceilf": _ceilf, "getShiftFromSize": getShiftFromSize, "__embind_register_function": __embind_register_function, "__embind_register_emval": __embind_register_emval, "_emscripten_asm_const_33": _emscripten_asm_const_33, "__embind_register_constant": __embind_register_constant, "___setErrNo": ___setErrNo, "__emval_register": __emval_register, "_sbrk": _sbrk, "readLatin1String": readLatin1String, "__embind_register_void": __embind_register_void, "_emscripten_memcpy_big": _emscripten_memcpy_big, "__embind_register_bool": __embind_register_bool, "___resumeException": ___resumeException, "___cxa_find_matching_catch": ___cxa_find_matching_catch, "_sysconf": _sysconf, "_embind_repr": _embind_repr, "__embind_register_std_wstring": __embind_register_std_wstring, "createNamedFunction": createNamedFunction, "embind_init_charCodes": embind_init_charCodes, "_cos": _cos, "getTypeName": getTypeName, "throwUnboundTypeError": throwUnboundTypeError, "_pthread_self": _pthread_self, "craftInvokerFunction": craftInvokerFunction, "__emval_decref": __emval_decref, "_sqrt": _sqrt, "__embind_register_float": __embind_register_float, "makeLegalFunctionName": makeLegalFunctionName, "integerReadValueFromPointer": integerReadValueFromPointer, "___unlock": ___unlock, "heap32VectorToArray": heap32VectorToArray, "_pthread_cleanup_pop": _pthread_cleanup_pop, "whenDependentTypesAreResolved": whenDependentTypesAreResolved, "_exit": _exit, "___syscall5": ___syscall5, "_emscripten_asm_const_4": _emscripten_asm_const_4, "___cxa_atexit": ___cxa_atexit, "registerType": registerType, "___cxa_throw": ___cxa_throw, "__exit": __exit, "___lock": ___lock, "___syscall6": ___syscall6, "throwBindingError": throwBindingError, "ensureOverloadTable": ensureOverloadTable, "count_emval_handles": count_emval_handles, "_time": _time, "requireFunction": requireFunction, "runDestructors": runDestructors, "new_": new_, "_atexit": _atexit, "___syscall140": ___syscall140, "exposePublicSymbol": exposePublicSymbol, "_emscripten_asm_const_5": _emscripten_asm_const_5, "__embind_register_std_string": __embind_register_std_string, "replacePublicSymbol": replacePublicSymbol, "___syscall145": ___syscall145, "___syscall146": ___syscall146, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "cttz_i8": cttz_i8, "___dso_handle": ___dso_handle };
// EMSCRIPTEN_START_ASM
var asm = (function(global, env, buffer) {
  'use asm';
  
  
  var Int8View = global.Int8Array;
  var Int16View = global.Int16Array;
  var Int32View = global.Int32Array;
  var Uint8View = global.Uint8Array;
  var Uint16View = global.Uint16Array;
  var Uint32View = global.Uint32Array;
  var Float32View = global.Float32Array;
  var Float64View = global.Float64Array;
  var HEAP8 = new Int8View(buffer);
  var HEAP16 = new Int16View(buffer);
  var HEAP32 = new Int32View(buffer);
  var HEAPU8 = new Uint8View(buffer);
  var HEAPU16 = new Uint16View(buffer);
  var HEAPU32 = new Uint32View(buffer);
  var HEAPF32 = new Float32View(buffer);
  var HEAPF64 = new Float64View(buffer);
  var byteLength = global.byteLength;


  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var ___dso_handle=env.___dso_handle|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var nullFunc_iiii=env.nullFunc_iiii;
  var nullFunc_viiiii=env.nullFunc_viiiii;
  var nullFunc_dii=env.nullFunc_dii;
  var nullFunc_vid=env.nullFunc_vid;
  var nullFunc_di=env.nullFunc_di;
  var nullFunc_i=env.nullFunc_i;
  var nullFunc_vi=env.nullFunc_vi;
  var nullFunc_vii=env.nullFunc_vii;
  var nullFunc_ii=env.nullFunc_ii;
  var nullFunc_viii=env.nullFunc_viii;
  var nullFunc_v=env.nullFunc_v;
  var nullFunc_viid=env.nullFunc_viid;
  var nullFunc_iiiii=env.nullFunc_iiiii;
  var nullFunc_viiiiii=env.nullFunc_viiiiii;
  var nullFunc_iii=env.nullFunc_iii;
  var nullFunc_viiii=env.nullFunc_viiii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_dii=env.invoke_dii;
  var invoke_vid=env.invoke_vid;
  var invoke_di=env.invoke_di;
  var invoke_i=env.invoke_i;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_ii=env.invoke_ii;
  var invoke_viii=env.invoke_viii;
  var invoke_v=env.invoke_v;
  var invoke_viid=env.invoke_viid;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_viiiiii=env.invoke_viiiiii;
  var invoke_iii=env.invoke_iii;
  var invoke_viiii=env.invoke_viiii;
  var _fabs=env._fabs;
  var ___syscall221=env.___syscall221;
  var _sin=env._sin;
  var floatReadValueFromPointer=env.floatReadValueFromPointer;
  var simpleReadValueFromPointer=env.simpleReadValueFromPointer;
  var ___syscall54=env.___syscall54;
  var __embind_register_memory_view=env.__embind_register_memory_view;
  var throwInternalError=env.throwInternalError;
  var get_first_emval=env.get_first_emval;
  var _abort=env._abort;
  var _pthread_cleanup_push=env._pthread_cleanup_push;
  var extendError=env.extendError;
  var __embind_register_integer=env.__embind_register_integer;
  var ___assert_fail=env.___assert_fail;
  var init_emval=env.init_emval;
  var ___cxa_allocate_exception=env.___cxa_allocate_exception;
  var __ZSt18uncaught_exceptionv=env.__ZSt18uncaught_exceptionv;
  var _ceilf=env._ceilf;
  var getShiftFromSize=env.getShiftFromSize;
  var __embind_register_function=env.__embind_register_function;
  var __embind_register_emval=env.__embind_register_emval;
  var _emscripten_asm_const_33=env._emscripten_asm_const_33;
  var __embind_register_constant=env.__embind_register_constant;
  var ___setErrNo=env.___setErrNo;
  var __emval_register=env.__emval_register;
  var _sbrk=env._sbrk;
  var readLatin1String=env.readLatin1String;
  var __embind_register_void=env.__embind_register_void;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var __embind_register_bool=env.__embind_register_bool;
  var ___resumeException=env.___resumeException;
  var ___cxa_find_matching_catch=env.___cxa_find_matching_catch;
  var _sysconf=env._sysconf;
  var _embind_repr=env._embind_repr;
  var __embind_register_std_wstring=env.__embind_register_std_wstring;
  var createNamedFunction=env.createNamedFunction;
  var embind_init_charCodes=env.embind_init_charCodes;
  var _cos=env._cos;
  var getTypeName=env.getTypeName;
  var throwUnboundTypeError=env.throwUnboundTypeError;
  var _pthread_self=env._pthread_self;
  var craftInvokerFunction=env.craftInvokerFunction;
  var __emval_decref=env.__emval_decref;
  var _sqrt=env._sqrt;
  var __embind_register_float=env.__embind_register_float;
  var makeLegalFunctionName=env.makeLegalFunctionName;
  var integerReadValueFromPointer=env.integerReadValueFromPointer;
  var ___unlock=env.___unlock;
  var heap32VectorToArray=env.heap32VectorToArray;
  var _pthread_cleanup_pop=env._pthread_cleanup_pop;
  var whenDependentTypesAreResolved=env.whenDependentTypesAreResolved;
  var _exit=env._exit;
  var ___syscall5=env.___syscall5;
  var _emscripten_asm_const_4=env._emscripten_asm_const_4;
  var ___cxa_atexit=env.___cxa_atexit;
  var registerType=env.registerType;
  var ___cxa_throw=env.___cxa_throw;
  var __exit=env.__exit;
  var ___lock=env.___lock;
  var ___syscall6=env.___syscall6;
  var throwBindingError=env.throwBindingError;
  var ensureOverloadTable=env.ensureOverloadTable;
  var count_emval_handles=env.count_emval_handles;
  var _time=env._time;
  var requireFunction=env.requireFunction;
  var runDestructors=env.runDestructors;
  var new_=env.new_;
  var _atexit=env._atexit;
  var ___syscall140=env.___syscall140;
  var exposePublicSymbol=env.exposePublicSymbol;
  var _emscripten_asm_const_5=env._emscripten_asm_const_5;
  var __embind_register_std_string=env.__embind_register_std_string;
  var replacePublicSymbol=env.replacePublicSymbol;
  var ___syscall145=env.___syscall145;
  var ___syscall146=env.___syscall146;
  var tempFloat = 0.0;

function _emscripten_replace_memory(newBuffer) {
  if ((byteLength(newBuffer) & 0xffffff || byteLength(newBuffer) <= 0xffffff) || byteLength(newBuffer) > 0x80000000) return false;
  HEAP8 = new Int8View(newBuffer);
  HEAP16 = new Int16View(newBuffer);
  HEAP32 = new Int32View(newBuffer);
  HEAPU8 = new Uint8View(newBuffer);
  HEAPU16 = new Uint16View(newBuffer);
  HEAPU32 = new Uint32View(newBuffer);
  HEAPF32 = new Float32View(newBuffer);
  HEAPF64 = new Float64View(newBuffer);
  buffer = newBuffer;
  return true;
}

// EMSCRIPTEN_START_FUNCS

function __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0 = 0, $$0$i = 0, $$0$i$i = 0, $$0$i$i$i = 0, $$0$i$i$i$i = 0, $$0$i$i$i105 = 0, $$0$i$i$i113 = 0, $$0$i$i$i123 = 0, $$0$i$i$i131 = 0, $$0$i$i$i136 = 0, $$0$i$i$i148 = 0, $$0$i$i$i153 = 0, $$0$i$i$i17 = 0, $$0$i$i$i181 = 0, $$0$i$i$i191509 = 0, $$0$i$i$i22 = 0, $$0$i$i$i27 = 0, $$0$i$i$i29 = 0, $$0$i$i$i31 = 0, $$0$i$i$i38 = 0, $$0$i$i$i43 = 0, $$0$i$i$i51 = 0, $$0$i$i$i56 = 0, $$0$i$i$i61 = 0, $$0$i$i$i66 = 0, $$0$i$i$i71 = 0, $$0$i$i$i76 = 0, $$0$i$i$i81 = 0, $$0$i$i$i87 = 0, $$0$i$i$i95 = 0, $$01$i$i = 0, $$03$i$i = 0, $$08$i = 0, $$1$i$i = 0, $$1$i263 = 0, $$12$i$i = 0, $$13$i259$ph = 0, $$14$i$i = 0, $$2$i$i = 0, $$in = 0, $$lcssa667 = 0, $$lcssa674 = 0, $$lcssa682 = 0, $$lcssa690 = 0, $$lcssa698 = 0, $$lcssa706 = 0, $$ph390 = 0, $$pre$i$i$i$i = 0, $$pre$i$i$i$i203 = 0, $$pre$i$i$i21$i = 0, $$pre$i$i$i36$i = 0, $$pre$i$i$i52$i = 0, $$pre$i$i$i71$i = 0, $0 = 0, $1 = 0, $10 = 0, $1001 = 0, $1003 = 0, $1006 = 0, $101 = 0, $1010 = 0, $1013 = 0, $1018 = 0, $1019 = 0, $1022 = 0, $1023 = 0, $1025 = 0, $1026 = 0, $1035 = 0, $1038 = 0, $104 = 0, $1043 = 0, $1044 = 0, $1049 = 0, $1051 = 0, $1054 = 0, $1058 = 0, $1061 = 0, $1066 = 0, $1067 = 0, $107 = 0, $1070 = 0, $1071 = 0, $1073 = 0, $1074 = 0, $108 = 0, $1083 = 0, $1086 = 0, $1094 = 0, $1096 = 0, $11 = 0, $1100 = 0, $1101 = 0, $1103 = 0, $1110 = 0, $1112 = 0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0, $1126 = 0, $1129 = 0, $113 = 0, $1132 = 0, $1133 = 0, $1139 = 0, $1141 = 0, $1145 = 0, $115 = 0, $1151 = 0, $1152 = 0, $1153 = 0, $1159 = 0, $1161 = 0, $1164 = 0, $1165 = 0, $1166 = 0, $1168 = 0, $117 = 0, $1178 = 0, $1179 = 0, $1180 = 0, $1181 = 0, $1184 = 0, $1187 = 0, $119 = 0, $1190 = 0, $1191 = 0, $1196 = 0, $1197 = 0, $1198 = 0, $1199 = 0, $12 = 0, $120 = 0, $1201 = 0, $1202 = 0, $1203 = 0, $1205 = 0, $1210 = 0, $1217 = 0, $1219 = 0, $122 = 0, $1223 = 0, $1226 = 0, $1228 = 0, $123 = 0, $1233 = 0, $1237 = 0, $124 = 0, $1245 = 0, $1252 = 0, $1253 = 0, $1254 = 0, $1255 = 0, $1256 = 0, $1257 = 0, $126 = 0, $1269 = 0, $1270 = 0, $1271 = 0, $1274 = 0, $1277 = 0, $1283 = 0, $1289 = 0, $1290 = 0, $1291 = 0, $1297 = 0, $1299 = 0, $13 = 0, $1302 = 0, $1303 = 0, $1304 = 0, $1306 = 0, $1316 = 0, $1317 = 0, $1318 = 0, $1319 = 0, $1322 = 0, $1325 = 0, $1328 = 0, $1329 = 0, $1334 = 0, $1335 = 0, $1336 = 0, $1337 = 0, $1338 = 0, $1339 = 0, $134 = 0, $1340 = 0, $1342 = 0, $1343 = 0, $1344 = 0, $1346 = 0, $1351 = 0, $1358 = 0, $136 = 0, $1360 = 0, $1364 = 0, $1367 = 0, $1369 = 0, $1374 = 0, $1378 = 0, $1386 = 0, $1393 = 0, $1394 = 0, $1395 = 0, $1397 = 0, $14 = 0, $1402 = 0, $1409 = 0, $1411 = 0, $1415 = 0, $1418 = 0, $1420 = 0, $1425 = 0, $1426 = 0, $1427 = 0, $1428 = 0, $1432 = 0, $1436 = 0, $1439 = 0, $1443 = 0, $1444 = 0, $1446 = 0, $1449 = 0, $1455 = 0, $1458 = 0, $147 = 0, $1470 = 0, $1474 = 0, $1475 = 0, $1486 = 0, $1487 = 0, $1488 = 0, $1489 = 0, $149 = 0, $1490 = 0, $1491 = 0, $15 = 0, $1503 = 0, $1504 = 0, $1505 = 0, $1508 = 0, $1511 = 0, $1517 = 0, $1523 = 0, $1524 = 0, $1525 = 0, $1531 = 0, $1533 = 0, $1536 = 0, $1537 = 0, $1538 = 0, $1540 = 0, $1550 = 0, $1551 = 0, $1552 = 0, $1553 = 0, $1556 = 0, $1559 = 0, $1562 = 0, $1563 = 0, $1568 = 0, $1569 = 0, $1570 = 0, $1571 = 0, $1573 = 0, $1574 = 0, $1575 = 0, $1577 = 0, $1582 = 0, $1589 = 0, $1591 = 0, $1595 = 0, $1598 = 0, $16 = 0, $1600 = 0, $1605 = 0, $1609 = 0, $1617 = 0, $1624 = 0, $1625 = 0, $1626 = 0, $1627 = 0, $1628 = 0, $1629 = 0, $164 = 0, $1641 = 0, $1642 = 0, $1643 = 0, $1646 = 0, $1649 = 0, $165 = 0, $1655 = 0, $166 = 0, $1661 = 0, $1662 = 0, $1668 = 0, $167 = 0, $1670 = 0, $1671 = 0, $1673 = 0, $1674 = 0, $1675 = 0, $1676 = 0, $1677 = 0, $168 = 0, $1687 = 0, $1688 = 0, $1689 = 0, $169 = 0, $1690 = 0, $1693 = 0, $1696 = 0, $1699 = 0, $17 = 0, $1700 = 0, $1705 = 0, $1707 = 0, $1708 = 0, $1709 = 0, $1710 = 0, $1711 = 0, $1712 = 0, $1724 = 0, $1725 = 0, $1726 = 0, $1729 = 0, $1732 = 0, $1743 = 0, $1747 = 0, $1748 = 0, $1749 = 0, $1750 = 0, $1753 = 0, $1755 = 0, $1766 = 0, $1768 = 0, $1769 = 0, $1776 = 0, $1778 = 0, $1786 = 0, $1787 = 0, $1788 = 0, $1789 = 0, $1792 = 0, $1795 = 0, $1798 = 0, $1799 = 0, $18 = 0, $1805 = 0, $1807 = 0, $181 = 0, $1811 = 0, $1813 = 0, $1815 = 0, $1817 = 0, $1818 = 0, $182 = 0, $1826 = 0, $1827 = 0, $1828 = 0, $1829 = 0, $183 = 0, $1831 = 0, $1832 = 0, $1834 = 0, $1839 = 0, $1846 = 0, $1848 = 0, $1853 = 0, $1858 = 0, $186 = 0, $1860 = 0, $1866 = 0, $1869 = 0, $1871 = 0, $1881 = 0, $1884 = 0, $1885 = 0, $1886 = 0, $1887 = 0, $1889 = 0, $189 = 0, $1891 = 0, $1892 = 0, $1894 = 0, $1895 = 0, $1897 = 0, $19 = 0, $1903 = 0, $1912 = 0, $1915 = 0, $1917 = 0, $1927 = 0, $1930 = 0, $1933 = 0, $1935 = 0, $1942 = 0, $1945 = 0, $1947 = 0, $195 = 0, $1954 = 0, $1955 = 0, $1956 = 0, $1957 = 0, $1961 = 0, $1963 = 0, $1966 = 0, $1967 = 0, $197 = 0, $1970 = 0, $1973 = 0, $1974 = 0, $1975 = 0, $1977 = 0, $1984 = 0, $1986 = 0, $1994 = 0, $1995 = 0, $1996 = 0, $1997 = 0, $2 = 0, $20 = 0, $200 = 0, $2000 = 0, $2003 = 0, $2006 = 0, $2007 = 0, $2013 = 0, $2015 = 0, $2019 = 0, $202 = 0, $2023 = 0, $2027 = 0, $2029 = 0, $2033 = 0, $2034 = 0, $2036 = 0, $204 = 0, $2043 = 0, $2045 = 0, $205 = 0, $2053 = 0, $2054 = 0, $2055 = 0, $2056 = 0, $2059 = 0, $2062 = 0, $2065 = 0, $2066 = 0, $2072 = 0, $2074 = 0, $2078 = 0, $208 = 0, $2080 = 0, $2082 = 0, $2083 = 0, $209 = 0, $2091 = 0, $2092 = 0, $2093 = 0, $2094 = 0, $2097 = 0, $2099 = 0, $21 = 0, $211 = 0, $2110 = 0, $2113 = 0, $2114 = 0, $2115 = 0, $2117 = 0, $212 = 0, $2124 = 0, $2126 = 0, $2134 = 0, $2135 = 0, $2136 = 0, $2137 = 0, $214 = 0, $2140 = 0, $2143 = 0, $2146 = 0, $2147 = 0, $2153 = 0, $2155 = 0, $2159 = 0, $2161 = 0, $2163 = 0, $2169 = 0, $2170 = 0, $2171 = 0, $2177 = 0, $2179 = 0, $2182 = 0, $2183 = 0, $2184 = 0, $2186 = 0, $219 = 0, $2196 = 0, $2197 = 0, $2198 = 0, $2199 = 0, $22 = 0, $2202 = 0, $2205 = 0, $2208 = 0, $2209 = 0, $2214 = 0, $2216 = 0, $2217 = 0, $2218 = 0, $2219 = 0, $2220 = 0, $2221 = 0, $2233 = 0, $2234 = 0, $2235 = 0, $2238 = 0, $2241 = 0, $2247 = 0, $2251 = 0, $2253 = 0, $2257 = 0, $2258 = 0, $226 = 0, $2260 = 0, $2267 = 0, $2269 = 0, $2277 = 0, $2278 = 0, $2279 = 0, $228 = 0, $2280 = 0, $2283 = 0, $2286 = 0, $2289 = 0, $2290 = 0, $2296 = 0, $2298 = 0, $23 = 0, $2308 = 0, $2309 = 0, $2311 = 0, $2317 = 0, $2318 = 0, $2322 = 0, $2326 = 0, $2329 = 0, $233 = 0, $2332 = 0, $2335 = 0, $2337 = 0, $2347 = 0, $2348 = 0, $2351 = 0, $2354 = 0, $2355 = 0, $2357 = 0, $2364 = 0, $2365 = 0, $2366 = 0, $2367 = 0, $2371 = 0, $2373 = 0, $2376 = 0, $2377 = 0, $238 = 0, $2382 = 0, $2385 = 0, $2386 = 0, $2393 = 0, $2394 = 0, $2395 = 0, $2396 = 0, $2398 = 0, $24 = 0, $240 = 0, $2402 = 0, $2405 = 0, $2408 = 0, $2424 = 0, $2425 = 0, $2426 = 0, $2427 = 0, $2432 = 0, $2434 = 0, $2438 = 0, $2441 = 0, $2444 = 0, $2446 = 0, $2459 = 0, $2461 = 0, $2465 = 0, $2466 = 0, $2468 = 0, $2475 = 0, $2477 = 0, $2485 = 0, $2486 = 0, $2487 = 0, $2488 = 0, $2491 = 0, $2494 = 0, $2497 = 0, $2498 = 0, $25 = 0, $250 = 0, $2504 = 0, $2506 = 0, $2510 = 0, $2512 = 0, $2516 = 0, $2518 = 0, $2522 = 0, $2523 = 0, $2525 = 0, $2532 = 0, $2534 = 0, $254 = 0, $2542 = 0, $2543 = 0, $2544 = 0, $2545 = 0, $2548 = 0, $255 = 0, $2551 = 0, $2554 = 0, $2555 = 0, $2561 = 0, $2563 = 0, $2567 = 0, $2568 = 0, $2569 = 0, $2570 = 0, $2571 = 0, $2572 = 0, $2573 = 0, $258 = 0, $259 = 0, $26 = 0, $261 = 0, $262 = 0, $264 = 0, $269 = 0, $27 = 0, $276 = 0, $278 = 0, $28 = 0, $283 = 0, $288 = 0, $29 = 0, $290 = 0, $298 = 0, $3 = 0, $30 = 0, $301 = 0, $308 = 0, $309 = 0, $31 = 0, $318 = 0, $32 = 0, $321 = 0, $324 = 0, $326 = 0, $33 = 0, $336 = 0, $34 = 0, $341 = 0, $342 = 0, $344 = 0, $345 = 0, $35 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $359 = 0, $36 = 0, $360 = 0, $365 = 0, $367 = 0, $37 = 0, $370 = 0, $374 = 0, $377 = 0, $38 = 0, $382 = 0, $383 = 0, $386 = 0, $387 = 0, $389 = 0, $39 = 0, $390 = 0, $399 = 0, $4 = 0, $40 = 0, $402 = 0, $407 = 0, $408 = 0, $41 = 0, $410 = 0, $411 = 0, $415 = 0, $416 = 0, $418 = 0, $42 = 0, $422 = 0, $424 = 0, $429 = 0, $43 = 0, $434 = 0, $436 = 0, $44 = 0, $441 = 0, $442 = 0, $443 = 0, $446 = 0, $449 = 0, $45 = 0, $451 = 0, $458 = 0, $46 = 0, $465 = 0, $467 = 0, $47 = 0, $470 = 0, $474 = 0, $477 = 0, $48 = 0, $482 = 0, $483 = 0, $486 = 0, $487 = 0, $489 = 0, $49 = 0, $490 = 0, $499 = 0, $5 = 0, $50 = 0, $502 = 0, $510 = 0, $512 = 0, $516 = 0, $517 = 0, $519 = 0, $526 = 0, $528 = 0, $536 = 0, $537 = 0, $538 = 0, $539 = 0, $54 = 0, $542 = 0, $545 = 0, $548 = 0, $549 = 0, $555 = 0, $557 = 0, $56 = 0, $561 = 0, $562 = 0, $565 = 0, $566 = 0, $569 = 0, $57 = 0, $571 = 0, $574 = 0, $575 = 0, $577 = 0, $584 = 0, $586 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $6 = 0, $600 = 0, $603 = 0, $606 = 0, $607 = 0, $613 = 0, $615 = 0, $620 = 0, $624 = 0, $626 = 0, $628 = 0, $629 = 0, $63 = 0, $630 = 0, $631 = 0, $632 = 0, $635 = 0, $636 = 0, $637 = 0, $638 = 0, $64 = 0, $641 = 0, $644 = 0, $648 = 0, $657 = 0, $658 = 0, $664 = 0, $669 = 0, $679 = 0, $681 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $698 = 0, $7 = 0, $70 = 0, $703 = 0, $705 = 0, $716 = 0, $718 = 0, $72 = 0, $722 = 0, $723 = 0, $725 = 0, $73 = 0, $732 = 0, $734 = 0, $74 = 0, $742 = 0, $743 = 0, $744 = 0, $745 = 0, $748 = 0, $75 = 0, $751 = 0, $754 = 0, $755 = 0, $76 = 0, $761 = 0, $763 = 0, $767 = 0, $768 = 0, $77 = 0, $771 = 0, $772 = 0, $775 = 0, $777 = 0, $780 = 0, $781 = 0, $783 = 0, $79 = 0, $790 = 0, $792 = 0, $8 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0, $806 = 0, $809 = 0, $812 = 0, $813 = 0, $819 = 0, $82 = 0, $821 = 0, $826 = 0, $827 = 0, $829 = 0, $831 = 0, $832 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $846 = 0, $856 = 0, $857 = 0, $858 = 0, $86 = 0, $861 = 0, $863 = 0, $873 = 0, $876 = 0, $883 = 0, $885 = 0, $888 = 0, $892 = 0, $895 = 0, $9 = 0, $900 = 0, $901 = 0, $904 = 0, $905 = 0, $907 = 0, $908 = 0, $917 = 0, $920 = 0, $925 = 0, $926 = 0, $929 = 0, $934 = 0, $936 = 0, $939 = 0, $943 = 0, $946 = 0, $95 = 0, $951 = 0, $952 = 0, $955 = 0, $956 = 0, $958 = 0, $959 = 0, $96 = 0, $968 = 0, $97 = 0, $971 = 0, $976 = 0, $979 = 0, $98 = 0, $981 = 0, $991 = 0, $994 = 0, $__p$0$i$i$i508 = 0, $__p$0$ph$i$i$i = 0, $__v$i$i$i = 0, $args = 0, $cv = 0, $k$0$i515 = 0, $k$0560 = 0, $k11$0540 = 0, $k15$0543 = 0, $k2$0$i516 = 0, $k20$0550 = 0, $k5$0533 = 0, $k8$0536 = 0, $num1$i = 0, $p$0 = 0, $p$1 = 0, $p$2 = 0, $phitmp$i$i$i$i$i$i$i240 = 0, $phitmp$i2$i$i$i$i$i$i243 = 0, $proto = 0, $ref_qual$0$i$ph$ph = 0, $ref_qual$0$i$ph521 = 0, $ref_qual$0$i$ph521$lcssa = 0, $t$0$i = 0, $t$1$i$be = 0, $t$1$i$ph$ph = 0, $t$1$i$ph520 = 0, $t$1$i518 = 0, $t$1$i518$lcssa = 0, $t12$0$i = 0, $template_args = 0, $type = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 784 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $__v$i$i$i = sp + 752 | 0;
 $0 = sp + 728 | 0;
 $1 = sp + 716 | 0;
 $2 = sp + 704 | 0;
 $3 = sp + 680 | 0;
 $4 = sp + 656 | 0;
 $5 = sp + 632 | 0;
 $6 = sp + 620 | 0;
 $num1$i = sp + 608 | 0;
 $7 = sp + 596 | 0;
 $8 = sp + 584 | 0;
 $9 = sp + 572 | 0;
 $cv = sp + 568 | 0;
 $10 = sp + 552 | 0;
 $11 = sp + 544 | 0;
 $12 = sp + 528 | 0;
 $13 = sp + 520 | 0;
 $14 = sp + 504 | 0;
 $15 = sp + 496 | 0;
 $16 = sp + 480 | 0;
 $17 = sp + 472 | 0;
 $18 = sp + 456 | 0;
 $19 = sp + 452 | 0;
 $20 = sp + 440 | 0;
 $21 = sp + 428 | 0;
 $22 = sp + 416 | 0;
 $23 = sp + 404 | 0;
 $args = sp + 392 | 0;
 $24 = sp + 376 | 0;
 $25 = sp + 368 | 0;
 $type = sp + 356 | 0;
 $26 = sp + 344 | 0;
 $27 = sp + 320 | 0;
 $28 = sp + 308 | 0;
 $29 = sp + 296 | 0;
 $30 = sp + 284 | 0;
 $proto = sp + 272 | 0;
 $31 = sp + 248 | 0;
 $32 = sp + 236 | 0;
 $33 = sp + 224 | 0;
 $34 = sp + 212 | 0;
 $35 = sp + 200 | 0;
 $36 = sp + 176 | 0;
 $37 = sp + 164 | 0;
 $38 = sp + 152 | 0;
 $39 = sp + 136 | 0;
 $40 = sp + 128 | 0;
 $41 = sp + 112 | 0;
 $42 = sp + 108 | 0;
 $template_args = sp + 96 | 0;
 $43 = sp + 80 | 0;
 $44 = sp + 72 | 0;
 $45 = sp + 56 | 0;
 $46 = sp + 48 | 0;
 $47 = sp + 32 | 0;
 $48 = sp + 24 | 0;
 $49 = sp + 8 | 0;
 $50 = sp;
 L1 : do if (($first | 0) == ($last | 0)) $$0 = $first; else {
  switch (HEAP8[$first >> 0] | 0) {
  case 75:
  case 86:
  case 114:
   {
    HEAP32[$cv >> 2] = 0;
    $54 = __ZN10__cxxabiv112_GLOBAL__N_119parse_cv_qualifiersEPKcS2_Rj($first, $last, $cv) | 0;
    if (($54 | 0) == ($first | 0)) {
     $$0 = $first;
     break L1;
    }
    $56 = HEAP8[$54 >> 0] | 0;
    $57 = $db + 4 | 0;
    $63 = ((HEAP32[$57 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
    $64 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($54, $last, $db) | 0;
    $70 = ((HEAP32[$57 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
    if (($64 | 0) == ($54 | 0)) {
     $$0 = $first;
     break L1;
    }
    $72 = $56 << 24 >> 24 == 70;
    $73 = $db + 20 | 0;
    $74 = HEAP32[$73 >> 2] | 0;
    if ($72) {
     $75 = $74 + -16 | 0;
     $77 = $74;
     do {
      $76 = $77 + -16 | 0;
      HEAP32[$73 >> 2] = $76;
      __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($76);
      $77 = HEAP32[$73 >> 2] | 0;
     } while (($77 | 0) != ($75 | 0));
     $86 = $75;
    } else $86 = $74;
    $79 = $db + 16 | 0;
    $82 = HEAP32[$db + 12 >> 2] | 0;
    $84 = HEAP32[$db + 24 >> 2] | 0;
    if ($86 >>> 0 < $84 >>> 0) {
     HEAP32[$86 >> 2] = 0;
     HEAP32[$86 + 4 >> 2] = 0;
     HEAP32[$86 + 8 >> 2] = 0;
     HEAP32[$86 + 12 >> 2] = $82;
     HEAP32[$73 >> 2] = (HEAP32[$73 >> 2] | 0) + 16;
    } else {
     $95 = HEAP32[$79 >> 2] | 0;
     $96 = $86 - $95 | 0;
     $97 = $96 >> 4;
     $98 = $97 + 1 | 0;
     if (($96 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($79);
     $101 = $84 - $95 | 0;
     if ($101 >> 4 >>> 0 < 1073741823) {
      $104 = $101 >> 3;
      $$0$i$i$i38 = $104 >>> 0 < $98 >>> 0 ? $98 : $104;
     } else $$0$i$i$i38 = 2147483647;
     __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i38, $97, $db + 28 | 0);
     $107 = $__v$i$i$i + 8 | 0;
     $108 = HEAP32[$107 >> 2] | 0;
     HEAP32[$108 >> 2] = 0;
     HEAP32[$108 + 4 >> 2] = 0;
     HEAP32[$108 + 8 >> 2] = 0;
     HEAP32[$108 + 12 >> 2] = $82;
     HEAP32[$107 >> 2] = $108 + 16;
     __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($79, $__v$i$i$i);
     __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
    }
    $113 = HEAP32[$cv >> 2] | 0;
    $115 = ($113 & 1 | 0) == 0;
    $117 = ($113 & 2 | 0) == 0;
    $119 = ($113 & 4 | 0) == 0;
    $120 = $__v$i$i$i + 8 | 0;
    if ($63 >>> 0 < $70 >>> 0) $k$0560 = $63; else {
     $$0 = $64;
     break L1;
    }
    while (1) {
     if ($72) {
      $122 = HEAP32[$db >> 2] | 0;
      $123 = $122 + ($k$0560 * 24 | 0) + 12 | 0;
      $124 = HEAP8[$123 >> 0] | 0;
      $126 = ($124 & 1) == 0;
      if ($126) {
       $$in = ($124 & 255) >>> 1;
       $136 = $123 + 1 | 0;
      } else {
       $$in = HEAP32[$122 + ($k$0560 * 24 | 0) + 16 >> 2] | 0;
       $136 = HEAP32[$122 + ($k$0560 * 24 | 0) + 20 >> 2] | 0;
      }
      $134 = $$in + -2 | 0;
      if ((HEAP8[$136 + $134 >> 0] | 0) == 38) $p$0 = $$in + -3 | 0; else {
       if ($126) {
        $147 = ($124 & 255) >>> 1;
        $149 = $123 + 1 | 0;
       } else {
        $147 = HEAP32[$122 + ($k$0560 * 24 | 0) + 16 >> 2] | 0;
        $149 = HEAP32[$122 + ($k$0560 * 24 | 0) + 20 >> 2] | 0;
       }
       $p$0 = (HEAP8[$149 + ($147 + -1) >> 0] | 0) == 38 ? $134 : $$in;
      }
      if ($115) $p$1 = $p$0; else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($123, $p$0, 12669) | 0;
       $p$1 = $p$0 + 6 | 0;
      }
      if ($117) $p$2 = $p$1; else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k$0560 * 24 | 0) + 12 | 0, $p$1, 12676) | 0;
       $p$2 = $p$1 + 9 | 0;
      }
      if (!$119) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k$0560 * 24 | 0) + 12 | 0, $p$2, 12686) | 0;
     } else {
      if (!$115) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$db >> 2] | 0) + ($k$0560 * 24 | 0) | 0, 12669) | 0;
      if (!$117) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$db >> 2] | 0) + ($k$0560 * 24 | 0) | 0, 12676) | 0;
      if (!$119) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$db >> 2] | 0) + ($k$0560 * 24 | 0) | 0, 12686) | 0;
     }
     $164 = HEAP32[$73 >> 2] | 0;
     $165 = $164 + -16 | 0;
     $166 = HEAP32[$db >> 2] | 0;
     $167 = $166 + ($k$0560 * 24 | 0) | 0;
     $168 = $164 + -12 | 0;
     $169 = HEAP32[$168 >> 2] | 0;
     if (($169 | 0) == (HEAP32[$164 + -8 >> 2] | 0)) {
      $181 = $169 - (HEAP32[$165 >> 2] | 0) | 0;
      $182 = ($181 | 0) / 24 | 0;
      $183 = $182 + 1 | 0;
      if (($181 | 0) < -24) {
       $$lcssa706 = $165;
       break;
      }
      if ($182 >>> 0 < 1073741823) {
       $186 = $182 << 1;
       $$0$i$i$i43 = $186 >>> 0 < $183 >>> 0 ? $183 : $186;
      } else $$0$i$i$i43 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i43, $182, $164 + -4 | 0);
      $189 = HEAP32[$120 >> 2] | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($189, $167);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($189 + 12 | 0, $166 + ($k$0560 * 24 | 0) + 12 | 0);
      HEAP32[$120 >> 2] = $189 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($165, $__v$i$i$i);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
     } else {
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($169, $167);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($169 + 12 | 0, $166 + ($k$0560 * 24 | 0) + 12 | 0);
      HEAP32[$168 >> 2] = (HEAP32[$168 >> 2] | 0) + 24;
     }
     $k$0560 = $k$0560 + 1 | 0;
     if ($k$0560 >>> 0 >= $70 >>> 0) {
      $$0 = $64;
      break L1;
     }
    }
    __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa706);
    break;
   }
  default:
   {}
  }
  $195 = __ZN10__cxxabiv112_GLOBAL__N_118parse_builtin_typeINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
  if (($195 | 0) == ($first | 0)) {
   $197 = HEAP8[$first >> 0] | 0;
   L65 : do switch ($197 << 24 >> 24 | 0) {
   case 65:
    {
     do if ($197 << 24 >> 24 == 65) {
      $200 = $first + 1 | 0;
      if (($200 | 0) == ($last | 0)) $$0$i = $first; else {
       $202 = HEAP8[$200 >> 0] | 0;
       if ($202 << 24 >> 24 == 95) {
        $204 = $first + 2 | 0;
        $205 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($204, $last, $db) | 0;
        if (($205 | 0) == ($204 | 0)) {
         $$0$i = $first;
         break;
        }
        $208 = $db + 4 | 0;
        $209 = HEAP32[$208 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($209 | 0)) {
         $$0$i = $first;
         break;
        }
        $211 = $209 + -12 | 0;
        $212 = HEAP8[$211 >> 0] | 0;
        $214 = ($212 & 1) == 0;
        $219 = $214 ? ($212 & 255) >>> 1 : HEAP32[$209 + -8 >> 2] | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($__v$i$i$i, $214 ? $211 + 1 | 0 : HEAP32[$209 + -4 >> 2] | 0, $219 >>> 0 < 2 ? $219 : 2);
        $226 = HEAP8[$__v$i$i$i >> 0] | 0;
        $228 = ($226 & 1) == 0;
        $233 = $228 ? ($226 & 255) >>> 1 : HEAP32[$__v$i$i$i + 4 >> 2] | 0;
        $238 = $233 >>> 0 > 2;
        $240 = _memcmp($228 ? $__v$i$i$i + 1 | 0 : HEAP32[$__v$i$i$i + 8 >> 2] | 0, 12696, $238 ? 2 : $233) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($__v$i$i$i);
        if (!((($240 | 0) == 0 ? ($233 >>> 0 < 2 ? -1 : $238 & 1) : $240) | 0)) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE5eraseEjj((HEAP32[$208 >> 2] | 0) + -12 | 0);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$208 >> 2] | 0) + -12 | 0, 0, 12699) | 0;
        $$0$i = $205;
        break;
       }
       if (($202 + -49 & 255) < 9) {
        $250 = __ZN10__cxxabiv112_GLOBAL__N_112parse_numberEPKcS2_($200, $last) | 0;
        if (($250 | 0) == ($last | 0)) {
         $$0$i = $first;
         break;
        }
        if ((HEAP8[$250 >> 0] | 0) != 95) {
         $$0$i = $first;
         break;
        }
        $254 = $250 + 1 | 0;
        $255 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($254, $last, $db) | 0;
        if (($255 | 0) == ($254 | 0)) {
         $$0$i = $first;
         break;
        }
        $258 = $db + 4 | 0;
        $259 = HEAP32[$258 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($259 | 0)) {
         $$0$i = $first;
         break;
        }
        $261 = $259 + -12 | 0;
        $262 = HEAP8[$261 >> 0] | 0;
        $264 = ($262 & 1) == 0;
        $269 = $264 ? ($262 & 255) >>> 1 : HEAP32[$259 + -8 >> 2] | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($0, $264 ? $261 + 1 | 0 : HEAP32[$259 + -4 >> 2] | 0, $269 >>> 0 < 2 ? $269 : 2);
        $276 = HEAP8[$0 >> 0] | 0;
        $278 = ($276 & 1) == 0;
        $283 = $278 ? ($276 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0;
        $288 = $283 >>> 0 > 2;
        $290 = _memcmp($278 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, 12696, $288 ? 2 : $283) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
        if (!((($290 | 0) == 0 ? ($283 >>> 0 < 2 ? -1 : $288 & 1) : $290) | 0)) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE5eraseEjj((HEAP32[$258 >> 2] | 0) + -12 | 0);
        $298 = (HEAP32[$258 >> 2] | 0) + -12 | 0;
        $301 = $250 - $200 | 0;
        if ($301 >>> 0 > 4294967279) __ZNKSt3__121__basic_string_commonILb1EE20__throw_length_errorEv($3);
        if ($301 >>> 0 < 11) {
         HEAP8[$3 >> 0] = $301 << 1;
         $__p$0$ph$i$i$i = $3 + 1 | 0;
        } else {
         $308 = $301 + 16 & -16;
         $309 = _malloc($308) | 0;
         HEAP32[$3 + 8 >> 2] = $309;
         HEAP32[$3 >> 2] = $308 | 1;
         HEAP32[$3 + 4 >> 2] = $301;
         $__p$0$ph$i$i$i = $309;
        }
        if (($200 | 0) != ($250 | 0)) {
         $$0$i$i$i191509 = $200;
         $__p$0$i$i$i508 = $__p$0$ph$i$i$i;
         while (1) {
          HEAP8[$__p$0$i$i$i508 >> 0] = HEAP8[$$0$i$i$i191509 >> 0] | 0;
          $$0$i$i$i191509 = $$0$i$i$i191509 + 1 | 0;
          if (($$0$i$i$i191509 | 0) == ($250 | 0)) break; else $__p$0$i$i$i508 = $__p$0$i$i$i508 + 1 | 0;
         }
        }
        HEAP8[$__p$0$ph$i$i$i + $301 >> 0] = 0;
        $318 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($3, 0, 12696) | 0;
        HEAP32[$2 >> 2] = HEAP32[$318 >> 2];
        HEAP32[$2 + 4 >> 2] = HEAP32[$318 + 4 >> 2];
        HEAP32[$2 + 8 >> 2] = HEAP32[$318 + 8 >> 2];
        HEAP32[$318 >> 2] = 0;
        HEAP32[$318 + 4 >> 2] = 0;
        HEAP32[$318 + 8 >> 2] = 0;
        $321 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12703) | 0;
        HEAP32[$1 >> 2] = HEAP32[$321 >> 2];
        HEAP32[$1 + 4 >> 2] = HEAP32[$321 + 4 >> 2];
        HEAP32[$1 + 8 >> 2] = HEAP32[$321 + 8 >> 2];
        HEAP32[$321 >> 2] = 0;
        HEAP32[$321 + 4 >> 2] = 0;
        HEAP32[$321 + 8 >> 2] = 0;
        $324 = HEAP8[$1 >> 0] | 0;
        $326 = ($324 & 1) == 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKcj($298, 0, $326 ? $1 + 1 | 0 : HEAP32[$1 + 8 >> 2] | 0, $326 ? ($324 & 255) >>> 1 : HEAP32[$1 + 4 >> 2] | 0) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
        $$0$i = $255;
        break;
       }
       $336 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($200, $last, $db) | 0;
       if (($336 | 0) == ($200 | 0) | ($336 | 0) == ($last | 0)) $$0$i = $first; else if ((HEAP8[$336 >> 0] | 0) == 95) {
        $341 = $336 + 1 | 0;
        $342 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($341, $last, $db) | 0;
        if (($342 | 0) == ($341 | 0)) $$0$i = $first; else {
         $344 = $db + 4 | 0;
         $345 = HEAP32[$344 >> 2] | 0;
         if ((($345 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$0$i = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($4, $345 + -24 | 0);
          $353 = HEAP32[$344 >> 2] | 0;
          $354 = $353 + -24 | 0;
          $356 = $353;
          do {
           $355 = $356 + -24 | 0;
           HEAP32[$344 >> 2] = $355;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($355);
           $356 = HEAP32[$344 >> 2] | 0;
          } while (($356 | 0) != ($354 | 0));
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($5, $353 + -48 | 0);
          $359 = HEAP32[$344 >> 2] | 0;
          $360 = $359 + -24 | 0;
          do if (!(HEAP8[$360 >> 0] & 1)) {
           HEAP8[$360 + 1 >> 0] = 0;
           HEAP8[$360 >> 0] = 0;
          } else {
           $365 = $359 + -16 | 0;
           HEAP8[HEAP32[$365 >> 2] >> 0] = 0;
           $367 = $359 + -20 | 0;
           HEAP32[$367 >> 2] = 0;
           $$pre$i$i$i$i203 = HEAP8[$360 >> 0] | 0;
           if (!($$pre$i$i$i$i203 & 1)) {
            $374 = $$pre$i$i$i$i203;
            $383 = 10;
           } else {
            $370 = HEAP32[$360 >> 2] | 0;
            $374 = $370 & 255;
            $383 = ($370 & -2) + -1 | 0;
           }
           if (!($374 & 1)) {
            $377 = ($374 & 255) >>> 1;
            if (($374 & 255) < 22) {
             $2567 = 1;
             $382 = 10;
             $402 = $377;
            } else {
             $2567 = 1;
             $382 = ($377 + 16 & 240) + -1 | 0;
             $402 = $377;
            }
           } else {
            $2567 = 0;
            $382 = 10;
            $402 = 0;
           }
           if (($382 | 0) != ($383 | 0)) {
            if (($382 | 0) == 10) {
             $389 = $360 + 1 | 0;
             $390 = HEAP32[$365 >> 2] | 0;
             if ($2567) {
              _memcpy($389 | 0, $390 | 0, (($374 & 255) >>> 1) + 1 | 0) | 0;
              _free($390);
             } else {
              HEAP8[$389 >> 0] = HEAP8[$390 >> 0] | 0;
              _free($390);
             }
             HEAP8[$360 >> 0] = $402 << 1;
             break;
            }
            $386 = $382 + 1 | 0;
            $387 = _malloc($386) | 0;
            if (!($382 >>> 0 <= $383 >>> 0 & ($387 | 0) == 0)) {
             if ($2567) _memcpy($387 | 0, $360 + 1 | 0, (($374 & 255) >>> 1) + 1 | 0) | 0; else {
              $399 = HEAP32[$365 >> 2] | 0;
              HEAP8[$387 >> 0] = HEAP8[$399 >> 0] | 0;
              _free($399);
             }
             HEAP32[$360 >> 2] = $386 | 1;
             HEAP32[$367 >> 2] = $402;
             HEAP32[$365 >> 2] = $387;
            }
           }
          } while (0);
          HEAP32[$360 >> 2] = HEAP32[$4 >> 2];
          HEAP32[$360 + 4 >> 2] = HEAP32[$4 + 4 >> 2];
          HEAP32[$360 + 8 >> 2] = HEAP32[$4 + 8 >> 2];
          HEAP32[$4 >> 2] = 0;
          HEAP32[$4 + 4 >> 2] = 0;
          HEAP32[$4 + 8 >> 2] = 0;
          $407 = $4 + 12 | 0;
          $408 = HEAP8[$407 >> 0] | 0;
          $410 = ($408 & 1) == 0;
          $411 = $4 + 16 | 0;
          $415 = $410 ? ($408 & 255) >>> 1 : HEAP32[$411 >> 2] | 0;
          $416 = $4 + 20 | 0;
          $418 = $407 + 1 | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($6, $410 ? $418 : HEAP32[$416 >> 2] | 0, $415 >>> 0 < 2 ? $415 : 2);
          $422 = HEAP8[$6 >> 0] | 0;
          $424 = ($422 & 1) == 0;
          $429 = $424 ? ($422 & 255) >>> 1 : HEAP32[$6 + 4 >> 2] | 0;
          $434 = $429 >>> 0 > 2;
          $436 = _memcmp($424 ? $6 + 1 | 0 : HEAP32[$6 + 8 >> 2] | 0, 12696, $434 ? 2 : $429) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          if (!((($436 | 0) == 0 ? ($429 >>> 0 < 2 ? -1 : $434 & 1) : $436) | 0)) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE5eraseEjj($407);
          $441 = HEAP32[$344 >> 2] | 0;
          $442 = $441 + -12 | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($9, $5);
          $443 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($9, 0, 12696) | 0;
          HEAP32[$8 >> 2] = HEAP32[$443 >> 2];
          HEAP32[$8 + 4 >> 2] = HEAP32[$443 + 4 >> 2];
          HEAP32[$8 + 8 >> 2] = HEAP32[$443 + 8 >> 2];
          HEAP32[$443 >> 2] = 0;
          HEAP32[$443 + 4 >> 2] = 0;
          HEAP32[$443 + 8 >> 2] = 0;
          $446 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($8, 12703) | 0;
          HEAP32[$7 >> 2] = HEAP32[$446 >> 2];
          HEAP32[$7 + 4 >> 2] = HEAP32[$446 + 4 >> 2];
          HEAP32[$7 + 8 >> 2] = HEAP32[$446 + 8 >> 2];
          HEAP32[$446 >> 2] = 0;
          HEAP32[$446 + 4 >> 2] = 0;
          HEAP32[$446 + 8 >> 2] = 0;
          $449 = HEAP8[$407 >> 0] | 0;
          $451 = ($449 & 1) == 0;
          $458 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($7, $451 ? $418 : HEAP32[$416 >> 2] | 0, $451 ? ($449 & 255) >>> 1 : HEAP32[$411 >> 2] | 0) | 0;
          HEAP32[$num1$i >> 2] = HEAP32[$458 >> 2];
          HEAP32[$num1$i + 4 >> 2] = HEAP32[$458 + 4 >> 2];
          HEAP32[$num1$i + 8 >> 2] = HEAP32[$458 + 8 >> 2];
          HEAP32[$458 >> 2] = 0;
          HEAP32[$458 + 4 >> 2] = 0;
          HEAP32[$458 + 8 >> 2] = 0;
          do if (!(HEAP8[$442 >> 0] & 1)) {
           HEAP8[$442 + 1 >> 0] = 0;
           HEAP8[$442 >> 0] = 0;
          } else {
           $465 = $441 + -4 | 0;
           HEAP8[HEAP32[$465 >> 2] >> 0] = 0;
           $467 = $441 + -8 | 0;
           HEAP32[$467 >> 2] = 0;
           $$pre$i$i$i36$i = HEAP8[$442 >> 0] | 0;
           if (!($$pre$i$i$i36$i & 1)) {
            $474 = $$pre$i$i$i36$i;
            $483 = 10;
           } else {
            $470 = HEAP32[$442 >> 2] | 0;
            $474 = $470 & 255;
            $483 = ($470 & -2) + -1 | 0;
           }
           do if (!($474 & 1)) {
            $477 = ($474 & 255) >>> 1;
            if (($474 & 255) < 22) {
             $2568 = 1;
             $482 = 10;
             $502 = $477;
             break;
            }
            $2568 = 1;
            $482 = ($477 + 16 & 240) + -1 | 0;
            $502 = $477;
           } else {
            $2568 = 0;
            $482 = 10;
            $502 = 0;
           } while (0);
           if (($482 | 0) != ($483 | 0)) {
            if (($482 | 0) == 10) {
             $489 = $442 + 1 | 0;
             $490 = HEAP32[$465 >> 2] | 0;
             if ($2568) {
              _memcpy($489 | 0, $490 | 0, (($474 & 255) >>> 1) + 1 | 0) | 0;
              _free($490);
             } else {
              HEAP8[$489 >> 0] = HEAP8[$490 >> 0] | 0;
              _free($490);
             }
             HEAP8[$442 >> 0] = $502 << 1;
             break;
            }
            $486 = $482 + 1 | 0;
            $487 = _malloc($486) | 0;
            if ($482 >>> 0 <= $483 >>> 0 & ($487 | 0) == 0) break;
            if ($2568) _memcpy($487 | 0, $442 + 1 | 0, (($474 & 255) >>> 1) + 1 | 0) | 0; else {
             $499 = HEAP32[$465 >> 2] | 0;
             HEAP8[$487 >> 0] = HEAP8[$499 >> 0] | 0;
             _free($499);
            }
            HEAP32[$442 >> 2] = $486 | 1;
            HEAP32[$467 >> 2] = $502;
            HEAP32[$465 >> 2] = $487;
           }
          } while (0);
          HEAP32[$442 >> 2] = HEAP32[$num1$i >> 2];
          HEAP32[$442 + 4 >> 2] = HEAP32[$num1$i + 4 >> 2];
          HEAP32[$442 + 8 >> 2] = HEAP32[$num1$i + 8 >> 2];
          HEAP32[$num1$i >> 2] = 0;
          HEAP32[$num1$i + 4 >> 2] = 0;
          HEAP32[$num1$i + 8 >> 2] = 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($num1$i);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($8);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($9);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($5);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($4);
          $$0$i = $342;
         }
        }
       } else $$0$i = $first;
      }
     } else $$0$i = $first; while (0);
     if (($$0$i | 0) == ($first | 0)) {
      $$0 = $first;
      break L1;
     }
     $510 = HEAP32[$db + 4 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($510 | 0)) {
      $$0 = $first;
      break L1;
     }
     $512 = $db + 16 | 0;
     HEAP32[$11 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($10, $510 + -24 | 0, $11);
     $516 = $db + 20 | 0;
     $517 = HEAP32[$516 >> 2] | 0;
     $519 = HEAP32[$db + 24 >> 2] | 0;
     if ($517 >>> 0 < $519 >>> 0) {
      HEAP32[$517 + 12 >> 2] = HEAP32[$10 + 12 >> 2];
      HEAP32[$517 >> 2] = HEAP32[$10 >> 2];
      $526 = $10 + 4 | 0;
      HEAP32[$517 + 4 >> 2] = HEAP32[$526 >> 2];
      $528 = $10 + 8 | 0;
      HEAP32[$517 + 8 >> 2] = HEAP32[$528 >> 2];
      HEAP32[$528 >> 2] = 0;
      HEAP32[$526 >> 2] = 0;
      HEAP32[$10 >> 2] = 0;
      HEAP32[$516 >> 2] = (HEAP32[$516 >> 2] | 0) + 16;
     } else {
      $536 = HEAP32[$512 >> 2] | 0;
      $537 = $517 - $536 | 0;
      $538 = $537 >> 4;
      $539 = $538 + 1 | 0;
      if (($537 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($512);
      $542 = $519 - $536 | 0;
      if ($542 >> 4 >>> 0 < 1073741823) {
       $545 = $542 >> 3;
       $$0$i$i$i56 = $545 >>> 0 < $539 >>> 0 ? $539 : $545;
      } else $$0$i$i$i56 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i56, $538, $db + 28 | 0);
      $548 = $__v$i$i$i + 8 | 0;
      $549 = HEAP32[$548 >> 2] | 0;
      HEAP32[$549 + 12 >> 2] = HEAP32[$10 + 12 >> 2];
      HEAP32[$549 >> 2] = HEAP32[$10 >> 2];
      $555 = $10 + 4 | 0;
      HEAP32[$549 + 4 >> 2] = HEAP32[$555 >> 2];
      $557 = $10 + 8 | 0;
      HEAP32[$549 + 8 >> 2] = HEAP32[$557 >> 2];
      HEAP32[$557 >> 2] = 0;
      HEAP32[$555 >> 2] = 0;
      HEAP32[$10 >> 2] = 0;
      HEAP32[$548 >> 2] = $549 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($512, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($10);
     $$0 = $$0$i;
     break L1;
     break;
    }
   case 67:
    {
     $561 = $first + 1 | 0;
     $562 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($561, $last, $db) | 0;
     if (($562 | 0) == ($561 | 0)) {
      $$0 = $first;
      break L1;
     }
     $565 = $db + 4 | 0;
     $566 = HEAP32[$565 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($566 | 0)) {
      $$0 = $first;
      break L1;
     }
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($566 + -24 | 0, 12705) | 0;
     $569 = $db + 16 | 0;
     $571 = (HEAP32[$565 >> 2] | 0) + -24 | 0;
     HEAP32[$13 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($12, $571, $13);
     $574 = $db + 20 | 0;
     $575 = HEAP32[$574 >> 2] | 0;
     $577 = HEAP32[$db + 24 >> 2] | 0;
     if ($575 >>> 0 < $577 >>> 0) {
      HEAP32[$575 + 12 >> 2] = HEAP32[$12 + 12 >> 2];
      HEAP32[$575 >> 2] = HEAP32[$12 >> 2];
      $584 = $12 + 4 | 0;
      HEAP32[$575 + 4 >> 2] = HEAP32[$584 >> 2];
      $586 = $12 + 8 | 0;
      HEAP32[$575 + 8 >> 2] = HEAP32[$586 >> 2];
      HEAP32[$586 >> 2] = 0;
      HEAP32[$584 >> 2] = 0;
      HEAP32[$12 >> 2] = 0;
      HEAP32[$574 >> 2] = (HEAP32[$574 >> 2] | 0) + 16;
     } else {
      $594 = HEAP32[$569 >> 2] | 0;
      $595 = $575 - $594 | 0;
      $596 = $595 >> 4;
      $597 = $596 + 1 | 0;
      if (($595 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($569);
      $600 = $577 - $594 | 0;
      if ($600 >> 4 >>> 0 < 1073741823) {
       $603 = $600 >> 3;
       $$0$i$i$i61 = $603 >>> 0 < $597 >>> 0 ? $597 : $603;
      } else $$0$i$i$i61 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i61, $596, $db + 28 | 0);
      $606 = $__v$i$i$i + 8 | 0;
      $607 = HEAP32[$606 >> 2] | 0;
      HEAP32[$607 + 12 >> 2] = HEAP32[$12 + 12 >> 2];
      HEAP32[$607 >> 2] = HEAP32[$12 >> 2];
      $613 = $12 + 4 | 0;
      HEAP32[$607 + 4 >> 2] = HEAP32[$613 >> 2];
      $615 = $12 + 8 | 0;
      HEAP32[$607 + 8 >> 2] = HEAP32[$615 >> 2];
      HEAP32[$615 >> 2] = 0;
      HEAP32[$613 >> 2] = 0;
      HEAP32[$12 >> 2] = 0;
      HEAP32[$606 >> 2] = $607 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($569, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($12);
     $$0 = $562;
     break L1;
     break;
    }
   case 70:
    {
     do if ($197 << 24 >> 24 == 70) {
      $620 = $first + 1 | 0;
      if (($620 | 0) != ($last | 0)) {
       if ((HEAP8[$620 >> 0] | 0) == 89) {
        $624 = $first + 2 | 0;
        if (($624 | 0) == ($last | 0)) break; else $t$0$i = $624;
       } else $t$0$i = $620;
       $626 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($t$0$i, $last, $db) | 0;
       if (($626 | 0) != ($t$0$i | 0)) {
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($__v$i$i$i, 12714, 1);
        $628 = $db + 4 | 0;
        $629 = $__v$i$i$i + 4 | 0;
        $630 = $0 + 8 | 0;
        $631 = $0 + 1 | 0;
        $632 = $0 + 4 | 0;
        L191 : do if (($626 | 0) == ($last | 0)) label = 144; else {
         $ref_qual$0$i$ph521 = 0;
         $t$1$i$ph520 = $626;
         L192 : while (1) {
          $t$1$i518 = $t$1$i$ph520;
          L194 : while (1) {
           switch (HEAP8[$t$1$i518 >> 0] | 0) {
           case 69:
            {
             $ref_qual$0$i$ph521$lcssa = $ref_qual$0$i$ph521;
             $t$1$i518$lcssa = $t$1$i518;
             break L192;
             break;
            }
           case 118:
            {
             $t$1$i$be = $t$1$i518 + 1 | 0;
             break;
            }
           case 82:
            {
             $644 = $t$1$i518 + 1 | 0;
             if (($644 | 0) == ($last | 0)) label = 154; else if ((HEAP8[$644 >> 0] | 0) == 69) {
              $ref_qual$0$i$ph$ph = 1;
              $t$1$i$ph$ph = $644;
              break L194;
             } else label = 154;
             break;
            }
           case 79:
            {
             $648 = $t$1$i518 + 1 | 0;
             if (($648 | 0) == ($last | 0)) label = 154; else if ((HEAP8[$648 >> 0] | 0) == 69) {
              $ref_qual$0$i$ph$ph = 2;
              $t$1$i$ph$ph = $648;
              break L194;
             } else label = 154;
             break;
            }
           default:
            label = 154;
           }
           if ((label | 0) == 154) {
            label = 0;
            $657 = ((HEAP32[$628 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
            $658 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($t$1$i518, $last, $db) | 0;
            $664 = ((HEAP32[$628 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
            if (($658 | 0) == ($t$1$i518 | 0) | ($658 | 0) == ($last | 0)) break L191;
            if ($657 >>> 0 < $664 >>> 0) {
             $k$0$i515 = $657;
             do {
              $669 = HEAP8[$__v$i$i$i >> 0] | 0;
              if ((($669 & 1) == 0 ? ($669 & 255) >>> 1 : HEAP32[$629 >> 2] | 0) >>> 0 > 1) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12716) | 0;
              __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, (HEAP32[$db >> 2] | 0) + ($k$0$i515 * 24 | 0) | 0);
              $679 = HEAP8[$0 >> 0] | 0;
              $681 = ($679 & 1) == 0;
              __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($__v$i$i$i, $681 ? $631 : HEAP32[$630 >> 2] | 0, $681 ? ($679 & 255) >>> 1 : HEAP32[$632 >> 2] | 0) | 0;
              __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
              $k$0$i515 = $k$0$i515 + 1 | 0;
             } while ($k$0$i515 >>> 0 < $664 >>> 0);
            }
            if ($657 >>> 0 < $664 >>> 0) {
             $k2$0$i516 = $657;
             do {
              $690 = HEAP32[$628 >> 2] | 0;
              $691 = $690 + -24 | 0;
              $693 = $690;
              do {
               $692 = $693 + -24 | 0;
               HEAP32[$628 >> 2] = $692;
               __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($692);
               $693 = HEAP32[$628 >> 2] | 0;
              } while (($693 | 0) != ($691 | 0));
              $k2$0$i516 = $k2$0$i516 + 1 | 0;
             } while ($k2$0$i516 >>> 0 < $664 >>> 0);
             $t$1$i$be = $658;
            } else $t$1$i$be = $658;
           }
           if (($t$1$i$be | 0) == ($last | 0)) {
            label = 144;
            break L191;
           } else $t$1$i518 = $t$1$i$be;
          }
          if (($t$1$i$ph$ph | 0) == ($last | 0)) {
           label = 144;
           break L191;
          } else {
           $ref_qual$0$i$ph521 = $ref_qual$0$i$ph$ph;
           $t$1$i$ph520 = $t$1$i$ph$ph;
          }
         }
         $641 = $t$1$i518$lcssa + 1 | 0;
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12619) | 0;
         switch ($ref_qual$0$i$ph521$lcssa | 0) {
         case 1:
          {
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12719) | 0;
           break;
          }
         case 2:
          {
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12722) | 0;
           break;
          }
         default:
          {}
         }
         $698 = HEAP32[$628 >> 2] | 0;
         if ((HEAP32[$db >> 2] | 0) != ($698 | 0)) {
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($698 + -24 | 0, 12726) | 0;
          $703 = HEAP8[$__v$i$i$i >> 0] | 0;
          $705 = ($703 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKcj((HEAP32[$628 >> 2] | 0) + -12 | 0, 0, $705 ? $__v$i$i$i + 1 | 0 : HEAP32[$__v$i$i$i + 8 >> 2] | 0, $705 ? ($703 & 255) >>> 1 : HEAP32[$629 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($__v$i$i$i);
          if (($641 | 0) == ($first | 0)) {
           $$0 = $first;
           break L1;
          }
          $716 = HEAP32[$628 >> 2] | 0;
          if ((HEAP32[$db >> 2] | 0) == ($716 | 0)) {
           $$0 = $first;
           break L1;
          }
          $718 = $db + 16 | 0;
          HEAP32[$15 >> 2] = HEAP32[$db + 12 >> 2];
          __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($14, $716 + -24 | 0, $15);
          $722 = $db + 20 | 0;
          $723 = HEAP32[$722 >> 2] | 0;
          $725 = HEAP32[$db + 24 >> 2] | 0;
          if ($723 >>> 0 < $725 >>> 0) {
           HEAP32[$723 + 12 >> 2] = HEAP32[$14 + 12 >> 2];
           HEAP32[$723 >> 2] = HEAP32[$14 >> 2];
           $732 = $14 + 4 | 0;
           HEAP32[$723 + 4 >> 2] = HEAP32[$732 >> 2];
           $734 = $14 + 8 | 0;
           HEAP32[$723 + 8 >> 2] = HEAP32[$734 >> 2];
           HEAP32[$734 >> 2] = 0;
           HEAP32[$732 >> 2] = 0;
           HEAP32[$14 >> 2] = 0;
           HEAP32[$722 >> 2] = (HEAP32[$722 >> 2] | 0) + 16;
          } else {
           $742 = HEAP32[$718 >> 2] | 0;
           $743 = $723 - $742 | 0;
           $744 = $743 >> 4;
           $745 = $744 + 1 | 0;
           if (($743 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($718);
           $748 = $725 - $742 | 0;
           if ($748 >> 4 >>> 0 < 1073741823) {
            $751 = $748 >> 3;
            $$0$i$i$i66 = $751 >>> 0 < $745 >>> 0 ? $745 : $751;
           } else $$0$i$i$i66 = 2147483647;
           __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i66, $744, $db + 28 | 0);
           $754 = $__v$i$i$i + 8 | 0;
           $755 = HEAP32[$754 >> 2] | 0;
           HEAP32[$755 + 12 >> 2] = HEAP32[$14 + 12 >> 2];
           HEAP32[$755 >> 2] = HEAP32[$14 >> 2];
           $761 = $14 + 4 | 0;
           HEAP32[$755 + 4 >> 2] = HEAP32[$761 >> 2];
           $763 = $14 + 8 | 0;
           HEAP32[$755 + 8 >> 2] = HEAP32[$763 >> 2];
           HEAP32[$763 >> 2] = 0;
           HEAP32[$761 >> 2] = 0;
           HEAP32[$14 >> 2] = 0;
           HEAP32[$754 >> 2] = $755 + 16;
           __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($718, $__v$i$i$i);
           __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
          }
          __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($14);
          $$0 = $641;
          break L1;
         }
        } while (0);
        if ((label | 0) == 144) {
         $635 = HEAP32[$628 >> 2] | 0;
         $636 = $635 + -24 | 0;
         $638 = $635;
         do {
          $637 = $638 + -24 | 0;
          HEAP32[$628 >> 2] = $637;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($637);
          $638 = HEAP32[$628 >> 2] | 0;
         } while (($638 | 0) != ($636 | 0));
        }
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($__v$i$i$i);
       }
      }
     } while (0);
     $$0 = $first;
     break L1;
     break;
    }
   case 71:
    {
     $767 = $first + 1 | 0;
     $768 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($767, $last, $db) | 0;
     if (($768 | 0) == ($767 | 0)) {
      $$0 = $first;
      break L1;
     }
     $771 = $db + 4 | 0;
     $772 = HEAP32[$771 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($772 | 0)) {
      $$0 = $first;
      break L1;
     }
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($772 + -24 | 0, 12728) | 0;
     $775 = $db + 16 | 0;
     $777 = (HEAP32[$771 >> 2] | 0) + -24 | 0;
     HEAP32[$17 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($16, $777, $17);
     $780 = $db + 20 | 0;
     $781 = HEAP32[$780 >> 2] | 0;
     $783 = HEAP32[$db + 24 >> 2] | 0;
     if ($781 >>> 0 < $783 >>> 0) {
      HEAP32[$781 + 12 >> 2] = HEAP32[$16 + 12 >> 2];
      HEAP32[$781 >> 2] = HEAP32[$16 >> 2];
      $790 = $16 + 4 | 0;
      HEAP32[$781 + 4 >> 2] = HEAP32[$790 >> 2];
      $792 = $16 + 8 | 0;
      HEAP32[$781 + 8 >> 2] = HEAP32[$792 >> 2];
      HEAP32[$792 >> 2] = 0;
      HEAP32[$790 >> 2] = 0;
      HEAP32[$16 >> 2] = 0;
      HEAP32[$780 >> 2] = (HEAP32[$780 >> 2] | 0) + 16;
     } else {
      $800 = HEAP32[$775 >> 2] | 0;
      $801 = $781 - $800 | 0;
      $802 = $801 >> 4;
      $803 = $802 + 1 | 0;
      if (($801 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($775);
      $806 = $783 - $800 | 0;
      if ($806 >> 4 >>> 0 < 1073741823) {
       $809 = $806 >> 3;
       $$0$i$i$i71 = $809 >>> 0 < $803 >>> 0 ? $803 : $809;
      } else $$0$i$i$i71 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i71, $802, $db + 28 | 0);
      $812 = $__v$i$i$i + 8 | 0;
      $813 = HEAP32[$812 >> 2] | 0;
      HEAP32[$813 + 12 >> 2] = HEAP32[$16 + 12 >> 2];
      HEAP32[$813 >> 2] = HEAP32[$16 >> 2];
      $819 = $16 + 4 | 0;
      HEAP32[$813 + 4 >> 2] = HEAP32[$819 >> 2];
      $821 = $16 + 8 | 0;
      HEAP32[$813 + 8 >> 2] = HEAP32[$821 >> 2];
      HEAP32[$821 >> 2] = 0;
      HEAP32[$819 >> 2] = 0;
      HEAP32[$16 >> 2] = 0;
      HEAP32[$812 >> 2] = $813 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($775, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($16);
     $$0 = $768;
     break L1;
     break;
    }
   case 77:
    {
     if ($197 << 24 >> 24 == 77) {
      $826 = $first + 1 | 0;
      $827 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($826, $last, $db) | 0;
      if (($827 | 0) == ($826 | 0)) $$08$i = $first; else {
       $829 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($827, $last, $db) | 0;
       if (($829 | 0) == ($827 | 0)) $$08$i = $first; else {
        $831 = $db + 4 | 0;
        $832 = HEAP32[$831 >> 2] | 0;
        if ((($832 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$08$i = $first; else {
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($__v$i$i$i, $832 + -24 | 0);
         $840 = HEAP32[$831 >> 2] | 0;
         $841 = $840 + -24 | 0;
         $843 = $840;
         do {
          $842 = $843 + -24 | 0;
          HEAP32[$831 >> 2] = $842;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($842);
          $843 = HEAP32[$831 >> 2] | 0;
         } while (($843 | 0) != ($841 | 0));
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($0, $840 + -48 | 0);
         $846 = $__v$i$i$i + 12 | 0;
         $856 = HEAP32[$831 >> 2] | 0;
         $857 = $856 + -24 | 0;
         if ((HEAP8[((HEAP8[$846 >> 0] & 1) == 0 ? $846 + 1 | 0 : HEAP32[$__v$i$i$i + 20 >> 2] | 0) >> 0] | 0) == 40) {
          $858 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12714) | 0;
          HEAP32[$3 >> 2] = HEAP32[$858 >> 2];
          HEAP32[$3 + 4 >> 2] = HEAP32[$858 + 4 >> 2];
          HEAP32[$3 + 8 >> 2] = HEAP32[$858 + 8 >> 2];
          HEAP32[$858 >> 2] = 0;
          HEAP32[$858 + 4 >> 2] = 0;
          HEAP32[$858 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($4, $0);
          $861 = HEAP8[$4 >> 0] | 0;
          $863 = ($861 & 1) == 0;
          $873 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($3, $863 ? $4 + 1 | 0 : HEAP32[$4 + 8 >> 2] | 0, $863 ? ($861 & 255) >>> 1 : HEAP32[$4 + 4 >> 2] | 0) | 0;
          HEAP32[$2 >> 2] = HEAP32[$873 >> 2];
          HEAP32[$2 + 4 >> 2] = HEAP32[$873 + 4 >> 2];
          HEAP32[$2 + 8 >> 2] = HEAP32[$873 + 8 >> 2];
          HEAP32[$873 >> 2] = 0;
          HEAP32[$873 + 4 >> 2] = 0;
          HEAP32[$873 + 8 >> 2] = 0;
          $876 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12739) | 0;
          HEAP32[$1 >> 2] = HEAP32[$876 >> 2];
          HEAP32[$1 + 4 >> 2] = HEAP32[$876 + 4 >> 2];
          HEAP32[$1 + 8 >> 2] = HEAP32[$876 + 8 >> 2];
          HEAP32[$876 >> 2] = 0;
          HEAP32[$876 + 4 >> 2] = 0;
          HEAP32[$876 + 8 >> 2] = 0;
          do if (!(HEAP8[$857 >> 0] & 1)) {
           HEAP8[$857 + 1 >> 0] = 0;
           HEAP8[$857 >> 0] = 0;
          } else {
           $883 = $856 + -16 | 0;
           HEAP8[HEAP32[$883 >> 2] >> 0] = 0;
           $885 = $856 + -20 | 0;
           HEAP32[$885 >> 2] = 0;
           $$pre$i$i$i$i = HEAP8[$857 >> 0] | 0;
           if (!($$pre$i$i$i$i & 1)) {
            $892 = $$pre$i$i$i$i;
            $901 = 10;
           } else {
            $888 = HEAP32[$857 >> 2] | 0;
            $892 = $888 & 255;
            $901 = ($888 & -2) + -1 | 0;
           }
           if (!($892 & 1)) {
            $895 = ($892 & 255) >>> 1;
            if (($892 & 255) < 22) {
             $2569 = 1;
             $900 = 10;
             $920 = $895;
            } else {
             $2569 = 1;
             $900 = ($895 + 16 & 240) + -1 | 0;
             $920 = $895;
            }
           } else {
            $2569 = 0;
            $900 = 10;
            $920 = 0;
           }
           if (($900 | 0) != ($901 | 0)) {
            if (($900 | 0) == 10) {
             $907 = $857 + 1 | 0;
             $908 = HEAP32[$883 >> 2] | 0;
             if ($2569) {
              _memcpy($907 | 0, $908 | 0, (($892 & 255) >>> 1) + 1 | 0) | 0;
              _free($908);
             } else {
              HEAP8[$907 >> 0] = HEAP8[$908 >> 0] | 0;
              _free($908);
             }
             HEAP8[$857 >> 0] = $920 << 1;
             break;
            }
            $904 = $900 + 1 | 0;
            $905 = _malloc($904) | 0;
            if (!($900 >>> 0 <= $901 >>> 0 & ($905 | 0) == 0)) {
             if ($2569) _memcpy($905 | 0, $857 + 1 | 0, (($892 & 255) >>> 1) + 1 | 0) | 0; else {
              $917 = HEAP32[$883 >> 2] | 0;
              HEAP8[$905 >> 0] = HEAP8[$917 >> 0] | 0;
              _free($917);
             }
             HEAP32[$857 >> 2] = $904 | 1;
             HEAP32[$885 >> 2] = $920;
             HEAP32[$883 >> 2] = $905;
            }
           }
          } while (0);
          HEAP32[$857 >> 2] = HEAP32[$1 >> 2];
          HEAP32[$857 + 4 >> 2] = HEAP32[$1 + 4 >> 2];
          HEAP32[$857 + 8 >> 2] = HEAP32[$1 + 8 >> 2];
          HEAP32[$1 >> 2] = 0;
          HEAP32[$1 + 4 >> 2] = 0;
          HEAP32[$1 + 8 >> 2] = 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
          $925 = HEAP32[$831 >> 2] | 0;
          $926 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($846, 0, 12619) | 0;
          HEAP32[$5 >> 2] = HEAP32[$926 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$926 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$926 + 8 >> 2];
          HEAP32[$926 >> 2] = 0;
          HEAP32[$926 + 4 >> 2] = 0;
          HEAP32[$926 + 8 >> 2] = 0;
          $929 = $925 + -12 | 0;
          do if (!(HEAP8[$929 >> 0] & 1)) {
           HEAP8[$929 + 1 >> 0] = 0;
           HEAP8[$929 >> 0] = 0;
          } else {
           $934 = $925 + -4 | 0;
           HEAP8[HEAP32[$934 >> 2] >> 0] = 0;
           $936 = $925 + -8 | 0;
           HEAP32[$936 >> 2] = 0;
           $$pre$i$i$i21$i = HEAP8[$929 >> 0] | 0;
           if (!($$pre$i$i$i21$i & 1)) {
            $943 = $$pre$i$i$i21$i;
            $952 = 10;
           } else {
            $939 = HEAP32[$929 >> 2] | 0;
            $943 = $939 & 255;
            $952 = ($939 & -2) + -1 | 0;
           }
           if (!($943 & 1)) {
            $946 = ($943 & 255) >>> 1;
            if (($943 & 255) < 22) {
             $2570 = 1;
             $951 = 10;
             $971 = $946;
            } else {
             $2570 = 1;
             $951 = ($946 + 16 & 240) + -1 | 0;
             $971 = $946;
            }
           } else {
            $2570 = 0;
            $951 = 10;
            $971 = 0;
           }
           if (($951 | 0) != ($952 | 0)) {
            if (($951 | 0) == 10) {
             $958 = $929 + 1 | 0;
             $959 = HEAP32[$934 >> 2] | 0;
             if ($2570) {
              _memcpy($958 | 0, $959 | 0, (($943 & 255) >>> 1) + 1 | 0) | 0;
              _free($959);
             } else {
              HEAP8[$958 >> 0] = HEAP8[$959 >> 0] | 0;
              _free($959);
             }
             HEAP8[$929 >> 0] = $971 << 1;
             break;
            }
            $955 = $951 + 1 | 0;
            $956 = _malloc($955) | 0;
            if (!($951 >>> 0 <= $952 >>> 0 & ($956 | 0) == 0)) {
             if ($2570) _memcpy($956 | 0, $929 + 1 | 0, (($943 & 255) >>> 1) + 1 | 0) | 0; else {
              $968 = HEAP32[$934 >> 2] | 0;
              HEAP8[$956 >> 0] = HEAP8[$968 >> 0] | 0;
              _free($968);
             }
             HEAP32[$929 >> 2] = $955 | 1;
             HEAP32[$936 >> 2] = $971;
             HEAP32[$934 >> 2] = $956;
            }
           }
          } while (0);
          HEAP32[$929 >> 2] = HEAP32[$5 >> 2];
          HEAP32[$929 + 4 >> 2] = HEAP32[$5 + 4 >> 2];
          HEAP32[$929 + 8 >> 2] = HEAP32[$5 + 8 >> 2];
          HEAP32[$5 >> 2] = 0;
          HEAP32[$5 + 4 >> 2] = 0;
          HEAP32[$5 + 8 >> 2] = 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
         } else {
          $976 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($__v$i$i$i, 12726) | 0;
          HEAP32[$7 >> 2] = HEAP32[$976 >> 2];
          HEAP32[$7 + 4 >> 2] = HEAP32[$976 + 4 >> 2];
          HEAP32[$7 + 8 >> 2] = HEAP32[$976 + 8 >> 2];
          HEAP32[$976 >> 2] = 0;
          HEAP32[$976 + 4 >> 2] = 0;
          HEAP32[$976 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($8, $0);
          $979 = HEAP8[$8 >> 0] | 0;
          $981 = ($979 & 1) == 0;
          $991 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($7, $981 ? $8 + 1 | 0 : HEAP32[$8 + 8 >> 2] | 0, $981 ? ($979 & 255) >>> 1 : HEAP32[$8 + 4 >> 2] | 0) | 0;
          HEAP32[$num1$i >> 2] = HEAP32[$991 >> 2];
          HEAP32[$num1$i + 4 >> 2] = HEAP32[$991 + 4 >> 2];
          HEAP32[$num1$i + 8 >> 2] = HEAP32[$991 + 8 >> 2];
          HEAP32[$991 >> 2] = 0;
          HEAP32[$991 + 4 >> 2] = 0;
          HEAP32[$991 + 8 >> 2] = 0;
          $994 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($num1$i, 12739) | 0;
          HEAP32[$6 >> 2] = HEAP32[$994 >> 2];
          HEAP32[$6 + 4 >> 2] = HEAP32[$994 + 4 >> 2];
          HEAP32[$6 + 8 >> 2] = HEAP32[$994 + 8 >> 2];
          HEAP32[$994 >> 2] = 0;
          HEAP32[$994 + 4 >> 2] = 0;
          HEAP32[$994 + 8 >> 2] = 0;
          do if (!(HEAP8[$857 >> 0] & 1)) {
           HEAP8[$857 + 1 >> 0] = 0;
           HEAP8[$857 >> 0] = 0;
          } else {
           $1001 = $856 + -16 | 0;
           HEAP8[HEAP32[$1001 >> 2] >> 0] = 0;
           $1003 = $856 + -20 | 0;
           HEAP32[$1003 >> 2] = 0;
           $$pre$i$i$i52$i = HEAP8[$857 >> 0] | 0;
           if (!($$pre$i$i$i52$i & 1)) {
            $1010 = $$pre$i$i$i52$i;
            $1019 = 10;
           } else {
            $1006 = HEAP32[$857 >> 2] | 0;
            $1010 = $1006 & 255;
            $1019 = ($1006 & -2) + -1 | 0;
           }
           if (!($1010 & 1)) {
            $1013 = ($1010 & 255) >>> 1;
            if (($1010 & 255) < 22) {
             $1018 = 10;
             $1038 = $1013;
             $2571 = 1;
            } else {
             $1018 = ($1013 + 16 & 240) + -1 | 0;
             $1038 = $1013;
             $2571 = 1;
            }
           } else {
            $1018 = 10;
            $1038 = 0;
            $2571 = 0;
           }
           if (($1018 | 0) != ($1019 | 0)) {
            if (($1018 | 0) == 10) {
             $1025 = $857 + 1 | 0;
             $1026 = HEAP32[$1001 >> 2] | 0;
             if ($2571) {
              _memcpy($1025 | 0, $1026 | 0, (($1010 & 255) >>> 1) + 1 | 0) | 0;
              _free($1026);
             } else {
              HEAP8[$1025 >> 0] = HEAP8[$1026 >> 0] | 0;
              _free($1026);
             }
             HEAP8[$857 >> 0] = $1038 << 1;
             break;
            }
            $1022 = $1018 + 1 | 0;
            $1023 = _malloc($1022) | 0;
            if (!($1018 >>> 0 <= $1019 >>> 0 & ($1023 | 0) == 0)) {
             if ($2571) _memcpy($1023 | 0, $857 + 1 | 0, (($1010 & 255) >>> 1) + 1 | 0) | 0; else {
              $1035 = HEAP32[$1001 >> 2] | 0;
              HEAP8[$1023 >> 0] = HEAP8[$1035 >> 0] | 0;
              _free($1035);
             }
             HEAP32[$857 >> 2] = $1022 | 1;
             HEAP32[$1003 >> 2] = $1038;
             HEAP32[$1001 >> 2] = $1023;
            }
           }
          } while (0);
          HEAP32[$857 >> 2] = HEAP32[$6 >> 2];
          HEAP32[$857 + 4 >> 2] = HEAP32[$6 + 4 >> 2];
          HEAP32[$857 + 8 >> 2] = HEAP32[$6 + 8 >> 2];
          HEAP32[$6 >> 2] = 0;
          HEAP32[$6 + 4 >> 2] = 0;
          HEAP32[$6 + 8 >> 2] = 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($num1$i);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($8);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
          $1043 = HEAP32[$831 >> 2] | 0;
          $1044 = $1043 + -12 | 0;
          do if (!(HEAP8[$1044 >> 0] & 1)) {
           HEAP8[$1044 + 1 >> 0] = 0;
           HEAP8[$1044 >> 0] = 0;
          } else {
           $1049 = $1043 + -4 | 0;
           HEAP8[HEAP32[$1049 >> 2] >> 0] = 0;
           $1051 = $1043 + -8 | 0;
           HEAP32[$1051 >> 2] = 0;
           $$pre$i$i$i71$i = HEAP8[$1044 >> 0] | 0;
           if (!($$pre$i$i$i71$i & 1)) {
            $1058 = $$pre$i$i$i71$i;
            $1067 = 10;
           } else {
            $1054 = HEAP32[$1044 >> 2] | 0;
            $1058 = $1054 & 255;
            $1067 = ($1054 & -2) + -1 | 0;
           }
           if (!($1058 & 1)) {
            $1061 = ($1058 & 255) >>> 1;
            if (($1058 & 255) < 22) {
             $1066 = 10;
             $1086 = $1061;
             $2572 = 1;
            } else {
             $1066 = ($1061 + 16 & 240) + -1 | 0;
             $1086 = $1061;
             $2572 = 1;
            }
           } else {
            $1066 = 10;
            $1086 = 0;
            $2572 = 0;
           }
           if (($1066 | 0) != ($1067 | 0)) {
            if (($1066 | 0) == 10) {
             $1073 = $1044 + 1 | 0;
             $1074 = HEAP32[$1049 >> 2] | 0;
             if ($2572) {
              _memcpy($1073 | 0, $1074 | 0, (($1058 & 255) >>> 1) + 1 | 0) | 0;
              _free($1074);
             } else {
              HEAP8[$1073 >> 0] = HEAP8[$1074 >> 0] | 0;
              _free($1074);
             }
             HEAP8[$1044 >> 0] = $1086 << 1;
             break;
            }
            $1070 = $1066 + 1 | 0;
            $1071 = _malloc($1070) | 0;
            if (!($1066 >>> 0 <= $1067 >>> 0 & ($1071 | 0) == 0)) {
             if ($2572) _memcpy($1071 | 0, $1044 + 1 | 0, (($1058 & 255) >>> 1) + 1 | 0) | 0; else {
              $1083 = HEAP32[$1049 >> 2] | 0;
              HEAP8[$1071 >> 0] = HEAP8[$1083 >> 0] | 0;
              _free($1083);
             }
             HEAP32[$1044 >> 2] = $1070 | 1;
             HEAP32[$1051 >> 2] = $1086;
             HEAP32[$1049 >> 2] = $1071;
            }
           }
          } while (0);
          HEAP32[$1044 >> 2] = HEAP32[$846 >> 2];
          HEAP32[$1044 + 4 >> 2] = HEAP32[$846 + 4 >> 2];
          HEAP32[$1044 + 8 >> 2] = HEAP32[$846 + 8 >> 2];
          HEAP32[$846 >> 2] = 0;
          HEAP32[$846 + 4 >> 2] = 0;
          HEAP32[$846 + 8 >> 2] = 0;
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($__v$i$i$i);
         $$08$i = $829;
        }
       }
      }
     } else $$08$i = $first;
     if (($$08$i | 0) == ($first | 0)) {
      $$0 = $first;
      break L1;
     }
     $1094 = HEAP32[$db + 4 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($1094 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1096 = $db + 16 | 0;
     HEAP32[$19 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($18, $1094 + -24 | 0, $19);
     $1100 = $db + 20 | 0;
     $1101 = HEAP32[$1100 >> 2] | 0;
     $1103 = HEAP32[$db + 24 >> 2] | 0;
     if ($1101 >>> 0 < $1103 >>> 0) {
      HEAP32[$1101 + 12 >> 2] = HEAP32[$18 + 12 >> 2];
      HEAP32[$1101 >> 2] = HEAP32[$18 >> 2];
      $1110 = $18 + 4 | 0;
      HEAP32[$1101 + 4 >> 2] = HEAP32[$1110 >> 2];
      $1112 = $18 + 8 | 0;
      HEAP32[$1101 + 8 >> 2] = HEAP32[$1112 >> 2];
      HEAP32[$1112 >> 2] = 0;
      HEAP32[$1110 >> 2] = 0;
      HEAP32[$18 >> 2] = 0;
      HEAP32[$1100 >> 2] = (HEAP32[$1100 >> 2] | 0) + 16;
     } else {
      $1120 = HEAP32[$1096 >> 2] | 0;
      $1121 = $1101 - $1120 | 0;
      $1122 = $1121 >> 4;
      $1123 = $1122 + 1 | 0;
      if (($1121 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1096);
      $1126 = $1103 - $1120 | 0;
      if ($1126 >> 4 >>> 0 < 1073741823) {
       $1129 = $1126 >> 3;
       $$0$i$i$i76 = $1129 >>> 0 < $1123 >>> 0 ? $1123 : $1129;
      } else $$0$i$i$i76 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i76, $1122, $db + 28 | 0);
      $1132 = $__v$i$i$i + 8 | 0;
      $1133 = HEAP32[$1132 >> 2] | 0;
      HEAP32[$1133 + 12 >> 2] = HEAP32[$18 + 12 >> 2];
      HEAP32[$1133 >> 2] = HEAP32[$18 >> 2];
      $1139 = $18 + 4 | 0;
      HEAP32[$1133 + 4 >> 2] = HEAP32[$1139 >> 2];
      $1141 = $18 + 8 | 0;
      HEAP32[$1133 + 8 >> 2] = HEAP32[$1141 >> 2];
      HEAP32[$1141 >> 2] = 0;
      HEAP32[$1139 >> 2] = 0;
      HEAP32[$18 >> 2] = 0;
      HEAP32[$1132 >> 2] = $1133 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1096, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($18);
     $$0 = $$08$i;
     break L1;
     break;
    }
   case 79:
    {
     $1145 = $db + 4 | 0;
     $1151 = ((HEAP32[$1145 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     $1152 = $first + 1 | 0;
     $1153 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1152, $last, $db) | 0;
     $1159 = ((HEAP32[$1145 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     if (($1153 | 0) == ($1152 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1161 = $db + 16 | 0;
     $1164 = HEAP32[$db + 12 >> 2] | 0;
     $1165 = $db + 20 | 0;
     $1166 = HEAP32[$1165 >> 2] | 0;
     $1168 = HEAP32[$db + 24 >> 2] | 0;
     if ($1166 >>> 0 < $1168 >>> 0) {
      HEAP32[$1166 >> 2] = 0;
      HEAP32[$1166 + 4 >> 2] = 0;
      HEAP32[$1166 + 8 >> 2] = 0;
      HEAP32[$1166 + 12 >> 2] = $1164;
      HEAP32[$1165 >> 2] = (HEAP32[$1165 >> 2] | 0) + 16;
     } else {
      $1178 = HEAP32[$1161 >> 2] | 0;
      $1179 = $1166 - $1178 | 0;
      $1180 = $1179 >> 4;
      $1181 = $1180 + 1 | 0;
      if (($1179 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1161);
      $1184 = $1168 - $1178 | 0;
      if ($1184 >> 4 >>> 0 < 1073741823) {
       $1187 = $1184 >> 3;
       $$0$i$i$i81 = $1187 >>> 0 < $1181 >>> 0 ? $1181 : $1187;
      } else $$0$i$i$i81 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i81, $1180, $db + 28 | 0);
      $1190 = $__v$i$i$i + 8 | 0;
      $1191 = HEAP32[$1190 >> 2] | 0;
      HEAP32[$1191 >> 2] = 0;
      HEAP32[$1191 + 4 >> 2] = 0;
      HEAP32[$1191 + 8 >> 2] = 0;
      HEAP32[$1191 + 12 >> 2] = $1164;
      HEAP32[$1190 >> 2] = $1191 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1161, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     $1196 = $20 + 4 | 0;
     $1197 = $20 + 8 | 0;
     $1198 = $20 + 1 | 0;
     $1199 = $__v$i$i$i + 8 | 0;
     if ($1151 >>> 0 < $1159 >>> 0) $k5$0533 = $1151; else {
      $$0 = $1153;
      break L1;
     }
     while (1) {
      $1201 = HEAP32[$db >> 2] | 0;
      $1202 = $1201 + ($k5$0533 * 24 | 0) + 12 | 0;
      $1203 = HEAP8[$1202 >> 0] | 0;
      $1205 = ($1203 & 1) == 0;
      $1210 = $1205 ? ($1203 & 255) >>> 1 : HEAP32[$1201 + ($k5$0533 * 24 | 0) + 16 >> 2] | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($20, $1205 ? $1202 + 1 | 0 : HEAP32[$1201 + ($k5$0533 * 24 | 0) + 20 >> 2] | 0, $1210 >>> 0 < 2 ? $1210 : 2);
      $1217 = HEAP8[$20 >> 0] | 0;
      $1219 = ($1217 & 1) == 0;
      $1223 = $1219 ? ($1217 & 255) >>> 1 : HEAP32[$1196 >> 2] | 0;
      $1226 = $1223 >>> 0 > 2;
      $1228 = _memcmp($1219 ? $1198 : HEAP32[$1197 >> 2] | 0, 12696, $1226 ? 2 : $1223) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($20);
      $1233 = HEAP32[$db >> 2] | 0;
      if (!((($1228 | 0) == 0 ? ($1223 >>> 0 < 2 ? -1 : $1226 & 1) : $1228) | 0)) {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1233 + ($k5$0533 * 24 | 0) | 0, 12616) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k5$0533 * 24 | 0) + 12 | 0, 0, 12619) | 0;
      } else {
       $1237 = $1233 + ($k5$0533 * 24 | 0) + 12 | 0;
       if (!(HEAP8[$1237 >> 0] & 1)) $1245 = $1237 + 1 | 0; else $1245 = HEAP32[$1233 + ($k5$0533 * 24 | 0) + 20 >> 2] | 0;
       if ((HEAP8[$1245 >> 0] | 0) == 40) {
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1233 + ($k5$0533 * 24 | 0) | 0, 12714) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k5$0533 * 24 | 0) + 12 | 0, 0, 12619) | 0;
       }
      }
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$db >> 2] | 0) + ($k5$0533 * 24 | 0) | 0, 12743) | 0;
      $1252 = HEAP32[$1165 >> 2] | 0;
      $1253 = $1252 + -16 | 0;
      $1254 = HEAP32[$db >> 2] | 0;
      $1255 = $1254 + ($k5$0533 * 24 | 0) | 0;
      $1256 = $1252 + -12 | 0;
      $1257 = HEAP32[$1256 >> 2] | 0;
      if (($1257 | 0) == (HEAP32[$1252 + -8 >> 2] | 0)) {
       $1269 = $1257 - (HEAP32[$1253 >> 2] | 0) | 0;
       $1270 = ($1269 | 0) / 24 | 0;
       $1271 = $1270 + 1 | 0;
       if (($1269 | 0) < -24) {
        $$lcssa667 = $1253;
        break;
       }
       if ($1270 >>> 0 < 1073741823) {
        $1274 = $1270 << 1;
        $$0$i$i$i87 = $1274 >>> 0 < $1271 >>> 0 ? $1271 : $1274;
       } else $$0$i$i$i87 = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i87, $1270, $1252 + -4 | 0);
       $1277 = HEAP32[$1199 >> 2] | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1277, $1255);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1277 + 12 | 0, $1254 + ($k5$0533 * 24 | 0) + 12 | 0);
       HEAP32[$1199 >> 2] = $1277 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($1253, $__v$i$i$i);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
      } else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1257, $1255);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1257 + 12 | 0, $1254 + ($k5$0533 * 24 | 0) + 12 | 0);
       HEAP32[$1256 >> 2] = (HEAP32[$1256 >> 2] | 0) + 24;
      }
      $k5$0533 = $k5$0533 + 1 | 0;
      if ($k5$0533 >>> 0 >= $1159 >>> 0) {
       $$0 = $1153;
       break L1;
      }
     }
     __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa667);
     break;
    }
   case 80:
    {
     $1283 = $db + 4 | 0;
     $1289 = ((HEAP32[$1283 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     $1290 = $first + 1 | 0;
     $1291 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1290, $last, $db) | 0;
     $1297 = ((HEAP32[$1283 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     if (($1291 | 0) == ($1290 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1299 = $db + 16 | 0;
     $1302 = HEAP32[$db + 12 >> 2] | 0;
     $1303 = $db + 20 | 0;
     $1304 = HEAP32[$1303 >> 2] | 0;
     $1306 = HEAP32[$db + 24 >> 2] | 0;
     if ($1304 >>> 0 < $1306 >>> 0) {
      HEAP32[$1304 >> 2] = 0;
      HEAP32[$1304 + 4 >> 2] = 0;
      HEAP32[$1304 + 8 >> 2] = 0;
      HEAP32[$1304 + 12 >> 2] = $1302;
      HEAP32[$1303 >> 2] = (HEAP32[$1303 >> 2] | 0) + 16;
     } else {
      $1316 = HEAP32[$1299 >> 2] | 0;
      $1317 = $1304 - $1316 | 0;
      $1318 = $1317 >> 4;
      $1319 = $1318 + 1 | 0;
      if (($1317 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1299);
      $1322 = $1306 - $1316 | 0;
      if ($1322 >> 4 >>> 0 < 1073741823) {
       $1325 = $1322 >> 3;
       $$0$i$i$i95 = $1325 >>> 0 < $1319 >>> 0 ? $1319 : $1325;
      } else $$0$i$i$i95 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i95, $1318, $db + 28 | 0);
      $1328 = $__v$i$i$i + 8 | 0;
      $1329 = HEAP32[$1328 >> 2] | 0;
      HEAP32[$1329 >> 2] = 0;
      HEAP32[$1329 + 4 >> 2] = 0;
      HEAP32[$1329 + 8 >> 2] = 0;
      HEAP32[$1329 + 12 >> 2] = $1302;
      HEAP32[$1328 >> 2] = $1329 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1299, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     $1334 = $21 + 4 | 0;
     $1335 = $21 + 8 | 0;
     $1336 = $21 + 1 | 0;
     $1337 = $22 + 4 | 0;
     $1338 = $22 + 8 | 0;
     $1339 = $22 + 1 | 0;
     $1340 = $__v$i$i$i + 8 | 0;
     if ($1289 >>> 0 < $1297 >>> 0) $k8$0536 = $1289; else {
      $$0 = $1291;
      break L1;
     }
     while (1) {
      $1342 = HEAP32[$db >> 2] | 0;
      $1343 = $1342 + ($k8$0536 * 24 | 0) + 12 | 0;
      $1344 = HEAP8[$1343 >> 0] | 0;
      $1346 = ($1344 & 1) == 0;
      $1351 = $1346 ? ($1344 & 255) >>> 1 : HEAP32[$1342 + ($k8$0536 * 24 | 0) + 16 >> 2] | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($21, $1346 ? $1343 + 1 | 0 : HEAP32[$1342 + ($k8$0536 * 24 | 0) + 20 >> 2] | 0, $1351 >>> 0 < 2 ? $1351 : 2);
      $1358 = HEAP8[$21 >> 0] | 0;
      $1360 = ($1358 & 1) == 0;
      $1364 = $1360 ? ($1358 & 255) >>> 1 : HEAP32[$1334 >> 2] | 0;
      $1367 = $1364 >>> 0 > 2;
      $1369 = _memcmp($1360 ? $1336 : HEAP32[$1335 >> 2] | 0, 12696, $1367 ? 2 : $1364) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($21);
      $1374 = HEAP32[$db >> 2] | 0;
      if (!((($1369 | 0) == 0 ? ($1364 >>> 0 < 2 ? -1 : $1367 & 1) : $1369) | 0)) {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1374 + ($k8$0536 * 24 | 0) | 0, 12616) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k8$0536 * 24 | 0) + 12 | 0, 0, 12619) | 0;
      } else {
       $1378 = $1374 + ($k8$0536 * 24 | 0) + 12 | 0;
       if (!(HEAP8[$1378 >> 0] & 1)) $1386 = $1378 + 1 | 0; else $1386 = HEAP32[$1374 + ($k8$0536 * 24 | 0) + 20 >> 2] | 0;
       if ((HEAP8[$1386 >> 0] | 0) == 40) {
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1374 + ($k8$0536 * 24 | 0) | 0, 12714) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k8$0536 * 24 | 0) + 12 | 0, 0, 12619) | 0;
       }
      }
      $1393 = HEAP32[$db >> 2] | 0;
      $1394 = $1393 + ($k8$0536 * 24 | 0) | 0;
      do if ((HEAP8[$1290 >> 0] | 0) == 85) {
       $1395 = HEAP8[$1394 >> 0] | 0;
       $1397 = ($1395 & 1) == 0;
       $1402 = $1397 ? ($1395 & 255) >>> 1 : HEAP32[$1393 + ($k8$0536 * 24 | 0) + 4 >> 2] | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($22, $1397 ? $1394 + 1 | 0 : HEAP32[$1393 + ($k8$0536 * 24 | 0) + 8 >> 2] | 0, $1402 >>> 0 < 12 ? $1402 : 12);
       $1409 = HEAP8[$22 >> 0] | 0;
       $1411 = ($1409 & 1) == 0;
       $1415 = $1411 ? ($1409 & 255) >>> 1 : HEAP32[$1337 >> 2] | 0;
       $1418 = $1415 >>> 0 > 12;
       $1420 = _memcmp($1411 ? $1339 : HEAP32[$1338 >> 2] | 0, 12746, $1418 ? 12 : $1415) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($22);
       $1425 = HEAP32[$db >> 2] | 0;
       $1426 = $1425 + ($k8$0536 * 24 | 0) | 0;
       if (!((($1420 | 0) == 0 ? ($1415 >>> 0 < 12 ? -1 : $1418 & 1) : $1420) | 0)) {
        $1428 = HEAP8[$1426 >> 0] | 0;
        if (!($1428 & 1)) {
         $1432 = ($1428 & 255) >>> 1;
         $1443 = $1432 >>> 0 < 11 ? $1432 : 11;
         $1444 = $1432;
         $1446 = 10;
         $1449 = $1428;
        } else {
         $1436 = HEAP32[$1425 + ($k8$0536 * 24 | 0) + 4 >> 2] | 0;
         $1439 = HEAP32[$1426 >> 2] | 0;
         $1443 = $1436 >>> 0 < 11 ? $1436 : 11;
         $1444 = $1436;
         $1446 = ($1439 & -2) + -1 | 0;
         $1449 = $1439 & 255;
        }
        if (($1443 - $1444 + $1446 | 0) >>> 0 < 2) {
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE21__grow_by_and_replaceEjjjjjjPKc($1426, $1446, 2 - $1443 + $1444 - $1446 | 0, $1444, 0, $1443, 2, 12761);
         break;
        }
        if (!($1449 & 1)) $1458 = $1426 + 1 | 0; else $1458 = HEAP32[$1425 + ($k8$0536 * 24 | 0) + 8 >> 2] | 0;
        do if (($1443 | 0) == 2) {
         $$1$i$i = 0;
         $$12$i$i = 12761;
         $$14$i$i = 2;
         $2573 = 2;
         label = 339;
        } else {
         $1455 = $1444 - $1443 | 0;
         if (($1444 | 0) == ($1443 | 0)) {
          $$1$i$i = 0;
          $$12$i$i = 12761;
          $$14$i$i = 2;
          $2573 = $1443;
          label = 339;
         } else {
          if ($1443 >>> 0 > 2) {
           HEAP8[$1458 >> 0] = 105;
           HEAP8[$1458 + 1 >> 0] = 100;
           _memmove($1458 + 2 | 0, $1458 + $1443 | 0, $1455 | 0) | 0;
           $$2$i$i = 2;
           $1474 = $1443;
           break;
          }
          do if ($1458 >>> 0 < 12761 >>> 0 & ($1458 + $1444 | 0) >>> 0 > 12761 >>> 0) if (($1458 + $1443 | 0) >>> 0 > 12761 >>> 0) {
           _memcpy($1458 | 0, 12761, $1443 | 0) | 0;
           $$0$i$i = $1443;
           $$01$i$i = 12763;
           $$03$i$i = 2 - $1443 | 0;
           $1470 = 0;
           break;
          } else {
           $$0$i$i = 0;
           $$01$i$i = 12761 + (2 - $1443) | 0;
           $$03$i$i = 2;
           $1470 = $1443;
           break;
          } else {
           $$0$i$i = 0;
           $$01$i$i = 12761;
           $$03$i$i = 2;
           $1470 = $1443;
          } while (0);
          _memmove($1458 + ($$0$i$i + $$03$i$i) | 0, $1458 + ($$0$i$i + $1470) | 0, $1455 | 0) | 0;
          $$1$i$i = $$0$i$i;
          $$12$i$i = $$01$i$i;
          $$14$i$i = $$03$i$i;
          $2573 = $1470;
          label = 339;
         }
        } while (0);
        if ((label | 0) == 339) {
         label = 0;
         _memmove($1458 + $$1$i$i | 0, $$12$i$i | 0, $$14$i$i | 0) | 0;
         $$2$i$i = $$14$i$i;
         $1474 = $2573;
        }
        $1475 = $$2$i$i - $1474 + $1444 | 0;
        if (!(HEAP8[$1426 >> 0] & 1)) HEAP8[$1426 >> 0] = $1475 << 1; else HEAP32[$1425 + ($k8$0536 * 24 | 0) + 4 >> 2] = $1475;
        HEAP8[$1458 + $1475 >> 0] = 0;
       } else {
        $1427 = $1426;
        label = 322;
       }
      } else {
       $1427 = $1394;
       label = 322;
      } while (0);
      if ((label | 0) == 322) {
       label = 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1427, 12759) | 0;
      }
      $1486 = HEAP32[$1303 >> 2] | 0;
      $1487 = $1486 + -16 | 0;
      $1488 = HEAP32[$db >> 2] | 0;
      $1489 = $1488 + ($k8$0536 * 24 | 0) | 0;
      $1490 = $1486 + -12 | 0;
      $1491 = HEAP32[$1490 >> 2] | 0;
      if (($1491 | 0) == (HEAP32[$1486 + -8 >> 2] | 0)) {
       $1503 = $1491 - (HEAP32[$1487 >> 2] | 0) | 0;
       $1504 = ($1503 | 0) / 24 | 0;
       $1505 = $1504 + 1 | 0;
       if (($1503 | 0) < -24) {
        $$lcssa674 = $1487;
        break;
       }
       if ($1504 >>> 0 < 1073741823) {
        $1508 = $1504 << 1;
        $$0$i$i$i105 = $1508 >>> 0 < $1505 >>> 0 ? $1505 : $1508;
       } else $$0$i$i$i105 = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i105, $1504, $1486 + -4 | 0);
       $1511 = HEAP32[$1340 >> 2] | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1511, $1489);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1511 + 12 | 0, $1488 + ($k8$0536 * 24 | 0) + 12 | 0);
       HEAP32[$1340 >> 2] = $1511 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($1487, $__v$i$i$i);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
      } else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1491, $1489);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1491 + 12 | 0, $1488 + ($k8$0536 * 24 | 0) + 12 | 0);
       HEAP32[$1490 >> 2] = (HEAP32[$1490 >> 2] | 0) + 24;
      }
      $k8$0536 = $k8$0536 + 1 | 0;
      if ($k8$0536 >>> 0 >= $1297 >>> 0) {
       $$0 = $1291;
       break L1;
      }
     }
     __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa674);
     break;
    }
   case 82:
    {
     $1517 = $db + 4 | 0;
     $1523 = ((HEAP32[$1517 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     $1524 = $first + 1 | 0;
     $1525 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1524, $last, $db) | 0;
     $1531 = ((HEAP32[$1517 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     if (($1525 | 0) == ($1524 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1533 = $db + 16 | 0;
     $1536 = HEAP32[$db + 12 >> 2] | 0;
     $1537 = $db + 20 | 0;
     $1538 = HEAP32[$1537 >> 2] | 0;
     $1540 = HEAP32[$db + 24 >> 2] | 0;
     if ($1538 >>> 0 < $1540 >>> 0) {
      HEAP32[$1538 >> 2] = 0;
      HEAP32[$1538 + 4 >> 2] = 0;
      HEAP32[$1538 + 8 >> 2] = 0;
      HEAP32[$1538 + 12 >> 2] = $1536;
      HEAP32[$1537 >> 2] = (HEAP32[$1537 >> 2] | 0) + 16;
     } else {
      $1550 = HEAP32[$1533 >> 2] | 0;
      $1551 = $1538 - $1550 | 0;
      $1552 = $1551 >> 4;
      $1553 = $1552 + 1 | 0;
      if (($1551 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1533);
      $1556 = $1540 - $1550 | 0;
      if ($1556 >> 4 >>> 0 < 1073741823) {
       $1559 = $1556 >> 3;
       $$0$i$i$i113 = $1559 >>> 0 < $1553 >>> 0 ? $1553 : $1559;
      } else $$0$i$i$i113 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i113, $1552, $db + 28 | 0);
      $1562 = $__v$i$i$i + 8 | 0;
      $1563 = HEAP32[$1562 >> 2] | 0;
      HEAP32[$1563 >> 2] = 0;
      HEAP32[$1563 + 4 >> 2] = 0;
      HEAP32[$1563 + 8 >> 2] = 0;
      HEAP32[$1563 + 12 >> 2] = $1536;
      HEAP32[$1562 >> 2] = $1563 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1533, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     $1568 = $23 + 4 | 0;
     $1569 = $23 + 8 | 0;
     $1570 = $23 + 1 | 0;
     $1571 = $__v$i$i$i + 8 | 0;
     if ($1523 >>> 0 < $1531 >>> 0) $k11$0540 = $1523; else {
      $$0 = $1525;
      break L1;
     }
     while (1) {
      $1573 = HEAP32[$db >> 2] | 0;
      $1574 = $1573 + ($k11$0540 * 24 | 0) + 12 | 0;
      $1575 = HEAP8[$1574 >> 0] | 0;
      $1577 = ($1575 & 1) == 0;
      $1582 = $1577 ? ($1575 & 255) >>> 1 : HEAP32[$1573 + ($k11$0540 * 24 | 0) + 16 >> 2] | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($23, $1577 ? $1574 + 1 | 0 : HEAP32[$1573 + ($k11$0540 * 24 | 0) + 20 >> 2] | 0, $1582 >>> 0 < 2 ? $1582 : 2);
      $1589 = HEAP8[$23 >> 0] | 0;
      $1591 = ($1589 & 1) == 0;
      $1595 = $1591 ? ($1589 & 255) >>> 1 : HEAP32[$1568 >> 2] | 0;
      $1598 = $1595 >>> 0 > 2;
      $1600 = _memcmp($1591 ? $1570 : HEAP32[$1569 >> 2] | 0, 12696, $1598 ? 2 : $1595) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($23);
      $1605 = HEAP32[$db >> 2] | 0;
      if (!((($1600 | 0) == 0 ? ($1595 >>> 0 < 2 ? -1 : $1598 & 1) : $1600) | 0)) {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1605 + ($k11$0540 * 24 | 0) | 0, 12616) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k11$0540 * 24 | 0) + 12 | 0, 0, 12619) | 0;
      } else {
       $1609 = $1605 + ($k11$0540 * 24 | 0) + 12 | 0;
       if (!(HEAP8[$1609 >> 0] & 1)) $1617 = $1609 + 1 | 0; else $1617 = HEAP32[$1605 + ($k11$0540 * 24 | 0) + 20 >> 2] | 0;
       if ((HEAP8[$1617 >> 0] | 0) == 40) {
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1605 + ($k11$0540 * 24 | 0) | 0, 12714) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc((HEAP32[$db >> 2] | 0) + ($k11$0540 * 24 | 0) + 12 | 0, 0, 12619) | 0;
       }
      }
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$db >> 2] | 0) + ($k11$0540 * 24 | 0) | 0, 12764) | 0;
      $1624 = HEAP32[$1537 >> 2] | 0;
      $1625 = $1624 + -16 | 0;
      $1626 = HEAP32[$db >> 2] | 0;
      $1627 = $1626 + ($k11$0540 * 24 | 0) | 0;
      $1628 = $1624 + -12 | 0;
      $1629 = HEAP32[$1628 >> 2] | 0;
      if (($1629 | 0) == (HEAP32[$1624 + -8 >> 2] | 0)) {
       $1641 = $1629 - (HEAP32[$1625 >> 2] | 0) | 0;
       $1642 = ($1641 | 0) / 24 | 0;
       $1643 = $1642 + 1 | 0;
       if (($1641 | 0) < -24) {
        $$lcssa682 = $1625;
        break;
       }
       if ($1642 >>> 0 < 1073741823) {
        $1646 = $1642 << 1;
        $$0$i$i$i123 = $1646 >>> 0 < $1643 >>> 0 ? $1643 : $1646;
       } else $$0$i$i$i123 = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i123, $1642, $1624 + -4 | 0);
       $1649 = HEAP32[$1571 >> 2] | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1649, $1627);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1649 + 12 | 0, $1626 + ($k11$0540 * 24 | 0) + 12 | 0);
       HEAP32[$1571 >> 2] = $1649 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($1625, $__v$i$i$i);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
      } else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1629, $1627);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1629 + 12 | 0, $1626 + ($k11$0540 * 24 | 0) + 12 | 0);
       HEAP32[$1628 >> 2] = (HEAP32[$1628 >> 2] | 0) + 24;
      }
      $k11$0540 = $k11$0540 + 1 | 0;
      if ($k11$0540 >>> 0 >= $1531 >>> 0) {
       $$0 = $1525;
       break L1;
      }
     }
     __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa682);
     break;
    }
   case 84:
    {
     $1655 = $db + 4 | 0;
     $1661 = ((HEAP32[$1655 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     $1662 = __ZN10__cxxabiv112_GLOBAL__N_120parse_template_paramINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
     $1668 = ((HEAP32[$1655 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
     if (($1662 | 0) == ($first | 0)) {
      $$0 = $first;
      break L1;
     }
     $1670 = $db + 16 | 0;
     $1671 = $db + 12 | 0;
     $1673 = HEAP32[$1671 >> 2] | 0;
     $1674 = $db + 20 | 0;
     $1675 = HEAP32[$1674 >> 2] | 0;
     $1676 = $db + 24 | 0;
     $1677 = HEAP32[$1676 >> 2] | 0;
     if ($1675 >>> 0 < $1677 >>> 0) {
      HEAP32[$1675 >> 2] = 0;
      HEAP32[$1675 + 4 >> 2] = 0;
      HEAP32[$1675 + 8 >> 2] = 0;
      HEAP32[$1675 + 12 >> 2] = $1673;
      HEAP32[$1674 >> 2] = (HEAP32[$1674 >> 2] | 0) + 16;
     } else {
      $1687 = HEAP32[$1670 >> 2] | 0;
      $1688 = $1675 - $1687 | 0;
      $1689 = $1688 >> 4;
      $1690 = $1689 + 1 | 0;
      if (($1688 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1670);
      $1693 = $1677 - $1687 | 0;
      if ($1693 >> 4 >>> 0 < 1073741823) {
       $1696 = $1693 >> 3;
       $$0$i$i$i131 = $1696 >>> 0 < $1690 >>> 0 ? $1690 : $1696;
      } else $$0$i$i$i131 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i131, $1689, $db + 28 | 0);
      $1699 = $__v$i$i$i + 8 | 0;
      $1700 = HEAP32[$1699 >> 2] | 0;
      HEAP32[$1700 >> 2] = 0;
      HEAP32[$1700 + 4 >> 2] = 0;
      HEAP32[$1700 + 8 >> 2] = 0;
      HEAP32[$1700 + 12 >> 2] = $1673;
      HEAP32[$1699 >> 2] = $1700 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1670, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     $1705 = $__v$i$i$i + 8 | 0;
     L522 : do if ($1661 >>> 0 < $1668 >>> 0) {
      $k15$0543 = $1661;
      while (1) {
       $1707 = HEAP32[$1674 >> 2] | 0;
       $1708 = $1707 + -16 | 0;
       $1709 = HEAP32[$db >> 2] | 0;
       $1710 = $1709 + ($k15$0543 * 24 | 0) | 0;
       $1711 = $1707 + -12 | 0;
       $1712 = HEAP32[$1711 >> 2] | 0;
       if (($1712 | 0) == (HEAP32[$1707 + -8 >> 2] | 0)) {
        $1724 = $1712 - (HEAP32[$1708 >> 2] | 0) | 0;
        $1725 = ($1724 | 0) / 24 | 0;
        $1726 = $1725 + 1 | 0;
        if (($1724 | 0) < -24) {
         $$lcssa690 = $1708;
         break;
        }
        if ($1725 >>> 0 < 1073741823) {
         $1729 = $1725 << 1;
         $$0$i$i$i136 = $1729 >>> 0 < $1726 >>> 0 ? $1726 : $1729;
        } else $$0$i$i$i136 = 2147483647;
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i136, $1725, $1707 + -4 | 0);
        $1732 = HEAP32[$1705 >> 2] | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1732, $1710);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1732 + 12 | 0, $1709 + ($k15$0543 * 24 | 0) + 12 | 0);
        HEAP32[$1705 >> 2] = $1732 + 24;
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($1708, $__v$i$i$i);
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
       } else {
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1712, $1710);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($1712 + 12 | 0, $1709 + ($k15$0543 * 24 | 0) + 12 | 0);
        HEAP32[$1711 >> 2] = (HEAP32[$1711 >> 2] | 0) + 24;
       }
       $k15$0543 = $k15$0543 + 1 | 0;
       if ($k15$0543 >>> 0 >= $1668 >>> 0) break L522;
      }
      __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa690);
     } while (0);
     if (!(($1668 | 0) == ($1661 + 1 | 0) & (HEAP8[$db + 63 >> 0] | 0) != 0)) {
      $$0 = $1662;
      break L1;
     }
     $1743 = __ZN10__cxxabiv112_GLOBAL__N_119parse_template_argsINS0_2DbEEEPKcS4_S4_RT_($1662, $last, $db) | 0;
     if (($1743 | 0) == ($1662 | 0)) {
      $$0 = $1662;
      break L1;
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($args, (HEAP32[$1655 >> 2] | 0) + -24 | 0);
     $1747 = HEAP32[$1655 >> 2] | 0;
     $1748 = $1747 + -24 | 0;
     $1750 = $1747;
     do {
      $1749 = $1750 + -24 | 0;
      HEAP32[$1655 >> 2] = $1749;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1749);
      $1750 = HEAP32[$1655 >> 2] | 0;
     } while (($1750 | 0) != ($1748 | 0));
     $1753 = HEAP8[$args >> 0] | 0;
     $1755 = ($1753 & 1) == 0;
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($1747 + -48 | 0, $1755 ? $args + 1 | 0 : HEAP32[$args + 8 >> 2] | 0, $1755 ? ($1753 & 255) >>> 1 : HEAP32[$args + 4 >> 2] | 0) | 0;
     $1766 = (HEAP32[$1655 >> 2] | 0) + -24 | 0;
     HEAP32[$25 >> 2] = HEAP32[$1671 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($24, $1766, $25);
     $1768 = HEAP32[$1674 >> 2] | 0;
     $1769 = HEAP32[$1676 >> 2] | 0;
     if ($1768 >>> 0 < $1769 >>> 0) {
      HEAP32[$1768 + 12 >> 2] = HEAP32[$24 + 12 >> 2];
      HEAP32[$1768 >> 2] = HEAP32[$24 >> 2];
      $1776 = $24 + 4 | 0;
      HEAP32[$1768 + 4 >> 2] = HEAP32[$1776 >> 2];
      $1778 = $24 + 8 | 0;
      HEAP32[$1768 + 8 >> 2] = HEAP32[$1778 >> 2];
      HEAP32[$1778 >> 2] = 0;
      HEAP32[$1776 >> 2] = 0;
      HEAP32[$24 >> 2] = 0;
      HEAP32[$1674 >> 2] = (HEAP32[$1674 >> 2] | 0) + 16;
     } else {
      $1786 = HEAP32[$1670 >> 2] | 0;
      $1787 = $1768 - $1786 | 0;
      $1788 = $1787 >> 4;
      $1789 = $1788 + 1 | 0;
      if (($1787 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1670);
      $1792 = $1769 - $1786 | 0;
      if ($1792 >> 4 >>> 0 < 1073741823) {
       $1795 = $1792 >> 3;
       $$0$i$i$i148 = $1795 >>> 0 < $1789 >>> 0 ? $1789 : $1795;
      } else $$0$i$i$i148 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i148, $1788, $db + 28 | 0);
      $1798 = $__v$i$i$i + 8 | 0;
      $1799 = HEAP32[$1798 >> 2] | 0;
      HEAP32[$1799 + 12 >> 2] = HEAP32[$24 + 12 >> 2];
      HEAP32[$1799 >> 2] = HEAP32[$24 >> 2];
      $1805 = $24 + 4 | 0;
      HEAP32[$1799 + 4 >> 2] = HEAP32[$1805 >> 2];
      $1807 = $24 + 8 | 0;
      HEAP32[$1799 + 8 >> 2] = HEAP32[$1807 >> 2];
      HEAP32[$1807 >> 2] = 0;
      HEAP32[$1805 >> 2] = 0;
      HEAP32[$24 >> 2] = 0;
      HEAP32[$1798 >> 2] = $1799 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1670, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($24);
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($args);
     $$0 = $1743;
     break L1;
     break;
    }
   case 85:
    {
     $1811 = $first + 1 | 0;
     if (($1811 | 0) == ($last | 0)) {
      $$0 = $first;
      break L1;
     }
     $1813 = __ZN10__cxxabiv112_GLOBAL__N_117parse_source_nameINS0_2DbEEEPKcS4_S4_RT_($1811, $last, $db) | 0;
     if (($1813 | 0) == ($1811 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1815 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1813, $last, $db) | 0;
     if (($1815 | 0) == ($1813 | 0)) {
      $$0 = $first;
      break L1;
     }
     $1817 = $db + 4 | 0;
     $1818 = HEAP32[$1817 >> 2] | 0;
     if ((($1818 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
      $$0 = $first;
      break L1;
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($type, $1818 + -24 | 0);
     $1826 = HEAP32[$1817 >> 2] | 0;
     $1827 = $1826 + -24 | 0;
     $1829 = $1826;
     do {
      $1828 = $1829 + -24 | 0;
      HEAP32[$1817 >> 2] = $1828;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1828);
      $1829 = HEAP32[$1817 >> 2] | 0;
     } while (($1829 | 0) != ($1827 | 0));
     $1831 = $1826 + -48 | 0;
     $1832 = HEAP8[$1831 >> 0] | 0;
     $1834 = ($1832 & 1) == 0;
     $1839 = $1834 ? ($1832 & 255) >>> 1 : HEAP32[$1826 + -44 >> 2] | 0;
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($26, $1834 ? $1831 + 1 | 0 : HEAP32[$1826 + -40 >> 2] | 0, $1839 >>> 0 < 9 ? $1839 : 9);
     $1846 = HEAP8[$26 >> 0] | 0;
     $1848 = ($1846 & 1) == 0;
     $1853 = $1848 ? ($1846 & 255) >>> 1 : HEAP32[$26 + 4 >> 2] | 0;
     $1858 = $1853 >>> 0 > 9;
     $1860 = _memcmp($1848 ? $26 + 1 | 0 : HEAP32[$26 + 8 >> 2] | 0, 12766, $1858 ? 9 : $1853) | 0;
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($26);
     $1866 = (HEAP32[$1817 >> 2] | 0) + -24 | 0;
     if (!((($1860 | 0) == 0 ? ($1853 >>> 0 < 9 ? -1 : $1858 & 1) : $1860) | 0)) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($proto, $1866);
      $1884 = HEAP32[$1817 >> 2] | 0;
      $1885 = $1884 + -24 | 0;
      $1887 = $1884;
      do {
       $1886 = $1887 + -24 | 0;
       HEAP32[$1817 >> 2] = $1886;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1886);
       $1887 = HEAP32[$1817 >> 2] | 0;
      } while (($1887 | 0) != ($1885 | 0));
      $1889 = HEAP8[$proto >> 0] | 0;
      $1891 = ($1889 & 1) == 0;
      $1892 = $proto + 8 | 0;
      $1894 = $proto + 1 | 0;
      $1895 = $1891 ? $1894 : HEAP32[$1892 >> 2] | 0;
      $1897 = $proto + 4 | 0;
      $1903 = __ZN10__cxxabiv112_GLOBAL__N_117parse_source_nameINS0_2DbEEEPKcS4_S4_RT_($1895 + 9 | 0, $1895 + ($1891 ? ($1889 & 255) >>> 1 : HEAP32[$1897 >> 2] | 0) | 0, $db) | 0;
      if (($1903 | 0) == (((HEAP8[$proto >> 0] & 1) == 0 ? $1894 : HEAP32[$1892 >> 2] | 0) + 9 | 0)) {
       __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EERKSB_PKS8_($38, $type, 12726);
       $1933 = HEAP8[$proto >> 0] | 0;
       $1935 = ($1933 & 1) == 0;
       $1942 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($38, $1935 ? $1894 : HEAP32[$1892 >> 2] | 0, $1935 ? ($1933 & 255) >>> 1 : HEAP32[$1897 >> 2] | 0) | 0;
       HEAP32[$37 >> 2] = HEAP32[$1942 >> 2];
       HEAP32[$37 + 4 >> 2] = HEAP32[$1942 + 4 >> 2];
       HEAP32[$37 + 8 >> 2] = HEAP32[$1942 + 8 >> 2];
       HEAP32[$1942 >> 2] = 0;
       HEAP32[$1942 + 4 >> 2] = 0;
       HEAP32[$1942 + 8 >> 2] = 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($36, $37);
       $1945 = HEAP32[$1817 >> 2] | 0;
       $1947 = HEAP32[$db + 8 >> 2] | 0;
       if ($1945 >>> 0 < $1947 >>> 0) {
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1945, $36);
        HEAP32[$1817 >> 2] = (HEAP32[$1817 >> 2] | 0) + 24;
       } else {
        $1954 = HEAP32[$db >> 2] | 0;
        $1955 = $1945 - $1954 | 0;
        $1956 = ($1955 | 0) / 24 | 0;
        $1957 = $1956 + 1 | 0;
        if (($1955 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
        $1961 = ($1947 - $1954 | 0) / 24 | 0;
        if ($1961 >>> 0 < 1073741823) {
         $1963 = $1961 << 1;
         $$0$i$i$i181 = $1963 >>> 0 < $1957 >>> 0 ? $1957 : $1963;
        } else $$0$i$i$i181 = 2147483647;
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i181, $1956, $db + 12 | 0);
        $1966 = $__v$i$i$i + 8 | 0;
        $1967 = HEAP32[$1966 >> 2] | 0;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1967, $36);
        HEAP32[$1966 >> 2] = $1967 + 24;
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i$i);
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
       }
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($36);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($37);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($38);
      } else {
       $1912 = (HEAP32[$1817 >> 2] | 0) + -24 | 0;
       __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EERKSB_PKS8_($34, $type, 12776);
       __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($35, (HEAP32[$1817 >> 2] | 0) + -24 | 0);
       $1915 = HEAP8[$35 >> 0] | 0;
       $1917 = ($1915 & 1) == 0;
       $1927 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($34, $1917 ? $35 + 1 | 0 : HEAP32[$35 + 8 >> 2] | 0, $1917 ? ($1915 & 255) >>> 1 : HEAP32[$35 + 4 >> 2] | 0) | 0;
       HEAP32[$33 >> 2] = HEAP32[$1927 >> 2];
       HEAP32[$33 + 4 >> 2] = HEAP32[$1927 + 4 >> 2];
       HEAP32[$33 + 8 >> 2] = HEAP32[$1927 + 8 >> 2];
       HEAP32[$1927 >> 2] = 0;
       HEAP32[$1927 + 4 >> 2] = 0;
       HEAP32[$1927 + 8 >> 2] = 0;
       $1930 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($33, 12778) | 0;
       HEAP32[$32 >> 2] = HEAP32[$1930 >> 2];
       HEAP32[$32 + 4 >> 2] = HEAP32[$1930 + 4 >> 2];
       HEAP32[$32 + 8 >> 2] = HEAP32[$1930 + 8 >> 2];
       HEAP32[$1930 >> 2] = 0;
       HEAP32[$1930 + 4 >> 2] = 0;
       HEAP32[$1930 + 8 >> 2] = 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($31, $32);
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1912, $31);
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($31);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($32);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($33);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($35);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($34);
      }
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($proto);
     } else {
      __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EERKSB_PKS8_($29, $type, 12726);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($30, (HEAP32[$1817 >> 2] | 0) + -24 | 0);
      $1869 = HEAP8[$30 >> 0] | 0;
      $1871 = ($1869 & 1) == 0;
      $1881 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($29, $1871 ? $30 + 1 | 0 : HEAP32[$30 + 8 >> 2] | 0, $1871 ? ($1869 & 255) >>> 1 : HEAP32[$30 + 4 >> 2] | 0) | 0;
      HEAP32[$28 >> 2] = HEAP32[$1881 >> 2];
      HEAP32[$28 + 4 >> 2] = HEAP32[$1881 + 4 >> 2];
      HEAP32[$28 + 8 >> 2] = HEAP32[$1881 + 8 >> 2];
      HEAP32[$1881 >> 2] = 0;
      HEAP32[$1881 + 4 >> 2] = 0;
      HEAP32[$1881 + 8 >> 2] = 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($27, $28);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1866, $27);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($27);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($28);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($30);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($29);
     }
     $1970 = (HEAP32[$1817 >> 2] | 0) + -24 | 0;
     HEAP32[$40 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($39, $1970, $40);
     $1973 = $db + 16 | 0;
     $1974 = $db + 20 | 0;
     $1975 = HEAP32[$1974 >> 2] | 0;
     $1977 = HEAP32[$db + 24 >> 2] | 0;
     if ($1975 >>> 0 < $1977 >>> 0) {
      HEAP32[$1975 + 12 >> 2] = HEAP32[$39 + 12 >> 2];
      HEAP32[$1975 >> 2] = HEAP32[$39 >> 2];
      $1984 = $39 + 4 | 0;
      HEAP32[$1975 + 4 >> 2] = HEAP32[$1984 >> 2];
      $1986 = $39 + 8 | 0;
      HEAP32[$1975 + 8 >> 2] = HEAP32[$1986 >> 2];
      HEAP32[$1986 >> 2] = 0;
      HEAP32[$1984 >> 2] = 0;
      HEAP32[$39 >> 2] = 0;
      HEAP32[$1974 >> 2] = (HEAP32[$1974 >> 2] | 0) + 16;
     } else {
      $1994 = HEAP32[$1973 >> 2] | 0;
      $1995 = $1975 - $1994 | 0;
      $1996 = $1995 >> 4;
      $1997 = $1996 + 1 | 0;
      if (($1995 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($1973);
      $2000 = $1977 - $1994 | 0;
      if ($2000 >> 4 >>> 0 < 1073741823) {
       $2003 = $2000 >> 3;
       $$0$i$i$i153 = $2003 >>> 0 < $1997 >>> 0 ? $1997 : $2003;
      } else $$0$i$i$i153 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i153, $1996, $db + 28 | 0);
      $2006 = $__v$i$i$i + 8 | 0;
      $2007 = HEAP32[$2006 >> 2] | 0;
      HEAP32[$2007 + 12 >> 2] = HEAP32[$39 + 12 >> 2];
      HEAP32[$2007 >> 2] = HEAP32[$39 >> 2];
      $2013 = $39 + 4 | 0;
      HEAP32[$2007 + 4 >> 2] = HEAP32[$2013 >> 2];
      $2015 = $39 + 8 | 0;
      HEAP32[$2007 + 8 >> 2] = HEAP32[$2015 >> 2];
      HEAP32[$2015 >> 2] = 0;
      HEAP32[$2013 >> 2] = 0;
      HEAP32[$39 >> 2] = 0;
      HEAP32[$2006 >> 2] = $2007 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($1973, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($39);
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($type);
     $$0 = $1815;
     break L1;
     break;
    }
   case 83:
    {
     $2019 = $first + 1 | 0;
     if (($2019 | 0) != ($last | 0)) if ((HEAP8[$2019 >> 0] | 0) == 116) {
      $2023 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
      if (($2023 | 0) == ($first | 0)) {
       $$0 = $first;
       break L1;
      }
      $2027 = HEAP32[$db + 4 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($2027 | 0)) {
       $$0 = $first;
       break L1;
      }
      $2029 = $db + 16 | 0;
      HEAP32[$42 >> 2] = HEAP32[$db + 12 >> 2];
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($41, $2027 + -24 | 0, $42);
      $2033 = $db + 20 | 0;
      $2034 = HEAP32[$2033 >> 2] | 0;
      $2036 = HEAP32[$db + 24 >> 2] | 0;
      if ($2034 >>> 0 < $2036 >>> 0) {
       HEAP32[$2034 + 12 >> 2] = HEAP32[$41 + 12 >> 2];
       HEAP32[$2034 >> 2] = HEAP32[$41 >> 2];
       $2043 = $41 + 4 | 0;
       HEAP32[$2034 + 4 >> 2] = HEAP32[$2043 >> 2];
       $2045 = $41 + 8 | 0;
       HEAP32[$2034 + 8 >> 2] = HEAP32[$2045 >> 2];
       HEAP32[$2045 >> 2] = 0;
       HEAP32[$2043 >> 2] = 0;
       HEAP32[$41 >> 2] = 0;
       HEAP32[$2033 >> 2] = (HEAP32[$2033 >> 2] | 0) + 16;
      } else {
       $2053 = HEAP32[$2029 >> 2] | 0;
       $2054 = $2034 - $2053 | 0;
       $2055 = $2054 >> 4;
       $2056 = $2055 + 1 | 0;
       if (($2054 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2029);
       $2059 = $2036 - $2053 | 0;
       if ($2059 >> 4 >>> 0 < 1073741823) {
        $2062 = $2059 >> 3;
        $$0$i$i$i51 = $2062 >>> 0 < $2056 >>> 0 ? $2056 : $2062;
       } else $$0$i$i$i51 = 2147483647;
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i51, $2055, $db + 28 | 0);
       $2065 = $__v$i$i$i + 8 | 0;
       $2066 = HEAP32[$2065 >> 2] | 0;
       HEAP32[$2066 + 12 >> 2] = HEAP32[$41 + 12 >> 2];
       HEAP32[$2066 >> 2] = HEAP32[$41 >> 2];
       $2072 = $41 + 4 | 0;
       HEAP32[$2066 + 4 >> 2] = HEAP32[$2072 >> 2];
       $2074 = $41 + 8 | 0;
       HEAP32[$2066 + 8 >> 2] = HEAP32[$2074 >> 2];
       HEAP32[$2074 >> 2] = 0;
       HEAP32[$2072 >> 2] = 0;
       HEAP32[$41 >> 2] = 0;
       HEAP32[$2065 >> 2] = $2066 + 16;
       __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2029, $__v$i$i$i);
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
      }
      __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($41);
      $$0 = $2023;
      break L1;
     }
     $2078 = __ZN10__cxxabiv112_GLOBAL__N_118parse_substitutionINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
     if (($2078 | 0) == ($first | 0)) {
      $$0 = $first;
      break L1;
     }
     $2080 = __ZN10__cxxabiv112_GLOBAL__N_119parse_template_argsINS0_2DbEEEPKcS4_S4_RT_($2078, $last, $db) | 0;
     if (($2080 | 0) == ($2078 | 0)) {
      $$0 = $2078;
      break L1;
     }
     $2082 = $db + 4 | 0;
     $2083 = HEAP32[$2082 >> 2] | 0;
     if ((($2083 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
      $$0 = $2078;
      break L1;
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($template_args, $2083 + -24 | 0);
     $2091 = HEAP32[$2082 >> 2] | 0;
     $2092 = $2091 + -24 | 0;
     $2094 = $2091;
     do {
      $2093 = $2094 + -24 | 0;
      HEAP32[$2082 >> 2] = $2093;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($2093);
      $2094 = HEAP32[$2082 >> 2] | 0;
     } while (($2094 | 0) != ($2092 | 0));
     $2097 = HEAP8[$template_args >> 0] | 0;
     $2099 = ($2097 & 1) == 0;
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($2091 + -48 | 0, $2099 ? $template_args + 1 | 0 : HEAP32[$template_args + 8 >> 2] | 0, $2099 ? ($2097 & 255) >>> 1 : HEAP32[$template_args + 4 >> 2] | 0) | 0;
     $2110 = (HEAP32[$2082 >> 2] | 0) + -24 | 0;
     HEAP32[$44 >> 2] = HEAP32[$db + 12 >> 2];
     __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($43, $2110, $44);
     $2113 = $db + 16 | 0;
     $2114 = $db + 20 | 0;
     $2115 = HEAP32[$2114 >> 2] | 0;
     $2117 = HEAP32[$db + 24 >> 2] | 0;
     if ($2115 >>> 0 < $2117 >>> 0) {
      HEAP32[$2115 + 12 >> 2] = HEAP32[$43 + 12 >> 2];
      HEAP32[$2115 >> 2] = HEAP32[$43 >> 2];
      $2124 = $43 + 4 | 0;
      HEAP32[$2115 + 4 >> 2] = HEAP32[$2124 >> 2];
      $2126 = $43 + 8 | 0;
      HEAP32[$2115 + 8 >> 2] = HEAP32[$2126 >> 2];
      HEAP32[$2126 >> 2] = 0;
      HEAP32[$2124 >> 2] = 0;
      HEAP32[$43 >> 2] = 0;
      HEAP32[$2114 >> 2] = (HEAP32[$2114 >> 2] | 0) + 16;
     } else {
      $2134 = HEAP32[$2113 >> 2] | 0;
      $2135 = $2115 - $2134 | 0;
      $2136 = $2135 >> 4;
      $2137 = $2136 + 1 | 0;
      if (($2135 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2113);
      $2140 = $2117 - $2134 | 0;
      if ($2140 >> 4 >>> 0 < 1073741823) {
       $2143 = $2140 >> 3;
       $$0$i$i$i31 = $2143 >>> 0 < $2137 >>> 0 ? $2137 : $2143;
      } else $$0$i$i$i31 = 2147483647;
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i31, $2136, $db + 28 | 0);
      $2146 = $__v$i$i$i + 8 | 0;
      $2147 = HEAP32[$2146 >> 2] | 0;
      HEAP32[$2147 + 12 >> 2] = HEAP32[$43 + 12 >> 2];
      HEAP32[$2147 >> 2] = HEAP32[$43 >> 2];
      $2153 = $43 + 4 | 0;
      HEAP32[$2147 + 4 >> 2] = HEAP32[$2153 >> 2];
      $2155 = $43 + 8 | 0;
      HEAP32[$2147 + 8 >> 2] = HEAP32[$2155 >> 2];
      HEAP32[$2155 >> 2] = 0;
      HEAP32[$2153 >> 2] = 0;
      HEAP32[$43 >> 2] = 0;
      HEAP32[$2146 >> 2] = $2147 + 16;
      __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2113, $__v$i$i$i);
      __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
     }
     __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($43);
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($template_args);
     $$0 = $2080;
     break L1;
     break;
    }
   case 68:
    {
     $2159 = $first + 1 | 0;
     if (($2159 | 0) != ($last | 0)) {
      $2161 = HEAP8[$2159 >> 0] | 0;
      switch ($2161 << 24 >> 24 | 0) {
      case 112:
       {
        $2163 = $db + 4 | 0;
        $2169 = ((HEAP32[$2163 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
        $2170 = $first + 2 | 0;
        $2171 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($2170, $last, $db) | 0;
        $2177 = ((HEAP32[$2163 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
        if (($2171 | 0) == ($2170 | 0)) break L65;
        $2179 = $db + 16 | 0;
        $2182 = HEAP32[$db + 12 >> 2] | 0;
        $2183 = $db + 20 | 0;
        $2184 = HEAP32[$2183 >> 2] | 0;
        $2186 = HEAP32[$db + 24 >> 2] | 0;
        if ($2184 >>> 0 < $2186 >>> 0) {
         HEAP32[$2184 >> 2] = 0;
         HEAP32[$2184 + 4 >> 2] = 0;
         HEAP32[$2184 + 8 >> 2] = 0;
         HEAP32[$2184 + 12 >> 2] = $2182;
         HEAP32[$2183 >> 2] = (HEAP32[$2183 >> 2] | 0) + 16;
        } else {
         $2196 = HEAP32[$2179 >> 2] | 0;
         $2197 = $2184 - $2196 | 0;
         $2198 = $2197 >> 4;
         $2199 = $2198 + 1 | 0;
         if (($2197 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2179);
         $2202 = $2186 - $2196 | 0;
         if ($2202 >> 4 >>> 0 < 1073741823) {
          $2205 = $2202 >> 3;
          $$0$i$i$i29 = $2205 >>> 0 < $2199 >>> 0 ? $2199 : $2205;
         } else $$0$i$i$i29 = 2147483647;
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i29, $2198, $db + 28 | 0);
         $2208 = $__v$i$i$i + 8 | 0;
         $2209 = HEAP32[$2208 >> 2] | 0;
         HEAP32[$2209 >> 2] = 0;
         HEAP32[$2209 + 4 >> 2] = 0;
         HEAP32[$2209 + 8 >> 2] = 0;
         HEAP32[$2209 + 12 >> 2] = $2182;
         HEAP32[$2208 >> 2] = $2209 + 16;
         __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2179, $__v$i$i$i);
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
        }
        $2214 = $__v$i$i$i + 8 | 0;
        if ($2169 >>> 0 < $2177 >>> 0) $k20$0550 = $2169; else {
         $$0 = $2171;
         break L1;
        }
        while (1) {
         $2216 = HEAP32[$2183 >> 2] | 0;
         $2217 = $2216 + -16 | 0;
         $2218 = HEAP32[$db >> 2] | 0;
         $2219 = $2218 + ($k20$0550 * 24 | 0) | 0;
         $2220 = $2216 + -12 | 0;
         $2221 = HEAP32[$2220 >> 2] | 0;
         if (($2221 | 0) == (HEAP32[$2216 + -8 >> 2] | 0)) {
          $2233 = $2221 - (HEAP32[$2217 >> 2] | 0) | 0;
          $2234 = ($2233 | 0) / 24 | 0;
          $2235 = $2234 + 1 | 0;
          if (($2233 | 0) < -24) {
           $$lcssa698 = $2217;
           break;
          }
          if ($2234 >>> 0 < 1073741823) {
           $2238 = $2234 << 1;
           $$0$i$i$i27 = $2238 >>> 0 < $2235 >>> 0 ? $2235 : $2238;
          } else $$0$i$i$i27 = 2147483647;
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i27, $2234, $2216 + -4 | 0);
          $2241 = HEAP32[$2214 >> 2] | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($2241, $2219);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($2241 + 12 | 0, $2218 + ($k20$0550 * 24 | 0) + 12 | 0);
          HEAP32[$2214 >> 2] = $2241 + 24;
          __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($2217, $__v$i$i$i);
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
         } else {
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($2221, $2219);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEC2ERKS7_($2221 + 12 | 0, $2218 + ($k20$0550 * 24 | 0) + 12 | 0);
          HEAP32[$2220 >> 2] = (HEAP32[$2220 >> 2] | 0) + 24;
         }
         $k20$0550 = $k20$0550 + 1 | 0;
         if ($k20$0550 >>> 0 >= $2177 >>> 0) {
          $$0 = $2171;
          break L1;
         }
        }
        __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($$lcssa698);
        break;
       }
      case 84:
      case 116:
       {
        $2247 = __ZN10__cxxabiv112_GLOBAL__N_114parse_decltypeINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
        if (($2247 | 0) == ($first | 0)) break L65;
        $2251 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($2251 | 0)) {
         $$0 = $first;
         break L1;
        }
        $2253 = $db + 16 | 0;
        HEAP32[$46 >> 2] = HEAP32[$db + 12 >> 2];
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($45, $2251 + -24 | 0, $46);
        $2257 = $db + 20 | 0;
        $2258 = HEAP32[$2257 >> 2] | 0;
        $2260 = HEAP32[$db + 24 >> 2] | 0;
        if ($2258 >>> 0 < $2260 >>> 0) {
         HEAP32[$2258 + 12 >> 2] = HEAP32[$45 + 12 >> 2];
         HEAP32[$2258 >> 2] = HEAP32[$45 >> 2];
         $2267 = $45 + 4 | 0;
         HEAP32[$2258 + 4 >> 2] = HEAP32[$2267 >> 2];
         $2269 = $45 + 8 | 0;
         HEAP32[$2258 + 8 >> 2] = HEAP32[$2269 >> 2];
         HEAP32[$2269 >> 2] = 0;
         HEAP32[$2267 >> 2] = 0;
         HEAP32[$45 >> 2] = 0;
         HEAP32[$2257 >> 2] = (HEAP32[$2257 >> 2] | 0) + 16;
        } else {
         $2277 = HEAP32[$2253 >> 2] | 0;
         $2278 = $2258 - $2277 | 0;
         $2279 = $2278 >> 4;
         $2280 = $2279 + 1 | 0;
         if (($2278 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2253);
         $2283 = $2260 - $2277 | 0;
         if ($2283 >> 4 >>> 0 < 1073741823) {
          $2286 = $2283 >> 3;
          $$0$i$i$i22 = $2286 >>> 0 < $2280 >>> 0 ? $2280 : $2286;
         } else $$0$i$i$i22 = 2147483647;
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i22, $2279, $db + 28 | 0);
         $2289 = $__v$i$i$i + 8 | 0;
         $2290 = HEAP32[$2289 >> 2] | 0;
         HEAP32[$2290 + 12 >> 2] = HEAP32[$45 + 12 >> 2];
         HEAP32[$2290 >> 2] = HEAP32[$45 >> 2];
         $2296 = $45 + 4 | 0;
         HEAP32[$2290 + 4 >> 2] = HEAP32[$2296 >> 2];
         $2298 = $45 + 8 | 0;
         HEAP32[$2290 + 8 >> 2] = HEAP32[$2298 >> 2];
         HEAP32[$2298 >> 2] = 0;
         HEAP32[$2296 >> 2] = 0;
         HEAP32[$45 >> 2] = 0;
         HEAP32[$2289 >> 2] = $2290 + 16;
         __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2253, $__v$i$i$i);
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
        }
        __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($45);
        $$0 = $2247;
        break L1;
        break;
       }
      case 118:
       {
        L662 : do if (($last - $first | 0) > 3 & $197 << 24 >> 24 == 68 & $2161 << 24 >> 24 == 118) {
         $2308 = $first + 2 | 0;
         $2309 = HEAP8[$2308 >> 0] | 0;
         if (($2309 + -49 & 255) < 9) {
          $2311 = __ZN10__cxxabiv112_GLOBAL__N_112parse_numberEPKcS2_($2308, $last) | 0;
          if (($2311 | 0) == ($last | 0)) {
           $$1$i263 = $first;
           break;
          }
          if ((HEAP8[$2311 >> 0] | 0) != 95) {
           $$1$i263 = $first;
           break;
          }
          $2317 = $2311 - $2308 | 0;
          $2318 = $2311 + 1 | 0;
          if (($2318 | 0) == ($last | 0)) {
           $$1$i263 = $first;
           break;
          }
          if ((HEAP8[$2318 >> 0] | 0) != 112) {
           $2322 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($2318, $last, $db) | 0;
           if (($2322 | 0) == ($2318 | 0)) {
            $$1$i263 = $first;
            break;
           }
           $2326 = HEAP32[$db + 4 >> 2] | 0;
           if ((HEAP32[$db >> 2] | 0) == ($2326 | 0)) {
            $$1$i263 = $first;
            break;
           }
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($2, $2308, $2317);
           $2329 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($2, 0, 12780) | 0;
           HEAP32[$1 >> 2] = HEAP32[$2329 >> 2];
           HEAP32[$1 + 4 >> 2] = HEAP32[$2329 + 4 >> 2];
           HEAP32[$1 + 8 >> 2] = HEAP32[$2329 + 8 >> 2];
           HEAP32[$2329 >> 2] = 0;
           HEAP32[$2329 + 4 >> 2] = 0;
           HEAP32[$2329 + 8 >> 2] = 0;
           $2332 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1, 12703) | 0;
           HEAP32[$0 >> 2] = HEAP32[$2332 >> 2];
           HEAP32[$0 + 4 >> 2] = HEAP32[$2332 + 4 >> 2];
           HEAP32[$0 + 8 >> 2] = HEAP32[$2332 + 8 >> 2];
           HEAP32[$2332 >> 2] = 0;
           HEAP32[$2332 + 4 >> 2] = 0;
           HEAP32[$2332 + 8 >> 2] = 0;
           $2335 = HEAP8[$0 >> 0] | 0;
           $2337 = ($2335 & 1) == 0;
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($2326 + -24 | 0, $2337 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $2337 ? ($2335 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
           $$1$i263 = $2322;
           break;
          }
          $2347 = $2311 + 2 | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($6, $2308, $2317);
          $2348 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($6, 0, 12789) | 0;
          HEAP32[$5 >> 2] = HEAP32[$2348 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$2348 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$2348 + 8 >> 2];
          HEAP32[$2348 >> 2] = 0;
          HEAP32[$2348 + 4 >> 2] = 0;
          HEAP32[$2348 + 8 >> 2] = 0;
          $2351 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($5, 12703) | 0;
          HEAP32[$4 >> 2] = HEAP32[$2351 >> 2];
          HEAP32[$4 + 4 >> 2] = HEAP32[$2351 + 4 >> 2];
          HEAP32[$4 + 8 >> 2] = HEAP32[$2351 + 8 >> 2];
          HEAP32[$2351 >> 2] = 0;
          HEAP32[$2351 + 4 >> 2] = 0;
          HEAP32[$2351 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($3, $4);
          $2354 = $db + 4 | 0;
          $2355 = HEAP32[$2354 >> 2] | 0;
          $2357 = HEAP32[$db + 8 >> 2] | 0;
          if ($2355 >>> 0 < $2357 >>> 0) {
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($2355, $3);
           HEAP32[$2354 >> 2] = (HEAP32[$2354 >> 2] | 0) + 24;
          } else {
           $2364 = HEAP32[$db >> 2] | 0;
           $2365 = $2355 - $2364 | 0;
           $2366 = ($2365 | 0) / 24 | 0;
           $2367 = $2366 + 1 | 0;
           if (($2365 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
           $2371 = ($2357 - $2364 | 0) / 24 | 0;
           if ($2371 >>> 0 < 1073741823) {
            $2373 = $2371 << 1;
            $$0$i$i$i$i = $2373 >>> 0 < $2367 >>> 0 ? $2367 : $2373;
           } else $$0$i$i$i$i = 2147483647;
           __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i$i, $$0$i$i$i$i, $2366, $db + 12 | 0);
           $2376 = $__v$i$i$i + 8 | 0;
           $2377 = HEAP32[$2376 >> 2] | 0;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($2377, $3);
           HEAP32[$2376 >> 2] = $2377 + 24;
           __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i$i);
           __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i$i);
          }
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($3);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          $$1$i263 = $2347;
          break;
         }
         HEAP32[$num1$i >> 2] = 0;
         HEAP32[$num1$i + 4 >> 2] = 0;
         HEAP32[$num1$i + 8 >> 2] = 0;
         if ($2309 << 24 >> 24 == 95) {
          $t12$0$i = $2308;
          label = 521;
         } else {
          $2382 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($2308, $last, $db) | 0;
          if (($2382 | 0) == ($2308 | 0)) {
           $t12$0$i = $2308;
           label = 521;
          } else {
           $2385 = $db + 4 | 0;
           $2386 = HEAP32[$2385 >> 2] | 0;
           if ((HEAP32[$db >> 2] | 0) != ($2386 | 0)) {
            __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($7, $2386 + -24 | 0);
            L689 : do if (!(HEAP8[$num1$i >> 0] & 1)) {
             HEAP8[$num1$i + 1 >> 0] = 0;
             HEAP8[$num1$i >> 0] = 0;
            } else {
             $2393 = $num1$i + 8 | 0;
             $2394 = HEAP32[$2393 >> 2] | 0;
             HEAP8[$2394 >> 0] = 0;
             $2395 = $num1$i + 4 | 0;
             HEAP32[$2395 >> 2] = 0;
             $2396 = HEAP32[$num1$i >> 2] | 0;
             $phitmp$i$i$i$i$i$i$i240 = ($2396 & -2) + -1 | 0;
             $2398 = $2396 & 255;
             do if (!($2398 & 1)) {
              $2402 = $2396 >>> 1 & 127;
              if (($2398 & 255) < 22) {
               _memcpy($num1$i + 1 | 0, $2394 | 0, ($2396 >>> 1 & 127) + 1 | 0) | 0;
               _free($2394);
               $$ph390 = $2402;
               break;
              }
              $2405 = $2402 + 16 & 240;
              $phitmp$i2$i$i$i$i$i$i243 = $2405 + -1 | 0;
              if (($phitmp$i2$i$i$i$i$i$i243 | 0) == ($phitmp$i$i$i$i$i$i$i240 | 0)) break L689;
              $2408 = _malloc($2405) | 0;
              if ($phitmp$i2$i$i$i$i$i$i243 >>> 0 <= $phitmp$i$i$i$i$i$i$i240 >>> 0 & ($2408 | 0) == 0) break L689;
              _memcpy($2408 | 0, $num1$i + 1 | 0, ($2396 >>> 1 & 127) + 1 | 0) | 0;
              HEAP32[$num1$i >> 2] = $2405 | 1;
              HEAP32[$2395 >> 2] = $2402;
              HEAP32[$2393 >> 2] = $2408;
              break L689;
             } else {
              HEAP8[$num1$i + 1 >> 0] = 0;
              _free($2394);
              $$ph390 = 0;
             } while (0);
             HEAP8[$num1$i >> 0] = $$ph390 << 1;
            } while (0);
            HEAP32[$num1$i >> 2] = HEAP32[$7 >> 2];
            HEAP32[$num1$i + 4 >> 2] = HEAP32[$7 + 4 >> 2];
            HEAP32[$num1$i + 8 >> 2] = HEAP32[$7 + 8 >> 2];
            HEAP32[$7 >> 2] = 0;
            HEAP32[$7 + 4 >> 2] = 0;
            HEAP32[$7 + 8 >> 2] = 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
            $2424 = HEAP32[$2385 >> 2] | 0;
            $2425 = $2424 + -24 | 0;
            $2427 = $2424;
            do {
             $2426 = $2427 + -24 | 0;
             HEAP32[$2385 >> 2] = $2426;
             __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($2426);
             $2427 = HEAP32[$2385 >> 2] | 0;
            } while (($2427 | 0) != ($2425 | 0));
            $t12$0$i = $2382;
            label = 521;
           }
          }
         }
         do if ((label | 0) == 521) {
          if (($t12$0$i | 0) == ($last | 0)) $$13$i259$ph = $first; else if ((HEAP8[$t12$0$i >> 0] | 0) == 95) {
           $2432 = $t12$0$i + 1 | 0;
           if (($2432 | 0) == ($last | 0)) $$13$i259$ph = $first; else {
            $2434 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($2432, $last, $db) | 0;
            if (($2434 | 0) == ($2432 | 0)) $$13$i259$ph = $first; else {
             $2438 = HEAP32[$db + 4 >> 2] | 0;
             if ((HEAP32[$db >> 2] | 0) == ($2438 | 0)) break;
             __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($9, 12780, $num1$i);
             $2441 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($9, 12703) | 0;
             HEAP32[$8 >> 2] = HEAP32[$2441 >> 2];
             HEAP32[$8 + 4 >> 2] = HEAP32[$2441 + 4 >> 2];
             HEAP32[$8 + 8 >> 2] = HEAP32[$2441 + 8 >> 2];
             HEAP32[$2441 >> 2] = 0;
             HEAP32[$2441 + 4 >> 2] = 0;
             HEAP32[$2441 + 8 >> 2] = 0;
             $2444 = HEAP8[$8 >> 0] | 0;
             $2446 = ($2444 & 1) == 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($2438 + -24 | 0, $2446 ? $8 + 1 | 0 : HEAP32[$8 + 8 >> 2] | 0, $2446 ? ($2444 & 255) >>> 1 : HEAP32[$8 + 4 >> 2] | 0) | 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($8);
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($9);
             $$13$i259$ph = $2434;
            }
           }
          } else $$13$i259$ph = $first;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($num1$i);
          $$1$i263 = $$13$i259$ph;
          break L662;
         } while (0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($num1$i);
         $$1$i263 = $first;
        } else $$1$i263 = $first; while (0);
        if (($$1$i263 | 0) == ($first | 0)) break L65;
        $2459 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($2459 | 0)) {
         $$0 = $first;
         break L1;
        }
        $2461 = $db + 16 | 0;
        HEAP32[$48 >> 2] = HEAP32[$db + 12 >> 2];
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($47, $2459 + -24 | 0, $48);
        $2465 = $db + 20 | 0;
        $2466 = HEAP32[$2465 >> 2] | 0;
        $2468 = HEAP32[$db + 24 >> 2] | 0;
        if ($2466 >>> 0 < $2468 >>> 0) {
         HEAP32[$2466 + 12 >> 2] = HEAP32[$47 + 12 >> 2];
         HEAP32[$2466 >> 2] = HEAP32[$47 >> 2];
         $2475 = $47 + 4 | 0;
         HEAP32[$2466 + 4 >> 2] = HEAP32[$2475 >> 2];
         $2477 = $47 + 8 | 0;
         HEAP32[$2466 + 8 >> 2] = HEAP32[$2477 >> 2];
         HEAP32[$2477 >> 2] = 0;
         HEAP32[$2475 >> 2] = 0;
         HEAP32[$47 >> 2] = 0;
         HEAP32[$2465 >> 2] = (HEAP32[$2465 >> 2] | 0) + 16;
        } else {
         $2485 = HEAP32[$2461 >> 2] | 0;
         $2486 = $2466 - $2485 | 0;
         $2487 = $2486 >> 4;
         $2488 = $2487 + 1 | 0;
         if (($2486 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2461);
         $2491 = $2468 - $2485 | 0;
         if ($2491 >> 4 >>> 0 < 1073741823) {
          $2494 = $2491 >> 3;
          $$0$i$i$i17 = $2494 >>> 0 < $2488 >>> 0 ? $2488 : $2494;
         } else $$0$i$i$i17 = 2147483647;
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i17, $2487, $db + 28 | 0);
         $2497 = $__v$i$i$i + 8 | 0;
         $2498 = HEAP32[$2497 >> 2] | 0;
         HEAP32[$2498 + 12 >> 2] = HEAP32[$47 + 12 >> 2];
         HEAP32[$2498 >> 2] = HEAP32[$47 >> 2];
         $2504 = $47 + 4 | 0;
         HEAP32[$2498 + 4 >> 2] = HEAP32[$2504 >> 2];
         $2506 = $47 + 8 | 0;
         HEAP32[$2498 + 8 >> 2] = HEAP32[$2506 >> 2];
         HEAP32[$2506 >> 2] = 0;
         HEAP32[$2504 >> 2] = 0;
         HEAP32[$47 >> 2] = 0;
         HEAP32[$2497 >> 2] = $2498 + 16;
         __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2461, $__v$i$i$i);
         __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
        }
        __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($47);
        $$0 = $$1$i263;
        break L1;
        break;
       }
      default:
       break L65;
      }
     }
     break;
    }
   default:
    {}
   } while (0);
   $2510 = __ZN10__cxxabiv112_GLOBAL__N_118parse_builtin_typeINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
   if (($2510 | 0) == ($first | 0)) {
    $2512 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
    if (($2512 | 0) == ($first | 0)) $$0 = $first; else {
     $2516 = HEAP32[$db + 4 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($2516 | 0)) $$0 = $first; else {
      $2518 = $db + 16 | 0;
      HEAP32[$50 >> 2] = HEAP32[$db + 12 >> 2];
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($49, $2516 + -24 | 0, $50);
      $2522 = $db + 20 | 0;
      $2523 = HEAP32[$2522 >> 2] | 0;
      $2525 = HEAP32[$db + 24 >> 2] | 0;
      if ($2523 >>> 0 < $2525 >>> 0) {
       HEAP32[$2523 + 12 >> 2] = HEAP32[$49 + 12 >> 2];
       HEAP32[$2523 >> 2] = HEAP32[$49 >> 2];
       $2532 = $49 + 4 | 0;
       HEAP32[$2523 + 4 >> 2] = HEAP32[$2532 >> 2];
       $2534 = $49 + 8 | 0;
       HEAP32[$2523 + 8 >> 2] = HEAP32[$2534 >> 2];
       HEAP32[$2534 >> 2] = 0;
       HEAP32[$2532 >> 2] = 0;
       HEAP32[$49 >> 2] = 0;
       HEAP32[$2522 >> 2] = (HEAP32[$2522 >> 2] | 0) + 16;
      } else {
       $2542 = HEAP32[$2518 >> 2] | 0;
       $2543 = $2523 - $2542 | 0;
       $2544 = $2543 >> 4;
       $2545 = $2544 + 1 | 0;
       if (($2543 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($2518);
       $2548 = $2525 - $2542 | 0;
       if ($2548 >> 4 >>> 0 < 1073741823) {
        $2551 = $2548 >> 3;
        $$0$i$i$i = $2551 >>> 0 < $2545 >>> 0 ? $2545 : $2551;
       } else $$0$i$i$i = 2147483647;
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i$i, $$0$i$i$i, $2544, $db + 28 | 0);
       $2554 = $__v$i$i$i + 8 | 0;
       $2555 = HEAP32[$2554 >> 2] | 0;
       HEAP32[$2555 + 12 >> 2] = HEAP32[$49 + 12 >> 2];
       HEAP32[$2555 >> 2] = HEAP32[$49 >> 2];
       $2561 = $49 + 4 | 0;
       HEAP32[$2555 + 4 >> 2] = HEAP32[$2561 >> 2];
       $2563 = $49 + 8 | 0;
       HEAP32[$2555 + 8 >> 2] = HEAP32[$2563 >> 2];
       HEAP32[$2563 >> 2] = 0;
       HEAP32[$2561 >> 2] = 0;
       HEAP32[$49 >> 2] = 0;
       HEAP32[$2554 >> 2] = $2555 + 16;
       __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($2518, $__v$i$i$i);
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i$i);
      }
      __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($49);
      $$0 = $2512;
     }
    }
   } else $$0 = $2510;
  } else $$0 = $195;
 } while (0);
 STACKTOP = sp;
 return $$0 | 0;
}
function __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0 = 0, $$0$i$i$i = 0, $$0$i$i$i$i = 0, $$0$i$i$i$i299 = 0, $$0$i$i$i$i348 = 0, $$0$i254 = 0, $$019$i = 0, $$02$i = 0, $$02$i310 = 0, $$02$i317 = 0, $$03$i = 0, $$03$i174 = 0, $$03$i189 = 0, $$03$i200 = 0, $$03$i211 = 0, $$03$i265 = 0, $$03$i456 = 0, $$03$i486 = 0, $$06$i = 0, $$06$i248 = 0, $$06$i345 = 0, $$06$i426 = 0, $$2$i302 = 0, $$2$i398 = 0, $$221$i = 0, $$311$i = 0, $$9$i = 0, $$first$i = 0, $$ph518 = 0, $$ph520524 = 0, $$phi$trans$insert = 0, $$pre$i$i$i = 0, $$pre$i$i$i$i = 0, $$pre$i$i$i$i372 = 0, $$pre$i$i$i$i436 = 0, $$pre$i$i$i$i466 = 0, $$pre$i$i$i87 = 0, $$pre$phi511Z2D = 0, $$pre$phiZ2D = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $1015 = 0, $1016 = 0, $1017 = 0, $1018 = 0, $1022 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0, $103 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1043 = 0, $1047 = 0, $1050 = 0, $1053 = 0, $106 = 0, $1069 = 0, $107 = 0, $1070 = 0, $1071 = 0, $1072 = 0, $1076 = 0, $1079 = 0, $1081 = 0, $109 = 0, $1091 = 0, $1093 = 0, $11 = 0, $110 = 0, $1103 = 0, $1106 = 0, $1108 = 0, $112 = 0, $1120 = 0, $1122 = 0, $1129 = 0, $113 = 0, $1130 = 0, $1131 = 0, $1132 = 0, $1136 = 0, $1138 = 0, $1141 = 0, $1142 = 0, $1145 = 0, $1146 = 0, $1148 = 0, $1149 = 0, $1151 = 0, $1152 = 0, $1154 = 0, $1155 = 0, $1159 = 0, $1161 = 0, $1162 = 0, $1165 = 0, $1172 = 0, $1174 = 0, $1177 = 0, $1181 = 0, $1184 = 0, $1189 = 0, $1190 = 0, $1193 = 0, $1194 = 0, $1196 = 0, $1197 = 0, $12 = 0, $1206 = 0, $1209 = 0, $121 = 0, $1219 = 0, $122 = 0, $1220 = 0, $1222 = 0, $1223 = 0, $1225 = 0, $1226 = 0, $1231 = 0, $1232 = 0, $1234 = 0, $1235 = 0, $1237 = 0, $1238 = 0, $1240 = 0, $1244 = 0, $1245 = 0, $1247 = 0, $1251 = 0, $1253 = 0, $1254 = 0, $1257 = 0, $126 = 0, $1260 = 0, $1261 = 0, $1269 = 0, $1270 = 0, $1272 = 0, $1274 = 0, $1275 = 0, $128 = 0, $1283 = 0, $1284 = 0, $1285 = 0, $1286 = 0, $129 = 0, $1291 = 0, $1293 = 0, $13 = 0, $1306 = 0, $1307 = 0, $1309 = 0, $1311 = 0, $1313 = 0, $1314 = 0, $132 = 0, $1322 = 0, $1323 = 0, $1324 = 0, $1325 = 0, $1328 = 0, $1329 = 0, $1330 = 0, $1331 = 0, $1335 = 0, $1336 = 0, $1339 = 0, $1341 = 0, $1351 = 0, $1354 = 0, $1357 = 0, $1359 = 0, $1369 = 0, $1372 = 0, $1375 = 0, $1376 = 0, $1377 = 0, $1379 = 0, $1380 = 0, $1381 = 0, $1383 = 0, $1384 = 0, $1385 = 0, $1386 = 0, $1387 = 0, $139 = 0, $1398 = 0, $1399 = 0, $14 = 0, $1401 = 0, $1403 = 0, $1404 = 0, $141 = 0, $1412 = 0, $1413 = 0, $1414 = 0, $1415 = 0, $1417 = 0, $1418 = 0, $1421 = 0, $1424 = 0, $1426 = 0, $1436 = 0, $1439 = 0, $144 = 0, $1442 = 0, $1443 = 0, $1445 = 0, $1446 = 0, $1448 = 0, $1449 = 0, $1451 = 0, $1452 = 0, $1463 = 0, $1464 = 0, $1466 = 0, $1468 = 0, $1469 = 0, $1477 = 0, $1478 = 0, $1479 = 0, $148 = 0, $1480 = 0, $1482 = 0, $1483 = 0, $1486 = 0, $1489 = 0, $1491 = 0, $15 = 0, $1501 = 0, $1504 = 0, $151 = 0, $1513 = 0, $1514 = 0, $1523 = 0, $1524 = 0, $1528 = 0, $1530 = 0, $1531 = 0, $1534 = 0, $1543 = 0, $1544 = 0, $1548 = 0, $1550 = 0, $1551 = 0, $1554 = 0, $156 = 0, $1569 = 0, $157 = 0, $1572 = 0, $1578 = 0, $1579 = 0, $1581 = 0, $1585 = 0, $1591 = 0, $1593 = 0, $16 = 0, $160 = 0, $1603 = 0, $1604 = 0, $1605 = 0, $1609 = 0, $161 = 0, $1612 = 0, $1614 = 0, $1623 = 0, $1624 = 0, $1625 = 0, $1626 = 0, $163 = 0, $1632 = 0, $1634 = 0, $164 = 0, $1641 = 0, $1642 = 0, $1643 = 0, $1644 = 0, $1648 = 0, $1650 = 0, $1653 = 0, $1654 = 0, $1662 = 0, $1665 = 0, $1669 = 0, $1671 = 0, $1672 = 0, $1675 = 0, $1685 = 0, $1687 = 0, $1693 = 0, $1695 = 0, $1696 = 0, $1699 = 0, $17 = 0, $1702 = 0, $1703 = 0, $1705 = 0, $1712 = 0, $1713 = 0, $1714 = 0, $1715 = 0, $1719 = 0, $1721 = 0, $1724 = 0, $1725 = 0, $173 = 0, $1734 = 0, $1735 = 0, $1739 = 0, $1741 = 0, $1742 = 0, $1746 = 0, $1747 = 0, $1748 = 0, $1749 = 0, $1750 = 0, $1751 = 0, $176 = 0, $18 = 0, $187 = 0, $188 = 0, $19 = 0, $192 = 0, $194 = 0, $195 = 0, $198 = 0, $2 = 0, $20 = 0, $205 = 0, $207 = 0, $21 = 0, $210 = 0, $214 = 0, $217 = 0, $22 = 0, $222 = 0, $223 = 0, $226 = 0, $227 = 0, $229 = 0, $23 = 0, $230 = 0, $239 = 0, $24 = 0, $242 = 0, $25 = 0, $256 = 0, $257 = 0, $259 = 0, $26 = 0, $261 = 0, $262 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $275 = 0, $276 = 0, $279 = 0, $28 = 0, $282 = 0, $284 = 0, $29 = 0, $294 = 0, $297 = 0, $3 = 0, $30 = 0, $305 = 0, $306 = 0, $31 = 0, $310 = 0, $311 = 0, $314 = 0, $315 = 0, $317 = 0, $32 = 0, $327 = 0, $33 = 0, $330 = 0, $335 = 0, $337 = 0, $34 = 0, $340 = 0, $344 = 0, $347 = 0, $35 = 0, $352 = 0, $353 = 0, $356 = 0, $357 = 0, $359 = 0, $36 = 0, $360 = 0, $369 = 0, $37 = 0, $372 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $384 = 0, $388 = 0, $39 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $396 = 0, $398 = 0, $4 = 0, $40 = 0, $402 = 0, $41 = 0, $412 = 0, $416 = 0, $417 = 0, $419 = 0, $42 = 0, $420 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $436 = 0, $438 = 0, $44 = 0, $442 = 0, $443 = 0, $445 = 0, $449 = 0, $45 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $464 = 0, $466 = 0, $469 = 0, $47 = 0, $470 = 0, $473 = 0, $477 = 0, $48 = 0, $482 = 0, $483 = 0, $49 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $496 = 0, $497 = 0, $5 = 0, $50 = 0, $500 = 0, $503 = 0, $505 = 0, $51 = 0, $515 = 0, $518 = 0, $52 = 0, $524 = 0, $525 = 0, $528 = 0, $529 = 0, $53 = 0, $531 = 0, $534 = 0, $539 = 0, $54 = 0, $541 = 0, $55 = 0, $551 = 0, $558 = 0, $56 = 0, $560 = 0, $563 = 0, $567 = 0, $57 = 0, $570 = 0, $575 = 0, $576 = 0, $579 = 0, $58 = 0, $580 = 0, $582 = 0, $583 = 0, $59 = 0, $592 = 0, $595 = 0, $6 = 0, $60 = 0, $606 = 0, $607 = 0, $609 = 0, $61 = 0, $611 = 0, $612 = 0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0, $625 = 0, $626 = 0, $629 = 0, $63 = 0, $632 = 0, $634 = 0, $64 = 0, $644 = 0, $647 = 0, $65 = 0, $650 = 0, $651 = 0, $653 = 0, $654 = 0, $657 = 0, $658 = 0, $66 = 0, $660 = 0, $663 = 0, $668 = 0, $67 = 0, $670 = 0, $68 = 0, $680 = 0, $687 = 0, $689 = 0, $69 = 0, $692 = 0, $696 = 0, $699 = 0, $7 = 0, $70 = 0, $704 = 0, $705 = 0, $708 = 0, $709 = 0, $71 = 0, $711 = 0, $712 = 0, $72 = 0, $721 = 0, $724 = 0, $73 = 0, $736 = 0, $737 = 0, $739 = 0, $74 = 0, $741 = 0, $742 = 0, $75 = 0, $750 = 0, $751 = 0, $752 = 0, $753 = 0, $756 = 0, $758 = 0, $76 = 0, $77 = 0, $774 = 0, $775 = 0, $777 = 0, $779 = 0, $78 = 0, $780 = 0, $788 = 0, $789 = 0, $79 = 0, $790 = 0, $791 = 0, $794 = 0, $796 = 0, $8 = 0, $80 = 0, $806 = 0, $807 = 0, $809 = 0, $81 = 0, $810 = 0, $815 = 0, $816 = 0, $818 = 0, $819 = 0, $821 = 0, $822 = 0, $827 = 0, $828 = 0, $83 = 0, $830 = 0, $831 = 0, $836 = 0, $837 = 0, $839 = 0, $841 = 0, $842 = 0, $85 = 0, $850 = 0, $851 = 0, $852 = 0, $853 = 0, $857 = 0, $858 = 0, $861 = 0, $863 = 0, $873 = 0, $876 = 0, $879 = 0, $880 = 0, $881 = 0, $886 = 0, $887 = 0, $889 = 0, $890 = 0, $892 = 0, $893 = 0, $895 = 0, $896 = 0, $9 = 0, $90 = 0, $901 = 0, $902 = 0, $904 = 0, $905 = 0, $907 = 0, $908 = 0, $910 = 0, $911 = 0, $913 = 0, $917 = 0, $918 = 0, $920 = 0, $924 = 0, $926 = 0, $927 = 0, $930 = 0, $936 = 0, $940 = 0, $943 = 0, $945 = 0, $946 = 0, $947 = 0, $954 = 0, $955 = 0, $961 = 0, $976 = 0, $977 = 0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $989 = 0, $993 = 0, $996 = 0, $999 = 0, $has_expr_list$0$off0$i = 0, $has_expr_list$0$off0$i$lcssa = 0, $has_init$0$off0$i513 = 0, $k$0$i621 = 0, $k$0$i622 = 0, $k1$0$i618 = 0, $op1 = 0, $op18 = 0, $op2 = 0, $op27 = 0, $op3 = 0, $parsed_gs$0$off0 = 0, $parsed_gs$0$off0$i = 0, $phitmp$i$i$i$i$i$i$i273 = 0, $phitmp$i$i$i$i$i$i32$i = 0, $phitmp$i2$i$i$i$i$i$i276 = 0, $phitmp$i2$i$i$i$i$i35$i = 0, $t$0 = 0, $t$0$i = 0, $t$0$i267 = 0, $t$0$i349567 = 0, $t$0$i390$lcssa = 0, $t$0$i390556 = 0, $t$1$i = 0, $t$1$i$lcssa = 0, $t$1$i350 = 0, $t$2$i = 0, $t$2$i351 = 0, $t$3$i512 = 0, dest = 0, label = 0, sp = 0, src = 0, stop = 0, $t$1$i$looptemp = 0, $t$2$i$looptemp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1168 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $0 = sp + 1144 | 0;
 $1 = sp + 1120 | 0;
 $2 = sp + 1096 | 0;
 $3 = sp + 1084 | 0;
 $4 = sp + 1072 | 0;
 $5 = sp + 1048 | 0;
 $6 = sp + 1032 | 0;
 $7 = sp + 900 | 0;
 $8 = sp + 632 | 0;
 $9 = sp + 620 | 0;
 $10 = sp + 584 | 0;
 $11 = sp + 560 | 0;
 $12 = sp + 524 | 0;
 $13 = sp + 1020 | 0;
 $14 = sp + 1008 | 0;
 $15 = sp + 996 | 0;
 $16 = sp + 984 | 0;
 $17 = sp + 972 | 0;
 $18 = sp + 960 | 0;
 $19 = sp + 948 | 0;
 $20 = sp + 936 | 0;
 $21 = sp + 924 | 0;
 $22 = sp + 912 | 0;
 $23 = sp + 888 | 0;
 $24 = sp + 876 | 0;
 $25 = sp + 864 | 0;
 $26 = sp + 852 | 0;
 $27 = sp + 840 | 0;
 $28 = sp + 828 | 0;
 $29 = sp + 816 | 0;
 $30 = sp + 804 | 0;
 $31 = sp + 792 | 0;
 $32 = sp + 780 | 0;
 $33 = sp + 768 | 0;
 $34 = sp + 756 | 0;
 $35 = sp + 744 | 0;
 $op2 = sp + 732 | 0;
 $op1 = sp + 720 | 0;
 $36 = sp + 696 | 0;
 $37 = sp + 680 | 0;
 $38 = sp + 668 | 0;
 $39 = sp + 656 | 0;
 $40 = sp + 644 | 0;
 $41 = sp + 608 | 0;
 $42 = sp + 596 | 0;
 $43 = sp + 548 | 0;
 $44 = sp + 536 | 0;
 $45 = sp + 512 | 0;
 $46 = sp + 500 | 0;
 $47 = sp + 488 | 0;
 $48 = sp + 476 | 0;
 $49 = sp + 464 | 0;
 $50 = sp + 440 | 0;
 $51 = sp + 424 | 0;
 $52 = sp + 412 | 0;
 $53 = sp + 400 | 0;
 $54 = sp + 388 | 0;
 $55 = sp + 376 | 0;
 $56 = sp + 364 | 0;
 $57 = sp + 352 | 0;
 $58 = sp + 340 | 0;
 $59 = sp + 328 | 0;
 $60 = sp + 316 | 0;
 $61 = sp + 304 | 0;
 $62 = sp + 292 | 0;
 $63 = sp + 280 | 0;
 $64 = sp + 256 | 0;
 $65 = sp + 240 | 0;
 $66 = sp + 228 | 0;
 $67 = sp + 216 | 0;
 $68 = sp + 204 | 0;
 $op3 = sp + 192 | 0;
 $op27 = sp + 180 | 0;
 $op18 = sp + 168 | 0;
 $69 = sp + 144 | 0;
 $70 = sp + 132 | 0;
 $71 = sp + 120 | 0;
 $72 = sp + 108 | 0;
 $73 = sp + 96 | 0;
 $74 = sp + 84 | 0;
 $75 = sp + 72 | 0;
 $76 = sp + 60 | 0;
 $77 = sp + 48 | 0;
 $78 = sp + 36 | 0;
 $79 = sp + 24 | 0;
 $80 = sp;
 $81 = $last;
 $83 = $81 - $first | 0;
 L1 : do if (($83 | 0) > 1) {
  $85 = ($83 | 0) > 3;
  if ($85) if ((HEAP8[$first >> 0] | 0) == 103) {
   $90 = (HEAP8[$first + 1 >> 0] | 0) == 115;
   $parsed_gs$0$off0 = $90;
   $t$0 = $90 ? $first + 2 | 0 : $first;
  } else {
   $parsed_gs$0$off0 = 0;
   $t$0 = $first;
  } else {
   $parsed_gs$0$off0 = 0;
   $t$0 = $first;
  }
  do switch (HEAP8[$t$0 >> 0] | 0) {
  case 76:
   {
    $$0 = __ZN10__cxxabiv112_GLOBAL__N_118parse_expr_primaryINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
    break L1;
    break;
   }
  case 84:
   {
    $$0 = __ZN10__cxxabiv112_GLOBAL__N_120parse_template_paramINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
    break L1;
    break;
   }
  case 102:
   {
    $$0 = __ZN10__cxxabiv112_GLOBAL__N_120parse_function_paramINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
    break L1;
    break;
   }
  case 97:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 97:
     {
      $100 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($13, 12743, 2);
      $101 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($100, $last, $13, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($13);
      $$0 = ($101 | 0) == ($100 | 0) ? $first : $101;
      break L1;
      break;
     }
    case 100:
     {
      $103 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($14, 12764, 1);
      $104 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($103, $last, $14, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($14);
      $$0 = ($104 | 0) == ($103 | 0) ? $first : $104;
      break L1;
      break;
     }
    case 110:
     {
      $106 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($15, 12764, 1);
      $107 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($106, $last, $15, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($15);
      $$0 = ($107 | 0) == ($106 | 0) ? $first : $107;
      break L1;
      break;
     }
    case 78:
     {
      $109 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($16, 13889, 2);
      $110 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($109, $last, $16, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($16);
      $$0 = ($110 | 0) == ($109 | 0) ? $first : $110;
      break L1;
      break;
     }
    case 83:
     {
      $112 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($17, 13892, 1);
      $113 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($112, $last, $17, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($17);
      $$0 = ($113 | 0) == ($112 | 0) ? $first : $113;
      break L1;
      break;
     }
    case 116:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 97) if ((HEAP8[$first + 1 >> 0] | 0) == 116) {
       $121 = $first + 2 | 0;
       $122 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($121, $last, $db) | 0;
       if (($122 | 0) == ($121 | 0)) $$03$i486 = $first; else {
        $126 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($126 | 0)) $$03$i486 = $first; else {
         $128 = $126 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $128);
         $129 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($2, 0, 13894) | 0;
         HEAP32[$1 >> 2] = HEAP32[$129 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$129 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$129 + 8 >> 2];
         HEAP32[$129 >> 2] = 0;
         HEAP32[$129 + 4 >> 2] = 0;
         HEAP32[$129 + 8 >> 2] = 0;
         $132 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1, 12619) | 0;
         HEAP32[$0 >> 2] = HEAP32[$132 >> 2];
         HEAP32[$0 + 4 >> 2] = HEAP32[$132 + 4 >> 2];
         HEAP32[$0 + 8 >> 2] = HEAP32[$132 + 8 >> 2];
         HEAP32[$132 >> 2] = 0;
         HEAP32[$132 + 4 >> 2] = 0;
         HEAP32[$132 + 8 >> 2] = 0;
         do if (!(HEAP8[$128 >> 0] & 1)) {
          HEAP8[$128 + 1 >> 0] = 0;
          HEAP8[$128 >> 0] = 0;
         } else {
          $139 = $126 + -16 | 0;
          HEAP8[HEAP32[$139 >> 2] >> 0] = 0;
          $141 = $126 + -20 | 0;
          HEAP32[$141 >> 2] = 0;
          $$pre$i$i$i$i466 = HEAP8[$128 >> 0] | 0;
          if (!($$pre$i$i$i$i466 & 1)) {
           $148 = $$pre$i$i$i$i466;
           $157 = 10;
          } else {
           $144 = HEAP32[$128 >> 2] | 0;
           $148 = $144 & 255;
           $157 = ($144 & -2) + -1 | 0;
          }
          if (!($148 & 1)) {
           $151 = ($148 & 255) >>> 1;
           if (($148 & 255) < 22) {
            $156 = 10;
            $1746 = 1;
            $176 = $151;
           } else {
            $156 = ($151 + 16 & 240) + -1 | 0;
            $1746 = 1;
            $176 = $151;
           }
          } else {
           $156 = 10;
           $1746 = 0;
           $176 = 0;
          }
          if (($156 | 0) != ($157 | 0)) {
           if (($156 | 0) == 10) {
            $163 = $128 + 1 | 0;
            $164 = HEAP32[$139 >> 2] | 0;
            if ($1746) {
             _memcpy($163 | 0, $164 | 0, (($148 & 255) >>> 1) + 1 | 0) | 0;
             _free($164);
            } else {
             HEAP8[$163 >> 0] = HEAP8[$164 >> 0] | 0;
             _free($164);
            }
            HEAP8[$128 >> 0] = $176 << 1;
            break;
           }
           $160 = $156 + 1 | 0;
           $161 = _malloc($160) | 0;
           if (!($156 >>> 0 <= $157 >>> 0 & ($161 | 0) == 0)) {
            if ($1746) _memcpy($161 | 0, $128 + 1 | 0, (($148 & 255) >>> 1) + 1 | 0) | 0; else {
             $173 = HEAP32[$139 >> 2] | 0;
             HEAP8[$161 >> 0] = HEAP8[$173 >> 0] | 0;
             _free($173);
            }
            HEAP32[$128 >> 2] = $160 | 1;
            HEAP32[$141 >> 2] = $176;
            HEAP32[$139 >> 2] = $161;
           }
          }
         } while (0);
         HEAP32[$128 >> 2] = HEAP32[$0 >> 2];
         HEAP32[$128 + 4 >> 2] = HEAP32[$0 + 4 >> 2];
         HEAP32[$128 + 8 >> 2] = HEAP32[$0 + 8 >> 2];
         HEAP32[$0 >> 2] = 0;
         HEAP32[$0 + 4 >> 2] = 0;
         HEAP32[$0 + 8 >> 2] = 0;
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         $$03$i486 = $122;
        }
       }
      } else $$03$i486 = $first; else $$03$i486 = $first; else $$03$i486 = $first;
      $$0 = $$03$i486;
      break L1;
      break;
     }
    case 122:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 97) if ((HEAP8[$first + 1 >> 0] | 0) == 122) {
       $187 = $first + 2 | 0;
       $188 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($187, $last, $db) | 0;
       if (($188 | 0) == ($187 | 0)) $$03$i456 = $first; else {
        $192 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($192 | 0)) $$03$i456 = $first; else {
         $194 = $192 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $194);
         $195 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($2, 0, 13894) | 0;
         HEAP32[$1 >> 2] = HEAP32[$195 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$195 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$195 + 8 >> 2];
         HEAP32[$195 >> 2] = 0;
         HEAP32[$195 + 4 >> 2] = 0;
         HEAP32[$195 + 8 >> 2] = 0;
         $198 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1, 12619) | 0;
         HEAP32[$0 >> 2] = HEAP32[$198 >> 2];
         HEAP32[$0 + 4 >> 2] = HEAP32[$198 + 4 >> 2];
         HEAP32[$0 + 8 >> 2] = HEAP32[$198 + 8 >> 2];
         HEAP32[$198 >> 2] = 0;
         HEAP32[$198 + 4 >> 2] = 0;
         HEAP32[$198 + 8 >> 2] = 0;
         do if (!(HEAP8[$194 >> 0] & 1)) {
          HEAP8[$194 + 1 >> 0] = 0;
          HEAP8[$194 >> 0] = 0;
         } else {
          $205 = $192 + -16 | 0;
          HEAP8[HEAP32[$205 >> 2] >> 0] = 0;
          $207 = $192 + -20 | 0;
          HEAP32[$207 >> 2] = 0;
          $$pre$i$i$i$i436 = HEAP8[$194 >> 0] | 0;
          if (!($$pre$i$i$i$i436 & 1)) {
           $214 = $$pre$i$i$i$i436;
           $223 = 10;
          } else {
           $210 = HEAP32[$194 >> 2] | 0;
           $214 = $210 & 255;
           $223 = ($210 & -2) + -1 | 0;
          }
          if (!($214 & 1)) {
           $217 = ($214 & 255) >>> 1;
           if (($214 & 255) < 22) {
            $1747 = 1;
            $222 = 10;
            $242 = $217;
           } else {
            $1747 = 1;
            $222 = ($217 + 16 & 240) + -1 | 0;
            $242 = $217;
           }
          } else {
           $1747 = 0;
           $222 = 10;
           $242 = 0;
          }
          if (($222 | 0) != ($223 | 0)) {
           if (($222 | 0) == 10) {
            $229 = $194 + 1 | 0;
            $230 = HEAP32[$205 >> 2] | 0;
            if ($1747) {
             _memcpy($229 | 0, $230 | 0, (($214 & 255) >>> 1) + 1 | 0) | 0;
             _free($230);
            } else {
             HEAP8[$229 >> 0] = HEAP8[$230 >> 0] | 0;
             _free($230);
            }
            HEAP8[$194 >> 0] = $242 << 1;
            break;
           }
           $226 = $222 + 1 | 0;
           $227 = _malloc($226) | 0;
           if (!($222 >>> 0 <= $223 >>> 0 & ($227 | 0) == 0)) {
            if ($1747) _memcpy($227 | 0, $194 + 1 | 0, (($214 & 255) >>> 1) + 1 | 0) | 0; else {
             $239 = HEAP32[$205 >> 2] | 0;
             HEAP8[$227 >> 0] = HEAP8[$239 >> 0] | 0;
             _free($239);
            }
            HEAP32[$194 >> 2] = $226 | 1;
            HEAP32[$207 >> 2] = $242;
            HEAP32[$205 >> 2] = $227;
           }
          }
         } while (0);
         HEAP32[$194 >> 2] = HEAP32[$0 >> 2];
         HEAP32[$194 + 4 >> 2] = HEAP32[$0 + 4 >> 2];
         HEAP32[$194 + 8 >> 2] = HEAP32[$0 + 8 >> 2];
         HEAP32[$0 >> 2] = 0;
         HEAP32[$0 + 4 >> 2] = 0;
         HEAP32[$0 + 8 >> 2] = 0;
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         $$03$i456 = $188;
        }
       }
      } else $$03$i456 = $first; else $$03$i456 = $first; else $$03$i456 = $first;
      $$0 = $$03$i456;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 99:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 99:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 99) if ((HEAP8[$first + 1 >> 0] | 0) == 99) {
       $256 = $first + 2 | 0;
       $257 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($256, $last, $db) | 0;
       if (($257 | 0) == ($256 | 0)) $$06$i426 = $first; else {
        $259 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($257, $last, $db) | 0;
        if (($259 | 0) == ($257 | 0)) $$06$i426 = $first; else {
         $261 = $db + 4 | 0;
         $262 = HEAP32[$261 >> 2] | 0;
         if ((($262 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$06$i426 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $262 + -24 | 0);
          $270 = HEAP32[$261 >> 2] | 0;
          $271 = $270 + -24 | 0;
          $273 = $270;
          do {
           $272 = $273 + -24 | 0;
           HEAP32[$261 >> 2] = $272;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($272);
           $273 = HEAP32[$261 >> 2] | 0;
          } while (($273 | 0) != ($271 | 0));
          $275 = $270 + -48 | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($6, $275);
          $276 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($6, 0, 13904) | 0;
          HEAP32[$5 >> 2] = HEAP32[$276 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$276 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$276 + 8 >> 2];
          HEAP32[$276 >> 2] = 0;
          HEAP32[$276 + 4 >> 2] = 0;
          HEAP32[$276 + 8 >> 2] = 0;
          $279 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($5, 13916) | 0;
          HEAP32[$4 >> 2] = HEAP32[$279 >> 2];
          HEAP32[$4 + 4 >> 2] = HEAP32[$279 + 4 >> 2];
          HEAP32[$4 + 8 >> 2] = HEAP32[$279 + 8 >> 2];
          HEAP32[$279 >> 2] = 0;
          HEAP32[$279 + 4 >> 2] = 0;
          HEAP32[$279 + 8 >> 2] = 0;
          $282 = HEAP8[$0 >> 0] | 0;
          $284 = ($282 & 1) == 0;
          $294 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($4, $284 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $284 ? ($282 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
          HEAP32[$3 >> 2] = HEAP32[$294 >> 2];
          HEAP32[$3 + 4 >> 2] = HEAP32[$294 + 4 >> 2];
          HEAP32[$3 + 8 >> 2] = HEAP32[$294 + 8 >> 2];
          HEAP32[$294 >> 2] = 0;
          HEAP32[$294 + 4 >> 2] = 0;
          HEAP32[$294 + 8 >> 2] = 0;
          $297 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($3, 12619) | 0;
          HEAP32[$2 >> 2] = HEAP32[$297 >> 2];
          HEAP32[$2 + 4 >> 2] = HEAP32[$297 + 4 >> 2];
          HEAP32[$2 + 8 >> 2] = HEAP32[$297 + 8 >> 2];
          HEAP32[$297 >> 2] = 0;
          HEAP32[$297 + 4 >> 2] = 0;
          HEAP32[$297 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($275, $1);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$06$i426 = $259;
         }
        }
       }
      } else $$06$i426 = $first; else $$06$i426 = $first; else $$06$i426 = $first;
      $$0 = $$06$i426;
      break L1;
      break;
     }
    case 108:
     {
      L97 : do if ($85) if ((HEAP8[$first >> 0] | 0) == 99) if ((HEAP8[$first + 1 >> 0] | 0) == 108) {
       $305 = $first + 2 | 0;
       $306 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($305, $last, $db) | 0;
       if (($306 | 0) == ($305 | 0) | ($306 | 0) == ($last | 0)) $$2$i398 = $first; else {
        $310 = $db + 4 | 0;
        $311 = HEAP32[$310 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($311 | 0)) $$2$i398 = $first; else {
         $314 = $311 + -12 | 0;
         $315 = HEAP8[$314 >> 0] | 0;
         $317 = ($315 & 1) == 0;
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($311 + -24 | 0, $317 ? $314 + 1 | 0 : HEAP32[$311 + -4 >> 2] | 0, $317 ? ($315 & 255) >>> 1 : HEAP32[$311 + -8 >> 2] | 0) | 0;
         $327 = HEAP32[$310 >> 2] | 0;
         HEAP32[$0 >> 2] = 0;
         HEAP32[$0 + 4 >> 2] = 0;
         HEAP32[$0 + 8 >> 2] = 0;
         $330 = $327 + -12 | 0;
         do if (!(HEAP8[$330 >> 0] & 1)) {
          HEAP8[$330 + 1 >> 0] = 0;
          HEAP8[$330 >> 0] = 0;
         } else {
          $335 = $327 + -4 | 0;
          HEAP8[HEAP32[$335 >> 2] >> 0] = 0;
          $337 = $327 + -8 | 0;
          HEAP32[$337 >> 2] = 0;
          $$pre$i$i$i$i372 = HEAP8[$330 >> 0] | 0;
          if (!($$pre$i$i$i$i372 & 1)) {
           $344 = $$pre$i$i$i$i372;
           $353 = 10;
          } else {
           $340 = HEAP32[$330 >> 2] | 0;
           $344 = $340 & 255;
           $353 = ($340 & -2) + -1 | 0;
          }
          if (!($344 & 1)) {
           $347 = ($344 & 255) >>> 1;
           if (($344 & 255) < 22) {
            $1748 = 1;
            $352 = 10;
            $372 = $347;
           } else {
            $1748 = 1;
            $352 = ($347 + 16 & 240) + -1 | 0;
            $372 = $347;
           }
          } else {
           $1748 = 0;
           $352 = 10;
           $372 = 0;
          }
          if (($352 | 0) != ($353 | 0)) {
           if (($352 | 0) == 10) {
            $359 = $330 + 1 | 0;
            $360 = HEAP32[$335 >> 2] | 0;
            if ($1748) {
             _memcpy($359 | 0, $360 | 0, (($344 & 255) >>> 1) + 1 | 0) | 0;
             _free($360);
            } else {
             HEAP8[$359 >> 0] = HEAP8[$360 >> 0] | 0;
             _free($360);
            }
            HEAP8[$330 >> 0] = $372 << 1;
            break;
           }
           $356 = $352 + 1 | 0;
           $357 = _malloc($356) | 0;
           if (!($352 >>> 0 <= $353 >>> 0 & ($357 | 0) == 0)) {
            if ($1748) _memcpy($357 | 0, $330 + 1 | 0, (($344 & 255) >>> 1) + 1 | 0) | 0; else {
             $369 = HEAP32[$335 >> 2] | 0;
             HEAP8[$357 >> 0] = HEAP8[$369 >> 0] | 0;
             _free($369);
            }
            HEAP32[$330 >> 2] = $356 | 1;
            HEAP32[$337 >> 2] = $372;
            HEAP32[$335 >> 2] = $357;
           }
          }
         } while (0);
         HEAP32[$330 >> 2] = HEAP32[$0 >> 2];
         HEAP32[$330 + 4 >> 2] = HEAP32[$0 + 4 >> 2];
         HEAP32[$330 + 8 >> 2] = HEAP32[$0 + 8 >> 2];
         HEAP32[$0 >> 2] = 0;
         HEAP32[$0 + 4 >> 2] = 0;
         HEAP32[$0 + 8 >> 2] = 0;
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc((HEAP32[$310 >> 2] | 0) + -24 | 0, 12714) | 0;
         $379 = $1 + 4 | 0;
         $380 = $1 + 8 | 0;
         $381 = $1 + 1 | 0;
         L127 : do if ((HEAP8[$306 >> 0] | 0) == 69) $t$0$i390$lcssa = $306; else {
          $t$0$i390556 = $306;
          while (1) {
           $384 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($t$0$i390556, $last, $db) | 0;
           if (($384 | 0) == ($t$0$i390556 | 0) | ($384 | 0) == ($last | 0)) {
            $$2$i398 = $first;
            break L97;
           }
           $388 = HEAP32[$310 >> 2] | 0;
           if ((HEAP32[$db >> 2] | 0) == ($388 | 0)) {
            $$2$i398 = $first;
            break L97;
           }
           __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($1, $388 + -24 | 0);
           $391 = HEAP32[$310 >> 2] | 0;
           $392 = $391 + -24 | 0;
           $394 = $391;
           do {
            $393 = $394 + -24 | 0;
            HEAP32[$310 >> 2] = $393;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($393);
            $394 = HEAP32[$310 >> 2] | 0;
           } while (($394 | 0) != ($392 | 0));
           $396 = HEAP8[$1 >> 0] | 0;
           $398 = ($396 & 1) == 0;
           $402 = $398 ? ($396 & 255) >>> 1 : HEAP32[$379 >> 2] | 0;
           if ($402) {
            if ((HEAP32[$db >> 2] | 0) == ($392 | 0)) break;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($391 + -48 | 0, $398 ? $381 : HEAP32[$380 >> 2] | 0, $402) | 0;
           }
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
           if ((HEAP8[$384 >> 0] | 0) == 69) {
            $t$0$i390$lcssa = $384;
            break L127;
           } else $t$0$i390556 = $384;
          }
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
          $$2$i398 = $first;
          break L97;
         } while (0);
         $412 = HEAP32[$310 >> 2] | 0;
         if ((HEAP32[$db >> 2] | 0) == ($412 | 0)) $$2$i398 = $first; else {
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($412 + -24 | 0, 12619) | 0;
          $$2$i398 = $t$0$i390$lcssa + 1 | 0;
         }
        }
       }
      } else $$2$i398 = $first; else $$2$i398 = $first; else $$2$i398 = $first; while (0);
      $$0 = $$2$i398;
      break L1;
      break;
     }
    case 109:
     {
      $416 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($18, 13919, 1);
      $417 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($416, $last, $18, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($18);
      $$0 = ($417 | 0) == ($416 | 0) ? $first : $417;
      break L1;
      break;
     }
    case 111:
     {
      $419 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($19, 12928, 1);
      $420 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($419, $last, $19, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($19);
      $$0 = ($420 | 0) == ($419 | 0) ? $first : $420;
      break L1;
      break;
     }
    case 118:
     {
      L146 : do if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 99) if ((HEAP8[$first + 1 >> 0] | 0) == 118) {
       $428 = $db + 63 | 0;
       $429 = HEAP8[$428 >> 0] | 0;
       HEAP8[$428 >> 0] = 0;
       $430 = $first + 2 | 0;
       $431 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($430, $last, $db) | 0;
       HEAP8[$428 >> 0] = $429;
       if (($431 | 0) == ($430 | 0) | ($431 | 0) == ($last | 0)) $$311$i = $first; else {
        if ((HEAP8[$431 >> 0] | 0) == 95) {
         $438 = $431 + 1 | 0;
         if (($438 | 0) == ($last | 0)) {
          $$311$i = $first;
          break;
         }
         do if ((HEAP8[$438 >> 0] | 0) == 69) {
          $442 = $db + 4 | 0;
          $443 = HEAP32[$442 >> 2] | 0;
          $445 = HEAP32[$db + 8 >> 2] | 0;
          if ($443 >>> 0 < $445 >>> 0) {
           HEAP32[$443 >> 2] = 0;
           HEAP32[$443 + 4 >> 2] = 0;
           HEAP32[$443 + 8 >> 2] = 0;
           HEAP32[$443 + 12 >> 2] = 0;
           HEAP32[$443 + 16 >> 2] = 0;
           HEAP32[$443 + 20 >> 2] = 0;
           HEAP32[$443 >> 2] = 0;
           HEAP32[$443 + 4 >> 2] = 0;
           HEAP32[$443 + 8 >> 2] = 0;
           $449 = $443 + 12 | 0;
           HEAP32[$449 >> 2] = 0;
           HEAP32[$449 + 4 >> 2] = 0;
           HEAP32[$449 + 8 >> 2] = 0;
           HEAP32[$442 >> 2] = (HEAP32[$442 >> 2] | 0) + 24;
           $t$1$i350 = $438;
           break;
          }
          $457 = HEAP32[$db >> 2] | 0;
          $458 = $443 - $457 | 0;
          $459 = ($458 | 0) / 24 | 0;
          $460 = $459 + 1 | 0;
          if (($458 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
          $464 = ($445 - $457 | 0) / 24 | 0;
          if ($464 >>> 0 < 1073741823) {
           $466 = $464 << 1;
           $$0$i$i$i$i348 = $466 >>> 0 < $460 >>> 0 ? $460 : $466;
          } else $$0$i$i$i$i348 = 2147483647;
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i$i348, $459, $db + 12 | 0);
          $469 = $0 + 8 | 0;
          $470 = HEAP32[$469 >> 2] | 0;
          HEAP32[$470 >> 2] = 0;
          HEAP32[$470 + 4 >> 2] = 0;
          HEAP32[$470 + 8 >> 2] = 0;
          HEAP32[$470 + 12 >> 2] = 0;
          HEAP32[$470 + 16 >> 2] = 0;
          HEAP32[$470 + 20 >> 2] = 0;
          HEAP32[$470 >> 2] = 0;
          HEAP32[$470 + 4 >> 2] = 0;
          HEAP32[$470 + 8 >> 2] = 0;
          $473 = $470 + 12 | 0;
          HEAP32[$473 >> 2] = 0;
          HEAP32[$473 + 4 >> 2] = 0;
          HEAP32[$473 + 8 >> 2] = 0;
          HEAP32[$469 >> 2] = $470 + 24;
          __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
          $t$1$i350 = $438;
         } else {
          $t$0$i349567 = $438;
          while (1) {
           $477 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($t$0$i349567, $last, $db) | 0;
           if (($477 | 0) == ($t$0$i349567 | 0) | ($477 | 0) == ($last | 0)) {
            $$311$i = $first;
            break L146;
           }
           if ((HEAP8[$477 >> 0] | 0) == 69) {
            $t$1$i350 = $477;
            break;
           } else $t$0$i349567 = $477;
          }
         } while (0);
         $t$2$i351 = $t$1$i350 + 1 | 0;
        } else {
         $436 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($431, $last, $db) | 0;
         if (($436 | 0) == ($431 | 0)) {
          $$311$i = $first;
          break;
         } else $t$2$i351 = $436;
        }
        $482 = $db + 4 | 0;
        $483 = HEAP32[$482 >> 2] | 0;
        if ((($483 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$311$i = $first; else {
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($1, $483 + -24 | 0);
         $491 = HEAP32[$482 >> 2] | 0;
         $492 = $491 + -24 | 0;
         $494 = $491;
         do {
          $493 = $494 + -24 | 0;
          HEAP32[$482 >> 2] = $493;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($493);
          $494 = HEAP32[$482 >> 2] | 0;
         } while (($494 | 0) != ($492 | 0));
         $496 = $491 + -48 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($7, $496);
         $497 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($7, 0, 12714) | 0;
         HEAP32[$6 >> 2] = HEAP32[$497 >> 2];
         HEAP32[$6 + 4 >> 2] = HEAP32[$497 + 4 >> 2];
         HEAP32[$6 + 8 >> 2] = HEAP32[$497 + 8 >> 2];
         HEAP32[$497 >> 2] = 0;
         HEAP32[$497 + 4 >> 2] = 0;
         HEAP32[$497 + 8 >> 2] = 0;
         $500 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($6, 13921) | 0;
         HEAP32[$5 >> 2] = HEAP32[$500 >> 2];
         HEAP32[$5 + 4 >> 2] = HEAP32[$500 + 4 >> 2];
         HEAP32[$5 + 8 >> 2] = HEAP32[$500 + 8 >> 2];
         HEAP32[$500 >> 2] = 0;
         HEAP32[$500 + 4 >> 2] = 0;
         HEAP32[$500 + 8 >> 2] = 0;
         $503 = HEAP8[$1 >> 0] | 0;
         $505 = ($503 & 1) == 0;
         $515 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($5, $505 ? $1 + 1 | 0 : HEAP32[$1 + 8 >> 2] | 0, $505 ? ($503 & 255) >>> 1 : HEAP32[$1 + 4 >> 2] | 0) | 0;
         HEAP32[$4 >> 2] = HEAP32[$515 >> 2];
         HEAP32[$4 + 4 >> 2] = HEAP32[$515 + 4 >> 2];
         HEAP32[$4 + 8 >> 2] = HEAP32[$515 + 8 >> 2];
         HEAP32[$515 >> 2] = 0;
         HEAP32[$515 + 4 >> 2] = 0;
         HEAP32[$515 + 8 >> 2] = 0;
         $518 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($4, 12619) | 0;
         HEAP32[$3 >> 2] = HEAP32[$518 >> 2];
         HEAP32[$3 + 4 >> 2] = HEAP32[$518 + 4 >> 2];
         HEAP32[$3 + 8 >> 2] = HEAP32[$518 + 8 >> 2];
         HEAP32[$518 >> 2] = 0;
         HEAP32[$518 + 4 >> 2] = 0;
         HEAP32[$518 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($2, $3);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($496, $2);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($2);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         $$311$i = $t$2$i351;
        }
       }
      } else $$311$i = $first; else $$311$i = $first; else $$311$i = $first; while (0);
      $$0 = $$311$i;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 100:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 97:
     {
      $524 = $t$0 + 2 | 0;
      $525 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($524, $last, $db) | 0;
      if (($525 | 0) == ($524 | 0)) {
       $$0 = $first;
       break L1;
      }
      $528 = $db + 4 | 0;
      $529 = HEAP32[$528 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($529 | 0)) {
       $$0 = $first;
       break L1;
      }
      $531 = $529 + -24 | 0;
      if ($parsed_gs$0$off0) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($22, 12902, 2); else {
       HEAP32[$22 >> 2] = 0;
       HEAP32[$22 + 4 >> 2] = 0;
       HEAP32[$22 + 8 >> 2] = 0;
      }
      $534 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($22, 13924) | 0;
      HEAP32[$21 >> 2] = HEAP32[$534 >> 2];
      HEAP32[$21 + 4 >> 2] = HEAP32[$534 + 4 >> 2];
      HEAP32[$21 + 8 >> 2] = HEAP32[$534 + 8 >> 2];
      HEAP32[$534 >> 2] = 0;
      HEAP32[$534 + 4 >> 2] = 0;
      HEAP32[$534 + 8 >> 2] = 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($23, (HEAP32[$528 >> 2] | 0) + -24 | 0);
      $539 = HEAP8[$23 >> 0] | 0;
      $541 = ($539 & 1) == 0;
      $551 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($21, $541 ? $23 + 1 | 0 : HEAP32[$23 + 8 >> 2] | 0, $541 ? ($539 & 255) >>> 1 : HEAP32[$23 + 4 >> 2] | 0) | 0;
      HEAP32[$20 >> 2] = HEAP32[$551 >> 2];
      HEAP32[$20 + 4 >> 2] = HEAP32[$551 + 4 >> 2];
      HEAP32[$20 + 8 >> 2] = HEAP32[$551 + 8 >> 2];
      HEAP32[$551 >> 2] = 0;
      HEAP32[$551 + 4 >> 2] = 0;
      HEAP32[$551 + 8 >> 2] = 0;
      do if (!(HEAP8[$531 >> 0] & 1)) {
       HEAP8[$531 + 1 >> 0] = 0;
       HEAP8[$531 >> 0] = 0;
      } else {
       $558 = $529 + -16 | 0;
       HEAP8[HEAP32[$558 >> 2] >> 0] = 0;
       $560 = $529 + -20 | 0;
       HEAP32[$560 >> 2] = 0;
       $$pre$i$i$i = HEAP8[$531 >> 0] | 0;
       if (!($$pre$i$i$i & 1)) {
        $567 = $$pre$i$i$i;
        $576 = 10;
       } else {
        $563 = HEAP32[$531 >> 2] | 0;
        $567 = $563 & 255;
        $576 = ($563 & -2) + -1 | 0;
       }
       if (!($567 & 1)) {
        $570 = ($567 & 255) >>> 1;
        if (($567 & 255) < 22) {
         $1749 = 1;
         $575 = 10;
         $595 = $570;
        } else {
         $1749 = 1;
         $575 = ($570 + 16 & 240) + -1 | 0;
         $595 = $570;
        }
       } else {
        $1749 = 0;
        $575 = 10;
        $595 = 0;
       }
       if (($575 | 0) != ($576 | 0)) {
        if (($575 | 0) == 10) {
         $582 = $531 + 1 | 0;
         $583 = HEAP32[$558 >> 2] | 0;
         if ($1749) {
          _memcpy($582 | 0, $583 | 0, (($567 & 255) >>> 1) + 1 | 0) | 0;
          _free($583);
         } else {
          HEAP8[$582 >> 0] = HEAP8[$583 >> 0] | 0;
          _free($583);
         }
         HEAP8[$531 >> 0] = $595 << 1;
         break;
        }
        $579 = $575 + 1 | 0;
        $580 = _malloc($579) | 0;
        if (!($575 >>> 0 <= $576 >>> 0 & ($580 | 0) == 0)) {
         if ($1749) _memcpy($580 | 0, $531 + 1 | 0, (($567 & 255) >>> 1) + 1 | 0) | 0; else {
          $592 = HEAP32[$558 >> 2] | 0;
          HEAP8[$580 >> 0] = HEAP8[$592 >> 0] | 0;
          _free($592);
         }
         HEAP32[$531 >> 2] = $579 | 1;
         HEAP32[$560 >> 2] = $595;
         HEAP32[$558 >> 2] = $580;
        }
       }
      } while (0);
      HEAP32[$531 >> 2] = HEAP32[$20 >> 2];
      HEAP32[$531 + 4 >> 2] = HEAP32[$20 + 4 >> 2];
      HEAP32[$531 + 8 >> 2] = HEAP32[$20 + 8 >> 2];
      HEAP32[$20 >> 2] = 0;
      HEAP32[$20 + 4 >> 2] = 0;
      HEAP32[$20 + 8 >> 2] = 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($20);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($23);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($21);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($22);
      $$0 = $525;
      break L1;
      break;
     }
    case 99:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 100) if ((HEAP8[$first + 1 >> 0] | 0) == 99) {
       $606 = $first + 2 | 0;
       $607 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($606, $last, $db) | 0;
       if (($607 | 0) == ($606 | 0)) $$06$i345 = $first; else {
        $609 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($607, $last, $db) | 0;
        if (($609 | 0) == ($607 | 0)) $$06$i345 = $first; else {
         $611 = $db + 4 | 0;
         $612 = HEAP32[$611 >> 2] | 0;
         if ((($612 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$06$i345 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $612 + -24 | 0);
          $620 = HEAP32[$611 >> 2] | 0;
          $621 = $620 + -24 | 0;
          $623 = $620;
          do {
           $622 = $623 + -24 | 0;
           HEAP32[$611 >> 2] = $622;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($622);
           $623 = HEAP32[$611 >> 2] | 0;
          } while (($623 | 0) != ($621 | 0));
          $625 = $620 + -48 | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($6, $625);
          $626 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($6, 0, 13934) | 0;
          HEAP32[$5 >> 2] = HEAP32[$626 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$626 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$626 + 8 >> 2];
          HEAP32[$626 >> 2] = 0;
          HEAP32[$626 + 4 >> 2] = 0;
          HEAP32[$626 + 8 >> 2] = 0;
          $629 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($5, 13916) | 0;
          HEAP32[$4 >> 2] = HEAP32[$629 >> 2];
          HEAP32[$4 + 4 >> 2] = HEAP32[$629 + 4 >> 2];
          HEAP32[$4 + 8 >> 2] = HEAP32[$629 + 8 >> 2];
          HEAP32[$629 >> 2] = 0;
          HEAP32[$629 + 4 >> 2] = 0;
          HEAP32[$629 + 8 >> 2] = 0;
          $632 = HEAP8[$0 >> 0] | 0;
          $634 = ($632 & 1) == 0;
          $644 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($4, $634 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $634 ? ($632 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
          HEAP32[$3 >> 2] = HEAP32[$644 >> 2];
          HEAP32[$3 + 4 >> 2] = HEAP32[$644 + 4 >> 2];
          HEAP32[$3 + 8 >> 2] = HEAP32[$644 + 8 >> 2];
          HEAP32[$644 >> 2] = 0;
          HEAP32[$644 + 4 >> 2] = 0;
          HEAP32[$644 + 8 >> 2] = 0;
          $647 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($3, 12619) | 0;
          HEAP32[$2 >> 2] = HEAP32[$647 >> 2];
          HEAP32[$2 + 4 >> 2] = HEAP32[$647 + 4 >> 2];
          HEAP32[$2 + 8 >> 2] = HEAP32[$647 + 8 >> 2];
          HEAP32[$647 >> 2] = 0;
          HEAP32[$647 + 4 >> 2] = 0;
          HEAP32[$647 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($625, $1);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$06$i345 = $609;
         }
        }
       }
      } else $$06$i345 = $first; else $$06$i345 = $first; else $$06$i345 = $first;
      $$0 = $$06$i345;
      break L1;
      break;
     }
    case 101:
     {
      $650 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($24, 12759, 1);
      $651 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($650, $last, $24, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($24);
      $$0 = ($651 | 0) == ($650 | 0) ? $first : $651;
      break L1;
      break;
     }
    case 108:
     {
      $653 = $t$0 + 2 | 0;
      $654 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($653, $last, $db) | 0;
      if (($654 | 0) == ($653 | 0)) {
       $$0 = $first;
       break L1;
      }
      $657 = $db + 4 | 0;
      $658 = HEAP32[$657 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($658 | 0)) {
       $$0 = $first;
       break L1;
      }
      $660 = $658 + -24 | 0;
      if ($parsed_gs$0$off0) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($27, 12902, 2); else {
       HEAP32[$27 >> 2] = 0;
       HEAP32[$27 + 4 >> 2] = 0;
       HEAP32[$27 + 8 >> 2] = 0;
      }
      $663 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($27, 13948) | 0;
      HEAP32[$26 >> 2] = HEAP32[$663 >> 2];
      HEAP32[$26 + 4 >> 2] = HEAP32[$663 + 4 >> 2];
      HEAP32[$26 + 8 >> 2] = HEAP32[$663 + 8 >> 2];
      HEAP32[$663 >> 2] = 0;
      HEAP32[$663 + 4 >> 2] = 0;
      HEAP32[$663 + 8 >> 2] = 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($28, (HEAP32[$657 >> 2] | 0) + -24 | 0);
      $668 = HEAP8[$28 >> 0] | 0;
      $670 = ($668 & 1) == 0;
      $680 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($26, $670 ? $28 + 1 | 0 : HEAP32[$28 + 8 >> 2] | 0, $670 ? ($668 & 255) >>> 1 : HEAP32[$28 + 4 >> 2] | 0) | 0;
      HEAP32[$25 >> 2] = HEAP32[$680 >> 2];
      HEAP32[$25 + 4 >> 2] = HEAP32[$680 + 4 >> 2];
      HEAP32[$25 + 8 >> 2] = HEAP32[$680 + 8 >> 2];
      HEAP32[$680 >> 2] = 0;
      HEAP32[$680 + 4 >> 2] = 0;
      HEAP32[$680 + 8 >> 2] = 0;
      do if (!(HEAP8[$660 >> 0] & 1)) {
       HEAP8[$660 + 1 >> 0] = 0;
       HEAP8[$660 >> 0] = 0;
      } else {
       $687 = $658 + -16 | 0;
       HEAP8[HEAP32[$687 >> 2] >> 0] = 0;
       $689 = $658 + -20 | 0;
       HEAP32[$689 >> 2] = 0;
       $$pre$i$i$i87 = HEAP8[$660 >> 0] | 0;
       if (!($$pre$i$i$i87 & 1)) {
        $696 = $$pre$i$i$i87;
        $705 = 10;
       } else {
        $692 = HEAP32[$660 >> 2] | 0;
        $696 = $692 & 255;
        $705 = ($692 & -2) + -1 | 0;
       }
       if (!($696 & 1)) {
        $699 = ($696 & 255) >>> 1;
        if (($696 & 255) < 22) {
         $1750 = 1;
         $704 = 10;
         $724 = $699;
        } else {
         $1750 = 1;
         $704 = ($699 + 16 & 240) + -1 | 0;
         $724 = $699;
        }
       } else {
        $1750 = 0;
        $704 = 10;
        $724 = 0;
       }
       if (($704 | 0) != ($705 | 0)) {
        if (($704 | 0) == 10) {
         $711 = $660 + 1 | 0;
         $712 = HEAP32[$687 >> 2] | 0;
         if ($1750) {
          _memcpy($711 | 0, $712 | 0, (($696 & 255) >>> 1) + 1 | 0) | 0;
          _free($712);
         } else {
          HEAP8[$711 >> 0] = HEAP8[$712 >> 0] | 0;
          _free($712);
         }
         HEAP8[$660 >> 0] = $724 << 1;
         break;
        }
        $708 = $704 + 1 | 0;
        $709 = _malloc($708) | 0;
        if (!($704 >>> 0 <= $705 >>> 0 & ($709 | 0) == 0)) {
         if ($1750) _memcpy($709 | 0, $660 + 1 | 0, (($696 & 255) >>> 1) + 1 | 0) | 0; else {
          $721 = HEAP32[$687 >> 2] | 0;
          HEAP8[$709 >> 0] = HEAP8[$721 >> 0] | 0;
          _free($721);
         }
         HEAP32[$660 >> 2] = $708 | 1;
         HEAP32[$689 >> 2] = $724;
         HEAP32[$687 >> 2] = $709;
        }
       }
      } while (0);
      HEAP32[$660 >> 2] = HEAP32[$25 >> 2];
      HEAP32[$660 + 4 >> 2] = HEAP32[$25 + 4 >> 2];
      HEAP32[$660 + 8 >> 2] = HEAP32[$25 + 8 >> 2];
      HEAP32[$25 >> 2] = 0;
      HEAP32[$25 + 4 >> 2] = 0;
      HEAP32[$25 + 8 >> 2] = 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($25);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($28);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($26);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($27);
      $$0 = $654;
      break L1;
      break;
     }
    case 110:
     {
      $$0 = __ZN10__cxxabiv112_GLOBAL__N_121parse_unresolved_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
      break L1;
      break;
     }
    case 115:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 100) if ((HEAP8[$first + 1 >> 0] | 0) == 115) {
       $736 = $first + 2 | 0;
       $737 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($736, $last, $db) | 0;
       if (($737 | 0) == ($736 | 0)) $$02$i317 = $first; else {
        $739 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($737, $last, $db) | 0;
        if (($739 | 0) == ($737 | 0)) $$02$i317 = $first; else {
         $741 = $db + 4 | 0;
         $742 = HEAP32[$741 >> 2] | 0;
         if ((($742 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$02$i317 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $742 + -24 | 0);
          $750 = HEAP32[$741 >> 2] | 0;
          $751 = $750 + -24 | 0;
          $753 = $750;
          do {
           $752 = $753 + -24 | 0;
           HEAP32[$741 >> 2] = $752;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($752);
           $753 = HEAP32[$741 >> 2] | 0;
          } while (($753 | 0) != ($751 | 0));
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($1, 13956, $0);
          $756 = HEAP8[$1 >> 0] | 0;
          $758 = ($756 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($750 + -48 | 0, $758 ? $1 + 1 | 0 : HEAP32[$1 + 8 >> 2] | 0, $758 ? ($756 & 255) >>> 1 : HEAP32[$1 + 4 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$02$i317 = $739;
         }
        }
       }
      } else $$02$i317 = $first; else $$02$i317 = $first; else $$02$i317 = $first;
      $$0 = $$02$i317;
      break L1;
      break;
     }
    case 116:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 100) if ((HEAP8[$first + 1 >> 0] | 0) == 116) {
       $774 = $first + 2 | 0;
       $775 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($774, $last, $db) | 0;
       if (($775 | 0) == ($774 | 0)) $$02$i310 = $first; else {
        $777 = __ZN10__cxxabiv112_GLOBAL__N_121parse_unresolved_nameINS0_2DbEEEPKcS4_S4_RT_($775, $last, $db) | 0;
        if (($777 | 0) == ($775 | 0)) $$02$i310 = $first; else {
         $779 = $db + 4 | 0;
         $780 = HEAP32[$779 >> 2] | 0;
         if ((($780 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$02$i310 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $780 + -24 | 0);
          $788 = HEAP32[$779 >> 2] | 0;
          $789 = $788 + -24 | 0;
          $791 = $788;
          do {
           $790 = $791 + -24 | 0;
           HEAP32[$779 >> 2] = $790;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($790);
           $791 = HEAP32[$779 >> 2] | 0;
          } while (($791 | 0) != ($789 | 0));
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($1, 18335, $0);
          $794 = HEAP8[$1 >> 0] | 0;
          $796 = ($794 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($788 + -48 | 0, $796 ? $1 + 1 | 0 : HEAP32[$1 + 8 >> 2] | 0, $796 ? ($794 & 255) >>> 1 : HEAP32[$1 + 4 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$02$i310 = $777;
         }
        }
       }
      } else $$02$i310 = $first; else $$02$i310 = $first; else $$02$i310 = $first;
      $$0 = $$02$i310;
      break L1;
      break;
     }
    case 118:
     {
      $806 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($29, 13959, 1);
      $807 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($806, $last, $29, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($29);
      $$0 = ($807 | 0) == ($806 | 0) ? $first : $807;
      break L1;
      break;
     }
    case 86:
     {
      $809 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($30, 13961, 2);
      $810 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($809, $last, $30, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($30);
      $$0 = ($810 | 0) == ($809 | 0) ? $first : $810;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 101:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 111:
     {
      $815 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($31, 13964, 1);
      $816 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($815, $last, $31, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($31);
      $$0 = ($816 | 0) == ($815 | 0) ? $first : $816;
      break L1;
      break;
     }
    case 79:
     {
      $818 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($32, 13966, 2);
      $819 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($818, $last, $32, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($32);
      $$0 = ($819 | 0) == ($818 | 0) ? $first : $819;
      break L1;
      break;
     }
    case 113:
     {
      $821 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($33, 13969, 2);
      $822 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($821, $last, $33, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($33);
      $$0 = ($822 | 0) == ($821 | 0) ? $first : $822;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 103:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 101:
     {
      $827 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($34, 13972, 2);
      $828 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($827, $last, $34, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($34);
      $$0 = ($828 | 0) == ($827 | 0) ? $first : $828;
      break L1;
      break;
     }
    case 116:
     {
      $830 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($35, 12778, 1);
      $831 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($830, $last, $35, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($35);
      $$0 = ($831 | 0) == ($830 | 0) ? $first : $831;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 105:
   {
    if ((HEAP8[$t$0 + 1 >> 0] | 0) != 120) {
     $$0 = $first;
     break L1;
    }
    $836 = $first + 2 | 0;
    $837 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($836, $last, $db) | 0;
    if (($837 | 0) == ($836 | 0)) {
     $$0 = $first;
     break L1;
    }
    $839 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($837, $last, $db) | 0;
    $841 = $db + 4 | 0;
    $842 = HEAP32[$841 >> 2] | 0;
    if (($839 | 0) == ($837 | 0)) {
     $879 = $842 + -24 | 0;
     $881 = $842;
     while (1) {
      $880 = $881 + -24 | 0;
      HEAP32[$841 >> 2] = $880;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($880);
      $881 = HEAP32[$841 >> 2] | 0;
      if (($881 | 0) == ($879 | 0)) {
       $$0 = $first;
       break L1;
      }
     }
    }
    if ((($842 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
     $$0 = $first;
     break L1;
    }
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($op2, $842 + -24 | 0);
    $850 = HEAP32[$841 >> 2] | 0;
    $851 = $850 + -24 | 0;
    $853 = $850;
    do {
     $852 = $853 + -24 | 0;
     HEAP32[$841 >> 2] = $852;
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($852);
     $853 = HEAP32[$841 >> 2] | 0;
    } while (($853 | 0) != ($851 | 0));
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($op1, $850 + -48 | 0);
    $857 = (HEAP32[$841 >> 2] | 0) + -24 | 0;
    __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($40, 12714, $op1);
    $858 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($40, 13975) | 0;
    HEAP32[$39 >> 2] = HEAP32[$858 >> 2];
    HEAP32[$39 + 4 >> 2] = HEAP32[$858 + 4 >> 2];
    HEAP32[$39 + 8 >> 2] = HEAP32[$858 + 8 >> 2];
    HEAP32[$858 >> 2] = 0;
    HEAP32[$858 + 4 >> 2] = 0;
    HEAP32[$858 + 8 >> 2] = 0;
    $861 = HEAP8[$op2 >> 0] | 0;
    $863 = ($861 & 1) == 0;
    $873 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($39, $863 ? $op2 + 1 | 0 : HEAP32[$op2 + 8 >> 2] | 0, $863 ? ($861 & 255) >>> 1 : HEAP32[$op2 + 4 >> 2] | 0) | 0;
    HEAP32[$38 >> 2] = HEAP32[$873 >> 2];
    HEAP32[$38 + 4 >> 2] = HEAP32[$873 + 4 >> 2];
    HEAP32[$38 + 8 >> 2] = HEAP32[$873 + 8 >> 2];
    HEAP32[$873 >> 2] = 0;
    HEAP32[$873 + 4 >> 2] = 0;
    HEAP32[$873 + 8 >> 2] = 0;
    $876 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($38, 12703) | 0;
    HEAP32[$37 >> 2] = HEAP32[$876 >> 2];
    HEAP32[$37 + 4 >> 2] = HEAP32[$876 + 4 >> 2];
    HEAP32[$37 + 8 >> 2] = HEAP32[$876 + 8 >> 2];
    HEAP32[$876 >> 2] = 0;
    HEAP32[$876 + 4 >> 2] = 0;
    HEAP32[$876 + 8 >> 2] = 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($36, $37);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($857, $36);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($36);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($37);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($38);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($39);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($40);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($op1);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($op2);
    $$0 = $839;
    break L1;
    break;
   }
  case 108:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 101:
     {
      $886 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($41, 13978, 2);
      $887 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($886, $last, $41, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($41);
      $$0 = ($887 | 0) == ($886 | 0) ? $first : $887;
      break L1;
      break;
     }
    case 115:
     {
      $889 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($42, 13981, 2);
      $890 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($889, $last, $42, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($42);
      $$0 = ($890 | 0) == ($889 | 0) ? $first : $890;
      break L1;
      break;
     }
    case 83:
     {
      $892 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($43, 13984, 3);
      $893 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($892, $last, $43, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($43);
      $$0 = ($893 | 0) == ($892 | 0) ? $first : $893;
      break L1;
      break;
     }
    case 116:
     {
      $895 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($44, 12776, 1);
      $896 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($895, $last, $44, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($44);
      $$0 = ($896 | 0) == ($895 | 0) ? $first : $896;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 109:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 105:
     {
      $901 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($45, 13988, 1);
      $902 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($901, $last, $45, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($45);
      $$0 = ($902 | 0) == ($901 | 0) ? $first : $902;
      break L1;
      break;
     }
    case 73:
     {
      $904 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($46, 13990, 2);
      $905 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($904, $last, $46, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($46);
      $$0 = ($905 | 0) == ($904 | 0) ? $first : $905;
      break L1;
      break;
     }
    case 108:
     {
      $907 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($47, 12759, 1);
      $908 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($907, $last, $47, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($47);
      $$0 = ($908 | 0) == ($907 | 0) ? $first : $908;
      break L1;
      break;
     }
    case 76:
     {
      $910 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($48, 13993, 2);
      $911 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($910, $last, $48, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($48);
      $$0 = ($911 | 0) == ($910 | 0) ? $first : $911;
      break L1;
      break;
     }
    case 109:
     {
      $913 = $first + 2 | 0;
      if (($913 | 0) != ($last | 0)) if ((HEAP8[$913 >> 0] | 0) == 95) {
       $917 = $first + 3 | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($49, 13996, 2);
       $918 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($917, $last, $49, $db) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($49);
       $$0 = ($918 | 0) == ($917 | 0) ? $first : $918;
       break L1;
      }
      $920 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($913, $last, $db) | 0;
      if (($920 | 0) == ($913 | 0)) {
       $$0 = $first;
       break L1;
      }
      $924 = HEAP32[$db + 4 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($924 | 0)) {
       $$0 = $first;
       break L1;
      }
      $926 = $924 + -24 | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($53, $926);
      $927 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($53, 0, 12714) | 0;
      HEAP32[$52 >> 2] = HEAP32[$927 >> 2];
      HEAP32[$52 + 4 >> 2] = HEAP32[$927 + 4 >> 2];
      HEAP32[$52 + 8 >> 2] = HEAP32[$927 + 8 >> 2];
      HEAP32[$927 >> 2] = 0;
      HEAP32[$927 + 4 >> 2] = 0;
      HEAP32[$927 + 8 >> 2] = 0;
      $930 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($52, 13999) | 0;
      HEAP32[$51 >> 2] = HEAP32[$930 >> 2];
      HEAP32[$51 + 4 >> 2] = HEAP32[$930 + 4 >> 2];
      HEAP32[$51 + 8 >> 2] = HEAP32[$930 + 8 >> 2];
      HEAP32[$930 >> 2] = 0;
      HEAP32[$930 + 4 >> 2] = 0;
      HEAP32[$930 + 8 >> 2] = 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($50, $51);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($926, $50);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($50);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($51);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($52);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($53);
      $$0 = $920;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 110:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 119:
    case 97:
     {
      L323 : do if ($85) {
       $936 = HEAP8[$first >> 0] | 0;
       if ($936 << 24 >> 24 == 103) {
        $940 = (HEAP8[$first + 1 >> 0] | 0) == 115;
        $$first$i = $940 ? $first + 2 | 0 : $first;
        $943 = HEAP8[$$first$i >> 0] | 0;
        $parsed_gs$0$off0$i = $940;
        $t$0$i267 = $$first$i;
       } else {
        $943 = $936;
        $parsed_gs$0$off0$i = 0;
        $t$0$i267 = $first;
       }
       if ($943 << 24 >> 24 == 110) {
        $945 = HEAP8[$t$0$i267 + 1 >> 0] | 0;
        switch ($945 << 24 >> 24) {
        case 97:
        case 119:
         break;
        default:
         {
          $$221$i = $first;
          label = 319;
          break L323;
         }
        }
        $946 = $945 << 24 >> 24 == 97;
        $947 = $t$0$i267 + 2 | 0;
        if (($947 | 0) == ($last | 0)) $$9$i = $first; else {
         $has_expr_list$0$off0$i = 0;
         $t$1$i = $947;
         while (1) {
          if ((HEAP8[$t$1$i >> 0] | 0) == 95) {
           $has_expr_list$0$off0$i$lcssa = $has_expr_list$0$off0$i;
           $t$1$i$lcssa = $t$1$i;
           break;
          }
          $t$1$i$looptemp = $t$1$i;
          $t$1$i = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($t$1$i, $last, $db) | 0;
          if (($t$1$i | 0) == ($t$1$i$looptemp | 0) | ($t$1$i | 0) == ($last | 0)) {
           $$9$i = $first;
           break L323;
          } else $has_expr_list$0$off0$i = 1;
         }
         $954 = $t$1$i$lcssa + 1 | 0;
         $955 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($954, $last, $db) | 0;
         if (($955 | 0) == ($954 | 0) | ($955 | 0) == ($last | 0)) $$9$i = $first; else {
          $961 = HEAP8[$955 >> 0] | 0;
          L335 : do if (($81 - $955 | 0) > 2 & $961 << 24 >> 24 == 112) {
           if ((HEAP8[$955 + 1 >> 0] | 0) != 105) {
            $$9$i = $first;
            break L323;
           }
           $t$2$i = $955 + 2 | 0;
           while (1) {
            if ((HEAP8[$t$2$i >> 0] | 0) == 69) {
             $has_init$0$off0$i513 = 1;
             $t$3$i512 = $t$2$i;
             break L335;
            }
            $t$2$i$looptemp = $t$2$i;
            $t$2$i = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($t$2$i, $last, $db) | 0;
            if (($t$2$i | 0) == ($t$2$i$looptemp | 0) | ($t$2$i | 0) == ($last | 0)) {
             $$9$i = $first;
             break L323;
            }
           }
          } else if ($961 << 24 >> 24 == 69) {
           $has_init$0$off0$i513 = 0;
           $t$3$i512 = $955;
          } else {
           $$9$i = $first;
           break L323;
          } while (0);
          HEAP32[$1 >> 2] = 0;
          HEAP32[$1 + 4 >> 2] = 0;
          HEAP32[$1 + 8 >> 2] = 0;
          if ($has_init$0$off0$i513) {
           $976 = $db + 4 | 0;
           $977 = HEAP32[$976 >> 2] | 0;
           if ((HEAP32[$db >> 2] | 0) != ($977 | 0)) {
            __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $977 + -24 | 0);
            L346 : do if (!(HEAP8[$1 >> 0] & 1)) {
             HEAP8[$1 + 1 >> 0] = 0;
             HEAP8[$1 >> 0] = 0;
            } else {
             $984 = $1 + 8 | 0;
             $985 = HEAP32[$984 >> 2] | 0;
             HEAP8[$985 >> 0] = 0;
             $986 = $1 + 4 | 0;
             HEAP32[$986 >> 2] = 0;
             $987 = HEAP32[$1 >> 2] | 0;
             $phitmp$i$i$i$i$i$i$i273 = ($987 & -2) + -1 | 0;
             $989 = $987 & 255;
             do if (!($989 & 1)) {
              $993 = $987 >>> 1 & 127;
              if (($989 & 255) < 22) {
               _memcpy($1 + 1 | 0, $985 | 0, ($987 >>> 1 & 127) + 1 | 0) | 0;
               _free($985);
               $$ph518 = $993;
               break;
              }
              $996 = $993 + 16 & 240;
              $phitmp$i2$i$i$i$i$i$i276 = $996 + -1 | 0;
              if (($phitmp$i2$i$i$i$i$i$i276 | 0) == ($phitmp$i$i$i$i$i$i$i273 | 0)) break L346;
              $999 = _malloc($996) | 0;
              if ($phitmp$i2$i$i$i$i$i$i276 >>> 0 <= $phitmp$i$i$i$i$i$i$i273 >>> 0 & ($999 | 0) == 0) break L346;
              _memcpy($999 | 0, $1 + 1 | 0, ($987 >>> 1 & 127) + 1 | 0) | 0;
              HEAP32[$1 >> 2] = $996 | 1;
              HEAP32[$986 >> 2] = $993;
              HEAP32[$984 >> 2] = $999;
              break L346;
             } else {
              HEAP8[$1 + 1 >> 0] = 0;
              _free($985);
              $$ph518 = 0;
             } while (0);
             HEAP8[$1 >> 0] = $$ph518 << 1;
            } while (0);
            HEAP32[$1 >> 2] = HEAP32[$2 >> 2];
            HEAP32[$1 + 4 >> 2] = HEAP32[$2 + 4 >> 2];
            HEAP32[$1 + 8 >> 2] = HEAP32[$2 + 8 >> 2];
            HEAP32[$2 >> 2] = 0;
            HEAP32[$2 + 4 >> 2] = 0;
            HEAP32[$2 + 8 >> 2] = 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
            $1015 = HEAP32[$976 >> 2] | 0;
            $1016 = $1015 + -24 | 0;
            $1018 = $1015;
            do {
             $1017 = $1018 + -24 | 0;
             HEAP32[$976 >> 2] = $1017;
             __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1017);
             $1018 = HEAP32[$976 >> 2] | 0;
            } while (($1018 | 0) != ($1016 | 0));
            $$pre$phi511Z2D = $976;
            $$pre$phiZ2D = $db;
            $1022 = $1016;
            label = 283;
           }
          } else {
           $$phi$trans$insert = $db + 4 | 0;
           $$pre$phi511Z2D = $$phi$trans$insert;
           $$pre$phiZ2D = $db;
           $1022 = HEAP32[$$phi$trans$insert >> 2] | 0;
           label = 283;
          }
          if ((label | 0) == 283) if ((HEAP32[$$pre$phiZ2D >> 2] | 0) != ($1022 | 0)) {
           __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($3, $1022 + -24 | 0);
           $1024 = HEAP32[$$pre$phi511Z2D >> 2] | 0;
           $1025 = $1024 + -24 | 0;
           $1027 = $1024;
           do {
            $1026 = $1027 + -24 | 0;
            HEAP32[$$pre$phi511Z2D >> 2] = $1026;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1026);
            $1027 = HEAP32[$$pre$phi511Z2D >> 2] | 0;
           } while (($1027 | 0) != ($1025 | 0));
           HEAP32[$4 >> 2] = 0;
           HEAP32[$4 + 4 >> 2] = 0;
           HEAP32[$4 + 8 >> 2] = 0;
           if ($has_expr_list$0$off0$i$lcssa) if ((HEAP32[$$pre$phiZ2D >> 2] | 0) == ($1025 | 0)) {
            $$019$i = $first;
            $$2$i302 = 0;
           } else {
            __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($5, $1024 + -48 | 0);
            L371 : do if (!(HEAP8[$4 >> 0] & 1)) {
             HEAP8[$4 + 1 >> 0] = 0;
             HEAP8[$4 >> 0] = 0;
            } else {
             $1038 = $4 + 8 | 0;
             $1039 = HEAP32[$1038 >> 2] | 0;
             HEAP8[$1039 >> 0] = 0;
             $1040 = $4 + 4 | 0;
             HEAP32[$1040 >> 2] = 0;
             $1041 = HEAP32[$4 >> 2] | 0;
             $phitmp$i$i$i$i$i$i32$i = ($1041 & -2) + -1 | 0;
             $1043 = $1041 & 255;
             do if (!($1043 & 1)) {
              $1047 = $1041 >>> 1 & 127;
              if (($1043 & 255) < 22) {
               _memcpy($4 + 1 | 0, $1039 | 0, ($1041 >>> 1 & 127) + 1 | 0) | 0;
               _free($1039);
               $$ph520524 = $1047;
               break;
              }
              $1050 = $1047 + 16 & 240;
              $phitmp$i2$i$i$i$i$i35$i = $1050 + -1 | 0;
              if (($phitmp$i2$i$i$i$i$i35$i | 0) == ($phitmp$i$i$i$i$i$i32$i | 0)) break L371;
              $1053 = _malloc($1050) | 0;
              if ($phitmp$i2$i$i$i$i$i35$i >>> 0 <= $phitmp$i$i$i$i$i$i32$i >>> 0 & ($1053 | 0) == 0) break L371;
              _memcpy($1053 | 0, $4 + 1 | 0, ($1041 >>> 1 & 127) + 1 | 0) | 0;
              HEAP32[$4 >> 2] = $1050 | 1;
              HEAP32[$1040 >> 2] = $1047;
              HEAP32[$1038 >> 2] = $1053;
              break L371;
             } else {
              HEAP8[$4 + 1 >> 0] = 0;
              _free($1039);
              $$ph520524 = 0;
             } while (0);
             HEAP8[$4 >> 0] = $$ph520524 << 1;
            } while (0);
            HEAP32[$4 >> 2] = HEAP32[$5 >> 2];
            HEAP32[$4 + 4 >> 2] = HEAP32[$5 + 4 >> 2];
            HEAP32[$4 + 8 >> 2] = HEAP32[$5 + 8 >> 2];
            HEAP32[$5 >> 2] = 0;
            HEAP32[$5 + 4 >> 2] = 0;
            HEAP32[$5 + 8 >> 2] = 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
            $1069 = HEAP32[$$pre$phi511Z2D >> 2] | 0;
            $1070 = $1069 + -24 | 0;
            $1072 = $1069;
            do {
             $1071 = $1072 + -24 | 0;
             HEAP32[$$pre$phi511Z2D >> 2] = $1071;
             __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1071);
             $1072 = HEAP32[$$pre$phi511Z2D >> 2] | 0;
            } while (($1072 | 0) != ($1070 | 0));
            label = 300;
           } else label = 300;
           if ((label | 0) == 300) {
            HEAP32[$6 >> 2] = 0;
            HEAP32[$6 + 4 >> 2] = 0;
            HEAP32[$6 + 8 >> 2] = 0;
            if ($parsed_gs$0$off0$i) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6assignEPKcj($6, 12902, 2);
            if ($946) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($6, 14003) | 0; else __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($6, 12726) | 0;
            if ($has_expr_list$0$off0$i$lcssa) {
             __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($8, 12714, $4);
             $1076 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($8, 14007) | 0;
             HEAP32[$7 >> 2] = HEAP32[$1076 >> 2];
             HEAP32[$7 + 4 >> 2] = HEAP32[$1076 + 4 >> 2];
             HEAP32[$7 + 8 >> 2] = HEAP32[$1076 + 8 >> 2];
             HEAP32[$1076 >> 2] = 0;
             HEAP32[$1076 + 4 >> 2] = 0;
             HEAP32[$1076 + 8 >> 2] = 0;
             $1079 = HEAP8[$7 >> 0] | 0;
             $1081 = ($1079 & 1) == 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($6, $1081 ? $7 + 1 | 0 : HEAP32[$7 + 8 >> 2] | 0, $1081 ? ($1079 & 255) >>> 1 : HEAP32[$7 + 4 >> 2] | 0) | 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($8);
            }
            $1091 = HEAP8[$3 >> 0] | 0;
            $1093 = ($1091 & 1) == 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($6, $1093 ? $3 + 1 | 0 : HEAP32[$3 + 8 >> 2] | 0, $1093 ? ($1091 & 255) >>> 1 : HEAP32[$3 + 4 >> 2] | 0) | 0;
            if ($has_init$0$off0$i513) {
             __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($10, 12616, $1);
             $1103 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($10, 12619) | 0;
             HEAP32[$9 >> 2] = HEAP32[$1103 >> 2];
             HEAP32[$9 + 4 >> 2] = HEAP32[$1103 + 4 >> 2];
             HEAP32[$9 + 8 >> 2] = HEAP32[$1103 + 8 >> 2];
             HEAP32[$1103 >> 2] = 0;
             HEAP32[$1103 + 4 >> 2] = 0;
             HEAP32[$1103 + 8 >> 2] = 0;
             $1106 = HEAP8[$9 >> 0] | 0;
             $1108 = ($1106 & 1) == 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($6, $1108 ? $9 + 1 | 0 : HEAP32[$9 + 8 >> 2] | 0, $1108 ? ($1106 & 255) >>> 1 : HEAP32[$9 + 4 >> 2] | 0) | 0;
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($9);
             __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($10);
            };
            HEAP32[$12 >> 2] = HEAP32[$6 >> 2];
            HEAP32[$12 + 4 >> 2] = HEAP32[$6 + 4 >> 2];
            HEAP32[$12 + 8 >> 2] = HEAP32[$6 + 8 >> 2];
            HEAP32[$6 >> 2] = 0;
            HEAP32[$6 + 4 >> 2] = 0;
            HEAP32[$6 + 8 >> 2] = 0;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($11, $12);
            $1120 = HEAP32[$$pre$phi511Z2D >> 2] | 0;
            $1122 = HEAP32[$db + 8 >> 2] | 0;
            if ($1120 >>> 0 < $1122 >>> 0) {
             __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1120, $11);
             HEAP32[$$pre$phi511Z2D >> 2] = (HEAP32[$$pre$phi511Z2D >> 2] | 0) + 24;
            } else {
             $1129 = HEAP32[$$pre$phiZ2D >> 2] | 0;
             $1130 = $1120 - $1129 | 0;
             $1131 = ($1130 | 0) / 24 | 0;
             $1132 = $1131 + 1 | 0;
             if (($1130 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
             $1136 = ($1122 - $1129 | 0) / 24 | 0;
             if ($1136 >>> 0 < 1073741823) {
              $1138 = $1136 << 1;
              $$0$i$i$i$i299 = $1138 >>> 0 < $1132 >>> 0 ? $1132 : $1138;
             } else $$0$i$i$i$i299 = 2147483647;
             __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i$i299, $1131, $db + 12 | 0);
             $1141 = $0 + 8 | 0;
             $1142 = HEAP32[$1141 >> 2] | 0;
             __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1142, $11);
             HEAP32[$1141 >> 2] = $1142 + 24;
             __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
             __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
            }
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($11);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($12);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
            $$019$i = $t$3$i512 + 1 | 0;
            $$2$i302 = 1;
           }
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
           if ($$2$i302) {
            $$221$i = $$019$i;
            label = 319;
            break;
           } else {
            $$9$i = $first;
            break;
           }
          }
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
          $$9$i = $first;
         }
        }
       } else {
        $$221$i = $first;
        label = 319;
       }
      } else {
       $$221$i = $first;
       label = 319;
      } while (0);
      if ((label | 0) == 319) $$9$i = $$221$i;
      $$0 = $$9$i;
      break L1;
      break;
     }
    case 101:
     {
      $1145 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($54, 14010, 2);
      $1146 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1145, $last, $54, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($54);
      $$0 = ($1146 | 0) == ($1145 | 0) ? $first : $1146;
      break L1;
      break;
     }
    case 103:
     {
      $1148 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($55, 13988, 1);
      $1149 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1148, $last, $55, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($55);
      $$0 = ($1149 | 0) == ($1148 | 0) ? $first : $1149;
      break L1;
      break;
     }
    case 116:
     {
      $1151 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($56, 14013, 1);
      $1152 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1151, $last, $56, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($56);
      $$0 = ($1152 | 0) == ($1151 | 0) ? $first : $1152;
      break L1;
      break;
     }
    case 120:
     {
      $1154 = $first + 2 | 0;
      $1155 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1154, $last, $db) | 0;
      if (($1155 | 0) == ($1154 | 0)) $$03$i265 = $1154; else {
       $1159 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($1159 | 0)) $$03$i265 = $1154; else {
        $1161 = $1159 + -24 | 0;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $1161);
        $1162 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($2, 0, 14015) | 0;
        HEAP32[$1 >> 2] = HEAP32[$1162 >> 2];
        HEAP32[$1 + 4 >> 2] = HEAP32[$1162 + 4 >> 2];
        HEAP32[$1 + 8 >> 2] = HEAP32[$1162 + 8 >> 2];
        HEAP32[$1162 >> 2] = 0;
        HEAP32[$1162 + 4 >> 2] = 0;
        HEAP32[$1162 + 8 >> 2] = 0;
        $1165 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1, 12619) | 0;
        HEAP32[$0 >> 2] = HEAP32[$1165 >> 2];
        HEAP32[$0 + 4 >> 2] = HEAP32[$1165 + 4 >> 2];
        HEAP32[$0 + 8 >> 2] = HEAP32[$1165 + 8 >> 2];
        HEAP32[$1165 >> 2] = 0;
        HEAP32[$1165 + 4 >> 2] = 0;
        HEAP32[$1165 + 8 >> 2] = 0;
        do if (!(HEAP8[$1161 >> 0] & 1)) {
         HEAP8[$1161 + 1 >> 0] = 0;
         HEAP8[$1161 >> 0] = 0;
        } else {
         $1172 = $1159 + -16 | 0;
         HEAP8[HEAP32[$1172 >> 2] >> 0] = 0;
         $1174 = $1159 + -20 | 0;
         HEAP32[$1174 >> 2] = 0;
         $$pre$i$i$i$i = HEAP8[$1161 >> 0] | 0;
         if (!($$pre$i$i$i$i & 1)) {
          $1181 = $$pre$i$i$i$i;
          $1190 = 10;
         } else {
          $1177 = HEAP32[$1161 >> 2] | 0;
          $1181 = $1177 & 255;
          $1190 = ($1177 & -2) + -1 | 0;
         }
         if (!($1181 & 1)) {
          $1184 = ($1181 & 255) >>> 1;
          if (($1181 & 255) < 22) {
           $1189 = 10;
           $1209 = $1184;
           $1751 = 1;
          } else {
           $1189 = ($1184 + 16 & 240) + -1 | 0;
           $1209 = $1184;
           $1751 = 1;
          }
         } else {
          $1189 = 10;
          $1209 = 0;
          $1751 = 0;
         }
         if (($1189 | 0) != ($1190 | 0)) {
          if (($1189 | 0) == 10) {
           $1196 = $1161 + 1 | 0;
           $1197 = HEAP32[$1172 >> 2] | 0;
           if ($1751) {
            _memcpy($1196 | 0, $1197 | 0, (($1181 & 255) >>> 1) + 1 | 0) | 0;
            _free($1197);
           } else {
            HEAP8[$1196 >> 0] = HEAP8[$1197 >> 0] | 0;
            _free($1197);
           }
           HEAP8[$1161 >> 0] = $1209 << 1;
           break;
          }
          $1193 = $1189 + 1 | 0;
          $1194 = _malloc($1193) | 0;
          if (!($1189 >>> 0 <= $1190 >>> 0 & ($1194 | 0) == 0)) {
           if ($1751) _memcpy($1194 | 0, $1161 + 1 | 0, (($1181 & 255) >>> 1) + 1 | 0) | 0; else {
            $1206 = HEAP32[$1172 >> 2] | 0;
            HEAP8[$1194 >> 0] = HEAP8[$1206 >> 0] | 0;
            _free($1206);
           }
           HEAP32[$1161 >> 2] = $1193 | 1;
           HEAP32[$1174 >> 2] = $1209;
           HEAP32[$1172 >> 2] = $1194;
          }
         }
        } while (0);
        HEAP32[$1161 >> 2] = HEAP32[$0 >> 2];
        HEAP32[$1161 + 4 >> 2] = HEAP32[$0 + 4 >> 2];
        HEAP32[$1161 + 8 >> 2] = HEAP32[$0 + 8 >> 2];
        HEAP32[$0 >> 2] = 0;
        HEAP32[$0 + 4 >> 2] = 0;
        HEAP32[$0 + 8 >> 2] = 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
        $$03$i265 = $1155;
       }
      }
      $$0 = ($$03$i265 | 0) == ($1154 | 0) ? $first : $$03$i265;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 111:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 110:
     {
      $$0 = __ZN10__cxxabiv112_GLOBAL__N_121parse_unresolved_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
      break L1;
      break;
     }
    case 111:
     {
      $1219 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($57, 14026, 2);
      $1220 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1219, $last, $57, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($57);
      $$0 = ($1220 | 0) == ($1219 | 0) ? $first : $1220;
      break L1;
      break;
     }
    case 114:
     {
      $1222 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($58, 14029, 1);
      $1223 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1222, $last, $58, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($58);
      $$0 = ($1223 | 0) == ($1222 | 0) ? $first : $1223;
      break L1;
      break;
     }
    case 82:
     {
      $1225 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($59, 14031, 2);
      $1226 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1225, $last, $59, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($59);
      $$0 = ($1226 | 0) == ($1225 | 0) ? $first : $1226;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 112:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 109:
     {
      $1231 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($60, 14034, 3);
      $1232 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1231, $last, $60, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($60);
      $$0 = ($1232 | 0) == ($1231 | 0) ? $first : $1232;
      break L1;
      break;
     }
    case 108:
     {
      $1234 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($61, 14038, 1);
      $1235 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1234, $last, $61, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($61);
      $$0 = ($1235 | 0) == ($1234 | 0) ? $first : $1235;
      break L1;
      break;
     }
    case 76:
     {
      $1237 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($62, 14040, 2);
      $1238 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1237, $last, $62, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($62);
      $$0 = ($1238 | 0) == ($1237 | 0) ? $first : $1238;
      break L1;
      break;
     }
    case 112:
     {
      $1240 = $first + 2 | 0;
      if (($1240 | 0) != ($last | 0)) if ((HEAP8[$1240 >> 0] | 0) == 95) {
       $1244 = $first + 3 | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($63, 14043, 2);
       $1245 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1244, $last, $63, $db) | 0;
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($63);
       $$0 = ($1245 | 0) == ($1244 | 0) ? $first : $1245;
       break L1;
      }
      $1247 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1240, $last, $db) | 0;
      if (($1247 | 0) == ($1240 | 0)) {
       $$0 = $first;
       break L1;
      }
      $1251 = HEAP32[$db + 4 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($1251 | 0)) {
       $$0 = $first;
       break L1;
      }
      $1253 = $1251 + -24 | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($67, $1253);
      $1254 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($67, 0, 12714) | 0;
      HEAP32[$66 >> 2] = HEAP32[$1254 >> 2];
      HEAP32[$66 + 4 >> 2] = HEAP32[$1254 + 4 >> 2];
      HEAP32[$66 + 8 >> 2] = HEAP32[$1254 + 8 >> 2];
      HEAP32[$1254 >> 2] = 0;
      HEAP32[$1254 + 4 >> 2] = 0;
      HEAP32[$1254 + 8 >> 2] = 0;
      $1257 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($66, 14046) | 0;
      HEAP32[$65 >> 2] = HEAP32[$1257 >> 2];
      HEAP32[$65 + 4 >> 2] = HEAP32[$1257 + 4 >> 2];
      HEAP32[$65 + 8 >> 2] = HEAP32[$1257 + 8 >> 2];
      HEAP32[$1257 >> 2] = 0;
      HEAP32[$1257 + 4 >> 2] = 0;
      HEAP32[$1257 + 8 >> 2] = 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($64, $65);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1253, $64);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($64);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($65);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($66);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($67);
      $$0 = $1247;
      break L1;
      break;
     }
    case 115:
     {
      $1260 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($68, 14038, 1);
      $1261 = __ZN10__cxxabiv112_GLOBAL__N_123parse_prefix_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1260, $last, $68, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($68);
      $$0 = ($1261 | 0) == ($1260 | 0) ? $first : $1261;
      break L1;
      break;
     }
    case 116:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 112) if ((HEAP8[$first + 1 >> 0] | 0) == 116) {
       $1269 = $first + 2 | 0;
       $1270 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1269, $last, $db) | 0;
       if (($1270 | 0) == ($1269 | 0)) $$0$i254 = $first; else {
        $1272 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1270, $last, $db) | 0;
        if (($1272 | 0) == ($1270 | 0)) $$0$i254 = $first; else {
         $1274 = $db + 4 | 0;
         $1275 = HEAP32[$1274 >> 2] | 0;
         if ((($1275 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$0$i254 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $1275 + -24 | 0);
          $1283 = HEAP32[$1274 >> 2] | 0;
          $1284 = $1283 + -24 | 0;
          $1286 = $1283;
          do {
           $1285 = $1286 + -24 | 0;
           HEAP32[$1274 >> 2] = $1285;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1285);
           $1286 = HEAP32[$1274 >> 2] | 0;
          } while (($1286 | 0) != ($1284 | 0));
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1283 + -48 | 0, 14050) | 0;
          $1291 = HEAP8[$0 >> 0] | 0;
          $1293 = ($1291 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj((HEAP32[$1274 >> 2] | 0) + -24 | 0, $1293 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $1293 ? ($1291 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$0$i254 = $1272;
         }
        }
       }
      } else $$0$i254 = $first; else $$0$i254 = $first; else $$0$i254 = $first;
      $$0 = $$0$i254;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 113:
   {
    if ((HEAP8[$t$0 + 1 >> 0] | 0) != 117) {
     $$0 = $first;
     break L1;
    }
    $1306 = $first + 2 | 0;
    $1307 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1306, $last, $db) | 0;
    if (($1307 | 0) == ($1306 | 0)) {
     $$0 = $first;
     break L1;
    }
    $1309 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1307, $last, $db) | 0;
    if (($1309 | 0) == ($1307 | 0)) {
     $1383 = $db + 4 | 0;
     $1384 = HEAP32[$1383 >> 2] | 0;
     $1385 = $1384 + -24 | 0;
     $1387 = $1384;
     while (1) {
      $1386 = $1387 + -24 | 0;
      HEAP32[$1383 >> 2] = $1386;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1386);
      $1387 = HEAP32[$1383 >> 2] | 0;
      if (($1387 | 0) == ($1385 | 0)) {
       $$0 = $first;
       break L1;
      }
     }
    }
    $1311 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1309, $last, $db) | 0;
    $1313 = $db + 4 | 0;
    $1314 = HEAP32[$1313 >> 2] | 0;
    if (($1311 | 0) == ($1309 | 0)) {
     $1375 = $1314 + -24 | 0;
     $1377 = $1314;
     do {
      $1376 = $1377 + -24 | 0;
      HEAP32[$1313 >> 2] = $1376;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1376);
      $1377 = HEAP32[$1313 >> 2] | 0;
     } while (($1377 | 0) != ($1375 | 0));
     $1379 = $1314 + -48 | 0;
     $1381 = $1375;
     while (1) {
      $1380 = $1381 + -24 | 0;
      HEAP32[$1313 >> 2] = $1380;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1380);
      $1381 = HEAP32[$1313 >> 2] | 0;
      if (($1381 | 0) == ($1379 | 0)) {
       $$0 = $first;
       break L1;
      }
     }
    }
    if ((($1314 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 3) {
     $$0 = $first;
     break L1;
    }
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($op3, $1314 + -24 | 0);
    $1322 = HEAP32[$1313 >> 2] | 0;
    $1323 = $1322 + -24 | 0;
    $1325 = $1322;
    do {
     $1324 = $1325 + -24 | 0;
     HEAP32[$1313 >> 2] = $1324;
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1324);
     $1325 = HEAP32[$1313 >> 2] | 0;
    } while (($1325 | 0) != ($1323 | 0));
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($op27, $1322 + -48 | 0);
    $1328 = HEAP32[$1313 >> 2] | 0;
    $1329 = $1328 + -24 | 0;
    $1331 = $1328;
    do {
     $1330 = $1331 + -24 | 0;
     HEAP32[$1313 >> 2] = $1330;
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1330);
     $1331 = HEAP32[$1313 >> 2] | 0;
    } while (($1331 | 0) != ($1329 | 0));
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($op18, $1328 + -48 | 0);
    $1335 = (HEAP32[$1313 >> 2] | 0) + -24 | 0;
    __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($75, 12714, $op18);
    $1336 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($75, 14053) | 0;
    HEAP32[$74 >> 2] = HEAP32[$1336 >> 2];
    HEAP32[$74 + 4 >> 2] = HEAP32[$1336 + 4 >> 2];
    HEAP32[$74 + 8 >> 2] = HEAP32[$1336 + 8 >> 2];
    HEAP32[$1336 >> 2] = 0;
    HEAP32[$1336 + 4 >> 2] = 0;
    HEAP32[$1336 + 8 >> 2] = 0;
    $1339 = HEAP8[$op27 >> 0] | 0;
    $1341 = ($1339 & 1) == 0;
    $1351 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($74, $1341 ? $op27 + 1 | 0 : HEAP32[$op27 + 8 >> 2] | 0, $1341 ? ($1339 & 255) >>> 1 : HEAP32[$op27 + 4 >> 2] | 0) | 0;
    HEAP32[$73 >> 2] = HEAP32[$1351 >> 2];
    HEAP32[$73 + 4 >> 2] = HEAP32[$1351 + 4 >> 2];
    HEAP32[$73 + 8 >> 2] = HEAP32[$1351 + 8 >> 2];
    HEAP32[$1351 >> 2] = 0;
    HEAP32[$1351 + 4 >> 2] = 0;
    HEAP32[$1351 + 8 >> 2] = 0;
    $1354 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($73, 14059) | 0;
    HEAP32[$72 >> 2] = HEAP32[$1354 >> 2];
    HEAP32[$72 + 4 >> 2] = HEAP32[$1354 + 4 >> 2];
    HEAP32[$72 + 8 >> 2] = HEAP32[$1354 + 8 >> 2];
    HEAP32[$1354 >> 2] = 0;
    HEAP32[$1354 + 4 >> 2] = 0;
    HEAP32[$1354 + 8 >> 2] = 0;
    $1357 = HEAP8[$op3 >> 0] | 0;
    $1359 = ($1357 & 1) == 0;
    $1369 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($72, $1359 ? $op3 + 1 | 0 : HEAP32[$op3 + 8 >> 2] | 0, $1359 ? ($1357 & 255) >>> 1 : HEAP32[$op3 + 4 >> 2] | 0) | 0;
    HEAP32[$71 >> 2] = HEAP32[$1369 >> 2];
    HEAP32[$71 + 4 >> 2] = HEAP32[$1369 + 4 >> 2];
    HEAP32[$71 + 8 >> 2] = HEAP32[$1369 + 8 >> 2];
    HEAP32[$1369 >> 2] = 0;
    HEAP32[$1369 + 4 >> 2] = 0;
    HEAP32[$1369 + 8 >> 2] = 0;
    $1372 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($71, 12619) | 0;
    HEAP32[$70 >> 2] = HEAP32[$1372 >> 2];
    HEAP32[$70 + 4 >> 2] = HEAP32[$1372 + 4 >> 2];
    HEAP32[$70 + 8 >> 2] = HEAP32[$1372 + 8 >> 2];
    HEAP32[$1372 >> 2] = 0;
    HEAP32[$1372 + 4 >> 2] = 0;
    HEAP32[$1372 + 8 >> 2] = 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($69, $70);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1335, $69);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($69);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($70);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($71);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($72);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($73);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($74);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($75);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($op18);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($op27);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($op3);
    $$0 = $1311;
    break L1;
    break;
   }
  case 114:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 99:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 114) if ((HEAP8[$first + 1 >> 0] | 0) == 99) {
       $1398 = $first + 2 | 0;
       $1399 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1398, $last, $db) | 0;
       if (($1399 | 0) == ($1398 | 0)) $$06$i248 = $first; else {
        $1401 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1399, $last, $db) | 0;
        if (($1401 | 0) == ($1399 | 0)) $$06$i248 = $first; else {
         $1403 = $db + 4 | 0;
         $1404 = HEAP32[$1403 >> 2] | 0;
         if ((($1404 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$06$i248 = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $1404 + -24 | 0);
          $1412 = HEAP32[$1403 >> 2] | 0;
          $1413 = $1412 + -24 | 0;
          $1415 = $1412;
          do {
           $1414 = $1415 + -24 | 0;
           HEAP32[$1403 >> 2] = $1414;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1414);
           $1415 = HEAP32[$1403 >> 2] | 0;
          } while (($1415 | 0) != ($1413 | 0));
          $1417 = $1412 + -48 | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($6, $1417);
          $1418 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($6, 0, 14065) | 0;
          HEAP32[$5 >> 2] = HEAP32[$1418 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$1418 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$1418 + 8 >> 2];
          HEAP32[$1418 >> 2] = 0;
          HEAP32[$1418 + 4 >> 2] = 0;
          HEAP32[$1418 + 8 >> 2] = 0;
          $1421 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($5, 13916) | 0;
          HEAP32[$4 >> 2] = HEAP32[$1421 >> 2];
          HEAP32[$4 + 4 >> 2] = HEAP32[$1421 + 4 >> 2];
          HEAP32[$4 + 8 >> 2] = HEAP32[$1421 + 8 >> 2];
          HEAP32[$1421 >> 2] = 0;
          HEAP32[$1421 + 4 >> 2] = 0;
          HEAP32[$1421 + 8 >> 2] = 0;
          $1424 = HEAP8[$0 >> 0] | 0;
          $1426 = ($1424 & 1) == 0;
          $1436 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($4, $1426 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $1426 ? ($1424 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
          HEAP32[$3 >> 2] = HEAP32[$1436 >> 2];
          HEAP32[$3 + 4 >> 2] = HEAP32[$1436 + 4 >> 2];
          HEAP32[$3 + 8 >> 2] = HEAP32[$1436 + 8 >> 2];
          HEAP32[$1436 >> 2] = 0;
          HEAP32[$1436 + 4 >> 2] = 0;
          HEAP32[$1436 + 8 >> 2] = 0;
          $1439 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($3, 12619) | 0;
          HEAP32[$2 >> 2] = HEAP32[$1439 >> 2];
          HEAP32[$2 + 4 >> 2] = HEAP32[$1439 + 4 >> 2];
          HEAP32[$2 + 8 >> 2] = HEAP32[$1439 + 8 >> 2];
          HEAP32[$1439 >> 2] = 0;
          HEAP32[$1439 + 4 >> 2] = 0;
          HEAP32[$1439 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1417, $1);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$06$i248 = $1401;
         }
        }
       }
      } else $$06$i248 = $first; else $$06$i248 = $first; else $$06$i248 = $first;
      $$0 = $$06$i248;
      break L1;
      break;
     }
    case 109:
     {
      $1442 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($76, 14083, 1);
      $1443 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1442, $last, $76, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($76);
      $$0 = ($1443 | 0) == ($1442 | 0) ? $first : $1443;
      break L1;
      break;
     }
    case 77:
     {
      $1445 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($77, 14085, 2);
      $1446 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1445, $last, $77, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($77);
      $$0 = ($1446 | 0) == ($1445 | 0) ? $first : $1446;
      break L1;
      break;
     }
    case 115:
     {
      $1448 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($78, 14088, 2);
      $1449 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1448, $last, $78, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($78);
      $$0 = ($1449 | 0) == ($1448 | 0) ? $first : $1449;
      break L1;
      break;
     }
    case 83:
     {
      $1451 = $first + 2 | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($79, 14091, 3);
      $1452 = __ZN10__cxxabiv112_GLOBAL__N_123parse_binary_expressionINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($1451, $last, $79, $db) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($79);
      STACKTOP = sp;
      return (($1452 | 0) == ($1451 | 0) ? $first : $1452) | 0;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 115:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 99:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 115) if ((HEAP8[$first + 1 >> 0] | 0) == 99) {
       $1463 = $first + 2 | 0;
       $1464 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1463, $last, $db) | 0;
       if (($1464 | 0) == ($1463 | 0)) $$06$i = $first; else {
        $1466 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1464, $last, $db) | 0;
        if (($1466 | 0) == ($1464 | 0)) $$06$i = $first; else {
         $1468 = $db + 4 | 0;
         $1469 = HEAP32[$1468 >> 2] | 0;
         if ((($1469 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) $$06$i = $first; else {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($0, $1469 + -24 | 0);
          $1477 = HEAP32[$1468 >> 2] | 0;
          $1478 = $1477 + -24 | 0;
          $1480 = $1477;
          do {
           $1479 = $1480 + -24 | 0;
           HEAP32[$1468 >> 2] = $1479;
           __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1479);
           $1480 = HEAP32[$1468 >> 2] | 0;
          } while (($1480 | 0) != ($1478 | 0));
          $1482 = $1477 + -48 | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($6, $1482);
          $1483 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($6, 0, 14095) | 0;
          HEAP32[$5 >> 2] = HEAP32[$1483 >> 2];
          HEAP32[$5 + 4 >> 2] = HEAP32[$1483 + 4 >> 2];
          HEAP32[$5 + 8 >> 2] = HEAP32[$1483 + 8 >> 2];
          HEAP32[$1483 >> 2] = 0;
          HEAP32[$1483 + 4 >> 2] = 0;
          HEAP32[$1483 + 8 >> 2] = 0;
          $1486 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($5, 13916) | 0;
          HEAP32[$4 >> 2] = HEAP32[$1486 >> 2];
          HEAP32[$4 + 4 >> 2] = HEAP32[$1486 + 4 >> 2];
          HEAP32[$4 + 8 >> 2] = HEAP32[$1486 + 8 >> 2];
          HEAP32[$1486 >> 2] = 0;
          HEAP32[$1486 + 4 >> 2] = 0;
          HEAP32[$1486 + 8 >> 2] = 0;
          $1489 = HEAP8[$0 >> 0] | 0;
          $1491 = ($1489 & 1) == 0;
          $1501 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($4, $1491 ? $0 + 1 | 0 : HEAP32[$0 + 8 >> 2] | 0, $1491 ? ($1489 & 255) >>> 1 : HEAP32[$0 + 4 >> 2] | 0) | 0;
          HEAP32[$3 >> 2] = HEAP32[$1501 >> 2];
          HEAP32[$3 + 4 >> 2] = HEAP32[$1501 + 4 >> 2];
          HEAP32[$3 + 8 >> 2] = HEAP32[$1501 + 8 >> 2];
          HEAP32[$1501 >> 2] = 0;
          HEAP32[$1501 + 4 >> 2] = 0;
          HEAP32[$1501 + 8 >> 2] = 0;
          $1504 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($3, 12619) | 0;
          HEAP32[$2 >> 2] = HEAP32[$1504 >> 2];
          HEAP32[$2 + 4 >> 2] = HEAP32[$1504 + 4 >> 2];
          HEAP32[$2 + 8 >> 2] = HEAP32[$1504 + 8 >> 2];
          HEAP32[$1504 >> 2] = 0;
          HEAP32[$1504 + 4 >> 2] = 0;
          HEAP32[$1504 + 8 >> 2] = 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1482, $1);
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($5);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $$06$i = $1466;
         }
        }
       }
      } else $$06$i = $first; else $$06$i = $first; else $$06$i = $first;
      $$0 = $$06$i;
      break L1;
      break;
     }
    case 112:
     {
      if (($83 | 0) <= 2) {
       $$0 = $first;
       break L1;
      }
      if ((HEAP8[$first >> 0] | 0) != 115) {
       $$0 = $first;
       break L1;
      }
      if ((HEAP8[$first + 1 >> 0] | 0) != 112) {
       $$0 = $first;
       break L1;
      }
      $1513 = $first + 2 | 0;
      $1514 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1513, $last, $db) | 0;
      $$0 = ($1514 | 0) == ($1513 | 0) ? $first : $1514;
      break L1;
      break;
     }
    case 114:
     {
      $$0 = __ZN10__cxxabiv112_GLOBAL__N_121parse_unresolved_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
      break L1;
      break;
     }
    case 116:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 115) if ((HEAP8[$first + 1 >> 0] | 0) == 116) {
       $1523 = $first + 2 | 0;
       $1524 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1523, $last, $db) | 0;
       if (($1524 | 0) == ($1523 | 0)) $$03$i211 = $first; else {
        $1528 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($1528 | 0)) $$03$i211 = $first; else {
         $1530 = $1528 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($3, $1530);
         $1531 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($3, 0, 14108) | 0;
         HEAP32[$2 >> 2] = HEAP32[$1531 >> 2];
         HEAP32[$2 + 4 >> 2] = HEAP32[$1531 + 4 >> 2];
         HEAP32[$2 + 8 >> 2] = HEAP32[$1531 + 8 >> 2];
         HEAP32[$1531 >> 2] = 0;
         HEAP32[$1531 + 4 >> 2] = 0;
         HEAP32[$1531 + 8 >> 2] = 0;
         $1534 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12619) | 0;
         HEAP32[$1 >> 2] = HEAP32[$1534 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$1534 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$1534 + 8 >> 2];
         HEAP32[$1534 >> 2] = 0;
         HEAP32[$1534 + 4 >> 2] = 0;
         HEAP32[$1534 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($0, $1);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1530, $0);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
         $$03$i211 = $1524;
        }
       }
      } else $$03$i211 = $first; else $$03$i211 = $first; else $$03$i211 = $first;
      $$0 = $$03$i211;
      break L1;
      break;
     }
    case 122:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 115) if ((HEAP8[$first + 1 >> 0] | 0) == 122) {
       $1543 = $first + 2 | 0;
       $1544 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1543, $last, $db) | 0;
       if (($1544 | 0) == ($1543 | 0)) $$03$i200 = $first; else {
        $1548 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($1548 | 0)) $$03$i200 = $first; else {
         $1550 = $1548 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($3, $1550);
         $1551 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($3, 0, 14108) | 0;
         HEAP32[$2 >> 2] = HEAP32[$1551 >> 2];
         HEAP32[$2 + 4 >> 2] = HEAP32[$1551 + 4 >> 2];
         HEAP32[$2 + 8 >> 2] = HEAP32[$1551 + 8 >> 2];
         HEAP32[$1551 >> 2] = 0;
         HEAP32[$1551 + 4 >> 2] = 0;
         HEAP32[$1551 + 8 >> 2] = 0;
         $1554 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12619) | 0;
         HEAP32[$1 >> 2] = HEAP32[$1554 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$1554 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$1554 + 8 >> 2];
         HEAP32[$1554 >> 2] = 0;
         HEAP32[$1554 + 4 >> 2] = 0;
         HEAP32[$1554 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($0, $1);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1550, $0);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
         $$03$i200 = $1544;
        }
       }
      } else $$03$i200 = $first; else $$03$i200 = $first; else $$03$i200 = $first;
      $$0 = $$03$i200;
      break L1;
      break;
     }
    case 90:
     {
      if (($81 - $t$0 | 0) <= 2) {
       $$0 = $first;
       break L1;
      }
      switch (HEAP8[$t$0 + 2 >> 0] | 0) {
      case 84:
       break;
      case 102:
       {
        if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 115) if ((HEAP8[$first + 1 >> 0] | 0) == 90) {
         $1662 = $first + 2 | 0;
         if ((HEAP8[$1662 >> 0] | 0) == 102) {
          $1665 = __ZN10__cxxabiv112_GLOBAL__N_120parse_function_paramINS0_2DbEEEPKcS4_S4_RT_($1662, $last, $db) | 0;
          if (($1665 | 0) == ($1662 | 0)) $$03$i174 = $first; else {
           $1669 = HEAP32[$db + 4 >> 2] | 0;
           if ((HEAP32[$db >> 2] | 0) == ($1669 | 0)) $$03$i174 = $first; else {
            $1671 = $1669 + -24 | 0;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($3, $1671);
            $1672 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($3, 0, 14117) | 0;
            HEAP32[$2 >> 2] = HEAP32[$1672 >> 2];
            HEAP32[$2 + 4 >> 2] = HEAP32[$1672 + 4 >> 2];
            HEAP32[$2 + 8 >> 2] = HEAP32[$1672 + 8 >> 2];
            HEAP32[$1672 >> 2] = 0;
            HEAP32[$1672 + 4 >> 2] = 0;
            HEAP32[$1672 + 8 >> 2] = 0;
            $1675 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12619) | 0;
            HEAP32[$1 >> 2] = HEAP32[$1675 >> 2];
            HEAP32[$1 + 4 >> 2] = HEAP32[$1675 + 4 >> 2];
            HEAP32[$1 + 8 >> 2] = HEAP32[$1675 + 8 >> 2];
            HEAP32[$1675 >> 2] = 0;
            HEAP32[$1675 + 4 >> 2] = 0;
            HEAP32[$1675 + 8 >> 2] = 0;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($0, $1);
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1671, $0);
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
            $$03$i174 = $1665;
           }
          }
         } else $$03$i174 = $first;
        } else $$03$i174 = $first; else $$03$i174 = $first; else $$03$i174 = $first;
        $$0 = $$03$i174;
        break L1;
        break;
       }
      default:
       {
        $$0 = $first;
        break L1;
       }
      }
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 115) if ((HEAP8[$first + 1 >> 0] | 0) == 90) {
       $1569 = $first + 2 | 0;
       if ((HEAP8[$1569 >> 0] | 0) == 84) {
        $1572 = $db + 4 | 0;
        $1578 = ((HEAP32[$1572 >> 2] | 0) - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0;
        $1579 = __ZN10__cxxabiv112_GLOBAL__N_120parse_template_paramINS0_2DbEEEPKcS4_S4_RT_($1569, $last, $db) | 0;
        $1581 = HEAP32[$db >> 2] | 0;
        $1585 = ((HEAP32[$1572 >> 2] | 0) - $1581 | 0) / 24 | 0;
        if (($1579 | 0) == ($1569 | 0)) $$03$i = $first; else {
         HEAP8[$1 >> 0] = 20;
         dest = $1 + 1 | 0;
         src = 14117;
         stop = dest + 10 | 0;
         do {
          HEAP8[dest >> 0] = HEAP8[src >> 0] | 0;
          dest = dest + 1 | 0;
          src = src + 1 | 0;
         } while ((dest | 0) < (stop | 0));
         HEAP8[$1 + 11 >> 0] = 0;
         if (($1578 | 0) != ($1585 | 0)) {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $1581 + ($1578 * 24 | 0) | 0);
          $1591 = HEAP8[$2 >> 0] | 0;
          $1593 = ($1591 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($1, $1593 ? $2 + 1 | 0 : HEAP32[$2 + 8 >> 2] | 0, $1593 ? ($1591 & 255) >>> 1 : HEAP32[$2 + 4 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
          $1603 = $3 + 8 | 0;
          $1604 = $3 + 1 | 0;
          $1605 = $3 + 4 | 0;
          $k$0$i621 = $1578 + 1 | 0;
          if (($k$0$i621 | 0) != ($1585 | 0)) {
           $k$0$i622 = $k$0$i621;
           do {
            __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($4, (HEAP32[$db >> 2] | 0) + ($k$0$i622 * 24 | 0) | 0);
            $1609 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($4, 0, 12716) | 0;
            HEAP32[$3 >> 2] = HEAP32[$1609 >> 2];
            HEAP32[$3 + 4 >> 2] = HEAP32[$1609 + 4 >> 2];
            HEAP32[$3 + 8 >> 2] = HEAP32[$1609 + 8 >> 2];
            HEAP32[$1609 >> 2] = 0;
            HEAP32[$1609 + 4 >> 2] = 0;
            HEAP32[$1609 + 8 >> 2] = 0;
            $1612 = HEAP8[$3 >> 0] | 0;
            $1614 = ($1612 & 1) == 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($1, $1614 ? $1604 : HEAP32[$1603 >> 2] | 0, $1614 ? ($1612 & 255) >>> 1 : HEAP32[$1605 >> 2] | 0) | 0;
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
            __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($4);
            $k$0$i622 = $k$0$i622 + 1 | 0;
           } while (($k$0$i622 | 0) != ($1585 | 0));
          }
         }
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($1, 12619) | 0;
         if (($1585 | 0) != ($1578 | 0)) {
          $k1$0$i618 = $1585;
          do {
           $1623 = HEAP32[$1572 >> 2] | 0;
           $1624 = $1623 + -24 | 0;
           $1626 = $1623;
           do {
            $1625 = $1626 + -24 | 0;
            HEAP32[$1572 >> 2] = $1625;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1625);
            $1626 = HEAP32[$1572 >> 2] | 0;
           } while (($1626 | 0) != ($1624 | 0));
           $k1$0$i618 = $k1$0$i618 + -1 | 0;
          } while (($k1$0$i618 | 0) != ($1578 | 0));
         };
         HEAP32[$6 >> 2] = HEAP32[$1 >> 2];
         HEAP32[$6 + 4 >> 2] = HEAP32[$1 + 4 >> 2];
         HEAP32[$6 + 8 >> 2] = HEAP32[$1 + 8 >> 2];
         HEAP32[$1 >> 2] = 0;
         HEAP32[$1 + 4 >> 2] = 0;
         HEAP32[$1 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($5, $6);
         $1632 = HEAP32[$1572 >> 2] | 0;
         $1634 = HEAP32[$db + 8 >> 2] | 0;
         if ($1632 >>> 0 < $1634 >>> 0) {
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1632, $5);
          HEAP32[$1572 >> 2] = (HEAP32[$1572 >> 2] | 0) + 24;
         } else {
          $1641 = HEAP32[$db >> 2] | 0;
          $1642 = $1632 - $1641 | 0;
          $1643 = ($1642 | 0) / 24 | 0;
          $1644 = $1643 + 1 | 0;
          if (($1642 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
          $1648 = ($1634 - $1641 | 0) / 24 | 0;
          if ($1648 >>> 0 < 1073741823) {
           $1650 = $1648 << 1;
           $$0$i$i$i$i = $1650 >>> 0 < $1644 >>> 0 ? $1644 : $1650;
          } else $$0$i$i$i$i = 2147483647;
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i$i, $1643, $db + 12 | 0);
          $1653 = $0 + 8 | 0;
          $1654 = HEAP32[$1653 >> 2] | 0;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1654, $5);
          HEAP32[$1653 >> 2] = $1654 + 24;
          __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
          __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($5);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         $$03$i = $1579;
        }
       } else $$03$i = $first;
      } else $$03$i = $first; else $$03$i = $first; else $$03$i = $first;
      $$0 = $$03$i;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 116:
   {
    switch (HEAP8[$t$0 + 1 >> 0] | 0) {
    case 105:
    case 101:
     {
      L600 : do if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 116) {
       $1685 = HEAP8[$first + 1 >> 0] | 0;
       switch ($1685 << 24 >> 24) {
       case 105:
       case 101:
        break;
       default:
        {
         $$03$i189 = $first;
         break L600;
        }
       }
       $1687 = $first + 2 | 0;
       if ($1685 << 24 >> 24 == 101) $t$0$i = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1687, $last, $db) | 0; else $t$0$i = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($1687, $last, $db) | 0;
       if (($t$0$i | 0) == ($1687 | 0)) $$03$i189 = $first; else {
        $1693 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($1693 | 0)) $$03$i189 = $first; else {
         $1695 = $1693 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($3, $1695);
         $1696 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($3, 0, 14128) | 0;
         HEAP32[$2 >> 2] = HEAP32[$1696 >> 2];
         HEAP32[$2 + 4 >> 2] = HEAP32[$1696 + 4 >> 2];
         HEAP32[$2 + 8 >> 2] = HEAP32[$1696 + 8 >> 2];
         HEAP32[$1696 >> 2] = 0;
         HEAP32[$1696 + 4 >> 2] = 0;
         HEAP32[$1696 + 8 >> 2] = 0;
         $1699 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($2, 12619) | 0;
         HEAP32[$1 >> 2] = HEAP32[$1699 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$1699 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$1699 + 8 >> 2];
         HEAP32[$1699 >> 2] = 0;
         HEAP32[$1699 + 4 >> 2] = 0;
         HEAP32[$1699 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($0, $1);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1695, $0);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
         $$03$i189 = $t$0$i;
        }
       }
      } else $$03$i189 = $first; else $$03$i189 = $first; while (0);
      $$0 = $$03$i189;
      break L1;
      break;
     }
    case 114:
     {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj6EEERAT__Kc($80, 14136);
      $1702 = $db + 4 | 0;
      $1703 = HEAP32[$1702 >> 2] | 0;
      $1705 = HEAP32[$db + 8 >> 2] | 0;
      if ($1703 >>> 0 < $1705 >>> 0) {
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1703, $80);
       HEAP32[$1702 >> 2] = (HEAP32[$1702 >> 2] | 0) + 24;
      } else {
       $1712 = HEAP32[$db >> 2] | 0;
       $1713 = $1703 - $1712 | 0;
       $1714 = ($1713 | 0) / 24 | 0;
       $1715 = $1714 + 1 | 0;
       if (($1713 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
       $1719 = ($1705 - $1712 | 0) / 24 | 0;
       if ($1719 >>> 0 < 1073741823) {
        $1721 = $1719 << 1;
        $$0$i$i$i = $1721 >>> 0 < $1715 >>> 0 ? $1715 : $1721;
       } else $$0$i$i$i = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i, $1714, $db + 12 | 0);
       $1724 = $0 + 8 | 0;
       $1725 = HEAP32[$1724 >> 2] | 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1725, $80);
       HEAP32[$1724 >> 2] = $1725 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
      }
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($80);
      $$0 = $first + 2 | 0;
      break L1;
      break;
     }
    case 119:
     {
      if (($83 | 0) > 2) if ((HEAP8[$first >> 0] | 0) == 116) if ((HEAP8[$first + 1 >> 0] | 0) == 119) {
       $1734 = $first + 2 | 0;
       $1735 = __ZN10__cxxabiv112_GLOBAL__N_116parse_expressionINS0_2DbEEEPKcS4_S4_RT_($1734, $last, $db) | 0;
       if (($1735 | 0) == ($1734 | 0)) $$02$i = $first; else {
        $1739 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($1739 | 0)) $$02$i = $first; else {
         $1741 = $1739 + -24 | 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($2, $1741);
         $1742 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($2, 0, 14142) | 0;
         HEAP32[$1 >> 2] = HEAP32[$1742 >> 2];
         HEAP32[$1 + 4 >> 2] = HEAP32[$1742 + 4 >> 2];
         HEAP32[$1 + 8 >> 2] = HEAP32[$1742 + 8 >> 2];
         HEAP32[$1742 >> 2] = 0;
         HEAP32[$1742 + 4 >> 2] = 0;
         HEAP32[$1742 + 8 >> 2] = 0;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($0, $1);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($1741, $0);
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($1);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
         $$02$i = $1735;
        }
       }
      } else $$02$i = $first; else $$02$i = $first; else $$02$i = $first;
      $$0 = $$02$i;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 57:
  case 56:
  case 55:
  case 54:
  case 53:
  case 52:
  case 51:
  case 50:
  case 49:
   {
    $$0 = __ZN10__cxxabiv112_GLOBAL__N_121parse_unresolved_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) | 0;
    break L1;
    break;
   }
  default:
   {
    $$0 = $first;
    break L1;
   }
  } while (0);
 } else $$0 = $first; while (0);
 STACKTOP = sp;
 return $$0 | 0;
}

function __ZN10__cxxabiv112_GLOBAL__N_119parse_operator_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0 = 0, $$0$i$i$i = 0, $$0$i$i$i10 = 0, $$0$i$i$i100 = 0, $$0$i$i$i105 = 0, $$0$i$i$i110 = 0, $$0$i$i$i115 = 0, $$0$i$i$i120 = 0, $$0$i$i$i125 = 0, $$0$i$i$i130 = 0, $$0$i$i$i135 = 0, $$0$i$i$i140 = 0, $$0$i$i$i145 = 0, $$0$i$i$i15 = 0, $$0$i$i$i150 = 0, $$0$i$i$i155 = 0, $$0$i$i$i160 = 0, $$0$i$i$i165 = 0, $$0$i$i$i170 = 0, $$0$i$i$i175 = 0, $$0$i$i$i180 = 0, $$0$i$i$i185 = 0, $$0$i$i$i190 = 0, $$0$i$i$i195 = 0, $$0$i$i$i20 = 0, $$0$i$i$i200 = 0, $$0$i$i$i205 = 0, $$0$i$i$i210 = 0, $$0$i$i$i215 = 0, $$0$i$i$i220 = 0, $$0$i$i$i225 = 0, $$0$i$i$i25 = 0, $$0$i$i$i30 = 0, $$0$i$i$i35 = 0, $$0$i$i$i40 = 0, $$0$i$i$i45 = 0, $$0$i$i$i5 = 0, $$0$i$i$i50 = 0, $$0$i$i$i55 = 0, $$0$i$i$i60 = 0, $$0$i$i$i65 = 0, $$0$i$i$i70 = 0, $$0$i$i$i75 = 0, $$0$i$i$i80 = 0, $$0$i$i$i85 = 0, $$0$i$i$i90 = 0, $$0$i$i$i95 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1009 = 0, $1011 = 0, $1014 = 0, $1015 = 0, $1021 = 0, $1022 = 0, $1024 = 0, $103 = 0, $1031 = 0, $1032 = 0, $1033 = 0, $1034 = 0, $1038 = 0, $104 = 0, $1040 = 0, $1043 = 0, $1044 = 0, $1047 = 0, $1048 = 0, $1050 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $1060 = 0, $1064 = 0, $1066 = 0, $1069 = 0, $107 = 0, $1070 = 0, $1073 = 0, $1074 = 0, $1076 = 0, $108 = 0, $1083 = 0, $1084 = 0, $1085 = 0, $1086 = 0, $1090 = 0, $1092 = 0, $1095 = 0, $1096 = 0, $1099 = 0, $11 = 0, $110 = 0, $1100 = 0, $1102 = 0, $1109 = 0, $1110 = 0, $1111 = 0, $1112 = 0, $1116 = 0, $1118 = 0, $1121 = 0, $1122 = 0, $1125 = 0, $1126 = 0, $1128 = 0, $1135 = 0, $1136 = 0, $1137 = 0, $1138 = 0, $1142 = 0, $1144 = 0, $1147 = 0, $1148 = 0, $1151 = 0, $1152 = 0, $1154 = 0, $1161 = 0, $1162 = 0, $1163 = 0, $1164 = 0, $1168 = 0, $117 = 0, $1170 = 0, $1173 = 0, $1174 = 0, $118 = 0, $1180 = 0, $1181 = 0, $1183 = 0, $119 = 0, $1190 = 0, $1191 = 0, $1192 = 0, $1193 = 0, $1197 = 0, $1199 = 0, $12 = 0, $120 = 0, $1202 = 0, $1203 = 0, $1209 = 0, $1210 = 0, $1212 = 0, $1219 = 0, $1220 = 0, $1221 = 0, $1222 = 0, $1226 = 0, $1228 = 0, $1231 = 0, $1232 = 0, $1235 = 0, $1236 = 0, $1238 = 0, $124 = 0, $1245 = 0, $1246 = 0, $1247 = 0, $1248 = 0, $1252 = 0, $1254 = 0, $1257 = 0, $1258 = 0, $126 = 0, $1261 = 0, $1262 = 0, $1264 = 0, $1271 = 0, $1272 = 0, $1273 = 0, $1274 = 0, $1278 = 0, $1280 = 0, $1283 = 0, $1284 = 0, $1287 = 0, $1288 = 0, $129 = 0, $1290 = 0, $1297 = 0, $1298 = 0, $1299 = 0, $13 = 0, $130 = 0, $1300 = 0, $1304 = 0, $1306 = 0, $1309 = 0, $1310 = 0, $1316 = 0, $1317 = 0, $1321 = 0, $133 = 0, $134 = 0, $136 = 0, $14 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $15 = 0, $150 = 0, $152 = 0, $155 = 0, $156 = 0, $16 = 0, $162 = 0, $163 = 0, $165 = 0, $17 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $179 = 0, $18 = 0, $181 = 0, $184 = 0, $185 = 0, $188 = 0, $189 = 0, $19 = 0, $191 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $205 = 0, $207 = 0, $21 = 0, $210 = 0, $211 = 0, $214 = 0, $215 = 0, $217 = 0, $22 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $23 = 0, $231 = 0, $233 = 0, $236 = 0, $237 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $247 = 0, $25 = 0, $254 = 0, $255 = 0, $257 = 0, $26 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $27 = 0, $271 = 0, $273 = 0, $276 = 0, $277 = 0, $28 = 0, $280 = 0, $281 = 0, $283 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $297 = 0, $299 = 0, $3 = 0, $30 = 0, $302 = 0, $303 = 0, $306 = 0, $31 = 0, $310 = 0, $313 = 0, $314 = 0, $316 = 0, $32 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $33 = 0, $330 = 0, $332 = 0, $335 = 0, $336 = 0, $339 = 0, $34 = 0, $340 = 0, $342 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $356 = 0, $358 = 0, $36 = 0, $361 = 0, $362 = 0, $365 = 0, $366 = 0, $368 = 0, $37 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $38 = 0, $382 = 0, $384 = 0, $387 = 0, $388 = 0, $39 = 0, $394 = 0, $395 = 0, $397 = 0, $4 = 0, $40 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $41 = 0, $411 = 0, $413 = 0, $416 = 0, $417 = 0, $42 = 0, $420 = 0, $421 = 0, $423 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $437 = 0, $439 = 0, $44 = 0, $442 = 0, $443 = 0, $446 = 0, $447 = 0, $449 = 0, $45 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $463 = 0, $465 = 0, $468 = 0, $469 = 0, $475 = 0, $476 = 0, $478 = 0, $485 = 0, $486 = 0, $487 = 0, $488 = 0, $492 = 0, $494 = 0, $497 = 0, $498 = 0, $5 = 0, $501 = 0, $502 = 0, $504 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0, $518 = 0, $520 = 0, $523 = 0, $524 = 0, $530 = 0, $531 = 0, $533 = 0, $540 = 0, $541 = 0, $542 = 0, $543 = 0, $547 = 0, $549 = 0, $55 = 0, $552 = 0, $553 = 0, $559 = 0, $56 = 0, $560 = 0, $562 = 0, $569 = 0, $570 = 0, $571 = 0, $572 = 0, $576 = 0, $578 = 0, $58 = 0, $581 = 0, $582 = 0, $585 = 0, $586 = 0, $590 = 0, $593 = 0, $594 = 0, $596 = 0, $6 = 0, $603 = 0, $604 = 0, $605 = 0, $606 = 0, $610 = 0, $612 = 0, $615 = 0, $616 = 0, $619 = 0, $620 = 0, $622 = 0, $629 = 0, $630 = 0, $631 = 0, $632 = 0, $636 = 0, $638 = 0, $641 = 0, $642 = 0, $645 = 0, $646 = 0, $648 = 0, $65 = 0, $655 = 0, $656 = 0, $657 = 0, $658 = 0, $66 = 0, $662 = 0, $664 = 0, $667 = 0, $668 = 0, $67 = 0, $674 = 0, $675 = 0, $677 = 0, $68 = 0, $684 = 0, $685 = 0, $686 = 0, $687 = 0, $691 = 0, $693 = 0, $696 = 0, $697 = 0, $7 = 0, $700 = 0, $701 = 0, $703 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $717 = 0, $719 = 0, $72 = 0, $722 = 0, $723 = 0, $726 = 0, $727 = 0, $729 = 0, $736 = 0, $737 = 0, $738 = 0, $739 = 0, $74 = 0, $743 = 0, $745 = 0, $748 = 0, $749 = 0, $752 = 0, $753 = 0, $755 = 0, $762 = 0, $763 = 0, $764 = 0, $765 = 0, $769 = 0, $77 = 0, $771 = 0, $774 = 0, $775 = 0, $778 = 0, $779 = 0, $78 = 0, $781 = 0, $788 = 0, $789 = 0, $790 = 0, $791 = 0, $795 = 0, $797 = 0, $8 = 0, $800 = 0, $801 = 0, $807 = 0, $808 = 0, $81 = 0, $810 = 0, $817 = 0, $818 = 0, $819 = 0, $82 = 0, $820 = 0, $824 = 0, $826 = 0, $829 = 0, $830 = 0, $833 = 0, $834 = 0, $836 = 0, $84 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0, $850 = 0, $852 = 0, $855 = 0, $856 = 0, $859 = 0, $860 = 0, $862 = 0, $869 = 0, $870 = 0, $871 = 0, $872 = 0, $876 = 0, $878 = 0, $881 = 0, $882 = 0, $885 = 0, $886 = 0, $888 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0, $9 = 0, $902 = 0, $904 = 0, $907 = 0, $908 = 0, $91 = 0, $911 = 0, $912 = 0, $914 = 0, $92 = 0, $921 = 0, $922 = 0, $923 = 0, $924 = 0, $928 = 0, $93 = 0, $930 = 0, $933 = 0, $934 = 0, $94 = 0, $940 = 0, $941 = 0, $943 = 0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $957 = 0, $959 = 0, $962 = 0, $963 = 0, $966 = 0, $967 = 0, $969 = 0, $976 = 0, $977 = 0, $978 = 0, $979 = 0, $98 = 0, $983 = 0, $985 = 0, $988 = 0, $989 = 0, $992 = 0, $993 = 0, $995 = 0, $__v$i$i224 = 0, dest = 0, sp = 0, src = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1136 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $__v$i$i224 = sp + 1104 | 0;
 $0 = sp + 1080 | 0;
 $1 = sp + 1056 | 0;
 $2 = sp + 1032 | 0;
 $3 = sp + 1008 | 0;
 $4 = sp + 984 | 0;
 $5 = sp + 960 | 0;
 $6 = sp + 936 | 0;
 $7 = sp + 912 | 0;
 $8 = sp + 888 | 0;
 $9 = sp + 864 | 0;
 $10 = sp + 840 | 0;
 $11 = sp + 816 | 0;
 $12 = sp + 792 | 0;
 $13 = sp + 768 | 0;
 $14 = sp + 744 | 0;
 $15 = sp + 720 | 0;
 $16 = sp + 696 | 0;
 $17 = sp + 672 | 0;
 $18 = sp + 648 | 0;
 $19 = sp + 624 | 0;
 $20 = sp + 600 | 0;
 $21 = sp + 576 | 0;
 $22 = sp + 552 | 0;
 $23 = sp + 528 | 0;
 $24 = sp + 504 | 0;
 $25 = sp + 480 | 0;
 $26 = sp + 456 | 0;
 $27 = sp + 432 | 0;
 $28 = sp + 408 | 0;
 $29 = sp + 384 | 0;
 $30 = sp + 360 | 0;
 $31 = sp + 336 | 0;
 $32 = sp + 312 | 0;
 $33 = sp + 288 | 0;
 $34 = sp + 264 | 0;
 $35 = sp + 240 | 0;
 $36 = sp + 216 | 0;
 $37 = sp + 192 | 0;
 $38 = sp + 168 | 0;
 $39 = sp + 144 | 0;
 $40 = sp + 120 | 0;
 $41 = sp + 96 | 0;
 $42 = sp + 72 | 0;
 $43 = sp + 48 | 0;
 $44 = sp + 24 | 0;
 $45 = sp;
 L1 : do if (($last - $first | 0) > 1) do switch (HEAP8[$first >> 0] | 0) {
 case 97:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 97:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($0, 12949);
     $55 = $db + 4 | 0;
     $56 = HEAP32[$55 >> 2] | 0;
     $58 = HEAP32[$db + 8 >> 2] | 0;
     if ($56 >>> 0 < $58 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($56, $0);
      HEAP32[$55 >> 2] = (HEAP32[$55 >> 2] | 0) + 24;
     } else {
      $65 = HEAP32[$db >> 2] | 0;
      $66 = $56 - $65 | 0;
      $67 = ($66 | 0) / 24 | 0;
      $68 = $67 + 1 | 0;
      if (($66 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $72 = ($58 - $65 | 0) / 24 | 0;
      if ($72 >>> 0 < 1073741823) {
       $74 = $72 << 1;
       $$0$i$i$i = $74 >>> 0 < $68 >>> 0 ? $68 : $74;
      } else $$0$i$i$i = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i, $67, $db + 12 | 0);
      $77 = $__v$i$i224 + 8 | 0;
      $78 = HEAP32[$77 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($78, $0);
      HEAP32[$77 >> 2] = $78 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 110:
   case 100:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($1, 12960);
     $81 = $db + 4 | 0;
     $82 = HEAP32[$81 >> 2] | 0;
     $84 = HEAP32[$db + 8 >> 2] | 0;
     if ($82 >>> 0 < $84 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($82, $1);
      HEAP32[$81 >> 2] = (HEAP32[$81 >> 2] | 0) + 24;
     } else {
      $91 = HEAP32[$db >> 2] | 0;
      $92 = $82 - $91 | 0;
      $93 = ($92 | 0) / 24 | 0;
      $94 = $93 + 1 | 0;
      if (($92 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $98 = ($84 - $91 | 0) / 24 | 0;
      if ($98 >>> 0 < 1073741823) {
       $100 = $98 << 1;
       $$0$i$i$i5 = $100 >>> 0 < $94 >>> 0 ? $94 : $100;
      } else $$0$i$i$i5 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i5, $93, $db + 12 | 0);
      $103 = $__v$i$i224 + 8 | 0;
      $104 = HEAP32[$103 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($104, $1);
      HEAP32[$103 >> 2] = $104 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 78:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($2, 12970);
     $107 = $db + 4 | 0;
     $108 = HEAP32[$107 >> 2] | 0;
     $110 = HEAP32[$db + 8 >> 2] | 0;
     if ($108 >>> 0 < $110 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($108, $2);
      HEAP32[$107 >> 2] = (HEAP32[$107 >> 2] | 0) + 24;
     } else {
      $117 = HEAP32[$db >> 2] | 0;
      $118 = $108 - $117 | 0;
      $119 = ($118 | 0) / 24 | 0;
      $120 = $119 + 1 | 0;
      if (($118 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $124 = ($110 - $117 | 0) / 24 | 0;
      if ($124 >>> 0 < 1073741823) {
       $126 = $124 << 1;
       $$0$i$i$i10 = $126 >>> 0 < $120 >>> 0 ? $120 : $126;
      } else $$0$i$i$i10 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i10, $119, $db + 12 | 0);
      $129 = $__v$i$i224 + 8 | 0;
      $130 = HEAP32[$129 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($130, $2);
      HEAP32[$129 >> 2] = $130 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($2);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 83:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($3, 12981);
     $133 = $db + 4 | 0;
     $134 = HEAP32[$133 >> 2] | 0;
     $136 = HEAP32[$db + 8 >> 2] | 0;
     if ($134 >>> 0 < $136 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($134, $3);
      HEAP32[$133 >> 2] = (HEAP32[$133 >> 2] | 0) + 24;
     } else {
      $143 = HEAP32[$db >> 2] | 0;
      $144 = $134 - $143 | 0;
      $145 = ($144 | 0) / 24 | 0;
      $146 = $145 + 1 | 0;
      if (($144 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $150 = ($136 - $143 | 0) / 24 | 0;
      if ($150 >>> 0 < 1073741823) {
       $152 = $150 << 1;
       $$0$i$i$i15 = $152 >>> 0 < $146 >>> 0 ? $146 : $152;
      } else $$0$i$i$i15 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i15, $145, $db + 12 | 0);
      $155 = $__v$i$i224 + 8 | 0;
      $156 = HEAP32[$155 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($156, $3);
      HEAP32[$155 >> 2] = $156 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($3);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 99:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 108:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($4, 12991);
     $162 = $db + 4 | 0;
     $163 = HEAP32[$162 >> 2] | 0;
     $165 = HEAP32[$db + 8 >> 2] | 0;
     if ($163 >>> 0 < $165 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($163, $4);
      HEAP32[$162 >> 2] = (HEAP32[$162 >> 2] | 0) + 24;
     } else {
      $172 = HEAP32[$db >> 2] | 0;
      $173 = $163 - $172 | 0;
      $174 = ($173 | 0) / 24 | 0;
      $175 = $174 + 1 | 0;
      if (($173 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $179 = ($165 - $172 | 0) / 24 | 0;
      if ($179 >>> 0 < 1073741823) {
       $181 = $179 << 1;
       $$0$i$i$i20 = $181 >>> 0 < $175 >>> 0 ? $175 : $181;
      } else $$0$i$i$i20 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i20, $174, $db + 12 | 0);
      $184 = $__v$i$i224 + 8 | 0;
      $185 = HEAP32[$184 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($185, $4);
      HEAP32[$184 >> 2] = $185 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($4);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 109:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($5, 13002);
     $188 = $db + 4 | 0;
     $189 = HEAP32[$188 >> 2] | 0;
     $191 = HEAP32[$db + 8 >> 2] | 0;
     if ($189 >>> 0 < $191 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($189, $5);
      HEAP32[$188 >> 2] = (HEAP32[$188 >> 2] | 0) + 24;
     } else {
      $198 = HEAP32[$db >> 2] | 0;
      $199 = $189 - $198 | 0;
      $200 = ($199 | 0) / 24 | 0;
      $201 = $200 + 1 | 0;
      if (($199 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $205 = ($191 - $198 | 0) / 24 | 0;
      if ($205 >>> 0 < 1073741823) {
       $207 = $205 << 1;
       $$0$i$i$i25 = $207 >>> 0 < $201 >>> 0 ? $201 : $207;
      } else $$0$i$i$i25 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i25, $200, $db + 12 | 0);
      $210 = $__v$i$i224 + 8 | 0;
      $211 = HEAP32[$210 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($211, $5);
      HEAP32[$210 >> 2] = $211 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($5);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 111:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($6, 13012);
     $214 = $db + 4 | 0;
     $215 = HEAP32[$214 >> 2] | 0;
     $217 = HEAP32[$db + 8 >> 2] | 0;
     if ($215 >>> 0 < $217 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($215, $6);
      HEAP32[$214 >> 2] = (HEAP32[$214 >> 2] | 0) + 24;
     } else {
      $224 = HEAP32[$db >> 2] | 0;
      $225 = $215 - $224 | 0;
      $226 = ($225 | 0) / 24 | 0;
      $227 = $226 + 1 | 0;
      if (($225 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $231 = ($217 - $224 | 0) / 24 | 0;
      if ($231 >>> 0 < 1073741823) {
       $233 = $231 << 1;
       $$0$i$i$i30 = $233 >>> 0 < $227 >>> 0 ? $227 : $233;
      } else $$0$i$i$i30 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i30, $226, $db + 12 | 0);
      $236 = $__v$i$i224 + 8 | 0;
      $237 = HEAP32[$236 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($237, $6);
      HEAP32[$236 >> 2] = $237 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($6);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 118:
    {
     $240 = $db + 63 | 0;
     $241 = HEAP8[$240 >> 0] | 0;
     HEAP8[$240 >> 0] = 0;
     $242 = $first + 2 | 0;
     $243 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($242, $last, $db) | 0;
     HEAP8[$240 >> 0] = $241;
     if (($243 | 0) == ($242 | 0)) {
      $$0 = $first;
      break L1;
     }
     $247 = HEAP32[$db + 4 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($247 | 0)) {
      $$0 = $first;
      break L1;
     }
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($247 + -24 | 0, 0, 13022) | 0;
     HEAP8[$db + 60 >> 0] = 1;
     $$0 = $243;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 100:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 97:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj18EEERAT__Kc($7, 13032);
     $254 = $db + 4 | 0;
     $255 = HEAP32[$254 >> 2] | 0;
     $257 = HEAP32[$db + 8 >> 2] | 0;
     if ($255 >>> 0 < $257 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($255, $7);
      HEAP32[$254 >> 2] = (HEAP32[$254 >> 2] | 0) + 24;
     } else {
      $264 = HEAP32[$db >> 2] | 0;
      $265 = $255 - $264 | 0;
      $266 = ($265 | 0) / 24 | 0;
      $267 = $266 + 1 | 0;
      if (($265 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $271 = ($257 - $264 | 0) / 24 | 0;
      if ($271 >>> 0 < 1073741823) {
       $273 = $271 << 1;
       $$0$i$i$i35 = $273 >>> 0 < $267 >>> 0 ? $267 : $273;
      } else $$0$i$i$i35 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i35, $266, $db + 12 | 0);
      $276 = $__v$i$i224 + 8 | 0;
      $277 = HEAP32[$276 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($277, $7);
      HEAP32[$276 >> 2] = $277 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($7);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 101:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($8, 13050);
     $280 = $db + 4 | 0;
     $281 = HEAP32[$280 >> 2] | 0;
     $283 = HEAP32[$db + 8 >> 2] | 0;
     if ($281 >>> 0 < $283 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($281, $8);
      HEAP32[$280 >> 2] = (HEAP32[$280 >> 2] | 0) + 24;
     } else {
      $290 = HEAP32[$db >> 2] | 0;
      $291 = $281 - $290 | 0;
      $292 = ($291 | 0) / 24 | 0;
      $293 = $292 + 1 | 0;
      if (($291 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $297 = ($283 - $290 | 0) / 24 | 0;
      if ($297 >>> 0 < 1073741823) {
       $299 = $297 << 1;
       $$0$i$i$i40 = $299 >>> 0 < $293 >>> 0 ? $293 : $299;
      } else $$0$i$i$i40 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i40, $292, $db + 12 | 0);
      $302 = $__v$i$i224 + 8 | 0;
      $303 = HEAP32[$302 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($303, $8);
      HEAP32[$302 >> 2] = $303 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($8);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 108:
    {
     $306 = _malloc(16) | 0;
     HEAP32[$9 + 8 >> 2] = $306;
     HEAP32[$9 >> 2] = 17;
     HEAP32[$9 + 4 >> 2] = 15;
     dest = $306;
     src = 13060;
     stop = dest + 15 | 0;
     do {
      HEAP8[dest >> 0] = HEAP8[src >> 0] | 0;
      dest = dest + 1 | 0;
      src = src + 1 | 0;
     } while ((dest | 0) < (stop | 0));
     HEAP8[$306 + 15 >> 0] = 0;
     $310 = $9 + 12 | 0;
     HEAP32[$310 >> 2] = 0;
     HEAP32[$310 + 4 >> 2] = 0;
     HEAP32[$310 + 8 >> 2] = 0;
     $313 = $db + 4 | 0;
     $314 = HEAP32[$313 >> 2] | 0;
     $316 = HEAP32[$db + 8 >> 2] | 0;
     if ($314 >>> 0 < $316 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($314, $9);
      HEAP32[$313 >> 2] = (HEAP32[$313 >> 2] | 0) + 24;
     } else {
      $323 = HEAP32[$db >> 2] | 0;
      $324 = $314 - $323 | 0;
      $325 = ($324 | 0) / 24 | 0;
      $326 = $325 + 1 | 0;
      if (($324 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $330 = ($316 - $323 | 0) / 24 | 0;
      if ($330 >>> 0 < 1073741823) {
       $332 = $330 << 1;
       $$0$i$i$i45 = $332 >>> 0 < $326 >>> 0 ? $326 : $332;
      } else $$0$i$i$i45 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i45, $325, $db + 12 | 0);
      $335 = $__v$i$i224 + 8 | 0;
      $336 = HEAP32[$335 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($336, $9);
      HEAP32[$335 >> 2] = $336 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($9);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 118:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($10, 13076);
     $339 = $db + 4 | 0;
     $340 = HEAP32[$339 >> 2] | 0;
     $342 = HEAP32[$db + 8 >> 2] | 0;
     if ($340 >>> 0 < $342 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($340, $10);
      HEAP32[$339 >> 2] = (HEAP32[$339 >> 2] | 0) + 24;
     } else {
      $349 = HEAP32[$db >> 2] | 0;
      $350 = $340 - $349 | 0;
      $351 = ($350 | 0) / 24 | 0;
      $352 = $351 + 1 | 0;
      if (($350 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $356 = ($342 - $349 | 0) / 24 | 0;
      if ($356 >>> 0 < 1073741823) {
       $358 = $356 << 1;
       $$0$i$i$i50 = $358 >>> 0 < $352 >>> 0 ? $352 : $358;
      } else $$0$i$i$i50 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i50, $351, $db + 12 | 0);
      $361 = $__v$i$i224 + 8 | 0;
      $362 = HEAP32[$361 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($362, $10);
      HEAP32[$361 >> 2] = $362 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($10);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 86:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($11, 13086);
     $365 = $db + 4 | 0;
     $366 = HEAP32[$365 >> 2] | 0;
     $368 = HEAP32[$db + 8 >> 2] | 0;
     if ($366 >>> 0 < $368 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($366, $11);
      HEAP32[$365 >> 2] = (HEAP32[$365 >> 2] | 0) + 24;
     } else {
      $375 = HEAP32[$db >> 2] | 0;
      $376 = $366 - $375 | 0;
      $377 = ($376 | 0) / 24 | 0;
      $378 = $377 + 1 | 0;
      if (($376 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $382 = ($368 - $375 | 0) / 24 | 0;
      if ($382 >>> 0 < 1073741823) {
       $384 = $382 << 1;
       $$0$i$i$i55 = $384 >>> 0 < $378 >>> 0 ? $378 : $384;
      } else $$0$i$i$i55 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i55, $377, $db + 12 | 0);
      $387 = $__v$i$i224 + 8 | 0;
      $388 = HEAP32[$387 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($388, $11);
      HEAP32[$387 >> 2] = $388 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($11);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 101:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 111:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($12, 13097);
     $394 = $db + 4 | 0;
     $395 = HEAP32[$394 >> 2] | 0;
     $397 = HEAP32[$db + 8 >> 2] | 0;
     if ($395 >>> 0 < $397 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($395, $12);
      HEAP32[$394 >> 2] = (HEAP32[$394 >> 2] | 0) + 24;
     } else {
      $404 = HEAP32[$db >> 2] | 0;
      $405 = $395 - $404 | 0;
      $406 = ($405 | 0) / 24 | 0;
      $407 = $406 + 1 | 0;
      if (($405 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $411 = ($397 - $404 | 0) / 24 | 0;
      if ($411 >>> 0 < 1073741823) {
       $413 = $411 << 1;
       $$0$i$i$i60 = $413 >>> 0 < $407 >>> 0 ? $407 : $413;
      } else $$0$i$i$i60 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i60, $406, $db + 12 | 0);
      $416 = $__v$i$i224 + 8 | 0;
      $417 = HEAP32[$416 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($417, $12);
      HEAP32[$416 >> 2] = $417 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($12);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 79:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($13, 13107);
     $420 = $db + 4 | 0;
     $421 = HEAP32[$420 >> 2] | 0;
     $423 = HEAP32[$db + 8 >> 2] | 0;
     if ($421 >>> 0 < $423 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($421, $13);
      HEAP32[$420 >> 2] = (HEAP32[$420 >> 2] | 0) + 24;
     } else {
      $430 = HEAP32[$db >> 2] | 0;
      $431 = $421 - $430 | 0;
      $432 = ($431 | 0) / 24 | 0;
      $433 = $432 + 1 | 0;
      if (($431 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $437 = ($423 - $430 | 0) / 24 | 0;
      if ($437 >>> 0 < 1073741823) {
       $439 = $437 << 1;
       $$0$i$i$i65 = $439 >>> 0 < $433 >>> 0 ? $433 : $439;
      } else $$0$i$i$i65 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i65, $432, $db + 12 | 0);
      $442 = $__v$i$i224 + 8 | 0;
      $443 = HEAP32[$442 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($443, $13);
      HEAP32[$442 >> 2] = $443 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($13);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 113:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($14, 13118);
     $446 = $db + 4 | 0;
     $447 = HEAP32[$446 >> 2] | 0;
     $449 = HEAP32[$db + 8 >> 2] | 0;
     if ($447 >>> 0 < $449 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($447, $14);
      HEAP32[$446 >> 2] = (HEAP32[$446 >> 2] | 0) + 24;
     } else {
      $456 = HEAP32[$db >> 2] | 0;
      $457 = $447 - $456 | 0;
      $458 = ($457 | 0) / 24 | 0;
      $459 = $458 + 1 | 0;
      if (($457 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $463 = ($449 - $456 | 0) / 24 | 0;
      if ($463 >>> 0 < 1073741823) {
       $465 = $463 << 1;
       $$0$i$i$i70 = $465 >>> 0 < $459 >>> 0 ? $459 : $465;
      } else $$0$i$i$i70 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i70, $458, $db + 12 | 0);
      $468 = $__v$i$i224 + 8 | 0;
      $469 = HEAP32[$468 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($469, $14);
      HEAP32[$468 >> 2] = $469 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($14);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 103:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 101:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($15, 13129);
     $475 = $db + 4 | 0;
     $476 = HEAP32[$475 >> 2] | 0;
     $478 = HEAP32[$db + 8 >> 2] | 0;
     if ($476 >>> 0 < $478 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($476, $15);
      HEAP32[$475 >> 2] = (HEAP32[$475 >> 2] | 0) + 24;
     } else {
      $485 = HEAP32[$db >> 2] | 0;
      $486 = $476 - $485 | 0;
      $487 = ($486 | 0) / 24 | 0;
      $488 = $487 + 1 | 0;
      if (($486 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $492 = ($478 - $485 | 0) / 24 | 0;
      if ($492 >>> 0 < 1073741823) {
       $494 = $492 << 1;
       $$0$i$i$i75 = $494 >>> 0 < $488 >>> 0 ? $488 : $494;
      } else $$0$i$i$i75 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i75, $487, $db + 12 | 0);
      $497 = $__v$i$i224 + 8 | 0;
      $498 = HEAP32[$497 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($498, $15);
      HEAP32[$497 >> 2] = $498 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($15);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 116:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($16, 13140);
     $501 = $db + 4 | 0;
     $502 = HEAP32[$501 >> 2] | 0;
     $504 = HEAP32[$db + 8 >> 2] | 0;
     if ($502 >>> 0 < $504 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($502, $16);
      HEAP32[$501 >> 2] = (HEAP32[$501 >> 2] | 0) + 24;
     } else {
      $511 = HEAP32[$db >> 2] | 0;
      $512 = $502 - $511 | 0;
      $513 = ($512 | 0) / 24 | 0;
      $514 = $513 + 1 | 0;
      if (($512 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $518 = ($504 - $511 | 0) / 24 | 0;
      if ($518 >>> 0 < 1073741823) {
       $520 = $518 << 1;
       $$0$i$i$i80 = $520 >>> 0 < $514 >>> 0 ? $514 : $520;
      } else $$0$i$i$i80 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i80, $513, $db + 12 | 0);
      $523 = $__v$i$i224 + 8 | 0;
      $524 = HEAP32[$523 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($524, $16);
      HEAP32[$523 >> 2] = $524 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($16);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 105:
  {
   if ((HEAP8[$first + 1 >> 0] | 0) != 120) {
    $$0 = $first;
    break L1;
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($17, 13150);
   $530 = $db + 4 | 0;
   $531 = HEAP32[$530 >> 2] | 0;
   $533 = HEAP32[$db + 8 >> 2] | 0;
   if ($531 >>> 0 < $533 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($531, $17);
    HEAP32[$530 >> 2] = (HEAP32[$530 >> 2] | 0) + 24;
   } else {
    $540 = HEAP32[$db >> 2] | 0;
    $541 = $531 - $540 | 0;
    $542 = ($541 | 0) / 24 | 0;
    $543 = $542 + 1 | 0;
    if (($541 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $547 = ($533 - $540 | 0) / 24 | 0;
    if ($547 >>> 0 < 1073741823) {
     $549 = $547 << 1;
     $$0$i$i$i85 = $549 >>> 0 < $543 >>> 0 ? $543 : $549;
    } else $$0$i$i$i85 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i85, $542, $db + 12 | 0);
    $552 = $__v$i$i224 + 8 | 0;
    $553 = HEAP32[$552 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($553, $17);
    HEAP32[$552 >> 2] = $553 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($17);
   $$0 = $first + 2 | 0;
   break L1;
   break;
  }
 case 108:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 101:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($18, 13161);
     $559 = $db + 4 | 0;
     $560 = HEAP32[$559 >> 2] | 0;
     $562 = HEAP32[$db + 8 >> 2] | 0;
     if ($560 >>> 0 < $562 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($560, $18);
      HEAP32[$559 >> 2] = (HEAP32[$559 >> 2] | 0) + 24;
     } else {
      $569 = HEAP32[$db >> 2] | 0;
      $570 = $560 - $569 | 0;
      $571 = ($570 | 0) / 24 | 0;
      $572 = $571 + 1 | 0;
      if (($570 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $576 = ($562 - $569 | 0) / 24 | 0;
      if ($576 >>> 0 < 1073741823) {
       $578 = $576 << 1;
       $$0$i$i$i90 = $578 >>> 0 < $572 >>> 0 ? $572 : $578;
      } else $$0$i$i$i90 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i90, $571, $db + 12 | 0);
      $581 = $__v$i$i224 + 8 | 0;
      $582 = HEAP32[$581 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($582, $18);
      HEAP32[$581 >> 2] = $582 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($18);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 105:
    {
     $585 = $first + 2 | 0;
     $586 = __ZN10__cxxabiv112_GLOBAL__N_117parse_source_nameINS0_2DbEEEPKcS4_S4_RT_($585, $last, $db) | 0;
     if (($586 | 0) == ($585 | 0)) {
      $$0 = $first;
      break L1;
     }
     $590 = HEAP32[$db + 4 >> 2] | 0;
     if ((HEAP32[$db >> 2] | 0) == ($590 | 0)) {
      $$0 = $first;
      break L1;
     }
     __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($590 + -24 | 0, 0, 13172) | 0;
     $$0 = $586;
     break L1;
     break;
    }
   case 115:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($19, 13184);
     $593 = $db + 4 | 0;
     $594 = HEAP32[$593 >> 2] | 0;
     $596 = HEAP32[$db + 8 >> 2] | 0;
     if ($594 >>> 0 < $596 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($594, $19);
      HEAP32[$593 >> 2] = (HEAP32[$593 >> 2] | 0) + 24;
     } else {
      $603 = HEAP32[$db >> 2] | 0;
      $604 = $594 - $603 | 0;
      $605 = ($604 | 0) / 24 | 0;
      $606 = $605 + 1 | 0;
      if (($604 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $610 = ($596 - $603 | 0) / 24 | 0;
      if ($610 >>> 0 < 1073741823) {
       $612 = $610 << 1;
       $$0$i$i$i95 = $612 >>> 0 < $606 >>> 0 ? $606 : $612;
      } else $$0$i$i$i95 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i95, $605, $db + 12 | 0);
      $615 = $__v$i$i224 + 8 | 0;
      $616 = HEAP32[$615 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($616, $19);
      HEAP32[$615 >> 2] = $616 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($19);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 83:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj12EEERAT__Kc($20, 13195);
     $619 = $db + 4 | 0;
     $620 = HEAP32[$619 >> 2] | 0;
     $622 = HEAP32[$db + 8 >> 2] | 0;
     if ($620 >>> 0 < $622 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($620, $20);
      HEAP32[$619 >> 2] = (HEAP32[$619 >> 2] | 0) + 24;
     } else {
      $629 = HEAP32[$db >> 2] | 0;
      $630 = $620 - $629 | 0;
      $631 = ($630 | 0) / 24 | 0;
      $632 = $631 + 1 | 0;
      if (($630 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $636 = ($622 - $629 | 0) / 24 | 0;
      if ($636 >>> 0 < 1073741823) {
       $638 = $636 << 1;
       $$0$i$i$i100 = $638 >>> 0 < $632 >>> 0 ? $632 : $638;
      } else $$0$i$i$i100 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i100, $631, $db + 12 | 0);
      $641 = $__v$i$i224 + 8 | 0;
      $642 = HEAP32[$641 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($642, $20);
      HEAP32[$641 >> 2] = $642 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($20);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 116:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($21, 13207);
     $645 = $db + 4 | 0;
     $646 = HEAP32[$645 >> 2] | 0;
     $648 = HEAP32[$db + 8 >> 2] | 0;
     if ($646 >>> 0 < $648 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($646, $21);
      HEAP32[$645 >> 2] = (HEAP32[$645 >> 2] | 0) + 24;
     } else {
      $655 = HEAP32[$db >> 2] | 0;
      $656 = $646 - $655 | 0;
      $657 = ($656 | 0) / 24 | 0;
      $658 = $657 + 1 | 0;
      if (($656 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $662 = ($648 - $655 | 0) / 24 | 0;
      if ($662 >>> 0 < 1073741823) {
       $664 = $662 << 1;
       $$0$i$i$i105 = $664 >>> 0 < $658 >>> 0 ? $658 : $664;
      } else $$0$i$i$i105 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i105, $657, $db + 12 | 0);
      $667 = $__v$i$i224 + 8 | 0;
      $668 = HEAP32[$667 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($668, $21);
      HEAP32[$667 >> 2] = $668 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($21);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 109:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 105:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($22, 13217);
     $674 = $db + 4 | 0;
     $675 = HEAP32[$674 >> 2] | 0;
     $677 = HEAP32[$db + 8 >> 2] | 0;
     if ($675 >>> 0 < $677 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($675, $22);
      HEAP32[$674 >> 2] = (HEAP32[$674 >> 2] | 0) + 24;
     } else {
      $684 = HEAP32[$db >> 2] | 0;
      $685 = $675 - $684 | 0;
      $686 = ($685 | 0) / 24 | 0;
      $687 = $686 + 1 | 0;
      if (($685 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $691 = ($677 - $684 | 0) / 24 | 0;
      if ($691 >>> 0 < 1073741823) {
       $693 = $691 << 1;
       $$0$i$i$i110 = $693 >>> 0 < $687 >>> 0 ? $687 : $693;
      } else $$0$i$i$i110 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i110, $686, $db + 12 | 0);
      $696 = $__v$i$i224 + 8 | 0;
      $697 = HEAP32[$696 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($697, $22);
      HEAP32[$696 >> 2] = $697 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($22);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 73:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($23, 13227);
     $700 = $db + 4 | 0;
     $701 = HEAP32[$700 >> 2] | 0;
     $703 = HEAP32[$db + 8 >> 2] | 0;
     if ($701 >>> 0 < $703 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($701, $23);
      HEAP32[$700 >> 2] = (HEAP32[$700 >> 2] | 0) + 24;
     } else {
      $710 = HEAP32[$db >> 2] | 0;
      $711 = $701 - $710 | 0;
      $712 = ($711 | 0) / 24 | 0;
      $713 = $712 + 1 | 0;
      if (($711 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $717 = ($703 - $710 | 0) / 24 | 0;
      if ($717 >>> 0 < 1073741823) {
       $719 = $717 << 1;
       $$0$i$i$i115 = $719 >>> 0 < $713 >>> 0 ? $713 : $719;
      } else $$0$i$i$i115 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i115, $712, $db + 12 | 0);
      $722 = $__v$i$i224 + 8 | 0;
      $723 = HEAP32[$722 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($723, $23);
      HEAP32[$722 >> 2] = $723 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($23);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 108:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($24, 13050);
     $726 = $db + 4 | 0;
     $727 = HEAP32[$726 >> 2] | 0;
     $729 = HEAP32[$db + 8 >> 2] | 0;
     if ($727 >>> 0 < $729 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($727, $24);
      HEAP32[$726 >> 2] = (HEAP32[$726 >> 2] | 0) + 24;
     } else {
      $736 = HEAP32[$db >> 2] | 0;
      $737 = $727 - $736 | 0;
      $738 = ($737 | 0) / 24 | 0;
      $739 = $738 + 1 | 0;
      if (($737 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $743 = ($729 - $736 | 0) / 24 | 0;
      if ($743 >>> 0 < 1073741823) {
       $745 = $743 << 1;
       $$0$i$i$i120 = $745 >>> 0 < $739 >>> 0 ? $739 : $745;
      } else $$0$i$i$i120 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i120, $738, $db + 12 | 0);
      $748 = $__v$i$i224 + 8 | 0;
      $749 = HEAP32[$748 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($749, $24);
      HEAP32[$748 >> 2] = $749 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($24);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 76:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($25, 13238);
     $752 = $db + 4 | 0;
     $753 = HEAP32[$752 >> 2] | 0;
     $755 = HEAP32[$db + 8 >> 2] | 0;
     if ($753 >>> 0 < $755 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($753, $25);
      HEAP32[$752 >> 2] = (HEAP32[$752 >> 2] | 0) + 24;
     } else {
      $762 = HEAP32[$db >> 2] | 0;
      $763 = $753 - $762 | 0;
      $764 = ($763 | 0) / 24 | 0;
      $765 = $764 + 1 | 0;
      if (($763 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $769 = ($755 - $762 | 0) / 24 | 0;
      if ($769 >>> 0 < 1073741823) {
       $771 = $769 << 1;
       $$0$i$i$i125 = $771 >>> 0 < $765 >>> 0 ? $765 : $771;
      } else $$0$i$i$i125 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i125, $764, $db + 12 | 0);
      $774 = $__v$i$i224 + 8 | 0;
      $775 = HEAP32[$774 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($775, $25);
      HEAP32[$774 >> 2] = $775 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($25);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 109:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($26, 13249);
     $778 = $db + 4 | 0;
     $779 = HEAP32[$778 >> 2] | 0;
     $781 = HEAP32[$db + 8 >> 2] | 0;
     if ($779 >>> 0 < $781 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($779, $26);
      HEAP32[$778 >> 2] = (HEAP32[$778 >> 2] | 0) + 24;
     } else {
      $788 = HEAP32[$db >> 2] | 0;
      $789 = $779 - $788 | 0;
      $790 = ($789 | 0) / 24 | 0;
      $791 = $790 + 1 | 0;
      if (($789 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $795 = ($781 - $788 | 0) / 24 | 0;
      if ($795 >>> 0 < 1073741823) {
       $797 = $795 << 1;
       $$0$i$i$i130 = $797 >>> 0 < $791 >>> 0 ? $791 : $797;
      } else $$0$i$i$i130 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i130, $790, $db + 12 | 0);
      $800 = $__v$i$i224 + 8 | 0;
      $801 = HEAP32[$800 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($801, $26);
      HEAP32[$800 >> 2] = $801 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($26);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 110:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 97:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj15EEERAT__Kc($27, 13260);
     $807 = $db + 4 | 0;
     $808 = HEAP32[$807 >> 2] | 0;
     $810 = HEAP32[$db + 8 >> 2] | 0;
     if ($808 >>> 0 < $810 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($808, $27);
      HEAP32[$807 >> 2] = (HEAP32[$807 >> 2] | 0) + 24;
     } else {
      $817 = HEAP32[$db >> 2] | 0;
      $818 = $808 - $817 | 0;
      $819 = ($818 | 0) / 24 | 0;
      $820 = $819 + 1 | 0;
      if (($818 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $824 = ($810 - $817 | 0) / 24 | 0;
      if ($824 >>> 0 < 1073741823) {
       $826 = $824 << 1;
       $$0$i$i$i135 = $826 >>> 0 < $820 >>> 0 ? $820 : $826;
      } else $$0$i$i$i135 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i135, $819, $db + 12 | 0);
      $829 = $__v$i$i224 + 8 | 0;
      $830 = HEAP32[$829 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($830, $27);
      HEAP32[$829 >> 2] = $830 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($27);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 101:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($28, 13275);
     $833 = $db + 4 | 0;
     $834 = HEAP32[$833 >> 2] | 0;
     $836 = HEAP32[$db + 8 >> 2] | 0;
     if ($834 >>> 0 < $836 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($834, $28);
      HEAP32[$833 >> 2] = (HEAP32[$833 >> 2] | 0) + 24;
     } else {
      $843 = HEAP32[$db >> 2] | 0;
      $844 = $834 - $843 | 0;
      $845 = ($844 | 0) / 24 | 0;
      $846 = $845 + 1 | 0;
      if (($844 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $850 = ($836 - $843 | 0) / 24 | 0;
      if ($850 >>> 0 < 1073741823) {
       $852 = $850 << 1;
       $$0$i$i$i140 = $852 >>> 0 < $846 >>> 0 ? $846 : $852;
      } else $$0$i$i$i140 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i140, $845, $db + 12 | 0);
      $855 = $__v$i$i224 + 8 | 0;
      $856 = HEAP32[$855 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($856, $28);
      HEAP32[$855 >> 2] = $856 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($28);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 103:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($29, 13217);
     $859 = $db + 4 | 0;
     $860 = HEAP32[$859 >> 2] | 0;
     $862 = HEAP32[$db + 8 >> 2] | 0;
     if ($860 >>> 0 < $862 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($860, $29);
      HEAP32[$859 >> 2] = (HEAP32[$859 >> 2] | 0) + 24;
     } else {
      $869 = HEAP32[$db >> 2] | 0;
      $870 = $860 - $869 | 0;
      $871 = ($870 | 0) / 24 | 0;
      $872 = $871 + 1 | 0;
      if (($870 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $876 = ($862 - $869 | 0) / 24 | 0;
      if ($876 >>> 0 < 1073741823) {
       $878 = $876 << 1;
       $$0$i$i$i145 = $878 >>> 0 < $872 >>> 0 ? $872 : $878;
      } else $$0$i$i$i145 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i145, $871, $db + 12 | 0);
      $881 = $__v$i$i224 + 8 | 0;
      $882 = HEAP32[$881 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($882, $29);
      HEAP32[$881 >> 2] = $882 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($29);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 116:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($30, 13286);
     $885 = $db + 4 | 0;
     $886 = HEAP32[$885 >> 2] | 0;
     $888 = HEAP32[$db + 8 >> 2] | 0;
     if ($886 >>> 0 < $888 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($886, $30);
      HEAP32[$885 >> 2] = (HEAP32[$885 >> 2] | 0) + 24;
     } else {
      $895 = HEAP32[$db >> 2] | 0;
      $896 = $886 - $895 | 0;
      $897 = ($896 | 0) / 24 | 0;
      $898 = $897 + 1 | 0;
      if (($896 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $902 = ($888 - $895 | 0) / 24 | 0;
      if ($902 >>> 0 < 1073741823) {
       $904 = $902 << 1;
       $$0$i$i$i150 = $904 >>> 0 < $898 >>> 0 ? $898 : $904;
      } else $$0$i$i$i150 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i150, $897, $db + 12 | 0);
      $907 = $__v$i$i224 + 8 | 0;
      $908 = HEAP32[$907 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($908, $30);
      HEAP32[$907 >> 2] = $908 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($30);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 119:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj13EEERAT__Kc($31, 13296);
     $911 = $db + 4 | 0;
     $912 = HEAP32[$911 >> 2] | 0;
     $914 = HEAP32[$db + 8 >> 2] | 0;
     if ($912 >>> 0 < $914 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($912, $31);
      HEAP32[$911 >> 2] = (HEAP32[$911 >> 2] | 0) + 24;
     } else {
      $921 = HEAP32[$db >> 2] | 0;
      $922 = $912 - $921 | 0;
      $923 = ($922 | 0) / 24 | 0;
      $924 = $923 + 1 | 0;
      if (($922 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $928 = ($914 - $921 | 0) / 24 | 0;
      if ($928 >>> 0 < 1073741823) {
       $930 = $928 << 1;
       $$0$i$i$i155 = $930 >>> 0 < $924 >>> 0 ? $924 : $930;
      } else $$0$i$i$i155 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i155, $923, $db + 12 | 0);
      $933 = $__v$i$i224 + 8 | 0;
      $934 = HEAP32[$933 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($934, $31);
      HEAP32[$933 >> 2] = $934 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($31);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 111:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 111:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($32, 13309);
     $940 = $db + 4 | 0;
     $941 = HEAP32[$940 >> 2] | 0;
     $943 = HEAP32[$db + 8 >> 2] | 0;
     if ($941 >>> 0 < $943 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($941, $32);
      HEAP32[$940 >> 2] = (HEAP32[$940 >> 2] | 0) + 24;
     } else {
      $950 = HEAP32[$db >> 2] | 0;
      $951 = $941 - $950 | 0;
      $952 = ($951 | 0) / 24 | 0;
      $953 = $952 + 1 | 0;
      if (($951 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $957 = ($943 - $950 | 0) / 24 | 0;
      if ($957 >>> 0 < 1073741823) {
       $959 = $957 << 1;
       $$0$i$i$i160 = $959 >>> 0 < $953 >>> 0 ? $953 : $959;
      } else $$0$i$i$i160 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i160, $952, $db + 12 | 0);
      $962 = $__v$i$i224 + 8 | 0;
      $963 = HEAP32[$962 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($963, $32);
      HEAP32[$962 >> 2] = $963 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($32);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 114:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($33, 13320);
     $966 = $db + 4 | 0;
     $967 = HEAP32[$966 >> 2] | 0;
     $969 = HEAP32[$db + 8 >> 2] | 0;
     if ($967 >>> 0 < $969 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($967, $33);
      HEAP32[$966 >> 2] = (HEAP32[$966 >> 2] | 0) + 24;
     } else {
      $976 = HEAP32[$db >> 2] | 0;
      $977 = $967 - $976 | 0;
      $978 = ($977 | 0) / 24 | 0;
      $979 = $978 + 1 | 0;
      if (($977 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $983 = ($969 - $976 | 0) / 24 | 0;
      if ($983 >>> 0 < 1073741823) {
       $985 = $983 << 1;
       $$0$i$i$i165 = $985 >>> 0 < $979 >>> 0 ? $979 : $985;
      } else $$0$i$i$i165 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i165, $978, $db + 12 | 0);
      $988 = $__v$i$i224 + 8 | 0;
      $989 = HEAP32[$988 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($989, $33);
      HEAP32[$988 >> 2] = $989 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($33);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 82:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($34, 13330);
     $992 = $db + 4 | 0;
     $993 = HEAP32[$992 >> 2] | 0;
     $995 = HEAP32[$db + 8 >> 2] | 0;
     if ($993 >>> 0 < $995 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($993, $34);
      HEAP32[$992 >> 2] = (HEAP32[$992 >> 2] | 0) + 24;
     } else {
      $1002 = HEAP32[$db >> 2] | 0;
      $1003 = $993 - $1002 | 0;
      $1004 = ($1003 | 0) / 24 | 0;
      $1005 = $1004 + 1 | 0;
      if (($1003 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1009 = ($995 - $1002 | 0) / 24 | 0;
      if ($1009 >>> 0 < 1073741823) {
       $1011 = $1009 << 1;
       $$0$i$i$i170 = $1011 >>> 0 < $1005 >>> 0 ? $1005 : $1011;
      } else $$0$i$i$i170 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i170, $1004, $db + 12 | 0);
      $1014 = $__v$i$i224 + 8 | 0;
      $1015 = HEAP32[$1014 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1015, $34);
      HEAP32[$1014 >> 2] = $1015 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($34);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 112:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 109:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj12EEERAT__Kc($35, 13341);
     $1021 = $db + 4 | 0;
     $1022 = HEAP32[$1021 >> 2] | 0;
     $1024 = HEAP32[$db + 8 >> 2] | 0;
     if ($1022 >>> 0 < $1024 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1022, $35);
      HEAP32[$1021 >> 2] = (HEAP32[$1021 >> 2] | 0) + 24;
     } else {
      $1031 = HEAP32[$db >> 2] | 0;
      $1032 = $1022 - $1031 | 0;
      $1033 = ($1032 | 0) / 24 | 0;
      $1034 = $1033 + 1 | 0;
      if (($1032 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1038 = ($1024 - $1031 | 0) / 24 | 0;
      if ($1038 >>> 0 < 1073741823) {
       $1040 = $1038 << 1;
       $$0$i$i$i175 = $1040 >>> 0 < $1034 >>> 0 ? $1034 : $1040;
      } else $$0$i$i$i175 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i175, $1033, $db + 12 | 0);
      $1043 = $__v$i$i224 + 8 | 0;
      $1044 = HEAP32[$1043 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1044, $35);
      HEAP32[$1043 >> 2] = $1044 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($35);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 108:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($36, 13353);
     $1047 = $db + 4 | 0;
     $1048 = HEAP32[$1047 >> 2] | 0;
     $1050 = HEAP32[$db + 8 >> 2] | 0;
     if ($1048 >>> 0 < $1050 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1048, $36);
      HEAP32[$1047 >> 2] = (HEAP32[$1047 >> 2] | 0) + 24;
     } else {
      $1057 = HEAP32[$db >> 2] | 0;
      $1058 = $1048 - $1057 | 0;
      $1059 = ($1058 | 0) / 24 | 0;
      $1060 = $1059 + 1 | 0;
      if (($1058 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1064 = ($1050 - $1057 | 0) / 24 | 0;
      if ($1064 >>> 0 < 1073741823) {
       $1066 = $1064 << 1;
       $$0$i$i$i180 = $1066 >>> 0 < $1060 >>> 0 ? $1060 : $1066;
      } else $$0$i$i$i180 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i180, $1059, $db + 12 | 0);
      $1069 = $__v$i$i224 + 8 | 0;
      $1070 = HEAP32[$1069 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1070, $36);
      HEAP32[$1069 >> 2] = $1070 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($36);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 76:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($37, 13363);
     $1073 = $db + 4 | 0;
     $1074 = HEAP32[$1073 >> 2] | 0;
     $1076 = HEAP32[$db + 8 >> 2] | 0;
     if ($1074 >>> 0 < $1076 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1074, $37);
      HEAP32[$1073 >> 2] = (HEAP32[$1073 >> 2] | 0) + 24;
     } else {
      $1083 = HEAP32[$db >> 2] | 0;
      $1084 = $1074 - $1083 | 0;
      $1085 = ($1084 | 0) / 24 | 0;
      $1086 = $1085 + 1 | 0;
      if (($1084 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1090 = ($1076 - $1083 | 0) / 24 | 0;
      if ($1090 >>> 0 < 1073741823) {
       $1092 = $1090 << 1;
       $$0$i$i$i185 = $1092 >>> 0 < $1086 >>> 0 ? $1086 : $1092;
      } else $$0$i$i$i185 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i185, $1085, $db + 12 | 0);
      $1095 = $__v$i$i224 + 8 | 0;
      $1096 = HEAP32[$1095 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1096, $37);
      HEAP32[$1095 >> 2] = $1096 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($37);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 112:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($38, 13374);
     $1099 = $db + 4 | 0;
     $1100 = HEAP32[$1099 >> 2] | 0;
     $1102 = HEAP32[$db + 8 >> 2] | 0;
     if ($1100 >>> 0 < $1102 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1100, $38);
      HEAP32[$1099 >> 2] = (HEAP32[$1099 >> 2] | 0) + 24;
     } else {
      $1109 = HEAP32[$db >> 2] | 0;
      $1110 = $1100 - $1109 | 0;
      $1111 = ($1110 | 0) / 24 | 0;
      $1112 = $1111 + 1 | 0;
      if (($1110 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1116 = ($1102 - $1109 | 0) / 24 | 0;
      if ($1116 >>> 0 < 1073741823) {
       $1118 = $1116 << 1;
       $$0$i$i$i190 = $1118 >>> 0 < $1112 >>> 0 ? $1112 : $1118;
      } else $$0$i$i$i190 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i190, $1111, $db + 12 | 0);
      $1121 = $__v$i$i224 + 8 | 0;
      $1122 = HEAP32[$1121 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1122, $38);
      HEAP32[$1121 >> 2] = $1122 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($38);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 115:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($39, 13353);
     $1125 = $db + 4 | 0;
     $1126 = HEAP32[$1125 >> 2] | 0;
     $1128 = HEAP32[$db + 8 >> 2] | 0;
     if ($1126 >>> 0 < $1128 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1126, $39);
      HEAP32[$1125 >> 2] = (HEAP32[$1125 >> 2] | 0) + 24;
     } else {
      $1135 = HEAP32[$db >> 2] | 0;
      $1136 = $1126 - $1135 | 0;
      $1137 = ($1136 | 0) / 24 | 0;
      $1138 = $1137 + 1 | 0;
      if (($1136 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1142 = ($1128 - $1135 | 0) / 24 | 0;
      if ($1142 >>> 0 < 1073741823) {
       $1144 = $1142 << 1;
       $$0$i$i$i195 = $1144 >>> 0 < $1138 >>> 0 ? $1138 : $1144;
      } else $$0$i$i$i195 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i195, $1137, $db + 12 | 0);
      $1147 = $__v$i$i224 + 8 | 0;
      $1148 = HEAP32[$1147 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1148, $39);
      HEAP32[$1147 >> 2] = $1148 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($39);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 116:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($40, 13385);
     $1151 = $db + 4 | 0;
     $1152 = HEAP32[$1151 >> 2] | 0;
     $1154 = HEAP32[$db + 8 >> 2] | 0;
     if ($1152 >>> 0 < $1154 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1152, $40);
      HEAP32[$1151 >> 2] = (HEAP32[$1151 >> 2] | 0) + 24;
     } else {
      $1161 = HEAP32[$db >> 2] | 0;
      $1162 = $1152 - $1161 | 0;
      $1163 = ($1162 | 0) / 24 | 0;
      $1164 = $1163 + 1 | 0;
      if (($1162 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1168 = ($1154 - $1161 | 0) / 24 | 0;
      if ($1168 >>> 0 < 1073741823) {
       $1170 = $1168 << 1;
       $$0$i$i$i200 = $1170 >>> 0 < $1164 >>> 0 ? $1164 : $1170;
      } else $$0$i$i$i200 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i200, $1163, $db + 12 | 0);
      $1173 = $__v$i$i224 + 8 | 0;
      $1174 = HEAP32[$1173 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1174, $40);
      HEAP32[$1173 >> 2] = $1174 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($40);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 113:
  {
   if ((HEAP8[$first + 1 >> 0] | 0) != 117) {
    $$0 = $first;
    break L1;
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($41, 13396);
   $1180 = $db + 4 | 0;
   $1181 = HEAP32[$1180 >> 2] | 0;
   $1183 = HEAP32[$db + 8 >> 2] | 0;
   if ($1181 >>> 0 < $1183 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1181, $41);
    HEAP32[$1180 >> 2] = (HEAP32[$1180 >> 2] | 0) + 24;
   } else {
    $1190 = HEAP32[$db >> 2] | 0;
    $1191 = $1181 - $1190 | 0;
    $1192 = ($1191 | 0) / 24 | 0;
    $1193 = $1192 + 1 | 0;
    if (($1191 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $1197 = ($1183 - $1190 | 0) / 24 | 0;
    if ($1197 >>> 0 < 1073741823) {
     $1199 = $1197 << 1;
     $$0$i$i$i205 = $1199 >>> 0 < $1193 >>> 0 ? $1193 : $1199;
    } else $$0$i$i$i205 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i205, $1192, $db + 12 | 0);
    $1202 = $__v$i$i224 + 8 | 0;
    $1203 = HEAP32[$1202 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1203, $41);
    HEAP32[$1202 >> 2] = $1203 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($41);
   $$0 = $first + 2 | 0;
   break L1;
   break;
  }
 case 114:
  {
   switch (HEAP8[$first + 1 >> 0] | 0) {
   case 109:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($42, 13406);
     $1209 = $db + 4 | 0;
     $1210 = HEAP32[$1209 >> 2] | 0;
     $1212 = HEAP32[$db + 8 >> 2] | 0;
     if ($1210 >>> 0 < $1212 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1210, $42);
      HEAP32[$1209 >> 2] = (HEAP32[$1209 >> 2] | 0) + 24;
     } else {
      $1219 = HEAP32[$db >> 2] | 0;
      $1220 = $1210 - $1219 | 0;
      $1221 = ($1220 | 0) / 24 | 0;
      $1222 = $1221 + 1 | 0;
      if (($1220 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1226 = ($1212 - $1219 | 0) / 24 | 0;
      if ($1226 >>> 0 < 1073741823) {
       $1228 = $1226 << 1;
       $$0$i$i$i210 = $1228 >>> 0 < $1222 >>> 0 ? $1222 : $1228;
      } else $$0$i$i$i210 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i210, $1221, $db + 12 | 0);
      $1231 = $__v$i$i224 + 8 | 0;
      $1232 = HEAP32[$1231 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1232, $42);
      HEAP32[$1231 >> 2] = $1232 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($42);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 77:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($43, 13416);
     $1235 = $db + 4 | 0;
     $1236 = HEAP32[$1235 >> 2] | 0;
     $1238 = HEAP32[$db + 8 >> 2] | 0;
     if ($1236 >>> 0 < $1238 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1236, $43);
      HEAP32[$1235 >> 2] = (HEAP32[$1235 >> 2] | 0) + 24;
     } else {
      $1245 = HEAP32[$db >> 2] | 0;
      $1246 = $1236 - $1245 | 0;
      $1247 = ($1246 | 0) / 24 | 0;
      $1248 = $1247 + 1 | 0;
      if (($1246 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1252 = ($1238 - $1245 | 0) / 24 | 0;
      if ($1252 >>> 0 < 1073741823) {
       $1254 = $1252 << 1;
       $$0$i$i$i215 = $1254 >>> 0 < $1248 >>> 0 ? $1248 : $1254;
      } else $$0$i$i$i215 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i215, $1247, $db + 12 | 0);
      $1257 = $__v$i$i224 + 8 | 0;
      $1258 = HEAP32[$1257 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1258, $43);
      HEAP32[$1257 >> 2] = $1258 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($43);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 115:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($44, 13427);
     $1261 = $db + 4 | 0;
     $1262 = HEAP32[$1261 >> 2] | 0;
     $1264 = HEAP32[$db + 8 >> 2] | 0;
     if ($1262 >>> 0 < $1264 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1262, $44);
      HEAP32[$1261 >> 2] = (HEAP32[$1261 >> 2] | 0) + 24;
     } else {
      $1271 = HEAP32[$db >> 2] | 0;
      $1272 = $1262 - $1271 | 0;
      $1273 = ($1272 | 0) / 24 | 0;
      $1274 = $1273 + 1 | 0;
      if (($1272 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1278 = ($1264 - $1271 | 0) / 24 | 0;
      if ($1278 >>> 0 < 1073741823) {
       $1280 = $1278 << 1;
       $$0$i$i$i220 = $1280 >>> 0 < $1274 >>> 0 ? $1274 : $1280;
      } else $$0$i$i$i220 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i220, $1273, $db + 12 | 0);
      $1283 = $__v$i$i224 + 8 | 0;
      $1284 = HEAP32[$1283 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1284, $44);
      HEAP32[$1283 >> 2] = $1284 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($44);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 83:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj12EEERAT__Kc($45, 13438);
     $1287 = $db + 4 | 0;
     $1288 = HEAP32[$1287 >> 2] | 0;
     $1290 = HEAP32[$db + 8 >> 2] | 0;
     if ($1288 >>> 0 < $1290 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1288, $45);
      HEAP32[$1287 >> 2] = (HEAP32[$1287 >> 2] | 0) + 24;
     } else {
      $1297 = HEAP32[$db >> 2] | 0;
      $1298 = $1288 - $1297 | 0;
      $1299 = ($1298 | 0) / 24 | 0;
      $1300 = $1299 + 1 | 0;
      if (($1298 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $1304 = ($1290 - $1297 | 0) / 24 | 0;
      if ($1304 >>> 0 < 1073741823) {
       $1306 = $1304 << 1;
       $$0$i$i$i225 = $1306 >>> 0 < $1300 >>> 0 ? $1300 : $1306;
      } else $$0$i$i$i225 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i224, $$0$i$i$i225, $1299, $db + 12 | 0);
      $1309 = $__v$i$i224 + 8 | 0;
      $1310 = HEAP32[$1309 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($1310, $45);
      HEAP32[$1309 >> 2] = $1310 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i224);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i224);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($45);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 case 118:
  {
   if (((HEAP8[$first + 1 >> 0] | 0) + -48 | 0) >>> 0 >= 10) {
    $$0 = $first;
    break L1;
   }
   $1316 = $first + 2 | 0;
   $1317 = __ZN10__cxxabiv112_GLOBAL__N_117parse_source_nameINS0_2DbEEEPKcS4_S4_RT_($1316, $last, $db) | 0;
   if (($1317 | 0) == ($1316 | 0)) {
    $$0 = $first;
    break L1;
   }
   $1321 = HEAP32[$db + 4 >> 2] | 0;
   if ((HEAP32[$db >> 2] | 0) == ($1321 | 0)) {
    $$0 = $first;
    break L1;
   }
   __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($1321 + -24 | 0, 0, 13022) | 0;
   $$0 = $1317;
   break L1;
   break;
  }
 default:
  {
   $$0 = $first;
   break L1;
  }
 } while (0); else $$0 = $first; while (0);
 STACKTOP = sp;
 return $$0 | 0;
}
function _arPattGetImage2($imageProcMode, $pattDetectMode, $patt_size, $sample_size, $image, $xsize, $ysize, $pixelFormat, $paramLTf, $vertex, $pattRatio, $ext_patt) {
 $imageProcMode = $imageProcMode | 0;
 $pattDetectMode = $pattDetectMode | 0;
 $patt_size = $patt_size | 0;
 $sample_size = $sample_size | 0;
 $image = $image | 0;
 $xsize = $xsize | 0;
 $ysize = $ysize | 0;
 $pixelFormat = $pixelFormat | 0;
 $paramLTf = $paramLTf | 0;
 $vertex = $vertex | 0;
 $pattRatio = +$pattRatio;
 $ext_patt = $ext_patt | 0;
 var $$0 = 0, $100 = 0, $1001 = 0, $1005 = 0, $1009 = 0, $1012 = 0, $1023 = 0.0, $1028 = 0.0, $103 = 0.0, $1035 = 0.0, $104 = 0.0, $1045 = 0.0, $1054 = 0.0, $1055 = 0.0, $106 = 0, $107 = 0, $1074 = 0, $108 = 0, $1084 = 0, $1090 = 0.0, $1096 = 0.0, $1097 = 0.0, $110 = 0.0, $1101 = 0, $1107 = 0, $111 = 0.0, $1111 = 0, $1113 = 0, $1119 = 0, $112 = 0.0, $1120 = 0, $1124 = 0, $1128 = 0, $113 = 0, $1132 = 0, $1135 = 0, $114 = 0, $1146 = 0.0, $115 = 0, $1151 = 0.0, $1158 = 0.0, $116 = 0, $1168 = 0.0, $117 = 0, $1177 = 0.0, $1178 = 0.0, $118 = 0, $119 = 0, $1199 = 0, $120 = 0, $1203 = 0, $121 = 0, $1211 = 0, $1212 = 0, $1217 = 0, $1225 = 0, $123 = 0, $1231 = 0, $124 = 0.0, $1242 = 0.0, $1247 = 0.0, $125 = 0.0, $1254 = 0.0, $126 = 0.0, $1264 = 0.0, $127 = 0, $1273 = 0.0, $1274 = 0.0, $128 = 0, $129 = 0, $1295 = 0, $1299 = 0, $130 = 0, $1307 = 0, $1308 = 0, $131 = 0, $1313 = 0, $132 = 0, $1321 = 0, $1327 = 0, $133 = 0, $1338 = 0.0, $134 = 0, $1343 = 0.0, $135 = 0, $1350 = 0.0, $1360 = 0.0, $1369 = 0.0, $137 = 0, $1370 = 0.0, $138 = 0.0, $139 = 0.0, $1391 = 0, $140 = 0.0, $1402 = 0, $1403 = 0, $1408 = 0, $141 = 0, $1413 = 0, $1419 = 0, $142 = 0, $143 = 0, $1433 = 0, $1436 = 0.0, $1437 = 0.0, $1438 = 0.0, $1439 = 0, $144 = 0, $1440 = 0, $1441 = 0, $1442 = 0, $1443 = 0, $1444 = 0, $1445 = 0, $1446 = 0, $1447 = 0, $1449 = 0, $145 = 0, $1450 = 0, $1456 = 0.0, $146 = 0, $1461 = 0.0, $1468 = 0.0, $147 = 0, $1478 = 0.0, $148 = 0, $1487 = 0.0, $1488 = 0.0, $149 = 0, $1509 = 0, $151 = 0, $152 = 0.0, $1528 = 0, $153 = 0.0, $1537 = 0.0, $1538 = 0.0, $1539 = 0.0, $154 = 0.0, $1540 = 0, $1541 = 0, $1542 = 0, $1543 = 0, $1544 = 0, $1545 = 0, $1546 = 0, $1547 = 0, $1548 = 0, $155 = 0, $1550 = 0, $1555 = 0.0, $156 = 0, $1560 = 0.0, $1567 = 0.0, $157 = 0, $1577 = 0.0, $158 = 0, $1586 = 0.0, $1587 = 0.0, $159 = 0, $160 = 0, $1608 = 0, $161 = 0, $162 = 0, $1627 = 0, $163 = 0, $1636 = 0.0, $1637 = 0.0, $1638 = 0.0, $1639 = 0, $1640 = 0, $1641 = 0, $1642 = 0, $1643 = 0, $1644 = 0, $1645 = 0, $1646 = 0, $1647 = 0, $1649 = 0, $165 = 0, $1654 = 0.0, $1659 = 0.0, $166 = 0.0, $1666 = 0.0, $167 = 0.0, $1676 = 0.0, $168 = 0.0, $1685 = 0.0, $1686 = 0.0, $169 = 0, $170 = 0, $1707 = 0, $171 = 0, $172 = 0, $1727 = 0, $173 = 0, $1734 = 0.0, $1735 = 0.0, $1736 = 0.0, $1737 = 0, $1738 = 0, $1739 = 0, $174 = 0, $1740 = 0, $1741 = 0, $1742 = 0, $1743 = 0, $1744 = 0, $1745 = 0, $1747 = 0, $1748 = 0.0, $1749 = 0.0, $175 = 0, $1750 = 0.0, $1751 = 0, $1752 = 0, $1753 = 0, $1754 = 0, $1755 = 0, $1756 = 0, $1757 = 0, $1758 = 0, $1759 = 0, $176 = 0, $1761 = 0, $1762 = 0.0, $1763 = 0.0, $1764 = 0.0, $1765 = 0, $1766 = 0, $1767 = 0, $1768 = 0, $1769 = 0, $177 = 0, $1770 = 0, $1771 = 0, $1772 = 0, $1773 = 0, $1775 = 0, $1776 = 0.0, $1777 = 0.0, $1778 = 0.0, $1779 = 0, $1780 = 0, $1781 = 0, $1782 = 0, $1783 = 0, $1784 = 0, $1785 = 0, $1786 = 0, $1787 = 0, $1789 = 0, $179 = 0, $1790 = 0.0, $1791 = 0.0, $1792 = 0.0, $1793 = 0, $1794 = 0, $1795 = 0, $1796 = 0, $1797 = 0, $1798 = 0, $1799 = 0, $180 = 0.0, $1800 = 0, $1801 = 0, $1803 = 0, $1804 = 0.0, $1805 = 0.0, $1806 = 0.0, $1807 = 0, $1808 = 0, $1809 = 0, $181 = 0.0, $1810 = 0, $1811 = 0, $1812 = 0, $1813 = 0, $1814 = 0, $1815 = 0, $1817 = 0, $182 = 0.0, $1822 = 0.0, $1827 = 0.0, $183 = 0, $1834 = 0.0, $184 = 0, $1844 = 0.0, $185 = 0, $1853 = 0.0, $1854 = 0.0, $186 = 0, $187 = 0, $1875 = 0, $188 = 0, $1882 = 0, $189 = 0, $1893 = 0.0, $1898 = 0.0, $190 = 0, $1905 = 0.0, $191 = 0, $1915 = 0.0, $1924 = 0.0, $1925 = 0.0, $193 = 0, $194 = 0.0, $1948 = 0, $195 = 0.0, $1955 = 0, $196 = 0.0, $1966 = 0.0, $197 = 0, $1971 = 0.0, $1978 = 0.0, $198 = 0, $1988 = 0.0, $199 = 0, $1997 = 0.0, $1998 = 0.0, $200 = 0, $201 = 0, $202 = 0, $2020 = 0, $2027 = 0, $203 = 0, $2038 = 0.0, $204 = 0, $2043 = 0.0, $205 = 0, $2050 = 0.0, $2060 = 0.0, $2069 = 0.0, $207 = 0, $2070 = 0.0, $208 = 0.0, $209 = 0.0, $2091 = 0, $2094 = 0, $210 = 0.0, $2102 = 0, $211 = 0, $2117 = 0, $212 = 0, $2128 = 0.0, $213 = 0, $2133 = 0.0, $214 = 0, $2140 = 0.0, $215 = 0, $2150 = 0.0, $2159 = 0.0, $216 = 0, $2160 = 0.0, $217 = 0, $218 = 0, $2181 = 0, $2184 = 0, $219 = 0, $2192 = 0, $2207 = 0, $221 = 0, $2218 = 0.0, $222 = 0.0, $2223 = 0.0, $223 = 0.0, $2230 = 0.0, $224 = 0.0, $2240 = 0.0, $2249 = 0.0, $225 = 0, $2250 = 0.0, $226 = 0, $227 = 0, $2271 = 0, $2274 = 0, $228 = 0, $229 = 0, $2293 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $235 = 0, $236 = 0.0, $237 = 0.0, $238 = 0.0, $239 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $249 = 0, $250 = 0.0, $251 = 0.0, $252 = 0.0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $260 = 0, $261 = 0, $263 = 0, $264 = 0.0, $265 = 0.0, $266 = 0.0, $267 = 0, $268 = 0, $269 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $277 = 0, $278 = 0, $284 = 0.0, $289 = 0.0, $29 = 0.0, $296 = 0.0, $306 = 0.0, $31 = 0.0, $315 = 0.0, $316 = 0.0, $32 = 0.0, $337 = 0, $346 = 0, $347 = 0, $35 = 0.0, $355 = 0, $362 = 0, $37 = 0.0, $373 = 0.0, $378 = 0.0, $38 = 0.0, $385 = 0.0, $395 = 0.0, $404 = 0.0, $405 = 0.0, $41 = 0, $426 = 0, $43 = 0.0, $434 = 0, $435 = 0, $443 = 0, $45 = 0.0, $451 = 0, $46 = 0.0, $462 = 0.0, $467 = 0.0, $474 = 0.0, $484 = 0.0, $49 = 0.0, $493 = 0.0, $494 = 0.0, $51 = 0.0, $515 = 0, $52 = 0.0, $524 = 0, $525 = 0, $533 = 0, $540 = 0, $55 = 0, $551 = 0.0, $556 = 0.0, $56 = 0.0, $563 = 0.0, $573 = 0.0, $58 = 0.0, $582 = 0.0, $583 = 0.0, $604 = 0, $61 = 0, $612 = 0, $613 = 0, $62 = 0.0, $621 = 0, $629 = 0, $64 = 0.0, $640 = 0.0, $645 = 0.0, $652 = 0.0, $662 = 0.0, $67 = 0, $671 = 0.0, $672 = 0.0, $693 = 0, $702 = 0, $703 = 0, $711 = 0, $719 = 0, $73 = 0, $730 = 0.0, $735 = 0.0, $742 = 0.0, $752 = 0.0, $761 = 0.0, $762 = 0.0, $77 = 0, $783 = 0, $785 = 0, $790 = 0, $791 = 0, $795 = 0, $799 = 0, $810 = 0.0, $815 = 0.0, $822 = 0.0, $832 = 0.0, $841 = 0.0, $842 = 0.0, $863 = 0, $872 = 0, $873 = 0, $881 = 0, $889 = 0, $900 = 0.0, $905 = 0.0, $912 = 0.0, $922 = 0.0, $931 = 0.0, $932 = 0.0, $951 = 0, $954 = 0, $959 = 0.0, $973 = 0.0, $974 = 0.0, $978 = 0, $984 = 0, $988 = 0, $99 = 0, $990 = 0, $996 = 0, $997 = 0, $ext_patt2$0 = 0, $i$10291 = 0, $i$11297 = 0, $i$12303 = 0, $i$1237 = 0, $i$13236 = 0, $i$14312 = 0, $i$15318 = 0, $i$16324 = 0, $i$17330 = 0, $i$18336 = 0, $i$19342 = 0, $i$20348 = 0, $i$21354 = 0, $i$22360 = 0, $i$2243 = 0, $i$23309 = 0, $i$3249 = 0, $i$4255 = 0, $i$5261 = 0, $i$6267 = 0, $i$7273 = 0, $i$8279 = 0, $i$9285 = 0, $j$0241 = 0, $j$10301 = 0, $j$11307 = 0, $j$12316 = 0, $j$1247 = 0, $j$13322 = 0, $j$14328 = 0, $j$15334 = 0, $j$16340 = 0, $j$17346 = 0, $j$18352 = 0, $j$19358 = 0, $j$20364 = 0, $j$2253 = 0, $j$3259 = 0, $j$4265 = 0, $j$5271 = 0, $j$6277 = 0, $j$7283 = 0, $j$8289 = 0, $j$9295 = 0, $local = 0, $para = 0, $sample_size$xdiv2$2 = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer3 = 0, $vararg_buffer5 = 0, $world = 0, $xc$0 = 0, $xc$1 = 0, $xc$10 = 0, $xc$11 = 0, $xc$12 = 0, $xc$13 = 0, $xc$14 = 0, $xc$15 = 0, $xc$16 = 0, $xc$17 = 0, $xc$18 = 0, $xc$19 = 0, $xc$2 = 0, $xc$20 = 0, $xc$3 = 0, $xc$4 = 0, $xc$5 = 0, $xc$6 = 0, $xc$7 = 0, $xc$8 = 0, $xc$9 = 0, $xc2 = 0, $xdiv2$0 = 0, $xdiv2$0$lcssa = 0, $xdiv2$1 = 0, $xdiv2$1$lcssa = 0, $xdiv2$2 = 0, $yc$0 = 0, $yc$1 = 0, $yc$10 = 0, $yc$11 = 0, $yc$12 = 0, $yc$13 = 0, $yc$14 = 0, $yc$15 = 0, $yc$16 = 0, $yc$17 = 0, $yc$18 = 0, $yc$19 = 0, $yc$2 = 0, $yc$20 = 0, $yc$3 = 0, $yc$4 = 0, $yc$5 = 0, $yc$6 = 0, $yc$7 = 0, $yc$8 = 0, $yc$9 = 0, $yc2 = 0, $ydiv2$0 = 0, $ydiv2$1 = 0, $ydiv2$2 = 0, $ydiv2$3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 240 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $vararg_buffer5 = sp + 224 | 0;
 $vararg_buffer3 = sp + 216 | 0;
 $vararg_buffer1 = sp + 208 | 0;
 $vararg_buffer = sp + 200 | 0;
 $world = sp + 136 | 0;
 $local = sp + 72 | 0;
 $para = sp;
 $xc2 = sp + 232 | 0;
 $yc2 = sp + 228 | 0;
 HEAPF64[$world >> 3] = 100.0;
 HEAPF64[$world + 8 >> 3] = 100.0;
 HEAPF64[$world + 16 >> 3] = 110.0;
 HEAPF64[$world + 24 >> 3] = 100.0;
 HEAPF64[$world + 32 >> 3] = 110.0;
 HEAPF64[$world + 40 >> 3] = 110.0;
 HEAPF64[$world + 48 >> 3] = 100.0;
 HEAPF64[$world + 56 >> 3] = 110.0;
 HEAPF64[$local >> 3] = +HEAPF64[$vertex >> 3];
 HEAPF64[$local + 8 >> 3] = +HEAPF64[$vertex + 8 >> 3];
 HEAPF64[$local + 16 >> 3] = +HEAPF64[$vertex + 16 >> 3];
 HEAPF64[$local + 24 >> 3] = +HEAPF64[$vertex + 24 >> 3];
 HEAPF64[$local + 32 >> 3] = +HEAPF64[$vertex + 32 >> 3];
 HEAPF64[$local + 40 >> 3] = +HEAPF64[$vertex + 40 >> 3];
 HEAPF64[$local + 48 >> 3] = +HEAPF64[$vertex + 48 >> 3];
 HEAPF64[$local + 56 >> 3] = +HEAPF64[$vertex + 56 >> 3];
 _get_cpara($world, $local, $para);
 $29 = +HEAPF64[$local >> 3];
 $31 = +HEAPF64[$local + 16 >> 3];
 $32 = $29 - $31;
 $35 = +HEAPF64[$local + 8 >> 3];
 $37 = +HEAPF64[$local + 24 >> 3];
 $38 = $35 - $37;
 $41 = ~~($32 * $32 + $38 * $38);
 $43 = +HEAPF64[$local + 32 >> 3];
 $45 = +HEAPF64[$local + 48 >> 3];
 $46 = $43 - $45;
 $49 = +HEAPF64[$local + 40 >> 3];
 $51 = +HEAPF64[$local + 56 >> 3];
 $52 = $49 - $51;
 $55 = ~~($46 * $46 + $52 * $52);
 $56 = $31 - $43;
 $58 = $37 - $49;
 $61 = ~~($56 * $56 + $58 * $58);
 $62 = $45 - $29;
 $64 = $51 - $35;
 $67 = ~~($62 * $62 + $64 * $64);
 $73 = ~~(+((($55 | 0) > ($41 | 0) ? $55 : $41) | 0) * $pattRatio * $pattRatio);
 $77 = ~~(+((($67 | 0) > ($61 | 0) ? $67 : $61) | 0) * $pattRatio * $pattRatio);
 if (!$imageProcMode) {
  $xdiv2$0 = $patt_size;
  while (1) if (($xdiv2$0 | 0) < ($sample_size | 0) & (Math_imul($xdiv2$0, $xdiv2$0) | 0) < ($73 | 0)) $xdiv2$0 = $xdiv2$0 << 1; else {
   $xdiv2$0$lcssa = $xdiv2$0;
   break;
  }
  $ydiv2$0 = $patt_size;
  while (1) if (($ydiv2$0 | 0) < ($sample_size | 0) & (Math_imul($ydiv2$0, $ydiv2$0) | 0) < ($77 | 0)) $ydiv2$0 = $ydiv2$0 << 1; else {
   $xdiv2$2 = $xdiv2$0$lcssa;
   $ydiv2$2 = $ydiv2$0;
   break;
  }
 } else {
  $xdiv2$1 = $patt_size;
  while (1) if (($xdiv2$1 | 0) < ($sample_size | 0) & (Math_imul($xdiv2$1 << 2, $xdiv2$1) | 0) < ($73 | 0)) $xdiv2$1 = $xdiv2$1 << 1; else {
   $xdiv2$1$lcssa = $xdiv2$1;
   break;
  }
  $ydiv2$1 = $patt_size;
  while (1) if (($ydiv2$1 | 0) < ($sample_size | 0) & (Math_imul($ydiv2$1 << 2, $ydiv2$1) | 0) < ($77 | 0)) $ydiv2$1 = $ydiv2$1 << 1; else {
   $xdiv2$2 = $xdiv2$1$lcssa;
   $ydiv2$2 = $ydiv2$1;
   break;
  }
 }
 $sample_size$xdiv2$2 = ($xdiv2$2 | 0) > ($sample_size | 0) ? $sample_size : $xdiv2$2;
 $ydiv2$3 = ($ydiv2$2 | 0) > ($sample_size | 0) ? $sample_size : $ydiv2$2;
 $99 = ($sample_size$xdiv2$2 | 0) / ($patt_size | 0) | 0;
 $100 = ($ydiv2$3 | 0) / ($patt_size | 0) | 0;
 $103 = (1.0 - $pattRatio) * .5 * 10.0;
 $104 = $pattRatio * 10.0;
 $106 = Math_imul($patt_size, $patt_size) | 0;
 L13 : do if (!$pattDetectMode) {
  $107 = $106 * 3 | 0;
  $108 = _calloc($107, 4) | 0;
  if (!$108) {
   _arLog(3, 5471, $vararg_buffer);
   _exit(1);
  }
  do switch ($pixelFormat | 0) {
  case 0:
   {
    $264 = $103 + 100.0;
    $265 = +($ydiv2$3 | 0);
    $266 = +($sample_size$xdiv2$2 | 0);
    $267 = $para + 48 | 0;
    $268 = $para + 56 | 0;
    $269 = $para + 64 | 0;
    $270 = $para + 8 | 0;
    $271 = $para + 16 | 0;
    $272 = $para + 24 | 0;
    $273 = $para + 32 | 0;
    $274 = $para + 40 | 0;
    $275 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $277 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$0241 = 0;
     do {
      $284 = $264 + $104 * (+($j$0241 | 0) + .5) / $265;
      if ($277) {
       $i$1237 = 0;
       do {
        $289 = $264 + $104 * (+($i$1237 | 0) + .5) / $266;
        $296 = +HEAPF64[$269 >> 3] + (+HEAPF64[$267 >> 3] * $289 + $284 * +HEAPF64[$268 >> 3]);
        if ($296 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $306 = (+HEAPF64[$271 >> 3] + ($289 * +HEAPF64[$para >> 3] + $284 * +HEAPF64[$270 >> 3])) / $296;
        HEAPF32[$xc2 >> 2] = $306;
        $315 = (+HEAPF64[$274 >> 3] + ($289 * +HEAPF64[$272 >> 3] + $284 * +HEAPF64[$273 >> 3])) / $296;
        HEAPF32[$yc2 >> 2] = $315;
        _arParamIdeal2ObservLTf($paramLTf, $306, $315, $xc2, $yc2) | 0;
        $316 = +HEAPF32[$xc2 >> 2];
        if ($275) {
         $xc$0 = ((~~($316 + 1.0) | 0) / 2 | 0) << 1;
         $yc$0 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$0 = ~~($316 + .5);
         $yc$0 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$0 | 0) > -1) if (($yc$0 | 0) < ($ysize | 0) & (($yc$0 | 0) > -1 & ($xc$0 | 0) < ($xsize | 0))) {
         $337 = ((Math_imul($yc$0, $xsize) | 0) + $xc$0 | 0) * 3 | 0;
         $346 = ((Math_imul(($j$0241 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$1237 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $347 = $108 + ($346 << 2) | 0;
         HEAP32[$347 >> 2] = (HEAP32[$347 >> 2] | 0) + (HEAPU8[$image + ($337 + 2) >> 0] | 0);
         $355 = $108 + ($346 + 1 << 2) | 0;
         HEAP32[$355 >> 2] = (HEAP32[$355 >> 2] | 0) + (HEAPU8[$image + ($337 + 1) >> 0] | 0);
         $362 = $108 + ($346 + 2 << 2) | 0;
         HEAP32[$362 >> 2] = (HEAP32[$362 >> 2] | 0) + (HEAPU8[$image + $337 >> 0] | 0);
        }
        $i$1237 = $i$1237 + 1 | 0;
       } while (($i$1237 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$0241 = $j$0241 + 1 | 0;
     } while (($j$0241 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 1:
   {
    $250 = $103 + 100.0;
    $251 = +($ydiv2$3 | 0);
    $252 = +($sample_size$xdiv2$2 | 0);
    $253 = $para + 48 | 0;
    $254 = $para + 56 | 0;
    $255 = $para + 64 | 0;
    $256 = $para + 8 | 0;
    $257 = $para + 16 | 0;
    $258 = $para + 24 | 0;
    $259 = $para + 32 | 0;
    $260 = $para + 40 | 0;
    $261 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $263 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$1247 = 0;
     do {
      $373 = $250 + $104 * (+($j$1247 | 0) + .5) / $251;
      if ($263) {
       $i$2243 = 0;
       do {
        $378 = $250 + $104 * (+($i$2243 | 0) + .5) / $252;
        $385 = +HEAPF64[$255 >> 3] + (+HEAPF64[$253 >> 3] * $378 + $373 * +HEAPF64[$254 >> 3]);
        if ($385 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $395 = (+HEAPF64[$257 >> 3] + ($378 * +HEAPF64[$para >> 3] + $373 * +HEAPF64[$256 >> 3])) / $385;
        HEAPF32[$xc2 >> 2] = $395;
        $404 = (+HEAPF64[$260 >> 3] + ($378 * +HEAPF64[$258 >> 3] + $373 * +HEAPF64[$259 >> 3])) / $385;
        HEAPF32[$yc2 >> 2] = $404;
        _arParamIdeal2ObservLTf($paramLTf, $395, $404, $xc2, $yc2) | 0;
        $405 = +HEAPF32[$xc2 >> 2];
        if ($261) {
         $xc$1 = ((~~($405 + 1.0) | 0) / 2 | 0) << 1;
         $yc$1 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$1 = ~~($405 + .5);
         $yc$1 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$1 | 0) > -1) if (($yc$1 | 0) < ($ysize | 0) & (($yc$1 | 0) > -1 & ($xc$1 | 0) < ($xsize | 0))) {
         $426 = ((Math_imul($yc$1, $xsize) | 0) + $xc$1 | 0) * 3 | 0;
         $434 = ((Math_imul(($j$1247 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$2243 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $435 = $108 + ($434 << 2) | 0;
         HEAP32[$435 >> 2] = (HEAP32[$435 >> 2] | 0) + (HEAPU8[$image + $426 >> 0] | 0);
         $443 = $108 + ($434 + 1 << 2) | 0;
         HEAP32[$443 >> 2] = (HEAP32[$443 >> 2] | 0) + (HEAPU8[$image + ($426 + 1) >> 0] | 0);
         $451 = $108 + ($434 + 2 << 2) | 0;
         HEAP32[$451 >> 2] = (HEAP32[$451 >> 2] | 0) + (HEAPU8[$image + ($426 + 2) >> 0] | 0);
        }
        $i$2243 = $i$2243 + 1 | 0;
       } while (($i$2243 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$1247 = $j$1247 + 1 | 0;
     } while (($j$1247 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 2:
   {
    $236 = $103 + 100.0;
    $237 = +($ydiv2$3 | 0);
    $238 = +($sample_size$xdiv2$2 | 0);
    $239 = $para + 48 | 0;
    $240 = $para + 56 | 0;
    $241 = $para + 64 | 0;
    $242 = $para + 8 | 0;
    $243 = $para + 16 | 0;
    $244 = $para + 24 | 0;
    $245 = $para + 32 | 0;
    $246 = $para + 40 | 0;
    $247 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $249 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$2253 = 0;
     do {
      $462 = $236 + $104 * (+($j$2253 | 0) + .5) / $237;
      if ($249) {
       $i$3249 = 0;
       do {
        $467 = $236 + $104 * (+($i$3249 | 0) + .5) / $238;
        $474 = +HEAPF64[$241 >> 3] + (+HEAPF64[$239 >> 3] * $467 + $462 * +HEAPF64[$240 >> 3]);
        if ($474 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $484 = (+HEAPF64[$243 >> 3] + ($467 * +HEAPF64[$para >> 3] + $462 * +HEAPF64[$242 >> 3])) / $474;
        HEAPF32[$xc2 >> 2] = $484;
        $493 = (+HEAPF64[$246 >> 3] + ($467 * +HEAPF64[$244 >> 3] + $462 * +HEAPF64[$245 >> 3])) / $474;
        HEAPF32[$yc2 >> 2] = $493;
        _arParamIdeal2ObservLTf($paramLTf, $484, $493, $xc2, $yc2) | 0;
        $494 = +HEAPF32[$xc2 >> 2];
        if ($247) {
         $xc$2 = ((~~($494 + 1.0) | 0) / 2 | 0) << 1;
         $yc$2 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$2 = ~~($494 + .5);
         $yc$2 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$2 | 0) > -1) if (($yc$2 | 0) < ($ysize | 0) & (($yc$2 | 0) > -1 & ($xc$2 | 0) < ($xsize | 0))) {
         $515 = (Math_imul($yc$2, $xsize) | 0) + $xc$2 << 2;
         $524 = ((Math_imul(($j$2253 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$3249 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $525 = $108 + ($524 << 2) | 0;
         HEAP32[$525 >> 2] = (HEAP32[$525 >> 2] | 0) + (HEAPU8[$image + ($515 | 2) >> 0] | 0);
         $533 = $108 + ($524 + 1 << 2) | 0;
         HEAP32[$533 >> 2] = (HEAP32[$533 >> 2] | 0) + (HEAPU8[$image + ($515 | 1) >> 0] | 0);
         $540 = $108 + ($524 + 2 << 2) | 0;
         HEAP32[$540 >> 2] = (HEAP32[$540 >> 2] | 0) + (HEAPU8[$image + $515 >> 0] | 0);
        }
        $i$3249 = $i$3249 + 1 | 0;
       } while (($i$3249 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$2253 = $j$2253 + 1 | 0;
     } while (($j$2253 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 3:
   {
    $222 = $103 + 100.0;
    $223 = +($ydiv2$3 | 0);
    $224 = +($sample_size$xdiv2$2 | 0);
    $225 = $para + 48 | 0;
    $226 = $para + 56 | 0;
    $227 = $para + 64 | 0;
    $228 = $para + 8 | 0;
    $229 = $para + 16 | 0;
    $230 = $para + 24 | 0;
    $231 = $para + 32 | 0;
    $232 = $para + 40 | 0;
    $233 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $235 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$3259 = 0;
     do {
      $551 = $222 + $104 * (+($j$3259 | 0) + .5) / $223;
      if ($235) {
       $i$4255 = 0;
       do {
        $556 = $222 + $104 * (+($i$4255 | 0) + .5) / $224;
        $563 = +HEAPF64[$227 >> 3] + (+HEAPF64[$225 >> 3] * $556 + $551 * +HEAPF64[$226 >> 3]);
        if ($563 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $573 = (+HEAPF64[$229 >> 3] + ($556 * +HEAPF64[$para >> 3] + $551 * +HEAPF64[$228 >> 3])) / $563;
        HEAPF32[$xc2 >> 2] = $573;
        $582 = (+HEAPF64[$232 >> 3] + ($556 * +HEAPF64[$230 >> 3] + $551 * +HEAPF64[$231 >> 3])) / $563;
        HEAPF32[$yc2 >> 2] = $582;
        _arParamIdeal2ObservLTf($paramLTf, $573, $582, $xc2, $yc2) | 0;
        $583 = +HEAPF32[$xc2 >> 2];
        if ($233) {
         $xc$3 = ((~~($583 + 1.0) | 0) / 2 | 0) << 1;
         $yc$3 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$3 = ~~($583 + .5);
         $yc$3 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$3 | 0) > -1) if (($yc$3 | 0) < ($ysize | 0) & (($yc$3 | 0) > -1 & ($xc$3 | 0) < ($xsize | 0))) {
         $604 = (Math_imul($yc$3, $xsize) | 0) + $xc$3 << 2;
         $612 = ((Math_imul(($j$3259 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$4255 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $613 = $108 + ($612 << 2) | 0;
         HEAP32[$613 >> 2] = (HEAP32[$613 >> 2] | 0) + (HEAPU8[$image + $604 >> 0] | 0);
         $621 = $108 + ($612 + 1 << 2) | 0;
         HEAP32[$621 >> 2] = (HEAP32[$621 >> 2] | 0) + (HEAPU8[$image + ($604 | 1) >> 0] | 0);
         $629 = $108 + ($612 + 2 << 2) | 0;
         HEAP32[$629 >> 2] = (HEAP32[$629 >> 2] | 0) + (HEAPU8[$image + ($604 | 2) >> 0] | 0);
        }
        $i$4255 = $i$4255 + 1 | 0;
       } while (($i$4255 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$3259 = $j$3259 + 1 | 0;
     } while (($j$3259 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 4:
   {
    $208 = $103 + 100.0;
    $209 = +($ydiv2$3 | 0);
    $210 = +($sample_size$xdiv2$2 | 0);
    $211 = $para + 48 | 0;
    $212 = $para + 56 | 0;
    $213 = $para + 64 | 0;
    $214 = $para + 8 | 0;
    $215 = $para + 16 | 0;
    $216 = $para + 24 | 0;
    $217 = $para + 32 | 0;
    $218 = $para + 40 | 0;
    $219 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $221 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$4265 = 0;
     do {
      $640 = $208 + $104 * (+($j$4265 | 0) + .5) / $209;
      if ($221) {
       $i$5261 = 0;
       do {
        $645 = $208 + $104 * (+($i$5261 | 0) + .5) / $210;
        $652 = +HEAPF64[$213 >> 3] + (+HEAPF64[$211 >> 3] * $645 + $640 * +HEAPF64[$212 >> 3]);
        if ($652 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $662 = (+HEAPF64[$215 >> 3] + ($645 * +HEAPF64[$para >> 3] + $640 * +HEAPF64[$214 >> 3])) / $652;
        HEAPF32[$xc2 >> 2] = $662;
        $671 = (+HEAPF64[$218 >> 3] + ($645 * +HEAPF64[$216 >> 3] + $640 * +HEAPF64[$217 >> 3])) / $652;
        HEAPF32[$yc2 >> 2] = $671;
        _arParamIdeal2ObservLTf($paramLTf, $662, $671, $xc2, $yc2) | 0;
        $672 = +HEAPF32[$xc2 >> 2];
        if ($219) {
         $xc$4 = ((~~($672 + 1.0) | 0) / 2 | 0) << 1;
         $yc$4 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$4 = ~~($672 + .5);
         $yc$4 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$4 | 0) > -1) if (($yc$4 | 0) < ($ysize | 0) & (($yc$4 | 0) > -1 & ($xc$4 | 0) < ($xsize | 0))) {
         $693 = (Math_imul($yc$4, $xsize) | 0) + $xc$4 << 2;
         $702 = ((Math_imul(($j$4265 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$5261 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $703 = $108 + ($702 << 2) | 0;
         HEAP32[$703 >> 2] = (HEAP32[$703 >> 2] | 0) + (HEAPU8[$image + ($693 | 1) >> 0] | 0);
         $711 = $108 + ($702 + 1 << 2) | 0;
         HEAP32[$711 >> 2] = (HEAP32[$711 >> 2] | 0) + (HEAPU8[$image + ($693 | 2) >> 0] | 0);
         $719 = $108 + ($702 + 2 << 2) | 0;
         HEAP32[$719 >> 2] = (HEAP32[$719 >> 2] | 0) + (HEAPU8[$image + ($693 | 3) >> 0] | 0);
        }
        $i$5261 = $i$5261 + 1 | 0;
       } while (($i$5261 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$4265 = $j$4265 + 1 | 0;
     } while (($j$4265 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 5:
  case 12:
  case 13:
  case 14:
   {
    $194 = $103 + 100.0;
    $195 = +($ydiv2$3 | 0);
    $196 = +($sample_size$xdiv2$2 | 0);
    $197 = $para + 48 | 0;
    $198 = $para + 56 | 0;
    $199 = $para + 64 | 0;
    $200 = $para + 8 | 0;
    $201 = $para + 16 | 0;
    $202 = $para + 24 | 0;
    $203 = $para + 32 | 0;
    $204 = $para + 40 | 0;
    $205 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $207 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$5271 = 0;
     do {
      $730 = $194 + $104 * (+($j$5271 | 0) + .5) / $195;
      if ($207) {
       $i$6267 = 0;
       do {
        $735 = $194 + $104 * (+($i$6267 | 0) + .5) / $196;
        $742 = +HEAPF64[$199 >> 3] + (+HEAPF64[$197 >> 3] * $735 + $730 * +HEAPF64[$198 >> 3]);
        if ($742 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $752 = (+HEAPF64[$201 >> 3] + ($735 * +HEAPF64[$para >> 3] + $730 * +HEAPF64[$200 >> 3])) / $742;
        HEAPF32[$xc2 >> 2] = $752;
        $761 = (+HEAPF64[$204 >> 3] + ($735 * +HEAPF64[$202 >> 3] + $730 * +HEAPF64[$203 >> 3])) / $742;
        HEAPF32[$yc2 >> 2] = $761;
        _arParamIdeal2ObservLTf($paramLTf, $752, $761, $xc2, $yc2) | 0;
        $762 = +HEAPF32[$xc2 >> 2];
        if ($205) {
         $xc$5 = ((~~($762 + 1.0) | 0) / 2 | 0) << 1;
         $yc$5 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$5 = ~~($762 + .5);
         $yc$5 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$5 | 0) > -1) if (($yc$5 | 0) < ($ysize | 0) & (($yc$5 | 0) > -1 & ($xc$5 | 0) < ($xsize | 0))) {
         $783 = $image + ((Math_imul($yc$5, $xsize) | 0) + $xc$5) | 0;
         $785 = HEAPU8[$783 >> 0] | 0;
         $790 = ((Math_imul(($j$5271 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$6267 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $791 = $108 + ($790 << 2) | 0;
         HEAP32[$791 >> 2] = (HEAP32[$791 >> 2] | 0) + $785;
         $795 = $108 + ($790 + 1 << 2) | 0;
         HEAP32[$795 >> 2] = (HEAP32[$795 >> 2] | 0) + $785;
         $799 = $108 + ($790 + 2 << 2) | 0;
         HEAP32[$799 >> 2] = (HEAP32[$799 >> 2] | 0) + $785;
        }
        $i$6267 = $i$6267 + 1 | 0;
       } while (($i$6267 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$5271 = $j$5271 + 1 | 0;
     } while (($j$5271 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 6:
   {
    $180 = $103 + 100.0;
    $181 = +($ydiv2$3 | 0);
    $182 = +($sample_size$xdiv2$2 | 0);
    $183 = $para + 48 | 0;
    $184 = $para + 56 | 0;
    $185 = $para + 64 | 0;
    $186 = $para + 8 | 0;
    $187 = $para + 16 | 0;
    $188 = $para + 24 | 0;
    $189 = $para + 32 | 0;
    $190 = $para + 40 | 0;
    $191 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $193 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$6277 = 0;
     do {
      $810 = $180 + $104 * (+($j$6277 | 0) + .5) / $181;
      if ($193) {
       $i$7273 = 0;
       do {
        $815 = $180 + $104 * (+($i$7273 | 0) + .5) / $182;
        $822 = +HEAPF64[$185 >> 3] + (+HEAPF64[$183 >> 3] * $815 + $810 * +HEAPF64[$184 >> 3]);
        if ($822 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $832 = (+HEAPF64[$187 >> 3] + ($815 * +HEAPF64[$para >> 3] + $810 * +HEAPF64[$186 >> 3])) / $822;
        HEAPF32[$xc2 >> 2] = $832;
        $841 = (+HEAPF64[$190 >> 3] + ($815 * +HEAPF64[$188 >> 3] + $810 * +HEAPF64[$189 >> 3])) / $822;
        HEAPF32[$yc2 >> 2] = $841;
        _arParamIdeal2ObservLTf($paramLTf, $832, $841, $xc2, $yc2) | 0;
        $842 = +HEAPF32[$xc2 >> 2];
        if ($191) {
         $xc$6 = ((~~($842 + 1.0) | 0) / 2 | 0) << 1;
         $yc$6 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$6 = ~~($842 + .5);
         $yc$6 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$6 | 0) > -1) if (($yc$6 | 0) < ($ysize | 0) & (($yc$6 | 0) > -1 & ($xc$6 | 0) < ($xsize | 0))) {
         $863 = (Math_imul($yc$6, $xsize) | 0) + $xc$6 << 2;
         $872 = ((Math_imul(($j$6277 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$7273 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $873 = $108 + ($872 << 2) | 0;
         HEAP32[$873 >> 2] = (HEAP32[$873 >> 2] | 0) + (HEAPU8[$image + ($863 | 3) >> 0] | 0);
         $881 = $108 + ($872 + 1 << 2) | 0;
         HEAP32[$881 >> 2] = (HEAP32[$881 >> 2] | 0) + (HEAPU8[$image + ($863 | 2) >> 0] | 0);
         $889 = $108 + ($872 + 2 << 2) | 0;
         HEAP32[$889 >> 2] = (HEAP32[$889 >> 2] | 0) + (HEAPU8[$image + ($863 | 1) >> 0] | 0);
        }
        $i$7273 = $i$7273 + 1 | 0;
       } while (($i$7273 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$6277 = $j$6277 + 1 | 0;
     } while (($j$6277 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 7:
   {
    $166 = $103 + 100.0;
    $167 = +($ydiv2$3 | 0);
    $168 = +($sample_size$xdiv2$2 | 0);
    $169 = $para + 48 | 0;
    $170 = $para + 56 | 0;
    $171 = $para + 64 | 0;
    $172 = $para + 8 | 0;
    $173 = $para + 16 | 0;
    $174 = $para + 24 | 0;
    $175 = $para + 32 | 0;
    $176 = $para + 40 | 0;
    $177 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $179 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$7283 = 0;
     do {
      $900 = $166 + $104 * (+($j$7283 | 0) + .5) / $167;
      if ($179) {
       $i$8279 = 0;
       do {
        $905 = $166 + $104 * (+($i$8279 | 0) + .5) / $168;
        $912 = +HEAPF64[$171 >> 3] + (+HEAPF64[$169 >> 3] * $905 + $900 * +HEAPF64[$170 >> 3]);
        if ($912 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $922 = (+HEAPF64[$173 >> 3] + ($905 * +HEAPF64[$para >> 3] + $900 * +HEAPF64[$172 >> 3])) / $912;
        HEAPF32[$xc2 >> 2] = $922;
        $931 = (+HEAPF64[$176 >> 3] + ($905 * +HEAPF64[$174 >> 3] + $900 * +HEAPF64[$175 >> 3])) / $912;
        HEAPF32[$yc2 >> 2] = $931;
        _arParamIdeal2ObservLTf($paramLTf, $922, $931, $xc2, $yc2) | 0;
        $932 = +HEAPF32[$xc2 >> 2];
        if ($177) {
         $xc$7 = ((~~($932 + 1.0) | 0) / 2 | 0) << 1;
         $yc$7 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$7 = ~~($932 + .5);
         $yc$7 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$7 | 0) > -1) if (($yc$7 | 0) < ($ysize | 0) & (($yc$7 | 0) > -1 & ($xc$7 | 0) < ($xsize | 0))) {
         $951 = Math_imul($yc$7, $xsize) | 0;
         $954 = ($xc$7 & 65534) + $951 << 1;
         $959 = +((HEAPU8[$image + $954 >> 0] | 0) + -128 | 0);
         $973 = +((HEAPU8[$image + ($954 + 2) >> 0] | 0) + -128 | 0);
         $974 = +((HEAPU8[$image + ($951 + $xc$7 << 1 | 1) >> 0] | 0) + -16 | 0) * 298.0820007324219;
         $978 = ~~($959 * 516.4110107421875 + $974) >> 8;
         $984 = ~~($974 - $959 * 100.29100036621094 - $973 * 208.1199951171875) >> 8;
         $988 = ~~($974 + $973 * 408.5830078125) >> 8;
         $990 = ($978 | 0) > 0 ? $978 : 0;
         $996 = ((Math_imul(($j$7283 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$8279 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $997 = $108 + ($996 << 2) | 0;
         HEAP32[$997 >> 2] = (($990 | 0) < 255 ? $990 : 255) + (HEAP32[$997 >> 2] | 0);
         $1001 = ($984 | 0) > 0 ? $984 : 0;
         $1005 = $108 + ($996 + 1 << 2) | 0;
         HEAP32[$1005 >> 2] = (($1001 | 0) < 255 ? $1001 : 255) + (HEAP32[$1005 >> 2] | 0);
         $1009 = ($988 | 0) > 0 ? $988 : 0;
         $1012 = $108 + ($996 + 2 << 2) | 0;
         HEAP32[$1012 >> 2] = (($1009 | 0) < 255 ? $1009 : 255) + (HEAP32[$1012 >> 2] | 0);
        }
        $i$8279 = $i$8279 + 1 | 0;
       } while (($i$8279 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$7283 = $j$7283 + 1 | 0;
     } while (($j$7283 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 8:
   {
    $152 = $103 + 100.0;
    $153 = +($ydiv2$3 | 0);
    $154 = +($sample_size$xdiv2$2 | 0);
    $155 = $para + 48 | 0;
    $156 = $para + 56 | 0;
    $157 = $para + 64 | 0;
    $158 = $para + 8 | 0;
    $159 = $para + 16 | 0;
    $160 = $para + 24 | 0;
    $161 = $para + 32 | 0;
    $162 = $para + 40 | 0;
    $163 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $165 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$8289 = 0;
     do {
      $1023 = $152 + $104 * (+($j$8289 | 0) + .5) / $153;
      if ($165) {
       $i$9285 = 0;
       do {
        $1028 = $152 + $104 * (+($i$9285 | 0) + .5) / $154;
        $1035 = +HEAPF64[$157 >> 3] + (+HEAPF64[$155 >> 3] * $1028 + $1023 * +HEAPF64[$156 >> 3]);
        if ($1035 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $1045 = (+HEAPF64[$159 >> 3] + ($1028 * +HEAPF64[$para >> 3] + $1023 * +HEAPF64[$158 >> 3])) / $1035;
        HEAPF32[$xc2 >> 2] = $1045;
        $1054 = (+HEAPF64[$162 >> 3] + ($1028 * +HEAPF64[$160 >> 3] + $1023 * +HEAPF64[$161 >> 3])) / $1035;
        HEAPF32[$yc2 >> 2] = $1054;
        _arParamIdeal2ObservLTf($paramLTf, $1045, $1054, $xc2, $yc2) | 0;
        $1055 = +HEAPF32[$xc2 >> 2];
        if ($163) {
         $xc$8 = ((~~($1055 + 1.0) | 0) / 2 | 0) << 1;
         $yc$8 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$8 = ~~($1055 + .5);
         $yc$8 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$8 | 0) > -1) if (($yc$8 | 0) < ($ysize | 0) & (($yc$8 | 0) > -1 & ($xc$8 | 0) < ($xsize | 0))) {
         $1074 = Math_imul($yc$8, $xsize) | 0;
         $1084 = ($xc$8 & 65534) + $1074 << 1;
         $1090 = +((HEAPU8[$image + ($1084 | 1) >> 0] | 0) + -128 | 0);
         $1096 = +((HEAPU8[$image + ($1084 + 3) >> 0] | 0) + -128 | 0);
         $1097 = +((HEAPU8[$image + ($1074 + $xc$8 << 1) >> 0] | 0) + -16 | 0) * 298.0820007324219;
         $1101 = ~~($1097 + $1090 * 516.4110107421875) >> 8;
         $1107 = ~~($1097 - $1090 * 100.29100036621094 - $1096 * 208.1199951171875) >> 8;
         $1111 = ~~($1097 + $1096 * 408.5830078125) >> 8;
         $1113 = ($1101 | 0) > 0 ? $1101 : 0;
         $1119 = ((Math_imul(($j$8289 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$9285 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $1120 = $108 + ($1119 << 2) | 0;
         HEAP32[$1120 >> 2] = (($1113 | 0) < 255 ? $1113 : 255) + (HEAP32[$1120 >> 2] | 0);
         $1124 = ($1107 | 0) > 0 ? $1107 : 0;
         $1128 = $108 + ($1119 + 1 << 2) | 0;
         HEAP32[$1128 >> 2] = (($1124 | 0) < 255 ? $1124 : 255) + (HEAP32[$1128 >> 2] | 0);
         $1132 = ($1111 | 0) > 0 ? $1111 : 0;
         $1135 = $108 + ($1119 + 2 << 2) | 0;
         HEAP32[$1135 >> 2] = (($1132 | 0) < 255 ? $1132 : 255) + (HEAP32[$1135 >> 2] | 0);
        }
        $i$9285 = $i$9285 + 1 | 0;
       } while (($i$9285 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$8289 = $j$8289 + 1 | 0;
     } while (($j$8289 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 9:
   {
    $138 = $103 + 100.0;
    $139 = +($ydiv2$3 | 0);
    $140 = +($sample_size$xdiv2$2 | 0);
    $141 = $para + 48 | 0;
    $142 = $para + 56 | 0;
    $143 = $para + 64 | 0;
    $144 = $para + 8 | 0;
    $145 = $para + 16 | 0;
    $146 = $para + 24 | 0;
    $147 = $para + 32 | 0;
    $148 = $para + 40 | 0;
    $149 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $151 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$9295 = 0;
     do {
      $1146 = $138 + $104 * (+($j$9295 | 0) + .5) / $139;
      if ($151) {
       $i$10291 = 0;
       do {
        $1151 = $138 + $104 * (+($i$10291 | 0) + .5) / $140;
        $1158 = +HEAPF64[$143 >> 3] + (+HEAPF64[$141 >> 3] * $1151 + $1146 * +HEAPF64[$142 >> 3]);
        if ($1158 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $1168 = (+HEAPF64[$145 >> 3] + ($1151 * +HEAPF64[$para >> 3] + $1146 * +HEAPF64[$144 >> 3])) / $1158;
        HEAPF32[$xc2 >> 2] = $1168;
        $1177 = (+HEAPF64[$148 >> 3] + ($1151 * +HEAPF64[$146 >> 3] + $1146 * +HEAPF64[$147 >> 3])) / $1158;
        HEAPF32[$yc2 >> 2] = $1177;
        _arParamIdeal2ObservLTf($paramLTf, $1168, $1177, $xc2, $yc2) | 0;
        $1178 = +HEAPF32[$xc2 >> 2];
        if ($149) {
         $xc$9 = ((~~($1178 + 1.0) | 0) / 2 | 0) << 1;
         $yc$9 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$9 = ~~($1178 + .5);
         $yc$9 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$9 | 0) > -1) if (($yc$9 | 0) < ($ysize | 0) & (($yc$9 | 0) > -1 & ($xc$9 | 0) < ($xsize | 0))) {
         $1199 = (Math_imul($yc$9, $xsize) | 0) + $xc$9 << 1;
         $1203 = HEAPU8[$image + ($1199 | 1) >> 0] | 0;
         $1211 = ((Math_imul(($j$9295 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$10291 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $1212 = $108 + ($1211 << 2) | 0;
         HEAP32[$1212 >> 2] = ($1203 << 3 & 248 | 4) + (HEAP32[$1212 >> 2] | 0);
         $1217 = HEAPU8[$image + $1199 >> 0] | 0;
         $1225 = $108 + ($1211 + 1 << 2) | 0;
         HEAP32[$1225 >> 2] = ($1217 << 5 & 224 | $1203 >>> 3 & 28 | 2) + (HEAP32[$1225 >> 2] | 0);
         $1231 = $108 + ($1211 + 2 << 2) | 0;
         HEAP32[$1231 >> 2] = ($1217 & 248 | 4) + (HEAP32[$1231 >> 2] | 0);
        }
        $i$10291 = $i$10291 + 1 | 0;
       } while (($i$10291 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$9295 = $j$9295 + 1 | 0;
     } while (($j$9295 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 10:
   {
    $124 = $103 + 100.0;
    $125 = +($ydiv2$3 | 0);
    $126 = +($sample_size$xdiv2$2 | 0);
    $127 = $para + 48 | 0;
    $128 = $para + 56 | 0;
    $129 = $para + 64 | 0;
    $130 = $para + 8 | 0;
    $131 = $para + 16 | 0;
    $132 = $para + 24 | 0;
    $133 = $para + 32 | 0;
    $134 = $para + 40 | 0;
    $135 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $137 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$10301 = 0;
     do {
      $1242 = $124 + $104 * (+($j$10301 | 0) + .5) / $125;
      if ($137) {
       $i$11297 = 0;
       do {
        $1247 = $124 + $104 * (+($i$11297 | 0) + .5) / $126;
        $1254 = +HEAPF64[$129 >> 3] + (+HEAPF64[$127 >> 3] * $1247 + $1242 * +HEAPF64[$128 >> 3]);
        if ($1254 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $1264 = (+HEAPF64[$131 >> 3] + ($1247 * +HEAPF64[$para >> 3] + $1242 * +HEAPF64[$130 >> 3])) / $1254;
        HEAPF32[$xc2 >> 2] = $1264;
        $1273 = (+HEAPF64[$134 >> 3] + ($1247 * +HEAPF64[$132 >> 3] + $1242 * +HEAPF64[$133 >> 3])) / $1254;
        HEAPF32[$yc2 >> 2] = $1273;
        _arParamIdeal2ObservLTf($paramLTf, $1264, $1273, $xc2, $yc2) | 0;
        $1274 = +HEAPF32[$xc2 >> 2];
        if ($135) {
         $xc$10 = ((~~($1274 + 1.0) | 0) / 2 | 0) << 1;
         $yc$10 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$10 = ~~($1274 + .5);
         $yc$10 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$10 | 0) > -1) if (($yc$10 | 0) < ($ysize | 0) & (($yc$10 | 0) > -1 & ($xc$10 | 0) < ($xsize | 0))) {
         $1295 = (Math_imul($yc$10, $xsize) | 0) + $xc$10 << 1;
         $1299 = HEAPU8[$image + ($1295 | 1) >> 0] | 0;
         $1307 = ((Math_imul(($j$10301 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$11297 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $1308 = $108 + ($1307 << 2) | 0;
         HEAP32[$1308 >> 2] = ($1299 << 2 & 248 | 4) + (HEAP32[$1308 >> 2] | 0);
         $1313 = HEAPU8[$image + $1295 >> 0] | 0;
         $1321 = $108 + ($1307 + 1 << 2) | 0;
         HEAP32[$1321 >> 2] = ($1313 << 5 & 224 | $1299 >>> 3 & 24 | 4) + (HEAP32[$1321 >> 2] | 0);
         $1327 = $108 + ($1307 + 2 << 2) | 0;
         HEAP32[$1327 >> 2] = ($1313 & 248 | 4) + (HEAP32[$1327 >> 2] | 0);
        }
        $i$11297 = $i$11297 + 1 | 0;
       } while (($i$11297 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$10301 = $j$10301 + 1 | 0;
     } while (($j$10301 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  case 11:
   {
    $110 = $103 + 100.0;
    $111 = +($ydiv2$3 | 0);
    $112 = +($sample_size$xdiv2$2 | 0);
    $113 = $para + 48 | 0;
    $114 = $para + 56 | 0;
    $115 = $para + 64 | 0;
    $116 = $para + 8 | 0;
    $117 = $para + 16 | 0;
    $118 = $para + 24 | 0;
    $119 = $para + 32 | 0;
    $120 = $para + 40 | 0;
    $121 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) > 0) {
     $123 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$11307 = 0;
     do {
      $1338 = $110 + $104 * (+($j$11307 | 0) + .5) / $111;
      if ($123) {
       $i$12303 = 0;
       do {
        $1343 = $110 + $104 * (+($i$12303 | 0) + .5) / $112;
        $1350 = +HEAPF64[$115 >> 3] + (+HEAPF64[$113 >> 3] * $1343 + $1338 * +HEAPF64[$114 >> 3]);
        if ($1350 == 0.0) {
         $ext_patt2$0 = $108;
         label = 278;
         break L13;
        }
        $1360 = (+HEAPF64[$117 >> 3] + ($1343 * +HEAPF64[$para >> 3] + $1338 * +HEAPF64[$116 >> 3])) / $1350;
        HEAPF32[$xc2 >> 2] = $1360;
        $1369 = (+HEAPF64[$120 >> 3] + ($1343 * +HEAPF64[$118 >> 3] + $1338 * +HEAPF64[$119 >> 3])) / $1350;
        HEAPF32[$yc2 >> 2] = $1369;
        _arParamIdeal2ObservLTf($paramLTf, $1360, $1369, $xc2, $yc2) | 0;
        $1370 = +HEAPF32[$xc2 >> 2];
        if ($121) {
         $xc$11 = ((~~($1370 + 1.0) | 0) / 2 | 0) << 1;
         $yc$11 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$11 = ~~($1370 + .5);
         $yc$11 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$11 | 0) > -1) if (($yc$11 | 0) < ($ysize | 0) & (($yc$11 | 0) > -1 & ($xc$11 | 0) < ($xsize | 0))) {
         $1391 = (Math_imul($yc$11, $xsize) | 0) + $xc$11 << 1;
         $1402 = ((Math_imul(($j$11307 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$12303 | 0) / ($99 | 0) | 0) | 0) * 3 | 0;
         $1403 = $108 + ($1402 << 2) | 0;
         HEAP32[$1403 >> 2] = (HEAP32[$1403 >> 2] | 0) + ((HEAPU8[$image + ($1391 | 1) >> 0] | 0) & 240 | 8);
         $1408 = HEAPU8[$image + $1391 >> 0] | 0;
         $1413 = $108 + ($1402 + 1 << 2) | 0;
         HEAP32[$1413 >> 2] = ($1408 << 4 & 240 | 8) + (HEAP32[$1413 >> 2] | 0);
         $1419 = $108 + ($1402 + 2 << 2) | 0;
         HEAP32[$1419 >> 2] = ($1408 & 240 | 8) + (HEAP32[$1419 >> 2] | 0);
        }
        $i$12303 = $i$12303 + 1 | 0;
       } while (($i$12303 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$11307 = $j$11307 + 1 | 0;
     } while (($j$11307 | 0) < ($ydiv2$3 | 0));
    }
    break;
   }
  default:
   {
    _arLog(3, 4615, $vararg_buffer1);
    $ext_patt2$0 = $108;
    label = 278;
    break L13;
   }
  } while (0);
  $278 = Math_imul($100, $99) | 0;
  if ($106) {
   $i$13236 = 0;
   do {
    HEAP8[$ext_patt + $i$13236 >> 0] = ((HEAP32[$108 + ($i$13236 << 2) >> 2] | 0) >>> 0) / ($278 >>> 0) | 0;
    $i$13236 = $i$13236 + 1 | 0;
   } while (($i$13236 | 0) < ($107 | 0));
  }
  _free($108);
  $$0 = 0;
 } else {
  $1433 = _calloc($106, 4) | 0;
  if (!$1433) {
   _arLog(3, 5471, $vararg_buffer3);
   _exit(1);
  }
  L233 : do if ($pixelFormat >>> 0 < 2) {
   $1436 = $103 + 100.0;
   $1437 = +($ydiv2$3 | 0);
   $1438 = +($sample_size$xdiv2$2 | 0);
   $1439 = $para + 48 | 0;
   $1440 = $para + 56 | 0;
   $1441 = $para + 64 | 0;
   $1442 = $para + 8 | 0;
   $1443 = $para + 16 | 0;
   $1444 = $para + 24 | 0;
   $1445 = $para + 32 | 0;
   $1446 = $para + 40 | 0;
   $1447 = ($imageProcMode | 0) == 1;
   if (($ydiv2$3 | 0) > 0) {
    $1449 = ($sample_size$xdiv2$2 | 0) > 0;
    $j$12316 = 0;
    do {
     $1456 = $1436 + $104 * (+($j$12316 | 0) + .5) / $1437;
     if ($1449) {
      $i$14312 = 0;
      do {
       $1461 = $1436 + $104 * (+($i$14312 | 0) + .5) / $1438;
       $1468 = +HEAPF64[$1441 >> 3] + (+HEAPF64[$1439 >> 3] * $1461 + $1456 * +HEAPF64[$1440 >> 3]);
       if ($1468 == 0.0) {
        $ext_patt2$0 = $1433;
        label = 278;
        break L13;
       }
       $1478 = (+HEAPF64[$1443 >> 3] + ($1461 * +HEAPF64[$para >> 3] + $1456 * +HEAPF64[$1442 >> 3])) / $1468;
       HEAPF32[$xc2 >> 2] = $1478;
       $1487 = (+HEAPF64[$1446 >> 3] + ($1461 * +HEAPF64[$1444 >> 3] + $1456 * +HEAPF64[$1445 >> 3])) / $1468;
       HEAPF32[$yc2 >> 2] = $1487;
       _arParamIdeal2ObservLTf($paramLTf, $1478, $1487, $xc2, $yc2) | 0;
       $1488 = +HEAPF32[$xc2 >> 2];
       if ($1447) {
        $xc$12 = ((~~($1488 + 1.0) | 0) / 2 | 0) << 1;
        $yc$12 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
       } else {
        $xc$12 = ~~($1488 + .5);
        $yc$12 = ~~(+HEAPF32[$yc2 >> 2] + .5);
       }
       if (($xc$12 | 0) > -1) if (($yc$12 | 0) < ($ysize | 0) & (($yc$12 | 0) > -1 & ($xc$12 | 0) < ($xsize | 0))) {
        $1509 = ((Math_imul($yc$12, $xsize) | 0) + $xc$12 | 0) * 3 | 0;
        $1528 = $1433 + ((Math_imul(($j$12316 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$14312 | 0) / ($99 | 0) | 0) << 2) | 0;
        HEAP32[$1528 >> 2] = (HEAP32[$1528 >> 2] | 0) + ((((HEAPU8[$image + ($1509 + 1) >> 0] | 0) + (HEAPU8[$image + $1509 >> 0] | 0) + (HEAPU8[$image + ($1509 + 2) >> 0] | 0) | 0) >>> 0) / 3 | 0);
       }
       $i$14312 = $i$14312 + 1 | 0;
      } while (($i$14312 | 0) < ($sample_size$xdiv2$2 | 0));
     }
     $j$12316 = $j$12316 + 1 | 0;
    } while (($j$12316 | 0) < ($ydiv2$3 | 0));
   }
  } else {
   if (($pixelFormat & -2 | 0) == 2) {
    $1537 = $103 + 100.0;
    $1538 = +($ydiv2$3 | 0);
    $1539 = +($sample_size$xdiv2$2 | 0);
    $1540 = $para + 48 | 0;
    $1541 = $para + 56 | 0;
    $1542 = $para + 64 | 0;
    $1543 = $para + 8 | 0;
    $1544 = $para + 16 | 0;
    $1545 = $para + 24 | 0;
    $1546 = $para + 32 | 0;
    $1547 = $para + 40 | 0;
    $1548 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) <= 0) break;
    $1550 = ($sample_size$xdiv2$2 | 0) > 0;
    $j$13322 = 0;
    while (1) {
     $1555 = $1537 + $104 * (+($j$13322 | 0) + .5) / $1538;
     if ($1550) {
      $i$15318 = 0;
      do {
       $1560 = $1537 + $104 * (+($i$15318 | 0) + .5) / $1539;
       $1567 = +HEAPF64[$1542 >> 3] + (+HEAPF64[$1540 >> 3] * $1560 + $1555 * +HEAPF64[$1541 >> 3]);
       if ($1567 == 0.0) {
        $ext_patt2$0 = $1433;
        label = 278;
        break L13;
       }
       $1577 = (+HEAPF64[$1544 >> 3] + ($1560 * +HEAPF64[$para >> 3] + $1555 * +HEAPF64[$1543 >> 3])) / $1567;
       HEAPF32[$xc2 >> 2] = $1577;
       $1586 = (+HEAPF64[$1547 >> 3] + ($1560 * +HEAPF64[$1545 >> 3] + $1555 * +HEAPF64[$1546 >> 3])) / $1567;
       HEAPF32[$yc2 >> 2] = $1586;
       _arParamIdeal2ObservLTf($paramLTf, $1577, $1586, $xc2, $yc2) | 0;
       $1587 = +HEAPF32[$xc2 >> 2];
       if ($1548) {
        $xc$13 = ((~~($1587 + 1.0) | 0) / 2 | 0) << 1;
        $yc$13 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
       } else {
        $xc$13 = ~~($1587 + .5);
        $yc$13 = ~~(+HEAPF32[$yc2 >> 2] + .5);
       }
       if (($xc$13 | 0) > -1) if (($yc$13 | 0) < ($ysize | 0) & (($yc$13 | 0) > -1 & ($xc$13 | 0) < ($xsize | 0))) {
        $1608 = (Math_imul($yc$13, $xsize) | 0) + $xc$13 << 2;
        $1627 = $1433 + ((Math_imul(($j$13322 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$15318 | 0) / ($99 | 0) | 0) << 2) | 0;
        HEAP32[$1627 >> 2] = (HEAP32[$1627 >> 2] | 0) + ((((HEAPU8[$image + ($1608 | 1) >> 0] | 0) + (HEAPU8[$image + $1608 >> 0] | 0) + (HEAPU8[$image + ($1608 | 2) >> 0] | 0) | 0) >>> 0) / 3 | 0);
       }
       $i$15318 = $i$15318 + 1 | 0;
      } while (($i$15318 | 0) < ($sample_size$xdiv2$2 | 0));
     }
     $j$13322 = $j$13322 + 1 | 0;
     if (($j$13322 | 0) >= ($ydiv2$3 | 0)) break L233;
    }
   }
   if (($pixelFormat & -3 | 0) == 4) {
    $1636 = $103 + 100.0;
    $1637 = +($ydiv2$3 | 0);
    $1638 = +($sample_size$xdiv2$2 | 0);
    $1639 = $para + 48 | 0;
    $1640 = $para + 56 | 0;
    $1641 = $para + 64 | 0;
    $1642 = $para + 8 | 0;
    $1643 = $para + 16 | 0;
    $1644 = $para + 24 | 0;
    $1645 = $para + 32 | 0;
    $1646 = $para + 40 | 0;
    $1647 = ($imageProcMode | 0) == 1;
    if (($ydiv2$3 | 0) <= 0) break;
    $1649 = ($sample_size$xdiv2$2 | 0) > 0;
    $j$14328 = 0;
    while (1) {
     $1654 = $1636 + $104 * (+($j$14328 | 0) + .5) / $1637;
     if ($1649) {
      $i$16324 = 0;
      do {
       $1659 = $1636 + $104 * (+($i$16324 | 0) + .5) / $1638;
       $1666 = +HEAPF64[$1641 >> 3] + (+HEAPF64[$1639 >> 3] * $1659 + $1654 * +HEAPF64[$1640 >> 3]);
       if ($1666 == 0.0) {
        $ext_patt2$0 = $1433;
        label = 278;
        break L13;
       }
       $1676 = (+HEAPF64[$1643 >> 3] + ($1659 * +HEAPF64[$para >> 3] + $1654 * +HEAPF64[$1642 >> 3])) / $1666;
       HEAPF32[$xc2 >> 2] = $1676;
       $1685 = (+HEAPF64[$1646 >> 3] + ($1659 * +HEAPF64[$1644 >> 3] + $1654 * +HEAPF64[$1645 >> 3])) / $1666;
       HEAPF32[$yc2 >> 2] = $1685;
       _arParamIdeal2ObservLTf($paramLTf, $1676, $1685, $xc2, $yc2) | 0;
       $1686 = +HEAPF32[$xc2 >> 2];
       if ($1647) {
        $xc$14 = ((~~($1686 + 1.0) | 0) / 2 | 0) << 1;
        $yc$14 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
       } else {
        $xc$14 = ~~($1686 + .5);
        $yc$14 = ~~(+HEAPF32[$yc2 >> 2] + .5);
       }
       if (($xc$14 | 0) > -1) if (($yc$14 | 0) < ($ysize | 0) & (($yc$14 | 0) > -1 & ($xc$14 | 0) < ($xsize | 0))) {
        $1707 = (Math_imul($yc$14, $xsize) | 0) + $xc$14 << 2;
        $1727 = $1433 + ((Math_imul(($j$14328 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$16324 | 0) / ($99 | 0) | 0) << 2) | 0;
        HEAP32[$1727 >> 2] = (HEAP32[$1727 >> 2] | 0) + ((((HEAPU8[$image + ($1707 | 2) >> 0] | 0) + (HEAPU8[$image + ($1707 | 1) >> 0] | 0) + (HEAPU8[$image + ($1707 | 3) >> 0] | 0) | 0) >>> 0) / 3 | 0);
       }
       $i$16324 = $i$16324 + 1 | 0;
      } while (($i$16324 | 0) < ($sample_size$xdiv2$2 | 0));
     }
     $j$14328 = $j$14328 + 1 | 0;
     if (($j$14328 | 0) >= ($ydiv2$3 | 0)) break L233;
    }
   }
   switch ($pixelFormat | 0) {
   case 5:
   case 12:
   case 13:
   case 14:
    {
     $1804 = $103 + 100.0;
     $1805 = +($ydiv2$3 | 0);
     $1806 = +($sample_size$xdiv2$2 | 0);
     $1807 = $para + 48 | 0;
     $1808 = $para + 56 | 0;
     $1809 = $para + 64 | 0;
     $1810 = $para + 8 | 0;
     $1811 = $para + 16 | 0;
     $1812 = $para + 24 | 0;
     $1813 = $para + 32 | 0;
     $1814 = $para + 40 | 0;
     $1815 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1817 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$15334 = 0;
     do {
      $1822 = $1804 + $104 * (+($j$15334 | 0) + .5) / $1805;
      if ($1817) {
       $i$17330 = 0;
       do {
        $1827 = $1804 + $104 * (+($i$17330 | 0) + .5) / $1806;
        $1834 = +HEAPF64[$1809 >> 3] + (+HEAPF64[$1807 >> 3] * $1827 + $1822 * +HEAPF64[$1808 >> 3]);
        if ($1834 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $1844 = (+HEAPF64[$1811 >> 3] + ($1827 * +HEAPF64[$para >> 3] + $1822 * +HEAPF64[$1810 >> 3])) / $1834;
        HEAPF32[$xc2 >> 2] = $1844;
        $1853 = (+HEAPF64[$1814 >> 3] + ($1827 * +HEAPF64[$1812 >> 3] + $1822 * +HEAPF64[$1813 >> 3])) / $1834;
        HEAPF32[$yc2 >> 2] = $1853;
        _arParamIdeal2ObservLTf($paramLTf, $1844, $1853, $xc2, $yc2) | 0;
        $1854 = +HEAPF32[$xc2 >> 2];
        if ($1815) {
         $xc$15 = ((~~($1854 + 1.0) | 0) / 2 | 0) << 1;
         $yc$15 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$15 = ~~($1854 + .5);
         $yc$15 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$15 | 0) > -1) if (($yc$15 | 0) < ($ysize | 0) & (($yc$15 | 0) > -1 & ($xc$15 | 0) < ($xsize | 0))) {
         $1875 = $image + ((Math_imul($yc$15, $xsize) | 0) + $xc$15) | 0;
         $1882 = $1433 + ((Math_imul(($j$15334 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$17330 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$1882 >> 2] = (HEAP32[$1882 >> 2] | 0) + (HEAPU8[$1875 >> 0] | 0);
        }
        $i$17330 = $i$17330 + 1 | 0;
       } while (($i$17330 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$15334 = $j$15334 + 1 | 0;
     } while (($j$15334 | 0) < ($ydiv2$3 | 0));
     break;
    }
   case 7:
    {
     $1790 = $103 + 100.0;
     $1791 = +($ydiv2$3 | 0);
     $1792 = +($sample_size$xdiv2$2 | 0);
     $1793 = $para + 48 | 0;
     $1794 = $para + 56 | 0;
     $1795 = $para + 64 | 0;
     $1796 = $para + 8 | 0;
     $1797 = $para + 16 | 0;
     $1798 = $para + 24 | 0;
     $1799 = $para + 32 | 0;
     $1800 = $para + 40 | 0;
     $1801 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1803 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$16340 = 0;
     do {
      $1893 = $1790 + $104 * (+($j$16340 | 0) + .5) / $1791;
      if ($1803) {
       $i$18336 = 0;
       do {
        $1898 = $1790 + $104 * (+($i$18336 | 0) + .5) / $1792;
        $1905 = +HEAPF64[$1795 >> 3] + (+HEAPF64[$1793 >> 3] * $1898 + $1893 * +HEAPF64[$1794 >> 3]);
        if ($1905 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $1915 = (+HEAPF64[$1797 >> 3] + ($1898 * +HEAPF64[$para >> 3] + $1893 * +HEAPF64[$1796 >> 3])) / $1905;
        HEAPF32[$xc2 >> 2] = $1915;
        $1924 = (+HEAPF64[$1800 >> 3] + ($1898 * +HEAPF64[$1798 >> 3] + $1893 * +HEAPF64[$1799 >> 3])) / $1905;
        HEAPF32[$yc2 >> 2] = $1924;
        _arParamIdeal2ObservLTf($paramLTf, $1915, $1924, $xc2, $yc2) | 0;
        $1925 = +HEAPF32[$xc2 >> 2];
        if ($1801) {
         $xc$16 = ((~~($1925 + 1.0) | 0) / 2 | 0) << 1;
         $yc$16 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$16 = ~~($1925 + .5);
         $yc$16 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$16 | 0) > -1) if (($yc$16 | 0) < ($ysize | 0) & (($yc$16 | 0) > -1 & ($xc$16 | 0) < ($xsize | 0))) {
         $1948 = $image + ((Math_imul($yc$16, $xsize) | 0) + $xc$16 << 1 | 1) | 0;
         $1955 = $1433 + ((Math_imul(($j$16340 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$18336 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$1955 >> 2] = (HEAP32[$1955 >> 2] | 0) + (HEAPU8[$1948 >> 0] | 0);
        }
        $i$18336 = $i$18336 + 1 | 0;
       } while (($i$18336 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$16340 = $j$16340 + 1 | 0;
     } while (($j$16340 | 0) < ($ydiv2$3 | 0));
     break;
    }
   case 8:
    {
     $1776 = $103 + 100.0;
     $1777 = +($ydiv2$3 | 0);
     $1778 = +($sample_size$xdiv2$2 | 0);
     $1779 = $para + 48 | 0;
     $1780 = $para + 56 | 0;
     $1781 = $para + 64 | 0;
     $1782 = $para + 8 | 0;
     $1783 = $para + 16 | 0;
     $1784 = $para + 24 | 0;
     $1785 = $para + 32 | 0;
     $1786 = $para + 40 | 0;
     $1787 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1789 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$17346 = 0;
     do {
      $1966 = $1776 + $104 * (+($j$17346 | 0) + .5) / $1777;
      if ($1789) {
       $i$19342 = 0;
       do {
        $1971 = $1776 + $104 * (+($i$19342 | 0) + .5) / $1778;
        $1978 = +HEAPF64[$1781 >> 3] + (+HEAPF64[$1779 >> 3] * $1971 + $1966 * +HEAPF64[$1780 >> 3]);
        if ($1978 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $1988 = (+HEAPF64[$1783 >> 3] + ($1971 * +HEAPF64[$para >> 3] + $1966 * +HEAPF64[$1782 >> 3])) / $1978;
        HEAPF32[$xc2 >> 2] = $1988;
        $1997 = (+HEAPF64[$1786 >> 3] + ($1971 * +HEAPF64[$1784 >> 3] + $1966 * +HEAPF64[$1785 >> 3])) / $1978;
        HEAPF32[$yc2 >> 2] = $1997;
        _arParamIdeal2ObservLTf($paramLTf, $1988, $1997, $xc2, $yc2) | 0;
        $1998 = +HEAPF32[$xc2 >> 2];
        if ($1787) {
         $xc$17 = ((~~($1998 + 1.0) | 0) / 2 | 0) << 1;
         $yc$17 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$17 = ~~($1998 + .5);
         $yc$17 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$17 | 0) > -1) if (($yc$17 | 0) < ($ysize | 0) & (($yc$17 | 0) > -1 & ($xc$17 | 0) < ($xsize | 0))) {
         $2020 = $image + ((Math_imul($yc$17, $xsize) | 0) + $xc$17 << 1) | 0;
         $2027 = $1433 + ((Math_imul(($j$17346 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$19342 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$2027 >> 2] = (HEAP32[$2027 >> 2] | 0) + (HEAPU8[$2020 >> 0] | 0);
        }
        $i$19342 = $i$19342 + 1 | 0;
       } while (($i$19342 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$17346 = $j$17346 + 1 | 0;
     } while (($j$17346 | 0) < ($ydiv2$3 | 0));
     break;
    }
   case 9:
    {
     $1762 = $103 + 100.0;
     $1763 = +($ydiv2$3 | 0);
     $1764 = +($sample_size$xdiv2$2 | 0);
     $1765 = $para + 48 | 0;
     $1766 = $para + 56 | 0;
     $1767 = $para + 64 | 0;
     $1768 = $para + 8 | 0;
     $1769 = $para + 16 | 0;
     $1770 = $para + 24 | 0;
     $1771 = $para + 32 | 0;
     $1772 = $para + 40 | 0;
     $1773 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1775 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$18352 = 0;
     do {
      $2038 = $1762 + $104 * (+($j$18352 | 0) + .5) / $1763;
      if ($1775) {
       $i$20348 = 0;
       do {
        $2043 = $1762 + $104 * (+($i$20348 | 0) + .5) / $1764;
        $2050 = +HEAPF64[$1767 >> 3] + (+HEAPF64[$1765 >> 3] * $2043 + $2038 * +HEAPF64[$1766 >> 3]);
        if ($2050 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $2060 = (+HEAPF64[$1769 >> 3] + ($2043 * +HEAPF64[$para >> 3] + $2038 * +HEAPF64[$1768 >> 3])) / $2050;
        HEAPF32[$xc2 >> 2] = $2060;
        $2069 = (+HEAPF64[$1772 >> 3] + ($2043 * +HEAPF64[$1770 >> 3] + $2038 * +HEAPF64[$1771 >> 3])) / $2050;
        HEAPF32[$yc2 >> 2] = $2069;
        _arParamIdeal2ObservLTf($paramLTf, $2060, $2069, $xc2, $yc2) | 0;
        $2070 = +HEAPF32[$xc2 >> 2];
        if ($1773) {
         $xc$18 = ((~~($2070 + 1.0) | 0) / 2 | 0) << 1;
         $yc$18 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$18 = ~~($2070 + .5);
         $yc$18 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$18 | 0) > -1) if (($yc$18 | 0) < ($ysize | 0) & (($yc$18 | 0) > -1 & ($xc$18 | 0) < ($xsize | 0))) {
         $2091 = (Math_imul($yc$18, $xsize) | 0) + $xc$18 << 1;
         $2094 = HEAPU8[$image + $2091 >> 0] | 0;
         $2102 = HEAPU8[$image + ($2091 | 1) >> 0] | 0;
         $2117 = $1433 + ((Math_imul(($j$18352 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$20348 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$2117 >> 2] = (HEAP32[$2117 >> 2] | 0) + (((($2102 << 3 & 248 | 4) + ($2094 & 248 | 4) + ($2094 << 5 & 224 | $2102 >>> 3 & 28 | 2) | 0) >>> 0) / 3 | 0);
        }
        $i$20348 = $i$20348 + 1 | 0;
       } while (($i$20348 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$18352 = $j$18352 + 1 | 0;
     } while (($j$18352 | 0) < ($ydiv2$3 | 0));
     break;
    }
   case 10:
    {
     $1748 = $103 + 100.0;
     $1749 = +($ydiv2$3 | 0);
     $1750 = +($sample_size$xdiv2$2 | 0);
     $1751 = $para + 48 | 0;
     $1752 = $para + 56 | 0;
     $1753 = $para + 64 | 0;
     $1754 = $para + 8 | 0;
     $1755 = $para + 16 | 0;
     $1756 = $para + 24 | 0;
     $1757 = $para + 32 | 0;
     $1758 = $para + 40 | 0;
     $1759 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1761 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$19358 = 0;
     do {
      $2128 = $1748 + $104 * (+($j$19358 | 0) + .5) / $1749;
      if ($1761) {
       $i$21354 = 0;
       do {
        $2133 = $1748 + $104 * (+($i$21354 | 0) + .5) / $1750;
        $2140 = +HEAPF64[$1753 >> 3] + (+HEAPF64[$1751 >> 3] * $2133 + $2128 * +HEAPF64[$1752 >> 3]);
        if ($2140 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $2150 = (+HEAPF64[$1755 >> 3] + ($2133 * +HEAPF64[$para >> 3] + $2128 * +HEAPF64[$1754 >> 3])) / $2140;
        HEAPF32[$xc2 >> 2] = $2150;
        $2159 = (+HEAPF64[$1758 >> 3] + ($2133 * +HEAPF64[$1756 >> 3] + $2128 * +HEAPF64[$1757 >> 3])) / $2140;
        HEAPF32[$yc2 >> 2] = $2159;
        _arParamIdeal2ObservLTf($paramLTf, $2150, $2159, $xc2, $yc2) | 0;
        $2160 = +HEAPF32[$xc2 >> 2];
        if ($1759) {
         $xc$19 = ((~~($2160 + 1.0) | 0) / 2 | 0) << 1;
         $yc$19 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$19 = ~~($2160 + .5);
         $yc$19 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$19 | 0) > -1) if (($yc$19 | 0) < ($ysize | 0) & (($yc$19 | 0) > -1 & ($xc$19 | 0) < ($xsize | 0))) {
         $2181 = (Math_imul($yc$19, $xsize) | 0) + $xc$19 << 1;
         $2184 = HEAPU8[$image + $2181 >> 0] | 0;
         $2192 = HEAPU8[$image + ($2181 | 1) >> 0] | 0;
         $2207 = $1433 + ((Math_imul(($j$19358 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$21354 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$2207 >> 2] = (HEAP32[$2207 >> 2] | 0) + (((($2192 << 2 & 248 | 4) + ($2184 & 248 | 4) + ($2184 << 5 & 224 | $2192 >>> 3 & 24 | 4) | 0) >>> 0) / 3 | 0);
        }
        $i$21354 = $i$21354 + 1 | 0;
       } while (($i$21354 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$19358 = $j$19358 + 1 | 0;
     } while (($j$19358 | 0) < ($ydiv2$3 | 0));
     break;
    }
   case 11:
    {
     $1734 = $103 + 100.0;
     $1735 = +($ydiv2$3 | 0);
     $1736 = +($sample_size$xdiv2$2 | 0);
     $1737 = $para + 48 | 0;
     $1738 = $para + 56 | 0;
     $1739 = $para + 64 | 0;
     $1740 = $para + 8 | 0;
     $1741 = $para + 16 | 0;
     $1742 = $para + 24 | 0;
     $1743 = $para + 32 | 0;
     $1744 = $para + 40 | 0;
     $1745 = ($imageProcMode | 0) == 1;
     if (($ydiv2$3 | 0) <= 0) break L233;
     $1747 = ($sample_size$xdiv2$2 | 0) > 0;
     $j$20364 = 0;
     do {
      $2218 = $1734 + $104 * (+($j$20364 | 0) + .5) / $1735;
      if ($1747) {
       $i$22360 = 0;
       do {
        $2223 = $1734 + $104 * (+($i$22360 | 0) + .5) / $1736;
        $2230 = +HEAPF64[$1739 >> 3] + (+HEAPF64[$1737 >> 3] * $2223 + $2218 * +HEAPF64[$1738 >> 3]);
        if ($2230 == 0.0) {
         $ext_patt2$0 = $1433;
         label = 278;
         break L13;
        }
        $2240 = (+HEAPF64[$1741 >> 3] + ($2223 * +HEAPF64[$para >> 3] + $2218 * +HEAPF64[$1740 >> 3])) / $2230;
        HEAPF32[$xc2 >> 2] = $2240;
        $2249 = (+HEAPF64[$1744 >> 3] + ($2223 * +HEAPF64[$1742 >> 3] + $2218 * +HEAPF64[$1743 >> 3])) / $2230;
        HEAPF32[$yc2 >> 2] = $2249;
        _arParamIdeal2ObservLTf($paramLTf, $2240, $2249, $xc2, $yc2) | 0;
        $2250 = +HEAPF32[$xc2 >> 2];
        if ($1745) {
         $xc$20 = ((~~($2250 + 1.0) | 0) / 2 | 0) << 1;
         $yc$20 = ((~~(+HEAPF32[$yc2 >> 2] + 1.0) | 0) / 2 | 0) << 1;
        } else {
         $xc$20 = ~~($2250 + .5);
         $yc$20 = ~~(+HEAPF32[$yc2 >> 2] + .5);
        }
        if (($xc$20 | 0) > -1) if (($yc$20 | 0) < ($ysize | 0) & (($yc$20 | 0) > -1 & ($xc$20 | 0) < ($xsize | 0))) {
         $2271 = (Math_imul($yc$20, $xsize) | 0) + $xc$20 << 1;
         $2274 = HEAPU8[$image + $2271 >> 0] | 0;
         $2293 = $1433 + ((Math_imul(($j$20364 | 0) / ($100 | 0) | 0, $patt_size) | 0) + (($i$22360 | 0) / ($99 | 0) | 0) << 2) | 0;
         HEAP32[$2293 >> 2] = (HEAP32[$2293 >> 2] | 0) + (((($2274 << 4 & 240 | 8) + ($2274 & 240 | 8) + ((HEAPU8[$image + ($2271 | 1) >> 0] | 0) & 240 | 8) | 0) >>> 0) / 3 | 0);
        }
        $i$22360 = $i$22360 + 1 | 0;
       } while (($i$22360 | 0) < ($sample_size$xdiv2$2 | 0));
      }
      $j$20364 = $j$20364 + 1 | 0;
     } while (($j$20364 | 0) < ($ydiv2$3 | 0));
     break;
    }
   default:
    {
     _arLog(3, 4615, $vararg_buffer5);
     $ext_patt2$0 = $1433;
     label = 278;
     break L13;
    }
   }
  } while (0);
  $1450 = Math_imul($100, $99) | 0;
  if ($106) {
   $i$23309 = 0;
   do {
    HEAP8[$ext_patt + $i$23309 >> 0] = ((HEAP32[$1433 + ($i$23309 << 2) >> 2] | 0) >>> 0) / ($1450 >>> 0) | 0;
    $i$23309 = $i$23309 + 1 | 0;
   } while (($i$23309 | 0) < ($106 | 0));
  }
  _free($1433);
  $$0 = 0;
 } while (0);
 if ((label | 0) == 278) {
  _free($ext_patt2$0);
  $$0 = -1;
 }
 STACKTOP = sp;
 return $$0 | 0;
}

function __ZN10__cxxabiv112_GLOBAL__N_118parse_builtin_typeINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0 = 0, $$0$i$i$i = 0, $$0$i$i$i103 = 0, $$0$i$i$i108 = 0, $$0$i$i$i113 = 0, $$0$i$i$i118 = 0, $$0$i$i$i123 = 0, $$0$i$i$i128 = 0, $$0$i$i$i133 = 0, $$0$i$i$i138 = 0, $$0$i$i$i14 = 0, $$0$i$i$i143 = 0, $$0$i$i$i19 = 0, $$0$i$i$i24 = 0, $$0$i$i$i29 = 0, $$0$i$i$i34 = 0, $$0$i$i$i39 = 0, $$0$i$i$i4 = 0, $$0$i$i$i44 = 0, $$0$i$i$i49 = 0, $$0$i$i$i54 = 0, $$0$i$i$i59 = 0, $$0$i$i$i66 = 0, $$0$i$i$i71 = 0, $$0$i$i$i76 = 0, $$0$i$i$i81 = 0, $$0$i$i$i88 = 0, $$0$i$i$i9 = 0, $$0$i$i$i93 = 0, $$0$i$i$i98 = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $106 = 0, $108 = 0, $11 = 0, $111 = 0, $112 = 0, $115 = 0, $116 = 0, $118 = 0, $12 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $13 = 0, $132 = 0, $134 = 0, $137 = 0, $138 = 0, $14 = 0, $141 = 0, $142 = 0, $144 = 0, $15 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $158 = 0, $16 = 0, $160 = 0, $163 = 0, $164 = 0, $167 = 0, $168 = 0, $17 = 0, $170 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $184 = 0, $186 = 0, $189 = 0, $19 = 0, $190 = 0, $193 = 0, $194 = 0, $196 = 0, $2 = 0, $20 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $21 = 0, $210 = 0, $212 = 0, $215 = 0, $216 = 0, $219 = 0, $22 = 0, $220 = 0, $222 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $236 = 0, $238 = 0, $24 = 0, $241 = 0, $242 = 0, $245 = 0, $246 = 0, $248 = 0, $25 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $26 = 0, $262 = 0, $264 = 0, $267 = 0, $268 = 0, $27 = 0, $271 = 0, $272 = 0, $274 = 0, $28 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $288 = 0, $290 = 0, $293 = 0, $294 = 0, $297 = 0, $298 = 0, $3 = 0, $300 = 0, $307 = 0, $308 = 0, $309 = 0, $310 = 0, $314 = 0, $316 = 0, $319 = 0, $32 = 0, $320 = 0, $323 = 0, $324 = 0, $326 = 0, $33 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $340 = 0, $342 = 0, $345 = 0, $346 = 0, $349 = 0, $35 = 0, $350 = 0, $352 = 0, $359 = 0, $360 = 0, $361 = 0, $362 = 0, $366 = 0, $368 = 0, $371 = 0, $372 = 0, $375 = 0, $379 = 0, $382 = 0, $383 = 0, $385 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $399 = 0, $4 = 0, $401 = 0, $404 = 0, $405 = 0, $408 = 0, $409 = 0, $411 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $425 = 0, $427 = 0, $43 = 0, $430 = 0, $431 = 0, $434 = 0, $435 = 0, $437 = 0, $44 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $45 = 0, $451 = 0, $453 = 0, $456 = 0, $457 = 0, $460 = 0, $461 = 0, $463 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $477 = 0, $479 = 0, $482 = 0, $483 = 0, $486 = 0, $488 = 0, $49 = 0, $491 = 0, $492 = 0, $494 = 0, $5 = 0, $501 = 0, $502 = 0, $503 = 0, $504 = 0, $508 = 0, $51 = 0, $510 = 0, $513 = 0, $514 = 0, $517 = 0, $518 = 0, $520 = 0, $527 = 0, $528 = 0, $529 = 0, $530 = 0, $534 = 0, $536 = 0, $539 = 0, $54 = 0, $540 = 0, $543 = 0, $544 = 0, $546 = 0, $55 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $560 = 0, $562 = 0, $565 = 0, $566 = 0, $569 = 0, $570 = 0, $572 = 0, $579 = 0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $586 = 0, $588 = 0, $591 = 0, $592 = 0, $595 = 0, $596 = 0, $598 = 0, $6 = 0, $60 = 0, $602 = 0, $603 = 0, $605 = 0, $612 = 0, $613 = 0, $614 = 0, $615 = 0, $619 = 0, $621 = 0, $624 = 0, $625 = 0, $628 = 0, $629 = 0, $63 = 0, $631 = 0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0, $645 = 0, $647 = 0, $650 = 0, $651 = 0, $654 = 0, $655 = 0, $657 = 0, $66 = 0, $664 = 0, $665 = 0, $666 = 0, $667 = 0, $671 = 0, $673 = 0, $676 = 0, $677 = 0, $680 = 0, $681 = 0, $683 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $697 = 0, $699 = 0, $7 = 0, $702 = 0, $703 = 0, $706 = 0, $707 = 0, $709 = 0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $723 = 0, $725 = 0, $728 = 0, $729 = 0, $73 = 0, $732 = 0, $733 = 0, $735 = 0, $74 = 0, $742 = 0, $743 = 0, $744 = 0, $745 = 0, $749 = 0, $75 = 0, $751 = 0, $754 = 0, $755 = 0, $758 = 0, $759 = 0, $76 = 0, $761 = 0, $768 = 0, $769 = 0, $770 = 0, $771 = 0, $775 = 0, $777 = 0, $780 = 0, $781 = 0, $784 = 0, $785 = 0, $787 = 0, $794 = 0, $795 = 0, $796 = 0, $797 = 0, $8 = 0, $80 = 0, $801 = 0, $803 = 0, $806 = 0, $807 = 0, $82 = 0, $85 = 0, $86 = 0, $89 = 0, $9 = 0, $90 = 0, $92 = 0, $99 = 0, $__v$i$i142 = 0, dest = 0, sp = 0, src = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 720 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $__v$i$i142 = sp + 696 | 0;
 $0 = sp + 672 | 0;
 $1 = sp + 648 | 0;
 $2 = sp + 624 | 0;
 $3 = sp + 600 | 0;
 $4 = sp + 576 | 0;
 $5 = sp + 552 | 0;
 $6 = sp + 528 | 0;
 $7 = sp + 504 | 0;
 $8 = sp + 480 | 0;
 $9 = sp + 456 | 0;
 $10 = sp + 432 | 0;
 $11 = sp + 408 | 0;
 $12 = sp + 384 | 0;
 $13 = sp + 360 | 0;
 $14 = sp + 336 | 0;
 $15 = sp + 312 | 0;
 $16 = sp + 288 | 0;
 $17 = sp + 264 | 0;
 $18 = sp + 240 | 0;
 $19 = sp + 216 | 0;
 $20 = sp + 192 | 0;
 $21 = sp + 168 | 0;
 $22 = sp + 144 | 0;
 $23 = sp + 120 | 0;
 $24 = sp + 96 | 0;
 $25 = sp + 72 | 0;
 $26 = sp + 48 | 0;
 $27 = sp + 24 | 0;
 $28 = sp;
 L1 : do if (($first | 0) == ($last | 0)) $$0 = $first; else do switch (HEAP8[$first >> 0] | 0) {
 case 118:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($0, 14202);
   $32 = $db + 4 | 0;
   $33 = HEAP32[$32 >> 2] | 0;
   $35 = HEAP32[$db + 8 >> 2] | 0;
   if ($33 >>> 0 < $35 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($33, $0);
    HEAP32[$32 >> 2] = (HEAP32[$32 >> 2] | 0) + 24;
   } else {
    $42 = HEAP32[$db >> 2] | 0;
    $43 = $33 - $42 | 0;
    $44 = ($43 | 0) / 24 | 0;
    $45 = $44 + 1 | 0;
    if (($43 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $49 = ($35 - $42 | 0) / 24 | 0;
    if ($49 >>> 0 < 1073741823) {
     $51 = $49 << 1;
     $$0$i$i$i = $51 >>> 0 < $45 >>> 0 ? $45 : $51;
    } else $$0$i$i$i = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i, $44, $db + 12 | 0);
    $54 = $__v$i$i142 + 8 | 0;
    $55 = HEAP32[$54 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($55, $0);
    HEAP32[$54 >> 2] = $55 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($0);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 119:
  {
   HEAP8[$1 >> 0] = 14;
   $58 = $1 + 1 | 0;
   HEAP8[$58 >> 0] = HEAP8[13764] | 0;
   HEAP8[$58 + 1 >> 0] = HEAP8[13765] | 0;
   HEAP8[$58 + 2 >> 0] = HEAP8[13766] | 0;
   HEAP8[$58 + 3 >> 0] = HEAP8[13767] | 0;
   HEAP8[$58 + 4 >> 0] = HEAP8[13768] | 0;
   HEAP8[$58 + 5 >> 0] = HEAP8[13769] | 0;
   HEAP8[$58 + 6 >> 0] = HEAP8[13770] | 0;
   HEAP8[$1 + 8 >> 0] = 0;
   $60 = $1 + 12 | 0;
   HEAP32[$60 >> 2] = 0;
   HEAP32[$60 + 4 >> 2] = 0;
   HEAP32[$60 + 8 >> 2] = 0;
   $63 = $db + 4 | 0;
   $64 = HEAP32[$63 >> 2] | 0;
   $66 = HEAP32[$db + 8 >> 2] | 0;
   if ($64 >>> 0 < $66 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($64, $1);
    HEAP32[$63 >> 2] = (HEAP32[$63 >> 2] | 0) + 24;
   } else {
    $73 = HEAP32[$db >> 2] | 0;
    $74 = $64 - $73 | 0;
    $75 = ($74 | 0) / 24 | 0;
    $76 = $75 + 1 | 0;
    if (($74 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $80 = ($66 - $73 | 0) / 24 | 0;
    if ($80 >>> 0 < 1073741823) {
     $82 = $80 << 1;
     $$0$i$i$i4 = $82 >>> 0 < $76 >>> 0 ? $76 : $82;
    } else $$0$i$i$i4 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i4, $75, $db + 12 | 0);
    $85 = $__v$i$i142 + 8 | 0;
    $86 = HEAP32[$85 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($86, $1);
    HEAP32[$85 >> 2] = $86 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 98:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($2, 14207);
   $89 = $db + 4 | 0;
   $90 = HEAP32[$89 >> 2] | 0;
   $92 = HEAP32[$db + 8 >> 2] | 0;
   if ($90 >>> 0 < $92 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($90, $2);
    HEAP32[$89 >> 2] = (HEAP32[$89 >> 2] | 0) + 24;
   } else {
    $99 = HEAP32[$db >> 2] | 0;
    $100 = $90 - $99 | 0;
    $101 = ($100 | 0) / 24 | 0;
    $102 = $101 + 1 | 0;
    if (($100 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $106 = ($92 - $99 | 0) / 24 | 0;
    if ($106 >>> 0 < 1073741823) {
     $108 = $106 << 1;
     $$0$i$i$i9 = $108 >>> 0 < $102 >>> 0 ? $102 : $108;
    } else $$0$i$i$i9 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i9, $101, $db + 12 | 0);
    $111 = $__v$i$i142 + 8 | 0;
    $112 = HEAP32[$111 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($112, $2);
    HEAP32[$111 >> 2] = $112 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($2);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 99:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($3, 13783);
   $115 = $db + 4 | 0;
   $116 = HEAP32[$115 >> 2] | 0;
   $118 = HEAP32[$db + 8 >> 2] | 0;
   if ($116 >>> 0 < $118 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($116, $3);
    HEAP32[$115 >> 2] = (HEAP32[$115 >> 2] | 0) + 24;
   } else {
    $125 = HEAP32[$db >> 2] | 0;
    $126 = $116 - $125 | 0;
    $127 = ($126 | 0) / 24 | 0;
    $128 = $127 + 1 | 0;
    if (($126 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $132 = ($118 - $125 | 0) / 24 | 0;
    if ($132 >>> 0 < 1073741823) {
     $134 = $132 << 1;
     $$0$i$i$i14 = $134 >>> 0 < $128 >>> 0 ? $128 : $134;
    } else $$0$i$i$i14 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i14, $127, $db + 12 | 0);
    $137 = $__v$i$i142 + 8 | 0;
    $138 = HEAP32[$137 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($138, $3);
    HEAP32[$137 >> 2] = $138 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($3);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 97:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj12EEERAT__Kc($4, 13788);
   $141 = $db + 4 | 0;
   $142 = HEAP32[$141 >> 2] | 0;
   $144 = HEAP32[$db + 8 >> 2] | 0;
   if ($142 >>> 0 < $144 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($142, $4);
    HEAP32[$141 >> 2] = (HEAP32[$141 >> 2] | 0) + 24;
   } else {
    $151 = HEAP32[$db >> 2] | 0;
    $152 = $142 - $151 | 0;
    $153 = ($152 | 0) / 24 | 0;
    $154 = $153 + 1 | 0;
    if (($152 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $158 = ($144 - $151 | 0) / 24 | 0;
    if ($158 >>> 0 < 1073741823) {
     $160 = $158 << 1;
     $$0$i$i$i19 = $160 >>> 0 < $154 >>> 0 ? $154 : $160;
    } else $$0$i$i$i19 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i19, $153, $db + 12 | 0);
    $163 = $__v$i$i142 + 8 | 0;
    $164 = HEAP32[$163 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($164, $4);
    HEAP32[$163 >> 2] = $164 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($4);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 104:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj14EEERAT__Kc($5, 13800);
   $167 = $db + 4 | 0;
   $168 = HEAP32[$167 >> 2] | 0;
   $170 = HEAP32[$db + 8 >> 2] | 0;
   if ($168 >>> 0 < $170 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($168, $5);
    HEAP32[$167 >> 2] = (HEAP32[$167 >> 2] | 0) + 24;
   } else {
    $177 = HEAP32[$db >> 2] | 0;
    $178 = $168 - $177 | 0;
    $179 = ($178 | 0) / 24 | 0;
    $180 = $179 + 1 | 0;
    if (($178 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $184 = ($170 - $177 | 0) / 24 | 0;
    if ($184 >>> 0 < 1073741823) {
     $186 = $184 << 1;
     $$0$i$i$i24 = $186 >>> 0 < $180 >>> 0 ? $180 : $186;
    } else $$0$i$i$i24 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i24, $179, $db + 12 | 0);
    $189 = $__v$i$i142 + 8 | 0;
    $190 = HEAP32[$189 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($190, $5);
    HEAP32[$189 >> 2] = $190 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($5);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 115:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj6EEERAT__Kc($6, 13814);
   $193 = $db + 4 | 0;
   $194 = HEAP32[$193 >> 2] | 0;
   $196 = HEAP32[$db + 8 >> 2] | 0;
   if ($194 >>> 0 < $196 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($194, $6);
    HEAP32[$193 >> 2] = (HEAP32[$193 >> 2] | 0) + 24;
   } else {
    $203 = HEAP32[$db >> 2] | 0;
    $204 = $194 - $203 | 0;
    $205 = ($204 | 0) / 24 | 0;
    $206 = $205 + 1 | 0;
    if (($204 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $210 = ($196 - $203 | 0) / 24 | 0;
    if ($210 >>> 0 < 1073741823) {
     $212 = $210 << 1;
     $$0$i$i$i29 = $212 >>> 0 < $206 >>> 0 ? $206 : $212;
    } else $$0$i$i$i29 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i29, $205, $db + 12 | 0);
    $215 = $__v$i$i142 + 8 | 0;
    $216 = HEAP32[$215 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($216, $6);
    HEAP32[$215 >> 2] = $216 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($6);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 116:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj15EEERAT__Kc($7, 13820);
   $219 = $db + 4 | 0;
   $220 = HEAP32[$219 >> 2] | 0;
   $222 = HEAP32[$db + 8 >> 2] | 0;
   if ($220 >>> 0 < $222 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($220, $7);
    HEAP32[$219 >> 2] = (HEAP32[$219 >> 2] | 0) + 24;
   } else {
    $229 = HEAP32[$db >> 2] | 0;
    $230 = $220 - $229 | 0;
    $231 = ($230 | 0) / 24 | 0;
    $232 = $231 + 1 | 0;
    if (($230 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $236 = ($222 - $229 | 0) / 24 | 0;
    if ($236 >>> 0 < 1073741823) {
     $238 = $236 << 1;
     $$0$i$i$i34 = $238 >>> 0 < $232 >>> 0 ? $232 : $238;
    } else $$0$i$i$i34 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i34, $231, $db + 12 | 0);
    $241 = $__v$i$i142 + 8 | 0;
    $242 = HEAP32[$241 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($242, $7);
    HEAP32[$241 >> 2] = $242 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($7);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 105:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj4EEERAT__Kc($8, 14212);
   $245 = $db + 4 | 0;
   $246 = HEAP32[$245 >> 2] | 0;
   $248 = HEAP32[$db + 8 >> 2] | 0;
   if ($246 >>> 0 < $248 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($246, $8);
    HEAP32[$245 >> 2] = (HEAP32[$245 >> 2] | 0) + 24;
   } else {
    $255 = HEAP32[$db >> 2] | 0;
    $256 = $246 - $255 | 0;
    $257 = ($256 | 0) / 24 | 0;
    $258 = $257 + 1 | 0;
    if (($256 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $262 = ($248 - $255 | 0) / 24 | 0;
    if ($262 >>> 0 < 1073741823) {
     $264 = $262 << 1;
     $$0$i$i$i39 = $264 >>> 0 < $258 >>> 0 ? $258 : $264;
    } else $$0$i$i$i39 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i39, $257, $db + 12 | 0);
    $267 = $__v$i$i142 + 8 | 0;
    $268 = HEAP32[$267 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($268, $8);
    HEAP32[$267 >> 2] = $268 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($8);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 106:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj13EEERAT__Kc($9, 14216);
   $271 = $db + 4 | 0;
   $272 = HEAP32[$271 >> 2] | 0;
   $274 = HEAP32[$db + 8 >> 2] | 0;
   if ($272 >>> 0 < $274 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($272, $9);
    HEAP32[$271 >> 2] = (HEAP32[$271 >> 2] | 0) + 24;
   } else {
    $281 = HEAP32[$db >> 2] | 0;
    $282 = $272 - $281 | 0;
    $283 = ($282 | 0) / 24 | 0;
    $284 = $283 + 1 | 0;
    if (($282 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $288 = ($274 - $281 | 0) / 24 | 0;
    if ($288 >>> 0 < 1073741823) {
     $290 = $288 << 1;
     $$0$i$i$i44 = $290 >>> 0 < $284 >>> 0 ? $284 : $290;
    } else $$0$i$i$i44 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i44, $283, $db + 12 | 0);
    $293 = $__v$i$i142 + 8 | 0;
    $294 = HEAP32[$293 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($294, $9);
    HEAP32[$293 >> 2] = $294 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($9);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 108:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($10, 14229);
   $297 = $db + 4 | 0;
   $298 = HEAP32[$297 >> 2] | 0;
   $300 = HEAP32[$db + 8 >> 2] | 0;
   if ($298 >>> 0 < $300 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($298, $10);
    HEAP32[$297 >> 2] = (HEAP32[$297 >> 2] | 0) + 24;
   } else {
    $307 = HEAP32[$db >> 2] | 0;
    $308 = $298 - $307 | 0;
    $309 = ($308 | 0) / 24 | 0;
    $310 = $309 + 1 | 0;
    if (($308 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $314 = ($300 - $307 | 0) / 24 | 0;
    if ($314 >>> 0 < 1073741823) {
     $316 = $314 << 1;
     $$0$i$i$i49 = $316 >>> 0 < $310 >>> 0 ? $310 : $316;
    } else $$0$i$i$i49 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i49, $309, $db + 12 | 0);
    $319 = $__v$i$i142 + 8 | 0;
    $320 = HEAP32[$319 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($320, $10);
    HEAP32[$319 >> 2] = $320 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($10);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 109:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj14EEERAT__Kc($11, 14234);
   $323 = $db + 4 | 0;
   $324 = HEAP32[$323 >> 2] | 0;
   $326 = HEAP32[$db + 8 >> 2] | 0;
   if ($324 >>> 0 < $326 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($324, $11);
    HEAP32[$323 >> 2] = (HEAP32[$323 >> 2] | 0) + 24;
   } else {
    $333 = HEAP32[$db >> 2] | 0;
    $334 = $324 - $333 | 0;
    $335 = ($334 | 0) / 24 | 0;
    $336 = $335 + 1 | 0;
    if (($334 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $340 = ($326 - $333 | 0) / 24 | 0;
    if ($340 >>> 0 < 1073741823) {
     $342 = $340 << 1;
     $$0$i$i$i54 = $342 >>> 0 < $336 >>> 0 ? $336 : $342;
    } else $$0$i$i$i54 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i54, $335, $db + 12 | 0);
    $345 = $__v$i$i142 + 8 | 0;
    $346 = HEAP32[$345 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($346, $11);
    HEAP32[$345 >> 2] = $346 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($11);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 120:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($12, 14248);
   $349 = $db + 4 | 0;
   $350 = HEAP32[$349 >> 2] | 0;
   $352 = HEAP32[$db + 8 >> 2] | 0;
   if ($350 >>> 0 < $352 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($350, $12);
    HEAP32[$349 >> 2] = (HEAP32[$349 >> 2] | 0) + 24;
   } else {
    $359 = HEAP32[$db >> 2] | 0;
    $360 = $350 - $359 | 0;
    $361 = ($360 | 0) / 24 | 0;
    $362 = $361 + 1 | 0;
    if (($360 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $366 = ($352 - $359 | 0) / 24 | 0;
    if ($366 >>> 0 < 1073741823) {
     $368 = $366 << 1;
     $$0$i$i$i59 = $368 >>> 0 < $362 >>> 0 ? $362 : $368;
    } else $$0$i$i$i59 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i59, $361, $db + 12 | 0);
    $371 = $__v$i$i142 + 8 | 0;
    $372 = HEAP32[$371 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($372, $12);
    HEAP32[$371 >> 2] = $372 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($12);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 121:
  {
   $375 = _malloc(32) | 0;
   HEAP32[$13 + 8 >> 2] = $375;
   HEAP32[$13 >> 2] = 33;
   HEAP32[$13 + 4 >> 2] = 18;
   dest = $375;
   src = 14258;
   stop = dest + 18 | 0;
   do {
    HEAP8[dest >> 0] = HEAP8[src >> 0] | 0;
    dest = dest + 1 | 0;
    src = src + 1 | 0;
   } while ((dest | 0) < (stop | 0));
   HEAP8[$375 + 18 >> 0] = 0;
   $379 = $13 + 12 | 0;
   HEAP32[$379 >> 2] = 0;
   HEAP32[$379 + 4 >> 2] = 0;
   HEAP32[$379 + 8 >> 2] = 0;
   $382 = $db + 4 | 0;
   $383 = HEAP32[$382 >> 2] | 0;
   $385 = HEAP32[$db + 8 >> 2] | 0;
   if ($383 >>> 0 < $385 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($383, $13);
    HEAP32[$382 >> 2] = (HEAP32[$382 >> 2] | 0) + 24;
   } else {
    $392 = HEAP32[$db >> 2] | 0;
    $393 = $383 - $392 | 0;
    $394 = ($393 | 0) / 24 | 0;
    $395 = $394 + 1 | 0;
    if (($393 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $399 = ($385 - $392 | 0) / 24 | 0;
    if ($399 >>> 0 < 1073741823) {
     $401 = $399 << 1;
     $$0$i$i$i66 = $401 >>> 0 < $395 >>> 0 ? $395 : $401;
    } else $$0$i$i$i66 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i66, $394, $db + 12 | 0);
    $404 = $__v$i$i142 + 8 | 0;
    $405 = HEAP32[$404 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($405, $13);
    HEAP32[$404 >> 2] = $405 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($13);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 110:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj9EEERAT__Kc($14, 13850);
   $408 = $db + 4 | 0;
   $409 = HEAP32[$408 >> 2] | 0;
   $411 = HEAP32[$db + 8 >> 2] | 0;
   if ($409 >>> 0 < $411 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($409, $14);
    HEAP32[$408 >> 2] = (HEAP32[$408 >> 2] | 0) + 24;
   } else {
    $418 = HEAP32[$db >> 2] | 0;
    $419 = $409 - $418 | 0;
    $420 = ($419 | 0) / 24 | 0;
    $421 = $420 + 1 | 0;
    if (($419 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $425 = ($411 - $418 | 0) / 24 | 0;
    if ($425 >>> 0 < 1073741823) {
     $427 = $425 << 1;
     $$0$i$i$i71 = $427 >>> 0 < $421 >>> 0 ? $421 : $427;
    } else $$0$i$i$i71 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i71, $420, $db + 12 | 0);
    $430 = $__v$i$i142 + 8 | 0;
    $431 = HEAP32[$430 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($431, $14);
    HEAP32[$430 >> 2] = $431 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($14);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 111:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj18EEERAT__Kc($15, 13859);
   $434 = $db + 4 | 0;
   $435 = HEAP32[$434 >> 2] | 0;
   $437 = HEAP32[$db + 8 >> 2] | 0;
   if ($435 >>> 0 < $437 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($435, $15);
    HEAP32[$434 >> 2] = (HEAP32[$434 >> 2] | 0) + 24;
   } else {
    $444 = HEAP32[$db >> 2] | 0;
    $445 = $435 - $444 | 0;
    $446 = ($445 | 0) / 24 | 0;
    $447 = $446 + 1 | 0;
    if (($445 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $451 = ($437 - $444 | 0) / 24 | 0;
    if ($451 >>> 0 < 1073741823) {
     $453 = $451 << 1;
     $$0$i$i$i76 = $453 >>> 0 < $447 >>> 0 ? $447 : $453;
    } else $$0$i$i$i76 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i76, $446, $db + 12 | 0);
    $456 = $__v$i$i142 + 8 | 0;
    $457 = HEAP32[$456 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($457, $15);
    HEAP32[$456 >> 2] = $457 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($15);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 102:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj6EEERAT__Kc($16, 14277);
   $460 = $db + 4 | 0;
   $461 = HEAP32[$460 >> 2] | 0;
   $463 = HEAP32[$db + 8 >> 2] | 0;
   if ($461 >>> 0 < $463 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($461, $16);
    HEAP32[$460 >> 2] = (HEAP32[$460 >> 2] | 0) + 24;
   } else {
    $470 = HEAP32[$db >> 2] | 0;
    $471 = $461 - $470 | 0;
    $472 = ($471 | 0) / 24 | 0;
    $473 = $472 + 1 | 0;
    if (($471 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $477 = ($463 - $470 | 0) / 24 | 0;
    if ($477 >>> 0 < 1073741823) {
     $479 = $477 << 1;
     $$0$i$i$i81 = $479 >>> 0 < $473 >>> 0 ? $473 : $479;
    } else $$0$i$i$i81 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i81, $472, $db + 12 | 0);
    $482 = $__v$i$i142 + 8 | 0;
    $483 = HEAP32[$482 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($483, $16);
    HEAP32[$482 >> 2] = $483 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($16);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 100:
  {
   HEAP8[$17 >> 0] = 12;
   $486 = $17 + 1 | 0;
   HEAP8[$486 >> 0] = HEAP8[14283] | 0;
   HEAP8[$486 + 1 >> 0] = HEAP8[14284] | 0;
   HEAP8[$486 + 2 >> 0] = HEAP8[14285] | 0;
   HEAP8[$486 + 3 >> 0] = HEAP8[14286] | 0;
   HEAP8[$486 + 4 >> 0] = HEAP8[14287] | 0;
   HEAP8[$486 + 5 >> 0] = HEAP8[14288] | 0;
   HEAP8[$17 + 7 >> 0] = 0;
   $488 = $17 + 12 | 0;
   HEAP32[$488 >> 2] = 0;
   HEAP32[$488 + 4 >> 2] = 0;
   HEAP32[$488 + 8 >> 2] = 0;
   $491 = $db + 4 | 0;
   $492 = HEAP32[$491 >> 2] | 0;
   $494 = HEAP32[$db + 8 >> 2] | 0;
   if ($492 >>> 0 < $494 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($492, $17);
    HEAP32[$491 >> 2] = (HEAP32[$491 >> 2] | 0) + 24;
   } else {
    $501 = HEAP32[$db >> 2] | 0;
    $502 = $492 - $501 | 0;
    $503 = ($502 | 0) / 24 | 0;
    $504 = $503 + 1 | 0;
    if (($502 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $508 = ($494 - $501 | 0) / 24 | 0;
    if ($508 >>> 0 < 1073741823) {
     $510 = $508 << 1;
     $$0$i$i$i88 = $510 >>> 0 < $504 >>> 0 ? $504 : $510;
    } else $$0$i$i$i88 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i88, $503, $db + 12 | 0);
    $513 = $__v$i$i142 + 8 | 0;
    $514 = HEAP32[$513 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($514, $17);
    HEAP32[$513 >> 2] = $514 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($17);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 101:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj12EEERAT__Kc($18, 14290);
   $517 = $db + 4 | 0;
   $518 = HEAP32[$517 >> 2] | 0;
   $520 = HEAP32[$db + 8 >> 2] | 0;
   if ($518 >>> 0 < $520 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($518, $18);
    HEAP32[$517 >> 2] = (HEAP32[$517 >> 2] | 0) + 24;
   } else {
    $527 = HEAP32[$db >> 2] | 0;
    $528 = $518 - $527 | 0;
    $529 = ($528 | 0) / 24 | 0;
    $530 = $529 + 1 | 0;
    if (($528 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $534 = ($520 - $527 | 0) / 24 | 0;
    if ($534 >>> 0 < 1073741823) {
     $536 = $534 << 1;
     $$0$i$i$i93 = $536 >>> 0 < $530 >>> 0 ? $530 : $536;
    } else $$0$i$i$i93 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i93, $529, $db + 12 | 0);
    $539 = $__v$i$i142 + 8 | 0;
    $540 = HEAP32[$539 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($540, $18);
    HEAP32[$539 >> 2] = $540 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($18);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 103:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($19, 14302);
   $543 = $db + 4 | 0;
   $544 = HEAP32[$543 >> 2] | 0;
   $546 = HEAP32[$db + 8 >> 2] | 0;
   if ($544 >>> 0 < $546 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($544, $19);
    HEAP32[$543 >> 2] = (HEAP32[$543 >> 2] | 0) + 24;
   } else {
    $553 = HEAP32[$db >> 2] | 0;
    $554 = $544 - $553 | 0;
    $555 = ($554 | 0) / 24 | 0;
    $556 = $555 + 1 | 0;
    if (($554 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $560 = ($546 - $553 | 0) / 24 | 0;
    if ($560 >>> 0 < 1073741823) {
     $562 = $560 << 1;
     $$0$i$i$i98 = $562 >>> 0 < $556 >>> 0 ? $556 : $562;
    } else $$0$i$i$i98 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i98, $555, $db + 12 | 0);
    $565 = $__v$i$i142 + 8 | 0;
    $566 = HEAP32[$565 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($566, $19);
    HEAP32[$565 >> 2] = $566 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($19);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 122:
  {
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj4EEERAT__Kc($20, 14313);
   $569 = $db + 4 | 0;
   $570 = HEAP32[$569 >> 2] | 0;
   $572 = HEAP32[$db + 8 >> 2] | 0;
   if ($570 >>> 0 < $572 >>> 0) {
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($570, $20);
    HEAP32[$569 >> 2] = (HEAP32[$569 >> 2] | 0) + 24;
   } else {
    $579 = HEAP32[$db >> 2] | 0;
    $580 = $570 - $579 | 0;
    $581 = ($580 | 0) / 24 | 0;
    $582 = $581 + 1 | 0;
    if (($580 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
    $586 = ($572 - $579 | 0) / 24 | 0;
    if ($586 >>> 0 < 1073741823) {
     $588 = $586 << 1;
     $$0$i$i$i103 = $588 >>> 0 < $582 >>> 0 ? $582 : $588;
    } else $$0$i$i$i103 = 2147483647;
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i103, $581, $db + 12 | 0);
    $591 = $__v$i$i142 + 8 | 0;
    $592 = HEAP32[$591 >> 2] | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($592, $20);
    HEAP32[$591 >> 2] = $592 + 24;
    __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
    __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
   }
   __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($20);
   $$0 = $first + 1 | 0;
   break L1;
   break;
  }
 case 117:
  {
   $595 = $first + 1 | 0;
   $596 = __ZN10__cxxabiv112_GLOBAL__N_117parse_source_nameINS0_2DbEEEPKcS4_S4_RT_($595, $last, $db) | 0;
   STACKTOP = sp;
   return (($596 | 0) == ($595 | 0) ? $first : $596) | 0;
  }
 case 68:
  {
   $598 = $first + 1 | 0;
   if (($598 | 0) == ($last | 0)) {
    $$0 = $first;
    break L1;
   }
   switch (HEAP8[$598 >> 0] | 0) {
   case 100:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($21, 14317);
     $602 = $db + 4 | 0;
     $603 = HEAP32[$602 >> 2] | 0;
     $605 = HEAP32[$db + 8 >> 2] | 0;
     if ($603 >>> 0 < $605 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($603, $21);
      HEAP32[$602 >> 2] = (HEAP32[$602 >> 2] | 0) + 24;
     } else {
      $612 = HEAP32[$db >> 2] | 0;
      $613 = $603 - $612 | 0;
      $614 = ($613 | 0) / 24 | 0;
      $615 = $614 + 1 | 0;
      if (($613 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $619 = ($605 - $612 | 0) / 24 | 0;
      if ($619 >>> 0 < 1073741823) {
       $621 = $619 << 1;
       $$0$i$i$i108 = $621 >>> 0 < $615 >>> 0 ? $615 : $621;
      } else $$0$i$i$i108 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i108, $614, $db + 12 | 0);
      $624 = $__v$i$i142 + 8 | 0;
      $625 = HEAP32[$624 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($625, $21);
      HEAP32[$624 >> 2] = $625 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($21);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 101:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj11EEERAT__Kc($22, 14327);
     $628 = $db + 4 | 0;
     $629 = HEAP32[$628 >> 2] | 0;
     $631 = HEAP32[$db + 8 >> 2] | 0;
     if ($629 >>> 0 < $631 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($629, $22);
      HEAP32[$628 >> 2] = (HEAP32[$628 >> 2] | 0) + 24;
     } else {
      $638 = HEAP32[$db >> 2] | 0;
      $639 = $629 - $638 | 0;
      $640 = ($639 | 0) / 24 | 0;
      $641 = $640 + 1 | 0;
      if (($639 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $645 = ($631 - $638 | 0) / 24 | 0;
      if ($645 >>> 0 < 1073741823) {
       $647 = $645 << 1;
       $$0$i$i$i113 = $647 >>> 0 < $641 >>> 0 ? $641 : $647;
      } else $$0$i$i$i113 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i113, $640, $db + 12 | 0);
      $650 = $__v$i$i142 + 8 | 0;
      $651 = HEAP32[$650 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($651, $22);
      HEAP32[$650 >> 2] = $651 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($22);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 102:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($23, 14338);
     $654 = $db + 4 | 0;
     $655 = HEAP32[$654 >> 2] | 0;
     $657 = HEAP32[$db + 8 >> 2] | 0;
     if ($655 >>> 0 < $657 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($655, $23);
      HEAP32[$654 >> 2] = (HEAP32[$654 >> 2] | 0) + 24;
     } else {
      $664 = HEAP32[$db >> 2] | 0;
      $665 = $655 - $664 | 0;
      $666 = ($665 | 0) / 24 | 0;
      $667 = $666 + 1 | 0;
      if (($665 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $671 = ($657 - $664 | 0) / 24 | 0;
      if ($671 >>> 0 < 1073741823) {
       $673 = $671 << 1;
       $$0$i$i$i118 = $673 >>> 0 < $667 >>> 0 ? $667 : $673;
      } else $$0$i$i$i118 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i118, $666, $db + 12 | 0);
      $676 = $__v$i$i142 + 8 | 0;
      $677 = HEAP32[$676 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($677, $23);
      HEAP32[$676 >> 2] = $677 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($23);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 104:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj10EEERAT__Kc($24, 14348);
     $680 = $db + 4 | 0;
     $681 = HEAP32[$680 >> 2] | 0;
     $683 = HEAP32[$db + 8 >> 2] | 0;
     if ($681 >>> 0 < $683 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($681, $24);
      HEAP32[$680 >> 2] = (HEAP32[$680 >> 2] | 0) + 24;
     } else {
      $690 = HEAP32[$db >> 2] | 0;
      $691 = $681 - $690 | 0;
      $692 = ($691 | 0) / 24 | 0;
      $693 = $692 + 1 | 0;
      if (($691 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $697 = ($683 - $690 | 0) / 24 | 0;
      if ($697 >>> 0 < 1073741823) {
       $699 = $697 << 1;
       $$0$i$i$i123 = $699 >>> 0 < $693 >>> 0 ? $693 : $699;
      } else $$0$i$i$i123 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i123, $692, $db + 12 | 0);
      $702 = $__v$i$i142 + 8 | 0;
      $703 = HEAP32[$702 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($703, $24);
      HEAP32[$702 >> 2] = $703 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($24);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 105:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj9EEERAT__Kc($25, 14358);
     $706 = $db + 4 | 0;
     $707 = HEAP32[$706 >> 2] | 0;
     $709 = HEAP32[$db + 8 >> 2] | 0;
     if ($707 >>> 0 < $709 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($707, $25);
      HEAP32[$706 >> 2] = (HEAP32[$706 >> 2] | 0) + 24;
     } else {
      $716 = HEAP32[$db >> 2] | 0;
      $717 = $707 - $716 | 0;
      $718 = ($717 | 0) / 24 | 0;
      $719 = $718 + 1 | 0;
      if (($717 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $723 = ($709 - $716 | 0) / 24 | 0;
      if ($723 >>> 0 < 1073741823) {
       $725 = $723 << 1;
       $$0$i$i$i128 = $725 >>> 0 < $719 >>> 0 ? $719 : $725;
      } else $$0$i$i$i128 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i128, $718, $db + 12 | 0);
      $728 = $__v$i$i142 + 8 | 0;
      $729 = HEAP32[$728 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($729, $25);
      HEAP32[$728 >> 2] = $729 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($25);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 115:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj9EEERAT__Kc($26, 14367);
     $732 = $db + 4 | 0;
     $733 = HEAP32[$732 >> 2] | 0;
     $735 = HEAP32[$db + 8 >> 2] | 0;
     if ($733 >>> 0 < $735 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($733, $26);
      HEAP32[$732 >> 2] = (HEAP32[$732 >> 2] | 0) + 24;
     } else {
      $742 = HEAP32[$db >> 2] | 0;
      $743 = $733 - $742 | 0;
      $744 = ($743 | 0) / 24 | 0;
      $745 = $744 + 1 | 0;
      if (($743 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $749 = ($735 - $742 | 0) / 24 | 0;
      if ($749 >>> 0 < 1073741823) {
       $751 = $749 << 1;
       $$0$i$i$i133 = $751 >>> 0 < $745 >>> 0 ? $745 : $751;
      } else $$0$i$i$i133 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i133, $744, $db + 12 | 0);
      $754 = $__v$i$i142 + 8 | 0;
      $755 = HEAP32[$754 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($755, $26);
      HEAP32[$754 >> 2] = $755 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($26);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 97:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($27, 14376);
     $758 = $db + 4 | 0;
     $759 = HEAP32[$758 >> 2] | 0;
     $761 = HEAP32[$db + 8 >> 2] | 0;
     if ($759 >>> 0 < $761 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($759, $27);
      HEAP32[$758 >> 2] = (HEAP32[$758 >> 2] | 0) + 24;
     } else {
      $768 = HEAP32[$db >> 2] | 0;
      $769 = $759 - $768 | 0;
      $770 = ($769 | 0) / 24 | 0;
      $771 = $770 + 1 | 0;
      if (($769 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $775 = ($761 - $768 | 0) / 24 | 0;
      if ($775 >>> 0 < 1073741823) {
       $777 = $775 << 1;
       $$0$i$i$i138 = $777 >>> 0 < $771 >>> 0 ? $771 : $777;
      } else $$0$i$i$i138 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i138, $770, $db + 12 | 0);
      $780 = $__v$i$i142 + 8 | 0;
      $781 = HEAP32[$780 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($781, $27);
      HEAP32[$780 >> 2] = $781 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($27);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   case 110:
    {
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj15EEERAT__Kc($28, 14381);
     $784 = $db + 4 | 0;
     $785 = HEAP32[$784 >> 2] | 0;
     $787 = HEAP32[$db + 8 >> 2] | 0;
     if ($785 >>> 0 < $787 >>> 0) {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($785, $28);
      HEAP32[$784 >> 2] = (HEAP32[$784 >> 2] | 0) + 24;
     } else {
      $794 = HEAP32[$db >> 2] | 0;
      $795 = $785 - $794 | 0;
      $796 = ($795 | 0) / 24 | 0;
      $797 = $796 + 1 | 0;
      if (($795 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
      $801 = ($787 - $794 | 0) / 24 | 0;
      if ($801 >>> 0 < 1073741823) {
       $803 = $801 << 1;
       $$0$i$i$i143 = $803 >>> 0 < $797 >>> 0 ? $797 : $803;
      } else $$0$i$i$i143 = 2147483647;
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i142, $$0$i$i$i143, $796, $db + 12 | 0);
      $806 = $__v$i$i142 + 8 | 0;
      $807 = HEAP32[$806 >> 2] | 0;
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($807, $28);
      HEAP32[$806 >> 2] = $807 + 24;
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i142);
      __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i142);
     }
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($28);
     $$0 = $first + 2 | 0;
     break L1;
     break;
    }
   default:
    {
     $$0 = $first;
     break L1;
    }
   }
   break;
  }
 default:
  {
   $$0 = $first;
   break L1;
  }
 } while (0); while (0);
 STACKTOP = sp;
 return $$0 | 0;
}

function _malloc($bytes) {
 $bytes = $bytes | 0;
 var $$3$i = 0, $$lcssa = 0, $$lcssa211 = 0, $$lcssa215 = 0, $$lcssa216 = 0, $$lcssa217 = 0, $$lcssa219 = 0, $$lcssa222 = 0, $$lcssa224 = 0, $$lcssa226 = 0, $$lcssa228 = 0, $$lcssa230 = 0, $$lcssa232 = 0, $$pre$phi$i$iZ2D = 0, $$pre$phi$i23$iZ2D = 0, $$pre$phi$i26Z2D = 0, $$pre$phi$iZ2D = 0, $$pre$phi58$i$iZ2D = 0, $$pre$phiZ2D = 0, $$rsize$3$i = 0, $$sum$i19$i = 0, $$sum2$i21$i = 0, $$sum3132$i$i = 0, $$sum67$i$i = 0, $100 = 0, $1000 = 0, $1002 = 0, $1005 = 0, $1010 = 0, $1016 = 0, $1019 = 0, $1020 = 0, $1027 = 0, $1039 = 0, $1044 = 0, $1051 = 0, $1052 = 0, $1053 = 0, $106 = 0, $1060 = 0, $1062 = 0, $1063 = 0, $1070 = 0, $110 = 0, $112 = 0, $113 = 0, $115 = 0, $117 = 0, $119 = 0, $12 = 0, $121 = 0, $123 = 0, $125 = 0, $127 = 0, $13 = 0, $132 = 0, $138 = 0, $14 = 0, $141 = 0, $144 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $151 = 0, $154 = 0, $156 = 0, $159 = 0, $16 = 0, $161 = 0, $164 = 0, $167 = 0, $168 = 0, $17 = 0, $170 = 0, $171 = 0, $173 = 0, $174 = 0, $176 = 0, $177 = 0, $18 = 0, $182 = 0, $183 = 0, $192 = 0, $197 = 0, $201 = 0, $207 = 0, $214 = 0, $217 = 0, $225 = 0, $227 = 0, $228 = 0, $229 = 0, $230 = 0, $231 = 0, $232 = 0, $236 = 0, $237 = 0, $245 = 0, $246 = 0, $247 = 0, $249 = 0, $25 = 0, $250 = 0, $255 = 0, $256 = 0, $259 = 0, $261 = 0, $264 = 0, $269 = 0, $276 = 0, $28 = 0, $285 = 0, $286 = 0, $290 = 0, $300 = 0, $303 = 0, $307 = 0, $309 = 0, $31 = 0, $310 = 0, $312 = 0, $314 = 0, $316 = 0, $318 = 0, $320 = 0, $322 = 0, $324 = 0, $334 = 0, $335 = 0, $337 = 0, $34 = 0, $346 = 0, $348 = 0, $351 = 0, $353 = 0, $356 = 0, $358 = 0, $361 = 0, $364 = 0, $365 = 0, $367 = 0, $368 = 0, $370 = 0, $371 = 0, $373 = 0, $374 = 0, $379 = 0, $38 = 0, $380 = 0, $389 = 0, $394 = 0, $398 = 0, $4 = 0, $404 = 0, $41 = 0, $411 = 0, $414 = 0, $422 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $431 = 0, $432 = 0, $438 = 0, $44 = 0, $443 = 0, $444 = 0, $447 = 0, $449 = 0, $452 = 0, $457 = 0, $46 = 0, $463 = 0, $467 = 0, $468 = 0, $47 = 0, $475 = 0, $487 = 0, $49 = 0, $492 = 0, $499 = 0, $5 = 0, $500 = 0, $501 = 0, $509 = 0, $51 = 0, $511 = 0, $512 = 0, $522 = 0, $526 = 0, $528 = 0, $529 = 0, $53 = 0, $538 = 0, $544 = 0, $545 = 0, $546 = 0, $547 = 0, $548 = 0, $549 = 0, $55 = 0, $550 = 0, $552 = 0, $554 = 0, $555 = 0, $561 = 0, $563 = 0, $565 = 0, $57 = 0, $572 = 0, $574 = 0, $575 = 0, $576 = 0, $584 = 0, $585 = 0, $588 = 0, $59 = 0, $592 = 0, $593 = 0, $596 = 0, $598 = 0, $6 = 0, $602 = 0, $604 = 0, $608 = 0, $61 = 0, $612 = 0, $621 = 0, $622 = 0, $628 = 0, $630 = 0, $632 = 0, $635 = 0, $637 = 0, $64 = 0, $641 = 0, $642 = 0, $648 = 0, $65 = 0, $653 = 0, $655 = 0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $67 = 0, $676 = 0, $678 = 0, $68 = 0, $683 = 0, $685 = 0, $69 = 0, $690 = 0, $692 = 0, $7 = 0, $70 = 0, $702 = 0, $706 = 0, $711 = 0, $714 = 0, $719 = 0, $720 = 0, $724 = 0, $725 = 0, $730 = 0, $736 = 0, $741 = 0, $744 = 0, $745 = 0, $748 = 0, $750 = 0, $752 = 0, $755 = 0, $766 = 0, $77 = 0, $771 = 0, $773 = 0, $776 = 0, $778 = 0, $781 = 0, $784 = 0, $785 = 0, $787 = 0, $788 = 0, $790 = 0, $791 = 0, $793 = 0, $794 = 0, $799 = 0, $80 = 0, $800 = 0, $809 = 0, $81 = 0, $814 = 0, $818 = 0, $824 = 0, $832 = 0, $838 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $847 = 0, $848 = 0, $854 = 0, $859 = 0, $860 = 0, $863 = 0, $865 = 0, $868 = 0, $873 = 0, $879 = 0, $883 = 0, $884 = 0, $89 = 0, $891 = 0, $90 = 0, $903 = 0, $908 = 0, $91 = 0, $915 = 0, $916 = 0, $917 = 0, $92 = 0, $925 = 0, $928 = 0, $929 = 0, $93 = 0, $934 = 0, $94 = 0, $940 = 0, $941 = 0, $943 = 0, $944 = 0, $947 = 0, $95 = 0, $952 = 0, $954 = 0, $959 = 0, $960 = 0, $964 = 0, $970 = 0, $975 = 0, $977 = 0, $978 = 0, $979 = 0, $980 = 0, $984 = 0, $985 = 0, $99 = 0, $991 = 0, $996 = 0, $997 = 0, $F$0$i$i = 0, $F1$0$i = 0, $F4$0 = 0, $F4$0$i$i = 0, $F5$0$i = 0, $I1$0$i$i = 0, $I7$0$i = 0, $I7$0$i$i = 0, $K12$029$i = 0, $K2$07$i$i = 0, $K8$051$i$i = 0, $R$0$i = 0, $R$0$i$i = 0, $R$0$i$i$lcssa = 0, $R$0$i$lcssa = 0, $R$0$i18 = 0, $R$0$i18$lcssa = 0, $R$1$i = 0, $R$1$i$i = 0, $R$1$i20 = 0, $RP$0$i = 0, $RP$0$i$i = 0, $RP$0$i$i$lcssa = 0, $RP$0$i$lcssa = 0, $RP$0$i17 = 0, $RP$0$i17$lcssa = 0, $T$0$lcssa$i = 0, $T$0$lcssa$i$i = 0, $T$0$lcssa$i25$i = 0, $T$028$i = 0, $T$028$i$lcssa = 0, $T$050$i$i = 0, $T$050$i$i$lcssa = 0, $T$06$i$i = 0, $T$06$i$i$lcssa = 0, $br$0$ph$i = 0, $i$02$i$i = 0, $idx$0$i = 0, $mem$0 = 0, $nb$0 = 0, $oldfirst$0$i$i = 0, $qsize$0$i$i = 0, $rsize$0$i = 0, $rsize$0$i$lcssa = 0, $rsize$0$i15 = 0, $rsize$1$i = 0, $rsize$2$i = 0, $rsize$3$lcssa$i = 0, $rsize$331$i = 0, $rst$0$i = 0, $rst$1$i = 0, $sizebits$0$i = 0, $sp$0$i$i = 0, $sp$0$i$i$i = 0, $sp$084$i = 0, $sp$084$i$lcssa = 0, $sp$183$i = 0, $sp$183$i$lcssa = 0, $ssize$0$$i = 0, $ssize$0$i = 0, $ssize$1$ph$i = 0, $ssize$2$i = 0, $t$0$i = 0, $t$0$i14 = 0, $t$1$i = 0, $t$2$ph$i = 0, $t$2$v$3$i = 0, $t$230$i = 0, $tbase$255$i = 0, $tsize$0$ph$i = 0, $tsize$0323944$i = 0, $tsize$1$i = 0, $tsize$254$i = 0, $v$0$i = 0, $v$0$i$lcssa = 0, $v$0$i16 = 0, $v$1$i = 0, $v$2$i = 0, $v$3$lcssa$i = 0, $v$3$ph$i = 0, $v$332$i = 0, label = 0, $964$looptemp = 0;
 do if ($bytes >>> 0 < 245) {
  $4 = $bytes >>> 0 < 11 ? 16 : $bytes + 11 & -8;
  $5 = $4 >>> 3;
  $6 = HEAP32[756] | 0;
  $7 = $6 >>> $5;
  if ($7 & 3) {
   $12 = ($7 & 1 ^ 1) + $5 | 0;
   $13 = $12 << 1;
   $14 = 3064 + ($13 << 2) | 0;
   $15 = 3064 + ($13 + 2 << 2) | 0;
   $16 = HEAP32[$15 >> 2] | 0;
   $17 = $16 + 8 | 0;
   $18 = HEAP32[$17 >> 2] | 0;
   do if (($14 | 0) == ($18 | 0)) HEAP32[756] = $6 & ~(1 << $12); else {
    if ($18 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort();
    $25 = $18 + 12 | 0;
    if ((HEAP32[$25 >> 2] | 0) == ($16 | 0)) {
     HEAP32[$25 >> 2] = $14;
     HEAP32[$15 >> 2] = $18;
     break;
    } else _abort();
   } while (0);
   $28 = $12 << 3;
   HEAP32[$16 + 4 >> 2] = $28 | 3;
   $31 = $16 + ($28 | 4) | 0;
   HEAP32[$31 >> 2] = HEAP32[$31 >> 2] | 1;
   $mem$0 = $17;
   return $mem$0 | 0;
  }
  $34 = HEAP32[758] | 0;
  if ($4 >>> 0 > $34 >>> 0) {
   if ($7) {
    $38 = 2 << $5;
    $41 = $7 << $5 & ($38 | 0 - $38);
    $44 = ($41 & 0 - $41) + -1 | 0;
    $46 = $44 >>> 12 & 16;
    $47 = $44 >>> $46;
    $49 = $47 >>> 5 & 8;
    $51 = $47 >>> $49;
    $53 = $51 >>> 2 & 4;
    $55 = $51 >>> $53;
    $57 = $55 >>> 1 & 2;
    $59 = $55 >>> $57;
    $61 = $59 >>> 1 & 1;
    $64 = ($49 | $46 | $53 | $57 | $61) + ($59 >>> $61) | 0;
    $65 = $64 << 1;
    $66 = 3064 + ($65 << 2) | 0;
    $67 = 3064 + ($65 + 2 << 2) | 0;
    $68 = HEAP32[$67 >> 2] | 0;
    $69 = $68 + 8 | 0;
    $70 = HEAP32[$69 >> 2] | 0;
    do if (($66 | 0) == ($70 | 0)) {
     HEAP32[756] = $6 & ~(1 << $64);
     $89 = $34;
    } else {
     if ($70 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort();
     $77 = $70 + 12 | 0;
     if ((HEAP32[$77 >> 2] | 0) == ($68 | 0)) {
      HEAP32[$77 >> 2] = $66;
      HEAP32[$67 >> 2] = $70;
      $89 = HEAP32[758] | 0;
      break;
     } else _abort();
    } while (0);
    $80 = $64 << 3;
    $81 = $80 - $4 | 0;
    HEAP32[$68 + 4 >> 2] = $4 | 3;
    $84 = $68 + $4 | 0;
    HEAP32[$68 + ($4 | 4) >> 2] = $81 | 1;
    HEAP32[$68 + $80 >> 2] = $81;
    if ($89) {
     $90 = HEAP32[761] | 0;
     $91 = $89 >>> 3;
     $92 = $91 << 1;
     $93 = 3064 + ($92 << 2) | 0;
     $94 = HEAP32[756] | 0;
     $95 = 1 << $91;
     if (!($94 & $95)) {
      HEAP32[756] = $94 | $95;
      $$pre$phiZ2D = 3064 + ($92 + 2 << 2) | 0;
      $F4$0 = $93;
     } else {
      $99 = 3064 + ($92 + 2 << 2) | 0;
      $100 = HEAP32[$99 >> 2] | 0;
      if ($100 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
       $$pre$phiZ2D = $99;
       $F4$0 = $100;
      }
     }
     HEAP32[$$pre$phiZ2D >> 2] = $90;
     HEAP32[$F4$0 + 12 >> 2] = $90;
     HEAP32[$90 + 8 >> 2] = $F4$0;
     HEAP32[$90 + 12 >> 2] = $93;
    }
    HEAP32[758] = $81;
    HEAP32[761] = $84;
    $mem$0 = $69;
    return $mem$0 | 0;
   }
   $106 = HEAP32[757] | 0;
   if (!$106) $nb$0 = $4; else {
    $110 = ($106 & 0 - $106) + -1 | 0;
    $112 = $110 >>> 12 & 16;
    $113 = $110 >>> $112;
    $115 = $113 >>> 5 & 8;
    $117 = $113 >>> $115;
    $119 = $117 >>> 2 & 4;
    $121 = $117 >>> $119;
    $123 = $121 >>> 1 & 2;
    $125 = $121 >>> $123;
    $127 = $125 >>> 1 & 1;
    $132 = HEAP32[3328 + (($115 | $112 | $119 | $123 | $127) + ($125 >>> $127) << 2) >> 2] | 0;
    $rsize$0$i = (HEAP32[$132 + 4 >> 2] & -8) - $4 | 0;
    $t$0$i = $132;
    $v$0$i = $132;
    while (1) {
     $138 = HEAP32[$t$0$i + 16 >> 2] | 0;
     if (!$138) {
      $141 = HEAP32[$t$0$i + 20 >> 2] | 0;
      if (!$141) {
       $rsize$0$i$lcssa = $rsize$0$i;
       $v$0$i$lcssa = $v$0$i;
       break;
      } else $144 = $141;
     } else $144 = $138;
     $147 = (HEAP32[$144 + 4 >> 2] & -8) - $4 | 0;
     $148 = $147 >>> 0 < $rsize$0$i >>> 0;
     $rsize$0$i = $148 ? $147 : $rsize$0$i;
     $t$0$i = $144;
     $v$0$i = $148 ? $144 : $v$0$i;
    }
    $149 = HEAP32[760] | 0;
    if ($v$0$i$lcssa >>> 0 < $149 >>> 0) _abort();
    $151 = $v$0$i$lcssa + $4 | 0;
    if ($v$0$i$lcssa >>> 0 >= $151 >>> 0) _abort();
    $154 = HEAP32[$v$0$i$lcssa + 24 >> 2] | 0;
    $156 = HEAP32[$v$0$i$lcssa + 12 >> 2] | 0;
    do if (($156 | 0) == ($v$0$i$lcssa | 0)) {
     $167 = $v$0$i$lcssa + 20 | 0;
     $168 = HEAP32[$167 >> 2] | 0;
     if (!$168) {
      $170 = $v$0$i$lcssa + 16 | 0;
      $171 = HEAP32[$170 >> 2] | 0;
      if (!$171) {
       $R$1$i = 0;
       break;
      } else {
       $R$0$i = $171;
       $RP$0$i = $170;
      }
     } else {
      $R$0$i = $168;
      $RP$0$i = $167;
     }
     while (1) {
      $173 = $R$0$i + 20 | 0;
      $174 = HEAP32[$173 >> 2] | 0;
      if ($174) {
       $R$0$i = $174;
       $RP$0$i = $173;
       continue;
      }
      $176 = $R$0$i + 16 | 0;
      $177 = HEAP32[$176 >> 2] | 0;
      if (!$177) {
       $R$0$i$lcssa = $R$0$i;
       $RP$0$i$lcssa = $RP$0$i;
       break;
      } else {
       $R$0$i = $177;
       $RP$0$i = $176;
      }
     }
     if ($RP$0$i$lcssa >>> 0 < $149 >>> 0) _abort(); else {
      HEAP32[$RP$0$i$lcssa >> 2] = 0;
      $R$1$i = $R$0$i$lcssa;
      break;
     }
    } else {
     $159 = HEAP32[$v$0$i$lcssa + 8 >> 2] | 0;
     if ($159 >>> 0 < $149 >>> 0) _abort();
     $161 = $159 + 12 | 0;
     if ((HEAP32[$161 >> 2] | 0) != ($v$0$i$lcssa | 0)) _abort();
     $164 = $156 + 8 | 0;
     if ((HEAP32[$164 >> 2] | 0) == ($v$0$i$lcssa | 0)) {
      HEAP32[$161 >> 2] = $156;
      HEAP32[$164 >> 2] = $159;
      $R$1$i = $156;
      break;
     } else _abort();
    } while (0);
    do if ($154) {
     $182 = HEAP32[$v$0$i$lcssa + 28 >> 2] | 0;
     $183 = 3328 + ($182 << 2) | 0;
     if (($v$0$i$lcssa | 0) == (HEAP32[$183 >> 2] | 0)) {
      HEAP32[$183 >> 2] = $R$1$i;
      if (!$R$1$i) {
       HEAP32[757] = HEAP32[757] & ~(1 << $182);
       break;
      }
     } else {
      if ($154 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort();
      $192 = $154 + 16 | 0;
      if ((HEAP32[$192 >> 2] | 0) == ($v$0$i$lcssa | 0)) HEAP32[$192 >> 2] = $R$1$i; else HEAP32[$154 + 20 >> 2] = $R$1$i;
      if (!$R$1$i) break;
     }
     $197 = HEAP32[760] | 0;
     if ($R$1$i >>> 0 < $197 >>> 0) _abort();
     HEAP32[$R$1$i + 24 >> 2] = $154;
     $201 = HEAP32[$v$0$i$lcssa + 16 >> 2] | 0;
     do if ($201) if ($201 >>> 0 < $197 >>> 0) _abort(); else {
      HEAP32[$R$1$i + 16 >> 2] = $201;
      HEAP32[$201 + 24 >> 2] = $R$1$i;
      break;
     } while (0);
     $207 = HEAP32[$v$0$i$lcssa + 20 >> 2] | 0;
     if ($207) if ($207 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
      HEAP32[$R$1$i + 20 >> 2] = $207;
      HEAP32[$207 + 24 >> 2] = $R$1$i;
      break;
     }
    } while (0);
    if ($rsize$0$i$lcssa >>> 0 < 16) {
     $214 = $rsize$0$i$lcssa + $4 | 0;
     HEAP32[$v$0$i$lcssa + 4 >> 2] = $214 | 3;
     $217 = $v$0$i$lcssa + ($214 + 4) | 0;
     HEAP32[$217 >> 2] = HEAP32[$217 >> 2] | 1;
    } else {
     HEAP32[$v$0$i$lcssa + 4 >> 2] = $4 | 3;
     HEAP32[$v$0$i$lcssa + ($4 | 4) >> 2] = $rsize$0$i$lcssa | 1;
     HEAP32[$v$0$i$lcssa + ($rsize$0$i$lcssa + $4) >> 2] = $rsize$0$i$lcssa;
     $225 = HEAP32[758] | 0;
     if ($225) {
      $227 = HEAP32[761] | 0;
      $228 = $225 >>> 3;
      $229 = $228 << 1;
      $230 = 3064 + ($229 << 2) | 0;
      $231 = HEAP32[756] | 0;
      $232 = 1 << $228;
      if (!($231 & $232)) {
       HEAP32[756] = $231 | $232;
       $$pre$phi$iZ2D = 3064 + ($229 + 2 << 2) | 0;
       $F1$0$i = $230;
      } else {
       $236 = 3064 + ($229 + 2 << 2) | 0;
       $237 = HEAP32[$236 >> 2] | 0;
       if ($237 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
        $$pre$phi$iZ2D = $236;
        $F1$0$i = $237;
       }
      }
      HEAP32[$$pre$phi$iZ2D >> 2] = $227;
      HEAP32[$F1$0$i + 12 >> 2] = $227;
      HEAP32[$227 + 8 >> 2] = $F1$0$i;
      HEAP32[$227 + 12 >> 2] = $230;
     }
     HEAP32[758] = $rsize$0$i$lcssa;
     HEAP32[761] = $151;
    }
    $mem$0 = $v$0$i$lcssa + 8 | 0;
    return $mem$0 | 0;
   }
  } else $nb$0 = $4;
 } else if ($bytes >>> 0 > 4294967231) $nb$0 = -1; else {
  $245 = $bytes + 11 | 0;
  $246 = $245 & -8;
  $247 = HEAP32[757] | 0;
  if (!$247) $nb$0 = $246; else {
   $249 = 0 - $246 | 0;
   $250 = $245 >>> 8;
   if (!$250) $idx$0$i = 0; else if ($246 >>> 0 > 16777215) $idx$0$i = 31; else {
    $255 = ($250 + 1048320 | 0) >>> 16 & 8;
    $256 = $250 << $255;
    $259 = ($256 + 520192 | 0) >>> 16 & 4;
    $261 = $256 << $259;
    $264 = ($261 + 245760 | 0) >>> 16 & 2;
    $269 = 14 - ($259 | $255 | $264) + ($261 << $264 >>> 15) | 0;
    $idx$0$i = $246 >>> ($269 + 7 | 0) & 1 | $269 << 1;
   }
   $276 = HEAP32[3328 + ($idx$0$i << 2) >> 2] | 0;
   L123 : do if (!$276) {
    $rsize$2$i = $249;
    $t$1$i = 0;
    $v$2$i = 0;
    label = 86;
   } else {
    $rsize$0$i15 = $249;
    $rst$0$i = 0;
    $sizebits$0$i = $246 << (($idx$0$i | 0) == 31 ? 0 : 25 - ($idx$0$i >>> 1) | 0);
    $t$0$i14 = $276;
    $v$0$i16 = 0;
    while (1) {
     $285 = HEAP32[$t$0$i14 + 4 >> 2] & -8;
     $286 = $285 - $246 | 0;
     if ($286 >>> 0 < $rsize$0$i15 >>> 0) if (($285 | 0) == ($246 | 0)) {
      $rsize$331$i = $286;
      $t$230$i = $t$0$i14;
      $v$332$i = $t$0$i14;
      label = 90;
      break L123;
     } else {
      $rsize$1$i = $286;
      $v$1$i = $t$0$i14;
     } else {
      $rsize$1$i = $rsize$0$i15;
      $v$1$i = $v$0$i16;
     }
     $290 = HEAP32[$t$0$i14 + 20 >> 2] | 0;
     $t$0$i14 = HEAP32[$t$0$i14 + 16 + ($sizebits$0$i >>> 31 << 2) >> 2] | 0;
     $rst$1$i = ($290 | 0) == 0 | ($290 | 0) == ($t$0$i14 | 0) ? $rst$0$i : $290;
     if (!$t$0$i14) {
      $rsize$2$i = $rsize$1$i;
      $t$1$i = $rst$1$i;
      $v$2$i = $v$1$i;
      label = 86;
      break;
     } else {
      $rsize$0$i15 = $rsize$1$i;
      $rst$0$i = $rst$1$i;
      $sizebits$0$i = $sizebits$0$i << 1;
      $v$0$i16 = $v$1$i;
     }
    }
   } while (0);
   if ((label | 0) == 86) {
    if (($t$1$i | 0) == 0 & ($v$2$i | 0) == 0) {
     $300 = 2 << $idx$0$i;
     $303 = $247 & ($300 | 0 - $300);
     if (!$303) {
      $nb$0 = $246;
      break;
     }
     $307 = ($303 & 0 - $303) + -1 | 0;
     $309 = $307 >>> 12 & 16;
     $310 = $307 >>> $309;
     $312 = $310 >>> 5 & 8;
     $314 = $310 >>> $312;
     $316 = $314 >>> 2 & 4;
     $318 = $314 >>> $316;
     $320 = $318 >>> 1 & 2;
     $322 = $318 >>> $320;
     $324 = $322 >>> 1 & 1;
     $t$2$ph$i = HEAP32[3328 + (($312 | $309 | $316 | $320 | $324) + ($322 >>> $324) << 2) >> 2] | 0;
     $v$3$ph$i = 0;
    } else {
     $t$2$ph$i = $t$1$i;
     $v$3$ph$i = $v$2$i;
    }
    if (!$t$2$ph$i) {
     $rsize$3$lcssa$i = $rsize$2$i;
     $v$3$lcssa$i = $v$3$ph$i;
    } else {
     $rsize$331$i = $rsize$2$i;
     $t$230$i = $t$2$ph$i;
     $v$332$i = $v$3$ph$i;
     label = 90;
    }
   }
   if ((label | 0) == 90) while (1) {
    label = 0;
    $334 = (HEAP32[$t$230$i + 4 >> 2] & -8) - $246 | 0;
    $335 = $334 >>> 0 < $rsize$331$i >>> 0;
    $$rsize$3$i = $335 ? $334 : $rsize$331$i;
    $t$2$v$3$i = $335 ? $t$230$i : $v$332$i;
    $337 = HEAP32[$t$230$i + 16 >> 2] | 0;
    if ($337) {
     $rsize$331$i = $$rsize$3$i;
     $t$230$i = $337;
     $v$332$i = $t$2$v$3$i;
     label = 90;
     continue;
    }
    $t$230$i = HEAP32[$t$230$i + 20 >> 2] | 0;
    if (!$t$230$i) {
     $rsize$3$lcssa$i = $$rsize$3$i;
     $v$3$lcssa$i = $t$2$v$3$i;
     break;
    } else {
     $rsize$331$i = $$rsize$3$i;
     $v$332$i = $t$2$v$3$i;
     label = 90;
    }
   }
   if (!$v$3$lcssa$i) $nb$0 = $246; else if ($rsize$3$lcssa$i >>> 0 < ((HEAP32[758] | 0) - $246 | 0) >>> 0) {
    $346 = HEAP32[760] | 0;
    if ($v$3$lcssa$i >>> 0 < $346 >>> 0) _abort();
    $348 = $v$3$lcssa$i + $246 | 0;
    if ($v$3$lcssa$i >>> 0 >= $348 >>> 0) _abort();
    $351 = HEAP32[$v$3$lcssa$i + 24 >> 2] | 0;
    $353 = HEAP32[$v$3$lcssa$i + 12 >> 2] | 0;
    do if (($353 | 0) == ($v$3$lcssa$i | 0)) {
     $364 = $v$3$lcssa$i + 20 | 0;
     $365 = HEAP32[$364 >> 2] | 0;
     if (!$365) {
      $367 = $v$3$lcssa$i + 16 | 0;
      $368 = HEAP32[$367 >> 2] | 0;
      if (!$368) {
       $R$1$i20 = 0;
       break;
      } else {
       $R$0$i18 = $368;
       $RP$0$i17 = $367;
      }
     } else {
      $R$0$i18 = $365;
      $RP$0$i17 = $364;
     }
     while (1) {
      $370 = $R$0$i18 + 20 | 0;
      $371 = HEAP32[$370 >> 2] | 0;
      if ($371) {
       $R$0$i18 = $371;
       $RP$0$i17 = $370;
       continue;
      }
      $373 = $R$0$i18 + 16 | 0;
      $374 = HEAP32[$373 >> 2] | 0;
      if (!$374) {
       $R$0$i18$lcssa = $R$0$i18;
       $RP$0$i17$lcssa = $RP$0$i17;
       break;
      } else {
       $R$0$i18 = $374;
       $RP$0$i17 = $373;
      }
     }
     if ($RP$0$i17$lcssa >>> 0 < $346 >>> 0) _abort(); else {
      HEAP32[$RP$0$i17$lcssa >> 2] = 0;
      $R$1$i20 = $R$0$i18$lcssa;
      break;
     }
    } else {
     $356 = HEAP32[$v$3$lcssa$i + 8 >> 2] | 0;
     if ($356 >>> 0 < $346 >>> 0) _abort();
     $358 = $356 + 12 | 0;
     if ((HEAP32[$358 >> 2] | 0) != ($v$3$lcssa$i | 0)) _abort();
     $361 = $353 + 8 | 0;
     if ((HEAP32[$361 >> 2] | 0) == ($v$3$lcssa$i | 0)) {
      HEAP32[$358 >> 2] = $353;
      HEAP32[$361 >> 2] = $356;
      $R$1$i20 = $353;
      break;
     } else _abort();
    } while (0);
    do if ($351) {
     $379 = HEAP32[$v$3$lcssa$i + 28 >> 2] | 0;
     $380 = 3328 + ($379 << 2) | 0;
     if (($v$3$lcssa$i | 0) == (HEAP32[$380 >> 2] | 0)) {
      HEAP32[$380 >> 2] = $R$1$i20;
      if (!$R$1$i20) {
       HEAP32[757] = HEAP32[757] & ~(1 << $379);
       break;
      }
     } else {
      if ($351 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort();
      $389 = $351 + 16 | 0;
      if ((HEAP32[$389 >> 2] | 0) == ($v$3$lcssa$i | 0)) HEAP32[$389 >> 2] = $R$1$i20; else HEAP32[$351 + 20 >> 2] = $R$1$i20;
      if (!$R$1$i20) break;
     }
     $394 = HEAP32[760] | 0;
     if ($R$1$i20 >>> 0 < $394 >>> 0) _abort();
     HEAP32[$R$1$i20 + 24 >> 2] = $351;
     $398 = HEAP32[$v$3$lcssa$i + 16 >> 2] | 0;
     do if ($398) if ($398 >>> 0 < $394 >>> 0) _abort(); else {
      HEAP32[$R$1$i20 + 16 >> 2] = $398;
      HEAP32[$398 + 24 >> 2] = $R$1$i20;
      break;
     } while (0);
     $404 = HEAP32[$v$3$lcssa$i + 20 >> 2] | 0;
     if ($404) if ($404 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
      HEAP32[$R$1$i20 + 20 >> 2] = $404;
      HEAP32[$404 + 24 >> 2] = $R$1$i20;
      break;
     }
    } while (0);
    L199 : do if ($rsize$3$lcssa$i >>> 0 < 16) {
     $411 = $rsize$3$lcssa$i + $246 | 0;
     HEAP32[$v$3$lcssa$i + 4 >> 2] = $411 | 3;
     $414 = $v$3$lcssa$i + ($411 + 4) | 0;
     HEAP32[$414 >> 2] = HEAP32[$414 >> 2] | 1;
    } else {
     HEAP32[$v$3$lcssa$i + 4 >> 2] = $246 | 3;
     HEAP32[$v$3$lcssa$i + ($246 | 4) >> 2] = $rsize$3$lcssa$i | 1;
     HEAP32[$v$3$lcssa$i + ($rsize$3$lcssa$i + $246) >> 2] = $rsize$3$lcssa$i;
     $422 = $rsize$3$lcssa$i >>> 3;
     if ($rsize$3$lcssa$i >>> 0 < 256) {
      $424 = $422 << 1;
      $425 = 3064 + ($424 << 2) | 0;
      $426 = HEAP32[756] | 0;
      $427 = 1 << $422;
      if (!($426 & $427)) {
       HEAP32[756] = $426 | $427;
       $$pre$phi$i26Z2D = 3064 + ($424 + 2 << 2) | 0;
       $F5$0$i = $425;
      } else {
       $431 = 3064 + ($424 + 2 << 2) | 0;
       $432 = HEAP32[$431 >> 2] | 0;
       if ($432 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
        $$pre$phi$i26Z2D = $431;
        $F5$0$i = $432;
       }
      }
      HEAP32[$$pre$phi$i26Z2D >> 2] = $348;
      HEAP32[$F5$0$i + 12 >> 2] = $348;
      HEAP32[$v$3$lcssa$i + ($246 + 8) >> 2] = $F5$0$i;
      HEAP32[$v$3$lcssa$i + ($246 + 12) >> 2] = $425;
      break;
     }
     $438 = $rsize$3$lcssa$i >>> 8;
     if (!$438) $I7$0$i = 0; else if ($rsize$3$lcssa$i >>> 0 > 16777215) $I7$0$i = 31; else {
      $443 = ($438 + 1048320 | 0) >>> 16 & 8;
      $444 = $438 << $443;
      $447 = ($444 + 520192 | 0) >>> 16 & 4;
      $449 = $444 << $447;
      $452 = ($449 + 245760 | 0) >>> 16 & 2;
      $457 = 14 - ($447 | $443 | $452) + ($449 << $452 >>> 15) | 0;
      $I7$0$i = $rsize$3$lcssa$i >>> ($457 + 7 | 0) & 1 | $457 << 1;
     }
     $463 = 3328 + ($I7$0$i << 2) | 0;
     HEAP32[$v$3$lcssa$i + ($246 + 28) >> 2] = $I7$0$i;
     HEAP32[$v$3$lcssa$i + ($246 + 20) >> 2] = 0;
     HEAP32[$v$3$lcssa$i + ($246 + 16) >> 2] = 0;
     $467 = HEAP32[757] | 0;
     $468 = 1 << $I7$0$i;
     if (!($467 & $468)) {
      HEAP32[757] = $467 | $468;
      HEAP32[$463 >> 2] = $348;
      HEAP32[$v$3$lcssa$i + ($246 + 24) >> 2] = $463;
      HEAP32[$v$3$lcssa$i + ($246 + 12) >> 2] = $348;
      HEAP32[$v$3$lcssa$i + ($246 + 8) >> 2] = $348;
      break;
     }
     $475 = HEAP32[$463 >> 2] | 0;
     L217 : do if ((HEAP32[$475 + 4 >> 2] & -8 | 0) == ($rsize$3$lcssa$i | 0)) $T$0$lcssa$i = $475; else {
      $K12$029$i = $rsize$3$lcssa$i << (($I7$0$i | 0) == 31 ? 0 : 25 - ($I7$0$i >>> 1) | 0);
      $T$028$i = $475;
      while (1) {
       $492 = $T$028$i + 16 + ($K12$029$i >>> 31 << 2) | 0;
       $487 = HEAP32[$492 >> 2] | 0;
       if (!$487) {
        $$lcssa232 = $492;
        $T$028$i$lcssa = $T$028$i;
        break;
       }
       if ((HEAP32[$487 + 4 >> 2] & -8 | 0) == ($rsize$3$lcssa$i | 0)) {
        $T$0$lcssa$i = $487;
        break L217;
       } else {
        $K12$029$i = $K12$029$i << 1;
        $T$028$i = $487;
       }
      }
      if ($$lcssa232 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
       HEAP32[$$lcssa232 >> 2] = $348;
       HEAP32[$v$3$lcssa$i + ($246 + 24) >> 2] = $T$028$i$lcssa;
       HEAP32[$v$3$lcssa$i + ($246 + 12) >> 2] = $348;
       HEAP32[$v$3$lcssa$i + ($246 + 8) >> 2] = $348;
       break L199;
      }
     } while (0);
     $499 = $T$0$lcssa$i + 8 | 0;
     $500 = HEAP32[$499 >> 2] | 0;
     $501 = HEAP32[760] | 0;
     if ($500 >>> 0 >= $501 >>> 0 & $T$0$lcssa$i >>> 0 >= $501 >>> 0) {
      HEAP32[$500 + 12 >> 2] = $348;
      HEAP32[$499 >> 2] = $348;
      HEAP32[$v$3$lcssa$i + ($246 + 8) >> 2] = $500;
      HEAP32[$v$3$lcssa$i + ($246 + 12) >> 2] = $T$0$lcssa$i;
      HEAP32[$v$3$lcssa$i + ($246 + 24) >> 2] = 0;
      break;
     } else _abort();
    } while (0);
    $mem$0 = $v$3$lcssa$i + 8 | 0;
    return $mem$0 | 0;
   } else $nb$0 = $246;
  }
 } while (0);
 $509 = HEAP32[758] | 0;
 if ($509 >>> 0 >= $nb$0 >>> 0) {
  $511 = $509 - $nb$0 | 0;
  $512 = HEAP32[761] | 0;
  if ($511 >>> 0 > 15) {
   HEAP32[761] = $512 + $nb$0;
   HEAP32[758] = $511;
   HEAP32[$512 + ($nb$0 + 4) >> 2] = $511 | 1;
   HEAP32[$512 + $509 >> 2] = $511;
   HEAP32[$512 + 4 >> 2] = $nb$0 | 3;
  } else {
   HEAP32[758] = 0;
   HEAP32[761] = 0;
   HEAP32[$512 + 4 >> 2] = $509 | 3;
   $522 = $512 + ($509 + 4) | 0;
   HEAP32[$522 >> 2] = HEAP32[$522 >> 2] | 1;
  }
  $mem$0 = $512 + 8 | 0;
  return $mem$0 | 0;
 }
 $526 = HEAP32[759] | 0;
 if ($526 >>> 0 > $nb$0 >>> 0) {
  $528 = $526 - $nb$0 | 0;
  HEAP32[759] = $528;
  $529 = HEAP32[762] | 0;
  HEAP32[762] = $529 + $nb$0;
  HEAP32[$529 + ($nb$0 + 4) >> 2] = $528 | 1;
  HEAP32[$529 + 4 >> 2] = $nb$0 | 3;
  $mem$0 = $529 + 8 | 0;
  return $mem$0 | 0;
 }
 do if (!(HEAP32[874] | 0)) {
  $538 = _sysconf(30) | 0;
  if (!($538 + -1 & $538)) {
   HEAP32[876] = $538;
   HEAP32[875] = $538;
   HEAP32[877] = -1;
   HEAP32[878] = -1;
   HEAP32[879] = 0;
   HEAP32[867] = 0;
   $544 = (_time(0) | 0) & -16 ^ 1431655768;
   HEAP32[874] = $544;
   break;
  } else _abort();
 } while (0);
 $545 = $nb$0 + 48 | 0;
 $546 = HEAP32[876] | 0;
 $547 = $nb$0 + 47 | 0;
 $548 = $546 + $547 | 0;
 $549 = 0 - $546 | 0;
 $550 = $548 & $549;
 if ($550 >>> 0 <= $nb$0 >>> 0) {
  $mem$0 = 0;
  return $mem$0 | 0;
 }
 $552 = HEAP32[866] | 0;
 if ($552) {
  $554 = HEAP32[864] | 0;
  $555 = $554 + $550 | 0;
  if ($555 >>> 0 <= $554 >>> 0 | $555 >>> 0 > $552 >>> 0) {
   $mem$0 = 0;
   return $mem$0 | 0;
  }
 }
 L258 : do if (!(HEAP32[867] & 4)) {
  $561 = HEAP32[762] | 0;
  L260 : do if (!$561) label = 174; else {
   $sp$0$i$i = 3472;
   while (1) {
    $563 = HEAP32[$sp$0$i$i >> 2] | 0;
    if ($563 >>> 0 <= $561 >>> 0) {
     $565 = $sp$0$i$i + 4 | 0;
     if (($563 + (HEAP32[$565 >> 2] | 0) | 0) >>> 0 > $561 >>> 0) {
      $$lcssa228 = $sp$0$i$i;
      $$lcssa230 = $565;
      break;
     }
    }
    $sp$0$i$i = HEAP32[$sp$0$i$i + 8 >> 2] | 0;
    if (!$sp$0$i$i) {
     label = 174;
     break L260;
    }
   }
   $596 = $548 - (HEAP32[759] | 0) & $549;
   if ($596 >>> 0 < 2147483647) {
    $598 = _sbrk($596 | 0) | 0;
    $602 = ($598 | 0) == ((HEAP32[$$lcssa228 >> 2] | 0) + (HEAP32[$$lcssa230 >> 2] | 0) | 0);
    $$3$i = $602 ? $596 : 0;
    if ($602) if (($598 | 0) == (-1 | 0)) $tsize$0323944$i = $$3$i; else {
     $tbase$255$i = $598;
     $tsize$254$i = $$3$i;
     label = 194;
     break L258;
    } else {
     $br$0$ph$i = $598;
     $ssize$1$ph$i = $596;
     $tsize$0$ph$i = $$3$i;
     label = 184;
    }
   } else $tsize$0323944$i = 0;
  } while (0);
  do if ((label | 0) == 174) {
   $572 = _sbrk(0) | 0;
   if (($572 | 0) == (-1 | 0)) $tsize$0323944$i = 0; else {
    $574 = $572;
    $575 = HEAP32[875] | 0;
    $576 = $575 + -1 | 0;
    if (!($576 & $574)) $ssize$0$i = $550; else $ssize$0$i = $550 - $574 + ($576 + $574 & 0 - $575) | 0;
    $584 = HEAP32[864] | 0;
    $585 = $584 + $ssize$0$i | 0;
    if ($ssize$0$i >>> 0 > $nb$0 >>> 0 & $ssize$0$i >>> 0 < 2147483647) {
     $588 = HEAP32[866] | 0;
     if ($588) if ($585 >>> 0 <= $584 >>> 0 | $585 >>> 0 > $588 >>> 0) {
      $tsize$0323944$i = 0;
      break;
     }
     $592 = _sbrk($ssize$0$i | 0) | 0;
     $593 = ($592 | 0) == ($572 | 0);
     $ssize$0$$i = $593 ? $ssize$0$i : 0;
     if ($593) {
      $tbase$255$i = $572;
      $tsize$254$i = $ssize$0$$i;
      label = 194;
      break L258;
     } else {
      $br$0$ph$i = $592;
      $ssize$1$ph$i = $ssize$0$i;
      $tsize$0$ph$i = $ssize$0$$i;
      label = 184;
     }
    } else $tsize$0323944$i = 0;
   }
  } while (0);
  L280 : do if ((label | 0) == 184) {
   $604 = 0 - $ssize$1$ph$i | 0;
   do if ($545 >>> 0 > $ssize$1$ph$i >>> 0 & ($ssize$1$ph$i >>> 0 < 2147483647 & ($br$0$ph$i | 0) != (-1 | 0))) {
    $608 = HEAP32[876] | 0;
    $612 = $547 - $ssize$1$ph$i + $608 & 0 - $608;
    if ($612 >>> 0 < 2147483647) if ((_sbrk($612 | 0) | 0) == (-1 | 0)) {
     _sbrk($604 | 0) | 0;
     $tsize$0323944$i = $tsize$0$ph$i;
     break L280;
    } else {
     $ssize$2$i = $612 + $ssize$1$ph$i | 0;
     break;
    } else $ssize$2$i = $ssize$1$ph$i;
   } else $ssize$2$i = $ssize$1$ph$i; while (0);
   if (($br$0$ph$i | 0) == (-1 | 0)) $tsize$0323944$i = $tsize$0$ph$i; else {
    $tbase$255$i = $br$0$ph$i;
    $tsize$254$i = $ssize$2$i;
    label = 194;
    break L258;
   }
  } while (0);
  HEAP32[867] = HEAP32[867] | 4;
  $tsize$1$i = $tsize$0323944$i;
  label = 191;
 } else {
  $tsize$1$i = 0;
  label = 191;
 } while (0);
 if ((label | 0) == 191) if ($550 >>> 0 < 2147483647) {
  $621 = _sbrk($550 | 0) | 0;
  $622 = _sbrk(0) | 0;
  if ($621 >>> 0 < $622 >>> 0 & (($621 | 0) != (-1 | 0) & ($622 | 0) != (-1 | 0))) {
   $628 = $622 - $621 | 0;
   $630 = $628 >>> 0 > ($nb$0 + 40 | 0) >>> 0;
   if ($630) {
    $tbase$255$i = $621;
    $tsize$254$i = $630 ? $628 : $tsize$1$i;
    label = 194;
   }
  }
 }
 if ((label | 0) == 194) {
  $632 = (HEAP32[864] | 0) + $tsize$254$i | 0;
  HEAP32[864] = $632;
  if ($632 >>> 0 > (HEAP32[865] | 0) >>> 0) HEAP32[865] = $632;
  $635 = HEAP32[762] | 0;
  L299 : do if (!$635) {
   $637 = HEAP32[760] | 0;
   if (($637 | 0) == 0 | $tbase$255$i >>> 0 < $637 >>> 0) HEAP32[760] = $tbase$255$i;
   HEAP32[868] = $tbase$255$i;
   HEAP32[869] = $tsize$254$i;
   HEAP32[871] = 0;
   HEAP32[765] = HEAP32[874];
   HEAP32[764] = -1;
   $i$02$i$i = 0;
   do {
    $641 = $i$02$i$i << 1;
    $642 = 3064 + ($641 << 2) | 0;
    HEAP32[3064 + ($641 + 3 << 2) >> 2] = $642;
    HEAP32[3064 + ($641 + 2 << 2) >> 2] = $642;
    $i$02$i$i = $i$02$i$i + 1 | 0;
   } while (($i$02$i$i | 0) != 32);
   $648 = $tbase$255$i + 8 | 0;
   $653 = ($648 & 7 | 0) == 0 ? 0 : 0 - $648 & 7;
   $655 = $tsize$254$i + -40 - $653 | 0;
   HEAP32[762] = $tbase$255$i + $653;
   HEAP32[759] = $655;
   HEAP32[$tbase$255$i + ($653 + 4) >> 2] = $655 | 1;
   HEAP32[$tbase$255$i + ($tsize$254$i + -36) >> 2] = 40;
   HEAP32[763] = HEAP32[878];
  } else {
   $sp$084$i = 3472;
   do {
    $660 = HEAP32[$sp$084$i >> 2] | 0;
    $661 = $sp$084$i + 4 | 0;
    $662 = HEAP32[$661 >> 2] | 0;
    if (($tbase$255$i | 0) == ($660 + $662 | 0)) {
     $$lcssa222 = $660;
     $$lcssa224 = $661;
     $$lcssa226 = $662;
     $sp$084$i$lcssa = $sp$084$i;
     label = 204;
     break;
    }
    $sp$084$i = HEAP32[$sp$084$i + 8 >> 2] | 0;
   } while (($sp$084$i | 0) != 0);
   if ((label | 0) == 204) if (!(HEAP32[$sp$084$i$lcssa + 12 >> 2] & 8)) if ($635 >>> 0 < $tbase$255$i >>> 0 & $635 >>> 0 >= $$lcssa222 >>> 0) {
    HEAP32[$$lcssa224 >> 2] = $$lcssa226 + $tsize$254$i;
    $676 = (HEAP32[759] | 0) + $tsize$254$i | 0;
    $678 = $635 + 8 | 0;
    $683 = ($678 & 7 | 0) == 0 ? 0 : 0 - $678 & 7;
    $685 = $676 - $683 | 0;
    HEAP32[762] = $635 + $683;
    HEAP32[759] = $685;
    HEAP32[$635 + ($683 + 4) >> 2] = $685 | 1;
    HEAP32[$635 + ($676 + 4) >> 2] = 40;
    HEAP32[763] = HEAP32[878];
    break;
   }
   $690 = HEAP32[760] | 0;
   if ($tbase$255$i >>> 0 < $690 >>> 0) {
    HEAP32[760] = $tbase$255$i;
    $755 = $tbase$255$i;
   } else $755 = $690;
   $692 = $tbase$255$i + $tsize$254$i | 0;
   $sp$183$i = 3472;
   while (1) {
    if ((HEAP32[$sp$183$i >> 2] | 0) == ($692 | 0)) {
     $$lcssa219 = $sp$183$i;
     $sp$183$i$lcssa = $sp$183$i;
     label = 212;
     break;
    }
    $sp$183$i = HEAP32[$sp$183$i + 8 >> 2] | 0;
    if (!$sp$183$i) {
     $sp$0$i$i$i = 3472;
     break;
    }
   }
   if ((label | 0) == 212) if (!(HEAP32[$sp$183$i$lcssa + 12 >> 2] & 8)) {
    HEAP32[$$lcssa219 >> 2] = $tbase$255$i;
    $702 = $sp$183$i$lcssa + 4 | 0;
    HEAP32[$702 >> 2] = (HEAP32[$702 >> 2] | 0) + $tsize$254$i;
    $706 = $tbase$255$i + 8 | 0;
    $711 = ($706 & 7 | 0) == 0 ? 0 : 0 - $706 & 7;
    $714 = $tbase$255$i + ($tsize$254$i + 8) | 0;
    $719 = ($714 & 7 | 0) == 0 ? 0 : 0 - $714 & 7;
    $720 = $tbase$255$i + ($719 + $tsize$254$i) | 0;
    $$sum$i19$i = $711 + $nb$0 | 0;
    $724 = $tbase$255$i + $$sum$i19$i | 0;
    $725 = $720 - ($tbase$255$i + $711) - $nb$0 | 0;
    HEAP32[$tbase$255$i + ($711 + 4) >> 2] = $nb$0 | 3;
    L324 : do if (($720 | 0) == ($635 | 0)) {
     $730 = (HEAP32[759] | 0) + $725 | 0;
     HEAP32[759] = $730;
     HEAP32[762] = $724;
     HEAP32[$tbase$255$i + ($$sum$i19$i + 4) >> 2] = $730 | 1;
    } else {
     if (($720 | 0) == (HEAP32[761] | 0)) {
      $736 = (HEAP32[758] | 0) + $725 | 0;
      HEAP32[758] = $736;
      HEAP32[761] = $724;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 4) >> 2] = $736 | 1;
      HEAP32[$tbase$255$i + ($736 + $$sum$i19$i) >> 2] = $736;
      break;
     }
     $$sum2$i21$i = $tsize$254$i + 4 | 0;
     $741 = HEAP32[$tbase$255$i + ($$sum2$i21$i + $719) >> 2] | 0;
     if (($741 & 3 | 0) == 1) {
      $744 = $741 & -8;
      $745 = $741 >>> 3;
      L332 : do if ($741 >>> 0 < 256) {
       $748 = HEAP32[$tbase$255$i + (($719 | 8) + $tsize$254$i) >> 2] | 0;
       $750 = HEAP32[$tbase$255$i + ($tsize$254$i + 12 + $719) >> 2] | 0;
       $752 = 3064 + ($745 << 1 << 2) | 0;
       do if (($748 | 0) != ($752 | 0)) {
        if ($748 >>> 0 < $755 >>> 0) _abort();
        if ((HEAP32[$748 + 12 >> 2] | 0) == ($720 | 0)) break;
        _abort();
       } while (0);
       if (($750 | 0) == ($748 | 0)) {
        HEAP32[756] = HEAP32[756] & ~(1 << $745);
        break;
       }
       do if (($750 | 0) == ($752 | 0)) $$pre$phi58$i$iZ2D = $750 + 8 | 0; else {
        if ($750 >>> 0 < $755 >>> 0) _abort();
        $766 = $750 + 8 | 0;
        if ((HEAP32[$766 >> 2] | 0) == ($720 | 0)) {
         $$pre$phi58$i$iZ2D = $766;
         break;
        }
        _abort();
       } while (0);
       HEAP32[$748 + 12 >> 2] = $750;
       HEAP32[$$pre$phi58$i$iZ2D >> 2] = $748;
      } else {
       $771 = HEAP32[$tbase$255$i + (($719 | 24) + $tsize$254$i) >> 2] | 0;
       $773 = HEAP32[$tbase$255$i + ($tsize$254$i + 12 + $719) >> 2] | 0;
       do if (($773 | 0) == ($720 | 0)) {
        $$sum67$i$i = $719 | 16;
        $784 = $tbase$255$i + ($$sum2$i21$i + $$sum67$i$i) | 0;
        $785 = HEAP32[$784 >> 2] | 0;
        if (!$785) {
         $787 = $tbase$255$i + ($$sum67$i$i + $tsize$254$i) | 0;
         $788 = HEAP32[$787 >> 2] | 0;
         if (!$788) {
          $R$1$i$i = 0;
          break;
         } else {
          $R$0$i$i = $788;
          $RP$0$i$i = $787;
         }
        } else {
         $R$0$i$i = $785;
         $RP$0$i$i = $784;
        }
        while (1) {
         $790 = $R$0$i$i + 20 | 0;
         $791 = HEAP32[$790 >> 2] | 0;
         if ($791) {
          $R$0$i$i = $791;
          $RP$0$i$i = $790;
          continue;
         }
         $793 = $R$0$i$i + 16 | 0;
         $794 = HEAP32[$793 >> 2] | 0;
         if (!$794) {
          $R$0$i$i$lcssa = $R$0$i$i;
          $RP$0$i$i$lcssa = $RP$0$i$i;
          break;
         } else {
          $R$0$i$i = $794;
          $RP$0$i$i = $793;
         }
        }
        if ($RP$0$i$i$lcssa >>> 0 < $755 >>> 0) _abort(); else {
         HEAP32[$RP$0$i$i$lcssa >> 2] = 0;
         $R$1$i$i = $R$0$i$i$lcssa;
         break;
        }
       } else {
        $776 = HEAP32[$tbase$255$i + (($719 | 8) + $tsize$254$i) >> 2] | 0;
        if ($776 >>> 0 < $755 >>> 0) _abort();
        $778 = $776 + 12 | 0;
        if ((HEAP32[$778 >> 2] | 0) != ($720 | 0)) _abort();
        $781 = $773 + 8 | 0;
        if ((HEAP32[$781 >> 2] | 0) == ($720 | 0)) {
         HEAP32[$778 >> 2] = $773;
         HEAP32[$781 >> 2] = $776;
         $R$1$i$i = $773;
         break;
        } else _abort();
       } while (0);
       if (!$771) break;
       $799 = HEAP32[$tbase$255$i + ($tsize$254$i + 28 + $719) >> 2] | 0;
       $800 = 3328 + ($799 << 2) | 0;
       do if (($720 | 0) == (HEAP32[$800 >> 2] | 0)) {
        HEAP32[$800 >> 2] = $R$1$i$i;
        if ($R$1$i$i) break;
        HEAP32[757] = HEAP32[757] & ~(1 << $799);
        break L332;
       } else {
        if ($771 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort();
        $809 = $771 + 16 | 0;
        if ((HEAP32[$809 >> 2] | 0) == ($720 | 0)) HEAP32[$809 >> 2] = $R$1$i$i; else HEAP32[$771 + 20 >> 2] = $R$1$i$i;
        if (!$R$1$i$i) break L332;
       } while (0);
       $814 = HEAP32[760] | 0;
       if ($R$1$i$i >>> 0 < $814 >>> 0) _abort();
       HEAP32[$R$1$i$i + 24 >> 2] = $771;
       $$sum3132$i$i = $719 | 16;
       $818 = HEAP32[$tbase$255$i + ($$sum3132$i$i + $tsize$254$i) >> 2] | 0;
       do if ($818) if ($818 >>> 0 < $814 >>> 0) _abort(); else {
        HEAP32[$R$1$i$i + 16 >> 2] = $818;
        HEAP32[$818 + 24 >> 2] = $R$1$i$i;
        break;
       } while (0);
       $824 = HEAP32[$tbase$255$i + ($$sum2$i21$i + $$sum3132$i$i) >> 2] | 0;
       if (!$824) break;
       if ($824 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
        HEAP32[$R$1$i$i + 20 >> 2] = $824;
        HEAP32[$824 + 24 >> 2] = $R$1$i$i;
        break;
       }
      } while (0);
      $oldfirst$0$i$i = $tbase$255$i + (($744 | $719) + $tsize$254$i) | 0;
      $qsize$0$i$i = $744 + $725 | 0;
     } else {
      $oldfirst$0$i$i = $720;
      $qsize$0$i$i = $725;
     }
     $832 = $oldfirst$0$i$i + 4 | 0;
     HEAP32[$832 >> 2] = HEAP32[$832 >> 2] & -2;
     HEAP32[$tbase$255$i + ($$sum$i19$i + 4) >> 2] = $qsize$0$i$i | 1;
     HEAP32[$tbase$255$i + ($qsize$0$i$i + $$sum$i19$i) >> 2] = $qsize$0$i$i;
     $838 = $qsize$0$i$i >>> 3;
     if ($qsize$0$i$i >>> 0 < 256) {
      $840 = $838 << 1;
      $841 = 3064 + ($840 << 2) | 0;
      $842 = HEAP32[756] | 0;
      $843 = 1 << $838;
      do if (!($842 & $843)) {
       HEAP32[756] = $842 | $843;
       $$pre$phi$i23$iZ2D = 3064 + ($840 + 2 << 2) | 0;
       $F4$0$i$i = $841;
      } else {
       $847 = 3064 + ($840 + 2 << 2) | 0;
       $848 = HEAP32[$847 >> 2] | 0;
       if ($848 >>> 0 >= (HEAP32[760] | 0) >>> 0) {
        $$pre$phi$i23$iZ2D = $847;
        $F4$0$i$i = $848;
        break;
       }
       _abort();
      } while (0);
      HEAP32[$$pre$phi$i23$iZ2D >> 2] = $724;
      HEAP32[$F4$0$i$i + 12 >> 2] = $724;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 8) >> 2] = $F4$0$i$i;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 12) >> 2] = $841;
      break;
     }
     $854 = $qsize$0$i$i >>> 8;
     do if (!$854) $I7$0$i$i = 0; else {
      if ($qsize$0$i$i >>> 0 > 16777215) {
       $I7$0$i$i = 31;
       break;
      }
      $859 = ($854 + 1048320 | 0) >>> 16 & 8;
      $860 = $854 << $859;
      $863 = ($860 + 520192 | 0) >>> 16 & 4;
      $865 = $860 << $863;
      $868 = ($865 + 245760 | 0) >>> 16 & 2;
      $873 = 14 - ($863 | $859 | $868) + ($865 << $868 >>> 15) | 0;
      $I7$0$i$i = $qsize$0$i$i >>> ($873 + 7 | 0) & 1 | $873 << 1;
     } while (0);
     $879 = 3328 + ($I7$0$i$i << 2) | 0;
     HEAP32[$tbase$255$i + ($$sum$i19$i + 28) >> 2] = $I7$0$i$i;
     HEAP32[$tbase$255$i + ($$sum$i19$i + 20) >> 2] = 0;
     HEAP32[$tbase$255$i + ($$sum$i19$i + 16) >> 2] = 0;
     $883 = HEAP32[757] | 0;
     $884 = 1 << $I7$0$i$i;
     if (!($883 & $884)) {
      HEAP32[757] = $883 | $884;
      HEAP32[$879 >> 2] = $724;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 24) >> 2] = $879;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 12) >> 2] = $724;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 8) >> 2] = $724;
      break;
     }
     $891 = HEAP32[$879 >> 2] | 0;
     L418 : do if ((HEAP32[$891 + 4 >> 2] & -8 | 0) == ($qsize$0$i$i | 0)) $T$0$lcssa$i25$i = $891; else {
      $K8$051$i$i = $qsize$0$i$i << (($I7$0$i$i | 0) == 31 ? 0 : 25 - ($I7$0$i$i >>> 1) | 0);
      $T$050$i$i = $891;
      while (1) {
       $908 = $T$050$i$i + 16 + ($K8$051$i$i >>> 31 << 2) | 0;
       $903 = HEAP32[$908 >> 2] | 0;
       if (!$903) {
        $$lcssa = $908;
        $T$050$i$i$lcssa = $T$050$i$i;
        break;
       }
       if ((HEAP32[$903 + 4 >> 2] & -8 | 0) == ($qsize$0$i$i | 0)) {
        $T$0$lcssa$i25$i = $903;
        break L418;
       } else {
        $K8$051$i$i = $K8$051$i$i << 1;
        $T$050$i$i = $903;
       }
      }
      if ($$lcssa >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
       HEAP32[$$lcssa >> 2] = $724;
       HEAP32[$tbase$255$i + ($$sum$i19$i + 24) >> 2] = $T$050$i$i$lcssa;
       HEAP32[$tbase$255$i + ($$sum$i19$i + 12) >> 2] = $724;
       HEAP32[$tbase$255$i + ($$sum$i19$i + 8) >> 2] = $724;
       break L324;
      }
     } while (0);
     $915 = $T$0$lcssa$i25$i + 8 | 0;
     $916 = HEAP32[$915 >> 2] | 0;
     $917 = HEAP32[760] | 0;
     if ($916 >>> 0 >= $917 >>> 0 & $T$0$lcssa$i25$i >>> 0 >= $917 >>> 0) {
      HEAP32[$916 + 12 >> 2] = $724;
      HEAP32[$915 >> 2] = $724;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 8) >> 2] = $916;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 12) >> 2] = $T$0$lcssa$i25$i;
      HEAP32[$tbase$255$i + ($$sum$i19$i + 24) >> 2] = 0;
      break;
     } else _abort();
    } while (0);
    $mem$0 = $tbase$255$i + ($711 | 8) | 0;
    return $mem$0 | 0;
   } else $sp$0$i$i$i = 3472;
   while (1) {
    $925 = HEAP32[$sp$0$i$i$i >> 2] | 0;
    if ($925 >>> 0 <= $635 >>> 0) {
     $928 = HEAP32[$sp$0$i$i$i + 4 >> 2] | 0;
     $929 = $925 + $928 | 0;
     if ($929 >>> 0 > $635 >>> 0) {
      $$lcssa215 = $925;
      $$lcssa216 = $928;
      $$lcssa217 = $929;
      break;
     }
    }
    $sp$0$i$i$i = HEAP32[$sp$0$i$i$i + 8 >> 2] | 0;
   }
   $934 = $$lcssa215 + ($$lcssa216 + -39) | 0;
   $940 = $$lcssa215 + ($$lcssa216 + -47 + (($934 & 7 | 0) == 0 ? 0 : 0 - $934 & 7)) | 0;
   $941 = $635 + 16 | 0;
   $943 = $940 >>> 0 < $941 >>> 0 ? $635 : $940;
   $944 = $943 + 8 | 0;
   $947 = $tbase$255$i + 8 | 0;
   $952 = ($947 & 7 | 0) == 0 ? 0 : 0 - $947 & 7;
   $954 = $tsize$254$i + -40 - $952 | 0;
   HEAP32[762] = $tbase$255$i + $952;
   HEAP32[759] = $954;
   HEAP32[$tbase$255$i + ($952 + 4) >> 2] = $954 | 1;
   HEAP32[$tbase$255$i + ($tsize$254$i + -36) >> 2] = 40;
   HEAP32[763] = HEAP32[878];
   $959 = $943 + 4 | 0;
   HEAP32[$959 >> 2] = 27;
   HEAP32[$944 >> 2] = HEAP32[868];
   HEAP32[$944 + 4 >> 2] = HEAP32[869];
   HEAP32[$944 + 8 >> 2] = HEAP32[870];
   HEAP32[$944 + 12 >> 2] = HEAP32[871];
   HEAP32[868] = $tbase$255$i;
   HEAP32[869] = $tsize$254$i;
   HEAP32[871] = 0;
   HEAP32[870] = $944;
   $960 = $943 + 28 | 0;
   HEAP32[$960 >> 2] = 7;
   if (($943 + 32 | 0) >>> 0 < $$lcssa217 >>> 0) {
    $964 = $960;
    do {
     $964$looptemp = $964;
     $964 = $964 + 4 | 0;
     HEAP32[$964 >> 2] = 7;
    } while (($964$looptemp + 8 | 0) >>> 0 < $$lcssa217 >>> 0);
   }
   if (($943 | 0) != ($635 | 0)) {
    $970 = $943 - $635 | 0;
    HEAP32[$959 >> 2] = HEAP32[$959 >> 2] & -2;
    HEAP32[$635 + 4 >> 2] = $970 | 1;
    HEAP32[$943 >> 2] = $970;
    $975 = $970 >>> 3;
    if ($970 >>> 0 < 256) {
     $977 = $975 << 1;
     $978 = 3064 + ($977 << 2) | 0;
     $979 = HEAP32[756] | 0;
     $980 = 1 << $975;
     if (!($979 & $980)) {
      HEAP32[756] = $979 | $980;
      $$pre$phi$i$iZ2D = 3064 + ($977 + 2 << 2) | 0;
      $F$0$i$i = $978;
     } else {
      $984 = 3064 + ($977 + 2 << 2) | 0;
      $985 = HEAP32[$984 >> 2] | 0;
      if ($985 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
       $$pre$phi$i$iZ2D = $984;
       $F$0$i$i = $985;
      }
     }
     HEAP32[$$pre$phi$i$iZ2D >> 2] = $635;
     HEAP32[$F$0$i$i + 12 >> 2] = $635;
     HEAP32[$635 + 8 >> 2] = $F$0$i$i;
     HEAP32[$635 + 12 >> 2] = $978;
     break;
    }
    $991 = $970 >>> 8;
    if (!$991) $I1$0$i$i = 0; else if ($970 >>> 0 > 16777215) $I1$0$i$i = 31; else {
     $996 = ($991 + 1048320 | 0) >>> 16 & 8;
     $997 = $991 << $996;
     $1000 = ($997 + 520192 | 0) >>> 16 & 4;
     $1002 = $997 << $1000;
     $1005 = ($1002 + 245760 | 0) >>> 16 & 2;
     $1010 = 14 - ($1000 | $996 | $1005) + ($1002 << $1005 >>> 15) | 0;
     $I1$0$i$i = $970 >>> ($1010 + 7 | 0) & 1 | $1010 << 1;
    }
    $1016 = 3328 + ($I1$0$i$i << 2) | 0;
    HEAP32[$635 + 28 >> 2] = $I1$0$i$i;
    HEAP32[$635 + 20 >> 2] = 0;
    HEAP32[$941 >> 2] = 0;
    $1019 = HEAP32[757] | 0;
    $1020 = 1 << $I1$0$i$i;
    if (!($1019 & $1020)) {
     HEAP32[757] = $1019 | $1020;
     HEAP32[$1016 >> 2] = $635;
     HEAP32[$635 + 24 >> 2] = $1016;
     HEAP32[$635 + 12 >> 2] = $635;
     HEAP32[$635 + 8 >> 2] = $635;
     break;
    }
    $1027 = HEAP32[$1016 >> 2] | 0;
    L459 : do if ((HEAP32[$1027 + 4 >> 2] & -8 | 0) == ($970 | 0)) $T$0$lcssa$i$i = $1027; else {
     $K2$07$i$i = $970 << (($I1$0$i$i | 0) == 31 ? 0 : 25 - ($I1$0$i$i >>> 1) | 0);
     $T$06$i$i = $1027;
     while (1) {
      $1044 = $T$06$i$i + 16 + ($K2$07$i$i >>> 31 << 2) | 0;
      $1039 = HEAP32[$1044 >> 2] | 0;
      if (!$1039) {
       $$lcssa211 = $1044;
       $T$06$i$i$lcssa = $T$06$i$i;
       break;
      }
      if ((HEAP32[$1039 + 4 >> 2] & -8 | 0) == ($970 | 0)) {
       $T$0$lcssa$i$i = $1039;
       break L459;
      } else {
       $K2$07$i$i = $K2$07$i$i << 1;
       $T$06$i$i = $1039;
      }
     }
     if ($$lcssa211 >>> 0 < (HEAP32[760] | 0) >>> 0) _abort(); else {
      HEAP32[$$lcssa211 >> 2] = $635;
      HEAP32[$635 + 24 >> 2] = $T$06$i$i$lcssa;
      HEAP32[$635 + 12 >> 2] = $635;
      HEAP32[$635 + 8 >> 2] = $635;
      break L299;
     }
    } while (0);
    $1051 = $T$0$lcssa$i$i + 8 | 0;
    $1052 = HEAP32[$1051 >> 2] | 0;
    $1053 = HEAP32[760] | 0;
    if ($1052 >>> 0 >= $1053 >>> 0 & $T$0$lcssa$i$i >>> 0 >= $1053 >>> 0) {
     HEAP32[$1052 + 12 >> 2] = $635;
     HEAP32[$1051 >> 2] = $635;
     HEAP32[$635 + 8 >> 2] = $1052;
     HEAP32[$635 + 12 >> 2] = $T$0$lcssa$i$i;
     HEAP32[$635 + 24 >> 2] = 0;
     break;
    } else _abort();
   }
  } while (0);
  $1060 = HEAP32[759] | 0;
  if ($1060 >>> 0 > $nb$0 >>> 0) {
   $1062 = $1060 - $nb$0 | 0;
   HEAP32[759] = $1062;
   $1063 = HEAP32[762] | 0;
   HEAP32[762] = $1063 + $nb$0;
   HEAP32[$1063 + ($nb$0 + 4) >> 2] = $1062 | 1;
   HEAP32[$1063 + 4 >> 2] = $nb$0 | 3;
   $mem$0 = $1063 + 8 | 0;
   return $mem$0 | 0;
  }
 }
 $1070 = ___errno_location() | 0;
 HEAP32[$1070 >> 2] = 12;
 $mem$0 = 0;
 return $mem$0 | 0;
}

function ___floatscan($f, $prec, $pok) {
 $f = $f | 0;
 $prec = $prec | 0;
 $pok = $pok | 0;
 var $$0 = 0.0, $$0$i27 = 0.0, $$010$i = 0, $$07$i = 0, $$0710$i = 0, $$0711$i = 0, $$09$i = 0, $$1$be$i = 0, $$1$ph$i = 0, $$18$i = 0, $$2$i = 0, $$3$be$i = 0, $$3$lcssa$i = 0, $$3105$i = 0, $$in = 0, $$lcssa = 0, $$lcssa256 = 0, $$lcssa256$lcssa = 0, $$lcssa257 = 0, $$lcssa257$lcssa = 0, $$lcssa263 = 0, $$lcssa264 = 0, $$lcssa265 = 0, $$lcssa275 = 0, $$not$i = 0, $$pre$i = 0, $$pre$i17 = 0, $$pre$phi42$iZ2D = 0.0, $$sink$off0$i = 0, $0 = 0, $1 = 0, $103 = 0, $113 = 0, $115 = 0, $123 = 0, $125 = 0, $132 = 0, $139 = 0, $147 = 0, $15 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $159 = 0, $16 = 0, $160 = 0, $164 = 0, $169 = 0, $171 = 0, $183 = 0.0, $190 = 0, $192 = 0, $2 = 0, $201 = 0, $205 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $223 = 0, $224 = 0, $225 = 0, $235 = 0, $236 = 0, $249 = 0, $251 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $266 = 0, $270 = 0, $272 = 0, $279 = 0, $283 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $295 = 0, $297 = 0, $298 = 0, $299 = 0, $300 = 0, $310 = 0.0, $322 = 0.0, $324 = 0, $330 = 0, $331 = 0, $338 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $350 = 0, $358 = 0, $36 = 0, $360 = 0, $362 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $371 = 0, $376 = 0, $377 = 0, $381 = 0, $39 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $402 = 0, $403 = 0, $412 = 0, $413 = 0, $414 = 0, $42 = 0, $421 = 0, $422 = 0, $427 = 0, $428 = 0, $430 = 0, $431 = 0, $444 = 0, $446 = 0, $452 = 0, $456 = 0, $458 = 0, $464 = 0, $470 = 0, $471 = 0, $472 = 0, $494 = 0, $506 = 0, $510 = 0, $513 = 0, $515 = 0, $516 = 0, $517 = 0, $520 = 0, $521 = 0, $533 = 0, $534 = 0, $535 = 0, $539 = 0, $541 = 0, $543 = 0, $544 = 0, $550 = 0, $552 = 0, $557 = 0, $560 = 0, $564 = 0, $567 = 0, $572 = 0, $576 = 0, $577 = 0, $579 = 0, $583 = 0, $585 = 0, $588 = 0, $589 = 0, $590 = 0, $591 = 0, $594 = 0, $595 = 0, $60 = 0, $604 = 0, $609 = 0, $610 = 0, $617 = 0, $619 = 0.0, $621 = 0, $625 = 0.0, $626 = 0.0, $629 = 0.0, $633 = 0, $636 = 0, $643 = 0.0, $661 = 0.0, $663 = 0, $669 = 0, $67 = 0, $670 = 0, $677 = 0, $680 = 0, $69 = 0, $691 = 0, $694 = 0, $695 = 0, $696 = 0, $697 = 0, $698 = 0, $699 = 0, $700 = 0, $701 = 0, $702 = 0, $703 = 0, $704 = 0, $705 = 0, $706 = 0, $707 = 0, $708 = 0, $709 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $714 = 0, $715 = 0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $720 = 0, $721 = 0, $722 = 0, $723 = 0, $77 = 0, $82 = 0, $9 = 0, $90 = 0, $99 = 0, $a$0$lcssa151$i = 0, $a$085$i = 0, $a$1$i = 0, $a$1$i$lcssa = 0, $a$2$ph38$i = 0, $a$3$i = 0, $a$3$i$lcssa248 = 0, $a$3$i249 = 0, $a$3$ph$i = 0, $a$3$ph157$i = 0, $a$478$i = 0, $a$5$i = 0, $a$5$i$lcssa = 0, $a$5$i$lcssa$lcssa = 0, $bias$0$i = 0.0, $bias$0$i25 = 0.0, $bits$0$ph = 0, $c$0 = 0, $c$0$i = 0, $c$1$lcssa = 0, $c$1$ph$i = 0, $c$179 = 0, $c$2 = 0, $c$2$i = 0, $c$2$lcssa$i = 0, $c$377 = 0, $c$4 = 0, $c$5 = 0, $c$6 = 0, $carry$087$i = 0, $carry1$0$i = 0, $carry1$1$i = 0, $carry1$1$i$lcssa = 0, $carry1$1$i$lcssa$lcssa = 0, $carry3$081$i = 0, $d$0$i = 0, $denormal$0$i = 0, $denormal$2$i = 0, $e2$0$i19 = 0, $e2$0$ph$i = 0, $e2$1$i = 0, $e2$1$i246 = 0, $e2$1$ph$i = 0, $e2$1$ph156$i = 0, $e2$2$i = 0, $e2$3$i = 0, $emin$0$ph = 0, $frac$0$i = 0.0, $frac$1$i = 0.0, $frac$2$i = 0.0, $gotdig$0$i = 0, $gotdig$0$i$lcssa242 = 0, $gotdig$0$i12 = 0, $gotdig$0$i12$lcssa273 = 0, $gotdig$2$i = 0, $gotdig$2$i$lcssa = 0, $gotdig$2$i13 = 0, $gotdig$3$i = 0, $gotdig$3$lcssa$i = 0, $gotdig$3101$i = 0, $gotdig$3101$i$lcssa = 0, $gotdig$4$i = 0, $gotrad$0$i = 0, $gotrad$0$i$lcssa = 0, $gotrad$0$i14 = 0, $gotrad$1$i = 0, $gotrad$1$lcssa$i = 0, $gotrad$1102$i = 0, $gotrad$2$i = 0, $gottail$0$i = 0, $gottail$1$i = 0, $gottail$2$i = 0, $i$0$lcssa = 0, $i$078 = 0, $i$1 = 0, $i$276 = 0, $i$3 = 0, $i$4 = 0, $i$4$lcssa = 0, $j$0$lcssa$i = 0, $j$0104$i = 0, $j$0104$i$lcssa = 0, $j$067$i = 0, $j$068$i = 0, $j$069$i = 0, $j$2$i = 0, $j$394$i = 0, $k$0$lcssa$i = 0, $k$0103$i = 0, $k$0103$i$lcssa = 0, $k$063$i = 0, $k$064$i = 0, $k$065$i = 0, $k$2$i = 0, $k$3$i = 0, $k$486$i = 0, $k$5$i = 0, $k$5$in$i = 0, $k$679$i = 0, $lnz$0$lcssa$i = 0, $lnz$0100$i = 0, $lnz$0100$i$lcssa = 0, $lnz$057$i = 0, $lnz$058$i = 0, $lnz$059$i = 0, $lnz$2$i = 0, $or$cond16$i = 0, $or$cond19$i = 0, $or$cond9$i = 0, $rp$0$lcssa152$i = 0, $rp$084$i = 0, $rp$1$i18 = 0, $rp$1$i18$lcssa = 0, $rp$2$ph36$i = 0, $rp$3$ph$i = 0, $rp$3$ph34$i = 0, $rp$477$i = 0, $rp$5$i = 0, $rp$5$i$lcssa = 0, $rp$5$i$lcssa$lcssa = 0, $scale$0$i = 0.0, $scale$1$i = 0.0, $scale$2$i = 0.0, $sign$0 = 0, $storemerge$i = 0, $sum$i = 0, $x$0$i = 0, $x$0$i$lcssa = 0, $x$1$i = 0, $x$2$i = 0, $x$3$lcssa$i = 0, $x$324$i = 0, $x$4$lcssa$i = 0, $x$419$i = 0, $x$5$i = 0, $x$i = 0, $y$0$i = 0.0, $y$0$i$lcssa = 0.0, $y$1$i = 0.0, $y$1$i24 = 0.0, $y$2$i = 0.0, $y$2$i26 = 0.0, $y$3$i = 0.0, $y$3$lcssa$i = 0.0, $y$320$i = 0.0, $y$4$i = 0.0, $z$0$i = 0, $z$1$i = 0, $z$1$ph37$i = 0, $z$2$i = 0, $z$3$i = 0, $z$3$i$lcssa = 0, $z$3$i$lcssa$lcssa = 0, $z$4$i = 0, $z$5$ph$i = 0, $z$7$1$i = 0, $z$7$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 512 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $x$i = sp;
 switch ($prec | 0) {
 case 0:
  {
   $bits$0$ph = 24;
   $emin$0$ph = -149;
   label = 4;
   break;
  }
 case 1:
  {
   $bits$0$ph = 53;
   $emin$0$ph = -1074;
   label = 4;
   break;
  }
 case 2:
  {
   $bits$0$ph = 53;
   $emin$0$ph = -1074;
   label = 4;
   break;
  }
 default:
  $$0 = 0.0;
 }
 L4 : do if ((label | 0) == 4) {
  $0 = $f + 4 | 0;
  $1 = $f + 100 | 0;
  do {
   $2 = HEAP32[$0 >> 2] | 0;
   if ($2 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
    HEAP32[$0 >> 2] = $2 + 1;
    $9 = HEAPU8[$2 >> 0] | 0;
   } else $9 = ___shgetc($f) | 0;
  } while ((_isspace($9) | 0) != 0);
  $$lcssa275 = $9;
  L13 : do switch ($$lcssa275 | 0) {
  case 43:
  case 45:
   {
    $15 = 1 - ((($$lcssa275 | 0) == 45 & 1) << 1) | 0;
    $16 = HEAP32[$0 >> 2] | 0;
    if ($16 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
     HEAP32[$0 >> 2] = $16 + 1;
     $c$0 = HEAPU8[$16 >> 0] | 0;
     $sign$0 = $15;
     break L13;
    } else {
     $c$0 = ___shgetc($f) | 0;
     $sign$0 = $15;
     break L13;
    }
    break;
   }
  default:
   {
    $c$0 = $$lcssa275;
    $sign$0 = 1;
   }
  } while (0);
  $c$179 = $c$0;
  $i$078 = 0;
  while (1) {
   if (($c$179 | 32 | 0) != (HEAP8[16484 + $i$078 >> 0] | 0)) {
    $c$1$lcssa = $c$179;
    $i$0$lcssa = $i$078;
    break;
   }
   do if ($i$078 >>> 0 < 7) {
    $29 = HEAP32[$0 >> 2] | 0;
    if ($29 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
     HEAP32[$0 >> 2] = $29 + 1;
     $c$2 = HEAPU8[$29 >> 0] | 0;
     break;
    } else {
     $c$2 = ___shgetc($f) | 0;
     break;
    }
   } else $c$2 = $c$179; while (0);
   $36 = $i$078 + 1 | 0;
   if ($36 >>> 0 < 8) {
    $c$179 = $c$2;
    $i$078 = $36;
   } else {
    $c$1$lcssa = $c$2;
    $i$0$lcssa = $36;
    break;
   }
  }
  L29 : do switch ($i$0$lcssa | 0) {
  case 8:
   break;
  case 3:
   {
    label = 23;
    break;
   }
  default:
   {
    $39 = ($pok | 0) != 0;
    if ($39 & $i$0$lcssa >>> 0 > 3) if (($i$0$lcssa | 0) == 8) break L29; else {
     label = 23;
     break L29;
    }
    L34 : do if (!$i$0$lcssa) {
     $c$377 = $c$1$lcssa;
     $i$276 = 0;
     while (1) {
      if (($c$377 | 32 | 0) != (HEAP8[18327 + $i$276 >> 0] | 0)) {
       $c$5 = $c$377;
       $i$3 = $i$276;
       break L34;
      }
      do if ($i$276 >>> 0 < 2) {
       $60 = HEAP32[$0 >> 2] | 0;
       if ($60 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $60 + 1;
        $c$4 = HEAPU8[$60 >> 0] | 0;
        break;
       } else {
        $c$4 = ___shgetc($f) | 0;
        break;
       }
      } else $c$4 = $c$377; while (0);
      $67 = $i$276 + 1 | 0;
      if ($67 >>> 0 < 3) {
       $c$377 = $c$4;
       $i$276 = $67;
      } else {
       $c$5 = $c$4;
       $i$3 = $67;
       break;
      }
     }
    } else {
     $c$5 = $c$1$lcssa;
     $i$3 = $i$0$lcssa;
    } while (0);
    switch ($i$3 | 0) {
    case 3:
     {
      $69 = HEAP32[$0 >> 2] | 0;
      if ($69 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
       HEAP32[$0 >> 2] = $69 + 1;
       $77 = HEAPU8[$69 >> 0] | 0;
      } else $77 = ___shgetc($f) | 0;
      if (($77 | 0) == 40) $i$4 = 1; else {
       if (!(HEAP32[$1 >> 2] | 0)) {
        $$0 = nan;
        break L4;
       }
       HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
       $$0 = nan;
       break L4;
      }
      while (1) {
       $82 = HEAP32[$0 >> 2] | 0;
       if ($82 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $82 + 1;
        $90 = HEAPU8[$82 >> 0] | 0;
       } else $90 = ___shgetc($f) | 0;
       if (!(($90 + -48 | 0) >>> 0 < 10 | ($90 + -65 | 0) >>> 0 < 26)) if (!(($90 | 0) == 95 | ($90 + -97 | 0) >>> 0 < 26)) {
        $$lcssa = $90;
        $i$4$lcssa = $i$4;
        break;
       }
       $i$4 = $i$4 + 1 | 0;
      }
      if (($$lcssa | 0) == 41) {
       $$0 = nan;
       break L4;
      }
      $99 = (HEAP32[$1 >> 2] | 0) == 0;
      if (!$99) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
      if (!$39) {
       $103 = ___errno_location() | 0;
       HEAP32[$103 >> 2] = 22;
       ___shlim($f, 0);
       $$0 = 0.0;
       break L4;
      }
      if (!$i$4$lcssa) {
       $$0 = nan;
       break L4;
      } else $$in = $i$4$lcssa;
      while (1) {
       $$in = $$in + -1 | 0;
       if (!$99) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
       if (!$$in) {
        $$0 = nan;
        break L4;
       }
      }
      break;
     }
    case 0:
     {
      do if (($c$5 | 0) == 48) {
       $115 = HEAP32[$0 >> 2] | 0;
       if ($115 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $115 + 1;
        $123 = HEAPU8[$115 >> 0] | 0;
       } else $123 = ___shgetc($f) | 0;
       if (($123 | 32 | 0) != 120) {
        if (!(HEAP32[$1 >> 2] | 0)) {
         $c$6 = 48;
         break;
        }
        HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
        $c$6 = 48;
        break;
       }
       $125 = HEAP32[$0 >> 2] | 0;
       if ($125 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $125 + 1;
        $c$0$i = HEAPU8[$125 >> 0] | 0;
        $gotdig$0$i = 0;
       } else {
        $c$0$i = ___shgetc($f) | 0;
        $gotdig$0$i = 0;
       }
       L94 : while (1) {
        switch ($c$0$i | 0) {
        case 46:
         {
          $gotdig$0$i$lcssa242 = $gotdig$0$i;
          label = 74;
          break L94;
          break;
         }
        case 48:
         break;
        default:
         {
          $169 = 0;
          $171 = 0;
          $694 = 0;
          $695 = 0;
          $c$2$i = $c$0$i;
          $gotdig$2$i = $gotdig$0$i;
          $gotrad$0$i = 0;
          $gottail$0$i = 0;
          $scale$0$i = 1.0;
          $x$0$i = 0;
          $y$0$i = 0.0;
          break L94;
         }
        }
        $132 = HEAP32[$0 >> 2] | 0;
        if ($132 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
         HEAP32[$0 >> 2] = $132 + 1;
         $c$0$i = HEAPU8[$132 >> 0] | 0;
         $gotdig$0$i = 1;
         continue;
        } else {
         $c$0$i = ___shgetc($f) | 0;
         $gotdig$0$i = 1;
         continue;
        }
       }
       if ((label | 0) == 74) {
        $139 = HEAP32[$0 >> 2] | 0;
        if ($139 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
         HEAP32[$0 >> 2] = $139 + 1;
         $c$1$ph$i = HEAPU8[$139 >> 0] | 0;
        } else $c$1$ph$i = ___shgetc($f) | 0;
        if (($c$1$ph$i | 0) == 48) {
         $154 = 0;
         $155 = 0;
         while (1) {
          $147 = HEAP32[$0 >> 2] | 0;
          if ($147 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
           HEAP32[$0 >> 2] = $147 + 1;
           $159 = HEAPU8[$147 >> 0] | 0;
          } else $159 = ___shgetc($f) | 0;
          $156 = _i64Add($154 | 0, $155 | 0, -1, -1) | 0;
          $157 = tempRet0;
          if (($159 | 0) == 48) {
           $154 = $156;
           $155 = $157;
          } else {
           $169 = 0;
           $171 = 0;
           $694 = $156;
           $695 = $157;
           $c$2$i = $159;
           $gotdig$2$i = 1;
           $gotrad$0$i = 1;
           $gottail$0$i = 0;
           $scale$0$i = 1.0;
           $x$0$i = 0;
           $y$0$i = 0.0;
           break;
          }
         }
        } else {
         $169 = 0;
         $171 = 0;
         $694 = 0;
         $695 = 0;
         $c$2$i = $c$1$ph$i;
         $gotdig$2$i = $gotdig$0$i$lcssa242;
         $gotrad$0$i = 1;
         $gottail$0$i = 0;
         $scale$0$i = 1.0;
         $x$0$i = 0;
         $y$0$i = 0.0;
        }
       }
       while (1) {
        $160 = $c$2$i + -48 | 0;
        $$pre$i = $c$2$i | 32;
        if ($160 >>> 0 < 10) label = 86; else {
         $164 = ($c$2$i | 0) == 46;
         if (!($164 | ($$pre$i + -97 | 0) >>> 0 < 6)) {
          $213 = $171;
          $214 = $694;
          $216 = $169;
          $217 = $695;
          $c$2$lcssa$i = $c$2$i;
          $gotdig$2$i$lcssa = $gotdig$2$i;
          $gotrad$0$i$lcssa = $gotrad$0$i;
          $x$0$i$lcssa = $x$0$i;
          $y$0$i$lcssa = $y$0$i;
          break;
         }
         if ($164) if (!$gotrad$0$i) {
          $696 = $171;
          $697 = $169;
          $698 = $171;
          $699 = $169;
          $gotdig$3$i = $gotdig$2$i;
          $gotrad$1$i = 1;
          $gottail$2$i = $gottail$0$i;
          $scale$2$i = $scale$0$i;
          $x$2$i = $x$0$i;
          $y$2$i = $y$0$i;
         } else {
          $213 = $171;
          $214 = $694;
          $216 = $169;
          $217 = $695;
          $c$2$lcssa$i = 46;
          $gotdig$2$i$lcssa = $gotdig$2$i;
          $gotrad$0$i$lcssa = $gotrad$0$i;
          $x$0$i$lcssa = $x$0$i;
          $y$0$i$lcssa = $y$0$i;
          break;
         } else label = 86;
        }
        if ((label | 0) == 86) {
         label = 0;
         $d$0$i = ($c$2$i | 0) > 57 ? $$pre$i + -87 | 0 : $160;
         do if (($169 | 0) < 0 | ($169 | 0) == 0 & $171 >>> 0 < 8) {
          $gottail$1$i = $gottail$0$i;
          $scale$1$i = $scale$0$i;
          $x$1$i = $d$0$i + ($x$0$i << 4) | 0;
          $y$1$i = $y$0$i;
         } else {
          if (($169 | 0) < 0 | ($169 | 0) == 0 & $171 >>> 0 < 14) {
           $183 = $scale$0$i * .0625;
           $gottail$1$i = $gottail$0$i;
           $scale$1$i = $183;
           $x$1$i = $x$0$i;
           $y$1$i = $y$0$i + $183 * +($d$0$i | 0);
           break;
          }
          if (($gottail$0$i | 0) != 0 | ($d$0$i | 0) == 0) {
           $gottail$1$i = $gottail$0$i;
           $scale$1$i = $scale$0$i;
           $x$1$i = $x$0$i;
           $y$1$i = $y$0$i;
          } else {
           $gottail$1$i = 1;
           $scale$1$i = $scale$0$i;
           $x$1$i = $x$0$i;
           $y$1$i = $y$0$i + $scale$0$i * .5;
          }
         } while (0);
         $190 = _i64Add($171 | 0, $169 | 0, 1, 0) | 0;
         $696 = $694;
         $697 = $695;
         $698 = $190;
         $699 = tempRet0;
         $gotdig$3$i = 1;
         $gotrad$1$i = $gotrad$0$i;
         $gottail$2$i = $gottail$1$i;
         $scale$2$i = $scale$1$i;
         $x$2$i = $x$1$i;
         $y$2$i = $y$1$i;
        }
        $192 = HEAP32[$0 >> 2] | 0;
        if ($192 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
         HEAP32[$0 >> 2] = $192 + 1;
         $169 = $699;
         $171 = $698;
         $694 = $696;
         $695 = $697;
         $c$2$i = HEAPU8[$192 >> 0] | 0;
         $gotdig$2$i = $gotdig$3$i;
         $gotrad$0$i = $gotrad$1$i;
         $gottail$0$i = $gottail$2$i;
         $scale$0$i = $scale$2$i;
         $x$0$i = $x$2$i;
         $y$0$i = $y$2$i;
         continue;
        } else {
         $169 = $699;
         $171 = $698;
         $694 = $696;
         $695 = $697;
         $c$2$i = ___shgetc($f) | 0;
         $gotdig$2$i = $gotdig$3$i;
         $gotrad$0$i = $gotrad$1$i;
         $gottail$0$i = $gottail$2$i;
         $scale$0$i = $scale$2$i;
         $x$0$i = $x$2$i;
         $y$0$i = $y$2$i;
         continue;
        }
       }
       if (!$gotdig$2$i$lcssa) {
        $201 = (HEAP32[$1 >> 2] | 0) == 0;
        if (!$201) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
        if (!$pok) ___shlim($f, 0); else if (!$201) {
         $205 = HEAP32[$0 >> 2] | 0;
         HEAP32[$0 >> 2] = $205 + -1;
         if ($gotrad$0$i$lcssa) HEAP32[$0 >> 2] = $205 + -2;
        }
        $$0 = +($sign$0 | 0) * 0.0;
        break L4;
       }
       $211 = ($gotrad$0$i$lcssa | 0) == 0;
       $212 = $211 ? $213 : $214;
       $215 = $211 ? $216 : $217;
       if (($216 | 0) < 0 | ($216 | 0) == 0 & $213 >>> 0 < 8) {
        $224 = $213;
        $225 = $216;
        $x$324$i = $x$0$i$lcssa;
        while (1) {
         $223 = $x$324$i << 4;
         $224 = _i64Add($224 | 0, $225 | 0, 1, 0) | 0;
         $225 = tempRet0;
         if (!(($225 | 0) < 0 | ($225 | 0) == 0 & $224 >>> 0 < 8)) {
          $x$3$lcssa$i = $223;
          break;
         } else $x$324$i = $223;
        }
       } else $x$3$lcssa$i = $x$0$i$lcssa;
       if (($c$2$lcssa$i | 32 | 0) == 112) {
        $235 = _scanexp($f, $pok) | 0;
        $236 = tempRet0;
        if (($235 | 0) == 0 & ($236 | 0) == -2147483648) {
         if (!$pok) {
          ___shlim($f, 0);
          $$0 = 0.0;
          break L4;
         }
         if (!(HEAP32[$1 >> 2] | 0)) {
          $253 = 0;
          $254 = 0;
         } else {
          HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
          $253 = 0;
          $254 = 0;
         }
        } else {
         $253 = $235;
         $254 = $236;
        }
       } else if (!(HEAP32[$1 >> 2] | 0)) {
        $253 = 0;
        $254 = 0;
       } else {
        HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
        $253 = 0;
        $254 = 0;
       }
       $249 = _bitshift64Shl($212 | 0, $215 | 0, 2) | 0;
       $251 = _i64Add($249 | 0, tempRet0 | 0, -32, -1) | 0;
       $255 = _i64Add($251 | 0, tempRet0 | 0, $253 | 0, $254 | 0) | 0;
       $256 = tempRet0;
       if (!$x$3$lcssa$i) {
        $$0 = +($sign$0 | 0) * 0.0;
        break L4;
       }
       if (($256 | 0) > 0 | ($256 | 0) == 0 & $255 >>> 0 > (0 - $emin$0$ph | 0) >>> 0) {
        $266 = ___errno_location() | 0;
        HEAP32[$266 >> 2] = 34;
        $$0 = +($sign$0 | 0) * 1797693134862315708145274.0e284 * 1797693134862315708145274.0e284;
        break L4;
       }
       $270 = $emin$0$ph + -106 | 0;
       $272 = (($270 | 0) < 0) << 31 >> 31;
       if (($256 | 0) < ($272 | 0) | ($256 | 0) == ($272 | 0) & $255 >>> 0 < $270 >>> 0) {
        $279 = ___errno_location() | 0;
        HEAP32[$279 >> 2] = 34;
        $$0 = +($sign$0 | 0) * 2.2250738585072014e-308 * 2.2250738585072014e-308;
        break L4;
       }
       if (($x$3$lcssa$i | 0) > -1) {
        $288 = $255;
        $289 = $256;
        $x$419$i = $x$3$lcssa$i;
        $y$320$i = $y$0$i$lcssa;
        while (1) {
         $283 = !($y$320$i >= .5);
         $287 = $283 & 1 | $x$419$i << 1;
         $x$5$i = $287 ^ 1;
         $y$4$i = $y$320$i + ($283 ? $y$320$i : $y$320$i + -1.0);
         $290 = _i64Add($288 | 0, $289 | 0, -1, -1) | 0;
         $291 = tempRet0;
         if (($287 | 0) > -1) {
          $288 = $290;
          $289 = $291;
          $x$419$i = $x$5$i;
          $y$320$i = $y$4$i;
         } else {
          $297 = $290;
          $298 = $291;
          $x$4$lcssa$i = $x$5$i;
          $y$3$lcssa$i = $y$4$i;
          break;
         }
        }
       } else {
        $297 = $255;
        $298 = $256;
        $x$4$lcssa$i = $x$3$lcssa$i;
        $y$3$lcssa$i = $y$0$i$lcssa;
       }
       $295 = _i64Subtract(32, 0, $emin$0$ph | 0, (($emin$0$ph | 0) < 0) << 31 >> 31 | 0) | 0;
       $299 = _i64Add($297 | 0, $298 | 0, $295 | 0, tempRet0 | 0) | 0;
       $300 = tempRet0;
       if (0 > ($300 | 0) | 0 == ($300 | 0) & $bits$0$ph >>> 0 > $299 >>> 0) if (($299 | 0) < 0) {
        $$0710$i = 0;
        label = 127;
       } else {
        $$07$i = $299;
        label = 125;
       } else {
        $$07$i = $bits$0$ph;
        label = 125;
       }
       if ((label | 0) == 125) if (($$07$i | 0) < 53) {
        $$0710$i = $$07$i;
        label = 127;
       } else {
        $$0711$i = $$07$i;
        $$pre$phi42$iZ2D = +($sign$0 | 0);
        $bias$0$i = 0.0;
       }
       if ((label | 0) == 127) {
        $310 = +($sign$0 | 0);
        $$0711$i = $$0710$i;
        $$pre$phi42$iZ2D = $310;
        $bias$0$i = +_copysignl(+_scalbn(1.0, 84 - $$0710$i | 0), $310);
       }
       $or$cond9$i = ($x$4$lcssa$i & 1 | 0) == 0 & ($y$3$lcssa$i != 0.0 & ($$0711$i | 0) < 32);
       $322 = $$pre$phi42$iZ2D * ($or$cond9$i ? 0.0 : $y$3$lcssa$i) + ($bias$0$i + $$pre$phi42$iZ2D * +((($or$cond9$i & 1) + $x$4$lcssa$i | 0) >>> 0)) - $bias$0$i;
       if (!($322 != 0.0)) {
        $324 = ___errno_location() | 0;
        HEAP32[$324 >> 2] = 34;
       }
       $$0 = +_scalbnl($322, $297);
       break L4;
      } else $c$6 = $c$5; while (0);
      $sum$i = $emin$0$ph + $bits$0$ph | 0;
      $330 = 0 - $sum$i | 0;
      $$09$i = $c$6;
      $gotdig$0$i12 = 0;
      L184 : while (1) {
       switch ($$09$i | 0) {
       case 46:
        {
         $gotdig$0$i12$lcssa273 = $gotdig$0$i12;
         label = 138;
         break L184;
         break;
        }
       case 48:
        break;
       default:
        {
         $$2$i = $$09$i;
         $700 = 0;
         $701 = 0;
         $gotdig$2$i13 = $gotdig$0$i12;
         $gotrad$0$i14 = 0;
         break L184;
        }
       }
       $331 = HEAP32[$0 >> 2] | 0;
       if ($331 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $331 + 1;
        $$09$i = HEAPU8[$331 >> 0] | 0;
        $gotdig$0$i12 = 1;
        continue;
       } else {
        $$09$i = ___shgetc($f) | 0;
        $gotdig$0$i12 = 1;
        continue;
       }
      }
      if ((label | 0) == 138) {
       $338 = HEAP32[$0 >> 2] | 0;
       if ($338 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
        HEAP32[$0 >> 2] = $338 + 1;
        $$1$ph$i = HEAPU8[$338 >> 0] | 0;
       } else $$1$ph$i = ___shgetc($f) | 0;
       if (($$1$ph$i | 0) == 48) {
        $346 = 0;
        $347 = 0;
        while (1) {
         $348 = _i64Add($346 | 0, $347 | 0, -1, -1) | 0;
         $349 = tempRet0;
         $350 = HEAP32[$0 >> 2] | 0;
         if ($350 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
          HEAP32[$0 >> 2] = $350 + 1;
          $$1$be$i = HEAPU8[$350 >> 0] | 0;
         } else $$1$be$i = ___shgetc($f) | 0;
         if (($$1$be$i | 0) == 48) {
          $346 = $348;
          $347 = $349;
         } else {
          $$2$i = $$1$be$i;
          $700 = $348;
          $701 = $349;
          $gotdig$2$i13 = 1;
          $gotrad$0$i14 = 1;
          break;
         }
        }
       } else {
        $$2$i = $$1$ph$i;
        $700 = 0;
        $701 = 0;
        $gotdig$2$i13 = $gotdig$0$i12$lcssa273;
        $gotrad$0$i14 = 1;
       }
      }
      HEAP32[$x$i >> 2] = 0;
      $358 = $$2$i + -48 | 0;
      $360 = ($$2$i | 0) == 46;
      L203 : do if ($360 | $358 >>> 0 < 10) {
       $362 = $x$i + 496 | 0;
       $$3105$i = $$2$i;
       $365 = 0;
       $366 = 0;
       $702 = $360;
       $703 = $358;
       $704 = $700;
       $705 = $701;
       $gotdig$3101$i = $gotdig$2$i13;
       $gotrad$1102$i = $gotrad$0$i14;
       $j$0104$i = 0;
       $k$0103$i = 0;
       $lnz$0100$i = 0;
       L205 : while (1) {
        do if ($702) if (!$gotrad$1102$i) {
         $706 = $365;
         $707 = $366;
         $708 = $365;
         $709 = $366;
         $gotdig$4$i = $gotdig$3101$i;
         $gotrad$2$i = 1;
         $j$2$i = $j$0104$i;
         $k$2$i = $k$0103$i;
         $lnz$2$i = $lnz$0100$i;
        } else {
         $710 = $704;
         $711 = $705;
         $712 = $365;
         $713 = $366;
         $gotdig$3101$i$lcssa = $gotdig$3101$i;
         $j$0104$i$lcssa = $j$0104$i;
         $k$0103$i$lcssa = $k$0103$i;
         $lnz$0100$i$lcssa = $lnz$0100$i;
         break L205;
        } else {
         $367 = _i64Add($365 | 0, $366 | 0, 1, 0) | 0;
         $368 = tempRet0;
         $369 = ($$3105$i | 0) != 48;
         if (($k$0103$i | 0) >= 125) {
          if (!$369) {
           $706 = $704;
           $707 = $705;
           $708 = $367;
           $709 = $368;
           $gotdig$4$i = $gotdig$3101$i;
           $gotrad$2$i = $gotrad$1102$i;
           $j$2$i = $j$0104$i;
           $k$2$i = $k$0103$i;
           $lnz$2$i = $lnz$0100$i;
           break;
          }
          HEAP32[$362 >> 2] = HEAP32[$362 >> 2] | 1;
          $706 = $704;
          $707 = $705;
          $708 = $367;
          $709 = $368;
          $gotdig$4$i = $gotdig$3101$i;
          $gotrad$2$i = $gotrad$1102$i;
          $j$2$i = $j$0104$i;
          $k$2$i = $k$0103$i;
          $lnz$2$i = $lnz$0100$i;
          break;
         }
         $371 = $x$i + ($k$0103$i << 2) | 0;
         if (!$j$0104$i) $storemerge$i = $703; else $storemerge$i = $$3105$i + -48 + ((HEAP32[$371 >> 2] | 0) * 10 | 0) | 0;
         HEAP32[$371 >> 2] = $storemerge$i;
         $376 = $j$0104$i + 1 | 0;
         $377 = ($376 | 0) == 9;
         $706 = $704;
         $707 = $705;
         $708 = $367;
         $709 = $368;
         $gotdig$4$i = 1;
         $gotrad$2$i = $gotrad$1102$i;
         $j$2$i = $377 ? 0 : $376;
         $k$2$i = ($377 & 1) + $k$0103$i | 0;
         $lnz$2$i = $369 ? $367 : $lnz$0100$i;
        } while (0);
        $381 = HEAP32[$0 >> 2] | 0;
        if ($381 >>> 0 < (HEAP32[$1 >> 2] | 0) >>> 0) {
         HEAP32[$0 >> 2] = $381 + 1;
         $$3$be$i = HEAPU8[$381 >> 0] | 0;
        } else $$3$be$i = ___shgetc($f) | 0;
        $703 = $$3$be$i + -48 | 0;
        $702 = ($$3$be$i | 0) == 46;
        if (!($702 | $703 >>> 0 < 10)) {
         $$3$lcssa$i = $$3$be$i;
         $394 = $708;
         $395 = $706;
         $397 = $709;
         $398 = $707;
         $gotdig$3$lcssa$i = $gotdig$4$i;
         $gotrad$1$lcssa$i = $gotrad$2$i;
         $j$0$lcssa$i = $j$2$i;
         $k$0$lcssa$i = $k$2$i;
         $lnz$0$lcssa$i = $lnz$2$i;
         label = 161;
         break L203;
        } else {
         $$3105$i = $$3$be$i;
         $365 = $708;
         $366 = $709;
         $704 = $706;
         $705 = $707;
         $gotdig$3101$i = $gotdig$4$i;
         $gotrad$1102$i = $gotrad$2$i;
         $j$0104$i = $j$2$i;
         $k$0103$i = $k$2$i;
         $lnz$0100$i = $lnz$2$i;
        }
       }
       $714 = $712;
       $715 = $713;
       $716 = $710;
       $717 = $711;
       $718 = ($gotdig$3101$i$lcssa | 0) != 0;
       $j$069$i = $j$0104$i$lcssa;
       $k$065$i = $k$0103$i$lcssa;
       $lnz$059$i = $lnz$0100$i$lcssa;
       label = 169;
      } else {
       $$3$lcssa$i = $$2$i;
       $394 = 0;
       $395 = $700;
       $397 = 0;
       $398 = $701;
       $gotdig$3$lcssa$i = $gotdig$2$i13;
       $gotrad$1$lcssa$i = $gotrad$0$i14;
       $j$0$lcssa$i = 0;
       $k$0$lcssa$i = 0;
       $lnz$0$lcssa$i = 0;
       label = 161;
      } while (0);
      do if ((label | 0) == 161) {
       $392 = ($gotrad$1$lcssa$i | 0) == 0;
       $393 = $392 ? $394 : $395;
       $396 = $392 ? $397 : $398;
       $399 = ($gotdig$3$lcssa$i | 0) != 0;
       if (!(($$3$lcssa$i | 32 | 0) == 101 & $399)) if (($$3$lcssa$i | 0) > -1) {
        $714 = $394;
        $715 = $397;
        $716 = $393;
        $717 = $396;
        $718 = $399;
        $j$069$i = $j$0$lcssa$i;
        $k$065$i = $k$0$lcssa$i;
        $lnz$059$i = $lnz$0$lcssa$i;
        label = 169;
        break;
       } else {
        $719 = $394;
        $720 = $397;
        $721 = $399;
        $722 = $393;
        $723 = $396;
        $j$068$i = $j$0$lcssa$i;
        $k$064$i = $k$0$lcssa$i;
        $lnz$058$i = $lnz$0$lcssa$i;
        label = 171;
        break;
       }
       $402 = _scanexp($f, $pok) | 0;
       $403 = tempRet0;
       if (($402 | 0) == 0 & ($403 | 0) == -2147483648) {
        if (!$pok) {
         ___shlim($f, 0);
         $$0$i27 = 0.0;
         break;
        }
        if (!(HEAP32[$1 >> 2] | 0)) {
         $412 = 0;
         $413 = 0;
        } else {
         HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
         $412 = 0;
         $413 = 0;
        }
       } else {
        $412 = $402;
        $413 = $403;
       }
       $414 = _i64Add($412 | 0, $413 | 0, $393 | 0, $396 | 0) | 0;
       $427 = $414;
       $428 = $394;
       $430 = tempRet0;
       $431 = $397;
       $j$067$i = $j$0$lcssa$i;
       $k$063$i = $k$0$lcssa$i;
       $lnz$057$i = $lnz$0$lcssa$i;
       label = 173;
      } while (0);
      if ((label | 0) == 169) if (!(HEAP32[$1 >> 2] | 0)) {
       $719 = $714;
       $720 = $715;
       $721 = $718;
       $722 = $716;
       $723 = $717;
       $j$068$i = $j$069$i;
       $k$064$i = $k$065$i;
       $lnz$058$i = $lnz$059$i;
       label = 171;
      } else {
       HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
       if ($718) {
        $427 = $716;
        $428 = $714;
        $430 = $717;
        $431 = $715;
        $j$067$i = $j$069$i;
        $k$063$i = $k$065$i;
        $lnz$057$i = $lnz$059$i;
        label = 173;
       } else label = 172;
      }
      if ((label | 0) == 171) if ($721) {
       $427 = $722;
       $428 = $719;
       $430 = $723;
       $431 = $720;
       $j$067$i = $j$068$i;
       $k$063$i = $k$064$i;
       $lnz$057$i = $lnz$058$i;
       label = 173;
      } else label = 172;
      do if ((label | 0) == 172) {
       $421 = ___errno_location() | 0;
       HEAP32[$421 >> 2] = 22;
       ___shlim($f, 0);
       $$0$i27 = 0.0;
      } else if ((label | 0) == 173) {
       $422 = HEAP32[$x$i >> 2] | 0;
       if (!$422) {
        $$0$i27 = +($sign$0 | 0) * 0.0;
        break;
       }
       if ((($431 | 0) < 0 | ($431 | 0) == 0 & $428 >>> 0 < 10) & (($427 | 0) == ($428 | 0) & ($430 | 0) == ($431 | 0))) if ($bits$0$ph >>> 0 > 30 | ($422 >>> $bits$0$ph | 0) == 0) {
        $$0$i27 = +($sign$0 | 0) * +($422 >>> 0);
        break;
       }
       $444 = ($emin$0$ph | 0) / -2 | 0;
       $446 = (($444 | 0) < 0) << 31 >> 31;
       if (($430 | 0) > ($446 | 0) | ($430 | 0) == ($446 | 0) & $427 >>> 0 > $444 >>> 0) {
        $452 = ___errno_location() | 0;
        HEAP32[$452 >> 2] = 34;
        $$0$i27 = +($sign$0 | 0) * 1797693134862315708145274.0e284 * 1797693134862315708145274.0e284;
        break;
       }
       $456 = $emin$0$ph + -106 | 0;
       $458 = (($456 | 0) < 0) << 31 >> 31;
       if (($430 | 0) < ($458 | 0) | ($430 | 0) == ($458 | 0) & $427 >>> 0 < $456 >>> 0) {
        $464 = ___errno_location() | 0;
        HEAP32[$464 >> 2] = 34;
        $$0$i27 = +($sign$0 | 0) * 2.2250738585072014e-308 * 2.2250738585072014e-308;
        break;
       }
       if (!$j$067$i) $k$3$i = $k$063$i; else {
        if (($j$067$i | 0) < 9) {
         $470 = $x$i + ($k$063$i << 2) | 0;
         $472 = HEAP32[$470 >> 2] | 0;
         $j$394$i = $j$067$i;
         while (1) {
          $471 = $472 * 10 | 0;
          $j$394$i = $j$394$i + 1 | 0;
          if (($j$394$i | 0) == 9) {
           $$lcssa265 = $471;
           break;
          } else $472 = $471;
         }
         HEAP32[$470 >> 2] = $$lcssa265;
        }
        $k$3$i = $k$063$i + 1 | 0;
       }
       if (($lnz$057$i | 0) < 9) if (($lnz$057$i | 0) <= ($427 | 0) & ($427 | 0) < 18) {
        if (($427 | 0) == 9) {
         $$0$i27 = +($sign$0 | 0) * +((HEAP32[$x$i >> 2] | 0) >>> 0);
         break;
        }
        if (($427 | 0) < 9) {
         $$0$i27 = +($sign$0 | 0) * +((HEAP32[$x$i >> 2] | 0) >>> 0) / +(HEAP32[2648 + (8 - $427 << 2) >> 2] | 0);
         break;
        }
        $494 = $bits$0$ph + 27 + (Math_imul($427, -3) | 0) | 0;
        $$pre$i17 = HEAP32[$x$i >> 2] | 0;
        if (($494 | 0) > 30 | ($$pre$i17 >>> $494 | 0) == 0) {
         $$0$i27 = +($sign$0 | 0) * +($$pre$i17 >>> 0) * +(HEAP32[2648 + ($427 + -10 << 2) >> 2] | 0);
         break;
        }
       }
       $506 = ($427 | 0) % 9 | 0;
       if (!$506) {
        $a$2$ph38$i = 0;
        $e2$0$ph$i = 0;
        $rp$2$ph36$i = $427;
        $z$1$ph37$i = $k$3$i;
       } else {
        $510 = ($427 | 0) > -1 ? $506 : $506 + 9 | 0;
        $513 = HEAP32[2648 + (8 - $510 << 2) >> 2] | 0;
        if (!$k$3$i) {
         $a$0$lcssa151$i = 0;
         $rp$0$lcssa152$i = $427;
         $z$0$i = 0;
        } else {
         $515 = 1e9 / ($513 | 0) | 0;
         $a$085$i = 0;
         $carry$087$i = 0;
         $k$486$i = 0;
         $rp$084$i = $427;
         while (1) {
          $516 = $x$i + ($k$486$i << 2) | 0;
          $517 = HEAP32[$516 >> 2] | 0;
          $520 = (($517 >>> 0) / ($513 >>> 0) | 0) + $carry$087$i | 0;
          HEAP32[$516 >> 2] = $520;
          $521 = Math_imul(($517 >>> 0) % ($513 >>> 0) | 0, $515) | 0;
          $or$cond16$i = ($k$486$i | 0) == ($a$085$i | 0) & ($520 | 0) == 0;
          $k$486$i = $k$486$i + 1 | 0;
          $rp$1$i18 = $or$cond16$i ? $rp$084$i + -9 | 0 : $rp$084$i;
          $a$1$i = $or$cond16$i ? $k$486$i & 127 : $a$085$i;
          if (($k$486$i | 0) == ($k$3$i | 0)) {
           $$lcssa264 = $521;
           $a$1$i$lcssa = $a$1$i;
           $rp$1$i18$lcssa = $rp$1$i18;
           break;
          } else {
           $a$085$i = $a$1$i;
           $carry$087$i = $521;
           $rp$084$i = $rp$1$i18;
          }
         }
         if (!$$lcssa264) {
          $a$0$lcssa151$i = $a$1$i$lcssa;
          $rp$0$lcssa152$i = $rp$1$i18$lcssa;
          $z$0$i = $k$3$i;
         } else {
          HEAP32[$x$i + ($k$3$i << 2) >> 2] = $$lcssa264;
          $a$0$lcssa151$i = $a$1$i$lcssa;
          $rp$0$lcssa152$i = $rp$1$i18$lcssa;
          $z$0$i = $k$3$i + 1 | 0;
         }
        }
        $a$2$ph38$i = $a$0$lcssa151$i;
        $e2$0$ph$i = 0;
        $rp$2$ph36$i = 9 - $510 + $rp$0$lcssa152$i | 0;
        $z$1$ph37$i = $z$0$i;
       }
       L284 : while (1) {
        $533 = ($rp$2$ph36$i | 0) < 18;
        $534 = ($rp$2$ph36$i | 0) == 18;
        $535 = $x$i + ($a$2$ph38$i << 2) | 0;
        $e2$0$i19 = $e2$0$ph$i;
        $z$1$i = $z$1$ph37$i;
        while (1) {
         if (!$533) {
          if (!$534) {
           $a$3$ph$i = $a$2$ph38$i;
           $e2$1$ph$i = $e2$0$i19;
           $rp$3$ph34$i = $rp$2$ph36$i;
           $z$5$ph$i = $z$1$i;
           break L284;
          }
          if ((HEAP32[$535 >> 2] | 0) >>> 0 >= 9007199) {
           $a$3$ph$i = $a$2$ph38$i;
           $e2$1$ph$i = $e2$0$i19;
           $rp$3$ph34$i = 18;
           $z$5$ph$i = $z$1$i;
           break L284;
          }
         }
         $carry1$0$i = 0;
         $k$5$in$i = $z$1$i + 127 | 0;
         $z$2$i = $z$1$i;
         while (1) {
          $k$5$i = $k$5$in$i & 127;
          $539 = $x$i + ($k$5$i << 2) | 0;
          $541 = _bitshift64Shl(HEAP32[$539 >> 2] | 0, 0, 29) | 0;
          $543 = _i64Add($541 | 0, tempRet0 | 0, $carry1$0$i | 0, 0) | 0;
          $544 = tempRet0;
          if ($544 >>> 0 > 0 | ($544 | 0) == 0 & $543 >>> 0 > 1e9) {
           $550 = ___udivdi3($543 | 0, $544 | 0, 1e9, 0) | 0;
           $552 = ___uremdi3($543 | 0, $544 | 0, 1e9, 0) | 0;
           $$sink$off0$i = $552;
           $carry1$1$i = $550;
          } else {
           $$sink$off0$i = $543;
           $carry1$1$i = 0;
          }
          HEAP32[$539 >> 2] = $$sink$off0$i;
          $557 = ($k$5$i | 0) == ($a$2$ph38$i | 0);
          $z$3$i = ($k$5$i | 0) != ($z$2$i + 127 & 127 | 0) | $557 ? $z$2$i : ($$sink$off0$i | 0) == 0 ? $k$5$i : $z$2$i;
          if ($557) {
           $carry1$1$i$lcssa = $carry1$1$i;
           $z$3$i$lcssa = $z$3$i;
           break;
          } else {
           $carry1$0$i = $carry1$1$i;
           $k$5$in$i = $k$5$i + -1 | 0;
           $z$2$i = $z$3$i;
          }
         }
         $560 = $e2$0$i19 + -29 | 0;
         if (!$carry1$1$i$lcssa) {
          $e2$0$i19 = $560;
          $z$1$i = $z$3$i$lcssa;
         } else {
          $$lcssa263 = $560;
          $carry1$1$i$lcssa$lcssa = $carry1$1$i$lcssa;
          $z$3$i$lcssa$lcssa = $z$3$i$lcssa;
          break;
         }
        }
        $564 = $a$2$ph38$i + 127 & 127;
        if (($564 | 0) == ($z$3$i$lcssa$lcssa | 0)) {
         $567 = $z$3$i$lcssa$lcssa + 127 & 127;
         $572 = $x$i + (($z$3$i$lcssa$lcssa + 126 & 127) << 2) | 0;
         HEAP32[$572 >> 2] = HEAP32[$572 >> 2] | HEAP32[$x$i + ($567 << 2) >> 2];
         $z$4$i = $567;
        } else $z$4$i = $z$3$i$lcssa$lcssa;
        HEAP32[$x$i + ($564 << 2) >> 2] = $carry1$1$i$lcssa$lcssa;
        $a$2$ph38$i = $564;
        $e2$0$ph$i = $$lcssa263;
        $rp$2$ph36$i = $rp$2$ph36$i + 9 | 0;
        $z$1$ph37$i = $z$4$i;
       }
       L302 : while (1) {
        $604 = $z$5$ph$i + 1 & 127;
        $609 = $x$i + (($z$5$ph$i + 127 & 127) << 2) | 0;
        $a$3$ph157$i = $a$3$ph$i;
        $e2$1$ph156$i = $e2$1$ph$i;
        $rp$3$ph$i = $rp$3$ph34$i;
        while (1) {
         $610 = ($rp$3$ph$i | 0) == 18;
         $$18$i = ($rp$3$ph$i | 0) > 27 ? 9 : 1;
         $$not$i = $610 ^ 1;
         $a$3$i = $a$3$ph157$i;
         $e2$1$i = $e2$1$ph156$i;
         while (1) {
          $576 = $a$3$i & 127;
          $577 = ($576 | 0) == ($z$5$ph$i | 0);
          do if ($577) label = 219; else {
           $579 = HEAP32[$x$i + ($576 << 2) >> 2] | 0;
           if ($579 >>> 0 < 9007199) {
            label = 219;
            break;
           }
           if ($579 >>> 0 > 9007199) break;
           $583 = $a$3$i + 1 & 127;
           if (($583 | 0) == ($z$5$ph$i | 0)) {
            label = 219;
            break;
           }
           $691 = HEAP32[$x$i + ($583 << 2) >> 2] | 0;
           if ($691 >>> 0 < 254740991) {
            label = 219;
            break;
           }
           if (!($691 >>> 0 > 254740991 | $$not$i)) {
            $617 = $576;
            $a$3$i249 = $a$3$i;
            $e2$1$i246 = $e2$1$i;
            $z$7$i = $z$5$ph$i;
            break L302;
           }
          } while (0);
          if ((label | 0) == 219) {
           label = 0;
           if ($610) {
            label = 220;
            break L302;
           }
          }
          $585 = $e2$1$i + $$18$i | 0;
          if (($a$3$i | 0) == ($z$5$ph$i | 0)) {
           $a$3$i = $z$5$ph$i;
           $e2$1$i = $585;
          } else {
           $$lcssa256 = $585;
           $a$3$i$lcssa248 = $a$3$i;
           break;
          }
         }
         $588 = (1 << $$18$i) + -1 | 0;
         $589 = 1e9 >>> $$18$i;
         $a$478$i = $a$3$i$lcssa248;
         $carry3$081$i = 0;
         $k$679$i = $a$3$i$lcssa248;
         $rp$477$i = $rp$3$ph$i;
         while (1) {
          $590 = $x$i + ($k$679$i << 2) | 0;
          $591 = HEAP32[$590 >> 2] | 0;
          $594 = ($591 >>> $$18$i) + $carry3$081$i | 0;
          HEAP32[$590 >> 2] = $594;
          $595 = Math_imul($591 & $588, $589) | 0;
          $or$cond19$i = ($k$679$i | 0) == ($a$478$i | 0) & ($594 | 0) == 0;
          $k$679$i = $k$679$i + 1 & 127;
          $rp$5$i = $or$cond19$i ? $rp$477$i + -9 | 0 : $rp$477$i;
          $a$5$i = $or$cond19$i ? $k$679$i : $a$478$i;
          if (($k$679$i | 0) == ($z$5$ph$i | 0)) {
           $$lcssa257 = $595;
           $a$5$i$lcssa = $a$5$i;
           $rp$5$i$lcssa = $rp$5$i;
           break;
          } else {
           $a$478$i = $a$5$i;
           $carry3$081$i = $595;
           $rp$477$i = $rp$5$i;
          }
         }
         if (!$$lcssa257) {
          $a$3$ph157$i = $a$5$i$lcssa;
          $e2$1$ph156$i = $$lcssa256;
          $rp$3$ph$i = $rp$5$i$lcssa;
          continue;
         }
         if (($604 | 0) != ($a$5$i$lcssa | 0)) {
          $$lcssa256$lcssa = $$lcssa256;
          $$lcssa257$lcssa = $$lcssa257;
          $a$5$i$lcssa$lcssa = $a$5$i$lcssa;
          $rp$5$i$lcssa$lcssa = $rp$5$i$lcssa;
          break;
         }
         HEAP32[$609 >> 2] = HEAP32[$609 >> 2] | 1;
         $a$3$ph157$i = $a$5$i$lcssa;
         $e2$1$ph156$i = $$lcssa256;
         $rp$3$ph$i = $rp$5$i$lcssa;
        }
        HEAP32[$x$i + ($z$5$ph$i << 2) >> 2] = $$lcssa257$lcssa;
        $a$3$ph$i = $a$5$i$lcssa$lcssa;
        $e2$1$ph$i = $$lcssa256$lcssa;
        $rp$3$ph34$i = $rp$5$i$lcssa$lcssa;
        $z$5$ph$i = $604;
       }
       if ((label | 0) == 220) if ($577) {
        HEAP32[$x$i + ($604 + -1 << 2) >> 2] = 0;
        $617 = $z$5$ph$i;
        $a$3$i249 = $a$3$i;
        $e2$1$i246 = $e2$1$i;
        $z$7$i = $604;
       } else {
        $617 = $576;
        $a$3$i249 = $a$3$i;
        $e2$1$i246 = $e2$1$i;
        $z$7$i = $z$5$ph$i;
       }
       $619 = +((HEAP32[$x$i + ($617 << 2) >> 2] | 0) >>> 0);
       $621 = $a$3$i249 + 1 & 127;
       if (($621 | 0) == ($z$7$i | 0)) {
        $680 = $a$3$i249 + 2 & 127;
        HEAP32[$x$i + ($680 + -1 << 2) >> 2] = 0;
        $z$7$1$i = $680;
       } else $z$7$1$i = $z$7$i;
       $643 = +($sign$0 | 0);
       $625 = $643 * ($619 * 1.0e9 + +((HEAP32[$x$i + ($621 << 2) >> 2] | 0) >>> 0));
       $663 = $e2$1$i246 + 53 | 0;
       $669 = $663 - $emin$0$ph | 0;
       $670 = ($669 | 0) < ($bits$0$ph | 0);
       $denormal$0$i = $670 & 1;
       $$010$i = $670 ? (($669 | 0) < 0 ? 0 : $669) : $bits$0$ph;
       if (($$010$i | 0) < 53) {
        $626 = +_copysignl(+_scalbn(1.0, 105 - $$010$i | 0), $625);
        $629 = +_fmodl($625, +_scalbn(1.0, 53 - $$010$i | 0));
        $bias$0$i25 = $626;
        $frac$0$i = $629;
        $y$1$i24 = $626 + ($625 - $629);
       } else {
        $bias$0$i25 = 0.0;
        $frac$0$i = 0.0;
        $y$1$i24 = $625;
       }
       $633 = $a$3$i249 + 2 & 127;
       do if (($633 | 0) == ($z$7$1$i | 0)) $frac$2$i = $frac$0$i; else {
        $636 = HEAP32[$x$i + ($633 << 2) >> 2] | 0;
        do if ($636 >>> 0 < 5e8) {
         if (!$636) if (($a$3$i249 + 3 & 127 | 0) == ($z$7$1$i | 0)) {
          $frac$1$i = $frac$0$i;
          break;
         }
         $frac$1$i = $643 * .25 + $frac$0$i;
        } else {
         if ($636 >>> 0 > 5e8) {
          $frac$1$i = $643 * .75 + $frac$0$i;
          break;
         }
         if (($a$3$i249 + 3 & 127 | 0) == ($z$7$1$i | 0)) {
          $frac$1$i = $643 * .5 + $frac$0$i;
          break;
         } else {
          $frac$1$i = $643 * .75 + $frac$0$i;
          break;
         }
        } while (0);
        if ((53 - $$010$i | 0) <= 1) {
         $frac$2$i = $frac$1$i;
         break;
        }
        if (+_fmodl($frac$1$i, 1.0) != 0.0) {
         $frac$2$i = $frac$1$i;
         break;
        }
        $frac$2$i = $frac$1$i + 1.0;
       } while (0);
       $661 = $y$1$i24 + $frac$2$i - $bias$0$i25;
       do if (($663 & 2147483647 | 0) > (-2 - $sum$i | 0)) {
        if (!(+Math_abs(+$661) >= 9007199254740992.0)) {
         $denormal$2$i = $denormal$0$i;
         $e2$2$i = $e2$1$i246;
         $y$2$i26 = $661;
        } else {
         $denormal$2$i = $670 & ($$010$i | 0) == ($669 | 0) ? 0 : $denormal$0$i;
         $e2$2$i = $e2$1$i246 + 1 | 0;
         $y$2$i26 = $661 * .5;
        }
        if (($e2$2$i + 50 | 0) <= ($330 | 0)) if (!($frac$2$i != 0.0 & ($denormal$2$i | 0) != 0)) {
         $e2$3$i = $e2$2$i;
         $y$3$i = $y$2$i26;
         break;
        }
        $677 = ___errno_location() | 0;
        HEAP32[$677 >> 2] = 34;
        $e2$3$i = $e2$2$i;
        $y$3$i = $y$2$i26;
       } else {
        $e2$3$i = $e2$1$i246;
        $y$3$i = $661;
       } while (0);
       $$0$i27 = +_scalbnl($y$3$i, $e2$3$i);
      } while (0);
      $$0 = $$0$i27;
      break L4;
      break;
     }
    default:
     {
      if (HEAP32[$1 >> 2] | 0) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
      $113 = ___errno_location() | 0;
      HEAP32[$113 >> 2] = 22;
      ___shlim($f, 0);
      $$0 = 0.0;
      break L4;
     }
    }
   }
  } while (0);
  if ((label | 0) == 23) {
   $42 = (HEAP32[$1 >> 2] | 0) == 0;
   if (!$42) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
   if (($pok | 0) != 0 & $i$0$lcssa >>> 0 > 3) {
    $i$1 = $i$0$lcssa;
    do {
     if (!$42) HEAP32[$0 >> 2] = (HEAP32[$0 >> 2] | 0) + -1;
     $i$1 = $i$1 + -1 | 0;
    } while ($i$1 >>> 0 > 3);
   }
  }
  $$0 = +($sign$0 | 0) * inf;
 } while (0);
 STACKTOP = sp;
 return +$$0;
}

function __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0$i = 0, $$0$i$i$i = 0, $$0$i$i$i$i = 0, $$0$i$i$i16$i = 0, $$0$i$i$i23$i = 0, $$0$i$i$i33$i = 0, $$0$i$i$i42$i = 0, $$0$i$i$i52$i = 0, $$0$i10 = 0, $$02 = 0, $$07$i = 0, $$first = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $129 = 0, $13 = 0, $130 = 0, $134 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $144 = 0, $145 = 0, $15 = 0, $153 = 0, $154 = 0, $156 = 0, $16 = 0, $164 = 0, $166 = 0, $167 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $186 = 0, $189 = 0, $192 = 0, $2 = 0, $201 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $211 = 0, $212 = 0, $220 = 0, $221 = 0, $223 = 0, $23 = 0, $231 = 0, $233 = 0, $234 = 0, $247 = 0, $248 = 0, $249 = 0, $250 = 0, $253 = 0, $256 = 0, $259 = 0, $268 = 0, $271 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $281 = 0, $282 = 0, $290 = 0, $291 = 0, $293 = 0, $3 = 0, $30 = 0, $301 = 0, $303 = 0, $304 = 0, $317 = 0, $318 = 0, $319 = 0, $320 = 0, $323 = 0, $326 = 0, $329 = 0, $338 = 0, $34 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $349 = 0, $35 = 0, $351 = 0, $359 = 0, $361 = 0, $362 = 0, $37 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $381 = 0, $384 = 0, $387 = 0, $398 = 0, $4 = 0, $400 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $41 = 0, $410 = 0, $411 = 0, $419 = 0, $420 = 0, $422 = 0, $430 = 0, $432 = 0, $433 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $452 = 0, $455 = 0, $458 = 0, $469 = 0, $474 = 0, $476 = 0, $477 = 0, $478 = 0, $483 = 0, $484 = 0, $489 = 0, $49 = 0, $494 = 0, $497 = 0, $5 = 0, $50 = 0, $500 = 0, $502 = 0, $506 = 0, $507 = 0, $509 = 0, $51 = 0, $510 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0, $526 = 0, $528 = 0, $538 = 0, $539 = 0, $540 = 0, $542 = 0, $544 = 0, $545 = 0, $546 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $56 = 0, $562 = 0, $564 = 0, $574 = 0, $575 = 0, $576 = 0, $577 = 0, $578 = 0, $58 = 0, $588 = 0, $593 = 0, $594 = 0, $597 = 0, $6 = 0, $605 = 0, $606 = 0, $608 = 0, $61 = 0, $612 = 0, $613 = 0, $615 = 0, $62 = 0, $622 = 0, $624 = 0, $632 = 0, $633 = 0, $634 = 0, $635 = 0, $638 = 0, $641 = 0, $644 = 0, $645 = 0, $65 = 0, $651 = 0, $653 = 0, $657 = 0, $659 = 0, $667 = 0, $668 = 0, $669 = 0, $670 = 0, $673 = 0, $675 = 0, $685 = 0, $690 = 0, $692 = 0, $693 = 0, $7 = 0, $701 = 0, $702 = 0, $703 = 0, $704 = 0, $707 = 0, $709 = 0, $719 = 0, $8 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $St$0$off0$i = 0, $__v$i$i51$i = 0, $cv$i = 0, $name$i11 = 0, $name1$i = 0, $name2$i12 = 0, $name3$i = 0, $name4$i = 0, $pop_subs$0$off0$i$ph$lcssa = 0, $pop_subs$0$off0$i$ph136 = 0, $t0$0$i = 0, $t0$0$i13 = 0, $t0$1$i = 0, $t0$2$i$be = 0, $t0$2$i$lcssa = 0, $t0$2$i$ph$be = 0, $t0$2$i$ph135 = 0, $t0$2$i131 = 0, $t0$2$i131$lcssa177 = 0, $t0$2$i131$lcssa178 = 0, $t0$2$i131$lcssa179 = 0, $t0$2$i131184 = 0, $tmp = 0, $tmp3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 304 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $__v$i$i51$i = sp + 276 | 0;
 $cv$i = sp + 264 | 0;
 $name$i11 = sp + 252 | 0;
 $0 = sp + 240 | 0;
 $1 = sp + 224 | 0;
 $2 = sp + 216 | 0;
 $name1$i = sp + 204 | 0;
 $3 = sp + 192 | 0;
 $4 = sp + 176 | 0;
 $5 = sp + 168 | 0;
 $name2$i12 = sp + 156 | 0;
 $6 = sp + 144 | 0;
 $7 = sp + 128 | 0;
 $8 = sp + 124 | 0;
 $name3$i = sp + 112 | 0;
 $9 = sp + 96 | 0;
 $10 = sp + 76 | 0;
 $name4$i = sp + 64 | 0;
 $11 = sp + 48 | 0;
 $12 = sp + 8 | 0;
 $13 = sp;
 $14 = sp + 80 | 0;
 $15 = sp + 60 | 0;
 $tmp = sp + 36 | 0;
 $tmp3 = sp + 24 | 0;
 $16 = $last;
 L1 : do if (($16 - $first | 0) > 1) {
  $$first = (HEAP8[$first >> 0] | 0) == 76 ? $first + 1 | 0 : $first;
  $23 = HEAP8[$$first >> 0] | 0;
  switch ($23 << 24 >> 24 | 0) {
  case 78:
   {
    L44 : do if (($$first | 0) == ($last | 0)) $$07$i = $last; else if ($23 << 24 >> 24 == 78) {
     $28 = __ZN10__cxxabiv112_GLOBAL__N_119parse_cv_qualifiersEPKcS2_Rj($$first + 1 | 0, $last, $cv$i) | 0;
     if (($28 | 0) == ($last | 0)) $$07$i = $$first; else {
      $30 = $db + 52 | 0;
      HEAP32[$30 >> 2] = 0;
      switch (HEAP8[$28 >> 0] | 0) {
      case 82:
       {
        HEAP32[$30 >> 2] = 1;
        $t0$0$i13 = $28 + 1 | 0;
        break;
       }
      case 79:
       {
        HEAP32[$30 >> 2] = 2;
        $t0$0$i13 = $28 + 1 | 0;
        break;
       }
      default:
       $t0$0$i13 = $28;
      }
      $34 = $db + 4 | 0;
      $35 = HEAP32[$34 >> 2] | 0;
      $37 = HEAP32[$db + 8 >> 2] | 0;
      if ($35 >>> 0 < $37 >>> 0) {
       HEAP32[$35 >> 2] = 0;
       HEAP32[$35 + 4 >> 2] = 0;
       HEAP32[$35 + 8 >> 2] = 0;
       HEAP32[$35 + 12 >> 2] = 0;
       HEAP32[$35 + 16 >> 2] = 0;
       HEAP32[$35 + 20 >> 2] = 0;
       HEAP32[$35 >> 2] = 0;
       HEAP32[$35 + 4 >> 2] = 0;
       HEAP32[$35 + 8 >> 2] = 0;
       $41 = $35 + 12 | 0;
       HEAP32[$41 >> 2] = 0;
       HEAP32[$41 + 4 >> 2] = 0;
       HEAP32[$41 + 8 >> 2] = 0;
       HEAP32[$34 >> 2] = (HEAP32[$34 >> 2] | 0) + 24;
      } else {
       $49 = HEAP32[$db >> 2] | 0;
       $50 = $35 - $49 | 0;
       $51 = ($50 | 0) / 24 | 0;
       $52 = $51 + 1 | 0;
       if (($50 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
       $56 = ($37 - $49 | 0) / 24 | 0;
       if ($56 >>> 0 < 1073741823) {
        $58 = $56 << 1;
        $$0$i$i$i$i = $58 >>> 0 < $52 >>> 0 ? $52 : $58;
       } else $$0$i$i$i$i = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($__v$i$i51$i, $$0$i$i$i$i, $51, $db + 12 | 0);
       $61 = $__v$i$i51$i + 8 | 0;
       $62 = HEAP32[$61 >> 2] | 0;
       HEAP32[$62 >> 2] = 0;
       HEAP32[$62 + 4 >> 2] = 0;
       HEAP32[$62 + 8 >> 2] = 0;
       HEAP32[$62 + 12 >> 2] = 0;
       HEAP32[$62 + 16 >> 2] = 0;
       HEAP32[$62 + 20 >> 2] = 0;
       HEAP32[$62 >> 2] = 0;
       HEAP32[$62 + 4 >> 2] = 0;
       HEAP32[$62 + 8 >> 2] = 0;
       $65 = $62 + 12 | 0;
       HEAP32[$65 >> 2] = 0;
       HEAP32[$65 + 4 >> 2] = 0;
       HEAP32[$65 + 8 >> 2] = 0;
       HEAP32[$61 >> 2] = $62 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $__v$i$i51$i);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($__v$i$i51$i);
      }
      if (($16 - $t0$0$i13 | 0) > 1) if ((HEAP8[$t0$0$i13 >> 0] | 0) == 83) if ((HEAP8[$t0$0$i13 + 1 >> 0] | 0) == 116) {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6assignEPKcj((HEAP32[$34 >> 2] | 0) + -24 | 0, 12898, 3);
       $t0$1$i = $t0$0$i13 + 2 | 0;
      } else $t0$1$i = $t0$0$i13; else $t0$1$i = $t0$0$i13; else $t0$1$i = $t0$0$i13;
      if (($t0$1$i | 0) == ($last | 0)) {
       $123 = HEAP32[$34 >> 2] | 0;
       $124 = $123 + -24 | 0;
       $126 = $123;
       while (1) {
        $125 = $126 + -24 | 0;
        HEAP32[$34 >> 2] = $125;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($125);
        $126 = HEAP32[$34 >> 2] | 0;
        if (($126 | 0) == ($124 | 0)) {
         $$07$i = $$first;
         break L44;
        }
       }
      }
      $81 = $name3$i + 8 | 0;
      $82 = $name3$i + 1 | 0;
      $83 = $name3$i + 4 | 0;
      $84 = $db + 12 | 0;
      $85 = $db + 16 | 0;
      $86 = $db + 20 | 0;
      $87 = $db + 24 | 0;
      $88 = $9 + 12 | 0;
      $89 = $9 + 4 | 0;
      $90 = $9 + 8 | 0;
      $91 = $db + 28 | 0;
      $92 = $__v$i$i51$i + 8 | 0;
      $93 = $12 + 12 | 0;
      $94 = $12 + 4 | 0;
      $95 = $12 + 8 | 0;
      $96 = $__v$i$i51$i + 8 | 0;
      $97 = $11 + 8 | 0;
      $98 = $11 + 1 | 0;
      $99 = $11 + 4 | 0;
      $100 = $0 + 8 | 0;
      $101 = $0 + 1 | 0;
      $102 = $0 + 4 | 0;
      $103 = $1 + 12 | 0;
      $104 = $1 + 4 | 0;
      $105 = $1 + 8 | 0;
      $106 = $__v$i$i51$i + 8 | 0;
      $107 = $4 + 12 | 0;
      $108 = $4 + 4 | 0;
      $109 = $4 + 8 | 0;
      $110 = $__v$i$i51$i + 8 | 0;
      $111 = $3 + 8 | 0;
      $112 = $3 + 1 | 0;
      $113 = $3 + 4 | 0;
      $114 = $7 + 12 | 0;
      $115 = $7 + 4 | 0;
      $116 = $7 + 8 | 0;
      $117 = $__v$i$i51$i + 8 | 0;
      $118 = $6 + 8 | 0;
      $119 = $6 + 1 | 0;
      $120 = $6 + 4 | 0;
      $121 = HEAP8[$t0$1$i >> 0] | 0;
      L72 : do if ($121 << 24 >> 24 == 69) {
       $pop_subs$0$off0$i$ph$lcssa = 0;
       $t0$2$i$lcssa = $t0$1$i;
      } else {
       $719 = $121;
       $pop_subs$0$off0$i$ph136 = 0;
       $t0$2$i$ph135 = $t0$1$i;
       L73 : while (1) {
        $129 = $719;
        $t0$2$i131 = $t0$2$i$ph135;
        L75 : while (1) {
         switch ($129 << 24 >> 24 | 0) {
         case 83:
          {
           $t0$2$i131$lcssa177 = $t0$2$i131;
           label = 25;
           break L75;
           break;
          }
         case 84:
          {
           $t0$2$i131$lcssa178 = $t0$2$i131;
           label = 44;
           break L75;
           break;
          }
         case 68:
          {
           $t0$2$i131$lcssa179 = $t0$2$i131;
           label = 61;
           break L75;
           break;
          }
         case 73:
          {
           $338 = __ZN10__cxxabiv112_GLOBAL__N_119parse_template_argsINS0_2DbEEEPKcS4_S4_RT_($t0$2$i131, $last, $db) | 0;
           if (($338 | 0) == ($t0$2$i131 | 0) | ($338 | 0) == ($last | 0)) {
            $$07$i = $$first;
            break L44;
           }
           __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($name3$i, (HEAP32[$34 >> 2] | 0) + -24 | 0);
           $343 = HEAP32[$34 >> 2] | 0;
           $344 = $343 + -24 | 0;
           $346 = $343;
           do {
            $345 = $346 + -24 | 0;
            HEAP32[$34 >> 2] = $345;
            __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($345);
            $346 = HEAP32[$34 >> 2] | 0;
           } while (($346 | 0) != ($344 | 0));
           $349 = HEAP8[$name3$i >> 0] | 0;
           $351 = ($349 & 1) == 0;
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($343 + -48 | 0, $351 ? $82 : HEAP32[$81 >> 2] | 0, $351 ? ($349 & 255) >>> 1 : HEAP32[$83 >> 2] | 0) | 0;
           $359 = (HEAP32[$34 >> 2] | 0) + -24 | 0;
           HEAP32[$10 >> 2] = HEAP32[$84 >> 2];
           __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($9, $359, $10);
           $361 = HEAP32[$86 >> 2] | 0;
           $362 = HEAP32[$87 >> 2] | 0;
           if ($361 >>> 0 < $362 >>> 0) {
            HEAP32[$361 + 12 >> 2] = HEAP32[$88 >> 2];
            HEAP32[$361 >> 2] = HEAP32[$9 >> 2];
            HEAP32[$361 + 4 >> 2] = HEAP32[$89 >> 2];
            HEAP32[$361 + 8 >> 2] = HEAP32[$90 >> 2];
            HEAP32[$90 >> 2] = 0;
            HEAP32[$89 >> 2] = 0;
            HEAP32[$9 >> 2] = 0;
            HEAP32[$86 >> 2] = (HEAP32[$86 >> 2] | 0) + 16;
           } else {
            $375 = HEAP32[$85 >> 2] | 0;
            $376 = $361 - $375 | 0;
            $377 = $376 >> 4;
            $378 = $377 + 1 | 0;
            if (($376 | 0) < -16) {
             label = 86;
             break L73;
            }
            $381 = $362 - $375 | 0;
            if ($381 >> 4 >>> 0 < 1073741823) {
             $384 = $381 >> 3;
             $$0$i$i$i42$i = $384 >>> 0 < $378 >>> 0 ? $378 : $384;
            } else $$0$i$i$i42$i = 2147483647;
            __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i42$i, $377, $91);
            $387 = HEAP32[$92 >> 2] | 0;
            HEAP32[$387 + 12 >> 2] = HEAP32[$88 >> 2];
            HEAP32[$387 >> 2] = HEAP32[$9 >> 2];
            HEAP32[$387 + 4 >> 2] = HEAP32[$89 >> 2];
            HEAP32[$387 + 8 >> 2] = HEAP32[$90 >> 2];
            HEAP32[$90 >> 2] = 0;
            HEAP32[$89 >> 2] = 0;
            HEAP32[$9 >> 2] = 0;
            HEAP32[$92 >> 2] = $387 + 16;
            __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($85, $__v$i$i51$i);
            __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
           }
           __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($9);
           __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($name3$i);
           $t0$2$i$be = $338;
           break;
          }
         case 76:
          {
           $398 = $t0$2$i131 + 1 | 0;
           if (($398 | 0) == ($last | 0)) {
            $$07$i = $$first;
            break L44;
           } else $t0$2$i$be = $398;
           break;
          }
         default:
          {
           $t0$2$i131184 = $t0$2$i131;
           label = 93;
           break L75;
          }
         }
         $129 = HEAP8[$t0$2$i$be >> 0] | 0;
         if ($129 << 24 >> 24 == 69) {
          $pop_subs$0$off0$i$ph$lcssa = $pop_subs$0$off0$i$ph136;
          $t0$2$i$lcssa = $t0$2$i$be;
          break L72;
         } else $t0$2$i131 = $t0$2$i$be;
        }
        L93 : do if ((label | 0) == 25) {
         label = 0;
         $130 = $t0$2$i131$lcssa177 + 1 | 0;
         if (($130 | 0) != ($last | 0)) if ((HEAP8[$130 >> 0] | 0) == 116) {
          $t0$2$i131184 = $t0$2$i131$lcssa177;
          label = 93;
          break;
         }
         $134 = __ZN10__cxxabiv112_GLOBAL__N_118parse_substitutionINS0_2DbEEEPKcS4_S4_RT_($t0$2$i131$lcssa177, $last, $db) | 0;
         if (($134 | 0) == ($t0$2$i131$lcssa177 | 0) | ($134 | 0) == ($last | 0)) {
          $$07$i = $$first;
          break L44;
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($name$i11, (HEAP32[$34 >> 2] | 0) + -24 | 0);
         $139 = HEAP32[$34 >> 2] | 0;
         $140 = $139 + -24 | 0;
         $142 = $139;
         do {
          $141 = $142 + -24 | 0;
          HEAP32[$34 >> 2] = $141;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($141);
          $142 = HEAP32[$34 >> 2] | 0;
         } while (($142 | 0) != ($140 | 0));
         $144 = $139 + -48 | 0;
         $145 = HEAP8[$144 >> 0] | 0;
         if (!($145 & 1)) $153 = ($145 & 255) >>> 1; else $153 = HEAP32[$139 + -44 >> 2] | 0;
         if (!$153) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEaSERKS7_($144, $name$i11); else {
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($0, 12902, $name$i11);
          $154 = HEAP8[$0 >> 0] | 0;
          $156 = ($154 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($144, $156 ? $101 : HEAP32[$100 >> 2] | 0, $156 ? ($154 & 255) >>> 1 : HEAP32[$102 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($0);
          $164 = (HEAP32[$34 >> 2] | 0) + -24 | 0;
          HEAP32[$2 >> 2] = HEAP32[$84 >> 2];
          __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($1, $164, $2);
          $166 = HEAP32[$86 >> 2] | 0;
          $167 = HEAP32[$87 >> 2] | 0;
          if ($166 >>> 0 < $167 >>> 0) {
           HEAP32[$166 + 12 >> 2] = HEAP32[$103 >> 2];
           HEAP32[$166 >> 2] = HEAP32[$1 >> 2];
           HEAP32[$166 + 4 >> 2] = HEAP32[$104 >> 2];
           HEAP32[$166 + 8 >> 2] = HEAP32[$105 >> 2];
           HEAP32[$105 >> 2] = 0;
           HEAP32[$104 >> 2] = 0;
           HEAP32[$1 >> 2] = 0;
           HEAP32[$86 >> 2] = (HEAP32[$86 >> 2] | 0) + 16;
          } else {
           $180 = HEAP32[$85 >> 2] | 0;
           $181 = $166 - $180 | 0;
           $182 = $181 >> 4;
           $183 = $182 + 1 | 0;
           if (($181 | 0) < -16) {
            label = 37;
            break L73;
           }
           $186 = $167 - $180 | 0;
           if ($186 >> 4 >>> 0 < 1073741823) {
            $189 = $186 >> 3;
            $$0$i$i$i16$i = $189 >>> 0 < $183 >>> 0 ? $183 : $189;
           } else $$0$i$i$i16$i = 2147483647;
           __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i16$i, $182, $91);
           $192 = HEAP32[$106 >> 2] | 0;
           HEAP32[$192 + 12 >> 2] = HEAP32[$103 >> 2];
           HEAP32[$192 >> 2] = HEAP32[$1 >> 2];
           HEAP32[$192 + 4 >> 2] = HEAP32[$104 >> 2];
           HEAP32[$192 + 8 >> 2] = HEAP32[$105 >> 2];
           HEAP32[$105 >> 2] = 0;
           HEAP32[$104 >> 2] = 0;
           HEAP32[$1 >> 2] = 0;
           HEAP32[$106 >> 2] = $192 + 16;
           __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($85, $__v$i$i51$i);
           __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
          }
          __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($1);
         }
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($name$i11);
         $t0$2$i$ph$be = $134;
        } else if ((label | 0) == 44) {
         label = 0;
         $201 = __ZN10__cxxabiv112_GLOBAL__N_120parse_template_paramINS0_2DbEEEPKcS4_S4_RT_($t0$2$i131$lcssa178, $last, $db) | 0;
         if (($201 | 0) == ($t0$2$i131$lcssa178 | 0) | ($201 | 0) == ($last | 0)) {
          $$07$i = $$first;
          break L44;
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($name1$i, (HEAP32[$34 >> 2] | 0) + -24 | 0);
         $206 = HEAP32[$34 >> 2] | 0;
         $207 = $206 + -24 | 0;
         $209 = $206;
         do {
          $208 = $209 + -24 | 0;
          HEAP32[$34 >> 2] = $208;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($208);
          $209 = HEAP32[$34 >> 2] | 0;
         } while (($209 | 0) != ($207 | 0));
         $211 = $206 + -48 | 0;
         $212 = HEAP8[$211 >> 0] | 0;
         if (!($212 & 1)) $220 = ($212 & 255) >>> 1; else $220 = HEAP32[$206 + -44 >> 2] | 0;
         if (!$220) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEaSERKS7_($211, $name1$i); else {
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($3, 12902, $name1$i);
          $221 = HEAP8[$3 >> 0] | 0;
          $223 = ($221 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($211, $223 ? $112 : HEAP32[$111 >> 2] | 0, $223 ? ($221 & 255) >>> 1 : HEAP32[$113 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
         }
         $231 = (HEAP32[$34 >> 2] | 0) + -24 | 0;
         HEAP32[$5 >> 2] = HEAP32[$84 >> 2];
         __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($4, $231, $5);
         $233 = HEAP32[$86 >> 2] | 0;
         $234 = HEAP32[$87 >> 2] | 0;
         if ($233 >>> 0 < $234 >>> 0) {
          HEAP32[$233 + 12 >> 2] = HEAP32[$107 >> 2];
          HEAP32[$233 >> 2] = HEAP32[$4 >> 2];
          HEAP32[$233 + 4 >> 2] = HEAP32[$108 >> 2];
          HEAP32[$233 + 8 >> 2] = HEAP32[$109 >> 2];
          HEAP32[$109 >> 2] = 0;
          HEAP32[$108 >> 2] = 0;
          HEAP32[$4 >> 2] = 0;
          HEAP32[$86 >> 2] = (HEAP32[$86 >> 2] | 0) + 16;
         } else {
          $247 = HEAP32[$85 >> 2] | 0;
          $248 = $233 - $247 | 0;
          $249 = $248 >> 4;
          $250 = $249 + 1 | 0;
          if (($248 | 0) < -16) {
           label = 56;
           break L73;
          }
          $253 = $234 - $247 | 0;
          if ($253 >> 4 >>> 0 < 1073741823) {
           $256 = $253 >> 3;
           $$0$i$i$i23$i = $256 >>> 0 < $250 >>> 0 ? $250 : $256;
          } else $$0$i$i$i23$i = 2147483647;
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i23$i, $249, $91);
          $259 = HEAP32[$110 >> 2] | 0;
          HEAP32[$259 + 12 >> 2] = HEAP32[$107 >> 2];
          HEAP32[$259 >> 2] = HEAP32[$4 >> 2];
          HEAP32[$259 + 4 >> 2] = HEAP32[$108 >> 2];
          HEAP32[$259 + 8 >> 2] = HEAP32[$109 >> 2];
          HEAP32[$109 >> 2] = 0;
          HEAP32[$108 >> 2] = 0;
          HEAP32[$4 >> 2] = 0;
          HEAP32[$110 >> 2] = $259 + 16;
          __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($85, $__v$i$i51$i);
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
         }
         __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($4);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($name1$i);
         $t0$2$i$ph$be = $201;
        } else if ((label | 0) == 61) {
         label = 0;
         $268 = $t0$2$i131$lcssa179 + 1 | 0;
         if (($268 | 0) != ($last | 0)) switch (HEAP8[$268 >> 0] | 0) {
         case 84:
         case 116:
          break;
         default:
          {
           $t0$2$i131184 = $t0$2$i131$lcssa179;
           label = 93;
           break L93;
          }
         }
         $271 = __ZN10__cxxabiv112_GLOBAL__N_114parse_decltypeINS0_2DbEEEPKcS4_S4_RT_($t0$2$i131$lcssa179, $last, $db) | 0;
         if (($271 | 0) == ($t0$2$i131$lcssa179 | 0) | ($271 | 0) == ($last | 0)) {
          $$07$i = $$first;
          break L44;
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($name2$i12, (HEAP32[$34 >> 2] | 0) + -24 | 0);
         $276 = HEAP32[$34 >> 2] | 0;
         $277 = $276 + -24 | 0;
         $279 = $276;
         do {
          $278 = $279 + -24 | 0;
          HEAP32[$34 >> 2] = $278;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($278);
          $279 = HEAP32[$34 >> 2] | 0;
         } while (($279 | 0) != ($277 | 0));
         $281 = $276 + -48 | 0;
         $282 = HEAP8[$281 >> 0] | 0;
         if (!($282 & 1)) $290 = ($282 & 255) >>> 1; else $290 = HEAP32[$276 + -44 >> 2] | 0;
         if (!$290) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEaSERKS7_($281, $name2$i12); else {
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($6, 12902, $name2$i12);
          $291 = HEAP8[$6 >> 0] | 0;
          $293 = ($291 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($281, $293 ? $119 : HEAP32[$118 >> 2] | 0, $293 ? ($291 & 255) >>> 1 : HEAP32[$120 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
         }
         $301 = (HEAP32[$34 >> 2] | 0) + -24 | 0;
         HEAP32[$8 >> 2] = HEAP32[$84 >> 2];
         __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($7, $301, $8);
         $303 = HEAP32[$86 >> 2] | 0;
         $304 = HEAP32[$87 >> 2] | 0;
         if ($303 >>> 0 < $304 >>> 0) {
          HEAP32[$303 + 12 >> 2] = HEAP32[$114 >> 2];
          HEAP32[$303 >> 2] = HEAP32[$7 >> 2];
          HEAP32[$303 + 4 >> 2] = HEAP32[$115 >> 2];
          HEAP32[$303 + 8 >> 2] = HEAP32[$116 >> 2];
          HEAP32[$116 >> 2] = 0;
          HEAP32[$115 >> 2] = 0;
          HEAP32[$7 >> 2] = 0;
          HEAP32[$86 >> 2] = (HEAP32[$86 >> 2] | 0) + 16;
         } else {
          $317 = HEAP32[$85 >> 2] | 0;
          $318 = $303 - $317 | 0;
          $319 = $318 >> 4;
          $320 = $319 + 1 | 0;
          if (($318 | 0) < -16) {
           label = 75;
           break L73;
          }
          $323 = $304 - $317 | 0;
          if ($323 >> 4 >>> 0 < 1073741823) {
           $326 = $323 >> 3;
           $$0$i$i$i33$i = $326 >>> 0 < $320 >>> 0 ? $320 : $326;
          } else $$0$i$i$i33$i = 2147483647;
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i33$i, $319, $91);
          $329 = HEAP32[$117 >> 2] | 0;
          HEAP32[$329 + 12 >> 2] = HEAP32[$114 >> 2];
          HEAP32[$329 >> 2] = HEAP32[$7 >> 2];
          HEAP32[$329 + 4 >> 2] = HEAP32[$115 >> 2];
          HEAP32[$329 + 8 >> 2] = HEAP32[$116 >> 2];
          HEAP32[$116 >> 2] = 0;
          HEAP32[$115 >> 2] = 0;
          HEAP32[$7 >> 2] = 0;
          HEAP32[$117 >> 2] = $329 + 16;
          __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($85, $__v$i$i51$i);
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
         }
         __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($7);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($name2$i12);
         $t0$2$i$ph$be = $271;
        } while (0);
        if ((label | 0) == 93) {
         label = 0;
         $400 = __ZN10__cxxabiv112_GLOBAL__N_122parse_unqualified_nameINS0_2DbEEEPKcS4_S4_RT_($t0$2$i131184, $last, $db) | 0;
         if (($400 | 0) == ($t0$2$i131184 | 0) | ($400 | 0) == ($last | 0)) {
          $$07$i = $$first;
          break L44;
         }
         __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($name4$i, (HEAP32[$34 >> 2] | 0) + -24 | 0);
         $405 = HEAP32[$34 >> 2] | 0;
         $406 = $405 + -24 | 0;
         $408 = $405;
         do {
          $407 = $408 + -24 | 0;
          HEAP32[$34 >> 2] = $407;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($407);
          $408 = HEAP32[$34 >> 2] | 0;
         } while (($408 | 0) != ($406 | 0));
         $410 = $405 + -48 | 0;
         $411 = HEAP8[$410 >> 0] | 0;
         if (!($411 & 1)) $419 = ($411 & 255) >>> 1; else $419 = HEAP32[$405 + -44 >> 2] | 0;
         if (!$419) __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEaSERKS7_($410, $name4$i); else {
          __ZNSt3__1plIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEEENS_12basic_stringIT_T0_T1_EEPKS8_RKSB_($11, 12902, $name4$i);
          $420 = HEAP8[$11 >> 0] | 0;
          $422 = ($420 & 1) == 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($410, $422 ? $98 : HEAP32[$97 >> 2] | 0, $422 ? ($420 & 255) >>> 1 : HEAP32[$99 >> 2] | 0) | 0;
          __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($11);
         }
         $430 = (HEAP32[$34 >> 2] | 0) + -24 | 0;
         HEAP32[$13 >> 2] = HEAP32[$84 >> 2];
         __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($12, $430, $13);
         $432 = HEAP32[$86 >> 2] | 0;
         $433 = HEAP32[$87 >> 2] | 0;
         if ($432 >>> 0 < $433 >>> 0) {
          HEAP32[$432 + 12 >> 2] = HEAP32[$93 >> 2];
          HEAP32[$432 >> 2] = HEAP32[$12 >> 2];
          HEAP32[$432 + 4 >> 2] = HEAP32[$94 >> 2];
          HEAP32[$432 + 8 >> 2] = HEAP32[$95 >> 2];
          HEAP32[$95 >> 2] = 0;
          HEAP32[$94 >> 2] = 0;
          HEAP32[$12 >> 2] = 0;
          HEAP32[$86 >> 2] = (HEAP32[$86 >> 2] | 0) + 16;
         } else {
          $446 = HEAP32[$85 >> 2] | 0;
          $447 = $432 - $446 | 0;
          $448 = $447 >> 4;
          $449 = $448 + 1 | 0;
          if (($447 | 0) < -16) {
           label = 105;
           break;
          }
          $452 = $433 - $446 | 0;
          if ($452 >> 4 >>> 0 < 1073741823) {
           $455 = $452 >> 3;
           $$0$i$i$i52$i = $455 >>> 0 < $449 >>> 0 ? $449 : $455;
          } else $$0$i$i$i52$i = 2147483647;
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i52$i, $448, $91);
          $458 = HEAP32[$96 >> 2] | 0;
          HEAP32[$458 + 12 >> 2] = HEAP32[$93 >> 2];
          HEAP32[$458 >> 2] = HEAP32[$12 >> 2];
          HEAP32[$458 + 4 >> 2] = HEAP32[$94 >> 2];
          HEAP32[$458 + 8 >> 2] = HEAP32[$95 >> 2];
          HEAP32[$95 >> 2] = 0;
          HEAP32[$94 >> 2] = 0;
          HEAP32[$12 >> 2] = 0;
          HEAP32[$96 >> 2] = $458 + 16;
          __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($85, $__v$i$i51$i);
          __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
         }
         __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($12);
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($name4$i);
         $t0$2$i$ph$be = $400;
        }
        $719 = HEAP8[$t0$2$i$ph$be >> 0] | 0;
        if ($719 << 24 >> 24 == 69) {
         $pop_subs$0$off0$i$ph$lcssa = 1;
         $t0$2$i$lcssa = $t0$2$i$ph$be;
         break L72;
        } else {
         $pop_subs$0$off0$i$ph136 = 1;
         $t0$2$i$ph135 = $t0$2$i$ph$be;
        }
       }
       if ((label | 0) == 37) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($85); else if ((label | 0) == 56) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($85); else if ((label | 0) == 75) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($85); else if ((label | 0) == 86) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($85); else if ((label | 0) == 105) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($85);
      } while (0);
      $469 = $t0$2$i$lcssa + 1 | 0;
      HEAP32[$db + 48 >> 2] = HEAP32[$cv$i >> 2];
      if ($pop_subs$0$off0$i$ph$lcssa) {
       $474 = HEAP32[$86 >> 2] | 0;
       if ((HEAP32[$db + 16 >> 2] | 0) == ($474 | 0)) $$07$i = $469; else {
        $476 = $474 + -16 | 0;
        $478 = $474;
        do {
         $477 = $478 + -16 | 0;
         HEAP32[$86 >> 2] = $477;
         __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($477);
         $478 = HEAP32[$86 >> 2] | 0;
        } while (($478 | 0) != ($476 | 0));
        $$07$i = $469;
       }
      } else $$07$i = $469;
     }
    } else $$07$i = $$first; while (0);
    $$02 = ($$07$i | 0) == ($$first | 0) ? $first : $$07$i;
    break L1;
    break;
   }
  case 90:
   {
    L199 : do if (($$first | 0) == ($last | 0)) $$0$i10 = $last; else if ($23 << 24 >> 24 == 90) {
     $483 = $$first + 1 | 0;
     $484 = __ZN10__cxxabiv112_GLOBAL__N_114parse_encodingINS0_2DbEEEPKcS4_S4_RT_($483, $last, $db) | 0;
     if (($484 | 0) == ($483 | 0) | ($484 | 0) == ($last | 0)) $$0$i10 = $$first; else if ((HEAP8[$484 >> 0] | 0) == 69) {
      $489 = $484 + 1 | 0;
      if (($489 | 0) == ($last | 0)) $$0$i10 = $$first; else switch (HEAP8[$489 >> 0] | 0) {
      case 115:
       {
        $494 = __ZN10__cxxabiv112_GLOBAL__N_119parse_discriminatorEPKcS2_($484 + 2 | 0, $last) | 0;
        $497 = HEAP32[$db + 4 >> 2] | 0;
        if ((HEAP32[$db >> 2] | 0) == ($497 | 0)) {
         $$0$i10 = $494;
         break L199;
        }
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($497 + -24 | 0, 12905) | 0;
        $$0$i10 = $494;
        break L199;
        break;
       }
      case 100:
       {
        $500 = $484 + 2 | 0;
        if (($500 | 0) == ($last | 0)) {
         $$0$i10 = $$first;
         break L199;
        }
        $502 = __ZN10__cxxabiv112_GLOBAL__N_112parse_numberEPKcS2_($500, $last) | 0;
        if (($502 | 0) == ($last | 0)) {
         $$0$i10 = $$first;
         break L199;
        }
        if ((HEAP8[$502 >> 0] | 0) != 95) {
         $$0$i10 = $$first;
         break L199;
        }
        $506 = $502 + 1 | 0;
        $507 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($506, $last, $db) | 0;
        $509 = $db + 4 | 0;
        $510 = HEAP32[$509 >> 2] | 0;
        if (($507 | 0) == ($506 | 0)) {
         $538 = $510 + -24 | 0;
         $540 = $510;
         while (1) {
          $539 = $540 + -24 | 0;
          HEAP32[$509 >> 2] = $539;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($539);
          $540 = HEAP32[$509 >> 2] | 0;
          if (($540 | 0) == ($538 | 0)) {
           $$0$i10 = $$first;
           break L199;
          }
         }
        }
        if ((($510 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
         $$0$i10 = $$first;
         break L199;
        }
        __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($__v$i$i51$i, $510 + -24 | 0);
        $518 = HEAP32[$509 >> 2] | 0;
        $519 = $518 + -24 | 0;
        $521 = $518;
        do {
         $520 = $521 + -24 | 0;
         HEAP32[$509 >> 2] = $520;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($520);
         $521 = HEAP32[$509 >> 2] | 0;
        } while (($521 | 0) != ($519 | 0));
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($518 + -48 | 0, 12902) | 0;
        $526 = HEAP8[$__v$i$i51$i >> 0] | 0;
        $528 = ($526 & 1) == 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj((HEAP32[$509 >> 2] | 0) + -24 | 0, $528 ? $__v$i$i51$i + 1 | 0 : HEAP32[$__v$i$i51$i + 8 >> 2] | 0, $528 ? ($526 & 255) >>> 1 : HEAP32[$__v$i$i51$i + 4 >> 2] | 0) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($__v$i$i51$i);
        $$0$i10 = $507;
        break L199;
        break;
       }
      default:
       {
        $542 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($489, $last, $db) | 0;
        if (($542 | 0) == ($489 | 0)) {
         $574 = $db + 4 | 0;
         $575 = HEAP32[$574 >> 2] | 0;
         $576 = $575 + -24 | 0;
         $578 = $575;
         while (1) {
          $577 = $578 + -24 | 0;
          HEAP32[$574 >> 2] = $577;
          __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($577);
          $578 = HEAP32[$574 >> 2] | 0;
          if (($578 | 0) == ($576 | 0)) {
           $$0$i10 = $$first;
           break L199;
          }
         }
        }
        $544 = __ZN10__cxxabiv112_GLOBAL__N_119parse_discriminatorEPKcS2_($542, $last) | 0;
        $545 = $db + 4 | 0;
        $546 = HEAP32[$545 >> 2] | 0;
        if ((($546 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
         $$0$i10 = $544;
         break L199;
        }
        __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($cv$i, $546 + -24 | 0);
        $554 = HEAP32[$545 >> 2] | 0;
        $555 = $554 + -24 | 0;
        $557 = $554;
        do {
         $556 = $557 + -24 | 0;
         HEAP32[$545 >> 2] = $556;
         __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($556);
         $557 = HEAP32[$545 >> 2] | 0;
        } while (($557 | 0) != ($555 | 0));
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($554 + -48 | 0, 12902) | 0;
        $562 = HEAP8[$cv$i >> 0] | 0;
        $564 = ($562 & 1) == 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj((HEAP32[$545 >> 2] | 0) + -24 | 0, $564 ? $cv$i + 1 | 0 : HEAP32[$cv$i + 8 >> 2] | 0, $564 ? ($562 & 255) >>> 1 : HEAP32[$cv$i + 4 >> 2] | 0) | 0;
        __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($cv$i);
        $$0$i10 = $544;
        break L199;
       }
      }
     } else $$0$i10 = $$first;
    } else $$0$i10 = $$first; while (0);
    STACKTOP = sp;
    return (($$0$i10 | 0) == ($$first | 0) ? $first : $$0$i10) | 0;
   }
  default:
   {
    do if (($16 - $$first | 0) > 1) {
     if ($23 << 24 >> 24 == 83) if ((HEAP8[$$first + 1 >> 0] | 0) == 116) {
      $588 = $$first + 2 | 0;
      if (($588 | 0) == ($last | 0)) {
       $St$0$off0$i = 0;
       $t0$0$i = $last;
      } else {
       $St$0$off0$i = 0;
       $t0$0$i = (HEAP8[$588 >> 0] | 0) == 76 ? $$first + 3 | 0 : $588;
      }
     } else {
      $St$0$off0$i = 1;
      $t0$0$i = $$first;
     } else {
      $St$0$off0$i = 1;
      $t0$0$i = $$first;
     }
     $593 = __ZN10__cxxabiv112_GLOBAL__N_122parse_unqualified_nameINS0_2DbEEEPKcS4_S4_RT_($t0$0$i, $last, $db) | 0;
     $594 = ($593 | 0) == ($t0$0$i | 0);
     if ($St$0$off0$i | $594) $$0$i = $594 ? $$first : $593; else {
      $597 = HEAP32[$db + 4 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($597 | 0)) break;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($597 + -24 | 0, 0, 12922) | 0;
      $$0$i = $593;
     }
     if (($$0$i | 0) != ($$first | 0)) {
      if (($$0$i | 0) == ($last | 0)) {
       $$02 = $last;
       break L1;
      }
      if ((HEAP8[$$0$i >> 0] | 0) != 73) {
       $$02 = $$0$i;
       break L1;
      }
      $605 = $db + 4 | 0;
      $606 = HEAP32[$605 >> 2] | 0;
      if ((HEAP32[$db >> 2] | 0) == ($606 | 0)) {
       $$02 = $first;
       break L1;
      }
      $608 = $db + 16 | 0;
      HEAP32[$15 >> 2] = HEAP32[$db + 12 >> 2];
      __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEC2EjRKS3_RKS5_($14, $606 + -24 | 0, $15);
      $612 = $db + 20 | 0;
      $613 = HEAP32[$612 >> 2] | 0;
      $615 = HEAP32[$db + 24 >> 2] | 0;
      if ($613 >>> 0 < $615 >>> 0) {
       HEAP32[$613 + 12 >> 2] = HEAP32[$14 + 12 >> 2];
       HEAP32[$613 >> 2] = HEAP32[$14 >> 2];
       $622 = $14 + 4 | 0;
       HEAP32[$613 + 4 >> 2] = HEAP32[$622 >> 2];
       $624 = $14 + 8 | 0;
       HEAP32[$613 + 8 >> 2] = HEAP32[$624 >> 2];
       HEAP32[$624 >> 2] = 0;
       HEAP32[$622 >> 2] = 0;
       HEAP32[$14 >> 2] = 0;
       HEAP32[$612 >> 2] = (HEAP32[$612 >> 2] | 0) + 16;
      } else {
       $632 = HEAP32[$608 >> 2] | 0;
       $633 = $613 - $632 | 0;
       $634 = $633 >> 4;
       $635 = $634 + 1 | 0;
       if (($633 | 0) < -16) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($608);
       $638 = $615 - $632 | 0;
       if ($638 >> 4 >>> 0 < 1073741823) {
        $641 = $638 >> 3;
        $$0$i$i$i = $641 >>> 0 < $635 >>> 0 ? $635 : $641;
       } else $$0$i$i$i = 2147483647;
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEEC2EjjS9_($__v$i$i51$i, $$0$i$i$i, $634, $db + 28 | 0);
       $644 = $__v$i$i51$i + 8 | 0;
       $645 = HEAP32[$644 >> 2] | 0;
       HEAP32[$645 + 12 >> 2] = HEAP32[$14 + 12 >> 2];
       HEAP32[$645 >> 2] = HEAP32[$14 >> 2];
       $651 = $14 + 4 | 0;
       HEAP32[$645 + 4 >> 2] = HEAP32[$651 >> 2];
       $653 = $14 + 8 | 0;
       HEAP32[$645 + 8 >> 2] = HEAP32[$653 >> 2];
       HEAP32[$653 >> 2] = 0;
       HEAP32[$651 >> 2] = 0;
       HEAP32[$14 >> 2] = 0;
       HEAP32[$644 >> 2] = $645 + 16;
       __ZNSt3__16vectorINS0_IN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEEENS4_IS6_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS6_RS7_EE($608, $__v$i$i51$i);
       __ZNSt3__114__split_bufferINS_6vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS3_11short_allocIS4_Lj4096EEEEERNS5_IS7_Lj4096EEEED2Ev($__v$i$i51$i);
      }
      __ZNSt3__113__vector_baseIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEED2Ev($14);
      $657 = __ZN10__cxxabiv112_GLOBAL__N_119parse_template_argsINS0_2DbEEEPKcS4_S4_RT_($$0$i, $last, $db) | 0;
      if (($657 | 0) == ($$0$i | 0)) {
       $$02 = $first;
       break L1;
      }
      $659 = HEAP32[$605 >> 2] | 0;
      if ((($659 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
       $$02 = $first;
       break L1;
      }
      __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($tmp, $659 + -24 | 0);
      $667 = HEAP32[$605 >> 2] | 0;
      $668 = $667 + -24 | 0;
      $670 = $667;
      do {
       $669 = $670 + -24 | 0;
       HEAP32[$605 >> 2] = $669;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($669);
       $670 = HEAP32[$605 >> 2] | 0;
      } while (($670 | 0) != ($668 | 0));
      $673 = HEAP8[$tmp >> 0] | 0;
      $675 = ($673 & 1) == 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($667 + -48 | 0, $675 ? $tmp + 1 | 0 : HEAP32[$tmp + 8 >> 2] | 0, $675 ? ($673 & 255) >>> 1 : HEAP32[$tmp + 4 >> 2] | 0) | 0;
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($tmp);
      $$02 = $657;
      break L1;
     }
    } while (0);
    $685 = __ZN10__cxxabiv112_GLOBAL__N_118parse_substitutionINS0_2DbEEEPKcS4_S4_RT_($$first, $last, $db) | 0;
    if (($685 | 0) == ($$first | 0) | ($685 | 0) == ($last | 0)) {
     $$02 = $first;
     break L1;
    }
    if ((HEAP8[$685 >> 0] | 0) != 73) {
     $$02 = $first;
     break L1;
    }
    $690 = __ZN10__cxxabiv112_GLOBAL__N_119parse_template_argsINS0_2DbEEEPKcS4_S4_RT_($685, $last, $db) | 0;
    if (($690 | 0) == ($685 | 0)) {
     $$02 = $first;
     break L1;
    }
    $692 = $db + 4 | 0;
    $693 = HEAP32[$692 >> 2] | 0;
    if ((($693 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
     $$02 = $first;
     break L1;
    }
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($tmp3, $693 + -24 | 0);
    $701 = HEAP32[$692 >> 2] | 0;
    $702 = $701 + -24 | 0;
    $704 = $701;
    do {
     $703 = $704 + -24 | 0;
     HEAP32[$692 >> 2] = $703;
     __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($703);
     $704 = HEAP32[$692 >> 2] | 0;
    } while (($704 | 0) != ($702 | 0));
    $707 = HEAP8[$tmp3 >> 0] | 0;
    $709 = ($707 & 1) == 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($701 + -48 | 0, $709 ? $tmp3 + 1 | 0 : HEAP32[$tmp3 + 8 >> 2] | 0, $709 ? ($707 & 255) >>> 1 : HEAP32[$tmp3 + 4 >> 2] | 0) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($tmp3);
    $$02 = $690;
    break L1;
   }
  }
 } else $$02 = $first; while (0);
 STACKTOP = sp;
 return $$02 | 0;
}

function _printf_core($f, $fmt, $ap, $nl_arg, $nl_type) {
 $f = $f | 0;
 $fmt = $fmt | 0;
 $ap = $ap | 0;
 $nl_arg = $nl_arg | 0;
 $nl_type = $nl_type | 0;
 var $$0 = 0, $$0$i = 0, $$0$lcssa$i = 0, $$012$i = 0, $$013$i = 0, $$03$i33 = 0, $$07$i = 0.0, $$1$i = 0.0, $$114$i = 0, $$2$i = 0.0, $$20$i = 0.0, $$21$i = 0, $$210$i = 0, $$23$i = 0, $$3$i = 0.0, $$31$i = 0, $$311$i = 0, $$4$i = 0.0, $$412$lcssa$i = 0, $$41276$i = 0, $$5$lcssa$i = 0, $$51 = 0, $$587$i = 0, $$a$3$i = 0, $$a$3186$i = 0, $$fl$4 = 0, $$lcssa = 0, $$lcssa159$i = 0, $$lcssa318 = 0, $$lcssa323 = 0, $$lcssa324 = 0, $$lcssa325 = 0, $$lcssa326 = 0, $$lcssa327 = 0, $$lcssa329 = 0, $$lcssa339 = 0, $$lcssa342 = 0.0, $$lcssa344 = 0, $$p$$i = 0, $$p$5 = 0, $$p$i = 0, $$pn$i = 0, $$pr$i = 0, $$pr47$i = 0, $$pre$phi184$iZ2D = 0, $$pre182$i = 0, $$z$4$i = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $106 = 0, $107 = 0, $109 = 0, $11 = 0, $12 = 0, $13 = 0, $133 = 0, $134 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $144 = 0, $146 = 0, $148 = 0, $149 = 0, $15 = 0, $154 = 0, $157 = 0, $162 = 0, $163 = 0, $168 = 0, $175 = 0, $176 = 0, $187 = 0, $19 = 0, $199 = 0, $2 = 0, $206 = 0, $208 = 0, $21 = 0, $211 = 0, $212 = 0, $217 = 0, $223 = 0, $224 = 0, $23 = 0, $230 = 0, $24 = 0, $243 = 0, $245 = 0, $248 = 0, $253 = 0, $256 = 0, $257 = 0, $267 = 0, $269 = 0, $271 = 0, $274 = 0, $276 = 0, $277 = 0, $278 = 0, $28 = 0, $284 = 0, $286 = 0, $287 = 0, $29 = 0, $291 = 0, $299 = 0, $3 = 0, $305 = 0, $314 = 0, $317 = 0, $320 = 0, $321 = 0, $334 = 0, $336 = 0, $34 = 0, $341 = 0, $346 = 0, $349 = 0, $359 = 0.0, $366 = 0, $370 = 0, $377 = 0, $379 = 0, $381 = 0, $382 = 0, $386 = 0, $39 = 0, $392 = 0.0, $393 = 0, $396 = 0, $398 = 0, $4 = 0, $40 = 0, $401 = 0, $403 = 0, $407 = 0.0, $417 = 0, $420 = 0, $423 = 0, $432 = 0, $434 = 0, $435 = 0, $44 = 0, $441 = 0, $459 = 0, $46 = 0, $464 = 0, $469 = 0, $47 = 0, $479 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $491 = 0, $492 = 0, $495 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $501 = 0, $505 = 0, $507 = 0, $51 = 0, $511 = 0, $516 = 0, $517 = 0, $518 = 0, $519 = 0, $521 = 0, $527 = 0, $528 = 0, $529 = 0, $533 = 0, $541 = 0, $555 = 0, $556 = 0, $559 = 0, $56 = 0, $564 = 0, $565 = 0, $567 = 0, $574 = 0, $575 = 0, $576 = 0, $579 = 0, $580 = 0, $581 = 0, $588 = 0, $59 = 0, $598 = 0, $6 = 0, $60 = 0, $601 = 0, $603 = 0, $605 = 0, $607 = 0, $61 = 0, $612 = 0, $613 = 0, $616 = 0, $618 = 0, $620 = 0, $622 = 0, $633 = 0, $636 = 0, $641 = 0, $650 = 0, $651 = 0, $655 = 0, $658 = 0, $66 = 0, $660 = 0, $662 = 0, $666 = 0, $669 = 0, $67 = 0, $673 = 0, $683 = 0, $688 = 0, $695 = 0, $698 = 0, $7 = 0, $706 = 0, $716 = 0, $718 = 0, $726 = 0, $733 = 0, $735 = 0, $739 = 0, $741 = 0, $750 = 0, $756 = 0, $771 = 0, $773 = 0, $786 = 0, $8 = 0, $9 = 0, $91 = 0, $92 = 0, $98 = 0, $99 = 0, $a$0 = 0, $a$1 = 0, $a$1$lcssa$i = 0, $a$1147$i = 0, $a$2 = 0, $a$2$ph$i = 0, $a$3$lcssa$i = 0, $a$3134$i = 0, $a$5$lcssa$i = 0, $a$5109$i = 0, $a$6$i = 0, $a$7$i = 0, $a$8$ph$i = 0, $arg = 0, $argpos$0 = 0, $big$i = 0, $buf = 0, $buf$i = 0, $carry$0140$i = 0, $carry3$0128$i = 0, $cnt$0 = 0, $cnt$1 = 0, $cnt$1$lcssa = 0, $d$0139$i = 0, $d$0141$i = 0, $d$1127$i = 0, $d$2$lcssa$i = 0, $d$2108$i = 0, $d$3$i = 0, $d$482$i = 0, $d$575$i = 0, $d$686$i = 0, $e$0123$i = 0, $e$1$i = 0, $e$2104$i = 0, $e$3$i = 0, $e$4$ph$i = 0, $e2$i = 0, $ebuf0$i = 0, $estr$0$i = 0, $estr$1$lcssa$i = 0, $estr$193$i = 0, $estr$2$i = 0, $fl$0109 = 0, $fl$062 = 0, $fl$1 = 0, $fl$1$ = 0, $fl$3 = 0, $fl$4 = 0, $fl$6 = 0, $fmt39$lcssa = 0, $fmt39101 = 0, $fmt40 = 0, $fmt41 = 0, $fmt42 = 0, $fmt44 = 0, $fmt44$lcssa321 = 0, $fmt45 = 0, $i$0$lcssa = 0, $i$0$lcssa200 = 0, $i$0114 = 0, $i$0122$i = 0, $i$03$i = 0, $i$03$i25 = 0, $i$1$lcssa$i = 0, $i$1116$i = 0, $i$1125 = 0, $i$2100 = 0, $i$2100$lcssa = 0, $i$2103$i = 0, $i$398 = 0, $i$399$i = 0, $isdigittmp = 0, $isdigittmp1$i = 0, $isdigittmp1$i22 = 0, $isdigittmp11 = 0, $isdigittmp4$i = 0, $isdigittmp4$i24 = 0, $isdigittmp9 = 0, $j$0115$i = 0, $j$0117$i = 0, $j$1100$i = 0, $j$2$i = 0, $l$0 = 0, $l$0$i = 0, $l$1113 = 0, $l$2 = 0, $l10n$0 = 0, $l10n$0$lcssa = 0, $l10n$1 = 0, $l10n$2 = 0, $l10n$3 = 0, $mb = 0, $notrhs$i = 0, $p$0 = 0, $p$1 = 0, $p$2 = 0, $p$4198 = 0, $p$5 = 0, $pl$0 = 0, $pl$0$i = 0, $pl$1 = 0, $pl$1$i = 0, $pl$2 = 0, $prefix$0 = 0, $prefix$0$$i = 0, $prefix$0$i = 0, $prefix$1 = 0, $prefix$2 = 0, $r$0$a$8$i = 0, $re$169$i = 0, $round$068$i = 0.0, $round6$1$i = 0.0, $s$0$i = 0, $s$1$i = 0, $s$1$i$lcssa = 0, $s7$079$i = 0, $s7$1$i = 0, $s8$0$lcssa$i = 0, $s8$070$i = 0, $s9$0$i = 0, $s9$183$i = 0, $s9$2$i = 0, $small$0$i = 0.0, $small$1$i = 0.0, $st$0 = 0, $st$0$lcssa322 = 0, $storemerge = 0, $storemerge13 = 0, $storemerge8108 = 0, $storemerge860 = 0, $t$0 = 0, $t$1 = 0, $w$0 = 0, $w$1 = 0, $w$2 = 0, $wc = 0, $ws$0115 = 0, $ws$1126 = 0, $z$0$i = 0, $z$0$lcssa = 0, $z$0102 = 0, $z$1$lcssa$i = 0, $z$1146$i = 0, $z$2 = 0, $z$2$i = 0, $z$2$i$lcssa = 0, $z$3$lcssa$i = 0, $z$3133$i = 0, $z$4$i = 0, $z$6$$i = 0, $z$6$i = 0, $z$6$i$lcssa = 0, $z$6$ph$i = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 624 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $big$i = sp + 24 | 0;
 $e2$i = sp + 16 | 0;
 $buf$i = sp + 588 | 0;
 $ebuf0$i = sp + 576 | 0;
 $arg = sp;
 $buf = sp + 536 | 0;
 $wc = sp + 8 | 0;
 $mb = sp + 528 | 0;
 $0 = ($f | 0) != 0;
 $1 = $buf + 40 | 0;
 $2 = $1;
 $3 = $buf + 39 | 0;
 $4 = $wc + 4 | 0;
 $5 = $ebuf0$i + 12 | 0;
 $6 = $ebuf0$i + 11 | 0;
 $7 = $buf$i;
 $8 = $5;
 $9 = $8 - $7 | 0;
 $10 = -2 - $7 | 0;
 $11 = $8 + 2 | 0;
 $12 = $big$i + 288 | 0;
 $13 = $buf$i + 9 | 0;
 $14 = $13;
 $15 = $buf$i + 8 | 0;
 $cnt$0 = 0;
 $fmt41 = $fmt;
 $l$0 = 0;
 $l10n$0 = 0;
 L1 : while (1) {
  do if (($cnt$0 | 0) > -1) if (($l$0 | 0) > (2147483647 - $cnt$0 | 0)) {
   $19 = ___errno_location() | 0;
   HEAP32[$19 >> 2] = 75;
   $cnt$1 = -1;
   break;
  } else {
   $cnt$1 = $l$0 + $cnt$0 | 0;
   break;
  } else $cnt$1 = $cnt$0; while (0);
  $21 = HEAP8[$fmt41 >> 0] | 0;
  if (!($21 << 24 >> 24)) {
   $cnt$1$lcssa = $cnt$1;
   $l10n$0$lcssa = $l10n$0;
   label = 245;
   break;
  } else {
   $23 = $21;
   $fmt40 = $fmt41;
  }
  L9 : while (1) {
   switch ($23 << 24 >> 24) {
   case 37:
    {
     $fmt39101 = $fmt40;
     $z$0102 = $fmt40;
     label = 9;
     break L9;
     break;
    }
   case 0:
    {
     $fmt39$lcssa = $fmt40;
     $z$0$lcssa = $fmt40;
     break L9;
     break;
    }
   default:
    {}
   }
   $24 = $fmt40 + 1 | 0;
   $23 = HEAP8[$24 >> 0] | 0;
   $fmt40 = $24;
  }
  L12 : do if ((label | 0) == 9) while (1) {
   label = 0;
   if ((HEAP8[$fmt39101 + 1 >> 0] | 0) != 37) {
    $fmt39$lcssa = $fmt39101;
    $z$0$lcssa = $z$0102;
    break L12;
   }
   $28 = $z$0102 + 1 | 0;
   $29 = $fmt39101 + 2 | 0;
   if ((HEAP8[$29 >> 0] | 0) == 37) {
    $fmt39101 = $29;
    $z$0102 = $28;
    label = 9;
   } else {
    $fmt39$lcssa = $29;
    $z$0$lcssa = $28;
    break;
   }
  } while (0);
  $34 = $z$0$lcssa - $fmt41 | 0;
  if ($0) if (!(HEAP32[$f >> 2] & 32)) ___fwritex($fmt41, $34, $f) | 0;
  if (($z$0$lcssa | 0) != ($fmt41 | 0)) {
   $cnt$0 = $cnt$1;
   $fmt41 = $fmt39$lcssa;
   $l$0 = $34;
   continue;
  }
  $39 = $fmt39$lcssa + 1 | 0;
  $40 = HEAP8[$39 >> 0] | 0;
  $isdigittmp = ($40 << 24 >> 24) + -48 | 0;
  if ($isdigittmp >>> 0 < 10) {
   $44 = (HEAP8[$fmt39$lcssa + 2 >> 0] | 0) == 36;
   $$51 = $44 ? $fmt39$lcssa + 3 | 0 : $39;
   $47 = HEAP8[$$51 >> 0] | 0;
   $argpos$0 = $44 ? $isdigittmp : -1;
   $l10n$1 = $44 ? 1 : $l10n$0;
   $storemerge = $$51;
  } else {
   $47 = $40;
   $argpos$0 = -1;
   $l10n$1 = $l10n$0;
   $storemerge = $39;
  }
  $46 = $47 << 24 >> 24;
  L25 : do if (($46 & -32 | 0) == 32) {
   $51 = $46;
   $56 = $47;
   $fl$0109 = 0;
   $storemerge8108 = $storemerge;
   while (1) {
    if (!(1 << $51 + -32 & 75913)) {
     $66 = $56;
     $fl$062 = $fl$0109;
     $storemerge860 = $storemerge8108;
     break L25;
    }
    $59 = 1 << ($56 << 24 >> 24) + -32 | $fl$0109;
    $60 = $storemerge8108 + 1 | 0;
    $61 = HEAP8[$60 >> 0] | 0;
    $51 = $61 << 24 >> 24;
    if (($51 & -32 | 0) != 32) {
     $66 = $61;
     $fl$062 = $59;
     $storemerge860 = $60;
     break;
    } else {
     $56 = $61;
     $fl$0109 = $59;
     $storemerge8108 = $60;
    }
   }
  } else {
   $66 = $47;
   $fl$062 = 0;
   $storemerge860 = $storemerge;
  } while (0);
  do if ($66 << 24 >> 24 == 42) {
   $67 = $storemerge860 + 1 | 0;
   $isdigittmp11 = (HEAP8[$67 >> 0] | 0) + -48 | 0;
   if ($isdigittmp11 >>> 0 < 10) if ((HEAP8[$storemerge860 + 2 >> 0] | 0) == 36) {
    HEAP32[$nl_type + ($isdigittmp11 << 2) >> 2] = 10;
    $l10n$2 = 1;
    $storemerge13 = $storemerge860 + 3 | 0;
    $w$0 = HEAP32[$nl_arg + ((HEAP8[$67 >> 0] | 0) + -48 << 3) >> 2] | 0;
   } else label = 24; else label = 24;
   if ((label | 0) == 24) {
    label = 0;
    if ($l10n$1) {
     $$0 = -1;
     break L1;
    }
    if (!$0) {
     $fl$1 = $fl$062;
     $fmt42 = $67;
     $l10n$3 = 0;
     $w$1 = 0;
     break;
    }
    $91 = (HEAP32[$ap >> 2] | 0) + (4 - 1) & ~(4 - 1);
    $92 = HEAP32[$91 >> 2] | 0;
    HEAP32[$ap >> 2] = $91 + 4;
    $l10n$2 = 0;
    $storemerge13 = $67;
    $w$0 = $92;
   }
   if (($w$0 | 0) < 0) {
    $fl$1 = $fl$062 | 8192;
    $fmt42 = $storemerge13;
    $l10n$3 = $l10n$2;
    $w$1 = 0 - $w$0 | 0;
   } else {
    $fl$1 = $fl$062;
    $fmt42 = $storemerge13;
    $l10n$3 = $l10n$2;
    $w$1 = $w$0;
   }
  } else {
   $isdigittmp1$i = ($66 << 24 >> 24) + -48 | 0;
   if ($isdigittmp1$i >>> 0 < 10) {
    $100 = $storemerge860;
    $i$03$i = 0;
    $isdigittmp4$i = $isdigittmp1$i;
    while (1) {
     $98 = ($i$03$i * 10 | 0) + $isdigittmp4$i | 0;
     $99 = $100 + 1 | 0;
     $isdigittmp4$i = (HEAP8[$99 >> 0] | 0) + -48 | 0;
     if ($isdigittmp4$i >>> 0 >= 10) {
      $$lcssa = $98;
      $$lcssa318 = $99;
      break;
     } else {
      $100 = $99;
      $i$03$i = $98;
     }
    }
    if (($$lcssa | 0) < 0) {
     $$0 = -1;
     break L1;
    } else {
     $fl$1 = $fl$062;
     $fmt42 = $$lcssa318;
     $l10n$3 = $l10n$1;
     $w$1 = $$lcssa;
    }
   } else {
    $fl$1 = $fl$062;
    $fmt42 = $storemerge860;
    $l10n$3 = $l10n$1;
    $w$1 = 0;
   }
  } while (0);
  L46 : do if ((HEAP8[$fmt42 >> 0] | 0) == 46) {
   $106 = $fmt42 + 1 | 0;
   $107 = HEAP8[$106 >> 0] | 0;
   if ($107 << 24 >> 24 != 42) {
    $isdigittmp1$i22 = ($107 << 24 >> 24) + -48 | 0;
    if ($isdigittmp1$i22 >>> 0 < 10) {
     $139 = $106;
     $i$03$i25 = 0;
     $isdigittmp4$i24 = $isdigittmp1$i22;
    } else {
     $fmt45 = $106;
     $p$0 = 0;
     break;
    }
    while (1) {
     $137 = ($i$03$i25 * 10 | 0) + $isdigittmp4$i24 | 0;
     $138 = $139 + 1 | 0;
     $isdigittmp4$i24 = (HEAP8[$138 >> 0] | 0) + -48 | 0;
     if ($isdigittmp4$i24 >>> 0 >= 10) {
      $fmt45 = $138;
      $p$0 = $137;
      break L46;
     } else {
      $139 = $138;
      $i$03$i25 = $137;
     }
    }
   }
   $109 = $fmt42 + 2 | 0;
   $isdigittmp9 = (HEAP8[$109 >> 0] | 0) + -48 | 0;
   if ($isdigittmp9 >>> 0 < 10) if ((HEAP8[$fmt42 + 3 >> 0] | 0) == 36) {
    HEAP32[$nl_type + ($isdigittmp9 << 2) >> 2] = 10;
    $fmt45 = $fmt42 + 4 | 0;
    $p$0 = HEAP32[$nl_arg + ((HEAP8[$109 >> 0] | 0) + -48 << 3) >> 2] | 0;
    break;
   }
   if ($l10n$3) {
    $$0 = -1;
    break L1;
   }
   if ($0) {
    $133 = (HEAP32[$ap >> 2] | 0) + (4 - 1) & ~(4 - 1);
    $134 = HEAP32[$133 >> 2] | 0;
    HEAP32[$ap >> 2] = $133 + 4;
    $fmt45 = $109;
    $p$0 = $134;
   } else {
    $fmt45 = $109;
    $p$0 = 0;
   }
  } else {
   $fmt45 = $fmt42;
   $p$0 = -1;
  } while (0);
  $fmt44 = $fmt45;
  $st$0 = 0;
  while (1) {
   $144 = (HEAP8[$fmt44 >> 0] | 0) + -65 | 0;
   if ($144 >>> 0 > 57) {
    $$0 = -1;
    break L1;
   }
   $146 = $fmt44 + 1 | 0;
   $148 = HEAP8[17803 + ($st$0 * 58 | 0) + $144 >> 0] | 0;
   $149 = $148 & 255;
   if (($149 + -1 | 0) >>> 0 < 8) {
    $fmt44 = $146;
    $st$0 = $149;
   } else {
    $$lcssa323 = $146;
    $$lcssa324 = $148;
    $$lcssa325 = $149;
    $fmt44$lcssa321 = $fmt44;
    $st$0$lcssa322 = $st$0;
    break;
   }
  }
  if (!($$lcssa324 << 24 >> 24)) {
   $$0 = -1;
   break;
  }
  $154 = ($argpos$0 | 0) > -1;
  do if ($$lcssa324 << 24 >> 24 == 19) if ($154) {
   $$0 = -1;
   break L1;
  } else label = 52; else {
   if ($154) {
    HEAP32[$nl_type + ($argpos$0 << 2) >> 2] = $$lcssa325;
    $157 = $nl_arg + ($argpos$0 << 3) | 0;
    $162 = HEAP32[$157 + 4 >> 2] | 0;
    $163 = $arg;
    HEAP32[$163 >> 2] = HEAP32[$157 >> 2];
    HEAP32[$163 + 4 >> 2] = $162;
    label = 52;
    break;
   }
   if (!$0) {
    $$0 = 0;
    break L1;
   }
   _pop_arg($arg, $$lcssa325, $ap);
  } while (0);
  if ((label | 0) == 52) {
   label = 0;
   if (!$0) {
    $cnt$0 = $cnt$1;
    $fmt41 = $$lcssa323;
    $l$0 = $34;
    $l10n$0 = $l10n$3;
    continue;
   }
  }
  $168 = HEAP8[$fmt44$lcssa321 >> 0] | 0;
  $t$0 = ($st$0$lcssa322 | 0) != 0 & ($168 & 15 | 0) == 3 ? $168 & -33 : $168;
  $175 = $fl$1 & -65537;
  $fl$1$ = ($fl$1 & 8192 | 0) == 0 ? $fl$1 : $175;
  L75 : do switch ($t$0 | 0) {
  case 110:
   {
    switch ($st$0$lcssa322 | 0) {
    case 0:
     {
      HEAP32[HEAP32[$arg >> 2] >> 2] = $cnt$1;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 1:
     {
      HEAP32[HEAP32[$arg >> 2] >> 2] = $cnt$1;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 2:
     {
      $187 = HEAP32[$arg >> 2] | 0;
      HEAP32[$187 >> 2] = $cnt$1;
      HEAP32[$187 + 4 >> 2] = (($cnt$1 | 0) < 0) << 31 >> 31;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 3:
     {
      HEAP16[HEAP32[$arg >> 2] >> 1] = $cnt$1;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 4:
     {
      HEAP8[HEAP32[$arg >> 2] >> 0] = $cnt$1;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 6:
     {
      HEAP32[HEAP32[$arg >> 2] >> 2] = $cnt$1;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    case 7:
     {
      $199 = HEAP32[$arg >> 2] | 0;
      HEAP32[$199 >> 2] = $cnt$1;
      HEAP32[$199 + 4 >> 2] = (($cnt$1 | 0) < 0) << 31 >> 31;
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
      break;
     }
    default:
     {
      $cnt$0 = $cnt$1;
      $fmt41 = $$lcssa323;
      $l$0 = $34;
      $l10n$0 = $l10n$3;
      continue L1;
     }
    }
    break;
   }
  case 112:
   {
    $fl$3 = $fl$1$ | 8;
    $p$1 = $p$0 >>> 0 > 8 ? $p$0 : 8;
    $t$1 = 120;
    label = 64;
    break;
   }
  case 88:
  case 120:
   {
    $fl$3 = $fl$1$;
    $p$1 = $p$0;
    $t$1 = $t$0;
    label = 64;
    break;
   }
  case 111:
   {
    $243 = $arg;
    $245 = HEAP32[$243 >> 2] | 0;
    $248 = HEAP32[$243 + 4 >> 2] | 0;
    if (($245 | 0) == 0 & ($248 | 0) == 0) $$0$lcssa$i = $1; else {
     $$03$i33 = $1;
     $253 = $245;
     $257 = $248;
     while (1) {
      $256 = $$03$i33 + -1 | 0;
      HEAP8[$256 >> 0] = $253 & 7 | 48;
      $253 = _bitshift64Lshr($253 | 0, $257 | 0, 3) | 0;
      $257 = tempRet0;
      if (($253 | 0) == 0 & ($257 | 0) == 0) {
       $$0$lcssa$i = $256;
       break;
      } else $$03$i33 = $256;
     }
    }
    if (!($fl$1$ & 8)) {
     $a$0 = $$0$lcssa$i;
     $fl$4 = $fl$1$;
     $p$2 = $p$0;
     $pl$1 = 0;
     $prefix$1 = 18283;
     label = 77;
    } else {
     $267 = $2 - $$0$lcssa$i + 1 | 0;
     $a$0 = $$0$lcssa$i;
     $fl$4 = $fl$1$;
     $p$2 = ($p$0 | 0) < ($267 | 0) ? $267 : $p$0;
     $pl$1 = 0;
     $prefix$1 = 18283;
     label = 77;
    }
    break;
   }
  case 105:
  case 100:
   {
    $269 = $arg;
    $271 = HEAP32[$269 >> 2] | 0;
    $274 = HEAP32[$269 + 4 >> 2] | 0;
    if (($274 | 0) < 0) {
     $276 = _i64Subtract(0, 0, $271 | 0, $274 | 0) | 0;
     $277 = tempRet0;
     $278 = $arg;
     HEAP32[$278 >> 2] = $276;
     HEAP32[$278 + 4 >> 2] = $277;
     $286 = $276;
     $287 = $277;
     $pl$0 = 1;
     $prefix$0 = 18283;
     label = 76;
     break L75;
    }
    if (!($fl$1$ & 2048)) {
     $284 = $fl$1$ & 1;
     $286 = $271;
     $287 = $274;
     $pl$0 = $284;
     $prefix$0 = ($284 | 0) == 0 ? 18283 : 18285;
     label = 76;
    } else {
     $286 = $271;
     $287 = $274;
     $pl$0 = 1;
     $prefix$0 = 18284;
     label = 76;
    }
    break;
   }
  case 117:
   {
    $176 = $arg;
    $286 = HEAP32[$176 >> 2] | 0;
    $287 = HEAP32[$176 + 4 >> 2] | 0;
    $pl$0 = 0;
    $prefix$0 = 18283;
    label = 76;
    break;
   }
  case 99:
   {
    HEAP8[$3 >> 0] = HEAP32[$arg >> 2];
    $a$2 = $3;
    $fl$6 = $175;
    $p$5 = 1;
    $pl$2 = 0;
    $prefix$2 = 18283;
    $z$2 = $1;
    break;
   }
  case 109:
   {
    $314 = ___errno_location() | 0;
    $a$1 = _strerror(HEAP32[$314 >> 2] | 0) | 0;
    label = 82;
    break;
   }
  case 115:
   {
    $317 = HEAP32[$arg >> 2] | 0;
    $a$1 = ($317 | 0) != 0 ? $317 : 18293;
    label = 82;
    break;
   }
  case 67:
   {
    HEAP32[$wc >> 2] = HEAP32[$arg >> 2];
    HEAP32[$4 >> 2] = 0;
    HEAP32[$arg >> 2] = $wc;
    $p$4198 = -1;
    label = 86;
    break;
   }
  case 83:
   {
    if (!$p$0) {
     _pad($f, 32, $w$1, 0, $fl$1$);
     $i$0$lcssa200 = 0;
     label = 98;
    } else {
     $p$4198 = $p$0;
     label = 86;
    }
    break;
   }
  case 65:
  case 71:
  case 70:
  case 69:
  case 97:
  case 103:
  case 102:
  case 101:
   {
    $359 = +HEAPF64[$arg >> 3];
    HEAP32[$e2$i >> 2] = 0;
    HEAPF64[tempDoublePtr >> 3] = $359;
    if ((HEAP32[tempDoublePtr + 4 >> 2] | 0) < 0) {
     $$07$i = -$359;
     $pl$0$i = 1;
     $prefix$0$i = 18300;
    } else if (!($fl$1$ & 2048)) {
     $366 = $fl$1$ & 1;
     $$07$i = $359;
     $pl$0$i = $366;
     $prefix$0$i = ($366 | 0) == 0 ? 18301 : 18306;
    } else {
     $$07$i = $359;
     $pl$0$i = 1;
     $prefix$0$i = 18303;
    }
    HEAPF64[tempDoublePtr >> 3] = $$07$i;
    $370 = HEAP32[tempDoublePtr + 4 >> 2] & 2146435072;
    do if ($370 >>> 0 < 2146435072 | ($370 | 0) == 2146435072 & 0 < 0) {
     $392 = +_frexpl($$07$i, $e2$i) * 2.0;
     $393 = $392 != 0.0;
     if ($393) HEAP32[$e2$i >> 2] = (HEAP32[$e2$i >> 2] | 0) + -1;
     $396 = $t$0 | 32;
     if (($396 | 0) == 97) {
      $398 = $t$0 & 32;
      $prefix$0$$i = ($398 | 0) == 0 ? $prefix$0$i : $prefix$0$i + 9 | 0;
      $401 = $pl$0$i | 2;
      $403 = 12 - $p$0 | 0;
      do if ($p$0 >>> 0 > 11 | ($403 | 0) == 0) $$1$i = $392; else {
       $re$169$i = $403;
       $round$068$i = 8.0;
       while (1) {
        $re$169$i = $re$169$i + -1 | 0;
        $407 = $round$068$i * 16.0;
        if (!$re$169$i) {
         $$lcssa342 = $407;
         break;
        } else $round$068$i = $407;
       }
       if ((HEAP8[$prefix$0$$i >> 0] | 0) == 45) {
        $$1$i = -($$lcssa342 + (-$392 - $$lcssa342));
        break;
       } else {
        $$1$i = $392 + $$lcssa342 - $$lcssa342;
        break;
       }
      } while (0);
      $417 = HEAP32[$e2$i >> 2] | 0;
      $420 = ($417 | 0) < 0 ? 0 - $417 | 0 : $417;
      $423 = _fmt_u($420, (($420 | 0) < 0) << 31 >> 31, $5) | 0;
      if (($423 | 0) == ($5 | 0)) {
       HEAP8[$6 >> 0] = 48;
       $estr$0$i = $6;
      } else $estr$0$i = $423;
      HEAP8[$estr$0$i + -1 >> 0] = ($417 >> 31 & 2) + 43;
      $432 = $estr$0$i + -2 | 0;
      HEAP8[$432 >> 0] = $t$0 + 15;
      $notrhs$i = ($p$0 | 0) < 1;
      $434 = ($fl$1$ & 8 | 0) == 0;
      $$2$i = $$1$i;
      $s$0$i = $buf$i;
      while (1) {
       $435 = ~~$$2$i;
       $441 = $s$0$i + 1 | 0;
       HEAP8[$s$0$i >> 0] = HEAPU8[18267 + $435 >> 0] | $398;
       $$2$i = ($$2$i - +($435 | 0)) * 16.0;
       do if (($441 - $7 | 0) == 1) {
        if ($434 & ($notrhs$i & $$2$i == 0.0)) {
         $s$1$i = $441;
         break;
        }
        HEAP8[$441 >> 0] = 46;
        $s$1$i = $s$0$i + 2 | 0;
       } else $s$1$i = $441; while (0);
       if (!($$2$i != 0.0)) {
        $s$1$i$lcssa = $s$1$i;
        break;
       } else $s$0$i = $s$1$i;
      }
      $$pre182$i = $s$1$i$lcssa;
      $l$0$i = ($p$0 | 0) != 0 & ($10 + $$pre182$i | 0) < ($p$0 | 0) ? $11 + $p$0 - $432 | 0 : $9 - $432 + $$pre182$i | 0;
      $459 = $l$0$i + $401 | 0;
      _pad($f, 32, $w$1, $459, $fl$1$);
      if (!(HEAP32[$f >> 2] & 32)) ___fwritex($prefix$0$$i, $401, $f) | 0;
      _pad($f, 48, $w$1, $459, $fl$1$ ^ 65536);
      $464 = $$pre182$i - $7 | 0;
      if (!(HEAP32[$f >> 2] & 32)) ___fwritex($buf$i, $464, $f) | 0;
      $469 = $8 - $432 | 0;
      _pad($f, 48, $l$0$i - ($464 + $469) | 0, 0, 0);
      if (!(HEAP32[$f >> 2] & 32)) ___fwritex($432, $469, $f) | 0;
      _pad($f, 32, $w$1, $459, $fl$1$ ^ 8192);
      $$0$i = ($459 | 0) < ($w$1 | 0) ? $w$1 : $459;
      break;
     }
     $$p$i = ($p$0 | 0) < 0 ? 6 : $p$0;
     if ($393) {
      $479 = (HEAP32[$e2$i >> 2] | 0) + -28 | 0;
      HEAP32[$e2$i >> 2] = $479;
      $$3$i = $392 * 268435456.0;
      $481 = $479;
     } else {
      $$3$i = $392;
      $481 = HEAP32[$e2$i >> 2] | 0;
     }
     $$31$i = ($481 | 0) < 0 ? $big$i : $12;
     $482 = $$31$i;
     $$4$i = $$3$i;
     $z$0$i = $$31$i;
     while (1) {
      $483 = ~~$$4$i >>> 0;
      HEAP32[$z$0$i >> 2] = $483;
      $484 = $z$0$i + 4 | 0;
      $$4$i = ($$4$i - +($483 >>> 0)) * 1.0e9;
      if (!($$4$i != 0.0)) {
       $$lcssa326 = $484;
       break;
      } else $z$0$i = $484;
     }
     $$pr$i = HEAP32[$e2$i >> 2] | 0;
     if (($$pr$i | 0) > 0) {
      $491 = $$pr$i;
      $a$1147$i = $$31$i;
      $z$1146$i = $$lcssa326;
      while (1) {
       $492 = ($491 | 0) > 29 ? 29 : $491;
       $d$0139$i = $z$1146$i + -4 | 0;
       do if ($d$0139$i >>> 0 < $a$1147$i >>> 0) $a$2$ph$i = $a$1147$i; else {
        $carry$0140$i = 0;
        $d$0141$i = $d$0139$i;
        while (1) {
         $495 = _bitshift64Shl(HEAP32[$d$0141$i >> 2] | 0, 0, $492 | 0) | 0;
         $497 = _i64Add($495 | 0, tempRet0 | 0, $carry$0140$i | 0, 0) | 0;
         $498 = tempRet0;
         $499 = ___uremdi3($497 | 0, $498 | 0, 1e9, 0) | 0;
         HEAP32[$d$0141$i >> 2] = $499;
         $501 = ___udivdi3($497 | 0, $498 | 0, 1e9, 0) | 0;
         $d$0141$i = $d$0141$i + -4 | 0;
         if ($d$0141$i >>> 0 < $a$1147$i >>> 0) {
          $$lcssa327 = $501;
          break;
         } else $carry$0140$i = $501;
        }
        if (!$$lcssa327) {
         $a$2$ph$i = $a$1147$i;
         break;
        }
        $505 = $a$1147$i + -4 | 0;
        HEAP32[$505 >> 2] = $$lcssa327;
        $a$2$ph$i = $505;
       } while (0);
       $z$2$i = $z$1146$i;
       while (1) {
        if ($z$2$i >>> 0 <= $a$2$ph$i >>> 0) {
         $z$2$i$lcssa = $z$2$i;
         break;
        }
        $507 = $z$2$i + -4 | 0;
        if (!(HEAP32[$507 >> 2] | 0)) $z$2$i = $507; else {
         $z$2$i$lcssa = $z$2$i;
         break;
        }
       }
       $511 = (HEAP32[$e2$i >> 2] | 0) - $492 | 0;
       HEAP32[$e2$i >> 2] = $511;
       if (($511 | 0) > 0) {
        $491 = $511;
        $a$1147$i = $a$2$ph$i;
        $z$1146$i = $z$2$i$lcssa;
       } else {
        $$pr47$i = $511;
        $a$1$lcssa$i = $a$2$ph$i;
        $z$1$lcssa$i = $z$2$i$lcssa;
        break;
       }
      }
     } else {
      $$pr47$i = $$pr$i;
      $a$1$lcssa$i = $$31$i;
      $z$1$lcssa$i = $$lcssa326;
     }
     if (($$pr47$i | 0) < 0) {
      $516 = (($$p$i + 25 | 0) / 9 | 0) + 1 | 0;
      $517 = ($396 | 0) == 102;
      $519 = $$pr47$i;
      $a$3134$i = $a$1$lcssa$i;
      $z$3133$i = $z$1$lcssa$i;
      while (1) {
       $518 = 0 - $519 | 0;
       $521 = ($518 | 0) > 9 ? 9 : $518;
       do if ($a$3134$i >>> 0 < $z$3133$i >>> 0) {
        $527 = (1 << $521) + -1 | 0;
        $528 = 1e9 >>> $521;
        $carry3$0128$i = 0;
        $d$1127$i = $a$3134$i;
        while (1) {
         $529 = HEAP32[$d$1127$i >> 2] | 0;
         HEAP32[$d$1127$i >> 2] = ($529 >>> $521) + $carry3$0128$i;
         $533 = Math_imul($529 & $527, $528) | 0;
         $d$1127$i = $d$1127$i + 4 | 0;
         if ($d$1127$i >>> 0 >= $z$3133$i >>> 0) {
          $$lcssa329 = $533;
          break;
         } else $carry3$0128$i = $533;
        }
        $$a$3$i = (HEAP32[$a$3134$i >> 2] | 0) == 0 ? $a$3134$i + 4 | 0 : $a$3134$i;
        if (!$$lcssa329) {
         $$a$3186$i = $$a$3$i;
         $z$4$i = $z$3133$i;
         break;
        }
        HEAP32[$z$3133$i >> 2] = $$lcssa329;
        $$a$3186$i = $$a$3$i;
        $z$4$i = $z$3133$i + 4 | 0;
       } else {
        $$a$3186$i = (HEAP32[$a$3134$i >> 2] | 0) == 0 ? $a$3134$i + 4 | 0 : $a$3134$i;
        $z$4$i = $z$3133$i;
       } while (0);
       $541 = $517 ? $$31$i : $$a$3186$i;
       $$z$4$i = ($z$4$i - $541 >> 2 | 0) > ($516 | 0) ? $541 + ($516 << 2) | 0 : $z$4$i;
       $519 = (HEAP32[$e2$i >> 2] | 0) + $521 | 0;
       HEAP32[$e2$i >> 2] = $519;
       if (($519 | 0) >= 0) {
        $a$3$lcssa$i = $$a$3186$i;
        $z$3$lcssa$i = $$z$4$i;
        break;
       } else {
        $a$3134$i = $$a$3186$i;
        $z$3133$i = $$z$4$i;
       }
      }
     } else {
      $a$3$lcssa$i = $a$1$lcssa$i;
      $z$3$lcssa$i = $z$1$lcssa$i;
     }
     do if ($a$3$lcssa$i >>> 0 < $z$3$lcssa$i >>> 0) {
      $555 = ($482 - $a$3$lcssa$i >> 2) * 9 | 0;
      $556 = HEAP32[$a$3$lcssa$i >> 2] | 0;
      if ($556 >>> 0 < 10) {
       $e$1$i = $555;
       break;
      } else {
       $e$0123$i = $555;
       $i$0122$i = 10;
      }
      while (1) {
       $i$0122$i = $i$0122$i * 10 | 0;
       $559 = $e$0123$i + 1 | 0;
       if ($556 >>> 0 < $i$0122$i >>> 0) {
        $e$1$i = $559;
        break;
       } else $e$0123$i = $559;
      }
     } else $e$1$i = 0; while (0);
     $564 = ($396 | 0) == 103;
     $565 = ($$p$i | 0) != 0;
     $567 = $$p$i - (($396 | 0) != 102 ? $e$1$i : 0) + (($565 & $564) << 31 >> 31) | 0;
     if (($567 | 0) < ((($z$3$lcssa$i - $482 >> 2) * 9 | 0) + -9 | 0)) {
      $574 = $567 + 9216 | 0;
      $575 = ($574 | 0) / 9 | 0;
      $576 = $$31$i + ($575 + -1023 << 2) | 0;
      $j$0115$i = (($574 | 0) % 9 | 0) + 1 | 0;
      if (($j$0115$i | 0) < 9) {
       $i$1116$i = 10;
       $j$0117$i = $j$0115$i;
       while (1) {
        $579 = $i$1116$i * 10 | 0;
        $j$0117$i = $j$0117$i + 1 | 0;
        if (($j$0117$i | 0) == 9) {
         $i$1$lcssa$i = $579;
         break;
        } else $i$1116$i = $579;
       }
      } else $i$1$lcssa$i = 10;
      $580 = HEAP32[$576 >> 2] | 0;
      $581 = ($580 >>> 0) % ($i$1$lcssa$i >>> 0) | 0;
      if (!$581) if (($$31$i + ($575 + -1022 << 2) | 0) == ($z$3$lcssa$i | 0)) {
       $a$7$i = $a$3$lcssa$i;
       $d$3$i = $576;
       $e$3$i = $e$1$i;
      } else label = 163; else label = 163;
      do if ((label | 0) == 163) {
       label = 0;
       $$20$i = ((($580 >>> 0) / ($i$1$lcssa$i >>> 0) | 0) & 1 | 0) == 0 ? 9007199254740992.0 : 9007199254740994.0;
       $588 = ($i$1$lcssa$i | 0) / 2 | 0;
       do if ($581 >>> 0 < $588 >>> 0) $small$0$i = .5; else {
        if (($581 | 0) == ($588 | 0)) if (($$31$i + ($575 + -1022 << 2) | 0) == ($z$3$lcssa$i | 0)) {
         $small$0$i = 1.0;
         break;
        }
        $small$0$i = 1.5;
       } while (0);
       do if (!$pl$0$i) {
        $round6$1$i = $$20$i;
        $small$1$i = $small$0$i;
       } else {
        if ((HEAP8[$prefix$0$i >> 0] | 0) != 45) {
         $round6$1$i = $$20$i;
         $small$1$i = $small$0$i;
         break;
        }
        $round6$1$i = -$$20$i;
        $small$1$i = -$small$0$i;
       } while (0);
       $598 = $580 - $581 | 0;
       HEAP32[$576 >> 2] = $598;
       if (!($round6$1$i + $small$1$i != $round6$1$i)) {
        $a$7$i = $a$3$lcssa$i;
        $d$3$i = $576;
        $e$3$i = $e$1$i;
        break;
       }
       $601 = $598 + $i$1$lcssa$i | 0;
       HEAP32[$576 >> 2] = $601;
       if ($601 >>> 0 > 999999999) {
        $a$5109$i = $a$3$lcssa$i;
        $d$2108$i = $576;
        while (1) {
         $603 = $d$2108$i + -4 | 0;
         HEAP32[$d$2108$i >> 2] = 0;
         if ($603 >>> 0 < $a$5109$i >>> 0) {
          $605 = $a$5109$i + -4 | 0;
          HEAP32[$605 >> 2] = 0;
          $a$6$i = $605;
         } else $a$6$i = $a$5109$i;
         $607 = (HEAP32[$603 >> 2] | 0) + 1 | 0;
         HEAP32[$603 >> 2] = $607;
         if ($607 >>> 0 > 999999999) {
          $a$5109$i = $a$6$i;
          $d$2108$i = $603;
         } else {
          $a$5$lcssa$i = $a$6$i;
          $d$2$lcssa$i = $603;
          break;
         }
        }
       } else {
        $a$5$lcssa$i = $a$3$lcssa$i;
        $d$2$lcssa$i = $576;
       }
       $612 = ($482 - $a$5$lcssa$i >> 2) * 9 | 0;
       $613 = HEAP32[$a$5$lcssa$i >> 2] | 0;
       if ($613 >>> 0 < 10) {
        $a$7$i = $a$5$lcssa$i;
        $d$3$i = $d$2$lcssa$i;
        $e$3$i = $612;
        break;
       } else {
        $e$2104$i = $612;
        $i$2103$i = 10;
       }
       while (1) {
        $i$2103$i = $i$2103$i * 10 | 0;
        $616 = $e$2104$i + 1 | 0;
        if ($613 >>> 0 < $i$2103$i >>> 0) {
         $a$7$i = $a$5$lcssa$i;
         $d$3$i = $d$2$lcssa$i;
         $e$3$i = $616;
         break;
        } else $e$2104$i = $616;
       }
      } while (0);
      $618 = $d$3$i + 4 | 0;
      $a$8$ph$i = $a$7$i;
      $e$4$ph$i = $e$3$i;
      $z$6$ph$i = $z$3$lcssa$i >>> 0 > $618 >>> 0 ? $618 : $z$3$lcssa$i;
     } else {
      $a$8$ph$i = $a$3$lcssa$i;
      $e$4$ph$i = $e$1$i;
      $z$6$ph$i = $z$3$lcssa$i;
     }
     $620 = 0 - $e$4$ph$i | 0;
     $z$6$i = $z$6$ph$i;
     while (1) {
      if ($z$6$i >>> 0 <= $a$8$ph$i >>> 0) {
       $$lcssa159$i = 0;
       $z$6$i$lcssa = $z$6$i;
       break;
      }
      $622 = $z$6$i + -4 | 0;
      if (!(HEAP32[$622 >> 2] | 0)) $z$6$i = $622; else {
       $$lcssa159$i = 1;
       $z$6$i$lcssa = $z$6$i;
       break;
      }
     }
     do if ($564) {
      $$p$$i = ($565 & 1 ^ 1) + $$p$i | 0;
      if (($$p$$i | 0) > ($e$4$ph$i | 0) & ($e$4$ph$i | 0) > -5) {
       $$013$i = $t$0 + -1 | 0;
       $$210$i = $$p$$i + -1 - $e$4$ph$i | 0;
      } else {
       $$013$i = $t$0 + -2 | 0;
       $$210$i = $$p$$i + -1 | 0;
      }
      $633 = $fl$1$ & 8;
      if ($633) {
       $$114$i = $$013$i;
       $$311$i = $$210$i;
       $$pre$phi184$iZ2D = $633;
       break;
      }
      do if ($$lcssa159$i) {
       $636 = HEAP32[$z$6$i$lcssa + -4 >> 2] | 0;
       if (!$636) {
        $j$2$i = 9;
        break;
       }
       if (!(($636 >>> 0) % 10 | 0)) {
        $i$399$i = 10;
        $j$1100$i = 0;
       } else {
        $j$2$i = 0;
        break;
       }
       while (1) {
        $i$399$i = $i$399$i * 10 | 0;
        $641 = $j$1100$i + 1 | 0;
        if (($636 >>> 0) % ($i$399$i >>> 0) | 0) {
         $j$2$i = $641;
         break;
        } else $j$1100$i = $641;
       }
      } else $j$2$i = 9; while (0);
      $650 = (($z$6$i$lcssa - $482 >> 2) * 9 | 0) + -9 | 0;
      if (($$013$i | 32 | 0) == 102) {
       $651 = $650 - $j$2$i | 0;
       $$21$i = ($651 | 0) < 0 ? 0 : $651;
       $$114$i = $$013$i;
       $$311$i = ($$210$i | 0) < ($$21$i | 0) ? $$210$i : $$21$i;
       $$pre$phi184$iZ2D = 0;
       break;
      } else {
       $655 = $650 + $e$4$ph$i - $j$2$i | 0;
       $$23$i = ($655 | 0) < 0 ? 0 : $655;
       $$114$i = $$013$i;
       $$311$i = ($$210$i | 0) < ($$23$i | 0) ? $$210$i : $$23$i;
       $$pre$phi184$iZ2D = 0;
       break;
      }
     } else {
      $$114$i = $t$0;
      $$311$i = $$p$i;
      $$pre$phi184$iZ2D = $fl$1$ & 8;
     } while (0);
     $658 = $$311$i | $$pre$phi184$iZ2D;
     $660 = ($658 | 0) != 0 & 1;
     $662 = ($$114$i | 32 | 0) == 102;
     if ($662) {
      $$pn$i = ($e$4$ph$i | 0) > 0 ? $e$4$ph$i : 0;
      $estr$2$i = 0;
     } else {
      $666 = ($e$4$ph$i | 0) < 0 ? $620 : $e$4$ph$i;
      $669 = _fmt_u($666, (($666 | 0) < 0) << 31 >> 31, $5) | 0;
      if (($8 - $669 | 0) < 2) {
       $estr$193$i = $669;
       while (1) {
        $673 = $estr$193$i + -1 | 0;
        HEAP8[$673 >> 0] = 48;
        if (($8 - $673 | 0) < 2) $estr$193$i = $673; else {
         $estr$1$lcssa$i = $673;
         break;
        }
       }
      } else $estr$1$lcssa$i = $669;
      HEAP8[$estr$1$lcssa$i + -1 >> 0] = ($e$4$ph$i >> 31 & 2) + 43;
      $683 = $estr$1$lcssa$i + -2 | 0;
      HEAP8[$683 >> 0] = $$114$i;
      $$pn$i = $8 - $683 | 0;
      $estr$2$i = $683;
     }
     $688 = $pl$0$i + 1 + $$311$i + $660 + $$pn$i | 0;
     _pad($f, 32, $w$1, $688, $fl$1$);
     if (!(HEAP32[$f >> 2] & 32)) ___fwritex($prefix$0$i, $pl$0$i, $f) | 0;
     _pad($f, 48, $w$1, $688, $fl$1$ ^ 65536);
     do if ($662) {
      $r$0$a$8$i = $a$8$ph$i >>> 0 > $$31$i >>> 0 ? $$31$i : $a$8$ph$i;
      $d$482$i = $r$0$a$8$i;
      while (1) {
       $695 = _fmt_u(HEAP32[$d$482$i >> 2] | 0, 0, $13) | 0;
       do if (($d$482$i | 0) == ($r$0$a$8$i | 0)) {
        if (($695 | 0) != ($13 | 0)) {
         $s7$1$i = $695;
         break;
        }
        HEAP8[$15 >> 0] = 48;
        $s7$1$i = $15;
       } else {
        if ($695 >>> 0 > $buf$i >>> 0) $s7$079$i = $695; else {
         $s7$1$i = $695;
         break;
        }
        while (1) {
         $698 = $s7$079$i + -1 | 0;
         HEAP8[$698 >> 0] = 48;
         if ($698 >>> 0 > $buf$i >>> 0) $s7$079$i = $698; else {
          $s7$1$i = $698;
          break;
         }
        }
       } while (0);
       if (!(HEAP32[$f >> 2] & 32)) ___fwritex($s7$1$i, $14 - $s7$1$i | 0, $f) | 0;
       $706 = $d$482$i + 4 | 0;
       if ($706 >>> 0 > $$31$i >>> 0) {
        $$lcssa339 = $706;
        break;
       } else $d$482$i = $706;
      }
      do if ($658) {
       if (HEAP32[$f >> 2] & 32) break;
       ___fwritex(18335, 1, $f) | 0;
      } while (0);
      if (($$311$i | 0) > 0 & $$lcssa339 >>> 0 < $z$6$i$lcssa >>> 0) {
       $$41276$i = $$311$i;
       $d$575$i = $$lcssa339;
       while (1) {
        $716 = _fmt_u(HEAP32[$d$575$i >> 2] | 0, 0, $13) | 0;
        if ($716 >>> 0 > $buf$i >>> 0) {
         $s8$070$i = $716;
         while (1) {
          $718 = $s8$070$i + -1 | 0;
          HEAP8[$718 >> 0] = 48;
          if ($718 >>> 0 > $buf$i >>> 0) $s8$070$i = $718; else {
           $s8$0$lcssa$i = $718;
           break;
          }
         }
        } else $s8$0$lcssa$i = $716;
        if (!(HEAP32[$f >> 2] & 32)) ___fwritex($s8$0$lcssa$i, ($$41276$i | 0) > 9 ? 9 : $$41276$i, $f) | 0;
        $d$575$i = $d$575$i + 4 | 0;
        $726 = $$41276$i + -9 | 0;
        if (!(($$41276$i | 0) > 9 & $d$575$i >>> 0 < $z$6$i$lcssa >>> 0)) {
         $$412$lcssa$i = $726;
         break;
        } else $$41276$i = $726;
       }
      } else $$412$lcssa$i = $$311$i;
      _pad($f, 48, $$412$lcssa$i + 9 | 0, 9, 0);
     } else {
      $z$6$$i = $$lcssa159$i ? $z$6$i$lcssa : $a$8$ph$i + 4 | 0;
      if (($$311$i | 0) > -1) {
       $733 = ($$pre$phi184$iZ2D | 0) == 0;
       $$587$i = $$311$i;
       $d$686$i = $a$8$ph$i;
       while (1) {
        $735 = _fmt_u(HEAP32[$d$686$i >> 2] | 0, 0, $13) | 0;
        if (($735 | 0) == ($13 | 0)) {
         HEAP8[$15 >> 0] = 48;
         $s9$0$i = $15;
        } else $s9$0$i = $735;
        do if (($d$686$i | 0) == ($a$8$ph$i | 0)) {
         $741 = $s9$0$i + 1 | 0;
         if (!(HEAP32[$f >> 2] & 32)) ___fwritex($s9$0$i, 1, $f) | 0;
         if ($733 & ($$587$i | 0) < 1) {
          $s9$2$i = $741;
          break;
         }
         if (HEAP32[$f >> 2] & 32) {
          $s9$2$i = $741;
          break;
         }
         ___fwritex(18335, 1, $f) | 0;
         $s9$2$i = $741;
        } else {
         if ($s9$0$i >>> 0 > $buf$i >>> 0) $s9$183$i = $s9$0$i; else {
          $s9$2$i = $s9$0$i;
          break;
         }
         while (1) {
          $739 = $s9$183$i + -1 | 0;
          HEAP8[$739 >> 0] = 48;
          if ($739 >>> 0 > $buf$i >>> 0) $s9$183$i = $739; else {
           $s9$2$i = $739;
           break;
          }
         }
        } while (0);
        $750 = $14 - $s9$2$i | 0;
        if (!(HEAP32[$f >> 2] & 32)) ___fwritex($s9$2$i, ($$587$i | 0) > ($750 | 0) ? $750 : $$587$i, $f) | 0;
        $756 = $$587$i - $750 | 0;
        $d$686$i = $d$686$i + 4 | 0;
        if (!($d$686$i >>> 0 < $z$6$$i >>> 0 & ($756 | 0) > -1)) {
         $$5$lcssa$i = $756;
         break;
        } else $$587$i = $756;
       }
      } else $$5$lcssa$i = $$311$i;
      _pad($f, 48, $$5$lcssa$i + 18 | 0, 18, 0);
      if (HEAP32[$f >> 2] & 32) break;
      ___fwritex($estr$2$i, $8 - $estr$2$i | 0, $f) | 0;
     } while (0);
     _pad($f, 32, $w$1, $688, $fl$1$ ^ 8192);
     $$0$i = ($688 | 0) < ($w$1 | 0) ? $w$1 : $688;
    } else {
     $377 = ($t$0 & 32 | 0) != 0;
     $379 = $$07$i != $$07$i | 0.0 != 0.0;
     $pl$1$i = $379 ? 0 : $pl$0$i;
     $381 = $pl$1$i + 3 | 0;
     _pad($f, 32, $w$1, $381, $175);
     $382 = HEAP32[$f >> 2] | 0;
     if (!($382 & 32)) {
      ___fwritex($prefix$0$i, $pl$1$i, $f) | 0;
      $386 = HEAP32[$f >> 2] | 0;
     } else $386 = $382;
     if (!($386 & 32)) ___fwritex($379 ? ($377 ? 18327 : 18331) : $377 ? 18319 : 18323, 3, $f) | 0;
     _pad($f, 32, $w$1, $381, $fl$1$ ^ 8192);
     $$0$i = ($381 | 0) < ($w$1 | 0) ? $w$1 : $381;
    } while (0);
    $cnt$0 = $cnt$1;
    $fmt41 = $$lcssa323;
    $l$0 = $$0$i;
    $l10n$0 = $l10n$3;
    continue L1;
    break;
   }
  default:
   {
    $a$2 = $fmt41;
    $fl$6 = $fl$1$;
    $p$5 = $p$0;
    $pl$2 = 0;
    $prefix$2 = 18283;
    $z$2 = $1;
   }
  } while (0);
  L313 : do if ((label | 0) == 64) {
   label = 0;
   $206 = $arg;
   $208 = HEAP32[$206 >> 2] | 0;
   $211 = HEAP32[$206 + 4 >> 2] | 0;
   $212 = $t$1 & 32;
   if (($208 | 0) == 0 & ($211 | 0) == 0) {
    $a$0 = $1;
    $fl$4 = $fl$3;
    $p$2 = $p$1;
    $pl$1 = 0;
    $prefix$1 = 18283;
    label = 77;
   } else {
    $$012$i = $1;
    $217 = $208;
    $224 = $211;
    while (1) {
     $223 = $$012$i + -1 | 0;
     HEAP8[$223 >> 0] = HEAPU8[18267 + ($217 & 15) >> 0] | $212;
     $217 = _bitshift64Lshr($217 | 0, $224 | 0, 4) | 0;
     $224 = tempRet0;
     if (($217 | 0) == 0 & ($224 | 0) == 0) {
      $$lcssa344 = $223;
      break;
     } else $$012$i = $223;
    }
    $230 = $arg;
    if (($fl$3 & 8 | 0) == 0 | (HEAP32[$230 >> 2] | 0) == 0 & (HEAP32[$230 + 4 >> 2] | 0) == 0) {
     $a$0 = $$lcssa344;
     $fl$4 = $fl$3;
     $p$2 = $p$1;
     $pl$1 = 0;
     $prefix$1 = 18283;
     label = 77;
    } else {
     $a$0 = $$lcssa344;
     $fl$4 = $fl$3;
     $p$2 = $p$1;
     $pl$1 = 2;
     $prefix$1 = 18283 + ($t$1 >> 4) | 0;
     label = 77;
    }
   }
  } else if ((label | 0) == 76) {
   label = 0;
   $a$0 = _fmt_u($286, $287, $1) | 0;
   $fl$4 = $fl$1$;
   $p$2 = $p$0;
   $pl$1 = $pl$0;
   $prefix$1 = $prefix$0;
   label = 77;
  } else if ((label | 0) == 82) {
   label = 0;
   $320 = _memchr($a$1, 0, $p$0) | 0;
   $321 = ($320 | 0) == 0;
   $a$2 = $a$1;
   $fl$6 = $175;
   $p$5 = $321 ? $p$0 : $320 - $a$1 | 0;
   $pl$2 = 0;
   $prefix$2 = 18283;
   $z$2 = $321 ? $a$1 + $p$0 | 0 : $320;
  } else if ((label | 0) == 86) {
   label = 0;
   $i$0114 = 0;
   $l$1113 = 0;
   $ws$0115 = HEAP32[$arg >> 2] | 0;
   while (1) {
    $334 = HEAP32[$ws$0115 >> 2] | 0;
    if (!$334) {
     $i$0$lcssa = $i$0114;
     $l$2 = $l$1113;
     break;
    }
    $336 = _wctomb($mb, $334) | 0;
    if (($336 | 0) < 0 | $336 >>> 0 > ($p$4198 - $i$0114 | 0) >>> 0) {
     $i$0$lcssa = $i$0114;
     $l$2 = $336;
     break;
    }
    $341 = $336 + $i$0114 | 0;
    if ($p$4198 >>> 0 > $341 >>> 0) {
     $i$0114 = $341;
     $l$1113 = $336;
     $ws$0115 = $ws$0115 + 4 | 0;
    } else {
     $i$0$lcssa = $341;
     $l$2 = $336;
     break;
    }
   }
   if (($l$2 | 0) < 0) {
    $$0 = -1;
    break L1;
   }
   _pad($f, 32, $w$1, $i$0$lcssa, $fl$1$);
   if (!$i$0$lcssa) {
    $i$0$lcssa200 = 0;
    label = 98;
   } else {
    $i$1125 = 0;
    $ws$1126 = HEAP32[$arg >> 2] | 0;
    while (1) {
     $346 = HEAP32[$ws$1126 >> 2] | 0;
     if (!$346) {
      $i$0$lcssa200 = $i$0$lcssa;
      label = 98;
      break L313;
     }
     $349 = _wctomb($mb, $346) | 0;
     $i$1125 = $349 + $i$1125 | 0;
     if (($i$1125 | 0) > ($i$0$lcssa | 0)) {
      $i$0$lcssa200 = $i$0$lcssa;
      label = 98;
      break L313;
     }
     if (!(HEAP32[$f >> 2] & 32)) ___fwritex($mb, $349, $f) | 0;
     if ($i$1125 >>> 0 >= $i$0$lcssa >>> 0) {
      $i$0$lcssa200 = $i$0$lcssa;
      label = 98;
      break;
     } else $ws$1126 = $ws$1126 + 4 | 0;
    }
   }
  } while (0);
  if ((label | 0) == 98) {
   label = 0;
   _pad($f, 32, $w$1, $i$0$lcssa200, $fl$1$ ^ 8192);
   $cnt$0 = $cnt$1;
   $fmt41 = $$lcssa323;
   $l$0 = ($w$1 | 0) > ($i$0$lcssa200 | 0) ? $w$1 : $i$0$lcssa200;
   $l10n$0 = $l10n$3;
   continue;
  }
  if ((label | 0) == 77) {
   label = 0;
   $$fl$4 = ($p$2 | 0) > -1 ? $fl$4 & -65537 : $fl$4;
   $291 = $arg;
   $299 = (HEAP32[$291 >> 2] | 0) != 0 | (HEAP32[$291 + 4 >> 2] | 0) != 0;
   if (($p$2 | 0) != 0 | $299) {
    $305 = ($299 & 1 ^ 1) + ($2 - $a$0) | 0;
    $a$2 = $a$0;
    $fl$6 = $$fl$4;
    $p$5 = ($p$2 | 0) > ($305 | 0) ? $p$2 : $305;
    $pl$2 = $pl$1;
    $prefix$2 = $prefix$1;
    $z$2 = $1;
   } else {
    $a$2 = $1;
    $fl$6 = $$fl$4;
    $p$5 = 0;
    $pl$2 = $pl$1;
    $prefix$2 = $prefix$1;
    $z$2 = $1;
   }
  }
  $771 = $z$2 - $a$2 | 0;
  $$p$5 = ($p$5 | 0) < ($771 | 0) ? $771 : $p$5;
  $773 = $pl$2 + $$p$5 | 0;
  $w$2 = ($w$1 | 0) < ($773 | 0) ? $773 : $w$1;
  _pad($f, 32, $w$2, $773, $fl$6);
  if (!(HEAP32[$f >> 2] & 32)) ___fwritex($prefix$2, $pl$2, $f) | 0;
  _pad($f, 48, $w$2, $773, $fl$6 ^ 65536);
  _pad($f, 48, $$p$5, $771, 0);
  if (!(HEAP32[$f >> 2] & 32)) ___fwritex($a$2, $771, $f) | 0;
  _pad($f, 32, $w$2, $773, $fl$6 ^ 8192);
  $cnt$0 = $cnt$1;
  $fmt41 = $$lcssa323;
  $l$0 = $w$2;
  $l10n$0 = $l10n$3;
 }
 L348 : do if ((label | 0) == 245) if (!$f) if (!$l10n$0$lcssa) $$0 = 0; else {
  $i$2100 = 1;
  while (1) {
   $786 = HEAP32[$nl_type + ($i$2100 << 2) >> 2] | 0;
   if (!$786) {
    $i$2100$lcssa = $i$2100;
    break;
   }
   _pop_arg($nl_arg + ($i$2100 << 3) | 0, $786, $ap);
   $i$2100 = $i$2100 + 1 | 0;
   if (($i$2100 | 0) >= 10) {
    $$0 = 1;
    break L348;
   }
  }
  if (($i$2100$lcssa | 0) < 10) {
   $i$398 = $i$2100$lcssa;
   while (1) {
    if (HEAP32[$nl_type + ($i$398 << 2) >> 2] | 0) {
     $$0 = -1;
     break L348;
    }
    $i$398 = $i$398 + 1 | 0;
    if (($i$398 | 0) >= 10) {
     $$0 = 1;
     break;
    }
   }
  } else $$0 = 1;
 } else $$0 = $cnt$1$lcssa; while (0);
 STACKTOP = sp;
 return $$0 | 0;
}
function __ZN10__cxxabiv112_GLOBAL__N_118parse_expr_primaryINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0 = 0, $$0$i = 0, $$0$i$i$i = 0, $$0$i$i$i$i = 0, $$0$i$i$i$i46 = 0, $$0$i$i$i$i62 = 0, $$0$i$i$i26 = 0, $$0$i$i117 = 0, $$0$i49 = 0, $$01$i$i$i122 = 0, $$01$i$i$i41126 = 0, $$01$i$i$i57130 = 0, $$1$i = 0, $$lcssa = 0, $$lcssa154 = 0, $$lcssa155 = 0, $$lcssa157 = 0, $$lcssa158 = 0, $$lcssa160 = 0, $$lcssa161 = 0, $0 = 0, $1 = 0, $10 = 0, $101 = 0, $102 = 0, $104 = 0, $105 = 0, $107 = 0, $108 = 0, $11 = 0, $110 = 0, $111 = 0, $113 = 0, $114 = 0, $116 = 0, $117 = 0, $119 = 0, $12 = 0, $120 = 0, $122 = 0, $123 = 0, $125 = 0, $126 = 0, $128 = 0, $129 = 0, $13 = 0, $131 = 0, $132 = 0, $134 = 0, $138 = 0, $14 = 0, $141 = 0, $145 = 0, $148 = 0, $148$phi = 0, $149 = 0, $15 = 0, $156 = 0, $157 = 0, $159 = 0, $16 = 0, $163 = 0, $165 = 0, $17 = 0, $171 = 0, $173 = 0, $174 = 0, $176 = 0, $18 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $19 = 0, $190 = 0, $192 = 0, $195 = 0, $196 = 0, $2 = 0, $20 = 0, $200 = 0, $204 = 0, $207 = 0, $21 = 0, $211 = 0, $214 = 0, $214$phi = 0, $215 = 0, $22 = 0, $222 = 0, $223 = 0, $225 = 0, $229 = 0, $23 = 0, $231 = 0, $236 = 0, $238 = 0, $239 = 0, $24 = 0, $241 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $255 = 0, $257 = 0, $260 = 0, $261 = 0, $265 = 0, $269 = 0, $272 = 0, $276 = 0, $279 = 0, $279$phi = 0, $280 = 0, $287 = 0, $288 = 0, $290 = 0, $294 = 0, $296 = 0, $3 = 0, $301 = 0, $303 = 0, $304 = 0, $306 = 0, $31 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $320 = 0, $322 = 0, $325 = 0, $326 = 0, $333 = 0, $334 = 0, $34 = 0, $340 = 0, $346 = 0, $35 = 0, $354 = 0, $356 = 0, $357 = 0, $360 = 0, $365 = 0, $372 = 0, $373 = 0, $382 = 0, $384 = 0, $394 = 0, $4 = 0, $43 = 0, $44 = 0, $46 = 0, $5 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $6 = 0, $60 = 0, $62 = 0, $65 = 0, $66 = 0, $69 = 0, $7 = 0, $70 = 0, $72 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $86 = 0, $88 = 0, $9 = 0, $91 = 0, $92 = 0, $95 = 0, $96 = 0, $98 = 0, $99 = 0, $__p$0$i$i116 = 0, $__p$0$ph$i$i = 0, $e$0$i124 = 0, $e$0$i124$lcssa153 = 0, $e$0$i33128 = 0, $e$0$i33128$lcssa156 = 0, $e$0$i52132 = 0, $e$0$i52132$lcssa159 = 0, $n$0120 = 0, $n$0120$lcssa = 0, $num$i51 = 0, $t$0$i125 = 0, $t$0$i34129 = 0, $t$0$i53133 = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer4 = 0, dest = 0, sp = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 480 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $vararg_buffer4 = sp + 72 | 0;
 $vararg_buffer1 = sp + 48 | 0;
 $vararg_buffer = sp + 24 | 0;
 $0 = sp;
 $num$i51 = sp + 432 | 0;
 $1 = sp + 408 | 0;
 $2 = sp + 396 | 0;
 $3 = sp + 384 | 0;
 $4 = sp + 360 | 0;
 $5 = sp + 336 | 0;
 $6 = sp + 320 | 0;
 $7 = sp + 308 | 0;
 $8 = sp + 296 | 0;
 $9 = sp + 284 | 0;
 $10 = sp + 272 | 0;
 $11 = sp + 260 | 0;
 $12 = sp + 248 | 0;
 $13 = sp + 236 | 0;
 $14 = sp + 224 | 0;
 $15 = sp + 212 | 0;
 $16 = sp + 200 | 0;
 $17 = sp + 188 | 0;
 $18 = sp + 176 | 0;
 $19 = sp + 152 | 0;
 $20 = sp + 140 | 0;
 $21 = sp + 128 | 0;
 $22 = sp + 116 | 0;
 $23 = sp + 104 | 0;
 $24 = sp + 92 | 0;
 $25 = $last;
 L1 : do if (($25 - $first | 0) > 3) if ((HEAP8[$first >> 0] | 0) == 76) {
  $31 = $first + 1 | 0;
  do switch (HEAP8[$31 >> 0] | 0) {
  case 84:
   {
    $$0 = $first;
    break L1;
    break;
   }
  case 119:
   {
    $34 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($3, 13764, 7);
    $35 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($34, $last, $3, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($3);
    $$0 = ($35 | 0) == ($34 | 0) ? $first : $35;
    break L1;
    break;
   }
  case 98:
   {
    if ((HEAP8[$first + 3 >> 0] | 0) != 69) {
     $$0 = $first;
     break L1;
    }
    switch (HEAP8[$first + 2 >> 0] | 0) {
    case 48:
     {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj6EEERAT__Kc($4, 13772);
      $43 = $db + 4 | 0;
      $44 = HEAP32[$43 >> 2] | 0;
      $46 = HEAP32[$db + 8 >> 2] | 0;
      if ($44 >>> 0 < $46 >>> 0) {
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($44, $4);
       HEAP32[$43 >> 2] = (HEAP32[$43 >> 2] | 0) + 24;
      } else {
       $53 = HEAP32[$db >> 2] | 0;
       $54 = $44 - $53 | 0;
       $55 = ($54 | 0) / 24 | 0;
       $56 = $55 + 1 | 0;
       if (($54 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
       $60 = ($46 - $53 | 0) / 24 | 0;
       if ($60 >>> 0 < 1073741823) {
        $62 = $60 << 1;
        $$0$i$i$i = $62 >>> 0 < $56 >>> 0 ? $56 : $62;
       } else $$0$i$i$i = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i, $55, $db + 12 | 0);
       $65 = $0 + 8 | 0;
       $66 = HEAP32[$65 >> 2] | 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($66, $4);
       HEAP32[$65 >> 2] = $66 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
      }
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($4);
      $$0 = $first + 4 | 0;
      break L1;
      break;
     }
    case 49:
     {
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ILj5EEERAT__Kc($5, 13778);
      $69 = $db + 4 | 0;
      $70 = HEAP32[$69 >> 2] | 0;
      $72 = HEAP32[$db + 8 >> 2] | 0;
      if ($70 >>> 0 < $72 >>> 0) {
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($70, $5);
       HEAP32[$69 >> 2] = (HEAP32[$69 >> 2] | 0) + 24;
      } else {
       $79 = HEAP32[$db >> 2] | 0;
       $80 = $70 - $79 | 0;
       $81 = ($80 | 0) / 24 | 0;
       $82 = $81 + 1 | 0;
       if (($80 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
       $86 = ($72 - $79 | 0) / 24 | 0;
       if ($86 >>> 0 < 1073741823) {
        $88 = $86 << 1;
        $$0$i$i$i26 = $88 >>> 0 < $82 >>> 0 ? $82 : $88;
       } else $$0$i$i$i26 = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($0, $$0$i$i$i26, $81, $db + 12 | 0);
       $91 = $0 + 8 | 0;
       $92 = HEAP32[$91 >> 2] | 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($92, $5);
       HEAP32[$91 >> 2] = $92 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $0);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($0);
      }
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($5);
      $$0 = $first + 4 | 0;
      break L1;
      break;
     }
    default:
     {
      $$0 = $first;
      break L1;
     }
    }
    break;
   }
  case 99:
   {
    $95 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($6, 13783, 4);
    $96 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($95, $last, $6, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($6);
    $$0 = ($96 | 0) == ($95 | 0) ? $first : $96;
    break L1;
    break;
   }
  case 97:
   {
    $98 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($7, 13788, 11);
    $99 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($98, $last, $7, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($7);
    $$0 = ($99 | 0) == ($98 | 0) ? $first : $99;
    break L1;
    break;
   }
  case 104:
   {
    $101 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($8, 13800, 13);
    $102 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($101, $last, $8, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($8);
    $$0 = ($102 | 0) == ($101 | 0) ? $first : $102;
    break L1;
    break;
   }
  case 115:
   {
    $104 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($9, 13814, 5);
    $105 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($104, $last, $9, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($9);
    $$0 = ($105 | 0) == ($104 | 0) ? $first : $105;
    break L1;
    break;
   }
  case 116:
   {
    $107 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($10, 13820, 14);
    $108 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($107, $last, $10, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($10);
    $$0 = ($108 | 0) == ($107 | 0) ? $first : $108;
    break L1;
    break;
   }
  case 105:
   {
    $110 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($11, 13835, 0);
    $111 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($110, $last, $11, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($11);
    $$0 = ($111 | 0) == ($110 | 0) ? $first : $111;
    break L1;
    break;
   }
  case 106:
   {
    $113 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($12, 13836, 1);
    $114 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($113, $last, $12, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($12);
    $$0 = ($114 | 0) == ($113 | 0) ? $first : $114;
    break L1;
    break;
   }
  case 108:
   {
    $116 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($13, 13838, 1);
    $117 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($116, $last, $13, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($13);
    $$0 = ($117 | 0) == ($116 | 0) ? $first : $117;
    break L1;
    break;
   }
  case 109:
   {
    $119 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($14, 13840, 2);
    $120 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($119, $last, $14, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($14);
    $$0 = ($120 | 0) == ($119 | 0) ? $first : $120;
    break L1;
    break;
   }
  case 120:
   {
    $122 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($15, 13843, 2);
    $123 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($122, $last, $15, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($15);
    $$0 = ($123 | 0) == ($122 | 0) ? $first : $123;
    break L1;
    break;
   }
  case 121:
   {
    $125 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($16, 13846, 3);
    $126 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($125, $last, $16, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($16);
    $$0 = ($126 | 0) == ($125 | 0) ? $first : $126;
    break L1;
    break;
   }
  case 110:
   {
    $128 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($17, 13850, 8);
    $129 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($128, $last, $17, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($17);
    $$0 = ($129 | 0) == ($128 | 0) ? $first : $129;
    break L1;
    break;
   }
  case 111:
   {
    $131 = $first + 2 | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($18, 13859, 17);
    $132 = __ZN10__cxxabiv112_GLOBAL__N_121parse_integer_literalINS0_2DbEEEPKcS4_S4_RKNT_6StringERS5_($131, $last, $18, $db) | 0;
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($18);
    $$0 = ($132 | 0) == ($131 | 0) ? $first : $132;
    break L1;
    break;
   }
  case 102:
   {
    $134 = $first + 2 | 0;
    L67 : do if (($25 - $134 | 0) >>> 0 > 8) {
     $138 = $first + 10 | 0;
     $141 = HEAP8[$134 >> 0] | 0;
     $148 = $first;
     $e$0$i124 = $0;
     $t$0$i125 = $134;
     while (1) {
      if (!(_isxdigit($141 << 24 >> 24) | 0)) {
       $$0$i = $134;
       break L67;
      }
      $145 = HEAP8[$t$0$i125 >> 0] | 0;
      $149 = HEAP8[$148 + 3 >> 0] | 0;
      HEAP8[$e$0$i124 >> 0] = ((($149 << 24 >> 24) + -48 | 0) >>> 0 < 10 ? 208 : 169) + ($149 & 255) + ((($145 + -48 | 0) >>> 0 < 10 ? 0 : 9) + $145 << 4);
      $156 = $t$0$i125 + 2 | 0;
      $157 = $e$0$i124 + 1 | 0;
      $159 = HEAP8[$156 >> 0] | 0;
      if (($156 | 0) == ($138 | 0)) {
       $$lcssa154 = $157;
       $$lcssa155 = $159;
       $e$0$i124$lcssa153 = $e$0$i124;
       break;
      } else {
       $148$phi = $t$0$i125;
       $141 = $159;
       $e$0$i124 = $157;
       $t$0$i125 = $156;
       $148 = $148$phi;
      }
     }
     if ($$lcssa155 << 24 >> 24 == 69) {
      if (($0 | 0) != ($$lcssa154 | 0) & $0 >>> 0 < $e$0$i124$lcssa153 >>> 0) {
       $$01$i$i$i122 = $0;
       $165 = $e$0$i124$lcssa153;
       do {
        $163 = HEAP8[$$01$i$i$i122 >> 0] | 0;
        HEAP8[$$01$i$i$i122 >> 0] = HEAP8[$165 >> 0] | 0;
        HEAP8[$165 >> 0] = $163;
        $$01$i$i$i122 = $$01$i$i$i122 + 1 | 0;
        $165 = $165 + -1 | 0;
       } while ($$01$i$i$i122 >>> 0 < $165 >>> 0);
      }
      dest = $num$i51;
      stop = dest + 24 | 0;
      do {
       HEAP8[dest >> 0] = 0;
       dest = dest + 1 | 0;
      } while ((dest | 0) < (stop | 0));
      HEAPF64[$vararg_buffer >> 3] = +HEAPF32[$0 >> 2];
      $171 = _snprintf($num$i51, 24, 13877, $vararg_buffer) | 0;
      if ($171 >>> 0 > 23) $$0$i = $134; else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($2, $num$i51, $171);
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
       $173 = $db + 4 | 0;
       $174 = HEAP32[$173 >> 2] | 0;
       $176 = HEAP32[$db + 8 >> 2] | 0;
       if ($174 >>> 0 < $176 >>> 0) {
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($174, $1);
        HEAP32[$173 >> 2] = (HEAP32[$173 >> 2] | 0) + 24;
       } else {
        $183 = HEAP32[$db >> 2] | 0;
        $184 = $174 - $183 | 0;
        $185 = ($184 | 0) / 24 | 0;
        $186 = $185 + 1 | 0;
        if (($184 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
        $190 = ($176 - $183 | 0) / 24 | 0;
        if ($190 >>> 0 < 1073741823) {
         $192 = $190 << 1;
         $$0$i$i$i$i = $192 >>> 0 < $186 >>> 0 ? $186 : $192;
        } else $$0$i$i$i$i = 2147483647;
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($vararg_buffer, $$0$i$i$i$i, $185, $db + 12 | 0);
        $195 = $vararg_buffer + 8 | 0;
        $196 = HEAP32[$195 >> 2] | 0;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($196, $1);
        HEAP32[$195 >> 2] = $196 + 24;
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $vararg_buffer);
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($vararg_buffer);
       }
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
       $$0$i = $first + 11 | 0;
      }
     } else $$0$i = $134;
    } else $$0$i = $134; while (0);
    $$0 = ($$0$i | 0) == ($134 | 0) ? $first : $$0$i;
    break L1;
    break;
   }
  case 100:
   {
    $200 = $first + 2 | 0;
    L91 : do if (($25 - $200 | 0) >>> 0 > 16) {
     $204 = $first + 18 | 0;
     $207 = HEAP8[$200 >> 0] | 0;
     $214 = $first;
     $e$0$i33128 = $0;
     $t$0$i34129 = $200;
     while (1) {
      if (!(_isxdigit($207 << 24 >> 24) | 0)) {
       $$0$i49 = $200;
       break L91;
      }
      $211 = HEAP8[$t$0$i34129 >> 0] | 0;
      $215 = HEAP8[$214 + 3 >> 0] | 0;
      HEAP8[$e$0$i33128 >> 0] = ((($215 << 24 >> 24) + -48 | 0) >>> 0 < 10 ? 208 : 169) + ($215 & 255) + ((($211 + -48 | 0) >>> 0 < 10 ? 0 : 9) + $211 << 4);
      $222 = $t$0$i34129 + 2 | 0;
      $223 = $e$0$i33128 + 1 | 0;
      $225 = HEAP8[$222 >> 0] | 0;
      if (($222 | 0) == ($204 | 0)) {
       $$lcssa157 = $223;
       $$lcssa158 = $225;
       $e$0$i33128$lcssa156 = $e$0$i33128;
       break;
      } else {
       $214$phi = $t$0$i34129;
       $207 = $225;
       $e$0$i33128 = $223;
       $t$0$i34129 = $222;
       $214 = $214$phi;
      }
     }
     if ($$lcssa158 << 24 >> 24 == 69) {
      if (($0 | 0) != ($$lcssa157 | 0) & $0 >>> 0 < $e$0$i33128$lcssa156 >>> 0) {
       $$01$i$i$i41126 = $0;
       $231 = $e$0$i33128$lcssa156;
       do {
        $229 = HEAP8[$$01$i$i$i41126 >> 0] | 0;
        HEAP8[$$01$i$i$i41126 >> 0] = HEAP8[$231 >> 0] | 0;
        HEAP8[$231 >> 0] = $229;
        $$01$i$i$i41126 = $$01$i$i$i41126 + 1 | 0;
        $231 = $231 + -1 | 0;
       } while ($$01$i$i$i41126 >>> 0 < $231 >>> 0);
      }
      dest = $num$i51;
      stop = dest + 32 | 0;
      do {
       HEAP8[dest >> 0] = 0;
       dest = dest + 1 | 0;
      } while ((dest | 0) < (stop | 0));
      HEAPF64[$vararg_buffer1 >> 3] = +HEAPF64[$0 >> 3];
      $236 = _snprintf($num$i51, 32, 13881, $vararg_buffer1) | 0;
      if ($236 >>> 0 > 31) $$0$i49 = $200; else {
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($2, $num$i51, $236);
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
       $238 = $db + 4 | 0;
       $239 = HEAP32[$238 >> 2] | 0;
       $241 = HEAP32[$db + 8 >> 2] | 0;
       if ($239 >>> 0 < $241 >>> 0) {
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($239, $1);
        HEAP32[$238 >> 2] = (HEAP32[$238 >> 2] | 0) + 24;
       } else {
        $248 = HEAP32[$db >> 2] | 0;
        $249 = $239 - $248 | 0;
        $250 = ($249 | 0) / 24 | 0;
        $251 = $250 + 1 | 0;
        if (($249 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
        $255 = ($241 - $248 | 0) / 24 | 0;
        if ($255 >>> 0 < 1073741823) {
         $257 = $255 << 1;
         $$0$i$i$i$i46 = $257 >>> 0 < $251 >>> 0 ? $251 : $257;
        } else $$0$i$i$i$i46 = 2147483647;
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($vararg_buffer1, $$0$i$i$i$i46, $250, $db + 12 | 0);
        $260 = $vararg_buffer1 + 8 | 0;
        $261 = HEAP32[$260 >> 2] | 0;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($261, $1);
        HEAP32[$260 >> 2] = $261 + 24;
        __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $vararg_buffer1);
        __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($vararg_buffer1);
       }
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
       $$0$i49 = $first + 19 | 0;
      }
     } else $$0$i49 = $200;
    } else $$0$i49 = $200; while (0);
    $$0 = ($$0$i49 | 0) == ($200 | 0) ? $first : $$0$i49;
    break L1;
    break;
   }
  case 101:
   {
    $265 = $first + 2 | 0;
    L115 : do if (($25 - $265 | 0) >>> 0 > 20) {
     $269 = $first + 22 | 0;
     $272 = HEAP8[$265 >> 0] | 0;
     $279 = $first;
     $e$0$i52132 = $0;
     $t$0$i53133 = $265;
     while (1) {
      if (!(_isxdigit($272 << 24 >> 24) | 0)) {
       $$1$i = $265;
       break L115;
      }
      $276 = HEAP8[$t$0$i53133 >> 0] | 0;
      $280 = HEAP8[$279 + 3 >> 0] | 0;
      HEAP8[$e$0$i52132 >> 0] = ((($280 << 24 >> 24) + -48 | 0) >>> 0 < 10 ? 208 : 169) + ($280 & 255) + ((($276 + -48 | 0) >>> 0 < 10 ? 0 : 9) + $276 << 4);
      $287 = $t$0$i53133 + 2 | 0;
      $288 = $e$0$i52132 + 1 | 0;
      $290 = HEAP8[$287 >> 0] | 0;
      if (($287 | 0) == ($269 | 0)) {
       $$lcssa160 = $288;
       $$lcssa161 = $290;
       $e$0$i52132$lcssa159 = $e$0$i52132;
       break;
      } else {
       $279$phi = $t$0$i53133;
       $272 = $290;
       $e$0$i52132 = $288;
       $t$0$i53133 = $287;
       $279 = $279$phi;
      }
     }
     if ($$lcssa161 << 24 >> 24 == 69) {
      if (($0 | 0) != ($$lcssa160 | 0) & $0 >>> 0 < $e$0$i52132$lcssa159 >>> 0) {
       $$01$i$i$i57130 = $0;
       $296 = $e$0$i52132$lcssa159;
       do {
        $294 = HEAP8[$$01$i$i$i57130 >> 0] | 0;
        HEAP8[$$01$i$i$i57130 >> 0] = HEAP8[$296 >> 0] | 0;
        HEAP8[$296 >> 0] = $294;
        $$01$i$i$i57130 = $$01$i$i$i57130 + 1 | 0;
        $296 = $296 + -1 | 0;
       } while ($$01$i$i$i57130 >>> 0 < $296 >>> 0);
      }
      dest = $num$i51;
      stop = dest + 40 | 0;
      do {
       HEAP8[dest >> 0] = 0;
       dest = dest + 1 | 0;
      } while ((dest | 0) < (stop | 0));
      HEAPF64[$vararg_buffer4 >> 3] = +HEAPF64[$0 >> 3];
      $301 = _snprintf($num$i51, 40, 13884, $vararg_buffer4) | 0;
      if ($301 >>> 0 > 39) {
       $$1$i = $265;
       break;
      }
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6__initEPKcj($2, $num$i51, $301);
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($1, $2);
      $303 = $db + 4 | 0;
      $304 = HEAP32[$303 >> 2] | 0;
      $306 = HEAP32[$db + 8 >> 2] | 0;
      if ($304 >>> 0 < $306 >>> 0) {
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($304, $1);
       HEAP32[$303 >> 2] = (HEAP32[$303 >> 2] | 0) + 24;
      } else {
       $313 = HEAP32[$db >> 2] | 0;
       $314 = $304 - $313 | 0;
       $315 = ($314 | 0) / 24 | 0;
       $316 = $315 + 1 | 0;
       if (($314 | 0) < -24) __ZNKSt3__120__vector_base_commonILb1EE20__throw_length_errorEv($db);
       $320 = ($306 - $313 | 0) / 24 | 0;
       if ($320 >>> 0 < 1073741823) {
        $322 = $320 << 1;
        $$0$i$i$i$i62 = $322 >>> 0 < $316 >>> 0 ? $316 : $322;
       } else $$0$i$i$i$i62 = 2147483647;
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEEC2EjjS6_($vararg_buffer4, $$0$i$i$i$i62, $315, $db + 12 | 0);
       $325 = $vararg_buffer4 + 8 | 0;
       $326 = HEAP32[$325 >> 2] | 0;
       __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2EOS1_($326, $1);
       HEAP32[$325 >> 2] = $326 + 24;
       __ZNSt3__16vectorIN10__cxxabiv112_GLOBAL__N_111string_pairENS2_11short_allocIS3_Lj4096EEEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($db, $vararg_buffer4);
       __ZNSt3__114__split_bufferIN10__cxxabiv112_GLOBAL__N_111string_pairERNS2_11short_allocIS3_Lj4096EEEED2Ev($vararg_buffer4);
      }
      __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($1);
      __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($2);
      $$1$i = $first + 23 | 0;
     } else $$1$i = $265;
    } else $$1$i = $265; while (0);
    $$0 = ($$1$i | 0) == ($265 | 0) ? $first : $$1$i;
    break L1;
    break;
   }
  case 95:
   {
    if ((HEAP8[$first + 2 >> 0] | 0) != 90) {
     $$0 = $first;
     break L1;
    }
    $333 = $first + 3 | 0;
    $334 = __ZN10__cxxabiv112_GLOBAL__N_114parse_encodingINS0_2DbEEEPKcS4_S4_RT_($333, $last, $db) | 0;
    if (($334 | 0) == ($333 | 0) | ($334 | 0) == ($last | 0)) {
     $$0 = $first;
     break L1;
    }
    STACKTOP = sp;
    return ((HEAP8[$334 >> 0] | 0) == 69 ? $334 + 1 | 0 : $first) | 0;
   }
  default:
   {
    $340 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($31, $last, $db) | 0;
    if (($340 | 0) == ($31 | 0) | ($340 | 0) == ($last | 0)) {
     $$0 = $first;
     break L1;
    }
    if ((HEAP8[$340 >> 0] | 0) == 69) {
     $$0 = $340 + 1 | 0;
     break L1;
    }
    if (($340 | 0) == ($last | 0)) {
     $$0 = $first;
     break L1;
    } else $n$0120 = $340;
    while (1) {
     $346 = HEAP8[$n$0120 >> 0] | 0;
     if ((($346 << 24 >> 24) + -48 | 0) >>> 0 >= 10) {
      $$lcssa = $346;
      $n$0120$lcssa = $n$0120;
      break;
     }
     $n$0120 = $n$0120 + 1 | 0;
     if (($n$0120 | 0) == ($last | 0)) {
      $$0 = $first;
      break L1;
     }
    }
    if (!(($n$0120$lcssa | 0) != ($340 | 0) & $$lcssa << 24 >> 24 == 69)) {
     $$0 = $first;
     break L1;
    }
    $354 = HEAP32[$db + 4 >> 2] | 0;
    if ((HEAP32[$db >> 2] | 0) == ($354 | 0)) {
     $$0 = $first;
     break L1;
    }
    $356 = $354 + -24 | 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($23, $356);
    $357 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($23, 0, 12714) | 0;
    HEAP32[$22 >> 2] = HEAP32[$357 >> 2];
    HEAP32[$22 + 4 >> 2] = HEAP32[$357 + 4 >> 2];
    HEAP32[$22 + 8 >> 2] = HEAP32[$357 + 8 >> 2];
    HEAP32[$357 >> 2] = 0;
    HEAP32[$357 + 4 >> 2] = 0;
    HEAP32[$357 + 8 >> 2] = 0;
    $360 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKc($22, 12619) | 0;
    HEAP32[$21 >> 2] = HEAP32[$360 >> 2];
    HEAP32[$21 + 4 >> 2] = HEAP32[$360 + 4 >> 2];
    HEAP32[$21 + 8 >> 2] = HEAP32[$360 + 8 >> 2];
    HEAP32[$360 >> 2] = 0;
    HEAP32[$360 + 4 >> 2] = 0;
    HEAP32[$360 + 8 >> 2] = 0;
    $365 = $n$0120$lcssa - $340 | 0;
    if ($365 >>> 0 > 4294967279) __ZNKSt3__121__basic_string_commonILb1EE20__throw_length_errorEv($24);
    if ($365 >>> 0 < 11) {
     HEAP8[$24 >> 0] = $365 << 1;
     $__p$0$ph$i$i = $24 + 1 | 0;
    } else {
     $372 = $365 + 16 & -16;
     $373 = _malloc($372) | 0;
     HEAP32[$24 + 8 >> 2] = $373;
     HEAP32[$24 >> 2] = $372 | 1;
     HEAP32[$24 + 4 >> 2] = $365;
     $__p$0$ph$i$i = $373;
    }
    if (($340 | 0) != ($n$0120$lcssa | 0)) {
     $$0$i$i117 = $340;
     $__p$0$i$i116 = $__p$0$ph$i$i;
     while (1) {
      HEAP8[$__p$0$i$i116 >> 0] = HEAP8[$$0$i$i117 >> 0] | 0;
      $$0$i$i117 = $$0$i$i117 + 1 | 0;
      if (($$0$i$i117 | 0) == ($n$0120$lcssa | 0)) break; else $__p$0$i$i116 = $__p$0$i$i116 + 1 | 0;
     }
    }
    HEAP8[$__p$0$ph$i$i + $365 >> 0] = 0;
    $382 = HEAP8[$24 >> 0] | 0;
    $384 = ($382 & 1) == 0;
    $394 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6appendEPKcj($21, $384 ? $24 + 1 | 0 : HEAP32[$24 + 8 >> 2] | 0, $384 ? ($382 & 255) >>> 1 : HEAP32[$24 + 4 >> 2] | 0) | 0;
    HEAP32[$20 >> 2] = HEAP32[$394 >> 2];
    HEAP32[$20 + 4 >> 2] = HEAP32[$394 + 4 >> 2];
    HEAP32[$20 + 8 >> 2] = HEAP32[$394 + 8 >> 2];
    HEAP32[$394 >> 2] = 0;
    HEAP32[$394 + 4 >> 2] = 0;
    HEAP32[$394 + 8 >> 2] = 0;
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairC2ENSt3__112basic_stringIcNS2_11char_traitsIcEENS0_12malloc_allocIcEEEE($19, $20);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairaSEOS1_($356, $19);
    __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($19);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($20);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($24);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($21);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($22);
    __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEED2Ev($23);
    $$0 = $n$0120$lcssa + 1 | 0;
    break L1;
   }
  } while (0);
 } else $$0 = $first; else $$0 = $first; while (0);
 STACKTOP = sp;
 return $$0 | 0;
}

function __ZN10__cxxabiv112_GLOBAL__N_114parse_encodingINS0_2DbEEEPKcS4_S4_RT_($first, $last, $db) {
 $first = $first | 0;
 $last = $last | 0;
 $db = $db | 0;
 var $$0$i = 0, $$24$ph = 0, $$7 = 0, $$in = 0, $$in109 = 0, $$lcssa150 = 0, $$lcssa151 = 0, $$lcssa156 = 0, $$ph96 = 0, $$pre$i$i$i$i = 0, $0 = 0, $1 = 0, $10 = 0, $101 = 0, $111 = 0, $118 = 0, $120 = 0, $123 = 0, $127 = 0, $13 = 0, $130 = 0, $135 = 0, $136 = 0, $139 = 0, $140 = 0, $142 = 0, $143 = 0, $152 = 0, $155 = 0, $160 = 0, $162 = 0, $166 = 0, $171 = 0, $175 = 0, $176 = 0, $18 = 0, $180 = 0, $183 = 0, $184 = 0, $188 = 0, $191 = 0, $193 = 0, $195 = 0, $199 = 0, $2 = 0, $203 = 0, $204 = 0, $206 = 0, $207 = 0, $209 = 0, $21 = 0, $215 = 0, $22 = 0, $226 = 0, $228 = 0, $240 = 0, $252 = 0, $255 = 0, $257 = 0, $26 = 0, $264 = 0, $267 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $277 = 0, $281 = 0, $284 = 0, $287 = 0, $29 = 0, $3 = 0, $30 = 0, $303 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $318 = 0, $320 = 0, $331 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $345 = 0, $347 = 0, $349 = 0, $350 = 0, $356 = 0, $361 = 0, $37 = 0, $371 = 0, $373 = 0, $38 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $389 = 0, $392 = 0, $398 = 0, $4 = 0, $402 = 0, $404 = 0, $405 = 0, $411 = 0, $413 = 0, $414 = 0, $42 = 0, $434 = 0, $436 = 0, $446 = 0, $45 = 0, $46 = 0, $50 = 0, $53 = 0, $54 = 0, $56 = 0, $58 = 0, $6 = 0, $62 = 0, $65 = 0, $66 = 0, $68 = 0, $7 = 0, $73 = 0, $74 = 0, $76 = 0, $77 = 0, $8 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $9 = 0, $90 = 0, $91 = 0, $94 = 0, $99 = 0, $first_arg$0$off0$ph = 0, $first_arg$3$off0$ph = 0, $k$0121 = 0, $k2$0122 = 0, $left$i = 0, $phitmp$i$i$i$i$i$i = 0, $phitmp$i2$i$i$i$i$i = 0, $ret1 = 0, $ret2 = 0, $t$0 = 0, $t$1 = 0, $t$1$ph = 0, $t$2 = 0, $tmp = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 if ((STACKTOP | 0) >= (STACK_MAX | 0)) abort();
 $left$i = sp + 96 | 0;
 $0 = sp + 84 | 0;
 $1 = sp + 72 | 0;
 $2 = sp + 60 | 0;
 $3 = sp + 48 | 0;
 $ret2 = sp + 36 | 0;
 $ret1 = sp + 24 | 0;
 $tmp = sp + 12 | 0;
 $4 = sp;
 L1 : do if (($first | 0) == ($last | 0)) $$7 = $first; else {
  $6 = $db + 56 | 0;
  $7 = HEAP32[$6 >> 2] | 0;
  $8 = $7 + 1 | 0;
  HEAP32[$6 >> 2] = $8;
  $9 = $db + 61 | 0;
  $10 = HEAP8[$9 >> 0] | 0;
  if ($8 >>> 0 > 1) HEAP8[$9 >> 0] = 1;
  $13 = HEAP8[$first >> 0] | 0;
  L6 : do switch ($13 | 0) {
  case 84:
  case 71:
   {
    L107 : do if (($last - $first | 0) > 2) {
     switch ($13 | 0) {
     case 84:
      break;
     case 71:
      {
       switch (HEAP8[$first + 1 >> 0] | 0) {
       case 86:
        {
         $175 = $first + 2 | 0;
         $176 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($175, $last, $db) | 0;
         if (($176 | 0) == ($175 | 0)) {
          $$0$i = $first;
          break L107;
         }
         $180 = HEAP32[$db + 4 >> 2] | 0;
         if ((HEAP32[$db >> 2] | 0) == ($180 | 0)) {
          $$0$i = $first;
          break L107;
         }
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($180 + -24 | 0, 0, 14547) | 0;
         $$0$i = $176;
         break L107;
         break;
        }
       case 82:
        {
         $183 = $first + 2 | 0;
         $184 = __ZN10__cxxabiv112_GLOBAL__N_110parse_nameINS0_2DbEEEPKcS4_S4_RT_($183, $last, $db) | 0;
         if (($184 | 0) == ($183 | 0)) {
          $$0$i = $first;
          break L107;
         }
         $188 = HEAP32[$db + 4 >> 2] | 0;
         if ((HEAP32[$db >> 2] | 0) == ($188 | 0)) {
          $$0$i = $first;
          break L107;
         }
         __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($188 + -24 | 0, 0, 14567) | 0;
         $$0$i = $184;
         break L107;
         break;
        }
       default:
        {
         $$0$i = $first;
         break L107;
        }
       }
       break;
      }
     default:
      {
       $$0$i = $first;
       break L107;
      }
     }
     $18 = $first + 1 | 0;
     switch (HEAP8[$18 >> 0] | 0) {
     case 86:
      {
       $21 = $first + 2 | 0;
       $22 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($21, $last, $db) | 0;
       if (($22 | 0) == ($21 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $26 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($26 | 0)) {
        $$0$i = $first;
        break L107;
       }
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($26 + -24 | 0, 0, 14396) | 0;
       $$0$i = $22;
       break L107;
       break;
      }
     case 84:
      {
       $29 = $first + 2 | 0;
       $30 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($29, $last, $db) | 0;
       if (($30 | 0) == ($29 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $34 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($34 | 0)) {
        $$0$i = $first;
        break L107;
       }
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($34 + -24 | 0, 0, 14408) | 0;
       $$0$i = $30;
       break L107;
       break;
      }
     case 73:
      {
       $37 = $first + 2 | 0;
       $38 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($37, $last, $db) | 0;
       if (($38 | 0) == ($37 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $42 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($42 | 0)) {
        $$0$i = $first;
        break L107;
       }
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($42 + -24 | 0, 0, 14417) | 0;
       $$0$i = $38;
       break L107;
       break;
      }
     case 83:
      {
       $45 = $first + 2 | 0;
       $46 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($45, $last, $db) | 0;
       if (($46 | 0) == ($45 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $50 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($50 | 0)) {
        $$0$i = $first;
        break L107;
       }
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($50 + -24 | 0, 0, 14431) | 0;
       $$0$i = $46;
       break L107;
       break;
      }
     case 99:
      {
       $53 = $first + 2 | 0;
       $54 = __ZN10__cxxabiv112_GLOBAL__N_117parse_call_offsetEPKcS2_($53, $last) | 0;
       if (($54 | 0) == ($53 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $56 = __ZN10__cxxabiv112_GLOBAL__N_117parse_call_offsetEPKcS2_($54, $last) | 0;
       if (($56 | 0) == ($54 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $58 = __ZN10__cxxabiv112_GLOBAL__N_114parse_encodingINS0_2DbEEEPKcS4_S4_RT_($56, $last, $db) | 0;
       if (($58 | 0) == ($56 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $62 = HEAP32[$db + 4 >> 2] | 0;
       if ((HEAP32[$db >> 2] | 0) == ($62 | 0)) {
        $$0$i = $first;
        break L107;
       }
       __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($62 + -24 | 0, 0, 14450) | 0;
       $$0$i = $58;
       break L107;
       break;
      }
     case 67:
      {
       $65 = $first + 2 | 0;
       $66 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($65, $last, $db) | 0;
       if (($66 | 0) == ($65 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $68 = __ZN10__cxxabiv112_GLOBAL__N_112parse_numberEPKcS2_($66, $last) | 0;
       if (($68 | 0) == ($66 | 0) | ($68 | 0) == ($last | 0)) {
        $$0$i = $first;
        break L107;
       }
       if ((HEAP8[$68 >> 0] | 0) != 95) {
        $$0$i = $first;
        break L107;
       }
       $73 = $68 + 1 | 0;
       $74 = __ZN10__cxxabiv112_GLOBAL__N_110parse_typeINS0_2DbEEEPKcS4_S4_RT_($73, $last, $db) | 0;
       if (($74 | 0) == ($73 | 0)) {
        $$0$i = $first;
        break L107;
       }
       $76 = $db + 4 | 0;
       $77 = HEAP32[$76 >> 2] | 0;
       if ((($77 - (HEAP32[$db >> 2] | 0) | 0) / 24 | 0) >>> 0 < 2) {
        $$0$i = $first;
        break L107;
       }
       __ZN10__cxxabiv112_GLOBAL__N_111string_pair9move_fullEv($left$i, $77 + -24 | 0);
       $85 = HEAP32[$76 >> 2] | 0;
       $86 = $85 + -24 | 0;
       $88 = $85;
       do {
        $87 = $88 + -24 | 0;
        HEAP32[$76 >> 2] = $87;
        __ZN10__cxxabiv112_GLOBAL__N_111string_pairD2Ev($87);
        $88 = HEAP32[$76 >> 2] | 0;
       } while (($88 | 0) != ($86 | 0));
       $90 = $85 + -48 | 0;
       $91 = __ZNSt3__112basic_stringIcNS_11char_traitsIcEEN10__cxxabiv112_GLOBAL__N_112malloc_allocIcEEE6insertEjPKc($left$i, 0, 14477) | 0;
       HEAP32[$2 >> 2] = HEAP32[$91 >> 2];
       HEAP32[$2 + 4 >> 2] = HEAP32[$91 + 4 >> 2];
       HEAP32[$2 + 8 >> 2] = HEAP32[$91 + 8 >> 2];
       HEAP32[$91 >> 2] = 0;
   