/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumn;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumnGroup;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClasses(value={@JsxClass(domClass=HtmlTableColumn.class), @JsxClass(domClass=HtmlTableColumnGroup.class)})
public class HTMLTableColElement
extends HTMLTableComponent {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLTableColElement() {
    }

    @JsxGetter
    public int getSpan() {
        int i;
        String span = this.getDomNodeOrDie().getAttribute("span");
        try {
            i = Integer.parseInt(span);
            if (i < 1) {
                i = 1;
            }
        }
        catch (NumberFormatException e) {
            i = 1;
        }
        return i;
    }

    @JsxSetter
    public void setSpan(Object span) {
        double d = Context.toNumber(span);
        int i = (int)d;
        if (i < 1) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SPAN_THROWS_EXCEPTION_IF_INVALID)) {
                Exception e = new Exception("Cannot set the span property to invalid value: " + span);
                Context.throwAsScriptRuntimeEx(e);
            } else {
                i = 1;
            }
        }
        this.getDomNodeOrDie().setAttribute("span", Integer.toString(i));
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_COLUMN_WIDTH_NO_NEGATIVE_VALUES);
        Boolean returnNegativeValues = ie ? Boolean.FALSE : null;
        return this.getWidthOrHeight("width", returnNegativeValues);
    }

    @JsxSetter
    public void setWidth(Object width) {
        String value = width == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_COLUMN_WIDTH_NULL_STRING) ? "" : Context.toString(width);
        this.setWidthOrHeight("width", value, false);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.getDomNodeOrDie() instanceof HtmlTableColumn;
    }

    @Override
    public void setOuterHTML(Object value) {
        throw Context.reportRuntimeError("outerHTML is read-only for tag '" + this.getDomNodeOrDie().getNodeName() + "'");
    }
}

