/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObjectImpl;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormChild;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeJavaObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Wrapper;

@JsxClass(domClass=HtmlObject.class)
public class HTMLObjectElement
extends FormChild
implements Wrapper {
    private Scriptable wrappedActiveX_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLObjectElement() {
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getClassid() {
        String classid = this.getDomNodeOrDie().getAttribute("classid");
        return classid;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setClassid(String classid) {
        this.getDomNodeOrDie().setAttribute("classid", classid);
        if (classid.indexOf(58) != -1 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_OBJECT_CLASSID)) {
            String xClassString;
            WebClient webClient = this.getWindow().getWebWindow().getWebClient();
            Map<String, String> map = webClient.getActiveXObjectMap();
            if (map != null && (xClassString = map.get(classid)) != null) {
                try {
                    Class<?> xClass = Class.forName(xClassString);
                    Object object = xClass.newInstance();
                    boolean contextCreated = false;
                    if (Context.getCurrentContext() == null) {
                        new HtmlUnitContextFactory(webClient).enterContext();
                        contextCreated = true;
                    }
                    this.wrappedActiveX_ = Context.toObject(object, this.getParentScope());
                    if (contextCreated) {
                        Context.exit();
                    }
                }
                catch (Exception e) {
                    throw Context.reportRuntimeError("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + ".");
                }
                return;
            }
            if (webClient.getOptions().isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
                try {
                    this.wrappedActiveX_ = new ActiveXObjectImpl(classid);
                    this.wrappedActiveX_.setParentScope(this.getParentScope());
                }
                catch (Exception e) {
                    Context.throwAsScriptRuntimeEx(e);
                }
            }
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this.wrappedActiveX_ instanceof NativeJavaObject) {
            NativeJavaObject obj = (NativeJavaObject)this.wrappedActiveX_;
            Object result = obj.get(name, start);
            if (Scriptable.NOT_FOUND != result) {
                return result;
            }
            return super.get(name, start);
        }
        if (this.wrappedActiveX_ != null) {
            return this.wrappedActiveX_.get(name, start);
        }
        return super.get(name, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.wrappedActiveX_ instanceof NativeJavaObject) {
            if (this.wrappedActiveX_.has(name, start)) {
                this.wrappedActiveX_.put(name, start, value);
            } else {
                super.put(name, start, value);
            }
            return;
        }
        if (this.wrappedActiveX_ != null) {
            this.wrappedActiveX_.put(name, start, value);
            return;
        }
        super.put(name, start, value);
    }

    @Override
    public Object unwrap() {
        if (this.wrappedActiveX_ instanceof Wrapper) {
            return ((Wrapper)((Object)this.wrappedActiveX_)).unwrap();
        }
        return this.wrappedActiveX_;
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", Boolean.TRUE);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.setWidthOrHeight("height", height, true);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttribute("name");
    }

    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }
}

