/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.FF)}), @JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.EDGE)})})
public class ClientRectList
extends SimpleScriptable {
    private final List<ClientRect> clientRects_ = new ArrayList<ClientRect>();

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.EDGE)})
    public ClientRectList() {
    }

    @JsxGetter
    public int getLength() {
        return this.clientRects_.size();
    }

    @Override
    public final Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        return NOT_FOUND;
    }

    @JsxFunction
    public ClientRect item(int index) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTRECTLIST_THROWS_IF_ITEM_NOT_FOUND)) {
            throw Context.reportRuntimeError("Invalid index '" + index + "'");
        }
        return null;
    }

    public void add(ClientRect clientRect) {
        this.clientRects_.add(clientRect);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class == hint && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTRECTLIST_DEFAUL_VALUE_FROM_FIRST)) {
            if (this.clientRects_.size() > 0) {
                return this.clientRects_.get(0).getDefaultValue(hint);
            }
            return "";
        }
        return super.getDefaultValue(hint);
    }
}

