/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.svg.SvgElementFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.htmlunit.cyberneko.HTMLConfiguration;
import net.sourceforge.htmlunit.cyberneko.HTMLElements;
import net.sourceforge.htmlunit.cyberneko.HTMLEventInfo;
import net.sourceforge.htmlunit.cyberneko.HTMLTagBalancingListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final ElementFactory SVG_FACTORY = new SvgElementFactory();
    private static final Map<String, ElementFactory> ELEMENT_FACTORIES = new HashMap<String, ElementFactory>();

    private HTMLParser() {
    }

    public static void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        HTMLParser.parseFragment(parent, parent, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFragment(DomNode parent, DomNode context, String source) throws SAXException, IOException {
        HtmlPage page = (HtmlPage)parent.getPage();
        URL url = page.getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(parent, url, source);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        ArrayList<QName> ancestors = new ArrayList<QName>();
        for (DomNode node = context; node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            ancestors.add(0, new QName(null, node.getNodeName(), null, null));
        }
        if (ancestors.isEmpty() || !"html".equals(((QName)ancestors.get((int)0)).localpart)) {
            ancestors.add(0, new QName(null, "html", null, null));
        }
        if (ancestors.size() == 1 || !"body".equals(((QName)ancestors.get((int)1)).localpart)) {
            ancestors.add(1, new QName(null, "body", null, null));
        }
        domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
        domBuilder.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", ancestors.toArray(new QName[0]));
        XMLInputSource in = new XMLInputSource(null, url.toString(), null, new StringReader(source), null);
        page.registerParsingStart();
        page.registerSnippetParsingStart();
        try {
            domBuilder.parse(in);
        }
        finally {
            page.registerParsingEnd();
            page.registerSnippetParsingEnd();
        }
    }

    public static HtmlPage parseHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlPage page = new HtmlPage(webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page, false);
        return page;
    }

    public static XHtmlPage parseXHtml(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XHtmlPage page = new XHtmlPage(webResponse, webWindow);
        HTMLParser.parse(webResponse, webWindow, page, true);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(WebResponse webResponse, WebWindow webWindow, HtmlPage page, boolean xhtml) throws IOException {
        webWindow.setEnclosedPage(page);
        URL url = webResponse.getWebRequest().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(page, url, null);
        String charset = webResponse.getContentCharsetOrNull();
        try {
            if (charset != null) {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
            } else {
                String specifiedCharset = webResponse.getWebRequest().getCharset();
                if (specifiedCharset != null) {
                    charset = specifiedCharset;
                }
            }
            if (xhtml) {
                domBuilder.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
            }
        }
        catch (Exception e) {
            throw new ObjectInstantiationException("Error setting HTML parser feature", e);
        }
        try (InputStream content = webResponse.getContentAsStream();){
            XMLInputSource in = new XMLInputSource(null, url.toString(), null, content, charset);
            page.registerParsingStart();
            try {
                domBuilder.parse(in);
            }
            catch (XNIException e) {
                Throwable origin = HTMLParser.extractNestedException(e);
                throw new RuntimeException("Failed parsing content from " + url, origin);
            }
        }
        finally {
            page.registerParsingEnd();
        }
        HTMLParser.addBodyToPageIfNecessary(page, true, domBuilder.body_ != null);
    }

    private static void addBodyToPageIfNecessary(HtmlPage page, boolean originalCall, boolean checkInsideFrameOnly) {
        boolean waitToLoad = page.hasFeature(BrowserVersionFeatures.PAGE_WAIT_LOAD_BEFORE_BODY);
        if (page.getEnclosingWindow() instanceof FrameWindow && originalCall && waitToLoad) {
            return;
        }
        HtmlElement doc = page.getDocumentElement();
        boolean hasBody = false;
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HtmlBody) && !(child instanceof HtmlFrameSet)) continue;
            hasBody = true;
            break;
        }
        if (!hasBody && !checkInsideFrameOnly) {
            HtmlBody body = new HtmlBody("body", page, null, false);
            doc.appendChild(body);
        }
        if (waitToLoad) {
            for (FrameWindow frame : page.getFrames()) {
                Page containedPage = frame.getEnclosedPage();
                if (containedPage == null || !containedPage.isHtmlPage()) continue;
                HTMLParser.addBodyToPageIfNecessary((HtmlPage)containedPage, false, false);
            }
        }
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    public static ElementFactory getFactory(String tagName) {
        ElementFactory result = ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    static ElementFactory getElementFactory(SgmlPage page, String namespaceURI, String qualifiedName) {
        int index;
        String tagName;
        ElementFactory factory;
        if (SVG_NAMESPACE.equals(namespaceURI)) {
            return SVG_FACTORY;
        }
        if ((namespaceURI == null || namespaceURI.isEmpty() || !qualifiedName.contains(":") || namespaceURI.equals(XHTML_NAMESPACE)) && (factory = ELEMENT_FACTORIES.get(tagName = (index = (tagName = qualifiedName).indexOf(58)) == -1 ? tagName.toLowerCase(Locale.ROOT) : tagName.substring(index + 1))) != null) {
            return factory;
        }
        return UnknownElementFactory.instance;
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        for (String tagName : DefaultElementFactory.SUPPORTED_TAGS_) {
            ELEMENT_FACTORIES.put(tagName, defaultElementFactory);
        }
    }

    static final class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler,
    HTMLTagBalancingListener {
        private final HtmlPage page_;
        private Locator locator_;
        private final Deque<DomNode> stack_ = new ArrayDeque<DomNode>();
        private DomNode currentNode_;
        private StringBuilder characters_;
        private HeadParsed headParsed_ = HeadParsed.NO;
        private boolean parsingInnerHead_ = false;
        private HtmlElement body_;
        private boolean lastTagWasSynthesized_;
        private HtmlForm formWaitingForLostChildren_;
        private static final String FEATURE_AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
        private static final String FEATURE_PARSE_NOSCRIPT = "http://cyberneko.org/html/features/parse-noscript-content";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushInputString(String html) {
            this.page_.registerParsingStart();
            this.page_.registerInlineSnippetParsingStart();
            try {
                WebResponse webResponse = this.page_.getWebResponse();
                String charset = webResponse.getContentCharset();
                String url = webResponse.getWebRequest().getUrl().toString();
                XMLInputSource in = new XMLInputSource(null, url, null, new StringReader(html), charset);
                ((HTMLConfiguration)this.fConfiguration).evaluateInputSource(in);
            }
            finally {
                this.page_.registerParsingEnd();
                this.page_.registerInlineSnippetParsingEnd();
            }
        }

        private HtmlUnitDOMBuilder(DomNode node, URL url, String htmlContent) {
            super(HtmlUnitDOMBuilder.createConfiguration(node.getPage().getWebClient()));
            boolean reportErrors;
            this.page_ = (HtmlPage)node.getPage();
            this.currentNode_ = node;
            for (Node ancestor : this.currentNode_.getAncestors()) {
                this.stack_.push((DomNode)ancestor);
            }
            WebClient webClient = this.page_.getWebClient();
            HTMLParserListener listener = webClient.getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler(new HTMLErrorHandler(listener, url, htmlContent));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature(FEATURE_AUGMENTATIONS, true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "default");
                if (!webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_ATTRIBUTE_LOWER_CASE)) {
                    this.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
                }
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature(FEATURE_PARSE_NOSCRIPT, !webClient.getOptions().isJavaScriptEnabled());
                this.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", false);
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        private static XMLParserConfiguration createConfiguration(WebClient webClient) {
            HTMLConfiguration configuration = new HTMLConfiguration();
            configuration.htmlElements_.setElement(new HTMLElements.Element(5, "AREA", 4, 51, null));
            BrowserVersion browserVersion = webClient.getBrowserVersion();
            if (browserVersion.isChrome()) {
                configuration.htmlElements_.setElement(new HTMLElements.Element(25, "COMMAND", 4, 51, null));
                configuration.htmlElements_.setElement(new HTMLElements.Element(62, "ISINDEX", 1, 16, null));
            } else if (browserVersion.isIE()) {
                configuration.htmlElements_.setElement(new HTMLElements.Element(25, "COMMAND", 4, 51, null));
                configuration.htmlElements_.setElement(new HTMLElements.Element(71, "MAIN", 1, 16, null));
            }
            return configuration;
        }

        public Locator getLocator() {
            return this.locator_;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            this.lastTagWasSynthesized_ = HtmlUnitDOMBuilder.isSynthesized(augs);
            super.startElement(element, attributes, augs);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String content;
            HtmlMeta meta;
            boolean keyGenAsSelect;
            this.handleCharacters();
            String tagLower = localName.toLowerCase(Locale.ROOT);
            if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
                return;
            }
            if (namespaceURI != null) {
                namespaceURI = namespaceURI.trim();
            }
            if ("head".equals(tagLower)) {
                if (this.headParsed_ == HeadParsed.YES || this.page_.isParsingHtmlSnippet()) {
                    this.parsingInnerHead_ = true;
                    return;
                }
                this.headParsed_ = this.lastTagWasSynthesized_ ? HeadParsed.SYNTHESIZED : HeadParsed.YES;
            } else if (this.headParsed_ == HeadParsed.NO && ("body".equals(tagLower) || "frameset".equals(tagLower))) {
                ElementFactory factory = HTMLParser.getElementFactory(this.page_, namespaceURI, "head");
                DomElement newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendChild(newElement);
                this.headParsed_ = HeadParsed.SYNTHESIZED;
            }
            HtmlBody oldBody = null;
            if ("body".equals(qName) && this.page_.getBody() instanceof HtmlBody) {
                oldBody = (HtmlBody)this.page_.getBody();
            }
            if ("form".equals(tagLower)) {
                this.formWaitingForLostChildren_ = null;
            }
            if (!(this.page_ instanceof XHtmlPage) && HTMLParser.XHTML_NAMESPACE.equals(namespaceURI)) {
                namespaceURI = null;
            }
            boolean bl = keyGenAsSelect = "keygen".equals(tagLower) && this.page_.hasFeature(BrowserVersionFeatures.KEYGEN_AS_SELECT);
            if (keyGenAsSelect) {
                tagLower = "select";
                qName = "select";
            }
            ElementFactory factory = HTMLParser.getElementFactory(this.page_, namespaceURI, qName);
            DomElement newElement = factory.createElementNS(this.page_, namespaceURI, qName, atts, true);
            newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.addNodeToRightParent(this.currentNode_, newElement);
            if (oldBody != null) {
                oldBody.quietlyRemoveAndMoveChildrenTo(newElement);
            }
            if ("body".equals(tagLower)) {
                this.body_ = (HtmlElement)newElement;
            } else if ("meta".equals(tagLower) && this.page_.hasFeature(BrowserVersionFeatures.META_X_UA_COMPATIBLE) && "X-UA-Compatible".equals((meta = (HtmlMeta)newElement).getHttpEquivAttribute()) && (content = meta.getContentAttribute()).startsWith("IE=")) {
                String mode = content.substring(3).trim();
                int version = this.page_.getWebClient().getBrowserVersion().getBrowserVersionNumeric();
                if ("edge".equals(mode)) {
                    ((HTMLDocument)this.page_.getScriptableObject()).forceDocumentMode(version);
                } else {
                    try {
                        int value = Integer.parseInt(mode);
                        if (value > version) {
                            value = version;
                        }
                        ((HTMLDocument)this.page_.getScriptableObject()).forceDocumentMode(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (keyGenAsSelect) {
                DomElement option = factory.createElementNS(this.page_, namespaceURI, "option", null, true);
                option.appendChild(new DomText(this.page_, "High Grade"));
                newElement.appendChild(option);
                option = factory.createElementNS(this.page_, namespaceURI, "option", null, true);
                option.appendChild(new DomText(this.page_, "Medium Grade"));
                newElement.appendChild(option);
            }
            this.currentNode_ = newElement;
            this.stack_.push(this.currentNode_);
        }

        private void addNodeToRightParent(DomNode currentNode, DomElement newElement) {
            String parentNodeName;
            String currentNodeName = currentNode.getNodeName();
            String newNodeName = newElement.getNodeName();
            DomNode parent = currentNode;
            if ("tr".equals(newNodeName) && !HtmlUnitDOMBuilder.isTableChild(currentNodeName)) {
                parent = this.findElementOnStack("tbody", "thead", "tfoot");
            } else if (HtmlUnitDOMBuilder.isTableChild(newNodeName) && !"table".equals(currentNodeName)) {
                parent = this.findElementOnStack("table");
            } else if (HtmlUnitDOMBuilder.isTableCell(newNodeName) && !"tr".equals(currentNodeName)) {
                parent = this.findElementOnStack("tr");
            }
            if (parent != currentNode && "form".equals(currentNodeName)) {
                this.formWaitingForLostChildren_ = (HtmlForm)currentNode;
            }
            if ("table".equals(parentNodeName = parent.getNodeName()) && !HtmlUnitDOMBuilder.isTableChild(newNodeName) || HtmlUnitDOMBuilder.isTableChild(parentNodeName) && !"caption".equals(parentNodeName) && !"colgroup".equals(parentNodeName) && !"tr".equals(newNodeName) || "colgroup".equals(parentNodeName) && !"col".equals(newNodeName) || "tr".equals(parentNodeName) && !HtmlUnitDOMBuilder.isTableCell(newNodeName)) {
                if ("form".equals(newNodeName)) {
                    this.formWaitingForLostChildren_ = (HtmlForm)newElement;
                    parent.appendChild(newElement);
                } else if (newElement instanceof SubmittableElement) {
                    if (this.formWaitingForLostChildren_ != null) {
                        this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
                    }
                    parent.appendChild(newElement);
                } else {
                    parent = this.findElementOnStack("table");
                    parent.insertBefore(newElement);
                }
            } else if (this.formWaitingForLostChildren_ != null && "form".equals(parentNodeName)) {
                if (newElement instanceof SubmittableElement) {
                    this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
                    parent.getParentNode().appendChild(newElement);
                } else {
                    parent = this.findElementOnStack("table");
                    parent.insertBefore(newElement);
                }
            } else if (this.formWaitingForLostChildren_ != null && newElement instanceof SubmittableElement) {
                this.formWaitingForLostChildren_.addLostChild((HtmlElement)newElement);
                parent.appendChild(newElement);
            } else {
                parent.appendChild(newElement);
            }
        }

        private DomNode findElementOnStack(String ... searchedElementNames) {
            DomNode searchedNode = null;
            for (DomNode node : this.stack_) {
                if (!ArrayUtils.contains(searchedElementNames, node.getNodeName())) continue;
                searchedNode = node;
                break;
            }
            if (searchedNode == null) {
                searchedNode = this.stack_.peek();
            }
            return searchedNode;
        }

        private static boolean isTableChild(String nodeName) {
            return "thead".equals(nodeName) || "tbody".equals(nodeName) || "tfoot".equals(nodeName) || "caption".equals(nodeName) || "colgroup".equals(nodeName);
        }

        private static boolean isTableCell(String nodeName) {
            return "td".equals(nodeName) || "th".equals(nodeName);
        }

        @Override
        public void endElement(QName element, Augmentations augs) throws XNIException {
            this.lastTagWasSynthesized_ = HtmlUnitDOMBuilder.isSynthesized(augs);
            super.endElement(element, augs);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            String tagLower = localName.toLowerCase(Locale.ROOT);
            if (this.page_.isParsingHtmlSnippet() && ("html".equals(tagLower) || "body".equals(tagLower))) {
                return;
            }
            if (this.parsingInnerHead_) {
                if ("head".equals(tagLower)) {
                    this.parsingInnerHead_ = false;
                }
                if ("head".equals(tagLower)) {
                    return;
                }
            }
            if ("form".equals(tagLower)) {
                this.formWaitingForLostChildren_ = null;
            }
            DomNode previousNode = this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            if (previousNode instanceof HtmlForm && this.lastTagWasSynthesized_) {
                this.formWaitingForLostChildren_ = (HtmlForm)previousNode;
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = this.stack_.peek();
            }
            boolean postponed = this.page_.isParsingInlineHtmlSnippet();
            previousNode.onAllChildrenAddedToPage(postponed);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuilder();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() != 0) {
                if (this.currentNode_ instanceof HtmlHtml) {
                    this.characters_.setLength(0);
                } else {
                    String textValue = this.characters_.toString();
                    DomText text = new DomText(this.page_, textValue);
                    this.characters_.setLength(0);
                    if (StringUtils.isNotBlank(textValue)) {
                        if (this.currentNode_ instanceof HtmlTableRow) {
                            HtmlTableRow row = (HtmlTableRow)this.currentNode_;
                            HtmlTable enclosingTable = row.getEnclosingTable();
                            if (enclosingTable != null) {
                                if (enclosingTable.getPreviousSibling() instanceof DomText) {
                                    DomText domText = (DomText)enclosingTable.getPreviousSibling();
                                    domText.setTextContent(domText + textValue);
                                } else {
                                    enclosingTable.insertBefore(text);
                                }
                            }
                        } else if (this.currentNode_ instanceof HtmlTable) {
                            HtmlTable enclosingTable = (HtmlTable)this.currentNode_;
                            if (enclosingTable.getPreviousSibling() instanceof DomText) {
                                DomText domText = (DomText)enclosingTable.getPreviousSibling();
                                domText.setTextContent(domText + textValue);
                            } else {
                                enclosingTable.insertBefore(text);
                            }
                        } else if (this.currentNode_ instanceof HtmlImage) {
                            this.currentNode_.setNextSibling(text);
                        } else {
                            this.currentNode_.appendChild(text);
                        }
                    } else {
                        this.currentNode_.appendChild(text);
                    }
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.handleCharacters();
            HtmlPage currentPage = this.page_;
            currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            this.handleCharacters();
            String data = new String(ch, start, length);
            DomComment comment = new DomComment(this.page_, data);
            this.currentNode_.appendChild(comment);
        }

        @Override
        public void endCDATA() {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void endEntity(String name) {
        }

        @Override
        public void startCDATA() {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            DomDocumentType type = new DomDocumentType(this.page_, name, publicId, systemId);
            this.page_.setDocumentType(type);
            DomDocumentType child = type;
            this.page_.appendChild(child);
        }

        @Override
        public void startEntity(String name) {
        }

        @Override
        public void ignoredEndElement(QName element, Augmentations augs) {
            if ("form".equals(element.localpart)) {
                this.formWaitingForLostChildren_ = null;
            }
            if (this.parsingInnerHead_ && "head".equalsIgnoreCase(element.localpart)) {
                this.parsingInnerHead_ = false;
            }
        }

        @Override
        public void ignoredStartElement(QName elem, XMLAttributes attrs, Augmentations augs) {
            if (this.body_ != null && "body".equalsIgnoreCase(elem.localpart) && attrs != null) {
                HtmlUnitDOMBuilder.copyAttributes(this.body_, attrs);
            }
            if (this.body_ != null && "html".equalsIgnoreCase(elem.localpart) && attrs != null) {
                HtmlUnitDOMBuilder.copyAttributes((DomElement)this.body_.getParentNode(), attrs);
            }
            if (this.headParsed_ == HeadParsed.YES && "head".equalsIgnoreCase(elem.localpart)) {
                this.parsingInnerHead_ = true;
            }
        }

        private static void copyAttributes(DomElement to, XMLAttributes attrs) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                String attrName = attrs.getLocalName(i).toLowerCase(Locale.ROOT);
                if (to.getAttributes().getNamedItem(attrName) != null) continue;
                to.setAttribute(attrName, attrs.getValue(i));
                if (!attrName.startsWith("on") || !(to.getScriptableObject() instanceof HTMLBodyElement)) continue;
                HTMLBodyElement jsBody = (HTMLBodyElement)to.getScriptableObject();
                jsBody.createEventHandlerFromAttribute(attrName, attrs.getValue(i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(XMLInputSource inputSource) throws XNIException, IOException {
            HtmlUnitDOMBuilder oldBuilder = this.page_.getBuilder();
            this.page_.setBuilder(this);
            try {
                super.parse(inputSource);
            }
            finally {
                this.page_.setBuilder(oldBuilder);
            }
        }

        private static boolean isSynthesized(Augmentations augs) {
            HTMLEventInfo info = augs == null ? null : (HTMLEventInfo)augs.getItem(FEATURE_AUGMENTATIONS);
            return info != null ? info.isSynthesized() : false;
        }

        private static enum HeadParsed {
            YES,
            SYNTHESIZED,
            NO;

        }
    }
}

