# Scikit Flow

This is a simplified interface for TensorFlow, to get people started on predictive analytics and data mining.

Library covers variety of needs from linear models to *Deep Learning* applications like text and image understanding.

## Why *TensorFlow*? 

- TensorFlow provides a good backbone for building different shapes of machine learning applications. 
- It will continue to evolve both in the distributed direction and as general pipelinining machinery.

## Why *Scikit Flow*? 

- To smooth the transition from the Scikit Learn world of one-liner machine learning into the more open world of building different shapes of ML models. You can start by using fit/predict and slide into TensorFlow APIs as you are getting comfortable. 
- To provide a set of reference models that would be easy to integrate with existing code.

# Installation

## Dependencies

- Python: 2.7, 3.4+ 
- Scikit learn: 0.16, 0.17, 0.18+ 
- Tensorflow: 0.7+

First, you need to make sure you have `TensorFlow <https://github.com/tensorflow/tensorflow#installation>`__ and `Scikit Learn <http://scikit-learn.org/stable/install.html>`__ installed. 

Run the following to install the stable version from PyPI:

    pip install skflow

Or run the following to install from the development version from Github:

    pip install git+git://github.com/tensorflow/skflow.git

## Tutorial

-  `Introduction to Scikit Flow and why you want to start learning
   TensorFlow <https://medium.com/@ilblackdragon/tensorflow-tutorial-part-1-c559c63c0cb1>`__
-  `DNNs, custom model and Digit recognition
   examples <https://medium.com/@ilblackdragon/tensorflow-tutorial-part-2-9ffe47049c92>`__
-  `Categorical variables: One hot vs Distributed
   representation <https://medium.com/@ilblackdragon/tensorflow-tutorial-part-3-c5fc0662bc08>`__
-  More coming soon.

## Community

- Twitter `#skflow <https://twitter.com/search?q=skflow&src=typd>`__.
- StackOverflow with `skflow tag <http://stackoverflow.com/questions/tagged/skflow>`__ for questions and struggles.
- Github `issues <https://github.com/tensorflow/skflow/issues>`__ for technical discussions and feature requests. 
- `Gitter channel <https://gitter.im/tensorflow/skflow>`__ for non-trivial discussions.

## Table of Contents
<!--#include virtual="sitemap.md" -->

