/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;

public class FileHelper {
    private static final String LOG_TAG = "FileUtils";
    private static final String _DATA = "_data";

    public static String getRealPath(String uriString, CordovaInterface cordova) {
        String realPath = null;
        if (uriString.startsWith("content://")) {
            String[] proj = new String[]{_DATA};
            Cursor cursor = cordova.getActivity().managedQuery(Uri.parse((String)uriString), proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow(_DATA);
            cursor.moveToFirst();
            realPath = cursor.getString(column_index);
            if (realPath == null) {
                LOG.e(LOG_TAG, "Could get real path for URI string %s", uriString);
            }
        } else if (uriString.startsWith("file://")) {
            realPath = uriString.substring(7);
            if (realPath.startsWith("/android_asset/")) {
                LOG.e(LOG_TAG, "Cannot get real path for URI string %s because it is a file:///android_asset/ URI.", uriString);
                realPath = null;
            }
        } else {
            realPath = uriString;
        }
        return realPath;
    }

    public static String getRealPath(Uri uri, CordovaInterface cordova) {
        return FileHelper.getRealPath(uri.toString(), cordova);
    }

    public static InputStream getInputStreamFromUriString(String uriString, CordovaInterface cordova) throws IOException {
        if (uriString.startsWith("content")) {
            Uri uri = Uri.parse((String)uriString);
            return cordova.getActivity().getContentResolver().openInputStream(uri);
        }
        if (uriString.startsWith("file:///android_asset/")) {
            Uri uri = Uri.parse((String)uriString);
            String relativePath = uri.getPath().substring(15);
            return cordova.getActivity().getAssets().open(relativePath);
        }
        return new FileInputStream(FileHelper.getRealPath(uriString, cordova));
    }

    public static String stripFileProtocol(String uriString) {
        if (uriString.startsWith("file://")) {
            uriString = uriString.substring(7);
        }
        return uriString;
    }

    public static String getMimeType(String uriString, CordovaInterface cordova) {
        String mimeType = null;
        Uri uri = Uri.parse((String)uriString);
        if (uriString.startsWith("content://")) {
            mimeType = cordova.getActivity().getContentResolver().getType(uri);
        } else {
            String extension = uri.getPath();
            int lastDot = extension.lastIndexOf(46);
            if (lastDot != -1) {
                extension = extension.substring(lastDot + 1);
            }
            mimeType = (extension = extension.toLowerCase()).equals("3ga") ? "audio/3gpp" : MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return mimeType;
    }
}

