/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaChromeClient;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.ExposedJsApi;
import org.apache.cordova.IceCreamCordovaWebViewClient;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;
import org.apache.cordova.api.PluginManager;
import org.apache.cordova.api.PluginResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CordovaWebView
extends WebView {
    public static final String TAG = "CordovaWebView";
    private ArrayList<Integer> keyDownCodes = new ArrayList();
    private ArrayList<Integer> keyUpCodes = new ArrayList();
    public PluginManager pluginManager;
    private boolean paused;
    private BroadcastReceiver receiver;
    private CordovaInterface cordova;
    CordovaWebViewClient viewClient;
    private CordovaChromeClient chromeClient;
    private String url;
    int loadUrlTimeout = 0;
    private boolean bound;
    private boolean handleButton = false;
    private long lastMenuEventTime = 0L;
    NativeToJsMessageQueue jsMessageQueue;
    ExposedJsApi exposedJsApi;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private ActivityResult mResult = null;
    static final FrameLayout.LayoutParams COVER_SCREEN_GRAVITY_CENTER = new FrameLayout.LayoutParams(-1, -1, 17);

    public CordovaWebView(Context context) {
        super(context);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.loadConfiguration();
        this.setup();
    }

    public CordovaWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova, this));
        this.initWebViewClient(this.cordova);
        this.loadConfiguration();
        this.setup();
    }

    public CordovaWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova, this));
        this.loadConfiguration();
        this.setup();
    }

    @TargetApi(value=11)
    public CordovaWebView(Context context, AttributeSet attrs, int defStyle, boolean privateBrowsing) {
        super(context, attrs, defStyle, privateBrowsing);
        if (CordovaInterface.class.isInstance(context)) {
            this.cordova = (CordovaInterface)context;
        } else {
            Log.d((String)TAG, (String)"Your activity must implement CordovaInterface to work");
        }
        this.setWebChromeClient(new CordovaChromeClient(this.cordova));
        this.initWebViewClient(this.cordova);
        this.loadConfiguration();
        this.setup();
    }

    private void initWebViewClient(CordovaInterface cordova) {
        if (Build.VERSION.SDK_INT < 11 || Build.VERSION.SDK_INT > 17) {
            this.setWebViewClient(new CordovaWebViewClient(this.cordova, this));
        } else {
            this.setWebViewClient(new IceCreamCordovaWebViewClient(this.cordova, this));
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setup() {
        this.setInitialScale(0);
        this.setVerticalScrollBarEnabled(false);
        this.requestFocusFromTouch();
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        try {
            Method gingerbread_getMethod = WebSettings.class.getMethod("setNavDump", Boolean.TYPE);
            String manufacturer = Build.MANUFACTURER;
            Log.d((String)TAG, (String)("CordovaWebView is running on device made by: " + manufacturer));
            if (Build.VERSION.SDK_INT < 11 && Build.MANUFACTURER.contains("HTC")) {
                gingerbread_getMethod.invoke((Object)settings, true);
            }
        }
        catch (NoSuchMethodException e) {
            Log.d((String)TAG, (String)"We are on a modern version of Android, we will deprecate HTC 2.3 devices in 2.8");
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"Doing the NavDump failed with bad arguments");
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)"This should never happen: IllegalAccessException means this isn't Android anymore");
        }
        catch (InvocationTargetException e) {
            Log.d((String)TAG, (String)"This should never happen: InvocationTargetException means this isn't Android anymore.");
        }
        settings.setSaveFormData(false);
        settings.setSavePassword(false);
        if (Build.VERSION.SDK_INT > 15) {
            Level16Apis.enableUniversalAccess(settings);
        }
        String databasePath = this.cordova.getActivity().getApplicationContext().getDir("database", 0).getPath();
        settings.setDatabaseEnabled(true);
        settings.setDatabasePath(databasePath);
        settings.setGeolocationDatabasePath(databasePath);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setAppCacheMaxSize(0x500000L);
        String pathToCache = this.cordova.getActivity().getApplicationContext().getDir("database", 0).getPath();
        settings.setAppCachePath(pathToCache);
        settings.setAppCacheEnabled(true);
        this.updateUserAgentString();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        if (this.receiver == null) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    CordovaWebView.this.updateUserAgentString();
                }
            };
            this.cordova.getActivity().registerReceiver(this.receiver, intentFilter);
        }
        this.pluginManager = new PluginManager(this, this.cordova);
        this.jsMessageQueue = new NativeToJsMessageQueue(this, this.cordova);
        this.exposedJsApi = new ExposedJsApi(this.pluginManager, this.jsMessageQueue);
        this.exposeJsInterface();
    }

    private void updateUserAgentString() {
        this.getSettings().getUserAgentString();
    }

    private void exposeJsInterface() {
        boolean isHoneycomb;
        int SDK_INT = Build.VERSION.SDK_INT;
        boolean bl = isHoneycomb = SDK_INT >= 11 && SDK_INT <= 13;
        if (isHoneycomb || SDK_INT < 9) {
            Log.i((String)TAG, (String)"Disabled addJavascriptInterface() bridge since Android version is old.");
            return;
        }
        if (SDK_INT < 11 && Build.MANUFACTURER.equals("unknown")) {
            Log.i((String)TAG, (String)"Disabled addJavascriptInterface() bridge callback due to a bug on the 2.3 emulator");
            return;
        }
        this.addJavascriptInterface(this.exposedJsApi, "_cordovaNative");
    }

    public void setWebViewClient(CordovaWebViewClient client) {
        this.viewClient = client;
        super.setWebViewClient((WebViewClient)client);
    }

    public void setWebChromeClient(CordovaChromeClient client) {
        this.chromeClient = client;
        super.setWebChromeClient((WebChromeClient)client);
    }

    public CordovaChromeClient getWebChromeClient() {
        return this.chromeClient;
    }

    public void loadUrl(String url) {
        if (url.equals("about:blank") || url.startsWith("javascript:")) {
            this.loadUrlNow(url);
        } else {
            String initUrl = this.getProperty("url", null);
            if (initUrl == null) {
                this.loadUrlIntoView(url);
            } else {
                this.loadUrlIntoView(initUrl);
            }
        }
    }

    public void loadUrl(String url, int time) {
        String initUrl = this.getProperty("url", null);
        if (initUrl == null) {
            this.loadUrlIntoView(url, time);
        } else {
            this.loadUrlIntoView(initUrl);
        }
    }

    public void loadUrlIntoView(final String url) {
        LOG.d(TAG, ">>> loadUrl(" + url + ")");
        this.url = url;
        this.pluginManager.init();
        final CordovaWebView me = this;
        final int currentLoadUrlTimeout = me.loadUrlTimeout;
        final int loadUrlTimeoutValue = Integer.parseInt(this.getProperty("loadUrlTimeoutValue", "20000"));
        final Runnable loadError = new Runnable(){

            public void run() {
                me.stopLoading();
                LOG.e(CordovaWebView.TAG, "CordovaWebView: TIMEOUT ERROR!");
                if (CordovaWebView.this.viewClient != null) {
                    CordovaWebView.this.viewClient.onReceivedError(me, -6, "The connection to the server was unsuccessful.", url);
                }
            }
        };
        final Runnable timeoutCheck = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(loadUrlTimeoutValue);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (me.loadUrlTimeout == currentLoadUrlTimeout) {
                    me.cordova.getActivity().runOnUiThread(loadError);
                }
            }
        };
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                Thread thread = new Thread(timeoutCheck);
                thread.start();
                me.loadUrlNow(url);
            }
        });
    }

    void loadUrlNow(String url) {
        if (LOG.isLoggable(3) && !url.startsWith("javascript:")) {
            LOG.d(TAG, ">>> loadUrlNow()");
        }
        if (url.startsWith("file://") || url.startsWith("javascript:") || Config.isUrlWhiteListed(url)) {
            super.loadUrl(url);
        }
    }

    public void loadUrlIntoView(String url, int time) {
        if (!url.startsWith("javascript:") && !this.canGoBack()) {
            LOG.d(TAG, "DroidGap.loadUrl(%s, %d)", url, time);
            this.postMessage("splashscreen", "show");
        }
        this.loadUrlIntoView(url);
    }

    public void sendJavascript(String statement) {
        this.jsMessageQueue.addJavaScript(statement);
    }

    public void sendPluginResult(PluginResult result, String callbackId) {
        this.jsMessageQueue.addPluginResult(result, callbackId);
    }

    public void postMessage(String id, Object data) {
        if (this.pluginManager != null) {
            this.pluginManager.postMessage(id, data);
        }
    }

    public boolean backHistory() {
        if (super.canGoBack()) {
            this.printBackForwardList();
            super.goBack();
            return true;
        }
        return false;
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap", url, openExternal, clearHistory);
        if (clearHistory) {
            this.clearHistory();
        }
        if (!openExternal) {
            if (url.startsWith("file://") || Config.isUrlWhiteListed(url)) {
                this.loadUrl(url);
            } else {
                LOG.w(TAG, "showWebPage: Cannot load URL into webview since it is not in white list.  Loading into browser instead. (URL=" + url + ")");
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error loading url " + url, e);
                }
            }
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                this.cordova.getActivity().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                LOG.e(TAG, "Error loading url " + url, e);
            }
        }
    }

    private void loadConfiguration() {
        if ("true".equals(this.getProperty("fullscreen", "false"))) {
            this.cordova.getActivity().getWindow().clearFlags(2048);
            this.cordova.getActivity().getWindow().setFlags(1024, 1024);
        }
    }

    public String getProperty(String name, String defaultValue) {
        Bundle bundle = this.cordova.getActivity().getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        Object p = bundle.get(name);
        if (p == null) {
            return defaultValue;
        }
        return p.toString();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.keyDownCodes.contains(keyCode)) {
            if (keyCode == 25) {
                LOG.d(TAG, "Down Key Hit");
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumedownbutton');");
                return true;
            }
            if (keyCode == 24) {
                LOG.d(TAG, "Up Key Hit");
                this.loadUrl("javascript:cordova.fireDocumentEvent('volumeupbutton');");
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 4) {
            return !this.startOfHistory() || this.bound;
        }
        if (keyCode == 82) {
            View childView = this.getFocusedChild();
            if (childView != null) {
                InputMethodManager imm = (InputMethodManager)this.cordova.getActivity().getSystemService("input_method");
                imm.hideSoftInputFromWindow(childView.getWindowToken(), 0);
                this.cordova.getActivity().openOptionsMenu();
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mCustomView != null) {
                this.hideCustomView();
            } else {
                if (this.bound) {
                    this.loadUrl("javascript:cordova.fireDocumentEvent('backbutton');");
                    return true;
                }
                if (this.backHistory()) {
                    return true;
                }
                this.cordova.getActivity().finish();
            }
        } else {
            if (keyCode == 82) {
                if (this.lastMenuEventTime < event.getEventTime()) {
                    this.loadUrl("javascript:cordova.fireDocumentEvent('menubutton');");
                }
                this.lastMenuEventTime = event.getEventTime();
                return super.onKeyUp(keyCode, event);
            }
            if (keyCode == 84) {
                this.loadUrl("javascript:cordova.fireDocumentEvent('searchbutton');");
                return true;
            }
            if (this.keyUpCodes.contains(keyCode)) {
                return super.onKeyUp(keyCode, event);
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void bindButton(boolean override) {
        this.bound = override;
    }

    public void bindButton(String button, boolean override) {
        if (button.compareTo("volumeup") == 0) {
            this.keyDownCodes.add(24);
        } else if (button.compareTo("volumedown") == 0) {
            this.keyDownCodes.add(25);
        }
    }

    public void bindButton(int keyCode, boolean keyDown, boolean override) {
        if (keyDown) {
            this.keyDownCodes.add(keyCode);
        } else {
            this.keyUpCodes.add(keyCode);
        }
    }

    public boolean isBackButtonBound() {
        return this.bound;
    }

    public void handlePause(boolean keepRunning) {
        LOG.d(TAG, "Handle the pause");
        this.loadUrl("javascript:try{cordova.fireDocumentEvent('pause');}catch(e){console.log('exception firing pause event from native');};");
        if (this.pluginManager != null) {
            this.pluginManager.onPause(keepRunning);
        }
        if (!keepRunning) {
            this.pauseTimers();
        }
        this.paused = true;
    }

    public void handleResume(boolean keepRunning, boolean activityResultKeepRunning) {
        this.loadUrl("javascript:try{cordova.fireDocumentEvent('resume');}catch(e){console.log('exception firing resume event from native');};");
        if (this.pluginManager != null) {
            this.pluginManager.onResume(keepRunning);
        }
        this.resumeTimers();
        this.paused = false;
    }

    public void handleDestroy() {
        this.loadUrlIntoView("javascript:try{cordova.require('cordova/channel').onDestroy.fire();}catch(e){console.log('exception firing destroy event from native');};");
        this.loadUrl("about:blank");
        if (this.pluginManager != null) {
            this.pluginManager.onDestroy();
        }
        if (this.receiver != null) {
            try {
                this.cordova.getActivity().unregisterReceiver(this.receiver);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Error unregistering configuration receiver: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void onNewIntent(Intent intent) {
        if (this.pluginManager != null) {
            this.pluginManager.onNewIntent(intent);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hadKeyEvent() {
        return this.handleButton;
    }

    public void printBackForwardList() {
        WebBackForwardList currentList = this.copyBackForwardList();
        int currentSize = currentList.getSize();
        for (int i = 0; i < currentSize; ++i) {
            WebHistoryItem item = currentList.getItemAtIndex(i);
            String url = item.getUrl();
            LOG.d(TAG, "The URL at index: " + Integer.toString(i) + "is " + url);
        }
    }

    public boolean startOfHistory() {
        WebBackForwardList currentList = this.copyBackForwardList();
        WebHistoryItem item = currentList.getItemAtIndex(0);
        if (item != null) {
            String url = item.getUrl();
            String currentUrl = this.getUrl();
            LOG.d(TAG, "The current URL is: " + currentUrl);
            LOG.d(TAG, "The URL at item 0 is:" + url);
            return currentUrl.equals(url);
        }
        return false;
    }

    public void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        Log.d((String)TAG, (String)"showing Custom View");
        if (this.mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        this.mCustomView = view;
        this.mCustomViewCallback = callback;
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.addView(view, (ViewGroup.LayoutParams)COVER_SCREEN_GRAVITY_CENTER);
        this.setVisibility(8);
        parent.setVisibility(0);
        parent.bringToFront();
    }

    public void hideCustomView() {
        Log.d((String)TAG, (String)"Hidding Custom View");
        if (this.mCustomView == null) {
            return;
        }
        this.mCustomView.setVisibility(8);
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.removeView(this.mCustomView);
        this.mCustomView = null;
        this.mCustomViewCallback.onCustomViewHidden();
        this.setVisibility(0);
    }

    public boolean isCustomViewShowing() {
        return this.mCustomView != null;
    }

    public WebBackForwardList restoreState(Bundle savedInstanceState) {
        WebBackForwardList myList = super.restoreState(savedInstanceState);
        Log.d((String)TAG, (String)"WebView restoration crew now restoring!");
        this.pluginManager.init();
        return myList;
    }

    public void storeResult(int requestCode, int resultCode, Intent intent) {
        this.mResult = new ActivityResult(requestCode, resultCode, intent);
    }

    @TargetApi(value=16)
    private static class Level16Apis {
        private Level16Apis() {
        }

        static void enableUniversalAccess(WebSettings settings) {
            settings.setAllowUniversalAccessFromFileURLs(true);
        }
    }

    class ActivityResult {
        int request;
        int result;
        Intent incoming;

        public ActivityResult(int req, int res, Intent intent) {
            this.request = req;
            this.result = res;
            this.incoming = intent;
        }
    }
}

