/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.Activity;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.api.LOG;
import org.xmlpull.v1.XmlPullParserException;

public class Config {
    public static final String TAG = "Config";
    private ArrayList<Pattern> whiteList = new ArrayList();
    private HashMap<String, Boolean> whiteListCache = new HashMap();
    private String startUrl;
    private static Config self = null;

    public static void init(Activity action) {
        if (self == null) {
            self = new Config(action);
        }
    }

    public static void init() {
        if (self == null) {
            self = new Config();
        }
    }

    private Config() {
    }

    private Config(Activity action) {
        if (action == null) {
            LOG.i("CordovaLog", "There is no activity. Is this on the lock screen?");
            return;
        }
        int id = action.getResources().getIdentifier("config", "xml", action.getPackageName());
        if (id == 0) {
            id = action.getResources().getIdentifier("cordova", "xml", action.getPackageName());
            LOG.i("CordovaLog", "config.xml missing, reverting to cordova.xml");
        }
        if (id == 0) {
            LOG.i("CordovaLog", "cordova.xml missing. Ignoring...");
            return;
        }
        XmlResourceParser xml = action.getResources().getXml(id);
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                String strNode = xml.getName();
                if (strNode.equals("access")) {
                    String origin = xml.getAttributeValue(null, "origin");
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    if (origin != null) {
                        this._addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    }
                } else if (strNode.equals("log")) {
                    String level = xml.getAttributeValue(null, "level");
                    LOG.i("CordovaLog", "Found log level %s", level);
                    if (level != null) {
                        LOG.setLogLevel(level);
                    }
                } else if (strNode.equals("preference")) {
                    String value;
                    String name = xml.getAttributeValue(null, "name");
                    if (name.equals("splashscreen")) {
                        value = xml.getAttributeValue(null, "value");
                        int resource = 0;
                        if (value != null) {
                            value = "splash";
                        }
                        resource = action.getResources().getIdentifier(value, "drawable", action.getPackageName());
                        action.getIntent().putExtra(name, resource);
                        LOG.i("CordovaLog", "Found preference for %s=%s", name, value);
                        Log.d((String)"CordovaLog", (String)("Found preference for " + name + "=" + value));
                    } else if (name.equals("backgroundColor")) {
                        int value2 = xml.getAttributeIntValue(null, "value", -16777216);
                        action.getIntent().putExtra(name, value2);
                        LOG.i("CordovaLog", "Found preference for %s=%d", name, value2);
                        Log.d((String)"CordovaLog", (String)("Found preference for " + name + "=" + Integer.toString(value2)));
                    } else if (name.equals("loadUrlTimeoutValue")) {
                        int value3 = xml.getAttributeIntValue(null, "value", 20000);
                        action.getIntent().putExtra(name, value3);
                        LOG.i("CordovaLog", "Found preference for %s=%d", name, value3);
                        Log.d((String)"CordovaLog", (String)("Found preference for " + name + "=" + Integer.toString(value3)));
                    } else if (name.equals("keepRunning")) {
                        boolean value4 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value4);
                    } else if (name.equals("InAppBrowserStorageEnabled")) {
                        boolean value5 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value5);
                    } else if (name.equals("disallowOverscroll")) {
                        boolean value6 = xml.getAttributeValue(null, "value").equals("true");
                        action.getIntent().putExtra(name, value6);
                    } else {
                        value = xml.getAttributeValue(null, "value");
                        action.getIntent().putExtra(name, value);
                        LOG.i("CordovaLog", "Found preference for %s=%s", name, value);
                        Log.d((String)"CordovaLog", (String)("Found preference for " + name + "=" + value));
                    }
                } else if (strNode.equals("content")) {
                    String src = xml.getAttributeValue(null, "src");
                    LOG.i("CordovaLog", "Found start page location: %s", src);
                    if (src != null) {
                        Pattern schemeRegex = Pattern.compile("^[a-z-]+://");
                        Matcher matcher = schemeRegex.matcher(src);
                        if (matcher.find()) {
                            this.startUrl = src;
                        } else {
                            if (src.charAt(0) == '/') {
                                src = src.substring(1);
                            }
                            this.startUrl = "file:///android_asset/www/" + src;
                        }
                    }
                }
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addWhiteListEntry(String origin, boolean subdomains) {
        if (self == null) {
            return;
        }
        self._addWhiteListEntry(origin, subdomains);
    }

    private void _addWhiteListEntry(String origin, boolean subdomains) {
        try {
            if (origin.compareTo("*") == 0) {
                LOG.d(TAG, "Unlimited access to network resources");
                this.whiteList.add(Pattern.compile(".*"));
            } else {
                Pattern schemeRegex = Pattern.compile("^[a-z-]+://");
                Matcher matcher = schemeRegex.matcher(origin);
                if (subdomains) {
                    if (origin.startsWith("http")) {
                        this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://(.*\\.)?")));
                    } else if (matcher.find()) {
                        this.whiteList.add(Pattern.compile("^" + origin.replaceFirst("//", "//(.*\\.)?")));
                    } else {
                        this.whiteList.add(Pattern.compile("^https?://(.*\\.)?" + origin));
                    }
                    LOG.d(TAG, "Origin to allow with subdomains: %s", origin);
                } else {
                    if (origin.startsWith("http")) {
                        this.whiteList.add(Pattern.compile(origin.replaceFirst("https?://", "^https?://")));
                    } else if (matcher.find()) {
                        this.whiteList.add(Pattern.compile("^" + origin));
                    } else {
                        this.whiteList.add(Pattern.compile("^https?://" + origin));
                    }
                    LOG.d(TAG, "Origin to allow: %s", origin);
                }
            }
        }
        catch (Exception e) {
            LOG.d(TAG, "Failed to add origin %s", origin);
        }
    }

    public static boolean isUrlWhiteListed(String url) {
        if (self == null) {
            return false;
        }
        if (Config.self.whiteListCache.get(url) != null) {
            return true;
        }
        for (Pattern p : Config.self.whiteList) {
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            Config.self.whiteListCache.put(url, true);
            return true;
        }
        return false;
    }

    public static String getStartUrl() {
        if (self == null || Config.self.startUrl == null) {
            return "file:///android_asset/www/index.html";
        }
        return Config.self.startUrl;
    }
}

