/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccelListener
extends CordovaPlugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    private float x = 0.0f;
    private float y = 0.0f;
    private float z = 0.0f;
    private long timestamp = 0L;
    private int status;
    private int accuracy = 0;
    private SensorManager sensorManager;
    private Sensor mSensor;
    private CallbackContext callbackContext;

    public AccelListener() {
        this.setStatus(STOPPED);
    }

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.sensorManager = (SensorManager)cordova.getActivity().getSystemService("sensor");
    }

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) {
        if (action.equals("start")) {
            this.callbackContext = callbackContext;
            if (this.status != RUNNING) {
                this.start();
            }
        } else if (action.equals("stop")) {
            if (this.status == RUNNING) {
                this.stop();
            }
        } else {
            return false;
        }
        PluginResult result = new PluginResult(PluginResult.Status.NO_RESULT, "");
        result.setKeepCallback(true);
        callbackContext.sendPluginResult(result);
        return true;
    }

    public void onDestroy() {
        this.stop();
    }

    private int start() {
        if (this.status == RUNNING || this.status == STARTING) {
            return this.status;
        }
        this.setStatus(STARTING);
        List list = this.sensorManager.getSensorList(1);
        if (list == null || list.size() <= 0) {
            this.setStatus(ERROR_FAILED_TO_START);
            this.fail(ERROR_FAILED_TO_START, "No sensors found to register accelerometer listening to.");
            return this.status;
        }
        this.mSensor = (Sensor)list.get(0);
        this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 2);
        this.setStatus(STARTING);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(){

            public void run() {
                AccelListener.this.timeout();
            }
        }, 2000L);
        return this.status;
    }

    private void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
        this.accuracy = 0;
    }

    private void timeout() {
        if (this.status == STARTING) {
            this.setStatus(ERROR_FAILED_TO_START);
            this.fail(ERROR_FAILED_TO_START, "Accelerometer could not be started.");
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (sensor.getType() != 1) {
            return;
        }
        if (this.status == STOPPED) {
            return;
        }
        this.accuracy = accuracy;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() != 1) {
            return;
        }
        if (this.status == STOPPED) {
            return;
        }
        this.setStatus(RUNNING);
        if (this.accuracy >= 2) {
            this.timestamp = System.currentTimeMillis();
            this.x = event.values[0];
            this.y = event.values[1];
            this.z = event.values[2];
            this.win();
        }
    }

    public void onReset() {
        if (this.status == RUNNING) {
            this.stop();
        }
    }

    private void fail(int code, String message) {
        JSONObject errorObj = new JSONObject();
        try {
            errorObj.put("code", code);
            errorObj.put("message", (Object)message);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        PluginResult err = new PluginResult(PluginResult.Status.ERROR, errorObj);
        err.setKeepCallback(true);
        this.callbackContext.sendPluginResult(err);
    }

    private void win() {
        PluginResult result = new PluginResult(PluginResult.Status.OK, this.getAccelerationJSON());
        result.setKeepCallback(true);
        this.callbackContext.sendPluginResult(result);
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private JSONObject getAccelerationJSON() {
        JSONObject r = new JSONObject();
        try {
            r.put("x", (double)this.x);
            r.put("y", (double)this.y);
            r.put("z", (double)this.z);
            r.put("timestamp", this.timestamp);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return r;
    }
}

