/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo.
// source: api.proto
// DO NOT EDIT!

/*
Package runtime is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	VersionRequest
	VersionResponse
	DNSConfig
	PortMapping
	Mount
	NamespaceOption
	LinuxSandboxSecurityContext
	LinuxPodSandboxConfig
	PodSandboxMetadata
	PodSandboxConfig
	RunPodSandboxRequest
	RunPodSandboxResponse
	StopPodSandboxRequest
	StopPodSandboxResponse
	RemovePodSandboxRequest
	RemovePodSandboxResponse
	PodSandboxStatusRequest
	PodSandboxNetworkStatus
	Namespace
	LinuxPodSandboxStatus
	PodSandboxStatus
	PodSandboxStatusResponse
	PodSandboxFilter
	ListPodSandboxRequest
	PodSandbox
	ListPodSandboxResponse
	ImageSpec
	KeyValue
	LinuxContainerResources
	SELinuxOption
	Capability
	LinuxContainerSecurityContext
	LinuxContainerConfig
	ContainerMetadata
	Device
	ContainerConfig
	CreateContainerRequest
	CreateContainerResponse
	StartContainerRequest
	StartContainerResponse
	StopContainerRequest
	StopContainerResponse
	RemoveContainerRequest
	RemoveContainerResponse
	ContainerFilter
	ListContainersRequest
	Container
	ListContainersResponse
	ContainerStatusRequest
	ContainerStatus
	ContainerStatusResponse
	ExecSyncRequest
	ExecSyncResponse
	ExecRequest
	ExecResponse
	AttachRequest
	AttachResponse
	PortForwardRequest
	PortForwardResponse
	ImageFilter
	ListImagesRequest
	Image
	ListImagesResponse
	ImageStatusRequest
	ImageStatusResponse
	AuthConfig
	PullImageRequest
	PullImageResponse
	RemoveImageRequest
	RemoveImageResponse
	NetworkConfig
	RuntimeConfig
	UpdateRuntimeConfigRequest
	UpdateRuntimeConfigResponse
	RuntimeCondition
	RuntimeStatus
	StatusRequest
	StatusResponse
*/
package runtime

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.GoGoProtoPackageIsVersion1

type Protocol int32

const (
	Protocol_TCP Protocol = 0
	Protocol_UDP Protocol = 1
)

var Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x Protocol) Enum() *Protocol {
	p := new(Protocol)
	*p = x
	return p
}
func (x Protocol) String() string {
	return proto.EnumName(Protocol_name, int32(x))
}
func (x *Protocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Protocol_value, data, "Protocol")
	if err != nil {
		return err
	}
	*x = Protocol(value)
	return nil
}
func (Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

type PodSandboxState int32

const (
	PodSandboxState_SANDBOX_READY    PodSandboxState = 0
	PodSandboxState_SANDBOX_NOTREADY PodSandboxState = 1
)

var PodSandboxState_name = map[int32]string{
	0: "SANDBOX_READY",
	1: "SANDBOX_NOTREADY",
}
var PodSandboxState_value = map[string]int32{
	"SANDBOX_READY":    0,
	"SANDBOX_NOTREADY": 1,
}

func (x PodSandboxState) Enum() *PodSandboxState {
	p := new(PodSandboxState)
	*p = x
	return p
}
func (x PodSandboxState) String() string {
	return proto.EnumName(PodSandboxState_name, int32(x))
}
func (x *PodSandboxState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PodSandboxState_value, data, "PodSandboxState")
	if err != nil {
		return err
	}
	*x = PodSandboxState(value)
	return nil
}
func (PodSandboxState) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

type ContainerState int32

const (
	ContainerState_CONTAINER_CREATED ContainerState = 0
	ContainerState_CONTAINER_RUNNING ContainerState = 1
	ContainerState_CONTAINER_EXITED  ContainerState = 2
	ContainerState_CONTAINER_UNKNOWN ContainerState = 3
)

var ContainerState_name = map[int32]string{
	0: "CONTAINER_CREATED",
	1: "CONTAINER_RUNNING",
	2: "CONTAINER_EXITED",
	3: "CONTAINER_UNKNOWN",
}
var ContainerState_value = map[string]int32{
	"CONTAINER_CREATED": 0,
	"CONTAINER_RUNNING": 1,
	"CONTAINER_EXITED":  2,
	"CONTAINER_UNKNOWN": 3,
}

func (x ContainerState) Enum() *ContainerState {
	p := new(ContainerState)
	*p = x
	return p
}
func (x ContainerState) String() string {
	return proto.EnumName(ContainerState_name, int32(x))
}
func (x *ContainerState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerState_value, data, "ContainerState")
	if err != nil {
		return err
	}
	*x = ContainerState(value)
	return nil
}
func (ContainerState) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

type VersionRequest struct {
	// Version of the kubelet runtime API.
	Version          *string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *VersionRequest) Reset()                    { *m = VersionRequest{} }
func (m *VersionRequest) String() string            { return proto.CompactTextString(m) }
func (*VersionRequest) ProtoMessage()               {}
func (*VersionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

func (m *VersionRequest) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

type VersionResponse struct {
	// Version of the kubelet runtime API.
	Version *string `protobuf:"bytes,1,opt,name=version" json:"version,omitempty"`
	// Name of the container runtime.
	RuntimeName *string `protobuf:"bytes,2,opt,name=runtime_name,json=runtimeName" json:"runtime_name,omitempty"`
	// Version of the container runtime. The string must be
	// semver-compatible.
	RuntimeVersion *string `protobuf:"bytes,3,opt,name=runtime_version,json=runtimeVersion" json:"runtime_version,omitempty"`
	// API version of the container runtime. The string must be
	// semver-compatible.
	RuntimeApiVersion *string `protobuf:"bytes,4,opt,name=runtime_api_version,json=runtimeApiVersion" json:"runtime_api_version,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *VersionResponse) Reset()                    { *m = VersionResponse{} }
func (m *VersionResponse) String() string            { return proto.CompactTextString(m) }
func (*VersionResponse) ProtoMessage()               {}
func (*VersionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

func (m *VersionResponse) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *VersionResponse) GetRuntimeName() string {
	if m != nil && m.RuntimeName != nil {
		return *m.RuntimeName
	}
	return ""
}

func (m *VersionResponse) GetRuntimeVersion() string {
	if m != nil && m.RuntimeVersion != nil {
		return *m.RuntimeVersion
	}
	return ""
}

func (m *VersionResponse) GetRuntimeApiVersion() string {
	if m != nil && m.RuntimeApiVersion != nil {
		return *m.RuntimeApiVersion
	}
	return ""
}

// DNSConfig specifies the DNS servers and search domains of a sandbox.
type DNSConfig struct {
	// List of DNS servers of the cluster.
	Servers []string `protobuf:"bytes,1,rep,name=servers" json:"servers,omitempty"`
	// List of DNS search domains of the cluster.
	Searches []string `protobuf:"bytes,2,rep,name=searches" json:"searches,omitempty"`
	// List of DNS options. See https://linux.die.net/man/5/resolv.conf
	// for all available options.
	Options          []string `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *DNSConfig) Reset()                    { *m = DNSConfig{} }
func (m *DNSConfig) String() string            { return proto.CompactTextString(m) }
func (*DNSConfig) ProtoMessage()               {}
func (*DNSConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

func (m *DNSConfig) GetServers() []string {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *DNSConfig) GetSearches() []string {
	if m != nil {
		return m.Searches
	}
	return nil
}

func (m *DNSConfig) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

// PortMapping specifies the port mapping configurations of a sandbox.
type PortMapping struct {
	// Protocol of the port mapping.
	Protocol *Protocol `protobuf:"varint,1,opt,name=protocol,enum=runtime.Protocol" json:"protocol,omitempty"`
	// Port number within the container.
	ContainerPort *int32 `protobuf:"varint,2,opt,name=container_port,json=containerPort" json:"container_port,omitempty"`
	// Port number on the host.
	HostPort *int32 `protobuf:"varint,3,opt,name=host_port,json=hostPort" json:"host_port,omitempty"`
	// Host IP.
	HostIp           *string `protobuf:"bytes,4,opt,name=host_ip,json=hostIp" json:"host_ip,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PortMapping) Reset()                    { *m = PortMapping{} }
func (m *PortMapping) String() string            { return proto.CompactTextString(m) }
func (*PortMapping) ProtoMessage()               {}
func (*PortMapping) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

func (m *PortMapping) GetProtocol() Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return Protocol_TCP
}

func (m *PortMapping) GetContainerPort() int32 {
	if m != nil && m.ContainerPort != nil {
		return *m.ContainerPort
	}
	return 0
}

func (m *PortMapping) GetHostPort() int32 {
	if m != nil && m.HostPort != nil {
		return *m.HostPort
	}
	return 0
}

func (m *PortMapping) GetHostIp() string {
	if m != nil && m.HostIp != nil {
		return *m.HostIp
	}
	return ""
}

// Mount specifies a host volume to mount into a container.
type Mount struct {
	// Path of the mount within the container.
	ContainerPath *string `protobuf:"bytes,1,opt,name=container_path,json=containerPath" json:"container_path,omitempty"`
	// Path of the mount on the host.
	HostPath *string `protobuf:"bytes,2,opt,name=host_path,json=hostPath" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	Readonly *bool `protobuf:"varint,3,opt,name=readonly" json:"readonly,omitempty"`
	// If set, the mount needs SELinux relabeling.
	SelinuxRelabel   *bool  `protobuf:"varint,4,opt,name=selinux_relabel,json=selinuxRelabel" json:"selinux_relabel,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Mount) Reset()                    { *m = Mount{} }
func (m *Mount) String() string            { return proto.CompactTextString(m) }
func (*Mount) ProtoMessage()               {}
func (*Mount) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

func (m *Mount) GetContainerPath() string {
	if m != nil && m.ContainerPath != nil {
		return *m.ContainerPath
	}
	return ""
}

func (m *Mount) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Mount) GetReadonly() bool {
	if m != nil && m.Readonly != nil {
		return *m.Readonly
	}
	return false
}

func (m *Mount) GetSelinuxRelabel() bool {
	if m != nil && m.SelinuxRelabel != nil {
		return *m.SelinuxRelabel
	}
	return false
}

// NamespaceOption provides options for Linux namespaces.
type NamespaceOption struct {
	// If set, use the host's network namespace.
	HostNetwork *bool `protobuf:"varint,1,opt,name=host_network,json=hostNetwork" json:"host_network,omitempty"`
	// If set, use the host's PID namespace.
	HostPid *bool `protobuf:"varint,2,opt,name=host_pid,json=hostPid" json:"host_pid,omitempty"`
	// If set, use the host's IPC namespace.
	HostIpc          *bool  `protobuf:"varint,3,opt,name=host_ipc,json=hostIpc" json:"host_ipc,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *NamespaceOption) Reset()                    { *m = NamespaceOption{} }
func (m *NamespaceOption) String() string            { return proto.CompactTextString(m) }
func (*NamespaceOption) ProtoMessage()               {}
func (*NamespaceOption) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

func (m *NamespaceOption) GetHostNetwork() bool {
	if m != nil && m.HostNetwork != nil {
		return *m.HostNetwork
	}
	return false
}

func (m *NamespaceOption) GetHostPid() bool {
	if m != nil && m.HostPid != nil {
		return *m.HostPid
	}
	return false
}

func (m *NamespaceOption) GetHostIpc() bool {
	if m != nil && m.HostIpc != nil {
		return *m.HostIpc
	}
	return false
}

// LinuxSandboxSecurityContext holds linux security configuration that will be
// applied to a sandbox. Note that:
// 1) It does not apply to containers in the pods.
// 2) It may not be applicable to a PodSandbox which does not contain any running
//    process.
type LinuxSandboxSecurityContext struct {
	// Configurations for the sandbox's namespaces.
	// This will be used only if the PodSandbox uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,1,opt,name=namespace_options,json=namespaceOptions" json:"namespace_options,omitempty"`
	// Optional SELinux context to be applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,2,opt,name=selinux_options,json=selinuxOptions" json:"selinux_options,omitempty"`
	// UID to run sandbox processes as, when applicable.
	RunAsUser *int64 `protobuf:"varint,3,opt,name=run_as_user,json=runAsUser" json:"run_as_user,omitempty"`
	// If set, the root filesystem of the sandbox is read-only.
	ReadonlyRootfs *bool `protobuf:"varint,4,opt,name=readonly_rootfs,json=readonlyRootfs" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in the sandbox, in
	// addition to the sandbox's primary GID.
	SupplementalGroups []int64 `protobuf:"varint,5,rep,name=supplemental_groups,json=supplementalGroups" json:"supplemental_groups,omitempty"`
	XXX_unrecognized   []byte  `json:"-"`
}

func (m *LinuxSandboxSecurityContext) Reset()                    { *m = LinuxSandboxSecurityContext{} }
func (m *LinuxSandboxSecurityContext) String() string            { return proto.CompactTextString(m) }
func (*LinuxSandboxSecurityContext) ProtoMessage()               {}
func (*LinuxSandboxSecurityContext) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

func (m *LinuxSandboxSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if m != nil {
		return m.SelinuxOptions
	}
	return nil
}

func (m *LinuxSandboxSecurityContext) GetRunAsUser() int64 {
	if m != nil && m.RunAsUser != nil {
		return *m.RunAsUser
	}
	return 0
}

func (m *LinuxSandboxSecurityContext) GetReadonlyRootfs() bool {
	if m != nil && m.ReadonlyRootfs != nil {
		return *m.ReadonlyRootfs
	}
	return false
}

func (m *LinuxSandboxSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

// LinuxPodSandboxConfig holds platform-specific configurations for Linux
// host platforms and Linux-based containers.
type LinuxPodSandboxConfig struct {
	// Parent cgroup of the PodSandbox.
	// The cgroupfs style syntax will be used, but the container runtime can
	// convert it to systemd semantics if needed.
	CgroupParent *string `protobuf:"bytes,1,opt,name=cgroup_parent,json=cgroupParent" json:"cgroup_parent,omitempty"`
	// LinuxSandboxSecurityContext holds sandbox security attributes.
	SecurityContext  *LinuxSandboxSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext" json:"security_context,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *LinuxPodSandboxConfig) Reset()                    { *m = LinuxPodSandboxConfig{} }
func (m *LinuxPodSandboxConfig) String() string            { return proto.CompactTextString(m) }
func (*LinuxPodSandboxConfig) ProtoMessage()               {}
func (*LinuxPodSandboxConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{7} }

func (m *LinuxPodSandboxConfig) GetCgroupParent() string {
	if m != nil && m.CgroupParent != nil {
		return *m.CgroupParent
	}
	return ""
}

func (m *LinuxPodSandboxConfig) GetSecurityContext() *LinuxSandboxSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

// PodSandboxMetadata holds all necessary information for building the sandbox name.
// The container runtime is encouraged to expose the metadata associated with the
// PodSandbox in its user interface for better user experience. For example,
// the runtime can construct a unique PodSandboxName based on the metadata.
type PodSandboxMetadata struct {
	// Pod name of the sandbox. Same as the pod name in the PodSpec.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Pod UID of the sandbox. Same as the pod UID in the PodSpec.
	Uid *string `protobuf:"bytes,2,opt,name=uid" json:"uid,omitempty"`
	// Pod namespace of the sandbox. Same as the pod namespace in the PodSpec.
	Namespace *string `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
	// Attempt number of creating the sandbox.
	Attempt          *uint32 `protobuf:"varint,4,opt,name=attempt" json:"attempt,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxMetadata) Reset()                    { *m = PodSandboxMetadata{} }
func (m *PodSandboxMetadata) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxMetadata) ProtoMessage()               {}
func (*PodSandboxMetadata) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{8} }

func (m *PodSandboxMetadata) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PodSandboxMetadata) GetUid() string {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return ""
}

func (m *PodSandboxMetadata) GetNamespace() string {
	if m != nil && m.Namespace != nil {
		return *m.Namespace
	}
	return ""
}

func (m *PodSandboxMetadata) GetAttempt() uint32 {
	if m != nil && m.Attempt != nil {
		return *m.Attempt
	}
	return 0
}

// PodSandboxConfig holds all the required and optional fields for creating a
// sandbox.
type PodSandboxConfig struct {
	// Metadata of the sandbox. This information will uniquely identify the
	// sandbox, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *PodSandboxMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Hostname of the sandbox.
	Hostname *string `protobuf:"bytes,2,opt,name=hostname" json:"hostname,omitempty"`
	// Path to the directory on the host in which container log files are
	// stored.
	// By default the log of a container going into the LogDirectory will be
	// hooked up to STDOUT and STDERR. However, the LogDirectory may contain
	// binary log files with structured logging data from the individual
	// containers. For example, the files might be newline separated JSON
	// structured logs, systemd-journald journal files, gRPC trace files, etc.
	// E.g.,
	//     PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//     ContainerConfig.LogPath = `containerName_Instance#.log`
	//
	// WARNING: Log management and how kubelet should interface with the
	// container logs are under active discussion in
	// https://issues.k8s.io/24677. There *may* be future change of direction
	// for logging as the discussion carries on.
	LogDirectory *string `protobuf:"bytes,3,opt,name=log_directory,json=logDirectory" json:"log_directory,omitempty"`
	// DNS config for the sandbox.
	DnsConfig *DNSConfig `protobuf:"bytes,4,opt,name=dns_config,json=dnsConfig" json:"dns_config,omitempty"`
	// Port mappings for the sandbox.
	PortMappings []*PortMapping `protobuf:"bytes,5,rep,name=port_mappings,json=portMappings" json:"port_mappings,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata. There are a few features are
	// driven by annotations, Runtimes could support them optionally:
	//
	// 1. AppArmor
	//
	//    key: container.apparmor.security.beta.kubernetes.io/<container_name>
	//    description: apparmor profile for the container.
	//    value:
	//      * runtime/default: equivalent to not specifying a profile.
	//      * localhost/<profile_name>: profile loaded on the node
	//        (localhost) by name. The possible profile names are detailed at
	//        http://wiki.apparmor.net/index.php/AppArmor_Core_Policy_Reference
	//
	// 2. Seccomp
	//
	//      key: security.alpha.kubernetes.io/seccomp/pod
	//      description: the seccomp profile for the containers of an entire pod.
	//      value: see below.
	//
	//      key: security.alpha.kubernetes.io/seccomp/container/<container name>
	//      description: the seccomp profile for the container (overides pod).
	//      values: see below
	//
	//      The value of seccomp is runtime agnostic:
	//      * runtime/default: the default profile for the container runtime
	//      * unconfined: unconfined profile, ie, no seccomp sandboxing
	//      * localhost/<profile-name>: the profile installed to the node's
	//        local seccomp profile root. Note that profile root is set in
	//        kubelet, and it is not passed in CRI yet, see https://issues.k8s.io/36997.
	//
	// 3. Sysctls
	//
	//      key: security.alpha.kubernetes.io/sysctls
	//      description: list of safe sysctls which are set for the sandbox.
	//      value: comma separated list of sysctl_name=value key-value pairs.
	//
	//      key: security.alpha.kubernetes.io/unsafe-sysctls
	//      description: list of unsafe sysctls which are set for the sandbox.
	//      value: comma separated list of sysctl_name=value key-value pairs.
	//
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional configurations specific to Linux hosts.
	Linux            *LinuxPodSandboxConfig `protobuf:"bytes,8,opt,name=linux" json:"linux,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *PodSandboxConfig) Reset()                    { *m = PodSandboxConfig{} }
func (m *PodSandboxConfig) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxConfig) ProtoMessage()               {}
func (*PodSandboxConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{9} }

func (m *PodSandboxConfig) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxConfig) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *PodSandboxConfig) GetLogDirectory() string {
	if m != nil && m.LogDirectory != nil {
		return *m.LogDirectory
	}
	return ""
}

func (m *PodSandboxConfig) GetDnsConfig() *DNSConfig {
	if m != nil {
		return m.DnsConfig
	}
	return nil
}

func (m *PodSandboxConfig) GetPortMappings() []*PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *PodSandboxConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *PodSandboxConfig) GetLinux() *LinuxPodSandboxConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

type RunPodSandboxRequest struct {
	// Configuration for creating a PodSandbox.
	Config           *PodSandboxConfig `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RunPodSandboxRequest) Reset()                    { *m = RunPodSandboxRequest{} }
func (m *RunPodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*RunPodSandboxRequest) ProtoMessage()               {}
func (*RunPodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{10} }

func (m *RunPodSandboxRequest) GetConfig() *PodSandboxConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

type RunPodSandboxResponse struct {
	// ID of the PodSandbox to run.
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RunPodSandboxResponse) Reset()                    { *m = RunPodSandboxResponse{} }
func (m *RunPodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*RunPodSandboxResponse) ProtoMessage()               {}
func (*RunPodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{11} }

func (m *RunPodSandboxResponse) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type StopPodSandboxRequest struct {
	// ID of the PodSandbox to stop.
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StopPodSandboxRequest) Reset()                    { *m = StopPodSandboxRequest{} }
func (m *StopPodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*StopPodSandboxRequest) ProtoMessage()               {}
func (*StopPodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{12} }

func (m *StopPodSandboxRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type StopPodSandboxResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopPodSandboxResponse) Reset()                    { *m = StopPodSandboxResponse{} }
func (m *StopPodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*StopPodSandboxResponse) ProtoMessage()               {}
func (*StopPodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{13} }

type RemovePodSandboxRequest struct {
	// ID of the PodSandbox to remove.
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RemovePodSandboxRequest) Reset()                    { *m = RemovePodSandboxRequest{} }
func (m *RemovePodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*RemovePodSandboxRequest) ProtoMessage()               {}
func (*RemovePodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{14} }

func (m *RemovePodSandboxRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

type RemovePodSandboxResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemovePodSandboxResponse) Reset()                    { *m = RemovePodSandboxResponse{} }
func (m *RemovePodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*RemovePodSandboxResponse) ProtoMessage()               {}
func (*RemovePodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{15} }

type PodSandboxStatusRequest struct {
	// ID of the PodSandbox for which to retrieve status.
	PodSandboxId     *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxStatusRequest) Reset()                    { *m = PodSandboxStatusRequest{} }
func (m *PodSandboxStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatusRequest) ProtoMessage()               {}
func (*PodSandboxStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{16} }

func (m *PodSandboxStatusRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

// PodSandboxNetworkStatus is the status of the network for a PodSandbox.
type PodSandboxNetworkStatus struct {
	// IP address of the PodSandbox.
	Ip               *string `protobuf:"bytes,1,opt,name=ip" json:"ip,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PodSandboxNetworkStatus) Reset()                    { *m = PodSandboxNetworkStatus{} }
func (m *PodSandboxNetworkStatus) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxNetworkStatus) ProtoMessage()               {}
func (*PodSandboxNetworkStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{17} }

func (m *PodSandboxNetworkStatus) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

// Namespace contains paths to the namespaces.
type Namespace struct {
	// Path to the network namespace.
	Network *string `protobuf:"bytes,1,opt,name=network" json:"network,omitempty"`
	// Namespace options for Linux namespaces.
	Options          *NamespaceOption `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Namespace) Reset()                    { *m = Namespace{} }
func (m *Namespace) String() string            { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()               {}
func (*Namespace) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{18} }

func (m *Namespace) GetNetwork() string {
	if m != nil && m.Network != nil {
		return *m.Network
	}
	return ""
}

func (m *Namespace) GetOptions() *NamespaceOption {
	if m != nil {
		return m.Options
	}
	return nil
}

// LinuxSandboxStatus contains status specific to Linux sandboxes.
type LinuxPodSandboxStatus struct {
	// Paths to the sandbox's namespaces.
	Namespaces       *Namespace `protobuf:"bytes,1,opt,name=namespaces" json:"namespaces,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *LinuxPodSandboxStatus) Reset()                    { *m = LinuxPodSandboxStatus{} }
func (m *LinuxPodSandboxStatus) String() string            { return proto.CompactTextString(m) }
func (*LinuxPodSandboxStatus) ProtoMessage()               {}
func (*LinuxPodSandboxStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{19} }

func (m *LinuxPodSandboxStatus) GetNamespaces() *Namespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

// PodSandboxStatus contains the status of the PodSandbox.
type PodSandboxStatus struct {
	// ID of the sandbox.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the sandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// State of the sandbox.
	State *PodSandboxState `protobuf:"varint,3,opt,name=state,enum=runtime.PodSandboxState" json:"state,omitempty"`
	// Creation timestamp of the sandbox in nanoseconds.
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Network contains network status if network is handled by the runtime.
	Network *PodSandboxNetworkStatus `protobuf:"bytes,5,opt,name=network" json:"network,omitempty"`
	// Linux-specific status to a pod sandbox.
	Linux *LinuxPodSandboxStatus `protobuf:"bytes,6,opt,name=linux" json:"linux,omitempty"`
	// Labels are key value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations      map[string]string `protobuf:"bytes,8,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxStatus) Reset()                    { *m = PodSandboxStatus{} }
func (m *PodSandboxStatus) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatus) ProtoMessage()               {}
func (*PodSandboxStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{20} }

func (m *PodSandboxStatus) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandboxStatus) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandboxStatus) GetState() PodSandboxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (m *PodSandboxStatus) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *PodSandboxStatus) GetNetwork() *PodSandboxNetworkStatus {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *PodSandboxStatus) GetLinux() *LinuxPodSandboxStatus {
	if m != nil {
		return m.Linux
	}
	return nil
}

func (m *PodSandboxStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandboxStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type PodSandboxStatusResponse struct {
	// Status of the PodSandbox.
	Status           *PodSandboxStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxStatusResponse) Reset()                    { *m = PodSandboxStatusResponse{} }
func (m *PodSandboxStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxStatusResponse) ProtoMessage()               {}
func (*PodSandboxStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{21} }

func (m *PodSandboxStatusResponse) GetStatus() *PodSandboxStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// PodSandboxFilter is used to filter a list of PodSandboxes.
// All those fields are combined with 'AND'
type PodSandboxFilter struct {
	// ID of the sandbox.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// State of the sandbox.
	State *PodSandboxState `protobuf:"varint,2,opt,name=state,enum=runtime.PodSandboxState" json:"state,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector    map[string]string `protobuf:"bytes,3,rep,name=label_selector,json=labelSelector" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandboxFilter) Reset()                    { *m = PodSandboxFilter{} }
func (m *PodSandboxFilter) String() string            { return proto.CompactTextString(m) }
func (*PodSandboxFilter) ProtoMessage()               {}
func (*PodSandboxFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{22} }

func (m *PodSandboxFilter) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandboxFilter) GetState() PodSandboxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (m *PodSandboxFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListPodSandboxRequest struct {
	// PodSandboxFilter to filter a list of PodSandboxes.
	Filter           *PodSandboxFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ListPodSandboxRequest) Reset()                    { *m = ListPodSandboxRequest{} }
func (m *ListPodSandboxRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPodSandboxRequest) ProtoMessage()               {}
func (*ListPodSandboxRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{23} }

func (m *ListPodSandboxRequest) GetFilter() *PodSandboxFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// PodSandbox contains minimal information about a sandbox.
type PodSandbox struct {
	// ID of the PodSandbox.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the PodSandbox.
	Metadata *PodSandboxMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// State of the PodSandbox.
	State *PodSandboxState `protobuf:"varint,3,opt,name=state,enum=runtime.PodSandboxState" json:"state,omitempty"`
	// Creation timestamps of the PodSandbox in nanoseconds.
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Labels of the PodSandbox.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations      map[string]string `protobuf:"bytes,6,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PodSandbox) Reset()                    { *m = PodSandbox{} }
func (m *PodSandbox) String() string            { return proto.CompactTextString(m) }
func (*PodSandbox) ProtoMessage()               {}
func (*PodSandbox) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{24} }

func (m *PodSandbox) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *PodSandbox) GetMetadata() *PodSandboxMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PodSandbox) GetState() PodSandboxState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return PodSandboxState_SANDBOX_READY
}

func (m *PodSandbox) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *PodSandbox) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *PodSandbox) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type ListPodSandboxResponse struct {
	// List of PodSandboxes.
	Items            []*PodSandbox `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ListPodSandboxResponse) Reset()                    { *m = ListPodSandboxResponse{} }
func (m *ListPodSandboxResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPodSandboxResponse) ProtoMessage()               {}
func (*ListPodSandboxResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{25} }

func (m *ListPodSandboxResponse) GetItems() []*PodSandbox {
	if m != nil {
		return m.Items
	}
	return nil
}

// ImageSpec is an internal representation of an image.  Currently, it wraps the
// value of a Container's Image field (e.g. imageName, imageName:tag, or
// imageName:digest), but in the future it will include more detailed
// information about the different image types.
type ImageSpec struct {
	Image            *string `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImageSpec) Reset()                    { *m = ImageSpec{} }
func (m *ImageSpec) String() string            { return proto.CompactTextString(m) }
func (*ImageSpec) ProtoMessage()               {}
func (*ImageSpec) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{26} }

func (m *ImageSpec) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

type KeyValue struct {
	Key              *string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{27} }

func (m *KeyValue) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *KeyValue) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// LinuxContainerResources specifies Linux specific configuration for
// resources.
// TODO: Consider using Resources from opencontainers/runtime-spec/specs-go
// directly.
type LinuxContainerResources struct {
	// CPU CFS (Completely Fair Scheduler) period.
	CpuPeriod *int64 `protobuf:"varint,1,opt,name=cpu_period,json=cpuPeriod" json:"cpu_period,omitempty"`
	// CPU CFS (Completely Fair Scheduler) quota.
	CpuQuota *int64 `protobuf:"varint,2,opt,name=cpu_quota,json=cpuQuota" json:"cpu_quota,omitempty"`
	// CPU shares (relative weight vs. other containers).
	CpuShares *int64 `protobuf:"varint,3,opt,name=cpu_shares,json=cpuShares" json:"cpu_shares,omitempty"`
	// Memory limit in bytes.
	MemoryLimitInBytes *int64 `protobuf:"varint,4,opt,name=memory_limit_in_bytes,json=memoryLimitInBytes" json:"memory_limit_in_bytes,omitempty"`
	// OOMScoreAdj adjusts the oom-killer score.
	OomScoreAdj      *int64 `protobuf:"varint,5,opt,name=oom_score_adj,json=oomScoreAdj" json:"oom_score_adj,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *LinuxContainerResources) Reset()                    { *m = LinuxContainerResources{} }
func (m *LinuxContainerResources) String() string            { return proto.CompactTextString(m) }
func (*LinuxContainerResources) ProtoMessage()               {}
func (*LinuxContainerResources) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{28} }

func (m *LinuxContainerResources) GetCpuPeriod() int64 {
	if m != nil && m.CpuPeriod != nil {
		return *m.CpuPeriod
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuQuota() int64 {
	if m != nil && m.CpuQuota != nil {
		return *m.CpuQuota
	}
	return 0
}

func (m *LinuxContainerResources) GetCpuShares() int64 {
	if m != nil && m.CpuShares != nil {
		return *m.CpuShares
	}
	return 0
}

func (m *LinuxContainerResources) GetMemoryLimitInBytes() int64 {
	if m != nil && m.MemoryLimitInBytes != nil {
		return *m.MemoryLimitInBytes
	}
	return 0
}

func (m *LinuxContainerResources) GetOomScoreAdj() int64 {
	if m != nil && m.OomScoreAdj != nil {
		return *m.OomScoreAdj
	}
	return 0
}

// SELinuxOption are the labels to be applied to the container.
type SELinuxOption struct {
	User             *string `protobuf:"bytes,1,opt,name=user" json:"user,omitempty"`
	Role             *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
	Type             *string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	Level            *string `protobuf:"bytes,4,opt,name=level" json:"level,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SELinuxOption) Reset()                    { *m = SELinuxOption{} }
func (m *SELinuxOption) String() string            { return proto.CompactTextString(m) }
func (*SELinuxOption) ProtoMessage()               {}
func (*SELinuxOption) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{29} }

func (m *SELinuxOption) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *SELinuxOption) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *SELinuxOption) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *SELinuxOption) GetLevel() string {
	if m != nil && m.Level != nil {
		return *m.Level
	}
	return ""
}

// Capability contains the container capabilities to add or drop
type Capability struct {
	// List of capabilities to add.
	AddCapabilities []string `protobuf:"bytes,1,rep,name=add_capabilities,json=addCapabilities" json:"add_capabilities,omitempty"`
	// List of capabilities to drop.
	DropCapabilities []string `protobuf:"bytes,2,rep,name=drop_capabilities,json=dropCapabilities" json:"drop_capabilities,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Capability) Reset()                    { *m = Capability{} }
func (m *Capability) String() string            { return proto.CompactTextString(m) }
func (*Capability) ProtoMessage()               {}
func (*Capability) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{30} }

func (m *Capability) GetAddCapabilities() []string {
	if m != nil {
		return m.AddCapabilities
	}
	return nil
}

func (m *Capability) GetDropCapabilities() []string {
	if m != nil {
		return m.DropCapabilities
	}
	return nil
}

// LinuxContainerSecurityContext holds linux security configuration that will be applied to a container.
type LinuxContainerSecurityContext struct {
	// Capabilities to add or drop.
	Capabilities *Capability `protobuf:"bytes,1,opt,name=capabilities" json:"capabilities,omitempty"`
	// If set, run container in privileged mode.
	Privileged *bool `protobuf:"varint,2,opt,name=privileged" json:"privileged,omitempty"`
	// Configurations for the container's namespaces.
	// Only used if the container uses namespace for isolation.
	NamespaceOptions *NamespaceOption `protobuf:"bytes,3,opt,name=namespace_options,json=namespaceOptions" json:"namespace_options,omitempty"`
	// SELinux context to be optionally applied.
	SelinuxOptions *SELinuxOption `protobuf:"bytes,4,opt,name=selinux_options,json=selinuxOptions" json:"selinux_options,omitempty"`
	// UID to run the container process as. Only one of run_as_user and
	// run_as_username can be specified at a time.
	RunAsUser *int64 `protobuf:"varint,5,opt,name=run_as_user,json=runAsUser" json:"run_as_user,omitempty"`
	// User name to run the container process as. If specified, the user MUST
	// exist in the container image (i.e. in the /etc/passwd inside the image),
	// and be resolved there by the runtime; otherwise, the runtime MUST error.
	RunAsUsername *string `protobuf:"bytes,6,opt,name=run_as_username,json=runAsUsername" json:"run_as_username,omitempty"`
	// If set, the root filesystem of the container is read-only.
	ReadonlyRootfs *bool `protobuf:"varint,7,opt,name=readonly_rootfs,json=readonlyRootfs" json:"readonly_rootfs,omitempty"`
	// List of groups applied to the first process run in the container, in
	// addition to the container's primary GID.
	SupplementalGroups []int64 `protobuf:"varint,8,rep,name=supplemental_groups,json=supplementalGroups" json:"supplemental_groups,omitempty"`
	XXX_unrecognized   []byte  `json:"-"`
}

func (m *LinuxContainerSecurityContext) Reset()         { *m = LinuxContainerSecurityContext{} }
func (m *LinuxContainerSecurityContext) String() string { return proto.CompactTextString(m) }
func (*LinuxContainerSecurityContext) ProtoMessage()    {}
func (*LinuxContainerSecurityContext) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{31}
}

func (m *LinuxContainerSecurityContext) GetCapabilities() *Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return false
}

func (m *LinuxContainerSecurityContext) GetNamespaceOptions() *NamespaceOption {
	if m != nil {
		return m.NamespaceOptions
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetSelinuxOptions() *SELinuxOption {
	if m != nil {
		return m.SelinuxOptions
	}
	return nil
}

func (m *LinuxContainerSecurityContext) GetRunAsUser() int64 {
	if m != nil && m.RunAsUser != nil {
		return *m.RunAsUser
	}
	return 0
}

func (m *LinuxContainerSecurityContext) GetRunAsUsername() string {
	if m != nil && m.RunAsUsername != nil {
		return *m.RunAsUsername
	}
	return ""
}

func (m *LinuxContainerSecurityContext) GetReadonlyRootfs() bool {
	if m != nil && m.ReadonlyRootfs != nil {
		return *m.ReadonlyRootfs
	}
	return false
}

func (m *LinuxContainerSecurityContext) GetSupplementalGroups() []int64 {
	if m != nil {
		return m.SupplementalGroups
	}
	return nil
}

// LinuxContainerConfig contains platform-specific configuration for
// Linux-based containers.
type LinuxContainerConfig struct {
	// Resources specification for the container.
	Resources *LinuxContainerResources `protobuf:"bytes,1,opt,name=resources" json:"resources,omitempty"`
	// LinuxContainerSecurityContext configuration for the container.
	SecurityContext  *LinuxContainerSecurityContext `protobuf:"bytes,2,opt,name=security_context,json=securityContext" json:"security_context,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *LinuxContainerConfig) Reset()                    { *m = LinuxContainerConfig{} }
func (m *LinuxContainerConfig) String() string            { return proto.CompactTextString(m) }
func (*LinuxContainerConfig) ProtoMessage()               {}
func (*LinuxContainerConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{32} }

func (m *LinuxContainerConfig) GetResources() *LinuxContainerResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *LinuxContainerConfig) GetSecurityContext() *LinuxContainerSecurityContext {
	if m != nil {
		return m.SecurityContext
	}
	return nil
}

// ContainerMetadata holds all necessary information for building the container
// name. The container runtime is encouraged to expose the metadata in its user
// interface for better user experience. E.g., runtime can construct a unique
// container name based on the metadata. Note that (name, attempt) is unique
// within a sandbox for the entire lifetime of the sandbox.
type ContainerMetadata struct {
	// Name of the container. Same as the container name in the PodSpec.
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Attempt number of creating the container.
	Attempt          *uint32 `protobuf:"varint,2,opt,name=attempt" json:"attempt,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerMetadata) Reset()                    { *m = ContainerMetadata{} }
func (m *ContainerMetadata) String() string            { return proto.CompactTextString(m) }
func (*ContainerMetadata) ProtoMessage()               {}
func (*ContainerMetadata) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{33} }

func (m *ContainerMetadata) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ContainerMetadata) GetAttempt() uint32 {
	if m != nil && m.Attempt != nil {
		return *m.Attempt
	}
	return 0
}

// Device specifies a host device to mount into a container.
type Device struct {
	// Path of the device within the container.
	ContainerPath *string `protobuf:"bytes,1,opt,name=container_path,json=containerPath" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath *string `protobuf:"bytes,2,opt,name=host_path,json=hostPath" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions      *string `protobuf:"bytes,3,opt,name=permissions" json:"permissions,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Device) Reset()                    { *m = Device{} }
func (m *Device) String() string            { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()               {}
func (*Device) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{34} }

func (m *Device) GetContainerPath() string {
	if m != nil && m.ContainerPath != nil {
		return *m.ContainerPath
	}
	return ""
}

func (m *Device) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Device) GetPermissions() string {
	if m != nil && m.Permissions != nil {
		return *m.Permissions
	}
	return ""
}

// ContainerConfig holds all the required and optional fields for creating a
// container.
type ContainerConfig struct {
	// Metadata of the container. This information will uniquely identify the
	// container, and the runtime should leverage this to ensure correct
	// operation. The runtime may also use this information to improve UX, such
	// as by constructing a readable name.
	Metadata *ContainerMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Image to use.
	Image *ImageSpec `protobuf:"bytes,2,opt,name=image" json:"image,omitempty"`
	// Command to execute (i.e., entrypoint for docker)
	Command []string `protobuf:"bytes,3,rep,name=command" json:"command,omitempty"`
	// Args for the Command (i.e., command for docker)
	Args []string `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	// Current working directory of the command.
	WorkingDir *string `protobuf:"bytes,5,opt,name=working_dir,json=workingDir" json:"working_dir,omitempty"`
	// List of environment variable to set in the container.
	Envs []*KeyValue `protobuf:"bytes,6,rep,name=envs" json:"envs,omitempty"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,7,rep,name=mounts" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*Device `protobuf:"bytes,8,rep,name=devices" json:"devices,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	// Label keys are of the form:
	//     label-key ::= prefixed-name | name
	//     prefixed-name ::= prefix '/' name
	//     prefix ::= DNS_SUBDOMAIN
	//     name ::= DNS_LABEL
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Path relative to PodSandboxConfig.LogDirectory for container to store
	// the log (STDOUT and STDERR) on the host.
	// E.g.,
	//     PodSandboxConfig.LogDirectory = `/var/log/pods/<podUID>/`
	//     ContainerConfig.LogPath = `containerName_Instance#.log`
	//
	// WARNING: Log management and how kubelet should interface with the
	// container logs are under active discussion in
	// https://issues.k8s.io/24677. There *may* be future change of direction
	// for logging as the discussion carries on.
	LogPath *string `protobuf:"bytes,11,opt,name=log_path,json=logPath" json:"log_path,omitempty"`
	// Variables for interactive containers, these have very specialized
	// use-cases (e.g. debugging).
	// TODO: Determine if we need to continue supporting these fields that are
	// part of Kubernetes's Container Spec.
	Stdin     *bool `protobuf:"varint,12,opt,name=stdin" json:"stdin,omitempty"`
	StdinOnce *bool `protobuf:"varint,13,opt,name=stdin_once,json=stdinOnce" json:"stdin_once,omitempty"`
	Tty       *bool `protobuf:"varint,14,opt,name=tty" json:"tty,omitempty"`
	// Configuration specific to Linux containers.
	Linux            *LinuxContainerConfig `protobuf:"bytes,15,opt,name=linux" json:"linux,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *ContainerConfig) Reset()                    { *m = ContainerConfig{} }
func (m *ContainerConfig) String() string            { return proto.CompactTextString(m) }
func (*ContainerConfig) ProtoMessage()               {}
func (*ContainerConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{35} }

func (m *ContainerConfig) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerConfig) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerConfig) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ContainerConfig) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *ContainerConfig) GetWorkingDir() string {
	if m != nil && m.WorkingDir != nil {
		return *m.WorkingDir
	}
	return ""
}

func (m *ContainerConfig) GetEnvs() []*KeyValue {
	if m != nil {
		return m.Envs
	}
	return nil
}

func (m *ContainerConfig) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *ContainerConfig) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ContainerConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerConfig) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerConfig) GetLogPath() string {
	if m != nil && m.LogPath != nil {
		return *m.LogPath
	}
	return ""
}

func (m *ContainerConfig) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

func (m *ContainerConfig) GetStdinOnce() bool {
	if m != nil && m.StdinOnce != nil {
		return *m.StdinOnce
	}
	return false
}

func (m *ContainerConfig) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *ContainerConfig) GetLinux() *LinuxContainerConfig {
	if m != nil {
		return m.Linux
	}
	return nil
}

type CreateContainerRequest struct {
	// ID of the PodSandbox in which the container should be created.
	PodSandboxId *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// Config of the container.
	Config *ContainerConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// Config of the PodSandbox. This is the same config that was passed
	// to RunPodSandboxRequest to create the PodSandbox. It is passed again
	// here just for easy reference. The PodSandboxConfig is immutable and
	// remains the same throughout the lifetime of the pod.
	SandboxConfig    *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig" json:"sandbox_config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{36} }

func (m *CreateContainerRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *CreateContainerRequest) GetConfig() *ContainerConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CreateContainerRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type CreateContainerResponse struct {
	// ID of the created container.
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{37} }

func (m *CreateContainerResponse) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type StartContainerRequest struct {
	// ID of the container to start.
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StartContainerRequest) Reset()                    { *m = StartContainerRequest{} }
func (m *StartContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*StartContainerRequest) ProtoMessage()               {}
func (*StartContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{38} }

func (m *StartContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type StartContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StartContainerResponse) Reset()                    { *m = StartContainerResponse{} }
func (m *StartContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*StartContainerResponse) ProtoMessage()               {}
func (*StartContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{39} }

type StopContainerRequest struct {
	// ID of the container to stop.
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// Timeout, in seconds, to stop the container.
	Timeout          *int64 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopContainerRequest) Reset()                    { *m = StopContainerRequest{} }
func (m *StopContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*StopContainerRequest) ProtoMessage()               {}
func (*StopContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{40} }

func (m *StopContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *StopContainerRequest) GetTimeout() int64 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type StopContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StopContainerResponse) Reset()                    { *m = StopContainerResponse{} }
func (m *StopContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*StopContainerResponse) ProtoMessage()               {}
func (*StopContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{41} }

type RemoveContainerRequest struct {
	// ID of the container to remove.
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RemoveContainerRequest) Reset()                    { *m = RemoveContainerRequest{} }
func (m *RemoveContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*RemoveContainerRequest) ProtoMessage()               {}
func (*RemoveContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{42} }

func (m *RemoveContainerRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

type RemoveContainerResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemoveContainerResponse) Reset()                    { *m = RemoveContainerResponse{} }
func (m *RemoveContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*RemoveContainerResponse) ProtoMessage()               {}
func (*RemoveContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{43} }

// ContainerFilter is used to filter containers.
// All those fields are combined with 'AND'
type ContainerFilter struct {
	// ID of the container.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// State of the container.
	State *ContainerState `protobuf:"varint,2,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// ID of the PodSandbox.
	PodSandboxId *string `protobuf:"bytes,3,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// LabelSelector to select matches.
	// Only api.MatchLabels is supported for now and the requirements
	// are ANDed. MatchExpressions is not supported yet.
	LabelSelector    map[string]string `protobuf:"bytes,4,rep,name=label_selector,json=labelSelector" json:"label_selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ContainerFilter) Reset()                    { *m = ContainerFilter{} }
func (m *ContainerFilter) String() string            { return proto.CompactTextString(m) }
func (*ContainerFilter) ProtoMessage()               {}
func (*ContainerFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{44} }

func (m *ContainerFilter) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *ContainerFilter) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (m *ContainerFilter) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *ContainerFilter) GetLabelSelector() map[string]string {
	if m != nil {
		return m.LabelSelector
	}
	return nil
}

type ListContainersRequest struct {
	Filter           *ContainerFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ListContainersRequest) Reset()                    { *m = ListContainersRequest{} }
func (m *ListContainersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListContainersRequest) ProtoMessage()               {}
func (*ListContainersRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{45} }

func (m *ListContainersRequest) GetFilter() *ContainerFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Container provides the runtime information for a container, such as ID, hash,
// state of the container.
type Container struct {
	// ID of the container, used by the container runtime to identify
	// a container.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// ID of the sandbox to which this container belongs.
	PodSandboxId *string `protobuf:"bytes,2,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,3,opt,name=metadata" json:"metadata,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID.
	ImageRef *string `protobuf:"bytes,5,opt,name=image_ref,json=imageRef" json:"image_ref,omitempty"`
	// State of the container.
	State *ContainerState `protobuf:"varint,6,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt *int64 `protobuf:"varint,7,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map that may be set by external
	// tools to store and retrieve arbitrary metadata.
	Annotations      map[string]string `protobuf:"bytes,9,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{46} }

func (m *Container) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Container) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *Container) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Container) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Container) GetImageRef() string {
	if m != nil && m.ImageRef != nil {
		return *m.ImageRef
	}
	return ""
}

func (m *Container) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (m *Container) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *Container) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Container) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type ListContainersResponse struct {
	// List of containers.
	Containers       []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ListContainersResponse) Reset()                    { *m = ListContainersResponse{} }
func (m *ListContainersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListContainersResponse) ProtoMessage()               {}
func (*ListContainersResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{47} }

func (m *ListContainersResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

type ContainerStatusRequest struct {
	// ID of the container for which to retrieve status.
	ContainerId      *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerStatusRequest) Reset()                    { *m = ContainerStatusRequest{} }
func (m *ContainerStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatusRequest) ProtoMessage()               {}
func (*ContainerStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{48} }

func (m *ContainerStatusRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

// ContainerStatus represents the status of a container.
type ContainerStatus struct {
	// ID of the container.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Metadata of the container.
	Metadata *ContainerMetadata `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// Status of the container.
	State *ContainerState `protobuf:"varint,3,opt,name=state,enum=runtime.ContainerState" json:"state,omitempty"`
	// Creation time of the container in nanoseconds.
	CreatedAt *int64 `protobuf:"varint,4,opt,name=created_at,json=createdAt" json:"created_at,omitempty"`
	// Start time of the container in nanoseconds.
	StartedAt *int64 `protobuf:"varint,5,opt,name=started_at,json=startedAt" json:"started_at,omitempty"`
	// Finish time of the container in nanoseconds.
	FinishedAt *int64 `protobuf:"varint,6,opt,name=finished_at,json=finishedAt" json:"finished_at,omitempty"`
	// Exit code of the container.
	ExitCode *int32 `protobuf:"varint,7,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,8,opt,name=image" json:"image,omitempty"`
	// Reference to the image in use. For most runtimes, this should be an
	// image ID
	ImageRef *string `protobuf:"bytes,9,opt,name=image_ref,json=imageRef" json:"image_ref,omitempty"`
	// Brief CamelCase string explaining why container is in its current state.
	Reason *string `protobuf:"bytes,10,opt,name=reason" json:"reason,omitempty"`
	// Human-readable message indicating details about why container is in its
	// current state.
	Message *string `protobuf:"bytes,11,opt,name=message" json:"message,omitempty"`
	// Key-value pairs that may be used to scope and select individual resources.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations is an unstructured key value map.
	Annotations map[string]string `protobuf:"bytes,13,rep,name=annotations" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mounts for the container.
	Mounts           []*Mount `protobuf:"bytes,14,rep,name=mounts" json:"mounts,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ContainerStatus) Reset()                    { *m = ContainerStatus{} }
func (m *ContainerStatus) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatus) ProtoMessage()               {}
func (*ContainerStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{49} }

func (m *ContainerStatus) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *ContainerStatus) GetMetadata() *ContainerMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *ContainerStatus) GetState() ContainerState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ContainerState_CONTAINER_CREATED
}

func (m *ContainerStatus) GetCreatedAt() int64 {
	if m != nil && m.CreatedAt != nil {
		return *m.CreatedAt
	}
	return 0
}

func (m *ContainerStatus) GetStartedAt() int64 {
	if m != nil && m.StartedAt != nil {
		return *m.StartedAt
	}
	return 0
}

func (m *ContainerStatus) GetFinishedAt() int64 {
	if m != nil && m.FinishedAt != nil {
		return *m.FinishedAt
	}
	return 0
}

func (m *ContainerStatus) GetExitCode() int32 {
	if m != nil && m.ExitCode != nil {
		return *m.ExitCode
	}
	return 0
}

func (m *ContainerStatus) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ContainerStatus) GetImageRef() string {
	if m != nil && m.ImageRef != nil {
		return *m.ImageRef
	}
	return ""
}

func (m *ContainerStatus) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *ContainerStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *ContainerStatus) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ContainerStatus) GetAnnotations() map[string]string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ContainerStatus) GetMounts() []*Mount {
	if m != nil {
		return m.Mounts
	}
	return nil
}

type ContainerStatusResponse struct {
	// Status of the container.
	Status           *ContainerStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ContainerStatusResponse) Reset()                    { *m = ContainerStatusResponse{} }
func (m *ContainerStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*ContainerStatusResponse) ProtoMessage()               {}
func (*ContainerStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{50} }

func (m *ContainerStatusResponse) GetStatus() *ContainerStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type ExecSyncRequest struct {
	// ID of the container.
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd" json:"cmd,omitempty"`
	// Timeout in seconds to stop the command. Default: run forever.
	Timeout          *int64 `protobuf:"varint,3,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ExecSyncRequest) Reset()                    { *m = ExecSyncRequest{} }
func (m *ExecSyncRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecSyncRequest) ProtoMessage()               {}
func (*ExecSyncRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{51} }

func (m *ExecSyncRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *ExecSyncRequest) GetCmd() []string {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *ExecSyncRequest) GetTimeout() int64 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type ExecSyncResponse struct {
	// Captured command stdout output.
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout" json:"stdout,omitempty"`
	// Captured command stderr output.
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr" json:"stderr,omitempty"`
	// Exit code the command finished with.
	ExitCode         *int32 `protobuf:"varint,3,opt,name=exit_code,json=exitCode" json:"exit_code,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ExecSyncResponse) Reset()                    { *m = ExecSyncResponse{} }
func (m *ExecSyncResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecSyncResponse) ProtoMessage()               {}
func (*ExecSyncResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{52} }

func (m *ExecSyncResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *ExecSyncResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *ExecSyncResponse) GetExitCode() int32 {
	if m != nil && m.ExitCode != nil {
		return *m.ExitCode
	}
	return 0
}

type ExecRequest struct {
	// ID of the container in which to execute the command.
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// Command to execute.
	Cmd []string `protobuf:"bytes,2,rep,name=cmd" json:"cmd,omitempty"`
	// Whether use tty.
	Tty *bool `protobuf:"varint,3,opt,name=tty" json:"tty,omitempty"`
	// Whether to stream stdin.
	Stdin            *bool  `protobuf:"varint,4,opt,name=stdin" json:"stdin,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ExecRequest) Reset()                    { *m = ExecRequest{} }
func (m *ExecRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecRequest) ProtoMessage()               {}
func (*ExecRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{53} }

func (m *ExecRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *ExecRequest) GetCmd() []string {
	if m != nil {
		return m.Cmd
	}
	return nil
}

func (m *ExecRequest) GetTty() bool {
	if m != nil && m.Tty != nil {
		return *m.Tty
	}
	return false
}

func (m *ExecRequest) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

type ExecResponse struct {
	// Fully qualified URL of the exec streaming server.
	Url              *string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExecResponse) Reset()                    { *m = ExecResponse{} }
func (m *ExecResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecResponse) ProtoMessage()               {}
func (*ExecResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{54} }

func (m *ExecResponse) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

type AttachRequest struct {
	// ID of the container to which to attach.
	ContainerId *string `protobuf:"bytes,1,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
	// Whether to stream stdin.
	Stdin            *bool  `protobuf:"varint,2,opt,name=stdin" json:"stdin,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AttachRequest) Reset()                    { *m = AttachRequest{} }
func (m *AttachRequest) String() string            { return proto.CompactTextString(m) }
func (*AttachRequest) ProtoMessage()               {}
func (*AttachRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{55} }

func (m *AttachRequest) GetContainerId() string {
	if m != nil && m.ContainerId != nil {
		return *m.ContainerId
	}
	return ""
}

func (m *AttachRequest) GetStdin() bool {
	if m != nil && m.Stdin != nil {
		return *m.Stdin
	}
	return false
}

type AttachResponse struct {
	// Fully qualified URL of the attach streaming server.
	Url              *string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AttachResponse) Reset()                    { *m = AttachResponse{} }
func (m *AttachResponse) String() string            { return proto.CompactTextString(m) }
func (*AttachResponse) ProtoMessage()               {}
func (*AttachResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{56} }

func (m *AttachResponse) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

type PortForwardRequest struct {
	// ID of the container to which to forward the port.
	PodSandboxId *string `protobuf:"bytes,1,opt,name=pod_sandbox_id,json=podSandboxId" json:"pod_sandbox_id,omitempty"`
	// Port to forward.
	Port             []int32 `protobuf:"varint,2,rep,name=port" json:"port,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PortForwardRequest) Reset()                    { *m = PortForwardRequest{} }
func (m *PortForwardRequest) String() string            { return proto.CompactTextString(m) }
func (*PortForwardRequest) ProtoMessage()               {}
func (*PortForwardRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{57} }

func (m *PortForwardRequest) GetPodSandboxId() string {
	if m != nil && m.PodSandboxId != nil {
		return *m.PodSandboxId
	}
	return ""
}

func (m *PortForwardRequest) GetPort() []int32 {
	if m != nil {
		return m.Port
	}
	return nil
}

type PortForwardResponse struct {
	// Fully qualified URL of the port-forward streaming server.
	Url              *string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PortForwardResponse) Reset()                    { *m = PortForwardResponse{} }
func (m *PortForwardResponse) String() string            { return proto.CompactTextString(m) }
func (*PortForwardResponse) ProtoMessage()               {}
func (*PortForwardResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{58} }

func (m *PortForwardResponse) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

type ImageFilter struct {
	// Spec of the image.
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImageFilter) Reset()                    { *m = ImageFilter{} }
func (m *ImageFilter) String() string            { return proto.CompactTextString(m) }
func (*ImageFilter) ProtoMessage()               {}
func (*ImageFilter) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{59} }

func (m *ImageFilter) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type ListImagesRequest struct {
	// Filter to list images.
	Filter           *ImageFilter `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ListImagesRequest) Reset()                    { *m = ListImagesRequest{} }
func (m *ListImagesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListImagesRequest) ProtoMessage()               {}
func (*ListImagesRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{60} }

func (m *ListImagesRequest) GetFilter() *ImageFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// Basic information about a container image.
type Image struct {
	// ID of the image.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Other names by which this image is known.
	RepoTags []string `protobuf:"bytes,2,rep,name=repo_tags,json=repoTags" json:"repo_tags,omitempty"`
	// Digests by which this image is known.
	RepoDigests []string `protobuf:"bytes,3,rep,name=repo_digests,json=repoDigests" json:"repo_digests,omitempty"`
	// Size of the image in bytes.
	Size_ *uint64 `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	// UID that will run the command(s). This is used as a default if no user is
	// specified when creating the container. UID and the following user name
	// are mutually exclusive.
	Uid *int64 `protobuf:"varint,5,opt,name=uid" json:"uid,omitempty"`
	// User name that will run the command(s). This is used if UID is not set
	// and no user is specified when creating container.
	Username         *string `protobuf:"bytes,6,opt,name=username" json:"username,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Image) Reset()                    { *m = Image{} }
func (m *Image) String() string            { return proto.CompactTextString(m) }
func (*Image) ProtoMessage()               {}
func (*Image) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{61} }

func (m *Image) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Image) GetRepoTags() []string {
	if m != nil {
		return m.RepoTags
	}
	return nil
}

func (m *Image) GetRepoDigests() []string {
	if m != nil {
		return m.RepoDigests
	}
	return nil
}

func (m *Image) GetSize_() uint64 {
	if m != nil && m.Size_ != nil {
		return *m.Size_
	}
	return 0
}

func (m *Image) GetUid() int64 {
	if m != nil && m.Uid != nil {
		return *m.Uid
	}
	return 0
}

func (m *Image) GetUsername() string {
	if m != nil && m.Username != nil {
		return *m.Username
	}
	return ""
}

type ListImagesResponse struct {
	// List of images.
	Images           []*Image `protobuf:"bytes,1,rep,name=images" json:"images,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ListImagesResponse) Reset()                    { *m = ListImagesResponse{} }
func (m *ListImagesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListImagesResponse) ProtoMessage()               {}
func (*ListImagesResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{62} }

func (m *ListImagesResponse) GetImages() []*Image {
	if m != nil {
		return m.Images
	}
	return nil
}

type ImageStatusRequest struct {
	// Spec of the image.
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImageStatusRequest) Reset()                    { *m = ImageStatusRequest{} }
func (m *ImageStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*ImageStatusRequest) ProtoMessage()               {}
func (*ImageStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63} }

func (m *ImageStatusRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImageStatusResponse struct {
	// Status of the image.
	Image            *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ImageStatusResponse) Reset()                    { *m = ImageStatusResponse{} }
func (m *ImageStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*ImageStatusResponse) ProtoMessage()               {}
func (*ImageStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{64} }

func (m *ImageStatusResponse) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// AuthConfig contains authorization information for connecting to a registry.
type AuthConfig struct {
	Username      *string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	Password      *string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	Auth          *string `protobuf:"bytes,3,opt,name=auth" json:"auth,omitempty"`
	ServerAddress *string `protobuf:"bytes,4,opt,name=server_address,json=serverAddress" json:"server_address,omitempty"`
	// IdentityToken is used to authenticate the user and get
	// an access token for the registry.
	IdentityToken *string `protobuf:"bytes,5,opt,name=identity_token,json=identityToken" json:"identity_token,omitempty"`
	// RegistryToken is a bearer token to be sent to a registry
	RegistryToken    *string `protobuf:"bytes,6,opt,name=registry_token,json=registryToken" json:"registry_token,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AuthConfig) Reset()                    { *m = AuthConfig{} }
func (m *AuthConfig) String() string            { return proto.CompactTextString(m) }
func (*AuthConfig) ProtoMessage()               {}
func (*AuthConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{65} }

func (m *AuthConfig) GetUsername() string {
	if m != nil && m.Username != nil {
		return *m.Username
	}
	return ""
}

func (m *AuthConfig) GetPassword() string {
	if m != nil && m.Password != nil {
		return *m.Password
	}
	return ""
}

func (m *AuthConfig) GetAuth() string {
	if m != nil && m.Auth != nil {
		return *m.Auth
	}
	return ""
}

func (m *AuthConfig) GetServerAddress() string {
	if m != nil && m.ServerAddress != nil {
		return *m.ServerAddress
	}
	return ""
}

func (m *AuthConfig) GetIdentityToken() string {
	if m != nil && m.IdentityToken != nil {
		return *m.IdentityToken
	}
	return ""
}

func (m *AuthConfig) GetRegistryToken() string {
	if m != nil && m.RegistryToken != nil {
		return *m.RegistryToken
	}
	return ""
}

type PullImageRequest struct {
	// Spec of the image.
	Image *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	// Authentication configuration for pulling the image.
	Auth *AuthConfig `protobuf:"bytes,2,opt,name=auth" json:"auth,omitempty"`
	// Config of the PodSandbox, which is used to pull image in PodSandbox context.
	SandboxConfig    *PodSandboxConfig `protobuf:"bytes,3,opt,name=sandbox_config,json=sandboxConfig" json:"sandbox_config,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PullImageRequest) Reset()                    { *m = PullImageRequest{} }
func (m *PullImageRequest) String() string            { return proto.CompactTextString(m) }
func (*PullImageRequest) ProtoMessage()               {}
func (*PullImageRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{66} }

func (m *PullImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *PullImageRequest) GetAuth() *AuthConfig {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *PullImageRequest) GetSandboxConfig() *PodSandboxConfig {
	if m != nil {
		return m.SandboxConfig
	}
	return nil
}

type PullImageResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *PullImageResponse) Reset()                    { *m = PullImageResponse{} }
func (m *PullImageResponse) String() string            { return proto.CompactTextString(m) }
func (*PullImageResponse) ProtoMessage()               {}
func (*PullImageResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67} }

type RemoveImageRequest struct {
	// Spec of the image to remove.
	Image            *ImageSpec `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *RemoveImageRequest) Reset()                    { *m = RemoveImageRequest{} }
func (m *RemoveImageRequest) String() string            { return proto.CompactTextString(m) }
func (*RemoveImageRequest) ProtoMessage()               {}
func (*RemoveImageRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{68} }

func (m *RemoveImageRequest) GetImage() *ImageSpec {
	if m != nil {
		return m.Image
	}
	return nil
}

type RemoveImageResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RemoveImageResponse) Reset()                    { *m = RemoveImageResponse{} }
func (m *RemoveImageResponse) String() string            { return proto.CompactTextString(m) }
func (*RemoveImageResponse) ProtoMessage()               {}
func (*RemoveImageResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{69} }

type NetworkConfig struct {
	// CIDR to use for pod IP addresses.
	PodCidr          *string `protobuf:"bytes,1,opt,name=pod_cidr,json=podCidr" json:"pod_cidr,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NetworkConfig) Reset()                    { *m = NetworkConfig{} }
func (m *NetworkConfig) String() string            { return proto.CompactTextString(m) }
func (*NetworkConfig) ProtoMessage()               {}
func (*NetworkConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{70} }

func (m *NetworkConfig) GetPodCidr() string {
	if m != nil && m.PodCidr != nil {
		return *m.PodCidr
	}
	return ""
}

type RuntimeConfig struct {
	NetworkConfig    *NetworkConfig `protobuf:"bytes,1,opt,name=network_config,json=networkConfig" json:"network_config,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *RuntimeConfig) Reset()                    { *m = RuntimeConfig{} }
func (m *RuntimeConfig) String() string            { return proto.CompactTextString(m) }
func (*RuntimeConfig) ProtoMessage()               {}
func (*RuntimeConfig) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{71} }

func (m *RuntimeConfig) GetNetworkConfig() *NetworkConfig {
	if m != nil {
		return m.NetworkConfig
	}
	return nil
}

type UpdateRuntimeConfigRequest struct {
	RuntimeConfig    *RuntimeConfig `protobuf:"bytes,1,opt,name=runtime_config,json=runtimeConfig" json:"runtime_config,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *UpdateRuntimeConfigRequest) Reset()                    { *m = UpdateRuntimeConfigRequest{} }
func (m *UpdateRuntimeConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRuntimeConfigRequest) ProtoMessage()               {}
func (*UpdateRuntimeConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{72} }

func (m *UpdateRuntimeConfigRequest) GetRuntimeConfig() *RuntimeConfig {
	if m != nil {
		return m.RuntimeConfig
	}
	return nil
}

type UpdateRuntimeConfigResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *UpdateRuntimeConfigResponse) Reset()                    { *m = UpdateRuntimeConfigResponse{} }
func (m *UpdateRuntimeConfigResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRuntimeConfigResponse) ProtoMessage()               {}
func (*UpdateRuntimeConfigResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{73} }

// RuntimeCondition contains condition information for the runtime.
// There are 2 kinds of runtime conditions:
// 1. Required condtitions: Conditions are required for kubelet to work
// properly. If any required condition is unmet, the node will be not ready.
// The required conditions include:
//   * RuntimeReady: RuntimeReady means the runtime is up and ready to accept
//   basic containers e.g. container only needs host network.
//   * NetworkReady: NetworkReady means the runtime network is up and ready to
//   accept containers which require container network.
// 2. Optional conditions: Conditions are informative to the user, but kubelet
// will not rely on. Since condition type is an arbitrary string, all conditions
// not required are optional. These conditions will be exposed to users to help
// them understand the status of the system.
type RuntimeCondition struct {
	// Type of runtime condition.
	Type *string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Status of the condition, one of true/false.
	Status *bool `protobuf:"varint,2,opt,name=status" json:"status,omitempty"`
	// Brief CamelCase string containing reason for the condition's last transition.
	Reason *string `protobuf:"bytes,3,opt,name=reason" json:"reason,omitempty"`
	// Human-readable message indicating details about last transition.
	Message          *string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RuntimeCondition) Reset()                    { *m = RuntimeCondition{} }
func (m *RuntimeCondition) String() string            { return proto.CompactTextString(m) }
func (*RuntimeCondition) ProtoMessage()               {}
func (*RuntimeCondition) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{74} }

func (m *RuntimeCondition) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *RuntimeCondition) GetStatus() bool {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return false
}

func (m *RuntimeCondition) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *RuntimeCondition) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

// RuntimeStatus is information about the current status of the runtime.
type RuntimeStatus struct {
	// List of current observed runtime conditions.
	Conditions       []*RuntimeCondition `protobuf:"bytes,1,rep,name=conditions" json:"conditions,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *RuntimeStatus) Reset()                    { *m = RuntimeStatus{} }
func (m *RuntimeStatus) String() string            { return proto.CompactTextString(m) }
func (*RuntimeStatus) ProtoMessage()               {}
func (*RuntimeStatus) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{75} }

func (m *RuntimeStatus) GetConditions() []*RuntimeCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type StatusRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *StatusRequest) Reset()                    { *m = StatusRequest{} }
func (m *StatusRequest) String() string            { return proto.CompactTextString(m) }
func (*StatusRequest) ProtoMessage()               {}
func (*StatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{76} }

type StatusResponse struct {
	// Status of the Runtime.
	Status           *RuntimeStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *StatusResponse) Reset()                    { *m = StatusResponse{} }
func (m *StatusResponse) String() string            { return proto.CompactTextString(m) }
func (*StatusResponse) ProtoMessage()               {}
func (*StatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{77} }

func (m *StatusResponse) GetStatus() *RuntimeStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*VersionRequest)(nil), "runtime.VersionRequest")
	proto.RegisterType((*VersionResponse)(nil), "runtime.VersionResponse")
	proto.RegisterType((*DNSConfig)(nil), "runtime.DNSConfig")
	proto.RegisterType((*PortMapping)(nil), "runtime.PortMapping")
	proto.RegisterType((*Mount)(nil), "runtime.Mount")
	proto.RegisterType((*NamespaceOption)(nil), "runtime.NamespaceOption")
	proto.RegisterType((*LinuxSandboxSecurityContext)(nil), "runtime.LinuxSandboxSecurityContext")
	proto.RegisterType((*LinuxPodSandboxConfig)(nil), "runtime.LinuxPodSandboxConfig")
	proto.RegisterType((*PodSandboxMetadata)(nil), "runtime.PodSandboxMetadata")
	proto.RegisterType((*PodSandboxConfig)(nil), "runtime.PodSandboxConfig")
	proto.RegisterType((*RunPodSandboxRequest)(nil), "runtime.RunPodSandboxRequest")
	proto.RegisterType((*RunPodSandboxResponse)(nil), "runtime.RunPodSandboxResponse")
	proto.RegisterType((*StopPodSandboxRequest)(nil), "runtime.StopPodSandboxRequest")
	proto.RegisterType((*StopPodSandboxResponse)(nil), "runtime.StopPodSandboxResponse")
	proto.RegisterType((*RemovePodSandboxRequest)(nil), "runtime.RemovePodSandboxRequest")
	proto.RegisterType((*RemovePodSandboxResponse)(nil), "runtime.RemovePodSandboxResponse")
	proto.RegisterType((*PodSandboxStatusRequest)(nil), "runtime.PodSandboxStatusRequest")
	proto.RegisterType((*PodSandboxNetworkStatus)(nil), "runtime.PodSandboxNetworkStatus")
	proto.RegisterType((*Namespace)(nil), "runtime.Namespace")
	proto.RegisterType((*LinuxPodSandboxStatus)(nil), "runtime.LinuxPodSandboxStatus")
	proto.RegisterType((*PodSandboxStatus)(nil), "runtime.PodSandboxStatus")
	proto.RegisterType((*PodSandboxStatusResponse)(nil), "runtime.PodSandboxStatusResponse")
	proto.RegisterType((*PodSandboxFilter)(nil), "runtime.PodSandboxFilter")
	proto.RegisterType((*ListPodSandboxRequest)(nil), "runtime.ListPodSandboxRequest")
	proto.RegisterType((*PodSandbox)(nil), "runtime.PodSandbox")
	proto.RegisterType((*ListPodSandboxResponse)(nil), "runtime.ListPodSandboxResponse")
	proto.RegisterType((*ImageSpec)(nil), "runtime.ImageSpec")
	proto.RegisterType((*KeyValue)(nil), "runtime.KeyValue")
	proto.RegisterType((*LinuxContainerResources)(nil), "runtime.LinuxContainerResources")
	proto.RegisterType((*SELinuxOption)(nil), "runtime.SELinuxOption")
	proto.RegisterType((*Capability)(nil), "runtime.Capability")
	proto.RegisterType((*LinuxContainerSecurityContext)(nil), "runtime.LinuxContainerSecurityContext")
	proto.RegisterType((*LinuxContainerConfig)(nil), "runtime.LinuxContainerConfig")
	proto.RegisterType((*ContainerMetadata)(nil), "runtime.ContainerMetadata")
	proto.RegisterType((*Device)(nil), "runtime.Device")
	proto.RegisterType((*ContainerConfig)(nil), "runtime.ContainerConfig")
	proto.RegisterType((*CreateContainerRequest)(nil), "runtime.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "runtime.CreateContainerResponse")
	proto.RegisterType((*StartContainerRequest)(nil), "runtime.StartContainerRequest")
	proto.RegisterType((*StartContainerResponse)(nil), "runtime.StartContainerResponse")
	proto.RegisterType((*StopContainerRequest)(nil), "runtime.StopContainerRequest")
	proto.RegisterType((*StopContainerResponse)(nil), "runtime.StopContainerResponse")
	proto.RegisterType((*RemoveContainerRequest)(nil), "runtime.RemoveContainerRequest")
	proto.RegisterType((*RemoveContainerResponse)(nil), "runtime.RemoveContainerResponse")
	proto.RegisterType((*ContainerFilter)(nil), "runtime.ContainerFilter")
	proto.RegisterType((*ListContainersRequest)(nil), "runtime.ListContainersRequest")
	proto.RegisterType((*Container)(nil), "runtime.Container")
	proto.RegisterType((*ListContainersResponse)(nil), "runtime.ListContainersResponse")
	proto.RegisterType((*ContainerStatusRequest)(nil), "runtime.ContainerStatusRequest")
	proto.RegisterType((*ContainerStatus)(nil), "runtime.ContainerStatus")
	proto.RegisterType((*ContainerStatusResponse)(nil), "runtime.ContainerStatusResponse")
	proto.RegisterType((*ExecSyncRequest)(nil), "runtime.ExecSyncRequest")
	proto.RegisterType((*ExecSyncResponse)(nil), "runtime.ExecSyncResponse")
	proto.RegisterType((*ExecRequest)(nil), "runtime.ExecRequest")
	proto.RegisterType((*ExecResponse)(nil), "runtime.ExecResponse")
	proto.RegisterType((*AttachRequest)(nil), "runtime.AttachRequest")
	proto.RegisterType((*AttachResponse)(nil), "runtime.AttachResponse")
	proto.RegisterType((*PortForwardRequest)(nil), "runtime.PortForwardRequest")
	proto.RegisterType((*PortForwardResponse)(nil), "runtime.PortForwardResponse")
	proto.RegisterType((*ImageFilter)(nil), "runtime.ImageFilter")
	proto.RegisterType((*ListImagesRequest)(nil), "runtime.ListImagesRequest")
	proto.RegisterType((*Image)(nil), "runtime.Image")
	proto.RegisterType((*ListImagesResponse)(nil), "runtime.ListImagesResponse")
	proto.RegisterType((*ImageStatusRequest)(nil), "runtime.ImageStatusRequest")
	proto.RegisterType((*ImageStatusResponse)(nil), "runtime.ImageStatusResponse")
	proto.RegisterType((*AuthConfig)(nil), "runtime.AuthConfig")
	proto.RegisterType((*PullImageRequest)(nil), "runtime.PullImageRequest")
	proto.RegisterType((*PullImageResponse)(nil), "runtime.PullImageResponse")
	proto.RegisterType((*RemoveImageRequest)(nil), "runtime.RemoveImageRequest")
	proto.RegisterType((*RemoveImageResponse)(nil), "runtime.RemoveImageResponse")
	proto.RegisterType((*NetworkConfig)(nil), "runtime.NetworkConfig")
	proto.RegisterType((*RuntimeConfig)(nil), "runtime.RuntimeConfig")
	proto.RegisterType((*UpdateRuntimeConfigRequest)(nil), "runtime.UpdateRuntimeConfigRequest")
	proto.RegisterType((*UpdateRuntimeConfigResponse)(nil), "runtime.UpdateRuntimeConfigResponse")
	proto.RegisterType((*RuntimeCondition)(nil), "runtime.RuntimeCondition")
	proto.RegisterType((*RuntimeStatus)(nil), "runtime.RuntimeStatus")
	proto.RegisterType((*StatusRequest)(nil), "runtime.StatusRequest")
	proto.RegisterType((*StatusResponse)(nil), "runtime.StatusResponse")
	proto.RegisterEnum("runtime.Protocol", Protocol_name, Protocol_value)
	proto.RegisterEnum("runtime.PodSandboxState", PodSandboxState_name, PodSandboxState_value)
	proto.RegisterEnum("runtime.ContainerState", ContainerState_name, ContainerState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for RuntimeService service

type RuntimeServiceClient interface {
	// Version returns the runtime name, runtime version, and runtime API version.
	Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error)
	// RunPodSandbox creates and starts a pod-level sandbox. Runtimes must ensure
	// the sandbox is in the ready state on success.
	RunPodSandbox(ctx context.Context, in *RunPodSandboxRequest, opts ...grpc.CallOption) (*RunPodSandboxResponse, error)
	// StopPodSandbox stops any running process that is part of the sandbox and
	// reclaims network resources (e.g., IP addresses) allocated to the sandbox.
	// If there are any running containers in the sandbox, they must be forcibly
	// terminated.
	// This call is idempotent, and must not return an error if all relevant
	// resources have already been reclaimed. kubelet will call StopPodSandbox
	// at least once before calling RemovePodSandbox. It will also attempt to
	// reclaim resources eagerly, as soon as a sandbox is not needed. Hence,
	// multiple StopPodSandbox calls are expected.
	StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers
	// in the sandbox, they must be forcibly terminated and removed.
	// This call is idempotent, and must not return an error if the sandbox has
	// already been removed.
	RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox.
	PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of PodSandboxes.
	ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	// This call is idempotent, and must not return an error if the container has
	// already been stopped.
	// TODO: what must the runtime do after the grace period is reached?
	StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container must be forcibly removed.
	// This call is idempotent, and must not return an error if the container has
	// already been removed.
	RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container.
	ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error)
	// ExecSync runs a command in a container synchronously.
	ExecSync(ctx context.Context, in *ExecSyncRequest, opts ...grpc.CallOption) (*ExecSyncResponse, error)
	// Exec prepares a streaming endpoint to execute a command in the container.
	Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error)
	// Attach prepares a streaming endpoint to attach to a running container.
	Attach(ctx context.Context, in *AttachRequest, opts ...grpc.CallOption) (*AttachResponse, error)
	// PortForward prepares a streaming endpoint to forward ports from a PodSandbox.
	PortForward(ctx context.Context, in *PortForwardRequest, opts ...grpc.CallOption) (*PortForwardResponse, error)
	// UpdateRuntimeConfig updates the runtime configuration based on the given request.
	UpdateRuntimeConfig(ctx context.Context, in *UpdateRuntimeConfigRequest, opts ...grpc.CallOption) (*UpdateRuntimeConfigResponse, error)
	// Status returns the status of the runtime.
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error)
}

type runtimeServiceClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeServiceClient(cc *grpc.ClientConn) RuntimeServiceClient {
	return &runtimeServiceClient{cc}
}

func (c *runtimeServiceClient) Version(ctx context.Context, in *VersionRequest, opts ...grpc.CallOption) (*VersionResponse, error) {
	out := new(VersionResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/Version", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RunPodSandbox(ctx context.Context, in *RunPodSandboxRequest, opts ...grpc.CallOption) (*RunPodSandboxResponse, error) {
	out := new(RunPodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/RunPodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopPodSandbox(ctx context.Context, in *StopPodSandboxRequest, opts ...grpc.CallOption) (*StopPodSandboxResponse, error) {
	out := new(StopPodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StopPodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemovePodSandbox(ctx context.Context, in *RemovePodSandboxRequest, opts ...grpc.CallOption) (*RemovePodSandboxResponse, error) {
	out := new(RemovePodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/RemovePodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PodSandboxStatus(ctx context.Context, in *PodSandboxStatusRequest, opts ...grpc.CallOption) (*PodSandboxStatusResponse, error) {
	out := new(PodSandboxStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/PodSandboxStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListPodSandbox(ctx context.Context, in *ListPodSandboxRequest, opts ...grpc.CallOption) (*ListPodSandboxResponse, error) {
	out := new(ListPodSandboxResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ListPodSandbox", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StartContainer(ctx context.Context, in *StartContainerRequest, opts ...grpc.CallOption) (*StartContainerResponse, error) {
	out := new(StartContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StartContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) StopContainer(ctx context.Context, in *StopContainerRequest, opts ...grpc.CallOption) (*StopContainerResponse, error) {
	out := new(StopContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/StopContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) RemoveContainer(ctx context.Context, in *RemoveContainerRequest, opts ...grpc.CallOption) (*RemoveContainerResponse, error) {
	out := new(RemoveContainerResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/RemoveContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ListContainers(ctx context.Context, in *ListContainersRequest, opts ...grpc.CallOption) (*ListContainersResponse, error) {
	out := new(ListContainersResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ListContainers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ContainerStatus(ctx context.Context, in *ContainerStatusRequest, opts ...grpc.CallOption) (*ContainerStatusResponse, error) {
	out := new(ContainerStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ContainerStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) ExecSync(ctx context.Context, in *ExecSyncRequest, opts ...grpc.CallOption) (*ExecSyncResponse, error) {
	out := new(ExecSyncResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/ExecSync", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Exec(ctx context.Context, in *ExecRequest, opts ...grpc.CallOption) (*ExecResponse, error) {
	out := new(ExecResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/Exec", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Attach(ctx context.Context, in *AttachRequest, opts ...grpc.CallOption) (*AttachResponse, error) {
	out := new(AttachResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/Attach", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) PortForward(ctx context.Context, in *PortForwardRequest, opts ...grpc.CallOption) (*PortForwardResponse, error) {
	out := new(PortForwardResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/PortForward", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) UpdateRuntimeConfig(ctx context.Context, in *UpdateRuntimeConfigRequest, opts ...grpc.CallOption) (*UpdateRuntimeConfigResponse, error) {
	out := new(UpdateRuntimeConfigResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/UpdateRuntimeConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeServiceClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error) {
	out := new(StatusResponse)
	err := grpc.Invoke(ctx, "/runtime.RuntimeService/Status", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RuntimeService service

type RuntimeServiceServer interface {
	// Version returns the runtime name, runtime version, and runtime API version.
	Version(context.Context, *VersionRequest) (*VersionResponse, error)
	// RunPodSandbox creates and starts a pod-level sandbox. Runtimes must ensure
	// the sandbox is in the ready state on success.
	RunPodSandbox(context.Context, *RunPodSandboxRequest) (*RunPodSandboxResponse, error)
	// StopPodSandbox stops any running process that is part of the sandbox and
	// reclaims network resources (e.g., IP addresses) allocated to the sandbox.
	// If there are any running containers in the sandbox, they must be forcibly
	// terminated.
	// This call is idempotent, and must not return an error if all relevant
	// resources have already been reclaimed. kubelet will call StopPodSandbox
	// at least once before calling RemovePodSandbox. It will also attempt to
	// reclaim resources eagerly, as soon as a sandbox is not needed. Hence,
	// multiple StopPodSandbox calls are expected.
	StopPodSandbox(context.Context, *StopPodSandboxRequest) (*StopPodSandboxResponse, error)
	// RemovePodSandbox removes the sandbox. If there are any running containers
	// in the sandbox, they must be forcibly terminated and removed.
	// This call is idempotent, and must not return an error if the sandbox has
	// already been removed.
	RemovePodSandbox(context.Context, *RemovePodSandboxRequest) (*RemovePodSandboxResponse, error)
	// PodSandboxStatus returns the status of the PodSandbox.
	PodSandboxStatus(context.Context, *PodSandboxStatusRequest) (*PodSandboxStatusResponse, error)
	// ListPodSandbox returns a list of PodSandboxes.
	ListPodSandbox(context.Context, *ListPodSandboxRequest) (*ListPodSandboxResponse, error)
	// CreateContainer creates a new container in specified PodSandbox
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	// StartContainer starts the container.
	StartContainer(context.Context, *StartContainerRequest) (*StartContainerResponse, error)
	// StopContainer stops a running container with a grace period (i.e., timeout).
	// This call is idempotent, and must not return an error if the container has
	// already been stopped.
	// TODO: what must the runtime do after the grace period is reached?
	StopContainer(context.Context, *StopContainerRequest) (*StopContainerResponse, error)
	// RemoveContainer removes the container. If the container is running, the
	// container must be forcibly removed.
	// This call is idempotent, and must not return an error if the container has
	// already been removed.
	RemoveContainer(context.Context, *RemoveContainerRequest) (*RemoveContainerResponse, error)
	// ListContainers lists all containers by filters.
	ListContainers(context.Context, *ListContainersRequest) (*ListContainersResponse, error)
	// ContainerStatus returns status of the container.
	ContainerStatus(context.Context, *ContainerStatusRequest) (*ContainerStatusResponse, error)
	// ExecSync runs a command in a container synchronously.
	ExecSync(context.Context, *ExecSyncRequest) (*ExecSyncResponse, error)
	// Exec prepares a streaming endpoint to execute a command in the container.
	Exec(context.Context, *ExecRequest) (*ExecResponse, error)
	// Attach prepares a streaming endpoint to attach to a running container.
	Attach(context.Context, *AttachRequest) (*AttachResponse, error)
	// PortForward prepares a streaming endpoint to forward ports from a PodSandbox.
	PortForward(context.Context, *PortForwardRequest) (*PortForwardResponse, error)
	// UpdateRuntimeConfig updates the runtime configuration based on the given request.
	UpdateRuntimeConfig(context.Context, *UpdateRuntimeConfigRequest) (*UpdateRuntimeConfigResponse, error)
	// Status returns the status of the runtime.
	Status(context.Context, *StatusRequest) (*StatusResponse, error)
}

func RegisterRuntimeServiceServer(s *grpc.Server, srv RuntimeServiceServer) {
	s.RegisterService(&_RuntimeService_serviceDesc, srv)
}

func _RuntimeService_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Version(ctx, req.(*VersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RunPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RunPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/RunPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RunPodSandbox(ctx, req.(*RunPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StopPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopPodSandbox(ctx, req.(*StopPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemovePodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/RemovePodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemovePodSandbox(ctx, req.(*RemovePodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PodSandboxStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PodSandboxStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/PodSandboxStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PodSandboxStatus(ctx, req.(*PodSandboxStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListPodSandbox_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPodSandboxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ListPodSandbox",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListPodSandbox(ctx, req.(*ListPodSandboxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StartContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StartContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StartContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StartContainer(ctx, req.(*StartContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_StopContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).StopContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/StopContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).StopContainer(ctx, req.(*StopContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_RemoveContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/RemoveContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).RemoveContainer(ctx, req.(*RemoveContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ListContainers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ListContainers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ListContainers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ListContainers(ctx, req.(*ListContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ContainerStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ContainerStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ContainerStatus(ctx, req.(*ContainerStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_ExecSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecSyncRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).ExecSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/ExecSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).ExecSync(ctx, req.(*ExecSyncRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Exec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Exec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/Exec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Exec(ctx, req.(*ExecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Attach_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Attach(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/Attach",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Attach(ctx, req.(*AttachRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_PortForward_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PortForwardRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).PortForward(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/PortForward",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).PortForward(ctx, req.(*PortForwardRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_UpdateRuntimeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRuntimeConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).UpdateRuntimeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/UpdateRuntimeConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).UpdateRuntimeConfig(ctx, req.(*UpdateRuntimeConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeService_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeServiceServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.RuntimeService/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeServiceServer).Status(ctx, req.(*StatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.RuntimeService",
	HandlerType: (*RuntimeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Version",
			Handler:    _RuntimeService_Version_Handler,
		},
		{
			MethodName: "RunPodSandbox",
			Handler:    _RuntimeService_RunPodSandbox_Handler,
		},
		{
			MethodName: "StopPodSandbox",
			Handler:    _RuntimeService_StopPodSandbox_Handler,
		},
		{
			MethodName: "RemovePodSandbox",
			Handler:    _RuntimeService_RemovePodSandbox_Handler,
		},
		{
			MethodName: "PodSandboxStatus",
			Handler:    _RuntimeService_PodSandboxStatus_Handler,
		},
		{
			MethodName: "ListPodSandbox",
			Handler:    _RuntimeService_ListPodSandbox_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _RuntimeService_CreateContainer_Handler,
		},
		{
			MethodName: "StartContainer",
			Handler:    _RuntimeService_StartContainer_Handler,
		},
		{
			MethodName: "StopContainer",
			Handler:    _RuntimeService_StopContainer_Handler,
		},
		{
			MethodName: "RemoveContainer",
			Handler:    _RuntimeService_RemoveContainer_Handler,
		},
		{
			MethodName: "ListContainers",
			Handler:    _RuntimeService_ListContainers_Handler,
		},
		{
			MethodName: "ContainerStatus",
			Handler:    _RuntimeService_ContainerStatus_Handler,
		},
		{
			MethodName: "ExecSync",
			Handler:    _RuntimeService_ExecSync_Handler,
		},
		{
			MethodName: "Exec",
			Handler:    _RuntimeService_Exec_Handler,
		},
		{
			MethodName: "Attach",
			Handler:    _RuntimeService_Attach_Handler,
		},
		{
			MethodName: "PortForward",
			Handler:    _RuntimeService_PortForward_Handler,
		},
		{
			MethodName: "UpdateRuntimeConfig",
			Handler:    _RuntimeService_UpdateRuntimeConfig_Handler,
		},
		{
			MethodName: "Status",
			Handler:    _RuntimeService_Status_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptorApi,
}

// Client API for ImageService service

type ImageServiceClient interface {
	// ListImages lists existing images.
	ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image. If the image is not
	// present, returns nil.
	ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// This call is idempotent, and must not return an error if the image has
	// already been removed.
	RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error)
}

type imageServiceClient struct {
	cc *grpc.ClientConn
}

func NewImageServiceClient(cc *grpc.ClientConn) ImageServiceClient {
	return &imageServiceClient{cc}
}

func (c *imageServiceClient) ListImages(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ListImagesResponse, error) {
	out := new(ListImagesResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/ListImages", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) ImageStatus(ctx context.Context, in *ImageStatusRequest, opts ...grpc.CallOption) (*ImageStatusResponse, error) {
	out := new(ImageStatusResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/ImageStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) PullImage(ctx context.Context, in *PullImageRequest, opts ...grpc.CallOption) (*PullImageResponse, error) {
	out := new(PullImageResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/PullImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageServiceClient) RemoveImage(ctx context.Context, in *RemoveImageRequest, opts ...grpc.CallOption) (*RemoveImageResponse, error) {
	out := new(RemoveImageResponse)
	err := grpc.Invoke(ctx, "/runtime.ImageService/RemoveImage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ImageService service

type ImageServiceServer interface {
	// ListImages lists existing images.
	ListImages(context.Context, *ListImagesRequest) (*ListImagesResponse, error)
	// ImageStatus returns the status of the image. If the image is not
	// present, returns nil.
	ImageStatus(context.Context, *ImageStatusRequest) (*ImageStatusResponse, error)
	// PullImage pulls an image with authentication config.
	PullImage(context.Context, *PullImageRequest) (*PullImageResponse, error)
	// RemoveImage removes the image.
	// This call is idempotent, and must not return an error if the image has
	// already been removed.
	RemoveImage(context.Context, *RemoveImageRequest) (*RemoveImageResponse, error)
}

func RegisterImageServiceServer(s *grpc.Server, srv ImageServiceServer) {
	s.RegisterService(&_ImageService_serviceDesc, srv)
}

func _ImageService_ListImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ListImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/ListImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ListImages(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_ImageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).ImageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/ImageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).ImageStatus(ctx, req.(*ImageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_PullImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).PullImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/PullImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).PullImage(ctx, req.(*PullImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageService_RemoveImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageServiceServer).RemoveImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/runtime.ImageService/RemoveImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageServiceServer).RemoveImage(ctx, req.(*RemoveImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "runtime.ImageService",
	HandlerType: (*ImageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListImages",
			Handler:    _ImageService_ListImages_Handler,
		},
		{
			MethodName: "ImageStatus",
			Handler:    _ImageService_ImageStatus_Handler,
		},
		{
			MethodName: "PullImage",
			Handler:    _ImageService_PullImage_Handler,
		},
		{
			MethodName: "RemoveImage",
			Handler:    _ImageService_RemoveImage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptorApi,
}

var fileDescriptorApi = []byte{
	// 3365 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xcc, 0x3a, 0xdb, 0x72, 0x1b, 0xc7,
	0xb1, 0x04, 0x40, 0x82, 0x40, 0x83, 0x00, 0xc1, 0x21, 0x45, 0x42, 0xa0, 0x25, 0x51, 0x6b, 0x49,
	0x96, 0x64, 0x5b, 0xc7, 0xe2, 0x39, 0xc7, 0x3a, 0x96, 0x2d, 0xd9, 0x30, 0x49, 0xfb, 0xd0, 0x92,
	0x20, 0x7a, 0x21, 0x39, 0x76, 0xf9, 0x61, 0xb3, 0xc2, 0x0e, 0xc1, 0x95, 0x80, 0xdd, 0xf5, 0xee,
	0x80, 0x16, 0xf3, 0x05, 0x79, 0x48, 0xaa, 0xf2, 0xea, 0xa7, 0xa4, 0x52, 0xa9, 0x72, 0x25, 0x79,
	0x4b, 0x55, 0xaa, 0xf2, 0x0f, 0xa9, 0x7c, 0x40, 0x3e, 0x21, 0x7f, 0x91, 0x9a, 0xdb, 0xee, 0xcc,
	0x5e, 0x28, 0x52, 0x76, 0xc5, 0x7a, 0xdb, 0xe9, 0xe9, 0xe9, 0xe9, 0xdb, 0xf4, 0x74, 0xf7, 0x2c,
	0xd4, 0xed, 0xc0, 0xbd, 0x11, 0x84, 0x3e, 0xf1, 0xd1, 0x7c, 0x38, 0xf5, 0x88, 0x3b, 0xc1, 0xc6,
	0x75, 0x68, 0x7d, 0x81, 0xc3, 0xc8, 0xf5, 0x3d, 0x13, 0x7f, 0x33, 0xc5, 0x11, 0x41, 0x1d, 0x98,
	0x3f, 0xe4, 0x90, 0x4e, 0x69, 0xa3, 0x74, 0xb5, 0x6e, 0xca, 0xa1, 0xf1, 0x7d, 0x09, 0x16, 0x63,
	0xe4, 0x28, 0xf0, 0xbd, 0x08, 0x17, 0x63, 0xa3, 0x8b, 0xb0, 0x20, 0x36, 0xb1, 0x3c, 0x7b, 0x82,
	0x3b, 0x65, 0x36, 0xdd, 0x10, 0xb0, 0xbe, 0x3d, 0xc1, 0xe8, 0x0d, 0x58, 0x94, 0x28, 0x92, 0x48,
	0x85, 0x61, 0xb5, 0x04, 0x58, 0xec, 0x86, 0x6e, 0xc0, 0xb2, 0x44, 0xb4, 0x03, 0x37, 0x46, 0x9e,
	0x65, 0xc8, 0x4b, 0x62, 0xaa, 0x17, 0xb8, 0x02, 0xdf, 0xf8, 0x1a, 0xea, 0xdb, 0xfd, 0xc1, 0x96,
	0xef, 0xed, 0xbb, 0x23, 0xca, 0x62, 0x84, 0x43, 0xba, 0xa6, 0x53, 0xda, 0xa8, 0x50, 0x16, 0xc5,
	0x10, 0x75, 0xa1, 0x16, 0x61, 0x3b, 0x1c, 0x1e, 0xe0, 0xa8, 0x53, 0x66, 0x53, 0xf1, 0x98, 0xae,
	0xf2, 0x03, 0xe2, 0xfa, 0x5e, 0xd4, 0xa9, 0xf0, 0x55, 0x62, 0x68, 0x7c, 0x57, 0x82, 0xc6, 0x9e,
	0x1f, 0x92, 0x07, 0x76, 0x10, 0xb8, 0xde, 0x08, 0xbd, 0x0d, 0x35, 0xa6, 0xd4, 0xa1, 0x3f, 0x66,
	0x3a, 0x68, 0x6d, 0x2e, 0xdd, 0x10, 0x2c, 0xdd, 0xd8, 0x13, 0x13, 0x66, 0x8c, 0x82, 0x2e, 0x43,
	0x6b, 0xe8, 0x7b, 0xc4, 0x76, 0x3d, 0x1c, 0x5a, 0x81, 0x1f, 0x12, 0xa6, 0x99, 0x39, 0xb3, 0x19,
	0x43, 0x29, 0x71, 0xb4, 0x0e, 0xf5, 0x03, 0x3f, 0x22, 0x1c, 0xa3, 0xc2, 0x30, 0x6a, 0x14, 0xc0,
	0x26, 0xd7, 0x60, 0x9e, 0x4d, 0xba, 0x81, 0xd0, 0x41, 0x95, 0x0e, 0x77, 0x03, 0xe3, 0x37, 0x25,
	0x98, 0x7b, 0xe0, 0x4f, 0x3d, 0x92, 0xda, 0xc6, 0x26, 0x07, 0xc2, 0x3e, 0xca, 0x36, 0x36, 0x39,
	0x48, 0xb6, 0xa1, 0x18, 0xdc, 0x44, 0x7c, 0x1b, 0x3a, 0xd9, 0x85, 0x5a, 0x88, 0x6d, 0xc7, 0xf7,
	0xc6, 0x47, 0x8c, 0x85, 0x9a, 0x19, 0x8f, 0xa9, 0xed, 0x22, 0x3c, 0x76, 0xbd, 0xe9, 0x73, 0x2b,
	0xc4, 0x63, 0xfb, 0x09, 0x1e, 0x33, 0x56, 0x6a, 0x66, 0x4b, 0x80, 0x4d, 0x0e, 0x35, 0x9e, 0xc2,
	0x22, 0x35, 0x76, 0x14, 0xd8, 0x43, 0xfc, 0x90, 0xa9, 0x90, 0xba, 0x06, 0xdb, 0xd4, 0xc3, 0xe4,
	0x5b, 0x3f, 0x7c, 0xc6, 0x38, 0xab, 0x99, 0x0d, 0x0a, 0xeb, 0x73, 0x10, 0x3a, 0x0b, 0x35, 0xce,
	0x97, 0xeb, 0x30, 0xb6, 0x6a, 0x26, 0x93, 0x78, 0xcf, 0x75, 0xe2, 0x29, 0x37, 0x18, 0x0a, 0xae,
	0xe6, 0xb9, 0xf4, 0x43, 0xe3, 0xb7, 0x65, 0x58, 0xbf, 0x4f, 0x37, 0x1f, 0xd8, 0x9e, 0xf3, 0xc4,
	0x7f, 0x3e, 0xc0, 0xc3, 0x69, 0xe8, 0x92, 0xa3, 0x2d, 0xdf, 0x23, 0xf8, 0x39, 0x41, 0x3b, 0xb0,
	0xe4, 0x49, 0x5e, 0x2c, 0x69, 0x5e, 0xba, 0x7b, 0x63, 0xb3, 0x13, 0xdb, 0x2c, 0xc5, 0xad, 0xd9,
	0xf6, 0x74, 0x40, 0x84, 0x3e, 0x4c, 0x64, 0x97, 0x44, 0xca, 0x8c, 0xc8, 0x6a, 0x4c, 0x64, 0xb0,
	0xc3, 0xf8, 0x10, 0x24, 0xa4, 0x4e, 0x24, 0x81, 0xf3, 0x40, 0xcf, 0x81, 0x65, 0x47, 0xd6, 0x34,
	0xc2, 0x21, 0x93, 0xa2, 0x62, 0xd6, 0xc3, 0xa9, 0xd7, 0x8b, 0x1e, 0x47, 0x38, 0x64, 0x07, 0x43,
	0x28, 0xda, 0x0a, 0x7d, 0x9f, 0xec, 0x47, 0x52, 0xb9, 0x12, 0x6c, 0x32, 0x28, 0xfa, 0x2f, 0x58,
	0x8e, 0xa6, 0x41, 0x30, 0xc6, 0x13, 0xec, 0x11, 0x7b, 0x6c, 0x8d, 0x42, 0x7f, 0x1a, 0x44, 0x9d,
	0xb9, 0x8d, 0xca, 0xd5, 0x8a, 0x89, 0xd4, 0xa9, 0x4f, 0xd9, 0x8c, 0xf1, 0xeb, 0x12, 0x9c, 0x61,
	0x9c, 0xed, 0xf9, 0x8e, 0x50, 0x92, 0x38, 0x26, 0xaf, 0x43, 0x73, 0xc8, 0x96, 0x5b, 0x81, 0x1d,
	0x62, 0x8f, 0x08, 0x7f, 0x59, 0xe0, 0xc0, 0x3d, 0x06, 0x43, 0x0f, 0xa1, 0x1d, 0x09, 0x9d, 0x5a,
	0x43, 0xae, 0x54, 0x21, 0xfa, 0xa5, 0x58, 0xf4, 0x63, 0x0c, 0x60, 0x2e, 0x46, 0x3a, 0xc0, 0x08,
	0x01, 0x25, 0x9c, 0x3c, 0xc0, 0xc4, 0x76, 0x6c, 0x62, 0x23, 0x04, 0xb3, 0x2c, 0x66, 0x70, 0x16,
	0xd8, 0x37, 0x6a, 0x43, 0x65, 0x2a, 0x9c, 0xa1, 0x6e, 0xd2, 0x4f, 0xf4, 0x1a, 0xd4, 0x63, 0xd3,
	0x88, 0xc0, 0x91, 0x00, 0xe8, 0x01, 0xb6, 0x09, 0xc1, 0x93, 0x80, 0x30, 0xdd, 0x35, 0x4d, 0x39,
	0x34, 0xfe, 0x36, 0x0b, 0xed, 0x8c, 0xf8, 0xb7, 0xa0, 0x36, 0x11, 0xdb, 0x0b, 0x8f, 0x58, 0x4f,
	0x4e, 0x71, 0x86, 0x43, 0x33, 0x46, 0xa6, 0x87, 0x84, 0xba, 0x9f, 0x12, 0xe3, 0xe2, 0x31, 0xd5,
	0xe9, 0xd8, 0x1f, 0x59, 0x8e, 0x1b, 0xe2, 0x21, 0xf1, 0xc3, 0x23, 0xc1, 0xe5, 0xc2, 0xd8, 0x1f,
	0x6d, 0x4b, 0x18, 0xba, 0x09, 0xe0, 0x78, 0x11, 0x55, 0xe7, 0xbe, 0x3b, 0x62, 0xbc, 0x36, 0x36,
	0x51, 0xbc, 0x77, 0x1c, 0xc7, 0xcc, 0xba, 0xe3, 0x45, 0x82, 0xd9, 0xf7, 0xa0, 0x49, 0xe3, 0x82,
	0x35, 0xe1, 0x21, 0x88, 0x1b, 0xbc, 0xb1, 0xb9, 0xa2, 0x70, 0x1c, 0xc7, 0x27, 0x73, 0x21, 0x48,
	0x06, 0x11, 0xba, 0x03, 0x55, 0x76, 0x2e, 0xa3, 0x4e, 0x95, 0xad, 0xb9, 0x9c, 0x23, 0x25, 0xdf,
	0xe5, 0xc6, 0x7d, 0x86, 0xb7, 0xe3, 0x91, 0xf0, 0xc8, 0x14, 0x8b, 0xd0, 0x7d, 0x68, 0xd8, 0x9e,
	0xe7, 0x13, 0x9b, 0xbb, 0xfd, 0x3c, 0xa3, 0x71, 0xbd, 0x98, 0x46, 0x2f, 0x41, 0xe6, 0x84, 0xd4,
	0xe5, 0xe8, 0x7f, 0x60, 0x8e, 0x9d, 0x8b, 0x4e, 0x8d, 0x49, 0x7d, 0x5e, 0xf7, 0xa1, 0x34, 0x31,
	0x93, 0x23, 0x77, 0xdf, 0x83, 0x86, 0xc2, 0x1a, 0x75, 0x8c, 0x67, 0xf8, 0x48, 0xf8, 0x0a, 0xfd,
	0x44, 0x2b, 0x30, 0x77, 0x68, 0x8f, 0xa7, 0xd2, 0x1e, 0x7c, 0x70, 0xbb, 0xfc, 0x7f, 0xa5, 0xee,
	0x5d, 0x68, 0xa7, 0x39, 0x3a, 0xcd, 0x7a, 0x63, 0x17, 0x56, 0xcc, 0xa9, 0x97, 0x30, 0x26, 0x2f,
	0xcd, 0x9b, 0x50, 0x15, 0xf6, 0xe3, 0xbe, 0x73, 0xb6, 0x50, 0x23, 0xa6, 0x40, 0x34, 0xee, 0xc0,
	0x99, 0x14, 0x29, 0x71, 0xa5, 0x5e, 0x82, 0x56, 0xe0, 0x3b, 0x56, 0xc4, 0xc1, 0x96, 0xeb, 0xc8,
	0x93, 0x18, 0xc4, 0xb8, 0xbb, 0x0e, 0x5d, 0x3e, 0x20, 0x7e, 0x90, 0x65, 0xe5, 0x64, 0xcb, 0x3b,
	0xb0, 0x9a, 0x5e, 0xce, 0xb7, 0x37, 0x3e, 0x84, 0x35, 0x13, 0x4f, 0xfc, 0x43, 0xfc, 0xb2, 0xa4,
	0xbb, 0xd0, 0xc9, 0x12, 0x48, 0x88, 0x27, 0xd0, 0x01, 0xb1, 0xc9, 0x34, 0x3a, 0x1d, 0xf1, 0x6b,
	0x2a, 0x01, 0x71, 0x59, 0x70, 0x3a, 0xa8, 0x05, 0x65, 0x37, 0x10, 0x8b, 0xca, 0x6e, 0x60, 0x7c,
	0x05, 0xf5, 0xbe, 0x1a, 0x0d, 0xd4, 0xdb, 0xa6, 0x6e, 0xca, 0x21, 0xda, 0x4c, 0x2e, 0xfa, 0xf2,
	0x0b, 0x6e, 0x82, 0x38, 0x05, 0xb8, 0x97, 0x09, 0xa2, 0x82, 0x87, 0x4d, 0x80, 0x38, 0x02, 0xc9,
	0x9b, 0x05, 0x65, 0xe9, 0x99, 0x0a, 0x96, 0xf1, 0x07, 0x2d, 0x1c, 0x29, 0xc2, 0x38, 0xb1, 0x30,
	0x8e, 0x16, 0x9e, 0xca, 0xa7, 0x09, 0x4f, 0x37, 0x60, 0x2e, 0x22, 0x36, 0xe1, 0x01, 0xb2, 0xa5,
	0x08, 0xa7, 0x6f, 0x89, 0x4d, 0x8e, 0x86, 0xce, 0x01, 0x0c, 0x43, 0x6c, 0x13, 0xec, 0x58, 0x36,
	0x8f, 0x9c, 0x15, 0xb3, 0x2e, 0x20, 0x3d, 0x82, 0x6e, 0x27, 0x7a, 0x9c, 0x63, 0x6c, 0x6c, 0xe4,
	0x10, 0xd4, 0xec, 0x92, 0x68, 0x3a, 0x3e, 0xed, 0xd5, 0xe3, 0x4f, 0xbb, 0x58, 0xc7, 0x91, 0x95,
	0x80, 0x35, 0x5f, 0x18, 0xb0, 0xf8, 0x8a, 0x93, 0x04, 0xac, 0x5a, 0x61, 0xc0, 0x12, 0x34, 0x8e,
	0x0d, 0x58, 0x3f, 0x65, 0xe8, 0x79, 0x00, 0x9d, 0xec, 0xd1, 0x11, 0x21, 0xe3, 0x26, 0x54, 0x23,
	0x06, 0x39, 0x26, 0xfc, 0x88, 0x25, 0x02, 0xd1, 0xf8, 0x57, 0x49, 0xf5, 0xba, 0x4f, 0xdc, 0x31,
	0xc1, 0x61, 0xc6, 0xeb, 0x62, 0xe7, 0x29, 0x9f, 0xcc, 0x79, 0x06, 0xd0, 0x62, 0x6a, 0xb7, 0x22,
	0x3c, 0x66, 0xb7, 0x1b, 0xcb, 0x9d, 0x1b, 0x9b, 0x6f, 0xe5, 0x2c, 0xe4, 0x5b, 0x72, 0x9b, 0x0d,
	0x04, 0x3a, 0xd7, 0x78, 0x73, 0xac, 0xc2, 0xba, 0x1f, 0x01, 0xca, 0x22, 0x9d, 0x4a, 0x75, 0x9f,
	0xd1, 0xe3, 0x4a, 0x53, 0xe7, 0x9c, 0xb0, 0xbd, 0xcf, 0xd8, 0x38, 0x46, 0x6f, 0x9c, 0x4f, 0x53,
	0x20, 0x1a, 0xbf, 0xab, 0x00, 0x24, 0x93, 0xaf, 0xec, 0x39, 0xbd, 0x15, 0x9f, 0x1a, 0x9e, 0x1a,
	0x5c, 0xc8, 0xa1, 0x97, 0x7b, 0x5e, 0x3e, 0xd1, 0xcf, 0x0b, 0x4f, 0x12, 0x2e, 0xe5, 0xad, 0x7e,
	0x65, 0x4f, 0xca, 0x16, 0xac, 0xa6, 0xcd, 0x2d, 0xce, 0xc9, 0x35, 0x98, 0x73, 0x09, 0x9e, 0xf0,
	0x42, 0xb0, 0xb1, 0xb9, 0x9c, 0x23, 0x96, 0xc9, 0x31, 0x8c, 0x8b, 0x50, 0xdf, 0x9d, 0xd8, 0x23,
	0x3c, 0x08, 0xf0, 0x90, 0xee, 0xe5, 0xd2, 0x81, 0xd8, 0x9f, 0x0f, 0x8c, 0x4d, 0xa8, 0xdd, 0xc3,
	0x47, 0x5f, 0xd0, 0x7d, 0x4f, 0xca, 0x9f, 0xf1, 0xf7, 0x12, 0xac, 0xb1, 0x70, 0xb7, 0x25, 0xcb,
	0x30, 0x13, 0x47, 0xfe, 0x34, 0x1c, 0xe2, 0x88, 0x99, 0x34, 0x98, 0x5a, 0x01, 0x0e, 0x5d, 0x9f,
	0xfb, 0x14, 0x35, 0x69, 0x30, 0xdd, 0x63, 0x00, 0x5a, 0xaa, 0xd1, 0xe9, 0x6f, 0xa6, 0xbe, 0xf0,
	0xad, 0x8a, 0x59, 0x1b, 0x06, 0xd3, 0xcf, 0xe9, 0x58, 0xae, 0x8d, 0x0e, 0xec, 0x10, 0x47, 0xb2,
	0xa0, 0x18, 0x06, 0xd3, 0x01, 0x03, 0xa0, 0x9b, 0x70, 0x66, 0x82, 0x27, 0x7e, 0x78, 0x64, 0x8d,
	0xdd, 0x89, 0x4b, 0x2c, 0xd7, 0xb3, 0x9e, 0x1c, 0x11, 0x1c, 0x09, 0xc7, 0x41, 0x7c, 0xf2, 0x3e,
	0x9d, 0xdb, 0xf5, 0x3e, 0xa6, 0x33, 0xc8, 0x80, 0xa6, 0xef, 0x4f, 0xac, 0x68, 0xe8, 0x87, 0xd8,
	0xb2, 0x9d, 0xa7, 0x2c, 0xde, 0x57, 0xcc, 0x86, 0xef, 0x4f, 0x06, 0x14, 0xd6, 0x73, 0x9e, 0x1a,
	0x36, 0x34, 0xb5, 0x42, 0x87, 0x26, 0xee, 0xac, 0xa2, 0x11, 0x89, 0x3b, 0xfd, 0xa6, 0xb0, 0xd0,
	0x1f, 0x4b, 0x3d, 0xb0, 0x6f, 0x0a, 0x23, 0x47, 0x81, 0xcc, 0xda, 0xd9, 0x37, 0x55, 0xd8, 0x18,
	0x1f, 0x8a, 0x3a, 0xb2, 0x6e, 0xf2, 0x81, 0xe1, 0x00, 0x6c, 0xd9, 0x81, 0xfd, 0xc4, 0x1d, 0xbb,
	0xe4, 0x08, 0x5d, 0x83, 0xb6, 0xed, 0x38, 0xd6, 0x50, 0x42, 0x5c, 0x2c, 0x8b, 0xfa, 0x45, 0xdb,
	0x71, 0xb6, 0x14, 0x30, 0x7a, 0x13, 0x96, 0x9c, 0xd0, 0x0f, 0x74, 0x5c, 0x5e, 0xe5, 0xb7, 0xe9,
	0x84, 0x8a, 0x6c, 0xfc, 0xbe, 0x02, 0xe7, 0x74, 0xb3, 0xa4, 0x4b, 0xc7, 0x5b, 0xb0, 0x90, 0xda,
	0xb5, 0xa4, 0x79, 0x50, 0xc2, 0xa4, 0xa9, 0x21, 0xa2, 0xf3, 0x00, 0x41, 0xe8, 0x1e, 0xba, 0x63,
	0x3c, 0xc2, 0xb2, 0x96, 0x55, 0x20, 0xf9, 0x35, 0x69, 0xe5, 0xc7, 0xa8, 0x49, 0x67, 0x7f, 0x48,
	0x4d, 0x3a, 0x97, 0xae, 0x49, 0xaf, 0xb0, 0x66, 0x8d, 0x9c, 0x67, 0xe5, 0x4e, 0x95, 0x77, 0x14,
	0x62, 0x1c, 0x4f, 0x36, 0x75, 0x52, 0xb5, 0xeb, 0xfc, 0x69, 0x6a, 0xd7, 0x5a, 0x61, 0xed, 0xfa,
	0xc7, 0x12, 0xac, 0xe8, 0x46, 0x12, 0xe5, 0xd0, 0x5d, 0xa8, 0x87, 0xf2, 0x14, 0x09, 0xc3, 0x6c,
	0xe8, 0xc9, 0x45, 0xf6, 0xb4, 0x99, 0xc9, 0x12, 0xf4, 0x79, 0x61, 0x55, 0x7b, 0xa5, 0x80, 0xcc,
	0x0b, 0xeb, 0xda, 0x1e, 0x2c, 0xc5, 0xc8, 0xc7, 0x96, 0xb5, 0x4a, 0x99, 0x5a, 0xd6, 0xcb, 0x54,
	0x0f, 0xaa, 0xdb, 0xf8, 0xd0, 0x1d, 0xe2, 0x1f, 0xa5, 0x97, 0xb3, 0x01, 0x8d, 0x00, 0x87, 0x13,
	0x37, 0x8a, 0x62, 0x07, 0xab, 0x9b, 0x2a, 0xc8, 0xf8, 0xe7, 0x1c, 0x2c, 0xa6, 0x35, 0xfb, 0x6e,
	0xa6, 0x2a, 0xee, 0x26, 0x1e, 0x9f, 0x96, 0x4f, 0xb9, 0xcd, 0xae, 0xca, 0x80, 0x59, 0x4e, 0xa5,
	0xc0, 0x71, 0x4c, 0x15, 0x41, 0x94, 0xca, 0x3f, 0xf4, 0x27, 0x13, 0xdb, 0x73, 0x64, 0x9f, 0x4d,
	0x0c, 0xa9, 0xb6, 0xec, 0x70, 0x44, 0xdd, 0x98, 0x82, 0xd9, 0x37, 0xba, 0x00, 0x0d, 0x9a, 0x4a,
	0xba, 0x1e, 0x2b, 0xaa, 0x99, 0x93, 0xd6, 0x4d, 0x10, 0xa0, 0x6d, 0x37, 0x44, 0x97, 0x61, 0x16,
	0x7b, 0x87, 0xf2, 0xde, 0x4a, 0x1a, 0x71, 0x32, 0x50, 0x9b, 0x6c, 0x1a, 0x5d, 0x81, 0xea, 0xc4,
	0x9f, 0x7a, 0x44, 0x26, 0x95, 0xad, 0x18, 0x91, 0x75, 0xcf, 0x4c, 0x31, 0x8b, 0xae, 0xc1, 0xbc,
	0xc3, 0x6c, 0x20, 0x33, 0xc7, 0xc5, 0xa4, 0x30, 0x67, 0x70, 0x53, 0xce, 0xa3, 0x0f, 0xe2, 0x1b,
	0xb7, 0x9e, 0xba, 0x33, 0x53, 0x4a, 0xcd, 0xbd, 0x76, 0xef, 0xe9, 0xd7, 0x2e, 0x30, 0x12, 0xd7,
	0x0a, 0x49, 0x1c, 0x5f, 0x56, 0x9f, 0x85, 0xda, 0xd8, 0x1f, 0x71, 0x3f, 0x68, 0xf0, 0x6a, 0x67,
	0xec, 0x8f, 0x98, 0x1b, 0xac, 0xd0, 0x34, 0xc3, 0x71, 0xbd, 0xce, 0x02, 0x3b, 0x93, 0x7c, 0x40,
	0x6f, 0x0f, 0xf6, 0x61, 0xf9, 0xde, 0x10, 0x77, 0x9a, 0x6c, 0xaa, 0xce, 0x20, 0x0f, 0xbd, 0x21,
	0xbb, 0xdc, 0x08, 0x39, 0xea, 0xb4, 0x18, 0x9c, 0x7e, 0xa2, 0xff, 0x96, 0xa9, 0xfc, 0x22, 0xb3,
	0xef, 0xb9, 0x82, 0x63, 0xf2, 0xca, 0xd4, 0xed, 0x7f, 0x29, 0xc1, 0xea, 0x16, 0x4b, 0x8e, 0x94,
	0x48, 0x70, 0x8a, 0xba, 0x13, 0xbd, 0x13, 0x17, 0xf8, 0xe9, 0x22, 0x31, 0x2d, 0xac, 0xc0, 0x43,
	0x1f, 0x41, 0x4b, 0xd2, 0x14, 0x2b, 0x2b, 0x2f, 0x6a, 0x0d, 0x34, 0x23, 0x75, 0x68, 0x7c, 0x00,
	0x6b, 0x19, 0x9e, 0x45, 0x22, 0x73, 0x11, 0x16, 0x92, 0x88, 0x10, 0xb3, 0xdc, 0x88, 0x61, 0xbb,
	0x8e, 0x71, 0x1b, 0xce, 0x0c, 0x88, 0x1d, 0x92, 0x8c, 0xc0, 0x27, 0x58, 0xcb, 0xba, 0x03, 0xfa,
	0x5a, 0x51, 0xc0, 0x0f, 0x60, 0x65, 0x40, 0xfc, 0xe0, 0x25, 0x88, 0xd2, 0x93, 0x4e, 0xc5, 0xf6,
	0xa7, 0x44, 0x64, 0x2f, 0x72, 0x68, 0xac, 0xf1, 0x5e, 0x46, 0x76, 0xb7, 0xf7, 0x61, 0x95, 0xb7,
	0x12, 0x5e, 0x46, 0x88, 0xb3, 0xb2, 0x91, 0x91, 0xa5, 0xfb, 0xab, 0xb2, 0x12, 0xea, 0x0a, 0x6a,
	0x9f, 0xb7, 0xf5, 0xda, 0x67, 0x2d, 0x6b, 0x70, 0x2d, 0x1f, 0xcf, 0xba, 0x51, 0x25, 0xc7, 0x8d,
	0xcc, 0x4c, 0x81, 0x34, 0xcb, 0x4e, 0xfa, 0x9b, 0x59, 0xea, 0xff, 0xc1, 0xfa, 0x68, 0x97, 0xd7,
	0x47, 0xf1, 0xd6, 0x71, 0x4f, 0xe6, 0x9d, 0x54, 0x7d, 0xd4, 0x29, 0x62, 0x33, 0x2e, 0x8f, 0x7e,
	0x39, 0x0b, 0xf5, 0x78, 0x2e, 0xa3, 0xd3, 0xac, 0x92, 0xca, 0x39, 0x4a, 0x52, 0x2f, 0x9d, 0xca,
	0xcb, 0x5c, 0x3a, 0xb3, 0x2f, 0xba, 0x74, 0xd6, 0xa1, 0xce, 0x3e, 0xac, 0x10, 0xef, 0x8b, 0x4b,
	0xa4, 0xc6, 0x00, 0x26, 0xde, 0x4f, 0x0c, 0x5f, 0x3d, 0x91, 0xe1, 0xf5, 0x42, 0x6c, 0x3e, 0x5d,
	0x88, 0xbd, 0x1b, 0x5f, 0x0b, 0xfc, 0x02, 0x39, 0x9f, 0x25, 0x97, 0x7b, 0x21, 0xec, 0xe8, 0x17,
	0x02, 0xbf, 0x53, 0x5e, 0xcf, 0x59, 0xfc, 0xca, 0x96, 0x61, 0xf7, 0x79, 0x19, 0xa6, 0x7a, 0x95,
	0x88, 0x5e, 0x9b, 0x00, 0xf1, 0x41, 0x95, 0xb5, 0x18, 0xca, 0x8a, 0x66, 0x2a, 0x58, 0x34, 0x14,
	0x68, 0xfa, 0x4f, 0x1a, 0x87, 0x27, 0x08, 0x05, 0x7f, 0x56, 0x53, 0x9b, 0x82, 0x0e, 0xdb, 0xbb,
	0x99, 0xca, 0xfd, 0x64, 0x5e, 0xf7, 0xb6, 0x5e, 0xb8, 0x9f, 0xce, 0x5d, 0x32, 0x75, 0x3b, 0xbb,
	0x89, 0xed, 0x50, 0x4c, 0x8b, 0x24, 0x5c, 0x40, 0x7a, 0x84, 0xe6, 0x3f, 0xfb, 0xae, 0xe7, 0x46,
	0x07, 0x7c, 0xbe, 0xca, 0xe6, 0x41, 0x82, 0x7a, 0xec, 0xd9, 0x10, 0x3f, 0x77, 0x89, 0x35, 0xf4,
	0x1d, 0xcc, 0x9c, 0x71, 0xce, 0xac, 0x51, 0xc0, 0x96, 0xef, 0xe0, 0xe4, 0x80, 0xd4, 0x4e, 0x75,
	0x40, 0xea, 0xa9, 0x03, 0xb2, 0x0a, 0xd5, 0x10, 0xdb, 0x91, 0xef, 0x75, 0x80, 0x3f, 0x3e, 0xf2,
	0x11, 0x0d, 0xf0, 0x13, 0x1c, 0x45, 0x74, 0x03, 0x91, 0x75, 0x88, 0xa1, 0x92, 0x1b, 0x2d, 0x14,
	0xe5, 0x46, 0xc7, 0xb4, 0xf0, 0x52, 0xb9, 0x51, 0xb3, 0x28, 0x37, 0x3a, 0x49, 0x07, 0x4f, 0xc9,
	0xfc, 0x5a, 0xc7, 0x65, 0x7e, 0x3f, 0xe5, 0xc1, 0xb9, 0x07, 0x6b, 0x19, 0x57, 0x17, 0x27, 0xe7,
	0x9d, 0x54, 0xa3, 0xaf, 0x53, 0xa4, 0x85, 0xb8, 0xcf, 0xf7, 0x73, 0x58, 0xdc, 0x79, 0x8e, 0x87,
	0x83, 0x23, 0x6f, 0x78, 0x8a, 0xbb, 0xba, 0x0d, 0x95, 0xe1, 0xc4, 0x11, 0xe5, 0x32, 0xfd, 0x54,
	0x6f, 0xef, 0x8a, 0x7e, 0x7b, 0x5b, 0xd0, 0x4e, 0x76, 0x10, 0x7c, 0xae, 0x52, 0x3e, 0x1d, 0x8a,
	0x4c, 0x89, 0x2f, 0x98, 0x62, 0x24, 0xe0, 0x38, 0x0c, 0x99, 0xd4, 0x1c, 0x8e, 0xc3, 0x50, 0x77,
	0xdb, 0x8a, 0xee, 0xb6, 0xc6, 0x53, 0x68, 0xd0, 0x0d, 0x7e, 0x10, 0xfb, 0x22, 0x85, 0xad, 0x24,
	0x29, 0x6c, 0x9c, 0x09, 0xcf, 0x2a, 0x99, 0xb0, 0xb1, 0x01, 0x0b, 0x7c, 0x2f, 0x21, 0x48, 0x1b,
	0x2a, 0xd3, 0x70, 0x2c, 0xed, 0x36, 0x0d, 0xc7, 0xc6, 0xff, 0x43, 0xb3, 0x47, 0x88, 0x3d, 0x3c,
	0x38, 0x05, 0x3f, 0xf1, 0x5e, 0x65, 0x75, 0x2f, 0x03, 0x5a, 0x92, 0x52, 0xe1, 0x6e, 0x7d, 0x40,
	0x7b, 0x7e, 0x48, 0x3e, 0xf1, 0xc3, 0x6f, 0xed, 0xd0, 0x39, 0x5d, 0xce, 0x8a, 0x60, 0x56, 0xfc,
	0x5f, 0x50, 0xb9, 0x3a, 0x67, 0xb2, 0x6f, 0xe3, 0x0d, 0x58, 0xd6, 0xe8, 0x15, 0x6e, 0x7c, 0x0b,
	0x1a, 0x2c, 0x2a, 0x88, 0xec, 0xe8, 0xaa, 0xda, 0x01, 0x3b, 0x2e, 0x74, 0xd0, 0xca, 0x97, 0x86,
	0x7d, 0x06, 0x8f, 0x63, 0xf4, 0x5b, 0xa9, 0x44, 0x62, 0x45, 0x5f, 0x9f, 0x4a, 0x22, 0xbe, 0x2b,
	0xc1, 0x1c, 0x83, 0x67, 0x82, 0xf4, 0x3a, 0xad, 0xf4, 0x03, 0xdf, 0x22, 0xf6, 0x28, 0xfe, 0x65,
	0x83, 0x02, 0x1e, 0xd9, 0xa3, 0x88, 0xfd, 0x71, 0x42, 0x27, 0x1d, 0x77, 0x84, 0x23, 0x22, 0xff,
	0xdb, 0x68, 0x50, 0xd8, 0x36, 0x07, 0x51, 0x95, 0x44, 0xee, 0x2f, 0x78, 0x86, 0x30, 0x6b, 0xb2,
	0x6f, 0xf9, 0xb0, 0xcc, 0x63, 0x2d, 0x7b, 0x58, 0xee, 0x42, 0x2d, 0xd5, 0xe3, 0x88, 0xc7, 0xc6,
	0x07, 0x80, 0x54, 0xf1, 0x84, 0xfe, 0xae, 0x40, 0x95, 0x49, 0x2f, 0x6f, 0xb3, 0x96, 0x2e, 0x9f,
	0x29, 0x66, 0x8d, 0xbb, 0x80, 0xb8, 0xc2, 0xb4, 0x1b, 0xec, 0xe4, 0xca, 0x7d, 0x1f, 0x96, 0xb5,
	0xf5, 0xf1, 0x93, 0xa1, 0x46, 0x20, 0xbd, 0xbb, 0x58, 0xfc, 0x8f, 0x12, 0x40, 0x6f, 0x4a, 0x0e,
	0x44, 0x6d, 0xaf, 0x4a, 0x59, 0xd2, 0xa5, 0xa4, 0x73, 0x81, 0x1d, 0x45, 0xdf, 0xfa, 0xa1, 0x4c,
	0xd1, 0xe2, 0x31, 0xab, 0xcb, 0xa7, 0xe4, 0x40, 0xf6, 0xee, 0xe8, 0x37, 0xba, 0x0c, 0x2d, 0xfe,
	0x53, 0x8d, 0x65, 0x3b, 0x4e, 0x88, 0xa3, 0x48, 0x34, 0xf1, 0x9a, 0x1c, 0xda, 0xe3, 0x40, 0x8a,
	0xe6, 0x3a, 0xd8, 0x23, 0x2e, 0x39, 0xb2, 0x88, 0xff, 0x0c, 0x7b, 0x22, 0xf9, 0x6a, 0x4a, 0xe8,
	0x23, 0x0a, 0xa4, 0x68, 0x21, 0x1e, 0xb9, 0x11, 0x09, 0x25, 0x9a, 0xec, 0x34, 0x09, 0x28, 0x43,
	0x33, 0xbe, 0x2f, 0x41, 0x7b, 0x6f, 0x3a, 0x1e, 0x73, 0x21, 0x4f, 0xab, 0x4b, 0xf4, 0x86, 0x90,
	0xa3, 0x9c, 0xea, 0xe4, 0x25, 0x2a, 0x12, 0xc2, 0xfd, 0xf0, 0x4a, 0x6e, 0x19, 0x96, 0x14, 0x46,
	0x45, 0x11, 0x72, 0x17, 0x10, 0xaf, 0x4f, 0x5e, 0x8e, 0x7f, 0xe3, 0x0c, 0x2c, 0x6b, 0xeb, 0x05,
	0xd9, 0xeb, 0xd0, 0x14, 0xef, 0x6f, 0xc2, 0xce, 0x67, 0xa1, 0x46, 0x83, 0xc5, 0xd0, 0x75, 0x64,
	0x5f, 0x76, 0x3e, 0xf0, 0x9d, 0x2d, 0xd7, 0x09, 0x8d, 0x3e, 0x34, 0x4d, 0x4e, 0x5e, 0xe0, 0xde,
	0x81, 0x96, 0x78, 0xad, 0xb3, 0xb4, 0xf7, 0xec, 0xa4, 0x89, 0xa8, 0xd1, 0x36, 0x9b, 0x9e, 0x3a,
	0x34, 0xbe, 0x86, 0xee, 0xe3, 0xc0, 0xa1, 0xd9, 0x8e, 0x4a, 0x55, 0x8a, 0x76, 0x07, 0xe4, 0x7f,
	0x5d, 0x45, 0xc4, 0xf5, 0x65, 0xcd, 0x50, 0x1d, 0x1a, 0xe7, 0x60, 0x3d, 0x97, 0xb8, 0x90, 0x3b,
	0x80, 0x76, 0x32, 0xe1, 0xb8, 0xb2, 0x1d, 0xcd, 0xda, 0xcc, 0x25, 0xa5, 0xcd, 0xbc, 0x1a, 0x5f,
	0xa1, 0x3c, 0x18, 0x8b, 0x91, 0x92, 0xd5, 0x54, 0x8a, 0xb2, 0x9a, 0x59, 0x2d, 0xab, 0x31, 0x3e,
	0x8b, 0xb5, 0x27, 0x52, 0xca, 0xf7, 0x58, 0x5e, 0xcb, 0xf7, 0x96, 0x91, 0xe0, 0x6c, 0x8e, 0x70,
	0x1c, 0xc3, 0x54, 0x90, 0x8d, 0x45, 0x68, 0x6a, 0x31, 0xc1, 0xf8, 0x08, 0x5a, 0xa9, 0x43, 0x7e,
	0x23, 0x75, 0xf7, 0x67, 0xd4, 0xa6, 0xdf, 0xfc, 0xd7, 0x5f, 0x83, 0x9a, 0xfc, 0xfd, 0x0c, 0xcd,
	0x43, 0xe5, 0xd1, 0xd6, 0x5e, 0x7b, 0x86, 0x7e, 0x3c, 0xde, 0xde, 0x6b, 0x97, 0xae, 0xdf, 0x86,
	0xc5, 0xd4, 0xcb, 0x12, 0x5a, 0x82, 0xe6, 0xa0, 0xd7, 0xdf, 0xfe, 0xf8, 0xe1, 0x97, 0x96, 0xb9,
	0xd3, 0xdb, 0xfe, 0xaa, 0x3d, 0x83, 0x56, 0xa0, 0x2d, 0x41, 0xfd, 0x87, 0x8f, 0x38, 0xb4, 0x74,
	0xfd, 0x19, 0xb4, 0xf4, 0xe4, 0x16, 0x9d, 0x81, 0xa5, 0xad, 0x87, 0xfd, 0x47, 0xbd, 0xdd, 0xfe,
	0x8e, 0x69, 0x6d, 0x99, 0x3b, 0xbd, 0x47, 0x3b, 0xdb, 0xed, 0x19, 0x1d, 0x6c, 0x3e, 0xee, 0xf7,
	0x77, 0xfb, 0x9f, 0xb6, 0x4b, 0x94, 0x6a, 0x02, 0xde, 0xf9, 0x72, 0x97, 0x22, 0x97, 0x75, 0xe4,
	0xc7, 0xfd, 0x7b, 0xfd, 0x87, 0x3f, 0xeb, 0xb7, 0x2b, 0x9b, 0x7f, 0x6a, 0x40, 0x4b, 0x0a, 0x88,
	0x43, 0xd6, 0x0f, 0xbd, 0x0b, 0xf3, 0xf2, 0xcf, 0xc0, 0x24, 0xdd, 0xd6, 0x7f, 0x63, 0xec, 0x76,
	0xb2, 0x13, 0xc2, 0x51, 0x66, 0xd0, 0x1e, 0x33, 0x9c, 0xf2, 0x8a, 0x77, 0x4e, 0x55, 0x65, 0xe6,
	0x99, 0xb0, 0x7b, 0xbe, 0x68, 0x3a, 0xa6, 0x38, 0xa0, 0xd6, 0x52, 0x7f, 0xa7, 0x40, 0xc9, 0x9a,
	0xdc, 0xdf, 0x34, 0xba, 0x17, 0x0a, 0xe7, 0x63, 0xa2, 0x5f, 0x41, 0x3b, 0xfd, 0x23, 0x05, 0x4a,
	0xfa, 0xda, 0x05, 0x3f, 0x69, 0x74, 0x2f, 0x1e, 0x83, 0xa1, 0x92, 0xce, 0xfc, 0x72, 0xb0, 0x51,
	0xfc, 0x68, 0x9c, 0x21, 0x5d, 0xf4, 0x12, 0xcd, 0x55, 0xa1, 0xbf, 0xbe, 0x21, 0xf5, 0xa1, 0x3f,
	0xe7, 0x15, 0x56, 0x51, 0x45, 0xfe, 0xb3, 0x9d, 0x31, 0x83, 0xbe, 0x80, 0xc5, 0x54, 0x2b, 0x0c,
	0x25, 0xab, 0xf2, 0x1b, 0x7b, 0xdd, 0x8d, 0x62, 0x04, 0xdd, 0x6e, 0x6a, 0xa3, 0x4b, 0xb3, 0x5b,
	0x4e, 0xf7, 0x4c, 0xb3, 0x5b, 0x6e, 0x87, 0x8c, 0xb9, 0x97, 0xd6, 0xce, 0x52, 0xdc, 0x2b, 0xaf,
	0x77, 0xd6, 0x3d, 0x5f, 0x34, 0xad, 0x8a, 0x9f, 0x6a, 0x65, 0x29, 0xe2, 0xe7, 0x77, 0xc8, 0xba,
	0x1b, 0xc5, 0x08, 0x69, 0x5b, 0x25, 0x25, 0x7a, 0xca, 0x56, 0x99, 0x8e, 0x50, 0xca, 0x56, 0xd9,
	0xda, 0x5e, 0xd8, 0x2a, 0x55, 0x6b, 0x5f, 0x28, 0x2c, 0x53, 0xb2, 0xb6, 0xca, 0xaf, 0x7c, 0x8c,
	0x19, 0xd4, 0x83, 0x9a, 0xac, 0x33, 0x50, 0x72, 0xba, 0x53, 0xc5, 0x4d, 0xf7, 0x6c, 0xce, 0x4c,
	0x4c, 0xe2, 0x7f, 0x61, 0x96, 0x42, 0xd1, 0x8a, 0x86, 0x24, 0x97, 0x9e, 0x49, 0x41, 0xe3, 0x65,
	0xef, 0x43, 0x95, 0x27, 0xea, 0x28, 0x89, 0xb9, 0x5a, 0x0d, 0xd0, 0x5d, 0xcb, 0xc0, 0xe3, 0xc5,
	0x9f, 0xf1, 0xbf, 0x85, 0x45, 0xc6, 0x8d, 0xd6, 0xb5, 0x7f, 0xf4, 0xf4, 0xbc, 0xbe, 0xfb, 0x5a,
	0xfe, 0x64, 0x4c, 0xeb, 0x09, 0x2c, 0xe7, 0x5c, 0x81, 0x28, 0x69, 0x0b, 0x15, 0xdf, 0xbe, 0xdd,
	0x4b, 0xc7, 0x23, 0xa9, 0xc2, 0x0a, 0xab, 0xad, 0xaa, 0xae, 0xae, 0x18, 0x6b, 0x2d, 0x03, 0x97,
	0x8b, 0x37, 0xff, 0x5a, 0x86, 0x05, 0x9e, 0xa8, 0x88, 0x50, 0xfd, 0x29, 0x40, 0x92, 0x2e, 0xa3,
	0xae, 0xe6, 0x3d, 0x5a, 0x89, 0xd0, 0x5d, 0xcf, 0x9d, 0x53, 0xd5, 0xa8, 0x64, 0xbe, 0x8a, 0x1a,
	0xb3, 0xf9, 0xb4, 0xa2, 0xc6, 0x9c, 0x64, 0xd9, 0x98, 0x41, 0xdb, 0x50, 0x8f, 0xd3, 0x31, 0xa4,
	0x64, 0x71, 0xa9, 0x5c, 0xb2, 0xdb, 0xcd, 0x9b, 0x52, 0x39, 0x52, 0xf2, 0x2f, 0x85, 0xa3, 0x6c,
	0x56, 0xa7, 0x70, 0x94, 0x97, 0xb2, 0xcd, 0xfc, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xf3, 0x7c,
	0x10, 0x9b, 0x2f, 0x00, 0x00,
}
