#!/bin/bash

# Copyright 2016 The Kubernetes Authors All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This script builds all the minikube binary for all 3 platforms as well as Windows-installer and .deb
# This is intended to be run on a new release tag in order to build/upload the required files for a release

# The script expects the following env variabls:
# VERSION_MAJOR: The the major version of the tag to be released.
# VERSION_MINOR: The the minor version of the tag to be released.
# VERSION_BUILD: The the build version of the tag to be released.
# BUCKET: The GCP bucket the build files should be uploaded to.
# GITHUB_TOKEN: The Github API access token. Injected by the Jenkins credential provider. 

set -e

export TAGNAME=v${VERSION_MAJOR}.${VERSION_MINOR}.${VERSION_BUILD}
export DEB_VERSION=${VERSION_MAJOR}.${VERSION_MINOR}-${VERSION_BUILD}

# Sanity checks
git status

# Make sure the tag matches the Makefile
cat Makefile | grep "VERSION_MAJOR ?=" | grep $VERSION_MAJOR
cat Makefile | grep "VERSION_MINOR ?=" | grep $VERSION_MINOR
cat Makefile | grep "VERSION_BUILD ?=" | grep $VERSION_BUILD

# Build and upload
make cross checksum

gsutil cp out/minikube-linux-amd64 gs://$BUCKET/releases/$TAGNAME/
gsutil cp out/minikube-linux-amd64.sha256 gs://$BUCKET/releases/$TAGNAME/
gsutil cp out/minikube-darwin-amd64 gs://$BUCKET/releases/$TAGNAME/
gsutil cp out/minikube-darwin-amd64.sha256 gs://$BUCKET/releases/$TAGNAME/
gsutil cp out/minikube-windows-amd64.exe gs://$BUCKET/releases/$TAGNAME/
gsutil cp out/minikube-windows-amd64.exe.sha256 gs://$BUCKET/releases/$TAGNAME/

make out/minikube-installer.exe 
gsutil cp out/minikube-installer.exe gs://$BUCKET/releases/$TAGNAME/

make out/minikube_${DEB_VERSION}.deb
gsutil cp out/minikube_${DEB_VERSION}.deb gs://$BUCKET/releases/$TAGNAME/

# Bump latest
gsutil cp -r gs://$BUCKET/releases/$TAGNAME/* gs://$BUCKET/releases/latest/
