# Filesystem

Scan a local project including language-specific files.

```bash
$ trivy fs /path/to/project
```

## Standalone mode
### Local Project
Trivy will look for vulnerabilities based on lock files such as Gemfile.lock and package-lock.json.

```
$ trivy fs ~/src/github.com/aquasecurity/trivy-ci-test
```

<details>
<summary>Result</summary>

```
2020-06-01T17:06:58.652+0300    WARN    OS is not detected and vulnerabilities in OS packages are not detected.
2020-06-01T17:06:58.652+0300    INFO    Detecting pipenv vulnerabilities...
2020-06-01T17:06:58.691+0300    INFO    Detecting cargo vulnerabilities...

Pipfile.lock
============
Total: 10 (UNKNOWN: 2, LOW: 0, MEDIUM: 6, HIGH: 2, CRITICAL: 0)

+---------------------+------------------+----------+-------------------+------------------------+------------------------------------+
|       LIBRARY       | VULNERABILITY ID | SEVERITY | INSTALLED VERSION |     FIXED VERSION      |               TITLE                |
+---------------------+------------------+----------+-------------------+------------------------+------------------------------------+
| django              | CVE-2020-7471    | HIGH     | 2.0.9             | 3.0.3, 2.2.10, 1.11.28 | django: potential                  |
|                     |                  |          |                   |                        | SQL injection via                  |
|                     |                  |          |                   |                        | StringAgg(delimiter)               |
+                     +------------------+----------+                   +------------------------+------------------------------------+
|                     | CVE-2019-19844   | MEDIUM   |                   | 3.0.1, 2.2.9, 1.11.27  | Django: crafted email address      |
|                     |                  |          |                   |                        | allows account takeover            |
+                     +------------------+          +                   +------------------------+------------------------------------+
|                     | CVE-2019-3498    |          |                   | 2.1.5, 2.0.10, 1.11.18 | python-django: Content             |
|                     |                  |          |                   |                        | spoofing via URL path in           |
|                     |                  |          |                   |                        | default 404 page                   |
+                     +------------------+          +                   +------------------------+------------------------------------+
|                     | CVE-2019-6975    |          |                   | 2.1.6, 2.0.11, 1.11.19 | python-django:                     |
|                     |                  |          |                   |                        | memory exhaustion in               |
|                     |                  |          |                   |                        | django.utils.numberformat.format() |
+---------------------+------------------+----------+-------------------+------------------------+------------------------------------+
...
```

</details>

### Single file
It's also possible to scan a single file.

```
$ trivy fs ~/src/github.com/aquasecurity/trivy-ci-test/Pipfile.lock
```

## Client/Server mode
You must launch Trivy server in advance. 

```sh
$ trivy server
```

Then, Trivy works as a client if you specify the `--server` option.

```sh
$ trivy fs --server http://localhost:4954 --severity CRITICAL ./integration/testdata/fixtures/fs/pom/
```

<details>
<summary>Result</summary>

```
pom.xml (pom)
=============
Total: 4 (CRITICAL: 4)

+---------------------------------------------+------------------+----------+-------------------+--------------------------------+---------------------------------------+
|                   LIBRARY                   | VULNERABILITY ID | SEVERITY | INSTALLED VERSION |         FIXED VERSION          |                 TITLE                 |
+---------------------------------------------+------------------+----------+-------------------+--------------------------------+---------------------------------------+
| com.fasterxml.jackson.core:jackson-databind | CVE-2017-17485   | CRITICAL | 2.9.1             | 2.8.11, 2.9.4                  | jackson-databind: Unsafe              |
|                                             |                  |          |                   |                                | deserialization due to                |
|                                             |                  |          |                   |                                | incomplete black list (incomplete     |
|                                             |                  |          |                   |                                | fix for CVE-2017-15095)...            |
|                                             |                  |          |                   |                                | -->avd.aquasec.com/nvd/cve-2017-17485 |
+                                             +------------------+          +                   +--------------------------------+---------------------------------------+
|                                             | CVE-2020-9546    |          |                   | 2.7.9.7, 2.8.11.6, 2.9.10.4    | jackson-databind: Serialization       |
|                                             |                  |          |                   |                                | gadgets in shaded-hikari-config       |
|                                             |                  |          |                   |                                | -->avd.aquasec.com/nvd/cve-2020-9546  |
+                                             +------------------+          +                   +                                +---------------------------------------+
|                                             | CVE-2020-9547    |          |                   |                                | jackson-databind: Serialization       |
|                                             |                  |          |                   |                                | gadgets in ibatis-sqlmap              |
|                                             |                  |          |                   |                                | -->avd.aquasec.com/nvd/cve-2020-9547  |
+                                             +------------------+          +                   +                                +---------------------------------------+
|                                             | CVE-2020-9548    |          |                   |                                | jackson-databind: Serialization       |
|                                             |                  |          |                   |                                | gadgets in anteros-core               |
|                                             |                  |          |                   |                                | -->avd.aquasec.com/nvd/cve-2020-9548  |
+---------------------------------------------+------------------+----------+-------------------+--------------------------------+---------------------------------------+
```
</details>

