# 循环神经网络
:label:`chap_rnn`

到目前为止，我们遇到了两种类型的数据：表格数据和图像数据。
对于后者，我们设计了专门的神经网络结构来利用数据的规律。
换句话说，如果我们拥有一张图像，图像中的内容看起来就像模拟电视时代的测试图，那么对图像中的像素位置进行重排，就会对图像中的内容推理造成极大的困难。

最重要的是，到目前为止我们默认数据都来自于某种分布，并且所有样本都是独立同分布的（independently and identically distributed, i.i.d.）。
然而，大多数的数据并非如此。
例如，文章中的单词是按顺序写的，如果顺序被随机地重排，就很难理解文章原始的意思。
同样，视频中的图像帧、对话中的音频信号以及网站上的浏览行为都是有顺序的。
因此，针对此类数据而设计特定模型，可能效果会更好。

另一个问题来自这样一个事实：我们不仅仅可以接收一个序列作为输入，而是还可能期望继续猜测这个序列的后续。
例如，一个任务可以是继续预测 $2, 4, 6, 8, 10, \ldots$。
这在时间序列分析中是相当常见的，可以用来预测股市的波动、患者的体温曲线或者赛车所需的加速度。
同理，我们需要能够处理这些数据的特定模型。

简言之，卷积神经网络可以有效地处理空间信息，*循环神经网络*（recurrent neural network, RNN）这种设计可以更好地处理序列信息。
循环神经网络通过引入状态变量存储过去的信息和当前的输入，从而可以确定当前的输出。

许多使用循环网络的例子都是基于文本数据的，因此我们将在本章中重点介绍语言模型。
在对序列数据进行更详细的回顾之后，我们将介绍文本预处理的实用技术。
然后，我们将讨论语言模型的基本概念，并将此讨论作为循环神经网络设计的灵感。
最后，我们描述了循环神经网络的梯度计算方法，以探讨训练此类网络时可能遇到的问题。

```toc
:maxdepth: 2

sequence
text-preprocessing
language-models-and-dataset
rnn
rnn-scratch
rnn-concise
bptt
```
