# 现代循环神经网络
:label:`chap_modern_rnn`

前文中我们已经介绍了循环神经网络的基础知识，这种网络可以更好地处理序列数据。
为了演示效果，我们在文本数据上实现了基于循环神经网络的语言模型。
但是，对于面对当今各种序列学习问题的从业人员，这些技术可能并不够用。

例如，循环神经网络在实践中一个常见问题是数值不稳定性。
尽管我们已经应用了梯度裁剪等实现阶段的技巧来处理它，但是通过设计更复杂的序列模型可以进一步缓解这个问题。
具体来说，在实践中更常见的门控循环神经网络。
首先，我们将引入两个广泛使用的网络，
即 *门控循环单元*（gated recurrent units, GRU）和 *长短期记忆网络*（long short-term memory, LSTM）。
然后，我们将基于迄今为止讨论过的一个单向隐藏层来扩展循环神经网络架构。
我们将描述具有多个隐藏层的深层架构，并讨论基于前向和后向循环计算的双向设计。
现代循环网络经常采用这种扩展。
在解释这些循环神经网络的变体时，我们将继续考虑 :numref:`chap_rnn` 中引入的语言建模问题。

事实上，语言建模只揭示了序列学习能力的冰山一角。
在各种序列学习问题中，如自动语音识别、文本到语音的转换和机器翻译，输入和输出都是任意长度的序列。
为了解释如何拟合这种类型的数据，我们将以机器翻译为例介绍基于循环神经网络的“编码器－解码器”架构和束搜索，并用它们来生成序列。

```toc
:maxdepth: 2

gru
lstm
deep-rnn
bi-rnn
machine-translation-and-dataset
encoder-decoder
seq2seq
beam-search
```