#  预备知识
:label:`chap_preliminaries`

要学习深度学习的相关知识，需要先掌握一些基本技能。所有机器学习方法都涉及从数据中提取信息，因此，我们先学习一些关于数据的实用技能，包括存储、操作和预处理数据。

机器学习通常需要处理大型数据集。我们可以将数据集视为表，其中表的行对应样本，列对应属性。线性代数为我们提供了一些用来处理表格数据的方法。我们不会太深入细节，而是将重点放在矩阵运算的基本原理及其实现上。

深度学习是关于优化的。我们有一个带有参数的模型，想要找到其中能拟合数据的最好模型。在算法的每个步骤中，决定以何种方式调整参数需要一点微积分知识。本节将简要介绍这些知识。幸运的是，`autograd`包会自动计算微分，本节也将介绍它。

机器学习还涉及如何做出预测：给定我们观察到的信息，某些未知属性可能的值是多少？要在不确定的情况下进行严格的推理，我们需要借用概率语言。

最后，官方文档提供了本书之外的大量描述和示例。在本章的结尾，我们将向你展示如何在官方文档中查找所需信息。

本书对读者数学基础的要求保持在正确理解深度学习所需的最低限度，但这并不意味着本书中没有数学方面的内容，本章就会快速介绍一些基本且常用的数学知识，以便读者至少能够理解书中的大部分数学内容。如果读者想要理解全部数学内容，可以进一步学习数学附录中给出的数学基础知识。

```toc
:maxdepth: 2

ndarray
pandas
linear-algebra
calculus
autograd
probability
lookup-api
```
