# 循环神经网络

与之前介绍的多层感知机和能有效处理空间信息的卷积神经网络不同，循环神经网络是为更好地处理时序信息而设计的。它引入状态变量来存储过去的信息，并用其与当前的输入共同决定当前的输出。

循环神经网络常用于处理序列数据，如一段文字或声音、购物或观影的顺序，甚至是图像中的一行或一列像素。因此，循环神经网络有着极为广泛的实际应用，如语言模型、文本分类、机器翻译、语音识别、图像分析、手写识别和推荐系统。

因为本章中的应用是基于语言模型的，所以我们将先介绍语言模型的基本概念，并由此激发循环神经网络的设计灵感。接着，我们将描述循环神经网络中的梯度计算方法，从而探究循环神经网络训练可能存在的问题。对于其中的部分问题，我们可以使用本章稍后介绍的含门控的循环神经网络来解决。最后，我们将拓展循环神经网络的架构。

```eval_rst

.. toctree::
   :maxdepth: 2

   lang-model
   rnn
   lang-model-dataset
   rnn-scratch
   rnn-gluon
   bptt
   gru
   lstm
   deep-rnn
   bi-rnn
```




