# 自然语言处理

自然语言处理关注计算机与人类之间的自然语言交互。在实际中，我们常常使用自然语言处理技术，如“循环神经网络”一章中介绍的语言模型，来处理和分析大量的自然语言数据。本章中，根据输入与输出的不同形式，我们按“定长到定长”、“不定长到定长”、“不定长到不定长”的顺序，逐步展示在自然语言处理中如何表征并变换定长的词或类别以及不定长的句子或段落序列。

我们先介绍如何用向量表示词，并在语料库上训练词向量。之后，我们把在更大语料库上预训练的词向量应用于求近义词和类比词，即“定长到定长”。接着，在文本分类这种“不定长到定长”的任务中，我们进一步应用词向量来分析文本情感，并分别基于循环神经网络和卷积神经网络为表征时序数据提供两种思路。此外，自然语言处理任务中很多输出是不定长的，如任意长度的句子或段落。我们将描述应对这类问题的编码器—解码器模型、束搜索和注意力机制，并动手实践“不定长到不定长”的机器翻译任务。

```eval_rst

.. toctree::
   :maxdepth: 2

   word2vec
   approx-training
   word2vec-gluon
   fasttext
   glove
   similarity-analogy
   sentiment-analysis-rnn
   sentiment-analysis-cnn
   seq2seq
   beam-search
   attention
   machine-translation
```




