# 前言

就在几年前，不管在大公司还是创业公司，都鲜有工程师和科学家来将深度学习应用到智能产品与服务中。作为深度学习前身的神经网络，才刚刚摆脱被机器学习学术界认为是过时工具的印象。那个时候，即使是机器学习也非新闻头条的常客。它仅仅被看作是一门具有前瞻性，并拥有一系列小范围实际应用的学科。在包含计算机视觉和自然语言处理在内的实际应用通常需要大量的相关领域知识：这些实际应用被视为相互独立的领域，而机器学习只占其中一小部分。

然而仅仅在这几年之内，深度学习便令全世界大吃一惊。它非常有力地推动了计算机视觉、自然语言处理、自动语音识别、强化学习和统计建模等多个领域的快速发展。随着这些领域的不断进步，我们现在可以制造自动驾驶的汽车，基于短信、邮件甚至电话的自动回复系统，以及在围棋中击败最优秀人类选手的软件。这些由深度学习带来的新工具也正产生着广泛的影响：它们改变了电影制作和疾病诊断的方式，并在从天体物理学到生物学等各个基础科学中扮演越来越重要的角色。

与此同时，深度学习也给它的使用者们带来了独一无二的挑战：任何单一的应用都汇集了各学科的知识。具体来说，应用深度学习需要同时理解：

1. 问题的动机和特点；
1. 将大量不同类型神经网络层通过特定方式组合在一起的模型背后的数学原理；
1. 在原始数据上拟合极复杂的深层模型的优化算法；
1. 有效训练模型、避免数值计算陷阱以及充分利用硬件性能所需的工程技能；
1. 为解决方案挑选合适的变量（超参数）组合的经验。

同样，我们几位作者也面临前所未有的挑战：我们需要在有限的篇幅里糅合深度学习的多方面知识，从而使读者能够较快理解并应用深度学习技术。本书代表了我们的一种尝试：我们将教给读者概念、背景知识和代码；我们将在同一个地方阐述剖析问题所需的批判性思维、解决问题所需的数学知识，以及实现解决方案所需的工程技能。


## 包含代码、数学、网页、讨论的统一资源

我们在2017年7月启动了写作这本书的项目。当时我们需要向用户解释Apache MXNet在那时的新接口Gluon。遗憾的是，我们并没有找到任何一个资源可以同时满足以下几点需求：

1. 包含较新的方法和应用，并不断更新；
1. 广泛覆盖现代深度学习技术并具有一定的技术深度；
1. 既是严谨的教科书，又是包含可运行代码的生动的教程。

那时，我们在博客和GitHub上找到了大量的演示特定深度学习框架（例如用TensorFlow进行数值计算）或实现特定模型（例如AlexNet、ResNet等）的示例代码。这些示例代码的一大价值在于提供了教科书或论文往往省略的实现细节，比如数据的处理和运算的高效率实现。如果不了解这些，即使能将算法倒背如流，也难以将算法应用到自己的项目中去。此外，这些示例代码还使得用户能通过观察修改代码所导致的结果变化而快速验证想法、积累经验。因此，我们坚信动手实践对于学习深度学习的重要性。然而可惜的是，这些示例代码通常侧重于如何实现给定的方法，却忽略了有关算法设计的探究或者实现细节的解释。虽然在像Distill这样的网站和某些博客上出现了一些有关算法设计和实现细节的讨论，但它们常常缺少示例代码，并通常仅覆盖深度学习的一小部分。

另外，我们欣喜地看到了一些有关深度学习的教科书不断问世，其中最著名的要数Goodfellow、Bengio和Courville的《深度学习》。该书梳理了深度学习背后的众多概念与方法，是一本极为优秀的教材。然而，这类资源并没有将概念描述与实际代码相结合，以至于有时会令读者对如何实现它们感到毫无头绪。除了这些以外，商业课程提供者们虽然制作了众多的优质资源，但它们的付费门槛依然令不少用户望而生畏。

正因为这样，深度学习用户，尤其是初学者，往往不得不参考来源不同的多种资料。例如，通过教科书或者论文来掌握算法及其相关数学知识，阅读线上文档学习深度学习框架的使用方法，然后寻找感兴趣的算法在这个框架上的实现并摸索如何将它应用到自己的项目中去。如果你正亲身经历这一过程，你可能会感到痛苦：不同来源的资料有时难以相互一一对应，即便能够对应也可能需要花费大量的精力。例如，我们需要将某篇论文公式中的数学变量与某段网上实现中的程序变量一一对应，并在代码中找到论文可能没交代清楚的实现细节，甚至要为运行不同的代码安装不同的运行环境。

针对以上存在的痛点，我们正在着手创建一个为实现以下目标的统一资源：

1. 所有人均可在网上免费获取；
1. 提供足够的技术深度，从而帮助读者实际成为深度学习应用科学家：既理解数学原理，又能够实现并不断改进方法；
1. 包含可运行的代码，为读者展示如何在实际中解决问题。这样不仅直接将数学公式对应成实际代码，而且可以修改代码、观察结果并及时获取经验；
1. 允许我们和整个社区不断快速迭代内容，从而紧跟仍在高速发展的深度学习领域；
1. 由包含有关技术细节问答的论坛作为补充，使大家可以相互答疑并交换经验。

这些目标往往互有冲突：公式、定理和引用最容易通过LaTeX进行管理和展示，代码自然应该用简单易懂的Python描述，而网页本身应该是一堆HTML及配套的CSS和JavaScript。此外，我们希望这个资源可以作为可执行代码、实体书以及网站。然而，目前并没有任何工具可以完美地满足以上所有需求。

因此，我们不得不自己来集成这样的一个工作流。我们决定在GitHub上分享源代码并允许提交编辑，通过Jupyter记事本来整合代码、公式、文本、图片等，使用Sphinx作为渲染引擎来生成不同格式的输出，并使用Discourse作为论坛。虽然我们的系统尚未完善，但这些选择在互有冲突的目标之间取得了较好的折中。这很可能是使用这种集成工作流发布的第一本书。


## 从在线课程到纸质书

本书的两位中国作者曾每周末在线免费讲授“动手学深度学习”系列课程。课程的讲义自然成为了本书内容的蓝本。这个课程持续了5个月，其间近3,000名同学参与了讨论，并贡献了近5,000多个有价值的讨论，特别是其中几个参加比赛的练习很受欢迎。这个课程的受欢迎程度出乎我们的意料。尽管我们将课件和课程视频都公开在了网上，但我们同时觉得出版成纸质书也许能让更多喜爱纸质阅读的读者受益。因此，我们委托人民邮电出版社来出版这本书。

从蓝本到成书花费了更多的时间。我们对所有涉及的所有技术点补充了背景介绍，并使用了更加严谨的写作风格，还对版式和示意图做了大量修改。书中所有的代码执行结果都是自动生成的，任何改动都会触发对书中每一段代码的测试，以保证读者在动手实践时能复现结果。

我们的初衷是让更多人更容易地使用深度学习。为了让大家能够便利地获取这些资源，我们保留了免费的网站内容，并且通过不收取出版稿费的方式来降低纸质书的价格，使更多人有能力购买。


## 致谢

我们无比感谢本书的中英文版稿件贡献者和论坛用户们。他们帮助增添或改进了书中内容并提供了有价值的反馈。特别地，我们要感谢每一位为这本中文版开源书提交内容改动的贡献者们。这些贡献者的GitHub用户名或姓名是（排名不分先后）：许致中、邓杨、崔永明、Aaron Sun、陈斌斌、曾元豪、周长安、李昂、王晨光、Chaitanya Prakash Bapat、金杰、赵小华、戴作卓、刘捷、张建浩、梓善、唐佐林、DHRUV536、丁海、郭晶博、段弘、杨英明、林海滨、范舟、李律、李阳、夏鲁豫、张鹏、徐曦、Kangel Zenn、Richard CUI、郭云鹏、hank123456、金颢、hardfish82、何通、高剑伟、王海龙、htoooth、hufuyu、Kun Hu、刘俊朋、沈海晨、韩承宇、张钟越、罗晶、jiqirer、贾忠祥、姜蔚蔚、田宇琛、王曜、李凯、兰青、王乐园、Leonard Lausen、张雷、鄭宇翔、linbojin、lingss0918、杨大卫、刘佳、戴玮、贾老坏、陆明、张亚鹏、李超、周俊佐、Liang Jinzheng、童话、彭小平、王皓、彭大发、彭远卓、黄瓒、解浚源、彭艺宇、刘铭、吴俊、刘睿、张绍明、施洪、刘天池、廖翊康、施行健、孙畔勇、查晟、郑帅、任杰骥、王海珍、王鑫、wangzhe258369、王振荟、周军、吴侃、汪磊、wudayo、徐驰、夏根源、何孝霆、谢国超、刘新伟、肖梅峰、黄晓烽、燕文磊、王贻达、马逸飞、邱怡轩、吴勇、杨培文、余峰、Peng Yu、王雨薇、王宇翔、喻心悦、赵越、刘忆智、张航、郑达、陈志、周航、张帜、周远、汪汇泽、谢乘胜、aitehappiness、张满闯、孙焱、林健、董进、陈宇泓、魏耀武、田慧媛、陈琛、许柏楠、bowcr、张宇楠、王晨、李居正、王宗冰、刘垣德。谢谢你们为每一位读者改进这本开源书。

本书的初稿在中国科学技术大学、上海财经大学的“深度学习”课程以及浙江大学的“物联网与信息处理”课程和上海交通大学的“面向视觉识别的卷积神经网络”课程中被用于教学。我们在此感谢这些课程的师生，特别是连德富教授、王智教授和罗家佳教授，感谢他们对改进本书提供的宝贵意见。

此外，我们感谢Amazon Web Services，特别是Swami Sivasubramanian、Raju Gulabani、Charlie Bell和Andrew Jassy在我们撰写本书时给予的慷慨支持。如果没有可用的时间、资源以及来自同事们的讨论和鼓励，就没有这本书的项目。我们还要感谢Apache MXNet团队实现了很多本书所使用的特性。另外，经过同事们的校勘，本书的质量得到了极大的提升。在此我们一一列出章节和校勘人，以表示我们由衷的感谢：引言的校勘人为金颢，预备知识的校勘人为吴俊，深度学习基础的校勘人为张航、王晨光、林海滨，深度学习计算的校勘人为查晟，卷积神经网络的校勘人为张帜、何通，循环神经网络的校勘人为查晟，优化算法的校勘人为郑帅，计算性能的校勘人为郑达、吴俊，计算机视觉的校勘人为解浚源、张帜、何通、张航，自然语言处理的校勘人为王晨光，附录的校勘人为金颢。

感谢将门创投，特别是王慧、高欣欣、常铭珊和白玉为本书的两位中国作者在讲授”动手学深度学习“系列课程时所提供的平台。感谢所有参与这一系列课程的数千名同学们。感谢Amazon Web Services中国团队的同事们，特别是费良宏和王晨对作者的支持与鼓励。感谢本书论坛的3位版主：王鑫、夏鲁豫和杨培文。他们牺牲了自己宝贵的休息时间来回复大家的提问。感谢人民邮电出版社的杨海玲编辑为我们在本书的出版过程中所提供的各种帮助。

最后，我们要感谢我们的家人。谢谢你们一直陪伴着我们。


## 教学资源、计算资源和反馈

本书的英文版Dive into Deep Learning是加州大学伯克利分校2019年春学期“Introduction to Deep Learning”（深度学习导论）课程的教材。同时，截至2019年春学期，本书中英文版的内容已被全球15所知名大学用于教学。本书的学习社区、免费教学资源（课件、教学视频、更多习题等），以及用于本书学习或教学的免费计算资源（仅限学生和老师）的申请方法在本书网站 https://zh.d2l.ai 上发布。诚然，将算法、公式、图片、代码和样例统一进一本适合阅读的书，并以具有交互式体验的Jupyter记事本文件的形式提供给读者，是对我们的极大挑战。书中难免有很多疏忽的地方，敬请原谅，并希望读者能通过每一节后面的二维码向我们反馈阅读本书过程中发现的问题。

结尾处，附上陆游的一句诗作为勉励：

> “纸上得来终觉浅，绝知此事要躬行。”


阿斯顿·张、李沐、扎卡里 C. 立顿、亚历山大 J. 斯莫拉

2019年5月
