# 计算机视觉

无论是医疗诊断、无人车、摄像监控，还是智能滤镜，计算机视觉领域的诸多应用都与我们当下和未来的生活息息相关。近年来，深度学习技术深刻推动了计算机视觉系统性能的提升。可以说，当下最先进的计算机视觉应用几乎离不开深度学习。鉴于此，本章将关注计算机视觉领域，并从中挑选时下在学术界和工业界具有影响力的方法与应用来展示深度学习的魅力。

我们在“卷积神经网络”一章中已经介绍了计算机视觉领域常使用的深度学习模型，并实践了简单的图像分类任务。在本章的开头，我们介绍两种有助于提升模型的泛化能力的方法，即图像增广和微调，并把它们应用于图像分类。由于深度神经网络能够对图像逐级有效地进行表征，这一特性被广泛应用在目标检测、语义分割和样式迁移这些主流计算机视觉任务中，并取得了成功。围绕这一核心思想，首先，我们将描述目标检测的工作流程与各类方法。之后，我们将探究如何使用全卷积网络对图像做语义分割。接下来，我们再解释如何使用样式迁移技术生成像本书封面一样的图像。最后，我们在两个计算机视觉的重要数据集上实践本章和前几章的内容。

```eval_rst

.. toctree::
   :maxdepth: 2

   image-augmentation
   fine-tuning
   bounding-box
   anchor
   multiscale-object-detection
   object-detection-dataset
   ssd
   rcnn
   semantic-segmentation-and-dataset
   fcn
   neural-style
   kaggle-gluon-cifar10
   kaggle-gluon-dog
```
