# 如何使用本书

在本书中，我们不仅阐述深度学习的技术与应用，还使用Apache MXNet（incubating）及其最新的Gluon接口演示如何实现它们。
除了讨论区以外，我们将利用Jupyter notebook能将文字、代码、公式和图像统一起来的优势，提供一个交互式的学习体验。据我们所知，目前还没有如此多方位交互式的深度学习的学习体验。我们将尝试弥补这个空白。


## 面向的读者

本书总体上面向大学生、工程师和研究人员。本书对于深度学习技术与应用的阐述涉及了数学和编程。如果你希望理解深度学习背后的数学原理，需要了解基础的线性代数、微分和概率。如果你希望读懂书中的代码，需要了解基础的Python编程。如果你只对书中的数学部分或编程部分感兴趣，也可以忽略另一部分。

附录提供了本书所涉及的数学知识，供有需要的读者选择参考。如果你对Python编程不熟悉，我们建议你先学习一些有关Python编程的教程，例如中文教程 http://www.runoob.com/python/python-tutorial.html 或英文教程 http://learnpython.org/ 。


## 内容和结构

本书内容大体可以分为三部分：

* 第一部分（第1章至第3章）涵盖预备工作和基础知识。第1章介绍了深度学习的背景和本书的使用。第2章提供了动手学深度学习所需要的预备知识，例如如何获取并运行书中的代码。第3章包括了深度学习最基础的概念和技术，例如多层感知机和模型正则化。如果你时间有限，并且只希望了解深度学习最基础的概念和技术，那么你只需阅读第一部分。

* 第二部分（第4章至第6章）关注现代深度学习技术。第4章描述了深度学习计算的各个重要组成部分，并为之后实现更复杂的模型打下基础。第5章解释了近年来令深度学习在计算机视觉领域大获成功的卷积神经网络。第6章阐述了近年来常用于处理序列数据的循环神经网络。阅读第二部分有助于掌握现代深度学习技术。

* 第三部分（第7章至第10章）讨论计算性能和应用。第7章评价了各种用来训练深度学习模型的优化算法。第8章检验了影响深度学习计算性能的几个重要因素。第9章和第10章分别列举了深度学习在计算机视觉和自然语言处理中的重要应用。这部分内容可供你根据兴趣选择阅读。

图1.1描绘了本书的结构。

![本书的结构。由甲章指向乙章的箭头表明甲章的知识有助于理解乙章的内容。如果你想短时间了解深度学习最基础的概念和技术，只需阅读第1章至第3章；如果你希望掌握现代深度学习技术，还需阅读第4章至第6章。第7章至第10章可供你根据兴趣选择阅读。](../img/book-org.svg)


## 代码

作为一个开源的深度学习框架，Apache MXNet提供了易用的Gluon接口，并有着出众的计算性能。MXNet支持例如C++、JavaScript、Python、R、Matlab、Julia、Scala、Go等前端编程语言，并被众多使用者部署到了手机、树莓派（Raspberry Pi）、笔记本电脑等不同的设备之上。我们选择MXNet作为本书使用的深度学习框架。它也是AWS（亚马逊的云计算服务）首选的深度学习框架。

此外，为避免重复描述，我们将本书多次使用的函数、类等封装在`gluonbook`包中。这些函数、类等的定义所在的章节已在附录中[“gluonbook包索引”](../chapter_appendix/gluonbook.md)里列出。

本书所有代码已在MXNet 1.2.1、`gluonbook` 0.7.1和Python 3.6.4下测试通过。由于深度学习发展极为迅速，未来版本的MXNet可能会造成书中部分代码无法正常运行。如果遇到某一节代码无法正常运行的情况，可安装1.2.1版的MXNet和0.7.1版的`gluonbook`或在该节的讨论区汇报问题。如果你希望安装未来新版本的MXNet并获得该版本下测试通过的新代码，可参考[“安装和运行”](../chapter_prerequisite/install.md)一节更新代码和运行环境。


## 讨论区

本书的学习社区地址是 https://discuss.gluon.ai/ 。当你对书中某节内容有疑惑时，也可以扫一扫该节后面的二维码参与讨论该节内容。值得一提的是，在有关Kaggle比赛章节的讨论区中，众多社区成员提供了丰富的高水平方法。我们强烈推荐大家积极参与学习社区中的讨论，并相信你一定会有所收获。本书作者和MXNet开发人员也时常参与社区中的讨论。


## 小结

* 我们选择MXNet作为本书使用的深度学习框架。
* 本书力求提供一个多方位交互式的深度学习的学习体验。


## 练习

* 在本书的学习社区 https://discuss.gluon.ai/ 上注册一个账号。搜索关键字Kaggle，浏览其中回复量最大的几个帖子。


## 扫码直达[讨论区](https://discuss.gluon.ai/t/topic/6915)


![](../img/qr_how-to-use.svg)
