# 深度学习简介


1950年，图灵在他的著名论文《计算机器与智能》中提出了“机器是否可以思考”的问题，并相信这是有可能的。在他所描述的图灵测试（Turing test）中，如果一个人在使用文本交互时较难区分机器与人类的回复，那么机器可以被认为是智能的。时至今日，为机器赋予智能的发展可谓日新月异。


## 人工智能

通俗地说，机器所展现出的智能叫做人工智能（artificial intelligence，简称AI）。在上世纪50年代之后的岁月里，人工智能领域不断蓬勃发展。到了今天，人工智能在图像识别、语音识别和无人驾驶等应用中已接近或达到人类智能水平，并在诸如棋类游戏的应用中超过了人类。举几个例子，

* 2016年，谷歌DeepMind研发的围棋程序“阿尔法狗”（AlphaGo）在五轮围棋比赛中以4比1的成绩战胜了围棋世界冠军李世石。之后的升级版“阿尔法狗”以3比0的成绩战胜了排名世界第一的围棋世界冠军柯洁。

* 2017年，来自中国的Momenta研发的视觉程序在ImageNet大型视觉识别挑战赛对1000类图像分类任务中取得2.25%的前五错误率。也就是说，对于97.75%的测试图片来说，视觉程序输出的最有可能的5个类别都包括正确答案。

* 2018年，谷歌研发的助手程序可以通过和理发店店员在电话中对话来预定理发时间。而人类在这长达近一分钟的语音交互中完全没有意识到电话的另一头是机器。

那么，人工智能究竟该如何实现呢？在人工智能发展的初期，许多人认为人类可以通过在计算机程序里设定足够多的规则使机器具备智能。这也促成了专家系统（expert system）的诞生。专家系统通过知识库与推理机来解决更复杂的问题。其中，知识库囊括了大量人类指定的事实与规则，而推理机将规则应用于知识库中已有的事实，从而推断出新的事实。作为人工智能的分支，专家系统的发展在上世纪80年代达到鼎盛。

虽然专家系统对于涉及复杂推理的任务非常有效，但它却很难解决例如图像识别和语音识别这样对人类较简单的问题。人类还需要另一种通往人工智能的手段：机器学习（machine learning）。


## 机器学习

机器学习研究如何使计算机系统利用经验改善性能。通常，这些经验以数据的形式存在。对于一个任务，我们希望计算机从数据中学习根据输入得到输出的规则，而无需人类明确指定这样的规则。这里的输入可以是一张含有猫或狗的图片，输出可以是“猫”或“狗”。因此，我们也可以把机器学习看作是基于数据的编程范式。在机器学习中，计算机从数据中学习到的将输入变换为输出的规则也叫模型（model）。随着数据规模的不断增大和硬件性能的不断提高，机器学习逐步发展成为人工智能领域最有吸引力的分支。如今，无论是用户接收个性化的商品或新闻推荐，还是电子邮件服务自动拦截垃圾邮件，机器学习几乎无处不在。

然而，传统的机器学习方法也有一定的局限性，尤其当输入是像图像和声音那样的原始数据时。我们已经提到，机器学习模型将输入变换为输出。如果我们能够以更好的方式表示这些输入数据，模型将更容易将它们变换为正确的输出。多年以来，人们先依靠有关具体任务的专业知识，仔细将原始数据变换成合适的表示，再使用机器学习方法将这些表示变换为输出。

实际上，在机器学习的众多研究方向中，表征学习（representation learning）关注如何自动找出表示数据的合适方式，以便更好地将输入变换为正确的输出。而本书所要重点探讨的深度学习（deep learning）正是表征学习的一类方法。


## 深度学习

深度学习是具有多级表示的表征学习方法。在每一级（从原始数据开始），深度学习通过简单的函数将该级的表示变换为更高级的表示。
因此，深度学习模型也可以看作是由许多简单函数复合而成的函数。当这些复合的函数足够多时，深度学习模型可以表达非常复杂的变换。

深度学习可以逐级表示越来越抽象的概念或模式。以图片为例，它的输入是一堆原始像素值。深度学习模型中，图片的第一级的表示通常是在特定的位置和角度是否出现边缘。而第二级的表示通常能够将这些边缘组合出有趣的模式，例如花纹。在第三级的表示中，也许上一级的花纹能进一步汇合成对应物体特定部位的模式。这样逐级表示下去，最终，模型能够较容易根据最后一级的表示完成给定的任务，例如图片分类。值得一提的是，作为表征学习的一种，深度学习将自动找出每一级表示数据的合适方式。

深度学习通常基于神经网络（neural network）模型。神经网络模型中每一层的输出对应着深度学习每一级的表示。而各种神经网络模型在上世纪就已经被提出了。然而，深度学习直到最近几年才在图像识别、语音识别、游戏等应用中取得一系列激动人心的成就。这主要得益于近年来硬件的发展和数据的增长，例如通用GPU的出现。此外，开源深度学习库也迅速使得深度学习技术在学界和业界得到广泛应用。早期的深度学习从业人员需要精通CUDA和C++。而在本书的学习中，你会发现，只需要懂得基础的Python编程就可以使用深度学习。

总之，深度学习作为机器学习的一类方法，是实现人工智能的一种重要途径。其实，本节开头所描述的“阿尔法狗”、错误率极低的图像分类以及像人一样打电话的助手程序都应用了深度学习。在未来几年，我们相信深度学习领域依然充满机遇，充满挑战。


## 小结

* 机器所展现出的智能叫做人工智能。
* 机器学习研究如何使计算机系统利用经验改善性能。它是人工智能领域的分支，也是实现人工智能的一种手段。
* 作为机器学习的一类，表征学习关注如何自动找出表示数据的合适方式。
* 深度学习是具有多级表示的表征学习方法。它可以逐级表示越来越抽象的概念或模式。


## 练习

* 如果把人工智能的发展看作是新一次工业革命。那么深度学习和数据的关系是否像是蒸汽机与煤炭的关系呢？为什么？
* 你生活的哪些方面可能被深度学习所改变？

## 扫码直达[讨论区](https://discuss.gluon.ai/t/topic/746)


![](../img/qr_deep-learning-intro.svg)
