# 为什么要做这个项目

两年前我们开始了MXNet这个项目，有一件事情一直困扰我们：每当MXNet发布新特性的时候，总会收到“做啥新东西，赶紧去更新文档”的留言。我们曾一度都很费解，文档明明很多啊，比我们以前所有做的项目都好。而且你看隔壁家轮子，都没文档，大家照样也不是用的很嗨。

后来有一天，[Zack](http://zacklipton.com/)问了这样一个问题：假设回到你刚开始学机器学习的时候，那么你需要什么样的文档？

我是大二开始接触机器学习。当时候并没有太多很好资料，抱着晦涩的翻译版《The Elements of Statistical Learning》读了大半年仍是懵懵懂懂。后来08年的时候又啃了好几个月《Pattern Recognition And Machine Learning》，被贝叶斯那一套绕得云里雾里。10年去港科大的时候James问我，你最熟悉的模型是哪个？使劲想了想，竟然答不出来。

虽然在我认识的人里，好些人能够读一篇论文或者听一个报告后就能问出很好的问题，然后就基本弄懂了。但我在这个上笨很多。读过的论文就像喝过的水，第二天就不记得了。一定是需要静下心来，从头到尾实现一篇，跑上几个数据，调些参数，才能心安地觉得懂了。例如在港科大的两年读了很多论文，但现在反过来看，仍然记得可能就是那两个老老实实动手实现过写过论文的模型了。即使后来在机器学习这个方向又走了五年，学习任何新东西仍然是要靠动手。

![](../img/why1.png)

几年前我开始学习深度学习，在MXNet这个项目里也帮助和目睹了很多小伙伴上手深度学习。我发现也有很多小伙伴跟我一样，动手去实现、去调参、去跑实验才会真正成为专家（或者合格的[炼丹师](https://zhuanlan.zhihu.com/p/23781756)）。

虽然深度学习崛起前的年代，不写代码不跑实验可以做出很好的理论工作。但在深度学习领域，动手能力才是核心竞争力。例如就算我熟知卷积的三种写法，Relu的十个变种，理解BatchNorm为什么能加速收敛，对Imagenet历届冠军的错误率随手拈来，能滔滔不绝说上几小时神经网络几度沉浮的恩怨史。但调不出参数，一切都是枉然。发论文被问你为啥跟state-of-the-art差老远，做产品被喷你这精度还不如我的便宜100倍的线性模型。

![](../img/why2.png)

在过去一年我在AWS工作中，很大一部分是在帮助Amazon内部团队和云上的用户来了解深度学习，并将其应用到他们的产品中。在今年夏威夷的CVPR上，遇到很多老朋友，例如地平线的凯哥，今日头条的李磊，第四范式的文渊和雨强，也认识了很多新朋友，例如Momenta旭东和商汤俊杰。我说MXNet有了新Gluon前端，可以一次性解决产品和研究的需求。大家纷纷表示，好啊好啊，来我们这里讲讲吧。而且特别强调说，我们这里新人很多，最好能讲讲入门知识。

所以很自然的会想，我们能不能帮助更多人。于是我们想开设一些系列课程，从深度学习入门到最新最前沿的算法，从0开始通过交互式的代码来讲解每个算法和概念。希望通过这个让大家既能了解算法的细节，又能调得出参数。既赢得了竞赛，又做的出产品。

为此我们做了（正在做）这五件事情：

1. [Eric](https://github.com/piiswrong)和[Sheng](https://github.com/szha)开发了MXNet的新前端Gluon，详细可以参见[Eric的这篇介绍](https://zhuanlan.zhihu.com/p/28648399)。这个前端带来跟Python更一致的便利的编程环境，不管是debug还是在交互上，都比TensorFlow之类通过计算图编程的框架更适合学习深度学习。
2. [Zack](https://github.com/zackchase), [Alex](https://alex.smola.org/), [Aston](https://github.com/astonzhang)和很多小伙伴一起写了一系列的notebook来讲解各个模型。Zack从一个外行（他是专业音乐人）和老师（CMU计算机教授）的角度，从0开始讲解和实现各个算法。
3. 我们同时将notebook翻译成中文。虽然翻译进度落后了英文版，但对每个翻译了教程都做了大量的改进（之后会merge回英文版）
4. 建立了中文社区[discuss.gluon.ai](http://discuss.gluon.ai)方便大家来讨论和学习。
5. 我们联合[将门](http://www.thejiangmen.com/)在斗鱼上直播一系列课程，深入讲解各个教程。

在我们准备这个的时候，Andrew Ng也开设了深度学习课程。从课程单上看非常好，讲得特别细。而且Andrew讲东西一向特别清楚，所以这个课程必然是精品。但我们做的跟Andrew的主要有几个区别：

1. 我们不仅介绍深度学习模型，而且提供简单易懂的代码实现。我们不是通过幻灯片来讲解，而是通过解读代码，实际动手调参数和跑实验来学习。
2. 我们使用中文。不管是教材，直播，还是论坛。（虽然在美国呆了5，6年了，事实上我仍然对一边听懂各式口音的英文一边理解内容很费力。）
3. Andrew课目前免费版只能看视频，而我们不仅仅直播教学，而且提供练习题，提供大家交流的论坛，并鼓励大家在github上参与到课程的改进中来。希望能与大家有更近距离的交互。

从大出发点上我们跟Andrew一致，希望能够帮助小伙伴们快速掌握深度学习。这一次技术上的创新可能会持续辐射技术圈数年，希望小伙伴们能更快更好的参与到这一次热潮来。

@mli
