# Contributing to Dozer

There are various ways to contribute to Dozer, and all are welcome and appreciated!

- [Bug reports](#bug-reports)
- [Feature requests](#feature-requests)
- [Design](#design)
- [Code](#code)
    - [Getting started](#getting-started)
    - [Submitting your pull request](#submitting-your-pull-request)

## Bug reports
Open issues about problems you may be encountering. When doing so please mention the version you're using.

## Feature requests
If you have a good idea for a feature or enhancement open an issue.

## Design
Refresh the Dozer icons or logo. [Design resources for logo and status bar icon](https://www.figma.com/file/g5MhiwxR1YFg5vti0tPANa/Dozer).

## Code
You can submit your own code. This can be bug fixes or new features. Please ask me (@Mortennn) before implementing a new feature. Check out [Issues](https://github.com/Mortennn/Dozer/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc).

### Getting started
Make sure you have at least Xcode 10 installed.

Run the following command:
```shell
git clone https://github.com/mortennn/dozer &&
cd dozer &&
make build
```
Done! The project should open automatically in Xcode.

### Submitting your pull request
Please give a small summary of what has changed. Also add any github issues links (`Fixes #100`).
Once your pull request is created, please add a changelog entry to the CHANGELOG.md along with the PR number.