find_package(Git)

if(GIT_FOUND)

	# Retrieving GDevelop version from Git tags is disabled as GDevelop 5
	# is being developed and we still want the old IDE version to stay at 4.
	# The old IDE has the same version number as GDCore/libGD.js
	# Hence, version of GDevelop 4 is manually specified in CMakeLists.txt
	# EXECUTE_PROCESS(
    #    		COMMAND ${GIT_EXECUTABLE} describe --tags
    #    		OUTPUT_VARIABLE GD_VERSION_STR
    #    		RESULT_VARIABLE GIT_DESCRIBE_RESULT
    #    		ERROR_VARIABLE GIT_DESCRIBE_ERROR
    #    		OUTPUT_STRIP_TRAILING_WHITESPACE
	# )
	set(GD_VERSION_STR ${CMAKE_ARGV4})

	set(VERSIONPRIV_PATH "${CMAKE_ARGV3}/VersionPriv.h")
	set(ORIGINAL_CONTENT " ")

	if(EXISTS "${VERSIONPRIV_PATH}")
		file(READ "${VERSIONPRIV_PATH}" ORIGINAL_CONTENT)
	endif()

	if("${GD_VERSION_STR}" STREQUAL "")
		message(STATUS "No tags found to determine the version of GDevelop!")
		set(GD_VERSION_STR "0.0.0-0-unknown")
	endif()

	# Generate the version RC macro
	string(REGEX REPLACE
		"([0-9]*)\\.([0-9]*)\\.([0-9]*)-([0-9]*)-.*"
		"\\1,\\2,\\3,\\4"
		GD_VERSION_RC
		"${GD_VERSION_STR}")

	string(REGEX REPLACE
		"([0-9]*)\\.([0-9]*)\\.([0-9]*)-([0-9]*)-.*"
		"\\1, \\2, \\3, \\4"
		GD_VERSION_RC_STR
		"${GD_VERSION_STR}")

	set(NEW_CONTENT "#define GD_VERSION_STRING \"${GD_VERSION_STR}\"\n#define GD_VERSION_RC ${GD_VERSION_RC}\n#define GD_VERSION_RC_STRING \"${GD_VERSION_RC_STR}\\0\"\n#define GD_DATE_STRING __DATE__")

	if(NOT ("${ORIGINAL_CONTENT}" STREQUAL "${NEW_CONTENT}"))
		# Write only the version file if different from the previous one
		message(STATUS "Updating VersionPriv.h header to version ${GD_VERSION_STR}.")
		file(WRITE
			"${VERSIONPRIV_PATH}"
			"${NEW_CONTENT}")
	else()
		message(STATUS "VersionPriv.h already up-to-date.")
	endif()
else()
	file(WRITE
		"${VERSIONPRIV_PATH}"
	"#define GD_VERSION_STRING \"0.0.0-0-unknown\"\n#define GD_VERSION_RC 0, 0, 0, 0\n#define GD_VERSION_RC_STRING \"0, 0, 0, 0\\0\"\n#define GD_DATE_STRING __DATE__")
endif()
