/*!
 * @pixi/filter-drop-shadow - v3.1.1
 * Compiled Wed, 08 Apr 2020 11:09:37 UTC
 *
 * @pixi/filter-drop-shadow is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
var __filters=function(t,i,e,r,n,o){"use strict";var l="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n    vTextureCoord = aTextureCoord;\n}",s="varying vec2 vTextureCoord;\nuniform sampler2D uSampler;\nuniform float alpha;\nuniform vec3 color;\n\nuniform vec2 shift;\nuniform vec4 inputSize;\n\nvoid main(void){\n    vec4 sample = texture2D(uSampler, vTextureCoord - shift * inputSize.zw);\n\n    // Premultiply alpha\n    sample.rgb = color.rgb * sample.a;\n\n    // alpha user alpha\n    sample *= alpha;\n\n    gl_FragColor = sample;\n}",a=function(t){function e(e){e&&e.constructor!==Object&&(console.warn("DropShadowFilter now uses options instead of (rotation, distance, blur, color, alpha)"),e={rotation:e},void 0!==arguments[1]&&(e.distance=arguments[1]),void 0!==arguments[2]&&(e.blur=arguments[2]),void 0!==arguments[3]&&(e.color=arguments[3]),void 0!==arguments[4]&&(e.alpha=arguments[4])),e=Object.assign({rotation:45,distance:5,color:0,alpha:.5,shadowOnly:!1,kernels:null,blur:2,quality:3,pixelSize:1,resolution:r.settings.RESOLUTION},e),t.call(this);var o=e.kernels,a=e.blur,u=e.quality,c=e.pixelSize,h=e.resolution;this._tintFilter=new t(l,s),this._tintFilter.uniforms.color=new Float32Array(4),this._tintFilter.uniforms.shift=new n.Point,this._tintFilter.resolution=h,this._blurFilter=o?new i.KawaseBlurFilter(o):new i.KawaseBlurFilter(a,u),this.pixelSize=c,this.resolution=h;var p=e.shadowOnly,f=e.rotation,d=e.distance,_=e.alpha,b=e.color;this.shadowOnly=p,this.rotation=f,this.distance=d,this.alpha=_,this.color=b,this._updatePadding()}t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e;var a={resolution:{configurable:!0},distance:{configurable:!0},rotation:{configurable:!0},alpha:{configurable:!0},color:{configurable:!0},kernels:{configurable:!0},blur:{configurable:!0},quality:{configurable:!0},pixelSize:{configurable:!0}};return e.prototype.apply=function(t,i,e,r){var n=t.getFilterTexture();this._tintFilter.apply(t,i,n,1),this._blurFilter.apply(t,n,e,r),!0!==this.shadowOnly&&t.applyFilter(this,i,e,0),t.returnFilterTexture(n)},e.prototype._updatePadding=function(){this.padding=this.distance+2*this.blur},e.prototype._updateShift=function(){this._tintFilter.uniforms.shift.set(this.distance*Math.cos(this.angle),this.distance*Math.sin(this.angle))},a.resolution.get=function(){return this._resolution},a.resolution.set=function(t){this._resolution=t,this._tintFilter&&(this._tintFilter.resolution=t),this._blurFilter&&(this._blurFilter.resolution=t)},a.distance.get=function(){return this._distance},a.distance.set=function(t){this._distance=t,this._updatePadding(),this._updateShift()},a.rotation.get=function(){return this.angle/n.DEG_TO_RAD},a.rotation.set=function(t){this.angle=t*n.DEG_TO_RAD,this._updateShift()},a.alpha.get=function(){return this._tintFilter.uniforms.alpha},a.alpha.set=function(t){this._tintFilter.uniforms.alpha=t},a.color.get=function(){return o.rgb2hex(this._tintFilter.uniforms.color)},a.color.set=function(t){o.hex2rgb(t,this._tintFilter.uniforms.color)},a.kernels.get=function(){return this._blurFilter.kernels},a.kernels.set=function(t){this._blurFilter.kernels=t},a.blur.get=function(){return this._blurFilter.blur},a.blur.set=function(t){this._blurFilter.blur=t,this._updatePadding()},a.quality.get=function(){return this._blurFilter.quality},a.quality.set=function(t){this._blurFilter.quality=t},a.pixelSize.get=function(){return this._blurFilter.pixelSize},a.pixelSize.set=function(t){this._blurFilter.pixelSize=t},Object.defineProperties(e.prototype,a),e}(e.Filter);return t.DropShadowFilter=a,t}({},PIXI.filters,PIXI,PIXI,PIXI,PIXI.utils);Object.assign(PIXI.filters,__filters);
