/**
 * Copyright (c) 2016, The National Archives <pronom@nationalarchives.gsi.gov.uk>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following
 * conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of the The National Archives nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package uk.gov.nationalarchives.droid.report.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * @author Alok Kumar Dash Interface mandates required methods for reported
 *         field type
 */
public interface ReportFieldType {

    /**
     * Depending upon the type of the reported field i.e. Numeric, Date or
     * String/Set the aggregate function is applied to the select part of the
     * query string.
     * 
    * @param groupByFields
     *            A list of fields and functions to group by.
     * @return String The select query string (only the selecting fields part).
     */
    String getSelectFieldString(List<GroupByField> groupByFields);


    /**
     * This method populates report data.
     * 
     * @param results
     *            result set from database.
     * @return ReportData
     */
    List<ReportLineItem> populateReportedData(List<?> results);

    /**
     * Retrieve ReportLineItems from a ResultSet.
     * @param results ResultSet
     * @return a List of ReportLineItems
     * @throws SQLException SQL Exception
     */
    List<ReportLineItem> populateReportedData(ResultSet results) throws SQLException;

    /**
     * Returns field string to be used in the query. 
     * @return String the persistence field name 
     */
    String getField();

}
