#!/usr/bin/python
import difflib, struct

def linesplit(a):
    l = []
    last = 0
    n = a.find("\n") + 1
    while n > 0:
        l.append(a[last:n])
        last = n
        n = a.find("\n", n) + 1

    if last < len(a): l.append(a[last:])

    return l

def textdiff(a, b):
    return diff(linesplit(a), linesplit(b))

def diff(a, b):
    bin = []
    p = [0]
    for i in a: p.append(p[-1] + len(i))
        
    d = difflib.SequenceMatcher(None, a, b)
    for o, m, n, s, t in d.get_opcodes():
        if o == 'equal': continue
        s = "".join(b[s:t])
        bin.append(struct.pack(">lll", p[m], p[n], len(s)) + s)

    return "".join(bin)

def patch(a, bin):
    last = pos = 0
    r = []
    c = 0

    while pos < len(bin):
        p1, p2, l = struct.unpack(">lll", bin[pos:pos + 12])
        pos += 12
        r.append(a[last:p1])
        r.append(bin[pos:pos + l])
        pos += l
        last = p2
        c += 1

    r.append(a[last:])
    return "".join(r)





