/*************************************************
 * Copyright (c) 2015 Ansible, Inc.
 *
 * All Rights Reserved
 *************************************************/

export default ['Rest', 'Wait',
    'NotificationsFormObject', 'ProcessErrors', 'GetBasePath',
    'GenerateForm',
    'notification_template',
    '$scope', '$state', 'GetChoices', 'CreateSelect2', 'Empty',
    'NotificationsTypeChange', 'ParseTypeChange', 'i18n',
    function(
        Rest, Wait,
        NotificationsFormObject, ProcessErrors, GetBasePath,
        GenerateForm,
        notification_template,
        $scope, $state, GetChoices, CreateSelect2, Empty,
        NotificationsTypeChange, ParseTypeChange, i18n
    ) {
        var generator = GenerateForm,
            id = notification_template.id,
            form = NotificationsFormObject,
            master = {},
            url = GetBasePath('notification_templates');

        init();

        function init() {
            $scope.notification_template = notification_template;

            $scope.$watch('notification_template.summary_fields.user_capabilities.edit', function(val) {
                if (val === false) {
                    $scope.canAdd = false;
                }
            });

            GetChoices({
                scope: $scope,
                url: url,
                field: 'notification_type',
                variable: 'notification_type_options',
                callback: 'choicesReady'
            });
        }

        if ($scope.removeChoicesReady) {
            $scope.removeChoicesReady();
        }
        $scope.removeChoicesReady = $scope.$on('choicesReady', function() {
            var i;
            for (i = 0; i < $scope.notification_type_options.length; i++) {
                if ($scope.notification_type_options[i].value === '') {
                    $scope.notification_type_options[i].value = "manual";
                    break;
                }
            }

            Wait('start');
            Rest.setUrl(url + id + '/');
            Rest.get()
                .then(({data}) => {
                    var fld;
                    for (fld in form.fields) {
                        if (data[fld]) {
                            $scope[fld] = data[fld];
                            master[fld] = data[fld];
                        }

                        if(form.fields[fld].type === 'radio_group') {
                            if(data.notification_configuration.use_ssl === true){
                                $scope.email_options = "use_ssl";
                                master.email_options = "use_ssl";
                                $scope.use_ssl = true;
                                master.use_ssl = true;
                                $scope.use_tls = false;
                                master.use_tls = false;
                            }
                            if(data.notification_configuration.use_tls === true){
                                $scope.email_options = "use_tls";
                                master.email_options = "use_tls";
                                $scope.use_ssl = false;
                                master.use_ssl = false;
                                $scope.use_tls = true;
                                master.use_tls = true;
                            }
                        }
                        else {
                            if (data.notification_configuration[fld]) {
                                $scope[fld] = data.notification_configuration[fld];
                                master[fld] = data.notification_configuration[fld];

                                if (form.fields[fld].type === 'textarea') {
                                    if (form.fields[fld].name === 'headers') {
                                        $scope[fld] = JSON.stringify($scope[fld], null, 2);
                                    } else {
                                        $scope[fld] = $scope[fld].join('\n');
                                    }
                                }
                            }

                            if (form.fields[fld].sourceModel && data.summary_fields &&
                                data.summary_fields[form.fields[fld].sourceModel]) {
                                $scope[form.fields[fld].sourceModel + '_' + form.fields[fld].sourceField] =
                                    data.summary_fields[form.fields[fld].sourceModel][form.fields[fld].sourceField];
                                master[form.fields[fld].sourceModel + '_' + form.fields[fld].sourceField] =
                                    data.summary_fields[form.fields[fld].sourceModel][form.fields[fld].sourceField];
                            }
                        }
                    }
                    data.notification_type = (Empty(data.notification_type)) ? '' : data.notification_type;
                    for (var i = 0; i < $scope.notification_type_options.length; i++) {
                        if ($scope.notification_type_options[i].value === data.notification_type) {
                            $scope.notification_type = $scope.notification_type_options[i];
                            break;
                        }
                    }

                    master.notification_type = $scope.notification_type;
                    CreateSelect2({
                        element: '#notification_template_notification_type',
                        multiple: false
                    });

                    $scope.hipchatColors = [
                        {'id': 'gray', 'name': i18n._('Gray')},
                        {'id': 'green', 'name': i18n._('Green')},
                        {'id': 'purple', 'name': i18n._('Purple')},
                        {'id': 'red', 'name': i18n._('Red')},
                        {'id': 'yellow', 'name': i18n._('Yellow')},
                        {'id': 'random', 'name': i18n._('Random')}
                    ];
                    CreateSelect2({
                        element: '#notification_template_color',
                        multiple: false
                    });
                    NotificationsTypeChange.getDetailFields($scope.notification_type.value).forEach(function(field) {
                        $scope[field[0]] = field[1];
                    });
                    $scope.notification_obj = data;

                    $scope.parse_type = 'json';
                    if (!$scope.headers) {
                        $scope.headers = "{\n}";
                    }
                    ParseTypeChange({
                        scope: $scope,
                        parse_variable: 'parse_type',
                        variable: 'headers',
                        field_id: 'notification_template_headers',
                    });
                    Wait('stop');
                })
                .catch(({data, status}) => {
                    ProcessErrors($scope, data, status, form, {
                        hdr: 'Error!',
                        msg: 'Failed to retrieve notification: ' + id + '. GET status: ' + status
                    });
                });
        });



        $scope.$watch('headers', function validate_headers(str) {
            try {
                let headers = JSON.parse(str);
                if (_.isObject(headers) && !_.isArray(headers)) {
                    let valid = true;
                    for (let k in headers) {
                        if (_.isObject(headers[k])) {
                            valid = false;
                        }
                        if (headers[k] === null) {
                            valid = false;
                        }
                    }
                    $scope.notification_template_form.headers.$setValidity('json', valid);
                    return;
                }
            } catch (err) {}

            $scope.notification_template_form.headers.$setValidity('json', false);
        });

        $scope.typeChange = function() {
            for (var fld in form.fields) {
                if (form.fields[fld] && form.fields[fld].subForm) {
                    if (form.fields[fld].type === 'checkbox_group' && form.fields[fld].fields) {
                        // Need to loop across the groups fields to null them out
                        for (var i = 0; i < form.fields[fld].fields.length; i++) {
                            // Pull the name out of the object (array of objects)
                            var subFldName = form.fields[fld].fields[i].name;
                            $scope[subFldName] = null;
                            $scope.notification_template_form[subFldName].$setPristine();
                        }
                    } else {
                        $scope[fld] = null;
                        $scope.notification_template_form[fld].$setPristine();
                    }
                }
            }

            NotificationsTypeChange.getDetailFields($scope.notification_type.value).forEach(function(field) {
                $scope[field[0]] = field[1];
            });

            $scope.parse_type = 'json';
            if (!$scope.headers) {
                $scope.headers = "{\n}";
            }
            ParseTypeChange({
                scope: $scope,
                parse_variable: 'parse_type',
                variable: 'headers',
                field_id: 'notification_template_headers',
            });
        };

        $scope.emailOptionsChange = function () {
            if ($scope.email_options === 'use_ssl') {
                if ($scope.use_ssl) {
                    $scope.email_options = null;
                    $scope.use_ssl = false;
                    return;
                }

                $scope.use_ssl = true;
                $scope.use_tls = false;
            }
            else if ($scope.email_options === 'use_tls') {
                if ($scope.use_tls) {
                    $scope.email_options = null;
                    $scope.use_tls = false;
                    return;
                }

                $scope.use_ssl = false;
                $scope.use_tls = true;
            }
        };

        $scope.formSave = function() {
            var params,
                v = $scope.notification_type.value;

            generator.clearApiErrors($scope);
            params = {
                "name": $scope.name,
                "description": $scope.description,
                "organization": $scope.organization,
                "notification_type": v,
                "notification_configuration": {}
            };

            function processValue(value, i, field) {
                if (field.type === 'textarea') {
                    if (field.name === 'headers') {
                        $scope[i] = JSON.parse($scope[i]);
                    } else {
                        $scope[i] = $scope[i].toString().split('\n');
                    }
                }
                if (field.type === 'checkbox') {
                    $scope[i] = Boolean($scope[i]);
                }
                if (field.type === 'number') {
                    $scope[i] = Number($scope[i]);
                }
                if (i === "username" && $scope.notification_type.value === "email" && (value === null || value === undefined)) {
                    $scope[i] = "";
                }
                if (field.type === 'sensitive' && (value === null || value === undefined)) {
                    $scope[i] = "";
                }
                return $scope[i];
            }

            params.notification_configuration = _.fromPairs(Object.keys(form.fields)
                .filter(i => (form.fields[i].ngShow && form.fields[i].ngShow.indexOf(v) > -1))
                .map(i => [i, processValue($scope[i], i, form.fields[i])]));

                delete params.notification_configuration.email_options;

                params.notification_configuration.use_ssl = Boolean($scope.use_ssl);
                params.notification_configuration.use_tls = Boolean($scope.use_tls);

            Wait('start');
            Rest.setUrl(url + id + '/');
            Rest.put(params)
                .then(() => {
                    $state.go('notifications', {}, { reload: true });
                    Wait('stop');
                })
                .catch(({data, status}) => {
                    ProcessErrors($scope, data, status, form, {
                        hdr: 'Error!',
                        msg: 'Failed to add new notification template. POST returned status: ' + status
                    });
                });
        };


        $scope.formCancel = function() {
            $state.go('notifications');
        };

    }
];
